/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.silk.base.AbstractBaseElementCellProvider;
import com.sas.graphics.silk.base.LinePlotElement;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import java.awt.Insets;

public class DefaultSeriesCellProvider
extends AbstractBaseElementCellProvider {
    public SILKNumber X_ROLE = null;
    public SILKNumber Y_ROLE = null;
    private LinePlotElement[][] charts = null;

    public DefaultSeriesCellProvider() {
        Roles r = Roles.getInstance(null);
        this.X_ROLE = r.getRoleObject("ROLE_X");
        this.Y_ROLE = r.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.X_ROLE, "X", 99);
        this.roles.newRole((Object)this.Y_ROLE, "Y", 99);
    }

    @Override
    public Object getCellElement(int x, int y) {
        if (this.filter == null || x >= this.getNumberColumns() || y >= this.getNumberRows()) {
            return null;
        }
        if (this.charts == null) {
            this.charts = new LinePlotElement[this.getNumberColumns()][this.getNumberRows()];
        }
        if (this.charts[x][y] != null) {
            return this.charts[x][y];
        }
        Object xVariable = this.roles.getVariable((Object)this.X_ROLE, x);
        Object yVariable = this.roles.getVariable((Object)this.Y_ROLE, y);
        LinePlotElement se = new LinePlotElement();
        se.setDataSource(this.getDataSource());
        se.setBackBufferDrawEnabled(false);
        se.setRole(xVariable, RoleInterface.ROLE_X);
        se.setRole(yVariable, RoleInterface.ROLE_Y);
        se.setOuterMargin(new Insets(0, 0, 0, 0));
        se.setId(this.filter.getVariableDescription(yVariable));
        this.charts[x][y] = se;
        return se;
    }

    @Override
    public int getNumberRows() {
        return this.roles.getNumVariablesAssigned((Object)this.Y_ROLE);
    }

    @Override
    public int getNumberColumns() {
        return this.roles.getNumVariablesAssigned((Object)this.X_ROLE);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return new Object[]{this.X_ROLE, this.Y_ROLE};
    }
}

