/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementGridCellProvider;
import com.sas.graphics.silk.base.DefaultSeriesCellProvider;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class BaseElementGridTableModel
implements TableModel {
    private BaseElement[][] values = null;
    private BaseElementGridCellProvider cellProvider = new DefaultSeriesCellProvider();

    private void init() {
        this.values = new BaseElement[this.cellProvider.getNumberColumns()][this.cellProvider.getNumberRows()];
        for (int i = 0; i < this.values.length; ++i) {
            for (int j = 0; j < this.values[i].length; ++j) {
                Object o = this.cellProvider.getCellElement(i, j);
                if (!(o instanceof BaseElement)) continue;
                this.values[i][j] = (BaseElement)o;
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.cellProvider.getNumberColumns();
    }

    @Override
    public int getRowCount() {
        return this.cellProvider.getNumberRows();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Class getColumnClass(int columnIndex) {
        return BaseElement.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.values == null || this.getColumnCount() <= columnIndex || this.getRowCount() <= rowIndex) {
            return null;
        }
        return this.values[columnIndex][rowIndex];
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public String getColumnName(int columnIndex) {
        return null;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public BaseElementGridCellProvider getCellProvider() {
        return this.cellProvider;
    }

    public void setCellProvider(BaseElementGridCellProvider cellProvider) {
        if (cellProvider != null) {
            this.cellProvider = cellProvider;
            this.init();
        }
    }
}

