/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.info.RoleAssigner;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.ui.graphwizard.SILKWizardEntry;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.SILKChartFlavor;
import com.sas.graphics.tools.wizard.WizardEntry;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;

public class BaseElementContainer
extends JComponent
implements LayerListenerInterface,
DropTargetListener {
    private static final long serialVersionUID = -7872174914349116086L;
    protected Vector charts = new Vector();
    protected int compWidth = 0;
    protected int compHeight = 0;
    private Image backBuffer = null;
    protected Insets margin = new Insets(5, 5, 5, 5);

    public BaseElementContainer() {
        new DropTarget(this, this);
    }

    public BaseElementContainer(BaseElement element) {
        this();
        this.addChart(element);
    }

    public void addChart(BaseElement element) {
        if (element == null || this.charts.contains(element)) {
            return;
        }
        this.charts.addElement(element);
        element.setBounds(this.getBounds());
        element.addLayerListener(this);
        element.addMarginListener(new MarginListener(){

            public void marginChanged(MarginChangeEvent e) {
                BaseElementContainer.this.mergeMargins();
                BaseElementContainer.this.doResize(BaseElementContainer.this.getWidth(), BaseElementContainer.this.getHeight());
            }
        });
        this.mergeRanges();
        this.mergeMargins();
    }

    protected void mergeMargins() {
        Enumeration e = this.charts.elements();
        while (e.hasMoreElements()) {
            BaseElement chart = (BaseElement)e.nextElement();
            Insets i = chart.getPreferredInnerMargin();
            this.margin.bottom = Math.max(this.margin.bottom, i.bottom);
            this.margin.top = Math.max(this.margin.top, i.top);
            this.margin.left = Math.max(this.margin.left, i.left);
            this.margin.right = Math.max(this.margin.right, i.right);
        }
    }

    private void mergeRanges() {
        BaseElement chart;
        Enumeration e = this.charts.elements();
        DataRange x = null;
        DataRange y = null;
        while (e.hasMoreElements()) {
            chart = (BaseElement)e.nextElement();
            x = BaseElementContainer.mergeRange(x, chart.getPreferredRange(chart.getPropertyValue(19057)));
            y = BaseElementContainer.mergeRange(y, chart.getPreferredRange(chart.getPropertyValue(19056)));
        }
        e = this.charts.elements();
        while (e.hasMoreElements()) {
            chart = (BaseElement)e.nextElement();
            chart.setDataRange((byte)1, 0, x);
            chart.setDataRange((byte)2, 0, y);
        }
    }

    protected static DataRange mergeRange(DataRange range1, DataRange range2) {
        DiscreteRange mergedRange = null;
        if (range1 == null) {
            return range2;
        }
        if (range2 == null) {
            return range1;
        }
        if (range1 instanceof DiscreteRange && range2 instanceof DiscreteRange) {
            mergedRange = new DiscreteRange();
            mergedRange.union(range1);
            mergedRange.union(range2);
        } else if (range1 instanceof ContinuousRange && range2 instanceof ContinuousRange) {
            ContinuousRange r1 = (ContinuousRange)range1;
            ContinuousRange r2 = (ContinuousRange)range2;
            mergedRange = new ContinuousRange(Math.min(r1.getMin(), r2.getMin()), Math.max(r1.getMax(), r2.getMax()));
        }
        return mergedRange;
    }

    protected Rectangle getChartArea() {
        return new Rectangle(this.margin.left, this.margin.top, this.getWidth() - this.margin.left - this.margin.right, this.getHeight() - this.margin.bottom - this.margin.top);
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = new BufferedImage(this.compWidth, this.compHeight, 2);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setTransformObject(((BaseElement)this.charts.elementAt(i)).getDefaultTransformObject());
            ((BaseElement)this.charts.elementAt(i)).draw(g, false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.buildBackBuffer();
        }
        g.drawImage(this.backBuffer, 0, 0, null);
        for (int i = 0; i < this.charts.size(); ++i) {
            BaseElement chart = (BaseElement)this.charts.elementAt(i);
            if (chart.selections != null) {
                chart.selections.reset();
            }
            chart.drawSelected(g);
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doResize(width, height);
    }

    protected void doResize(int compWidthIn, int compHeightIn) {
        if (compWidthIn == this.compWidth && compHeightIn == this.compHeight) {
            return;
        }
        this.compWidth = compWidthIn;
        this.compHeight = compHeightIn;
        this.backBuffer = null;
        for (int i = 0; i < this.charts.size(); ++i) {
            ((BaseElement)this.charts.elementAt(i)).setBounds(this.margin.left, this.margin.top, this.compWidth - this.margin.left - this.margin.right, this.compHeight - this.margin.top - this.margin.bottom);
            ((BaseElement)this.charts.elementAt(i)).setComponentSize(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void layerChanged(LayerChangedEvent lce) {
        this.repaint();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(SILKChartFlavor.silkChartFlavor)) {
                SILKWizardEntry swe;
                BaseElement be;
                dropTargetDropEvent.acceptDrop(3);
                WizardEntry entry = (WizardEntry)tr.getTransferData(SILKChartFlavor.silkChartFlavor);
                if (entry instanceof SILKWizardEntry && (be = (swe = (SILKWizardEntry)entry).getBaseElement()) != null) {
                    swe.getChartInfo().assignDataSource(be, entry.getDataSource());
                    swe.getChartInfo().doXMLInit(be);
                    RoleAssigner ra = new RoleAssigner(FilterFactory.getDataSourceFilter((Object)entry.getDataSource()), swe.getChartInfo());
                    ra.doRoleAssignments(be);
                    this.addChart(be);
                }
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

