/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.heatmap.HeatmapParmObject;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.HeatmapElementPropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToNumberMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;

public abstract class AbstractHeatmapElement
extends BaseElement
implements HeatmapElementPropertyInterface {
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber colorRole = null;
    protected boolean rebuildRequired = false;
    protected boolean isBuilding = false;
    protected Variable xGTKVariable;
    protected Variable yGTKVariable;
    protected Variable colorGTKVariable;
    protected HeatmapParmObject heatmap = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber groupIndexRole = null;
    protected Variable groupGTKVariable;
    protected Variable groupIndexGTKVariable;
    protected LinkedHashMap groupColorMap = null;
    protected HashMap<Object, Number> groupIndexMap = null;
    protected CharacterVariableMapper yCharacterVariableMapper;
    protected CharacterVariableMapper xCharacterVariableMapper;
    protected int currentChickletWidth = 0;
    protected int currentChickletHeight = 0;
    protected final int INNER_MARGIN_GAP = 3;
    protected SILKNumber currentLegend = null;
    protected static final int ADD_SORTABLE_ROLE = 1;
    protected static final int REMOVE_SORTABLE_ROLE = 2;
    protected Vector<SILKNumber> sortableRoles = null;
    protected LinkedHashMap groupValueIndexMap = null;
    protected int[] sortableDirections = new int[]{1, 0, -1};
    protected boolean useDataRangeX = true;
    protected boolean useDataRangeY = true;

    protected void initRoles() {
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.roles.setSortsSupported((Object)this.xRole, this.sortableDirections);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.roles.setSortsSupported((Object)this.yRole, this.sortableDirections);
        this.colorRole = this.role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, "Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.groupIndexRole = this.role.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.setSupportedSortRoles(new Object[][]{{this.xRole}, {this.yRole}});
        this.sortableRoles = new Vector();
        this.sortableRoles.add(this.xRole);
        this.sortableRoles.add(this.yRole);
    }

    protected void initHeatmapObject() {
        this.heatmap = new HeatmapParmObject();
        this.heatmap.setShowOutline(true);
        this.heatmap.setChannel(new Channel((Component)new Container(), 2));
        this.heatmap.setXEndLabels(true);
        this.heatmap.setYEndLabels(true);
    }

    protected boolean connectNetwork() {
        if (!this.rebuildRequired || this.isBuilding) {
            return false;
        }
        if (this.bounds.width <= 0 || this.bounds.height <= 0) {
            return false;
        }
        this.isBuilding = true;
        double xOutMin = this.innerMargin.left;
        double xOutMax = this.bounds.width - this.innerMargin.right;
        NumericMap xmap = this.buildNumericMap((byte)1, this.xGTKVariable, this.xDataRange, this.xRole, xOutMin, xOutMax);
        double yOutMin = this.bounds.height - this.innerMargin.bottom;
        double yOutMax = this.innerMargin.top;
        NumericMap ymap = this.buildNumericMap((byte)2, this.yGTKVariable, this.yDataRange, this.yRole, yOutMin, yOutMax);
        if (xmap == null || ymap == null) {
            this.isBuilding = false;
            return false;
        }
        ColorMap colormap = this.buildColorMap();
        if (xmap == null || ymap == null || !this.heatmap.connectNetwork(xmap, ymap, colormap, null, null, null)) {
            this.isBuilding = false;
            return false;
        }
        this.rebuildRequired = false;
        this.isBuilding = false;
        this.updateInnerMargin();
        this.setViewport();
        this.setProjection();
        return true;
    }

    protected NumericMap buildNumericMap(byte dimension, Variable gtkVariable, DataRange range, SILKNumber role, double outMin, double outMax) {
        DataRange outputRange = this.getOutputRange(dimension);
        if (outputRange == null || gtkVariable == null || !gtkVariable.isConnected()) {
            return null;
        }
        if (gtkVariable instanceof StringVariable) {
            int i;
            CharacterVariableMapper cvm = null;
            switch (dimension) {
                case 1: {
                    Vector values;
                    DiscreteRange dr;
                    if (range instanceof DiscreteRange) {
                        dr = (DiscreteRange)range;
                        if (this.xCharacterVariableMapper == null) {
                            this.xCharacterVariableMapper = new CharacterVariableMapper();
                        } else {
                            this.xCharacterVariableMapper.removeAllValues();
                        }
                        values = dr.getValues();
                        if (values != null) {
                            for (i = 0; i < values.size(); ++i) {
                                this.xCharacterVariableMapper.addValue(values.elementAt(i));
                            }
                        }
                    } else if (this.xCharacterVariableMapper == null) {
                        this.xCharacterVariableMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)role, 0));
                    } else {
                        this.xCharacterVariableMapper.removeAllValues();
                        this.xCharacterVariableMapper.setVariable(this.roles.getVariable((Object)role, 0));
                    }
                    cvm = this.xCharacterVariableMapper;
                    break;
                }
                case 2: {
                    Vector values;
                    DiscreteRange dr;
                    if (range instanceof DiscreteRange) {
                        dr = (DiscreteRange)range;
                        if (this.yCharacterVariableMapper == null) {
                            this.yCharacterVariableMapper = new CharacterVariableMapper();
                        } else {
                            this.yCharacterVariableMapper.removeAllValues();
                        }
                        values = dr.getValues();
                        if (values != null) {
                            for (i = 0; i < values.size(); ++i) {
                                this.yCharacterVariableMapper.addValue(values.elementAt(i));
                            }
                        }
                    } else if (this.yCharacterVariableMapper == null) {
                        this.yCharacterVariableMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)role, 0));
                    } else {
                        this.yCharacterVariableMapper.removeAllValues();
                        this.yCharacterVariableMapper.setVariable(this.roles.getVariable((Object)role, 0));
                    }
                    cvm = this.yCharacterVariableMapper;
                    break;
                }
                default: {
                    return null;
                }
            }
            if (this.roles.getSortOrder((Object)role) != null) {
                cvm.setSort((Integer)this.roles.getSortOrder((Object)role));
            }
            int numberOfValues = cvm.getNumberValues();
            String[] stringArray = new String[numberOfValues];
            for (i = numberOfValues - 1; i >= 0; --i) {
                stringArray[i] = cvm.getValue(i).toString();
            }
            StringVectorVariable allAxisValuesVariable = new StringVectorVariable();
            allAxisValuesVariable.connectFrom(stringArray);
            allAxisValuesVariable.setBlankMissing(false);
            StringToNumberMap map = new StringToNumberMap();
            map.setLabelMissingValues(true);
            double[] proj = new double[3];
            double end = 1.0;
            if (numberOfValues == 1) {
                end = 0.0;
            }
            double chickletWidth = this.getScreenSpacing(dimension, 0.0, end);
            int varIndex = -1;
            switch (dimension) {
                case 1: {
                    this.heatmap.setDiscreteChickletXWidth(chickletWidth);
                    varIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
                    break;
                }
                case 2: {
                    this.heatmap.setDiscreteChickletYWidth(chickletWidth);
                    varIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
                }
            }
            for (int i2 = numberOfValues - 1; i2 >= 0; --i2) {
                double x = 0.0;
                double y = 0.0;
                switch (dimension) {
                    case 1: {
                        x = i2;
                        if (!this.transformObject.isReverse(0)) break;
                        x = numberOfValues - 1 - i2;
                        break;
                    }
                    case 2: {
                        y = i2;
                        if (!this.transformObject.isReverse(1)) break;
                        y = numberOfValues - 1 - i2;
                    }
                }
                this.transformObject.project(x, y, -1.0, proj);
                double val = 0.0;
                switch (dimension) {
                    case 1: {
                        val = proj[0] - (double)this.bounds.x;
                        break;
                    }
                    case 2: {
                        val = proj[1] - (double)this.bounds.y;
                    }
                }
                if (this.filter.isMissing(varIndex, (Object)stringArray[i2])) {
                    map.setMissingReplacement(val);
                    continue;
                }
                map.add(stringArray[i2], (Number)val);
            }
            map.addStringPipe(allAxisValuesVariable.value);
            return map;
        }
        if (gtkVariable instanceof NumericVariable && range instanceof ContinuousRange) {
            double inMax;
            ContinuousRangeToNumericMap map = new ContinuousRangeToNumericMap();
            ContinuousRange cr = null;
            boolean useDataRange = dimension == 2 ? this.useDataRangeY : this.useDataRangeX;
            cr = useDataRange ? (ContinuousRange)range : (ContinuousRange)outputRange;
            double inMin = cr.getMin();
            if (inMin == (inMax = cr.getMax())) {
                inMin -= 0.5;
                inMax += 0.5;
                double outCenter = (outMin + outMax) / 2.0;
                double ss = this.getScreenSpacing(dimension, 0.0, 0.0);
                outMin = outCenter - ss / 2.0;
                outMax = outCenter + ss / 2.0;
            }
            map.setInputMin(inMin);
            map.setInputMax(inMax);
            map.setOutputMin(outMin);
            map.setOutputMax(outMax);
            return map;
        }
        return null;
    }

    protected ColorMap buildColorMap() {
        ColorMap map = null;
        if (this.isRoleSet((Object)this.groupRole)) {
            map = this.buildGroupMap();
        } else if (this.isContinuousColorMapping()) {
            this.initColorRamp();
            map = new ContinuousRangeToColorMap();
            ContinuousRangeToColorMap cMap = (ContinuousRangeToColorMap)map;
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            if (r == null) {
                return null;
            }
            cMap.setInputMin(r.getMin());
            cMap.setInputMax(r.getMax());
            double neutralValue = (r.getMin() + r.getMax()) / 2.0;
            cMap.setColorSpectrumColors(new Color[]{this.colorMapper.getColor(r.getMin()), this.colorMapper.getColor(neutralValue), this.colorMapper.getColor(r.getMax())});
            cMap.setColorSpectrumValues(new double[]{r.getMin(), neutralValue, r.getMax()});
            cMap.setReplaceMissingValues(true);
            cMap.setMissingReplacement(this.colorMapper.getMissingColor());
        }
        return map;
    }

    protected abstract boolean isContinuousColorMapping();

    protected ColorMap buildGroupMap() {
        if (this.groupGTKVariable == null || !this.groupGTKVariable.isConnected()) {
            return null;
        }
        if (this.groupColorMap == null) {
            this.groupColorMap = new LinkedHashMap();
            this.groupValueIndexMap = new LinkedHashMap();
        } else {
            this.groupColorMap.clear();
            this.groupValueIndexMap.clear();
        }
        int numValues = this.groupGTKVariable.getUniqueValueCount();
        Vector<String> groupValues = new Vector<String>(numValues);
        this.groupGTKVariable.init();
        for (int i = 0; i < numValues; ++i) {
            try {
                String group = this.groupGTKVariable.formattedUniqueValue.getValue(i);
                if (this.groupGTKVariable instanceof StringVariable) {
                    this.groupValueIndexMap.put(group, ((StringVariable)this.groupGTKVariable).getFirstOccurringValueIndex(i));
                } else if (this.groupGTKVariable instanceof NumericVariable) {
                    this.groupValueIndexMap.put(group, ((NumericVariable)this.groupGTKVariable).getFirstOccurringValueIndex(i));
                }
                groupValues.addElement(group);
                continue;
            }
            catch (MissingValueException e) {
                if (this.groupGTKVariable instanceof NumericVariable) {
                    groupValues.addElement(".");
                    this.groupValueIndexMap.put(".", ((NumericVariable)this.groupGTKVariable).getFirstOccurringValueIndex(i));
                    continue;
                }
                groupValues.addElement("");
            }
        }
        if (groupValues.size() == 0) {
            return null;
        }
        FillStyleElement missingFSE = this.style.getFillStyleElement("Missing");
        StringToColorMap cMap = new StringToColorMap();
        cMap.setReplaceMissingValues(true);
        for (int i = 0; i < groupValues.size(); ++i) {
            Object group = groupValues.elementAt(i);
            if (group == null) continue;
            int groupIndex = this.getGroupIndex(group);
            if (groupIndex >= 0) {
                DataStyleElement dse = this.style.getDataStyleElement(groupIndex);
                cMap.add(group.toString(), dse.getFillColor());
                this.groupColorMap.put(group.toString(), dse.getFillColor());
                continue;
            }
            cMap.setMissingReplacement(missingFSE.getFillColor());
            this.groupColorMap.put(group.toString(), missingFSE.getFillColor());
        }
        return cMap;
    }

    protected int getGroupIndex(Object value) {
        if (this.groupIndexMap == null) {
            Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
            if (groupVar == null) {
                return -1;
            }
            this.buildGroupIndexMap();
        }
        if (this.groupIndexMap == null || value == null) {
            return -1;
        }
        Number o = this.groupIndexMap.get(value);
        if (o instanceof Number) {
            return o.intValue();
        }
        return -1;
    }

    protected void buildGroupIndexMap() {
        if (this.filter == null || this.roles == null) {
            return;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object groupIndexVar = this.roles.getVariable((Object)this.groupIndexRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int groupIndexVarIndex = this.filter.getVariableIndex(groupIndexVar);
        if (groupVarIndex < 0 || groupVar == null) {
            return;
        }
        if (this.groupIndexMap == null) {
            this.groupIndexMap = new HashMap();
        } else {
            this.groupIndexMap.clear();
        }
        int numValues = this.groupGTKVariable.getUniqueValueCount();
        this.groupGTKVariable.init();
        int gIndex = 0;
        for (int i = 0; i < numValues; ++i) {
            try {
                String group = this.groupGTKVariable.formattedUniqueValue.getValue(i);
                int firstIndex = -1;
                if (this.groupGTKVariable instanceof NumericVariable) {
                    firstIndex = ((NumericVariable)this.groupGTKVariable).getFirstOccurringValueIndex(i);
                } else if (this.groupGTKVariable instanceof StringVariable) {
                    firstIndex = ((StringVariable)this.groupGTKVariable).getFirstOccurringValueIndex(i);
                }
                if (firstIndex >= 0 && groupIndexVarIndex >= 0) {
                    double gi = this.filter.getNumericValue(groupIndexVarIndex, (long)firstIndex);
                    if (!(gi >= 0.0)) continue;
                    this.groupIndexMap.put(group, new Double(gi));
                    continue;
                }
                this.groupIndexMap.put(group, new Integer(gIndex));
                ++gIndex;
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    protected void setProjection() {
        Channel channel = this.heatmap.getChannel();
        if (channel != null && !this.bounds.isEmpty() && this.xGTKVariable != null && this.yGTKVariable != null && this.xGTKVariable.isConnected() && this.yGTKVariable.isConnected()) {
            double t;
            DataRange xrange = this.getOutputRange((byte)1);
            DataRange yrange = this.getOutputRange((byte)2);
            if (xrange == null || yrange == null) {
                return;
            }
            double left = 0.0;
            double right = this.bounds.width;
            double bottom = this.bounds.height;
            double top = 0.0;
            if (this.transformObject.isReverse(this.getXAxisMapping())) {
                t = left;
                left = right;
                right = t;
            }
            if (this.transformObject.isReverse(this.getYAxisMapping())) {
                t = bottom;
                bottom = top;
                top = t;
            }
            channel.glOrtho(left, right, bottom, top, -1.0, -1.0);
        }
    }

    protected void setViewport() {
        Channel channel = this.heatmap.getChannel();
        if (channel == null || this.bounds.isEmpty()) {
            return;
        }
        channel.glViewport(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
    }

    protected void updateInnerMargin() {
        if (this.xGTKVariable == null || this.yGTKVariable == null || !this.xGTKVariable.isConnected() || !this.yGTKVariable.isConnected()) {
            return;
        }
        if (this.xGTKVariable.getUniqueValueCount() == 0 || this.yGTKVariable.getUniqueValueCount() == 0) {
            return;
        }
        int numXValues = this.xGTKVariable.getUniqueValueCount();
        if (this.xDataRange instanceof DiscreteRange) {
            numXValues = ((DiscreteRange)this.xDataRange).getValuesSize();
        }
        int numYValues = this.yGTKVariable.getUniqueValueCount();
        if (this.yDataRange instanceof DiscreteRange) {
            numYValues = ((DiscreteRange)this.yDataRange).getValuesSize();
        }
        int chickletWTemp = (int)(this.bounds.getMaxX() - this.bounds.getMinX()) / numXValues + 3 + 3;
        int chickletHTemp = (int)(this.bounds.getMaxY() - this.bounds.getMinY()) / numYValues + 3 + 3;
        boolean needToFireMarginChangedEvent = false;
        if (chickletWTemp != this.currentChickletWidth && chickletWTemp > 0) {
            this.currentChickletWidth = chickletWTemp;
            needToFireMarginChangedEvent = true;
        }
        if (chickletHTemp != this.currentChickletHeight && chickletWTemp > 0) {
            this.currentChickletHeight = chickletHTemp;
            needToFireMarginChangedEvent = true;
        }
        if (needToFireMarginChangedEvent) {
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
        }
    }

    protected void sortRole(RoleEvent e) {
        if (this.filter == null) {
            return;
        }
        int sortOrder = 0;
        Object o = null;
        switch (e.role) {
            case 24: {
                o = this.roles.getSortOrder((Object)this.xRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.xCharacterVariableMapper != null && this.xCharacterVariableMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.xRole, this.xCharacterVariableMapper, sortOrder);
                break;
            }
            case 25: {
                o = this.roles.getSortOrder((Object)this.yRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.yCharacterVariableMapper != null && this.yCharacterVariableMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.yRole, this.yCharacterVariableMapper, sortOrder);
            }
        }
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(3);
    }

    protected void setSortOrderToCharMapper(SILKNumber role, CharacterVariableMapper charMapper, int sortOrder) {
        if (this.filter == null) {
            return;
        }
        if (this.filter.isNumericVariable(this.roles.getVariable((Object)role, 0))) {
            return;
        }
        if (charMapper == null) {
            return;
        }
        charMapper.setSort(sortOrder);
    }

    protected void processSubset() {
        Object subsetList = this.filter.getSubsetList();
        if (subsetList instanceof int[]) {
            int[] nArray = (int[])subsetList;
        } else if (subsetList == null) {
            // empty if block
        }
        if (this.xGTKVariable != null) {
            this.xGTKVariable.setModified(true);
        }
        if (this.yGTKVariable != null) {
            this.yGTKVariable.setModified(true);
        }
        if (this.groupGTKVariable != null) {
            this.groupGTKVariable.setModified(true);
        }
        if (this.groupIndexGTKVariable != null) {
            this.groupIndexGTKVariable.setModified(true);
        }
        if (this.colorGTKVariable != null) {
            this.colorGTKVariable.setModified(true);
        }
        this.groupIndexMap = null;
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                this.processSubset();
            }
        }
        super.dataFilterChanged(evt);
    }

    protected abstract Object getLegendEntries(SILKNumber var1);

    protected abstract boolean isContinuousLegend(SILKNumber var1);

    protected abstract Object getLegendTitle(SILKNumber var1);

    protected boolean isLegendValid(SILKNumber role) {
        if (role == null) {
            return false;
        }
        Object o = null;
        o = this.getLegendEntries(role);
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.isRebuildRequired() && !this.connectNetwork()) {
            return;
        }
        this.heatmap.getChannel().setSingleBufferGraphics(g);
        this.heatmap.draw();
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 333636: {
                return this.heatmap.showOutline();
            }
            case 333643: {
                return this.getXGap();
            }
            case 333644: {
                return this.getYGap();
            }
            case 333650: {
                return this.isXBinAxis();
            }
            case 333651: {
                return this.isYBinAxis();
            }
            case 333654: {
                return this.isXEndLabels();
            }
            case 333655: {
                return this.isYEndLabels();
            }
            case 333659: {
                return this.xGTKVariable instanceof NumericVariable;
            }
            case 333660: {
                return this.yGTKVariable instanceof NumericVariable;
            }
            case 19064: 
            case 19065: {
                rc = Boolean.TRUE;
                break;
            }
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                    break;
                }
                if (this.groupRole.toString().equalsIgnoreCase(this.currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(this.currentLegend.getEnglishName())) {
                    rc = this.roles.getVariable((Object)this.groupRole, 0);
                    break;
                }
                if (!this.colorRole.toString().equalsIgnoreCase(this.currentLegend.toString()) && !this.colorRole.getEnglishName().equalsIgnoreCase(this.colorRole.getEnglishName())) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid(this.groupRole)) {
                    legNames.add(this.groupRole);
                } else if (this.isLegendValid(this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 444: {
                rc = null;
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
            }
        }
        return rc != null ? rc : super.getPropertyValue(id);
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.groupRole.toString()) && !leg.equalsIgnoreCase(this.groupRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.toString())) break;
                if (value instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)((Object)value);
                }
                return true;
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 333636: {
                if (value instanceof Boolean) {
                    this.heatmap.setShowOutline(((Boolean)value).booleanValue());
                }
                this.rebuildRequired = true;
                this.heatmap.setReconnectRequired(true);
                break;
            }
            case 333643: {
                if (!(value instanceof Number)) break;
                this.setXGap(((Number)value).doubleValue());
                break;
            }
            case 333644: {
                if (!(value instanceof Number)) break;
                this.setYGap(((Number)value).doubleValue());
                break;
            }
            case 333650: {
                if (!(value instanceof Boolean)) break;
                this.setXBinAxis((Boolean)value);
                break;
            }
            case 333651: {
                if (!(value instanceof Boolean)) break;
                this.setYBinAxis((Boolean)value);
                break;
            }
            case 333654: {
                if (!(value instanceof Boolean)) break;
                this.setXEndLabels((Boolean)value);
                break;
            }
            case 333655: {
                if (!(value instanceof Boolean)) break;
                this.setYEndLabels((Boolean)value);
                break;
            }
            case 53: {
                super.applyChange(key, value);
                this.rebuildRequired = true;
                this.heatmap.setReconnectRequired(true);
                break;
            }
            default: {
                super.applyChange(key, value);
                return;
            }
        }
        this.userSetProperties.set(key);
    }

    public double getXGap() {
        return this.heatmap.getXGap();
    }

    public double getYGap() {
        return this.heatmap.getYGap();
    }

    public void setXGap(double gap) {
        this.heatmap.setXGap(gap);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
    }

    public void setYGap(double gap) {
        this.heatmap.setYGap(gap);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
    }

    public boolean isXBinAxis() {
        return this.heatmap.isXBinAxis();
    }

    public boolean isYBinAxis() {
        return this.heatmap.isYBinAxis();
    }

    public void setXBinAxis(boolean binAxis) {
        this.heatmap.setXBinAxis(binAxis);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public void setYBinAxis(boolean binAxis) {
        this.heatmap.setYBinAxis(binAxis);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public void setXEndLabels(boolean endLabels) {
        this.heatmap.setXEndLabels(endLabels);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public void setYEndLabels(boolean endLabels) {
        this.heatmap.setYEndLabels(endLabels);
        this.fireLayerListenerChanged(5);
        this.fireLayerListenerChanged(8);
        this.fireLayerListenerChanged(5);
    }

    public boolean isXEndLabels() {
        return this.heatmap.isXEndLabels();
    }

    public boolean isYEndLabels() {
        return this.heatmap.isYEndLabels();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.rebuildRequired = true;
        this.heatmap.setReconnectRequired(true);
        this.updateInnerMargin();
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc) {
            this.applyStyleElement();
        }
        return rc;
    }

    public void applyStyleElement() {
        if (this.heatmap != null && !this.rebuildRequired) {
            this.rebuildRequired = true;
            this.heatmap.setReconnectRequired(true);
        }
    }

    public double[] getXBoundaries() {
        return this.heatmap.getXBoundaries();
    }

    public void setXBoundaries(double[] boundaries) {
        this.heatmap.setXBoundaries(boundaries);
    }

    public double[] getYBoundaries() {
        return this.heatmap.getYBoundaries();
    }

    public void setYBoundaries(double[] boundaries) {
        this.heatmap.setYBoundaries(boundaries);
    }

    protected abstract DataRange adjustRange(DataRange var1, int var2, boolean var3, boolean var4, double var5, double[] var7);

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        Object range = null;
        while (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
            if (role == null) continue;
            DataRange rc = null;
            if (RoleInterface.ROLE_X.equals(role)) {
                rc = this.adjustRange(super.getPreferredRange(which), this.heatmap.getXValues(), this.heatmap.isXBinAxis(), this.heatmap.isXEndLabels(), this.heatmap.getXStep(), this.heatmap.getXBoundaries());
            } else if (RoleInterface.ROLE_Y.equals(role)) {
                rc = this.adjustRange(super.getPreferredRange(which), this.heatmap.getYValues(), this.heatmap.isYBinAxis(), this.heatmap.isYEndLabels(), this.heatmap.getYStep(), this.heatmap.getYBoundaries());
            }
            return rc;
        }
        return super.getPreferredRange(which);
    }

    @Override
    public Insets getPreferredInnerMargin() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.xGTKVariable instanceof StringVariable) {
            insets.left = insets.right = (int)((double)(this.currentChickletWidth / 2) - 0.5);
        }
        if (this.yGTKVariable instanceof StringVariable) {
            insets.bottom = insets.top = (int)((double)(this.currentChickletHeight / 2) - 0.5);
        }
        return insets;
    }

    protected void updateSortableRoles(SILKNumber role, int action) {
        if (role == null || this.sortableRoles == null) {
            return;
        }
        switch (action) {
            case 1: {
                if (this.sortableRoles.contains((Object)role)) {
                    return;
                }
                this.sortableRoles.add(role);
                break;
            }
            case 2: {
                this.sortableRoles.remove((Object)role);
            }
        }
        Object[][] sortRoles = null;
        if (this.sortableRoles.size() > 0) {
            sortRoles = new Object[this.sortableRoles.size()][];
            for (int i = 0; i < this.sortableRoles.size(); ++i) {
                sortRoles[i] = new Object[]{this.sortableRoles.elementAt(i)};
            }
        }
        this.roles.setSupportedSortRoles(sortRoles);
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.xRole = null;
        this.yRole = null;
        this.colorRole = null;
        if (this.xGTKVariable != null) {
            this.xGTKVariable.disconnect();
        }
        this.xGTKVariable = null;
        if (this.yGTKVariable != null) {
            this.yGTKVariable.disconnect();
        }
        this.yGTKVariable = null;
        if (this.colorGTKVariable != null) {
            this.colorGTKVariable.disconnect();
        }
        this.colorGTKVariable = null;
        this.heatmap = null;
        this.groupRole = null;
        this.groupIndexRole = null;
        if (this.groupGTKVariable != null) {
            this.groupGTKVariable.disconnect();
        }
        this.groupGTKVariable = null;
        if (this.groupIndexGTKVariable != null) {
            this.groupIndexGTKVariable.disconnect();
        }
        this.groupIndexGTKVariable = null;
        if (this.groupColorMap != null) {
            this.groupColorMap.clear();
        }
        this.groupColorMap = null;
        if (this.groupIndexMap != null) {
            this.groupIndexMap.clear();
        }
        this.groupIndexMap = null;
        if (this.xCharacterVariableMapper != null) {
            this.xCharacterVariableMapper.setVariable(null);
        }
        this.xCharacterVariableMapper = null;
        if (this.yCharacterVariableMapper != null) {
            this.yCharacterVariableMapper.setVariable(null);
        }
        this.yCharacterVariableMapper = null;
        this.currentLegend = null;
        if (this.sortableRoles != null) {
            this.sortableRoles.clear();
        }
        this.sortableRoles = null;
        if (this.groupValueIndexMap != null) {
            this.groupValueIndexMap.clear();
        }
        this.groupValueIndexMap = null;
        if (this.xCharacterVariableMapper != null) {
            this.xCharacterVariableMapper.dispose();
            this.xCharacterVariableMapper = null;
        }
        if (this.yCharacterVariableMapper != null) {
            this.yCharacterVariableMapper.dispose();
            this.yCharacterVariableMapper = null;
        }
    }
}

