/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public abstract class AbstractBarElement
extends BaseElement {
    protected static final int VERTICAL = 0;
    protected static final int HORIZONTAL = 1;
    protected static final int PARM = 2;
    protected static final int NONPARM = 3;
    protected static final int AUTO = 0;
    protected static final int OFF = 1;
    public static final int STACKED = 0;
    public static final int CLUSTERED = 1;
    protected static final int ASCENDING = 0;
    protected static final int DESCENDING = 1;
    protected static final int MAX_RESPONSES = 10;
    protected int orientation = 0;
    protected int chartType = 2;
    protected SILKNumber categoryRole = null;
    protected SILKNumber responseRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber errorLowRole = null;
    protected SILKNumber errorHighRole = null;
    protected SILKNumber colorIndexRole = null;
    protected SILKNumber tipRole = null;
    protected ResourceBundle rbBar = null;
    protected double widthFactor;
    protected double clusterWidthFactor;
    protected double fullBarWidth;
    protected double baseLineValue = 0.0;
    protected double adjust_pos = 0.0;
    protected double adjust_neg = 0.0;
    protected double barWidth;
    protected double userBarWidth = Double.NaN;
    protected boolean userShowRespStatOnAxis = false;
    protected int userClusterCount = -1;
    protected double respWidth;
    protected AxisDefaults axisDefaults;
    protected CharacterVariableMapper categoryMapper = null;
    protected CharacterVariableMapper groupMapper = null;
    protected DefaultStatistics defaultStatistics = null;
    protected Vector tuple = null;
    protected LinkedHashMap errorLowList = null;
    protected LinkedHashMap errorHighList = null;
    protected LinkedHashMap colorIndexList = null;
    protected LinkedHashMap categoryList = null;
    protected LinkedHashMap responseLink = null;
    protected LinkedHashMap labelList = null;
    LinkedHashMap uniqueGroupList = null;
    LinkedHashMap uniqueCatList = null;
    LinkedHashMap renderingData = null;
    LinkedHashMap renderingMRData = null;
    LinkedHashMap renderingGroupedData = null;
    protected Object responseSign = null;
    protected Object colorBy = null;
    protected Object respVar;
    protected Object frequencyVar;
    protected Object categorySortType = RoleInterface.ROLE_SORT_DATA;
    protected Object responseSortType = null;
    protected Object[] respVars = null;
    protected Object[] summaryVars;
    protected int displayBarStart;
    protected int displayBarEnd;
    protected int numberOfResponse = 1;
    protected int xValueCount = 0;
    protected int actualXValueCount = 0;
    protected int numberOfBars;
    protected int sortOrder = 0;
    protected int responseStatDisplay = 0;
    protected int groupDisplayType = 0;
    protected int statType = 12;
    protected boolean outlineOn;
    protected boolean allowMultiResponse = true;
    protected boolean disableSortByResponse = false;
    protected boolean singleBar;
    protected boolean negResp = false;
    protected boolean userSetXValueCount = false;
    protected boolean absolute = false;
    protected boolean absoluteSort = false;
    protected boolean showStatOnAxis = false;
    protected boolean isGraphed = true;
    protected boolean gradient = true;
    protected boolean gradientDisable = false;
    protected boolean showLabels = false;
    protected boolean showGraphedLabels = false;
    protected boolean styleElementSelectorEnabled = true;
    protected boolean isNegative = false;
    protected boolean isVerticalBar = true;
    protected boolean isDataBuild = false;
    protected String currentLegend = null;
    protected Color transparencyColor = Color.gray;
    protected Color outlineClr;
    protected Font barLabelFont = null;
    protected boolean showOtherBar = false;
    protected static final int NOT_OTHER_BAR = 0;
    protected static final int POSITIVE_OTHER_BAR = 1;
    protected static final int NEGATIVE_OTHER_BAR = 2;
    protected String OTHER_CATEGORY = "OTHER";
    protected ArrayList otherCatList = new ArrayList();
    protected ArrayList otherPosCatList = new ArrayList();
    protected ArrayList otherNegCatList = new ArrayList();
    protected double otherPosRespValue;
    protected double otherNegRespValue;
    private boolean isPositiveBarSelected;
    private boolean isNegativeBarSelected;
    public static final int[] supportedBarElementProperties = new int[]{19081, 19054, 19055, 19067, 806, 815, 803, 813, 812, 816, 807, 804, 810, 809, 802, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 24, 25, 23, 40, 42, 433, 426, 434, 441};

    public AbstractBarElement() {
        this.addChartTabInfo("com.sas.graphics.silk.ui.BarElementPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BarElement.Bar.txt", (String)"Bar"));
        Roles role = Roles.getInstance(null);
        this.categoryRole = role.getRoleObject("ROLE_CATEGORY");
        this.roles.newRole((Object)this.categoryRole, "Category", 1);
        this.roles.setRoleType((Object)this.categoryRole, 0);
        this.roles.setDiscrete((Object)this.categoryRole, true);
        this.roles.setSupportsDiscrete((Object)this.categoryRole, false);
        this.roles.setSortOrder((Object)this.categoryRole, RoleInterface.ROLE_SORT_DATA);
        this.responseRole = role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 10);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.groupRole = role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.errorLowRole = role.getRoleObject("ROLE_ERROR_LOW");
        this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
        this.roles.setRoleType((Object)this.errorLowRole, 1);
        this.errorHighRole = role.getRoleObject("ROLE_ERROR_HIGH");
        this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
        this.roles.setRoleType((Object)this.errorHighRole, 1);
        this.colorIndexRole = role.getRoleObject("ROLE_COLOR_INDEX");
        this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
        this.roles.setRoleType((Object)this.colorIndexRole, 1);
        this.tipRole = role.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.tipRole, "Tip", 1);
        this.roles.setRoleType((Object)this.tipRole, 0);
        this.rbBar = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.responseSign = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.ResponseSign.txt", (String)"Response Sign"), "Response Sign");
        this.widthFactor = 0.85;
        this.clusterWidthFactor = 1.0;
        this.outlineClr = this.style.getLineStyleElement("Outlines").getLineColor();
        this.outlineOn = true;
        this.axisDefaults = new AxisDefaults();
        this.barLabelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)10);
        this.setSupportedProperties(supportedBarElementProperties);
        this.userSetProperties.appendProperties(supportedBarElementProperties);
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 5: {
                this.setSortOrder(e);
            }
        }
        this.setSortMetadata();
        this.createCategoryList();
        if (this.isVerticalBar) {
            if (e.type == 5 || this.isCurrentSortTypeOnCategory()) {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            }
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        } else {
            if (e.type == 5 || this.isCurrentSortTypeOnCategory()) {
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        }
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    public abstract void setAbsolute(boolean var1);

    public abstract void getSortedCategories();

    protected abstract String getFormattedLabel(Object var1);

    protected abstract void removeRole(RoleEvent var1);

    protected abstract void sortCategoriesOnResponse(Object[] var1, ArrayList var2, int var3);

    protected abstract void buildResponseValuesList(Object[] var1, ArrayList var2);

    protected abstract void drawLabels(Graphics var1);

    protected abstract void BuildData(Object[] var1);

    protected abstract void buildSelectionData(LinkedHashMap var1);

    protected abstract String getToolTiptext(Object var1, int var2, int var3, double var4, Object var6);

    protected abstract void drawBars(Graphics var1);

    protected abstract void renderBars(Graphics var1, Color var2, int var3, int var4, int var5, int var6, double var7, int var9, int var10);

    protected abstract Object[] getUniqueCategoryValues(boolean var1);

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 1: 
            case 24: {
                this.setRoleCategoryEnum();
                break;
            }
            case 6: {
                this.setRoleGroupEnum();
                break;
            }
            case 17: {
                this.setRoleResponseEnum();
                break;
            }
        }
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        return super.addRole(variableId, role);
    }

    protected void setRoleCategoryEnum() {
        if (this.filter != null) {
            this.showStatOnAxis = false;
            this.userShowRespStatOnAxis = false;
            Object o = this.roles.getVariable((Object)this.categoryRole, 0);
            int observations = this.filter.getNumberObservations(-1);
            if (this.filter.isNumericVariable(o)) {
                this.responseSortType = RoleInterface.ROLE_SORT_NONE;
            } else {
                this.categorySortType = RoleInterface.ROLE_SORT_DATA;
            }
            if (this.categoryMapper == null) {
                this.categoryMapper = new CharacterVariableMapper(this.filter, null);
                this.categoryMapper.setIncludeMissing(this.isMissingDiscreteIncluded());
                this.categoryMapper.setVariable(o);
            } else {
                this.categoryMapper.setVariable(o);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            this.displayBarStart = 1;
            this.displayBarEnd = this.numberOfBars = this.categoryMapper.getNumberValues();
            if (this.responseStatDisplay == 0) {
                if (this.userShowRespStatOnAxis) {
                    this.showStatOnAxis = this.userShowRespStatOnAxis;
                } else {
                    boolean bl = this.showStatOnAxis = observations != this.numberOfBars;
                }
            }
            if (this.roles.getVariable((Object)this.colorIndexRole, 0) != null) {
                this.lce.setAction(6);
                this.lce.setBuildData(this.categoryRole.toString());
                this.fireLayerListenerChanged(this.lce);
            }
        }
    }

    public void setRoleResponseEnum() {
        this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
        int n = this.numberOfResponse = this.respVars != null ? this.respVars.length : 1;
        if (this.numberOfResponse > 1) {
            this.allowMultiResponse = true;
            this.roles.deleteRole((Object)this.groupRole);
            this.roles.deleteRole((Object)this.colorIndexRole);
            this.roles.deleteRole((Object)this.errorLowRole);
            this.roles.deleteRole((Object)this.errorHighRole);
            this.setOtherBarEnabled();
        } else {
            this.roles.newRole((Object)this.groupRole, "Group", 1);
            this.roles.newRole((Object)this.colorIndexRole, "Color index", 1);
            this.roles.newRole((Object)this.errorLowRole, "Error low", 1);
            this.roles.newRole((Object)this.errorHighRole, "Error high", 1);
        }
        if (this.responseLink != null) {
            this.responseLink.clear();
        }
        if (this.responseLink == null) {
            this.responseLink = new LinkedHashMap();
        }
        for (int i = 0; i < this.numberOfResponse; ++i) {
            this.responseLink.put(new Integer(i), this.respVars[i]);
        }
        Object object = this.respVar = this.respVars != null ? this.respVars[0] : null;
        if (this.getChartType() == 3 && this.respVar != null && (this.statType == 12 || this.statType == 11)) {
            this.statType = 1;
        }
        if (this.getChartType() == 2 && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign")) && this.roles.getVariable((Object)this.colorIndexRole, 0) != null) {
            this.lce.setAction(6);
            this.lce.setBuildData(this.responseSign.toString());
            this.fireLayerListenerChanged(this.lce);
        }
        this.persistSortOrder();
    }

    protected void setRoleGroupEnum() {
        if (this.filter != null) {
            if (this.groupMapper == null) {
                this.groupMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.groupRole, 0));
            } else {
                this.groupMapper.setVariable(this.roles.getVariable((Object)this.groupRole, 0));
            }
            this.allowMultiResponse = false;
            this.responseSortType = RoleInterface.ROLE_SORT_DATA;
            this.buildRenderingData();
            this.lce.setAction(6);
            this.lce.setBuildData(this.groupRole.toString());
            this.fireLayerListenerChanged(this.lce);
        }
    }

    protected void createCategoryList() {
        if (this.filter == null) {
            return;
        }
        int catVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        if (catVarIndex < 0) {
            this.categoryList = null;
            return;
        }
        if (this.defaultStatistics == null) {
            this.defaultStatistics = new DefaultStatistics((Object)this.filter);
        }
        if (this.defaultStatistics == null) {
            this.categoryList = null;
        }
        this.summaryVars = grpVarIndex > -1 ? new Object[]{this.roles.getVariable((Object)this.categoryRole, 0), this.roles.getVariable((Object)this.groupRole, 0)} : new Object[]{this.roles.getVariable((Object)this.categoryRole, 0)};
        this.tuple = this.getChartType() == 2 ? this.defaultStatistics.getSummaryVarsTuples(this.summaryVars, this.respVar) : this.defaultStatistics.getSummaryVarsTuples(this.summaryVars, this.respVar, this.frequencyVar);
        if (this.tuple == null) {
            this.categoryList = null;
            return;
        }
        this.buildGroupListPerCategory();
    }

    protected void buildGroupListPerCategory() {
        int i;
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        LinkedHashMap<Object, Map<Integer, Object>> catList = new LinkedHashMap<Object, Map<Integer, Object>>();
        Map<Integer, Object> grpList = new LinkedHashMap<Integer, Object>();
        Object[] catVals = this.getUniqueCategoryValues(false);
        LinkedHashMap<Object, Object> lhm = new LinkedHashMap<Object, Object>();
        for (i = 0; i < catVals.length; ++i) {
            lhm.put(catVals[i], catVals[i]);
        }
        for (i = 0; i < this.tuple.size(); ++i) {
            Object[] val = (Object[])this.tuple.elementAt(i);
            Integer grpKeyObj = new Integer(0);
            Object grpValueObj = null;
            if (grpVarIndex > -1) {
                grpKeyObj = new Integer(this.groupMapper.getIndex(val[1]));
                grpValueObj = val[1];
            }
            if (!lhm.containsKey(val[0])) continue;
            if (catList.containsKey(val[0])) {
                grpList = (Map)catList.get(val[0]);
                if (grpList != null) {
                    grpList.put(grpKeyObj, grpValueObj);
                    grpList = new TreeMap(grpList);
                } else {
                    grpList = new LinkedHashMap();
                    grpList.put(grpKeyObj, grpValueObj);
                }
            } else {
                grpList = new LinkedHashMap();
                grpList.put(grpKeyObj, grpValueObj);
            }
            catList.put(val[0], grpList);
        }
        this.buildErrorLists();
        this.colorIndexList = null;
        int colorIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorIndexRole, 0));
        if (colorIndexVarIndex > -1) {
            if (grpVarIndex > -1) {
                this.colorIndexList = new LinkedHashMap();
                for (int i2 = 0; i2 < this.filter.getNumberObservations(-1); ++i2) {
                    Object grpObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)i2, null);
                    grpObj = new Integer(this.groupMapper.getIndex(grpObj));
                    double colorIndexVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.colorIndexRole, 0), (long)i2);
                    if (grpObj == null || Double.isNaN(colorIndexVal) || !(colorIndexVal >= 0.0) || this.colorIndexList.containsKey(grpObj)) continue;
                    this.colorIndexList.put(grpObj, new Integer((int)colorIndexVal));
                }
            } else if (this.numberOfResponse == 1) {
                int i3;
                this.colorIndexList = new LinkedHashMap();
                LinkedHashMap<Object, Integer> uniqueCatList = new LinkedHashMap<Object, Integer>();
                Object[] uniqueCatVals = this.getUniqueCategoryValues(false);
                for (i3 = 0; i3 < uniqueCatVals.length; ++i3) {
                    uniqueCatList.put(uniqueCatVals[i3], new Integer(i3));
                }
                for (i3 = 0; i3 < this.filter.getNumberObservations(-1); ++i3) {
                    int catIndx;
                    Object catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)i3, null);
                    if (!uniqueCatList.containsKey(catObj) || (catIndx = ((Number)uniqueCatList.get(catObj)).intValue()) <= -1) continue;
                    catObj = new Integer(catIndx);
                    double colorIndexVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.colorIndexRole, 0), (long)i3);
                    if (catObj == null || Double.isNaN(colorIndexVal) || !(colorIndexVal >= 0.0) || this.colorIndexList.containsKey(catObj)) continue;
                    this.colorIndexList.put(catObj, new Integer((int)colorIndexVal));
                }
            }
        }
        this.categoryList = catList;
        this.singleBar = this.categoryList.keySet().toArray().length == 1;
        this.actualXValueCount = this.categoryList.keySet().toArray().length;
        if (!this.userSetXValueCount) {
            this.xValueCount = this.actualXValueCount;
        }
    }

    protected void persistSortOrder() {
        if (this.responseSortType != null) {
            this.setResponseSortOrder();
        } else {
            this.setCategorySortOrder();
        }
    }

    protected boolean isCurrentSortTypeOnCategory() {
        if (this.categorySortType != null) {
            return !this.categorySortType.equals(RoleInterface.ROLE_SORT_CUSTOM) || this.responseSortType == null;
        }
        return this.responseSortType == null;
    }

    protected void setCategorySortOrder() {
        this.categorySortType = this.roles.getSortOrder((Object)this.categoryRole);
        this.responseSortType = null;
        if (this.categoryMapper != null && this.categorySortType instanceof Number) {
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
        }
    }

    protected void setSortOrder(RoleEvent re) {
        if (this.filter == null || this.categoryMapper == null) {
            return;
        }
        int roleInt = re.role;
        if (roleInt == 1) {
            if (this.categorySortType != null && this.categorySortType.equals(this.roles.getSortOrder((Object)this.categoryRole))) {
                return;
            }
            this.setCategorySortOrder();
            this.roles.setSortOrder((Object)this.responseRole, null);
        } else if (roleInt == 17) {
            if (this.categoryList == null || this.defaultStatistics == null) {
                return;
            }
            Object order = this.roles.getSortOrder((Object)this.responseRole);
            if (this.responseSortType != null && this.responseSortType.equals(order)) {
                return;
            }
            if (RoleInterface.ROLE_SORT_DATA.equals(order)) {
                return;
            }
            this.responseSortType = order;
            if (order instanceof Number) {
                this.sortOrder = ((Number)order).intValue() == RoleInterface.ROLE_SORT_DESCENDING.intValue() ? 1 : 0;
            }
            this.setResponseSortOrder();
        }
    }

    protected void setResponseSortOrder() {
        if (this.categoryMapper == null) {
            return;
        }
        if (this.responseSortType == RoleInterface.ROLE_SORT_NONE) {
            if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                this.categorySortType = new Integer(0);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            return;
        }
        if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1) {
            this.responseSortType = null;
            if (this.categorySortType == null) {
                this.categorySortType = new Integer(-3);
            }
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
        } else {
            this.categorySortType = new Integer(-3);
            this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            Object[] catArray = this.categoryMapper.getValues();
            ArrayList responseValsList = new ArrayList();
            this.buildResponseValuesList(catArray, responseValsList);
            int cOrder = -1;
            if (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING) {
                cOrder = 1;
            } else if (this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING) {
                cOrder = -1;
            }
            this.sortCategoriesOnResponse(catArray, responseValsList, cOrder);
        }
    }

    protected void setSortMetadata() {
        this.roles.setSupportedSortRoles(this.buildSupportedSortableRoles());
        this.roles.setSortsSupported((Object)this.categoryRole, this.buildSupportedSortDirections((Object)this.categoryRole));
        this.roles.setSortsSupported((Object)this.responseRole, this.buildSupportedSortDirections((Object)this.responseRole));
    }

    public int[] buildSupportedSortDirections(Object role) {
        if (role == null || this.filter == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 1) {
            return new int[]{1, -1, 0};
        }
        if (role instanceof Number && ((Number)role).intValue() == 17) {
            if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                return new int[]{1, -1};
            }
            return new int[]{-2, 1, -1};
        }
        return null;
    }

    public Object[][] buildSupportedSortableRoles() {
        if (this.filter == null) {
            return null;
        }
        boolean cat = false;
        boolean resp = false;
        if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
            cat = true;
        }
        if (!(this.disableSortByResponse || this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1)) {
            resp = true;
        }
        if (cat && resp) {
            return new Object[][]{{this.categoryRole, this.responseRole}};
        }
        if (cat) {
            return new Object[][]{{this.categoryRole}};
        }
        if (resp) {
            return new Object[][]{{this.responseRole}};
        }
        return null;
    }

    protected void buildErrorLists() {
        int errorLowVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.errorLowRole, 0));
        int errorHighVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.errorHighRole, 0));
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        this.errorLowList = null;
        this.errorHighList = null;
        if (grpVarIndex == -1 && this.numberOfResponse <= 1) {
            if (errorLowVarIndex > -1) {
                this.errorLowList = new LinkedHashMap();
            }
            if (errorHighVarIndex > -1) {
                this.errorHighList = new LinkedHashMap();
            }
            if (errorLowVarIndex > -1 || errorHighVarIndex > -1) {
                for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    String catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)i, null);
                    int catVal = this.categoryMapper.getIndex(catObj);
                    if (errorLowVarIndex > -1 && catVal > -1) {
                        double errorLowVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.errorLowRole, 0), (long)i);
                        if (catObj != null && !Double.isNaN(errorLowVal) && errorLowVal > 0.0) {
                            this.errorLowList.put(new Integer(catVal), new Double(errorLowVal));
                        }
                    }
                    if (errorHighVarIndex <= -1 || catVal <= -1) continue;
                    double errorHighVal = this.filter.getNumericValue(this.roles.getVariable((Object)this.errorHighRole, 0), (long)i);
                    if (catObj == null || Double.isNaN(errorHighVal) || !(errorHighVal > 0.0)) continue;
                    this.errorHighList.put(new Integer(catVal), new Double(errorHighVal));
                }
            }
        }
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        if (this instanceof AbstractBarElement && (dim == 1 || dim == 2) && (range instanceof DiscreteRange || range instanceof OrdinalRange) && this.categoryMapper != null) {
            DiscreteRange dr = (DiscreteRange)range;
            Vector values = dr.getValues();
            int size = values.size();
            boolean rebuild = false;
            if (size != this.categoryMapper.getNumberValues()) {
                rebuild = true;
            }
            this.categoryMapper.removeAllValues();
            for (int catIndex = 0; catIndex < size; ++catIndex) {
                this.categoryMapper.addValue(values.elementAt(catIndex));
            }
            this.buildErrorLists();
            if (rebuild) {
                this.prefInnerMargin.left = 0;
                this.prefInnerMargin.right = 0;
                if (this.categoryList != null) {
                    this.actualXValueCount = this.categoryList.keySet().toArray().length;
                    if (!this.userSetXValueCount) {
                        this.xValueCount = this.actualXValueCount;
                    }
                }
                this.layoutChart();
            }
        }
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                this.persistSortOrder();
                this.createCategoryList();
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 806: {
                rc = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1 || this.colorIndexList != null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 815: {
                rc = this.colorBy;
                break;
            }
            case 803: {
                rc = new Boolean(this.outlineOn);
                break;
            }
            case 813: {
                rc = new Boolean(this.gradientDisable);
                break;
            }
            case 812: {
                rc = new Boolean(this.gradient);
                break;
            }
            case 816: {
                rc = new Boolean(this.showLabels);
                break;
            }
            case 807: {
                rc = new Integer(-1);
                break;
            }
            case 804: {
                rc = new Double(this.widthFactor);
                break;
            }
            case 823: {
                rc = new Double(this.clusterWidthFactor);
                break;
            }
            case 810: {
                rc = new Integer(this.numberOfBars);
                break;
            }
            case 824: {
                rc = this.getBarWidth();
                break;
            }
            case 809: {
                rc = this.getDisplayBarRange();
                break;
            }
            case 802: {
                rc = this.outlineClr;
                break;
            }
            case 820: {
                rc = new Integer(this.groupDisplayType);
                break;
            }
            case 821: {
                rc = this.isMultipleResponseBar();
                break;
            }
            case 822: {
                rc = this.isGrouped();
                break;
            }
            case 23: {
                this.currentLegend = null;
                if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1) {
                    String string = this.currentLegend = this.groupRole != null ? this.groupRole.toString() : null;
                }
                if (this.currentLegend == null && this.allowMultiResponse && this.numberOfResponse > 1) {
                    this.currentLegend = this.responseRole.toString();
                }
                if (this.currentLegend == null && this.colorIndexList != null) {
                    this.currentLegend = this.categoryRole.toString();
                }
                if (this.currentLegend == null && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                    this.currentLegend = this.responseSign.toString();
                }
                if (this.currentLegend == null && this.colorBy != null && !this.colorBy.equals(this.responseSign) && !this.colorBy.toString().equalsIgnoreCase("Response Sign")) {
                    this.currentLegend = this.categoryRole.toString();
                }
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.groupRole == null || !this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (this.filter == null) break;
                Vector<Object> legNames = new Vector<Object>();
                int grpIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                if (grpIndex > -1) {
                    legNames.add((Object)this.groupRole);
                } else if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    legNames.add((Object)this.responseRole);
                } else if (this.colorIndexList != null) {
                    legNames.add((Object)this.categoryRole);
                } else if (grpIndex == -1 && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                    legNames.add(this.responseSign);
                } else if (grpIndex == -1 && this.colorBy != null && !this.colorBy.equals(this.responseSign) && !this.colorBy.toString().equalsIgnoreCase("Response Sign")) {
                    legNames.add((Object)this.categoryRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                MarkerAttrib ms;
                Object[] catVals;
                int groupIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                Color color = null;
                if (groupIndex > -1 && this.categoryList != null) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
                    if (this.colorIndexList != null) {
                        Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
                        for (int i = 0; i < groupVals.length; ++i) {
                            Integer grpObj = new Integer(this.groupMapper.getIndex(groupVals[i]));
                            Object clrObj = this.colorIndexList.get(grpObj);
                            if (clrObj != null) {
                                int clrVal = ((Number)clrObj).intValue();
                                DataStyleElement dse = SILKUtilities.getStyleElement(groupVals[i].toString(), clrVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                                color = dse.getFillColor();
                            } else {
                                color = this.style.getFillStyleElement("Missing").getFillColor();
                            }
                            int grpVal = this.groupMapper.getIndex(groupVals[i]);
                            if (grpVal <= -1) continue;
                            MarkerAttrib ms2 = new MarkerAttrib(true, color);
                            ms2.setOutline(new Boolean(this.outlineOn));
                            ms2.setOutline(this.outlineClr);
                            legendEntries.add(new LegendEntry(groupVals[i], ms2, null));
                        }
                    } else {
                        Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
                        for (int i = 0; i < groupVals.length; ++i) {
                            int grpVal = i;
                            String attrValueStr = groupVals[i].toString();
                            DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, grpVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                            color = dse.getFillColor();
                            grpVal = this.groupMapper.getIndex(groupVals[i]);
                            if (grpVal <= -1) continue;
                            MarkerAttrib ms3 = new MarkerAttrib(true, color);
                            ms3.setOutline(new Boolean(this.outlineOn));
                            ms3.setOutline(this.outlineClr);
                            legendEntries.add(new LegendEntry(groupVals[i], ms3, null));
                        }
                    }
                    rc = legendEntries;
                    break;
                }
                if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(this.numberOfResponse);
                    for (int i = 0; i < this.numberOfResponse; ++i) {
                        Object var = this.roles.getVariable((Object)this.responseRole, i);
                        var = this.filter.getVariableDescription(var);
                        String attrValueStr = var.toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                        color = dse.getFillColor();
                        MarkerAttrib ms4 = new MarkerAttrib(true, color);
                        ms4.setOutline(new Boolean(this.outlineOn));
                        ms4.setOutline(this.outlineClr);
                        legendEntries.add(new LegendEntry(var, ms4, null));
                    }
                    rc = legendEntries;
                    break;
                }
                if (this.colorIndexList != null) {
                    LinkedHashMap<Object, Integer> uniqueCatList = new LinkedHashMap<Object, Integer>();
                    Object[] catVals2 = this.getUniqueCategoryValues(false);
                    for (int i = 0; i < catVals2.length; ++i) {
                        uniqueCatList.put(catVals2[i], new Integer(i));
                    }
                    catVals2 = this.getUniqueCategoryValues(true);
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(catVals2.length);
                    for (int i = 0; i < catVals2.length; ++i) {
                        int catIndx = ((Number)uniqueCatList.get(catVals2[i])).intValue();
                        Integer catObj = new Integer(catIndx);
                        Object clrObj = this.colorIndexList.get(catObj);
                        if (clrObj != null) {
                            int clrVal = ((Number)clrObj).intValue();
                            DataStyleElement dse = SILKUtilities.getStyleElement(catVals2[i].toString(), clrVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                            color = dse.getFillColor();
                        } else {
                            color = this.style.getFillStyleElement("Missing").getFillColor();
                        }
                        int catIndex = this.categoryMapper.getIndex(catVals2[i]);
                        if (catIndex <= -1) continue;
                        MarkerAttrib ms5 = new MarkerAttrib(true, color);
                        ms5.setOutline(new Boolean(this.outlineOn));
                        ms5.setOutline(this.outlineClr);
                        legendEntries.add(new LegendEntry(catVals2[i], ms5, null));
                    }
                    if (this.showOtherBar && this.otherCatList != null && this.otherCatList.size() > 0) {
                        FillStyleElement se = this.style.getFillStyleElement("Other");
                        Color otherBarClr = se.getFillColor();
                        MarkerAttrib ms6 = new MarkerAttrib(true, otherBarClr);
                        ms6.setOutline(new Boolean(this.outlineOn));
                        ms6.setOutline(this.outlineClr);
                        legendEntries.add(new LegendEntry(this.OTHER_CATEGORY, ms6, null));
                    }
                    rc = legendEntries;
                    break;
                }
                if (groupIndex == -1 && this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(2);
                    Color[] fillColors = this.style.getDataFillColors();
                    color = fillColors[1];
                    MarkerAttrib ms7 = new MarkerAttrib(true, color);
                    ms7.setOutline(new Boolean(this.outlineOn));
                    ms7.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry("-", ms7, null));
                    color = fillColors[0];
                    ms7 = new MarkerAttrib(true, color);
                    ms7.setOutline(new Boolean(this.outlineOn));
                    ms7.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry("+", ms7, null));
                    rc = legendEntries;
                    break;
                }
                if (groupIndex != -1 || this.colorBy == null || this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign") || (catVals = this.getUniqueCategoryValues(false)) == null || catVals.length <= 0) break;
                Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(catVals.length);
                for (int i = 0; i < catVals.length; ++i) {
                    int catVal = this.categoryMapper.getIndex(catVals[i]);
                    if (catVal < 0) continue;
                    catVal = i;
                    String attrValueStr = catVals[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, catVal, 2, this.style, this.fillAttrs.getReference(), null).getAsDataStyle();
                    color = dse.getFillColor();
                    ms = new MarkerAttrib(true, color);
                    ms.setOutline(new Boolean(this.outlineOn));
                    ms.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry(catVals[i], ms, null));
                }
                if (this.showOtherBar && this.otherCatList != null && this.otherCatList.size() > 0) {
                    FillStyleElement se = this.style.getFillStyleElement("Other");
                    Color otherBarClr = se.getFillColor();
                    ms = new MarkerAttrib(true, otherBarClr);
                    ms.setOutline(new Boolean(this.outlineOn));
                    ms.setOutline(this.outlineClr);
                    legendEntries.add(new LegendEntry(this.OTHER_CATEGORY, ms, null));
                }
                rc = legendEntries;
                break;
            }
            case 426: {
                Object catVar;
                Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
                if (this.filter != null && groupVar != null) {
                    rc = this.filter.getVariableDescription(groupVar);
                }
                if (rc == null) {
                    rc = groupVar;
                }
                if (rc == null && this.colorIndexList != null) {
                    catVar = this.roles.getVariable((Object)this.categoryRole, 0);
                    if (this.filter != null && catVar != null) {
                        rc = this.filter.getVariableDescription(catVar);
                    }
                    if (rc == null) {
                        rc = catVar;
                    }
                }
                if (rc != null) break;
                if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                    rc = this.responseSign.toString();
                    break;
                }
                if (this.colorBy == null || this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign")) break;
                catVar = this.roles.getVariable((Object)this.categoryRole, 0);
                if (this.filter != null && catVar != null) {
                    rc = this.filter.getVariableDescription(catVar);
                }
                if (rc != null) break;
                rc = catVar;
                break;
            }
            case 420: {
                rc = new Boolean(!this.categoryRole.equals(this.currentLegend));
                break;
            }
            case 441: {
                rc = Boolean.FALSE;
                break;
            }
            case 19057: {
                rc = new Object[]{RoleInterface.ROLE_CATEGORY};
                break;
            }
            case 19056: {
                rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                break;
            }
            case 19064: {
                rc = Boolean.FALSE;
                break;
            }
            case 19053: {
                rc = this.setCategoryAxisLabels();
                break;
            }
            case 19052: {
                rc = this.setCategoryAxisLabels();
                break;
            }
            case 19067: {
                if (this.userSetXValueCount) {
                    rc = new Integer(this.getXValueCount());
                    break;
                }
                rc = null;
                break;
            }
            case 42: {
                rc = new Double(this.actualXValueCount);
                break;
            }
            case 826: {
                rc = this.getNumberOFClusters();
                break;
            }
            case 829: {
                rc = this.showStatOnAxis;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        switch (id) {
            case 815: {
                this.styleElementSelectorEnabled = value == null;
                break;
            }
            case 825: {
                this.setUseBarWidth(((Number)value).doubleValue());
                break;
            }
        }
        return super.setPropertyValue(id, value);
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 19081: {
                if (!(value instanceof Boolean)) break;
                this.disableSortByResponse = (Boolean)value;
                if (this.disableSortByResponse) {
                    this.roles.setSortOrder((Object)this.responseRole, null);
                }
                this.setSortMetadata();
                break;
            }
            case 809: {
                if (!(value instanceof int[])) break;
                int[] range = (int[])value;
                this.setDisplayBarRange(range[0], range[1]);
                break;
            }
            case 815: {
                this.setColorBy(value);
                break;
            }
            case 824: {
                this.setBarWidth(((Number)value).doubleValue());
                break;
            }
            case 803: {
                if (!(value instanceof Boolean)) break;
                this.outlineOn = (Boolean)value;
                this.userSetProperties.set(803);
                break;
            }
            case 820: {
                if (value instanceof Number) {
                    this.setGroupDisplayType(((Number)value).intValue());
                    this.userSetProperties.set(820);
                    break;
                }
                if (!(value instanceof String)) break;
                if (((String)value).equalsIgnoreCase("STACKED")) {
                    this.setGroupDisplayType(0);
                    break;
                }
                if (!((String)value).equalsIgnoreCase("CLUSTERED")) break;
                this.setGroupDisplayType(1);
                break;
            }
            case 802: {
                if (!(value instanceof Color)) break;
                this.outlineClr = (Color)value;
                break;
            }
            case 812: {
                if (!(value instanceof Boolean)) break;
                this.setGradientOn((Boolean)value);
                break;
            }
            case 804: {
                if (!(value instanceof Number)) break;
                this.setWidthFactor(((Number)value).doubleValue());
                break;
            }
            case 825: {
                if (!(value instanceof Number)) break;
                this.setUseBarWidth(((Number)value).doubleValue());
                break;
            }
            case 827: {
                if (!(value instanceof Number)) break;
                this.setUserClusterBarCount(((Number)value).intValue());
                break;
            }
            case 828: {
                if (!(value instanceof Boolean)) break;
                this.setUserShowRespStatOnAxis((Boolean)value);
                break;
            }
            case 823: {
                if (!(value instanceof Number)) break;
                this.setClusterWidthFactor(((Number)value).doubleValue());
                break;
            }
            case 816: {
                if (!(value instanceof Boolean)) break;
                this.setShowLabel((Boolean)value);
                break;
            }
            case 40: {
                if (!(value instanceof Number)) break;
                this.setXValueCount(((Number)value).intValue());
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setGroupDisplayType(int groupDisplayType) {
        this.groupDisplayType = groupDisplayType;
        if (groupDisplayType == 1) {
            this.showStatOnAxis = false;
            if (!this.hasUserSetValue(823)) {
                this.setClusterWidthFactor(0.85);
            }
            if (!this.hasUserSetValue(804)) {
                this.setWidthFactor(1.0);
            }
        } else {
            this.setClusterWidthFactor(1.0);
            if (!this.hasUserSetValue(804)) {
                this.setWidthFactor(0.85);
            }
        }
        this.userSetProperties.set(820);
        this.fireLayerListenerChanged(7);
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public double getUserBarWidth() {
        return this.userBarWidth;
    }

    public void setBarWidth(double width) {
        this.barWidth = width;
        this.userSetProperties.set(824);
        this.fireLayerListenerChanged(1);
    }

    public void setUseBarWidth(double width) {
        this.userBarWidth = width;
        this.userSetProperties.set(825);
        this.fireLayerListenerChanged(1);
    }

    public void setUserClusterBarCount(int userCount) {
        this.userClusterCount = userCount;
    }

    public int getUserClusterBarCount() {
        return this.userClusterCount;
    }

    public void setShowLabel(boolean flag) {
        this.userSetProperties.set(816);
        this.showLabels = flag;
        this.fireLayerListenerChanged(1);
    }

    private Object setCategoryAxisLabels() {
        Object rc = null;
        if (this.filter != null) {
            Object catVar = this.roles.getVariable((Object)this.categoryRole, 0);
            if (catVar != null) {
                rc = this.filter.getVariableDescription(catVar);
            }
            if (rc == null) {
                rc = catVar;
            }
        }
        return rc;
    }

    public int getXValueCount() {
        return Math.max(this.actualXValueCount, this.xValueCount);
    }

    public void setXValueCount(int count) {
        this.userSetXValueCount = count >= 1;
        this.xValueCount = count;
        this.fireLayerListenerChanged(7);
    }

    public int getXActualValueCount() {
        return this.actualXValueCount;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return this.allowMultiResponse;
    }

    public void setNumberDisplayBars(int n) {
        if (n < 1) {
            return;
        }
        this.setDisplayBarRange(1, n);
    }

    public void setDisplayBarRange(int start, int end) {
        if (start < 1 || end < start) {
            return;
        }
        this.displayBarStart = start;
        this.displayBarEnd = end;
        this.userSetProperties.set(809);
        ViewportEvent evt = this.isVerticalBar ? new ViewportEvent(this, 1, (double)this.displayBarStart - 1.5, (double)this.displayBarEnd - 0.5, Double.NaN, Double.NaN, Double.NaN, Double.NaN) : new ViewportEvent(this, 1, Double.NaN, Double.NaN, (double)this.displayBarStart - 1.5, (double)this.displayBarEnd - 0.5, Double.NaN, Double.NaN);
        this.fireViewportEvent(evt);
        this.fireLayerListenerChanged(1);
    }

    public int getNumberDisplayBars() {
        return this.displayBarEnd + 1 - this.displayBarStart;
    }

    public int[] getDisplayBarRange() {
        return new int[]{this.displayBarStart, this.displayBarEnd};
    }

    public void setColorBy(Object role) {
        if (role == null) {
            this.colorBy = null;
        }
        if (role instanceof String && (((String)role).equalsIgnoreCase(this.responseSign.toString()) || ((String)role).equalsIgnoreCase("Response Sign"))) {
            this.colorBy = role;
        } else if (role instanceof String && (((String)role).equalsIgnoreCase(this.categoryRole.toString()) || ((String)role).equalsIgnoreCase("Category"))) {
            this.colorBy = role;
        } else if (role instanceof SILKNumber) {
            this.colorBy = (SILKNumber)((Object)role);
        }
        this.userSetProperties.set(815);
        this.fireLayerListenerChanged(1);
    }

    public void setGradientOn(boolean onOff) {
        if (this.gradient == onOff) {
            return;
        }
        this.gradient = onOff;
        this.userSetProperties.set(812);
        this.fireLayerListenerChanged(1);
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.widthFactor = fac;
        this.userBarWidth = Double.NaN;
        double temp = 0.85;
        if (this.groupDisplayType == 1) {
            temp = 1.0;
        }
        if (fac - temp == 0.0) {
            this.userSetProperties.clear(804);
        } else {
            this.userSetProperties.set(804);
        }
        this.fireLayerListenerChanged(1);
    }

    public void setClusterWidthFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.clusterWidthFactor = fac;
        this.userBarWidth = Double.NaN;
        double temp = 0.85;
        if (this.groupDisplayType == 0) {
            temp = 1.0;
        }
        if (fac - temp == 0.0) {
            this.userSetProperties.clear(823);
        } else {
            this.userSetProperties.set(823);
        }
        this.fireLayerListenerChanged(1);
    }

    public double getClusterWidthFactor() {
        return this.clusterWidthFactor;
    }

    protected void setDefaultBarLabelFont() {
        int size = 0;
        size = (int)(0.5 * Math.sqrt(this.bounds.height) * this.axisDefaults.fontSizeAdjust);
        size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
        this.barLabelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)size);
    }

    @Override
    public Object getVariable(Object role) {
        return super.getVariable(role);
    }

    @Override
    public Object getAllVariables(Object role) {
        return super.getAllVariables(role);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsoluteSort(boolean absoluteSort) {
        this.setAbsoluteSort(absoluteSort, this.sortOrder);
    }

    public void setAbsoluteSort(boolean absoluteSort, int sortOrder) {
        this.absoluteSort = absoluteSort;
        this.sortOrder = sortOrder;
        Object o = this.roles.getSortOrder(RoleInterface.ROLE_RESPONSE);
        if (this.getSortOrder(RoleInterface.ROLE_RESPONSE) == null) {
            return;
        }
        if (absoluteSort) {
            switch (sortOrder) {
                case 1: {
                    this.setSortOrder(RoleInterface.ROLE_RESPONSE, RoleInterface.ROLE_SORT_DESCENDING);
                    break;
                }
                default: {
                    this.setSortOrder(RoleInterface.ROLE_RESPONSE, RoleInterface.ROLE_SORT_ASCENDING);
                }
            }
        }
        this.persistSortOrder();
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public boolean isAbsoluteSort() {
        return this.absoluteSort;
    }

    protected boolean checkNegative(double responseValue) {
        return responseValue < 0.0;
    }

    protected boolean isNegative() {
        return this.isNegative;
    }

    public void checkNegativeValues(double value) {
        this.isNegative = value < 0.0;
    }

    protected Object[] getCatValues() {
        if (this.categoryMapper != null) {
            Object[] obj = this.categoryMapper.getValues();
            return obj;
        }
        return null;
    }

    protected AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    protected boolean isGraphed(int i) {
        return this.filter.isGraphed((long)i);
    }

    public void setGraphTransparency(double a) {
        int alpha = 0;
        alpha = a < 0.0 ? 0 : (a > 1.0 ? 255 : (int)(255.0 * a));
        this.transparencyColor = new Color(this.transparencyColor.getRed(), this.transparencyColor.getGreen(), this.transparencyColor.getBlue(), alpha);
    }

    public void setGraphTransparencyColor(Color c) {
        this.transparencyColor = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.transparencyColor.getAlpha());
    }

    protected void drawOutline(Graphics g, int x, int y, int width, int height, boolean isGraphed) {
        Color outlineColor = this.getOutlineColor();
        if (!isGraphed) {
            outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
        }
        g.setColor(outlineColor);
        Graphics2D g2 = null;
        Stroke s = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        if (g2 != null) {
            s = g2.getStroke();
            g2.setStroke(this.getOutlineStroke());
        }
        g.drawRect(x, y, width, height);
        if (g2 != null) {
            g2.setStroke(s);
        }
    }

    protected Color adjustForFillTransparency(Color c, StyleElement localOverrides) {
        Color c2 = c;
        if (localOverrides != null) {
            int alpha = (int)(255.0 - 255.0 * localOverrides.getAsFillStyle().getFillTransparency());
            c2 = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        return c2;
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        boolean b = super.applyWhereClause(clause, clearPrevious);
        this.fireLayerListenerChanged(7);
        return b;
    }

    protected double getResponseValues(Object[] summaryVars, Object respVar1, Object frequencyVar1, Object[] summaryVarVals1, int statType1) {
        double responseValue = 0.0;
        responseValue = this.defaultStatistics.getSummaryStatistic(summaryVars, respVar1, frequencyVar1, summaryVarVals1, statType1);
        this.isNegative = this.checkNegative(responseValue);
        return responseValue;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] supportedRoles = super.getSupportedRoles(id, discrete);
        List<Object> supportedRoleList = Arrays.asList(supportedRoles);
        ArrayList<Object> modifiedList = new ArrayList<Object>(supportedRoleList);
        Object groupVar = this.roles.getVariable(RoleInterface.ROLE_GROUP);
        if (groupVar != null) {
            modifiedList.remove((Object)this.role.getRoleObject("ROLE_ERROR_HIGH"));
            modifiedList.remove((Object)this.role.getRoleObject("ROLE_ERROR_LOW"));
        }
        Object errorLowVar = this.roles.getVariable(RoleInterface.ROLE_ERROR_LOW);
        Object errorHighVar = this.roles.getVariable(RoleInterface.ROLE_ERROR_HIGH);
        if (errorLowVar != null || errorHighVar != null) {
            SILKNumber groupRole = this.role.getRoleObject("ROLE_GROUP");
            modifiedList.remove((Object)groupRole);
        }
        return modifiedList.toArray(new Object[0]);
    }

    protected int getGroupObsIndex(String catVal, String grpVal) {
        int catIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        int grpIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            String catValue = this.filter.getFormattedValue(this.filter.getVariableId(catIndex), (long)i, null);
            String grpValue = this.filter.getFormattedValue(this.filter.getVariableId(grpIndex), (long)i, null);
            if (!catValue.equals(catVal) || !grpValue.equals(grpVal)) continue;
            return i;
        }
        return -1;
    }

    private boolean isGrouped() {
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        return grpVarIndex > -1;
    }

    protected boolean isMultipleResponseBar() {
        return this.allowMultiResponse && this.numberOfResponse > 1;
    }

    @Override
    public void dispose() {
        this.categoryRole = null;
        this.responseRole = null;
        this.groupRole = null;
        this.categoryMapper = null;
        this.groupMapper = null;
        this.rbBar = null;
        this.responseSign = null;
        this.colorBy = null;
        if (this.defaultStatistics != null) {
            this.defaultStatistics.dispose();
        }
        this.defaultStatistics = null;
        this.tuple = null;
        this.categoryList = null;
        this.errorLowList = null;
        this.errorHighList = null;
        this.colorIndexList = null;
        this.barLabelFont = null;
        this.axisDefaults = null;
        super.dispose();
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void setOrientation(int orientation) {
        this.orientation = orientation;
        this.isVerticalBar = orientation == 0;
    }

    protected int getChartType() {
        return this.chartType;
    }

    protected void setChartType(int chartType) {
        this.chartType = chartType;
    }

    protected int getNumberOFClusters() {
        if (this.categoryList == null) {
            return 0;
        }
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        int numberOfCluster = 0;
        for (int i = 0; i < catArray.length; ++i) {
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            int temp = grpValuesArray.length;
            if (temp <= numberOfCluster) continue;
            numberOfCluster = temp;
        }
        return numberOfCluster;
    }

    protected void drawErrorHighLow(Graphics g, double[] projectValues, double[] projectValues_1, double respValue, int catValue) {
        double val;
        Object valObj;
        Color mc;
        int barCenter = catValue;
        Color color = mc = this.isGraphed ? this.outlineClr : new Color(this.outlineClr.getRed(), this.outlineClr.getGreen(), this.outlineClr.getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
        if (this.errorHighList != null && (valObj = this.errorHighList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
            int errorHighX;
            g.setColor(mc);
            if (this.isVerticalBar) {
                int n = errorHighX = respValue >= 0.0 ? (int)projectValues[1] : (int)projectValues_1[1];
                if (this.transformObject.isReverse(1)) {
                    errorHighX = respValue >= 0.0 ? (int)projectValues_1[1] : (int)projectValues[1];
                }
                projectValues_1 = this.transformObject.project(barCenter, respValue + val, 0.0, projectValues_1);
                g.drawLine((int)projectValues_1[0], errorHighX, (int)projectValues_1[0], (int)projectValues_1[1]);
                g.drawLine((int)projectValues_1[0] - 3, (int)projectValues_1[1], (int)projectValues_1[0] + 3, (int)projectValues_1[1]);
            } else {
                int n = errorHighX = respValue >= 0.0 ? (int)projectValues_1[0] : (int)projectValues[0];
                if (this.transformObject.isReverse(0)) {
                    errorHighX = respValue >= 0.0 ? (int)projectValues[0] : (int)projectValues_1[0];
                }
                projectValues_1 = this.transformObject.project(respValue + val, barCenter, 0.0, projectValues_1);
                g.drawLine(errorHighX, (int)projectValues_1[1], (int)projectValues_1[0], (int)projectValues_1[1]);
                g.drawLine((int)projectValues_1[0], (int)projectValues_1[1] - 3, (int)projectValues_1[0], (int)projectValues_1[1] + 3);
            }
        }
        if (this.errorLowList != null && (valObj = this.errorLowList.get(new Integer(catValue))) != null && !Double.isNaN(val = ((Number)valObj).doubleValue())) {
            int errorLowX;
            g.setColor(mc);
            if (this.isVerticalBar) {
                int n = errorLowX = respValue >= 0.0 ? (int)projectValues[1] : (int)projectValues_1[1];
                if (this.transformObject.isReverse(1)) {
                    errorLowX = respValue >= 0.0 ? (int)projectValues_1[1] : (int)projectValues[1];
                }
                projectValues_1 = this.transformObject.project(barCenter, respValue - val, 0.0, projectValues_1);
                g.drawLine((int)projectValues_1[0], errorLowX, (int)projectValues_1[0], (int)projectValues_1[1]);
                g.drawLine((int)projectValues_1[0] - 3, (int)projectValues_1[1], (int)projectValues_1[0] + 3, (int)projectValues_1[1]);
            } else {
                int n = errorLowX = respValue >= 0.0 ? (int)projectValues_1[0] : (int)projectValues[0];
                if (this.transformObject.isReverse(0)) {
                    errorLowX = respValue >= 0.0 ? (int)projectValues[0] : (int)projectValues_1[0];
                }
                projectValues_1 = this.transformObject.project(respValue - val, barCenter, 0.0, projectValues_1);
                g.drawLine(errorLowX, (int)projectValues_1[1], (int)projectValues_1[0], (int)projectValues_1[1]);
                g.drawLine((int)projectValues_1[0], (int)projectValues_1[1] - 3, (int)projectValues_1[0], (int)projectValues_1[1] + 3);
            }
        }
    }

    protected void getProjectedBar(double barCenter, double respValue, double adjust_pos, double adjust_neg, double[] projectValues, double[] projectValues_1) {
        if (this.isVerticalBar) {
            double barEnd;
            double barStart;
            if (respValue >= 0.0) {
                if (this.transformObject.isReverse(1)) {
                    barStart = adjust_pos;
                    barEnd = adjust_pos + respValue;
                } else {
                    barStart = respValue + adjust_pos;
                    barEnd = adjust_pos;
                }
            } else if (this.transformObject.isReverse(1)) {
                barStart = adjust_neg + respValue;
                barEnd = adjust_neg;
            } else {
                barStart = adjust_neg;
                barEnd = adjust_neg + respValue;
            }
            projectValues = this.transformObject.project(barCenter, barStart, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(barCenter, barEnd, 0.0, projectValues_1);
        } else {
            double barEnd;
            double barStart;
            if (respValue >= 0.0) {
                if (this.transformObject.isReverse(0)) {
                    barStart = adjust_pos + respValue;
                    barEnd = adjust_pos;
                } else {
                    barStart = adjust_pos;
                    barEnd = adjust_pos + respValue;
                }
            } else if (this.transformObject.isReverse(0)) {
                barStart = adjust_neg;
                barEnd = adjust_neg + respValue;
            } else {
                barStart = adjust_neg + respValue;
                barEnd = adjust_neg;
            }
            projectValues = this.transformObject.project(barStart, barCenter, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(barEnd, barCenter, 0.0, projectValues_1);
        }
    }

    protected void drawBaseLine(Graphics g) {
        double[] projectValues = new double[3];
        projectValues = this.transformObject.project(0.0, this.baseLineValue, 0.0, projectValues);
        Color baseLineColor = this.style.getLineStyleElement("AxisLines").getLineColor();
        g.setColor(baseLineColor);
        if (this.isVerticalBar) {
            g.drawLine(this.bounds.x, (int)projectValues[1], this.bounds.x + this.bounds.width, (int)projectValues[1]);
        } else {
            g.drawLine((int)projectValues[0], this.bounds.y, (int)projectValues[0], this.bounds.y + this.bounds.height);
        }
    }

    protected void populateLabels(double respValue_l, double projection) {
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        double[] dVal = new double[2];
        if (grpVarIndex > -1 && this.groupDisplayType == 0) {
            if (respValue_l < 0.0) {
                dVal[1] = respValue_l;
            } else {
                dVal[0] = respValue_l;
            }
        } else {
            dVal[0] = respValue_l;
        }
        Object tmpVal = null;
        double catKey = projection;
        if (this.labelList.containsKey(new Double(catKey)) && (tmpVal = this.labelList.get(new Double(catKey))) != null) {
            if (grpVarIndex > -1 && this.groupDisplayType == 0) {
                if (respValue_l > 0.0) {
                    double val = ((double[])tmpVal)[0];
                    dVal[0] = dVal[0] + val;
                    dVal[1] = ((double[])tmpVal)[1];
                } else {
                    double val = ((double[])tmpVal)[1];
                    dVal[0] = ((double[])tmpVal)[0];
                    dVal[1] = dVal[1] + val;
                }
            } else if (grpVarIndex <= -1 || this.groupDisplayType != 1) {
                double val = ((double[])tmpVal)[0];
                dVal[0] = dVal[0] + val;
            }
        }
        this.labelList.put(new Double(catKey), dVal);
    }

    @Override
    protected void layoutChart() {
        super.layoutChart();
        if (this.filter != null) {
            int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
            int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
            if (xVarIndex > -1 && this.categoryMapper != null && this.categoryMapper.getNumberValues() > 0) {
                if (this.isVerticalBar) {
                    int num = Math.max(Math.max(this.xValueCount, this.actualXValueCount), this.categoryMapper.getNumberValues());
                    this.fullBarWidth = this.bounds.width / num;
                } else {
                    this.fullBarWidth = this.bounds.height / this.categoryMapper.getNumberValues();
                }
                int halfWidth = (int)(this.fullBarWidth / 2.0);
                if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    this.fullBarWidth /= (double)(this.numberOfResponse + 1);
                    this.barWidth = this.respWidth = this.fullBarWidth;
                    this.barWidth *= this.widthFactor;
                    halfWidth -= (int)(0.025 * this.fullBarWidth);
                } else if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                    double cnt = this.getNumberOFClusters();
                    double clustCount = this.userClusterCount > 0 && (double)this.userClusterCount >= cnt ? (double)this.userClusterCount : cnt;
                    this.fullBarWidth *= this.clusterWidthFactor;
                    this.fullBarWidth /= clustCount;
                    this.barWidth = Double.isNaN(this.userBarWidth) ? (this.respWidth = this.fullBarWidth) : this.userBarWidth;
                    this.barWidth *= this.widthFactor;
                    halfWidth -= (int)(0.001 * this.fullBarWidth);
                } else {
                    this.respWidth = this.barWidth = this.fullBarWidth;
                    this.barWidth *= this.widthFactor;
                }
                boolean fireEvent = false;
                if (this.isVerticalBar) {
                    int offsetBottom = 0;
                    int offsetTop = 0;
                    if (this.showLabels) {
                        this.setDefaultBarLabelFont();
                        if (this.transformObject.isReverse(1)) {
                            offsetBottom = this.barLabelFont.getSize() + 2;
                            offsetTop = this.negResp ? this.barLabelFont.getSize() + 2 : 0;
                        } else {
                            offsetBottom = this.negResp ? this.barLabelFont.getSize() + 2 : 0;
                            offsetTop = this.barLabelFont.getSize() + 2;
                        }
                        if (this.showOtherBar && this.otherPosRespValue > 0.0) {
                            if (this.transformObject.isReverse(1)) {
                                offsetTop = this.barLabelFont.getSize() + 2;
                            } else {
                                offsetBottom = this.barLabelFont.getSize() + 2;
                            }
                        }
                        if (this.otherNegRespValue < 0.0) {
                            if (this.transformObject.isReverse(1)) {
                                offsetTop = this.barLabelFont.getSize() + 2;
                            } else {
                                offsetBottom = this.barLabelFont.getSize() + 2;
                            }
                        }
                    }
                    if (this.prefInnerMargin.top != offsetTop || this.prefInnerMargin.bottom != offsetBottom || this.prefInnerMargin.right != halfWidth || this.prefInnerMargin.left != halfWidth) {
                        fireEvent = true;
                    }
                    this.prefInnerMargin = new Insets(offsetTop, halfWidth, offsetBottom, halfWidth);
                } else {
                    int offsetRight = 0;
                    int offsetLeft = 0;
                    int offsetBottom = halfWidth;
                    int offsetTop = halfWidth;
                    if (this.showLabels) {
                        this.setDefaultBarLabelFont();
                        if (this.categoryList != null) {
                            TextLayout txtStr;
                            String label;
                            Object[] catArray = this.categoryList.keySet().toArray();
                            Object[] grpArray = this.categoryList.values().toArray();
                            Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[2];
                            float textLength = 0.0f;
                            FontRenderContext frc = new FontRenderContext(null, true, true);
                            Object format = this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, 0), SASFormat.class);
                            for (int i = 0; i < catArray.length; ++i) {
                                Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
                                Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
                                summaryVarVals[0] = catArray[i];
                                double respValue = 0.0;
                                for (int j = 0; j < grpKeyArray.length; ++j) {
                                    if (grpVarIndex > -1 && this.groupDisplayType == 0) {
                                        summaryVarVals[1] = grpValuesArray[j];
                                        respValue = this.chartType == 2 ? this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, 1) : this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                                    } else {
                                        respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                                    }
                                    format = this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, 0), SASFormat.class);
                                    label = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(respValue), format);
                                    label = label.trim();
                                    txtStr = new TextLayout(label, this.barLabelFont, frc);
                                    textLength = Math.max(textLength, txtStr.getVisibleAdvance() + 6.0f + txtStr.getAscent());
                                    textLength = Math.min(textLength, (float)((double)this.bounds.width * 0.2));
                                    if (this.transformObject.isReverse(0)) {
                                        offsetLeft = (int)textLength;
                                        offsetRight = this.negResp ? (int)textLength : 0;
                                        continue;
                                    }
                                    offsetLeft = this.negResp ? (int)textLength : 0;
                                    offsetRight = (int)textLength;
                                }
                            }
                            if (this.showOtherBar) {
                                if (this.otherPosRespValue > 0.0) {
                                    label = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(this.otherPosRespValue), format);
                                    label = label.trim();
                                    txtStr = new TextLayout(label, this.barLabelFont, frc);
                                    textLength = Math.max(textLength, txtStr.getVisibleAdvance() + 6.0f + txtStr.getAscent());
                                    textLength = Math.min(textLength, (float)((double)this.bounds.width * 0.2));
                                    if (this.transformObject.isReverse(0)) {
                                        offsetLeft = (int)textLength;
                                    } else {
                                        offsetRight = (int)textLength;
                                    }
                                }
                                if (this.otherNegRespValue < 0.0) {
                                    label = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(this.otherNegRespValue), format);
                                    label = label.trim();
                                    txtStr = new TextLayout(label, this.barLabelFont, frc);
                                    textLength = Math.max(textLength, txtStr.getVisibleAdvance() + 6.0f + txtStr.getAscent());
                                    textLength = Math.min(textLength, (float)((double)this.bounds.width * 0.2));
                                    if (this.transformObject.isReverse(0)) {
                                        offsetRight = (int)textLength;
                                    } else {
                                        offsetLeft = (int)textLength;
                                    }
                                }
                            }
                        }
                    }
                    if (this.prefInnerMargin == null || this.prefInnerMargin.top != offsetTop || this.prefInnerMargin.bottom != offsetBottom || this.prefInnerMargin.right != offsetRight || this.prefInnerMargin.left != offsetLeft) {
                        fireEvent = true;
                    }
                    this.prefInnerMargin = new Insets(offsetTop, offsetLeft, offsetBottom, offsetRight);
                }
                if (fireEvent) {
                    this.fireMarginChanged(new MarginChangeEvent((Object)this));
                }
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.filter == null) {
            return;
        }
        if (this.categoryList == null) {
            return;
        }
        Object[] grpArray = this.categoryList.values().toArray();
        Object[] grpKeyArray = null;
        this.labelList = new LinkedHashMap();
        this.outlineClr = this.style.getLineStyleElement("Outlines").getLineColor();
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        this.gradientDisable = false;
        for (int i = 0; i < grpArray.length; ++i) {
            grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            if (grpKeyArray.length <= 1) continue;
            this.gradientDisable = true;
            break;
        }
        if (!this.isDataBuild) {
            this.buildRenderingData();
        }
        if (this.categoryMapper != null) {
            boolean v1 = false;
            boolean v2 = true;
            if (this.categoryMapper.getNumberValues() == 1) {
                v2 = v1;
            }
            if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                double cnt = this.getNumberOFClusters();
                double clustCount = this.userClusterCount > 0 && (double)this.userClusterCount >= cnt ? (double)this.userClusterCount : cnt;
                this.fullBarWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
                this.fullBarWidth *= this.clusterWidthFactor;
                this.fullBarWidth /= clustCount;
                this.barWidth = Double.isNaN(this.userBarWidth) ? (this.respWidth = this.fullBarWidth) : this.userBarWidth;
                this.barWidth *= this.widthFactor;
            } else if (this.isMultipleResponseBar()) {
                this.fullBarWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
                this.fullBarWidth /= (double)(this.numberOfResponse + 1);
                this.barWidth = Double.isNaN(this.userBarWidth) ? (this.respWidth = this.fullBarWidth) : this.userBarWidth;
                this.barWidth *= this.widthFactor;
            } else {
                this.barWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
                this.barWidth *= this.widthFactor;
            }
        }
        if (this.isAbsoluteSort() && (!this.allowMultiResponse || this.numberOfResponse <= 1)) {
            this.getSortedCategories();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        }
        if (this.allowMultiResponse && this.numberOfResponse > 1) {
            this.drawMRBars(g);
        } else if (grpVarIndex > -1) {
            this.drawGroupedBars(g);
        } else {
            this.drawBars(g);
        }
        this.drawBaseLine(g);
        if (this.showLabels) {
            this.drawLabels(g);
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        DataRange[] ranges;
        String[] vars;
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        if (this.categoryList == null) {
            return false;
        }
        double[] upv1 = new double[3];
        double[] upv2 = new double[3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        double respValue = Double.NaN;
        if (this.isVerticalBar) {
            upv1 = this.transformObject.unProject(selectArea.x, 0.0, 0.0, upv1);
            upv2 = this.transformObject.unProject(selectArea.x + selectArea.width, 0.0, 0.0, upv2);
            minX = Math.min(upv1[0], upv2[0]);
            maxX = Math.max(upv1[0], upv2[0]);
            maxX += this.widthFactor / 2.0;
            if (Double.isNaN(minX -= this.widthFactor / 2.0)) {
                minX = 0.0;
            }
            if (Double.isNaN(maxX)) {
                maxX = 0.0;
            }
        } else {
            upv1 = this.transformObject.unProject(0.0, selectArea.y, 0.0, upv1);
            upv2 = this.transformObject.unProject(0.0, selectArea.y + selectArea.height, 0.0, upv2);
            minY = Math.min(upv1[1], upv2[1]);
            maxY = Math.max(upv1[1], upv2[1]);
            maxY += this.widthFactor / 2.0;
            if (Double.isNaN(minY -= this.widthFactor / 2.0)) {
                minY = 0.0;
            }
            if (Double.isNaN(maxY)) {
                maxY = 0.0;
            }
        }
        double respWidth = this.barWidth = this.fullBarWidth;
        this.barWidth *= this.widthFactor;
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        if (this.categoryMapper != null && (grpVarIndex <= -1 || this.groupDisplayType != 1)) {
            boolean v1 = false;
            boolean v2 = true;
            if (this.categoryMapper.getNumberValues() == 1) {
                v2 = v1;
            }
            this.barWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
            this.barWidth *= this.widthFactor;
        }
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        Vector<Object> catVector = new Vector<Object>();
        Vector<Object> grpVector = new Vector<Object>();
        for (int i = 0; i < catArray.length; ++i) {
            int catValue = this.categoryMapper.getIndex(catArray[i]);
            if (this.isVerticalBar ? !((double)catValue >= minX) || !((double)catValue <= maxX) : !((double)catValue >= minY) || !((double)catValue <= maxY)) continue;
            double barCenter = catValue;
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                LinkedHashMap renderingData = (LinkedHashMap)this.renderingMRData.get(catArray[i]);
                barCenter = this.categoryMapper.getIndex(catArray[i]);
                Object[] respVars = renderingData.keySet().toArray();
                Object[] respVals = renderingData.values().toArray();
                for (int j = 0; j < respVars.length; ++j) {
                    ArrayList responselist = (ArrayList)respVals[j];
                    Rectangle rect = null;
                    for (int k = 0; k < responselist.size(); ++k) {
                        this.adjust_neg = 0.0;
                        this.adjust_pos = 0.0;
                        Object[] respArray = (Object[])responselist.get(k);
                        Double val = (Double)respArray[0];
                        if (val == 0.0 || Double.isNaN(val)) continue;
                        if (val != null) {
                            respValue = val;
                        }
                        if (respValue == 0.0 || Double.isNaN(respValue)) continue;
                        respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                        this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                        if (this.isVerticalBar) {
                            projectValues[0] = projectValues[0] - ((double)this.numberOfResponse / 2.0 - (double)j) * respWidth;
                            projectValues[0] = projectValues[0] + respWidth / 2.0;
                            rect = new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                        } else {
                            projectValues[1] = projectValues[1] - ((double)this.numberOfResponse / 2.0 - (double)j) * respWidth;
                            projectValues[1] = projectValues[1] + respWidth / 2.0;
                            rect = new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                        }
                        if (!rect.intersects(selectArea)) continue;
                        catVector.addElement(catArray[i]);
                    }
                }
                continue;
            }
            Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            int numberOfCluster = grpValuesArray.length;
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
            LinkedHashMap groupedData = (LinkedHashMap)this.renderingGroupedData.get(catArray[i]);
            if (grpVarIndex > -1) {
                for (int j = 0; j < grpKeyArray.length; ++j) {
                    int grpValue = ((Number)grpKeyArray[j]).intValue();
                    String grpValueStr = this.groupMapper.getValue(grpValue).toString();
                    if (groupedData == null) continue;
                    ArrayList responseList = (ArrayList)groupedData.get(grpValueStr);
                    for (int k = 0; k < responseList.size(); ++k) {
                        Rectangle rect;
                        Object[] respArray = (Object[])responseList.get(k);
                        Double val = (Double)respArray[0];
                        if (val == 0.0 || Double.isNaN(val)) continue;
                        if (val != null) {
                            respValue = val;
                        }
                        respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                        this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                        if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                            if (this.isVerticalBar) {
                                projectValues[0] = projectValues[0] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[0] = projectValues[0] + respWidth / 2.0;
                            } else {
                                projectValues[1] = projectValues[1] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[1] = projectValues[1] + respWidth / 2.0;
                            }
                            this.adjust_neg = 0.0;
                            this.adjust_pos = 0.0;
                        } else if (respValue >= 0.0) {
                            this.adjust_pos += respValue;
                        } else {
                            this.adjust_neg += respValue;
                        }
                        Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                        if (!rect.intersects(selectArea)) continue;
                        catVector.addElement(catArray[i]);
                        if (grpVarIndex <= -1) continue;
                        grpVector.addElement(grpValuesArray[j]);
                    }
                }
                continue;
            }
            barCenter = this.categoryMapper.getIndex(catArray[i]);
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            if (responseList == null) continue;
            for (int j = 0; j < responseList.size(); ++j) {
                Rectangle rect;
                this.adjust_neg = 0.0;
                this.adjust_pos = 0.0;
                Object[] respArray = (Object[])responseList.get(j);
                Double val = (Double)respArray[0];
                if (val == 0.0 || Double.isNaN(val)) continue;
                if (val != null) {
                    respValue = val;
                }
                respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                if (respValue >= 0.0) {
                    this.adjust_pos += respValue;
                } else {
                    this.adjust_neg += respValue;
                }
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (!rect.intersects(selectArea)) continue;
                catVector.addElement(catArray[i]);
            }
        }
        int barCenter = this.categoryMapper.getIndex(this.OTHER_CATEGORY);
        if (barCenter > -1) {
            this.isNegativeBarSelected = false;
            this.isPositiveBarSelected = false;
            if (this.otherPosRespValue > 0.0) {
                Rectangle rect;
                this.adjust_neg = 0.0;
                this.adjust_pos = 0.0;
                respValue = this.otherPosRespValue;
                this.getProjectedBar(barCenter, this.otherPosRespValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    this.adjust_pos += respValue;
                } else {
                    this.adjust_neg += respValue;
                }
                if (rect.intersects(selectArea)) {
                    this.isPositiveBarSelected = true;
                    if (!catVector.contains(this.OTHER_CATEGORY)) {
                        catVector.addElement(this.OTHER_CATEGORY);
                    }
                }
            }
            if (this.otherNegRespValue < 0.0) {
                Rectangle rect;
                this.adjust_neg = 0.0;
                this.adjust_pos = 0.0;
                respValue = this.otherNegRespValue;
                this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    this.adjust_pos += respValue;
                } else {
                    this.adjust_neg += respValue;
                }
                if (rect.intersects(selectArea)) {
                    this.isNegativeBarSelected = true;
                    if (!catVector.contains(this.OTHER_CATEGORY)) {
                        catVector.addElement(this.OTHER_CATEGORY);
                    }
                }
            }
        }
        if (grpVarIndex > -1) {
            vars = new String[]{this.roles.getVariable((Object)this.categoryRole, 0).toString(), this.roles.getVariable((Object)this.groupRole, 0).toString()};
            ranges = new DataRange[]{new DiscreteRange(catVector.toArray()), new DiscreteRange(grpVector.toArray())};
        } else if (catVector.size() == 1 && catVector.contains(this.OTHER_CATEGORY)) {
            vars = new String[]{this.roles.getVariable((Object)this.categoryRole, 0).toString()};
            ranges = new DataRange[1];
            if (this.isPositiveBarSelected && this.isNegativeBarSelected) {
                ranges[0] = new DiscreteRange(this.otherCatList.toArray());
            } else if (this.isPositiveBarSelected) {
                ranges[0] = new DiscreteRange(this.otherPosCatList.toArray());
            } else if (this.isNegativeBarSelected) {
                ranges[0] = new DiscreteRange(this.otherNegCatList.toArray());
            }
        } else {
            vars = new String[]{this.roles.getVariable((Object)this.categoryRole, 0).toString()};
            ranges = new DataRange[1];
            if (this.isPositiveBarSelected) {
                catVector.addAll(this.otherPosCatList);
            }
            if (this.isNegativeBarSelected) {
                catVector.addAll(this.otherNegCatList);
            }
            ranges[0] = new DiscreteRange(catVector.toArray());
        }
        if (this.filter != null) {
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, true);
            } else {
                this.filter.setSelected(vars, ranges, select, true);
            }
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        Rectangle rect;
        double barCenter;
        if (this.categoryList == null) {
            return null;
        }
        Rectangle textRect = new Rectangle(screenX - 1, screenY - 1, 3, 3);
        double[] upv1 = new double[3];
        double[] upv2 = new double[3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        if (this.isVerticalBar) {
            upv1 = this.transformObject.unProject(textRect.x, 0.0, 0.0, upv1);
            upv2 = this.transformObject.unProject(textRect.x + textRect.width, 0.0, 0.0, upv2);
            minX = Math.min(upv1[0], upv2[0]);
            maxX = Math.max(upv1[0], upv2[0]);
            maxX += this.widthFactor / 2.0;
            if (Double.isNaN(minX -= this.widthFactor / 2.0)) {
                minX = 0.0;
            }
            if (Double.isNaN(maxX)) {
                maxX = 0.0;
            }
        } else {
            upv1 = this.transformObject.unProject(0.0, textRect.y, 0.0, upv1);
            upv2 = this.transformObject.unProject(0.0, textRect.y + textRect.height, 0.0, upv2);
            minY = Math.min(upv1[1], upv2[1]);
            maxY = Math.max(upv1[1], upv2[1]);
            maxY += this.widthFactor / 2.0;
            if (Double.isNaN(minY -= this.widthFactor / 2.0)) {
                minY = 0.0;
            }
            if (Double.isNaN(maxY)) {
                maxY = 0.0;
            }
        }
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        double adjust_pos = 0.0;
        double adjust_neg = 0.0;
        double respValue = Double.NaN;
        int respIndex = 0;
        Object[] respKeyArray = this.responseLink != null ? this.responseLink.keySet().toArray() : null;
        Object[] respValuesArray = this.responseLink != null ? this.responseLink.values().toArray() : null;
        String tipText = null;
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        double respWidth = this.barWidth = this.fullBarWidth * this.widthFactor;
        this.barWidth *= this.widthFactor;
        if (this.categoryMapper != null) {
            if (!(grpVarIndex > -1 && this.groupDisplayType == 1 || this.isMultipleResponseBar())) {
                boolean v1 = false;
                boolean v2 = true;
                if (this.categoryMapper.getNumberValues() == 1) {
                    v2 = v1;
                }
                this.barWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
                this.barWidth *= this.widthFactor;
            }
        } else {
            return "";
        }
        for (int i = 0; i < catArray.length; ++i) {
            Object varObj;
            Object valObj;
            Double val;
            int catValue = this.categoryMapper.getIndex(catArray[i]);
            if (!this.isVerticalBar ? !((double)catValue >= minY) || !((double)catValue <= maxY) : !((double)catValue >= minX) || !((double)catValue <= maxX)) continue;
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                LinkedHashMap renderingData = (LinkedHashMap)this.renderingMRData.get(catArray[i]);
                barCenter = this.categoryMapper.getIndex(catArray[i]);
                Object[] respVars = renderingData.keySet().toArray();
                Object[] respVals = renderingData.values().toArray();
                for (int j = 0; j < respVars.length; ++j) {
                    respIndex = j;
                    ArrayList responselist = (ArrayList)respVals[j];
                    adjust_neg = 0.0;
                    adjust_pos = 0.0;
                    Object[] respArray = (Object[])responselist.get(responselist.size() - 1);
                    Double val2 = (Double)respArray[0];
                    if (val2 == 0.0 || Double.isNaN(val2)) continue;
                    if (val2 != null) {
                        respValue = val2;
                    }
                    if (respValue == 0.0 || Double.isNaN(respValue)) continue;
                    respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                    this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                    if (this.isVerticalBar) {
                        projectValues[0] = projectValues[0] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * respWidth;
                        projectValues[0] = projectValues[0] + respWidth / 2.0;
                        rect = new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                    } else {
                        projectValues[1] = projectValues[1] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * respWidth;
                        projectValues[1] = projectValues[1] + respWidth / 2.0;
                        rect = new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                    }
                    if (!rect.intersects(textRect)) continue;
                    return this.getToolTiptext(catArray[i], catValue, j, respValue, null);
                }
                continue;
            }
            Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            adjust_neg = 0.0;
            adjust_pos = 0.0;
            LinkedHashMap groupedData = (LinkedHashMap)this.renderingGroupedData.get(catArray[i]);
            if (grpVarIndex > -1) {
                for (int j = 0; j < grpKeyArray.length; ++j) {
                    int grpValue = ((Number)grpKeyArray[j]).intValue();
                    String grpValueStr = this.groupMapper.getValue(grpValue).toString();
                    int numberOfCluster = grpValuesArray.length;
                    ArrayList responseList = (ArrayList)groupedData.get(grpValueStr);
                    boolean clustered = false;
                    for (int k = 0; k < responseList.size() && !clustered; ++k) {
                        Object[] respArray = (Object[])responseList.get(k);
                        val = (Double)respArray[0];
                        if (this.groupDisplayType == 1) {
                            respArray = (Object[])responseList.get(responseList.size() - 1);
                            val = (Double)respArray[0];
                            clustered = true;
                        }
                        if (val == 0.0 || Double.isNaN(val)) continue;
                        if (val != null) {
                            respValue = val;
                        }
                        respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                        this.getProjectedBar(catValue, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                        if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                            if (this.isVerticalBar) {
                                projectValues[0] = projectValues[0] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[0] = projectValues[0] + respWidth / 2.0;
                            } else {
                                projectValues[1] = projectValues[1] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[1] = projectValues[1] + respWidth / 2.0;
                            }
                            adjust_neg = 0.0;
                            adjust_pos = 0.0;
                        } else if (respValue >= 0.0) {
                            adjust_pos += respValue;
                        } else {
                            adjust_neg += respValue;
                        }
                        Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                        if (!rect.intersects(textRect)) continue;
                        return this.getToolTiptext(catArray[i], catValue, 0, respValue, grpValuesArray[j]);
                    }
                }
                continue;
            }
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            barCenter = this.categoryMapper.getIndex(catArray[i]);
            adjust_neg = 0.0;
            adjust_pos = 0.0;
            if (responseList == null) {
                return null;
            }
            Object[] respArray = (Object[])responseList.get(responseList.size() - 1);
            val = (Double)respArray[0];
            if (val == 0.0 || Double.isNaN(val)) continue;
            if (val != null) {
                respValue = val;
            }
            respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
            this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
            if (respValue >= 0.0) {
                adjust_pos += respValue;
            } else {
                adjust_neg += respValue;
            }
            Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            if (!rect.intersects(textRect)) continue;
            tipText = this.getToolTiptext(catArray[i], catValue, 0, respValue, null);
            Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
            if (this.errorLowList != null) {
                valObj = this.errorLowList.get(new Integer(catValue));
                varObj = this.roles.getVariable((Object)this.errorLowRole, 0);
                Object format = this.filter.getFormat(varObj, SASFormat.class);
                String errorLowValStr = this.filter.getFormattedValue(varObj, valObj, format);
                errorLowValStr = "\n" + probeMessage.toString(this.filter.getVariableDescription(varObj), (Object)errorLowValStr);
                tipText = tipText + errorLowValStr;
            }
            if (this.errorHighList != null) {
                valObj = this.errorHighList.get(new Integer(catValue));
                varObj = this.roles.getVariable((Object)this.errorHighRole, 0);
                Object format = this.filter.getFormat(varObj, SASFormat.class);
                String errorHighValStr = this.filter.getFormattedValue(varObj, valObj, format);
                errorHighValStr = "\n" + probeMessage.toString(this.filter.getVariableDescription(varObj), (Object)errorHighValStr);
                tipText = tipText + errorHighValStr;
            }
            tipText = tipText.replaceAll("=", "\t=\t");
            tipText = tipText.replaceAll("\\[", "\t \t\\[");
            return tipText;
        }
        barCenter = this.categoryMapper.getIndex(this.OTHER_CATEGORY);
        if (barCenter > -1.0) {
            if (this.otherPosRespValue > 0.0) {
                adjust_neg = 0.0;
                adjust_pos = 0.0;
                respValue = this.otherPosRespValue;
                this.getProjectedBar(barCenter, this.otherPosRespValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    adjust_pos += respValue;
                } else {
                    adjust_neg += respValue;
                }
                if (rect.intersects(textRect)) {
                    tipText = this.getToolTiptext(this.OTHER_CATEGORY, (int)barCenter, 0, this.otherPosRespValue, null);
                }
            }
            if (this.otherNegRespValue < 0.0) {
                adjust_neg = 0.0;
                adjust_pos = 0.0;
                respValue = this.otherNegRespValue;
                this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    adjust_pos += respValue;
                } else {
                    adjust_neg += respValue;
                }
                if (rect.intersects(textRect)) {
                    tipText = this.getToolTiptext(this.OTHER_CATEGORY, (int)barCenter, 0, this.otherNegRespValue, null);
                }
            }
        }
        return tipText;
    }

    @Override
    protected void drawSelected(Graphics g) {
        double barCenter;
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        if (this.chartType == 3 ? this.categoryList == null : this.categoryList == null || this.respVar == null) {
            return;
        }
        int catIndex = -1;
        int grpIndex = 0;
        int respIndex = 0;
        double respValue = 0.0;
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Color selectionColor = this.style.getFillStyleElement("Selection").getFillColor();
        TexturePaint tp = null;
        FillPattern fillPattern = new FillPattern();
        tp = fillPattern.getHatch45(selectionColor);
        Object[] grpArray = this.categoryList.values().toArray();
        Object[] grpKeyArray = this.categoryList.keySet().toArray();
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        if (this.userBarWidth > 0.0) {
            this.respWidth = this.fullBarWidth;
            this.barWidth = this.userBarWidth;
        } else {
            double respWidth = this.barWidth = this.fullBarWidth;
            this.barWidth *= this.widthFactor;
        }
        if (!(this.categoryMapper == null || grpVarIndex > -1 && this.groupDisplayType == 1 || this.isMultipleResponseBar())) {
            boolean v1 = false;
            boolean v2 = true;
            if (this.categoryMapper.getNumberValues() == 1) {
                v2 = v1;
            }
            this.barWidth = this.isVerticalBar ? (double)this.getScreenSpacing((byte)1, (double)v1, (double)v2) : (double)this.getScreenSpacing((byte)2, (double)v1, (double)v2);
            this.barWidth *= this.widthFactor;
        }
        LinkedHashMap selectionList = new LinkedHashMap();
        this.buildSelectionData(selectionList);
        Object[] selectionKeyArray = selectionList.keySet().toArray();
        Object[] selectionValArray = selectionList.values().toArray();
        for (int i = 0; i < selectionKeyArray.length; ++i) {
            if (this.showOtherBar && this.otherCatList != null && this.otherCatList.size() > 0 && this.otherCatList.contains(selectionKeyArray[i])) continue;
            Object[] selectionGrpArray = ((LinkedHashMap)selectionValArray[i]).keySet().toArray();
            Object[] selectionGrpValArray = ((LinkedHashMap)selectionValArray[i]).values().toArray();
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
            catIndex = this.categoryMapper.getIndex(selectionKeyArray[i]);
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                for (int j = 0; j < selectionGrpArray.length; ++j) {
                    respIndex = ((Number)selectionGrpArray[j]).intValue();
                    respValue = ((Number)selectionGrpValArray[j]).doubleValue();
                    if (respValue == 0.0) continue;
                    respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                    barCenter = catIndex;
                    this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                    ((Graphics2D)g).setPaint(tp);
                    if (this.isVerticalBar) {
                        projectValues[0] = projectValues[0] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * this.respWidth;
                        projectValues[0] = projectValues[0] + this.respWidth / 2.0;
                        g.fillRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                        ((Graphics2D)g).setPaint(selectionColor);
                        g.drawRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                        continue;
                    }
                    projectValues[1] = projectValues[1] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * this.respWidth;
                    projectValues[1] = projectValues[1] + this.respWidth / 2.0;
                    g.fillRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                    ((Graphics2D)g).setPaint(selectionColor);
                    g.drawRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                }
                continue;
            }
            int clusterIndex = 0;
            for (int j = 0; j < selectionGrpArray.length; ++j) {
                this.adjust_neg = 0.0;
                this.adjust_pos = 0.0;
                if (grpVarIndex > -1) {
                    grpIndex = this.groupMapper.getIndex(selectionGrpArray[j]);
                    double sum_pos = 0.0;
                    double sum_neg = 0.0;
                    LinkedHashMap groupedData = (LinkedHashMap)this.renderingGroupedData.get(selectionKeyArray[i]);
                    if (groupedData == null) continue;
                    for (int k = grpIndex - 1; k > -1; --k) {
                        Object obj = this.groupMapper.getValue(k);
                        ArrayList responses = (ArrayList)groupedData.get(obj);
                        if (responses == null) continue;
                        for (int r = 0; r < responses.size(); ++r) {
                            Object[] respArray = (Object[])responses.get(r);
                            Double val = (Double)respArray[0];
                            if (Double.isNaN(val)) continue;
                            if (val < 0.0) {
                                sum_neg += val.doubleValue();
                                continue;
                            }
                            sum_pos += val.doubleValue();
                        }
                    }
                    if (this.groupDisplayType == 0) {
                        this.adjust_pos = sum_pos;
                        this.adjust_neg = sum_neg;
                    } else if (this.groupDisplayType == 1) {
                        this.adjust_neg = 0.0;
                        this.adjust_pos = 0.0;
                    }
                }
                barCenter = catIndex;
                respValue = ((Number)selectionGrpValArray[j]).doubleValue();
                double d = respValue = this.isAbsolute() ? Math.abs(respValue) : respValue;
                if (Double.isNaN(respValue) || respValue == 0.0) continue;
                this.getProjectedBar(barCenter, respValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
                if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                    Object[] grpValuesArray = ((Map)this.categoryList.get(selectionKeyArray[i])).keySet().toArray();
                    int numberOfCluster = grpValuesArray.length;
                    for (int k = 0; k < grpValuesArray.length; ++k) {
                        if (((Number)grpValuesArray[k]).intValue() != grpIndex) continue;
                        clusterIndex = k;
                        break;
                    }
                    if (this.isVerticalBar) {
                        projectValues[0] = projectValues[0] - ((double)numberOfCluster / 2.0 - (double)clusterIndex) * this.respWidth;
                        projectValues[0] = projectValues[0] + this.respWidth / 2.0;
                    } else {
                        projectValues[1] = projectValues[1] - ((double)numberOfCluster / 2.0 - (double)clusterIndex) * this.respWidth;
                        projectValues[1] = projectValues[1] + this.respWidth / 2.0;
                    }
                }
                if (this.isVerticalBar) {
                    ((Graphics2D)g).setPaint(tp);
                    g.fillRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                    ((Graphics2D)g).setPaint(selectionColor);
                    g.drawRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                    continue;
                }
                ((Graphics2D)g).setPaint(tp);
                g.fillRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                ((Graphics2D)g).setPaint(selectionColor);
                g.drawRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            }
        }
        this.adjust_neg = 0.0;
        this.adjust_pos = 0.0;
        barCenter = this.categoryMapper.getIndex(this.OTHER_CATEGORY);
        if (this.isPositiveBarSelected) {
            this.getProjectedBar(barCenter, this.otherPosRespValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
            if (this.isVerticalBar) {
                ((Graphics2D)g).setPaint(tp);
                g.fillRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                ((Graphics2D)g).setPaint(selectionColor);
                g.drawRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            } else {
                ((Graphics2D)g).setPaint(tp);
                g.fillRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                ((Graphics2D)g).setPaint(selectionColor);
                g.drawRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            }
        }
        if (this.isNegativeBarSelected) {
            this.getProjectedBar(barCenter, this.otherNegRespValue, this.adjust_pos, this.adjust_neg, projectValues, projectValues_1);
            if (this.isVerticalBar) {
                ((Graphics2D)g).setPaint(tp);
                g.fillRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                ((Graphics2D)g).setPaint(selectionColor);
                g.drawRect((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            } else {
                ((Graphics2D)g).setPaint(tp);
                g.fillRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                ((Graphics2D)g).setPaint(selectionColor);
                g.drawRect((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            }
        }
    }

    protected void buildRenderingData() {
        Object[] summaryVarVals;
        this.uniqueGroupList = new LinkedHashMap();
        this.uniqueCatList = new LinkedHashMap();
        this.renderingData = new LinkedHashMap();
        this.renderingGroupedData = new LinkedHashMap();
        this.renderingMRData = new LinkedHashMap();
        int catVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        if (catVarIndex == -1) {
            return;
        }
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] uniqueCatVals = this.getUniqueCategoryValues(false);
        for (int i = 0; i < uniqueCatVals.length; ++i) {
            this.uniqueCatList.put(uniqueCatVals[i], new Integer(i));
        }
        if (grpVarIndex > -1) {
            summaryVarVals = new Object[2];
            Object[] uniqueGroupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
            if (uniqueGroupVals.length > 0) {
                for (int i = 0; i < uniqueGroupVals.length; ++i) {
                    this.uniqueGroupList.put(uniqueGroupVals[i], new Integer(i));
                }
            }
        } else {
            summaryVarVals = new Object[1];
        }
        this.BuildData(summaryVarVals);
    }

    private void drawGroupedBars(Graphics g) {
        int respIndex = 0;
        int grpValue = 0;
        double respValue = 0.0;
        String grpValueStr = null;
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        for (int i = 0; i < catArray.length; ++i) {
            Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            int numberOfCluster = grpValuesArray.length;
            this.adjust_neg = 0.0;
            this.adjust_pos = 0.0;
            LinkedHashMap groupedData = (LinkedHashMap)this.renderingGroupedData.get(catArray[i]);
            int barCenter = this.categoryMapper.getIndex(catArray[i]);
            for (int j = 0; j < grpKeyArray.length; ++j) {
                ArrayList responseList;
                grpValue = ((Number)grpKeyArray[j]).intValue();
                Object gv = this.groupMapper.getValue(grpValue);
                if (gv == null) continue;
                grpValueStr = gv.toString();
                int grpIndx = ((Number)this.uniqueGroupList.get(grpValuesArray[j])).intValue();
                DataStyleElement dse = SILKUtilities.getStyleElement(grpValueStr, grpIndx, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                Color clr = dse.getFillColor();
                if (groupedData == null || (responseList = (ArrayList)groupedData.get(grpValueStr)) == null) continue;
                for (int k = 0; k < responseList.size(); ++k) {
                    Object[] respArray = (Object[])responseList.get(k);
                    Double val = (Double)respArray[0];
                    if (val == 0.0 || Double.isNaN(val)) continue;
                    if (val != null) {
                        respValue = val;
                    }
                    this.isGraphed = (Boolean)respArray[1];
                    this.checkNegativeValues(respValue);
                    if (this.colorIndexList != null) {
                        Object clrObj = null;
                        clrObj = this.colorIndexList.get(new Integer(grpValue));
                        if (clrObj != null) {
                            int clrVal = ((Number)clrObj).intValue();
                            dse = SILKUtilities.getStyleElement(grpValueStr, clrVal, 2, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                            clr = dse.getFillColor();
                        } else {
                            clr = this.style.getFillStyleElement("Missing").getFillColor();
                        }
                    }
                    this.renderBars(g, clr, i, j, numberOfCluster, barCenter, respValue, respIndex, -1);
                }
            }
        }
    }

    private void drawMRBars(Graphics g) {
        int respIndex = 0;
        double respValue = 0.0;
        Color[] fillColors = this.style.getDataFillColors();
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] respKeyArray = this.responseLink != null ? this.responseLink.keySet().toArray() : null;
        Object[] respValuesArray = this.responseLink != null ? this.responseLink.values().toArray() : null;
        for (int i = 0; i < catArray.length; ++i) {
            LinkedHashMap renderingData = (LinkedHashMap)this.renderingMRData.get(catArray[i]);
            int barCenter = this.categoryMapper.getIndex(catArray[i]);
            Object[] respVars = renderingData.keySet().toArray();
            Object[] respVals = renderingData.values().toArray();
            for (int j = 0; j < respVars.length; ++j) {
                String respVarStr = respVars[j].toString();
                respIndex = j;
                ArrayList responseList = (ArrayList)respVals[j];
                for (int k = 0; k < responseList.size(); ++k) {
                    this.adjust_neg = 0.0;
                    this.adjust_pos = 0.0;
                    Object[] respArray = (Object[])responseList.get(k);
                    Double val = (Double)respArray[0];
                    if (val == 0.0 || Double.isNaN(val)) continue;
                    if (val != null) {
                        respValue = val;
                    }
                    if (respValue == 0.0 || Double.isNaN(respValue)) continue;
                    this.isGraphed = (Boolean)respArray[1];
                    this.checkNegativeValues(respValue);
                    DataStyleElement dse = SILKUtilities.getStyleElement(respVarStr, respIndex, 1, this.style, this.fillAttrs.getReference(), this.fillAttrs.getOverrides(false)).getAsDataStyle();
                    Color clr = dse.getFillColor();
                    this.renderBars(g, clr, i, j, 0, barCenter, respValue, respIndex, -1);
                }
            }
        }
    }

    @Override
    protected Hashtable getDrilldownInfo(int screenX, int screenY) {
        Rectangle rect;
        double barCenter;
        if (this.categoryList == null) {
            return null;
        }
        Object[] catArray = this.categoryList.keySet().toArray();
        Object[] grpArray = this.categoryList.values().toArray();
        double adjust_pos = 0.0;
        double adjust_neg = 0.0;
        double respValue = Double.NaN;
        int respIndex = 0;
        adjust_neg = 0.0;
        adjust_pos = 0.0;
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Rectangle textRect = new Rectangle(screenX - 1, screenY - 1, 3, 3);
        double[] upv1 = new double[3];
        double[] upv2 = new double[3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        if (this.isVerticalBar) {
            upv1 = this.transformObject.unProject(textRect.x, 0.0, 0.0, upv1);
            upv2 = this.transformObject.unProject(textRect.x + textRect.width, 0.0, 0.0, upv2);
            minX = Math.min(upv1[0], upv2[0]);
            maxX = Math.max(upv1[0], upv2[0]);
            minX -= this.widthFactor / 2.0;
            maxX += this.widthFactor / 2.0;
        } else {
            upv1 = this.transformObject.unProject(0.0, textRect.y, 0.0, upv1);
            upv2 = this.transformObject.unProject(0.0, textRect.y + textRect.height, 0.0, upv2);
            minY = Math.min(upv1[1], upv2[1]);
            maxY = Math.max(upv1[1], upv2[1]);
            minY -= this.widthFactor / 2.0;
            maxY += this.widthFactor / 2.0;
        }
        double respWidth = this.barWidth = this.fullBarWidth * this.widthFactor;
        this.barWidth *= this.widthFactor;
        for (int i = 0; i < catArray.length; ++i) {
            Double val;
            int catValue = this.categoryMapper.getIndex(catArray[i]);
            if (!this.isVerticalBar ? !((double)catValue >= minY) || !((double)catValue <= maxY) : !((double)catValue >= minX) || !((double)catValue <= maxX)) continue;
            if (this.allowMultiResponse && this.numberOfResponse > 1) {
                LinkedHashMap renderingData = (LinkedHashMap)this.renderingMRData.get(catArray[i]);
                barCenter = this.categoryMapper.getIndex(catArray[i]);
                Object[] respVars = renderingData.keySet().toArray();
                Object[] respVals = renderingData.values().toArray();
                for (int j = 0; j < respVars.length; ++j) {
                    respIndex = j;
                    ArrayList responselist = (ArrayList)respVals[j];
                    adjust_neg = 0.0;
                    adjust_pos = 0.0;
                    Object[] respArray = (Object[])responselist.get(responselist.size() - 1);
                    Double val2 = (Double)respArray[0];
                    if (val2 == 0.0 || Double.isNaN(val2)) continue;
                    if (val2 != null) {
                        respValue = val2;
                    }
                    if (respValue == 0.0 || Double.isNaN(respValue)) continue;
                    this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                    if (this.isVerticalBar) {
                        projectValues[0] = projectValues[0] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * respWidth;
                        projectValues[0] = projectValues[0] + respWidth / 2.0;
                        rect = new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                    } else {
                        projectValues[1] = projectValues[1] - ((double)this.numberOfResponse / 2.0 - (double)respIndex) * respWidth;
                        projectValues[1] = projectValues[1] + respWidth / 2.0;
                        rect = new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                    }
                    if (!rect.intersects(textRect)) continue;
                    Hashtable<Integer, Object> rc = new Hashtable<Integer, Object>();
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_URL, catArray[i]);
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, catArray[i]);
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_RESPONSE_VAR, respVars[j]);
                    return rc;
                }
                continue;
            }
            LinkedHashMap groupedData = (LinkedHashMap)this.renderingGroupedData.get(catArray[i]);
            Object[] grpKeyArray = ((Map)grpArray[i]).keySet().toArray();
            Object[] grpValuesArray = ((Map)grpArray[i]).values().toArray();
            if (grpVarIndex > -1) {
                for (int j = 0; j < grpKeyArray.length; ++j) {
                    int grpValue = ((Number)grpKeyArray[j]).intValue();
                    String grpValueStr = this.groupMapper.getValue(grpValue).toString();
                    int numberOfCluster = grpValuesArray.length;
                    ArrayList responseList = (ArrayList)groupedData.get(grpValueStr);
                    boolean clustered = false;
                    for (int k = 0; k < responseList.size() && !clustered; ++k) {
                        Object[] respArray = (Object[])responseList.get(k);
                        val = (Double)respArray[0];
                        if (this.groupDisplayType == 1) {
                            respArray = (Object[])responseList.get(responseList.size() - 1);
                            val = (Double)respArray[0];
                            clustered = true;
                        }
                        if (val == 0.0 || Double.isNaN(val)) continue;
                        if (val != null) {
                            respValue = val;
                        }
                        this.getProjectedBar(catValue, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                        if (grpVarIndex > -1 && this.groupDisplayType == 1) {
                            if (this.isVerticalBar) {
                                projectValues[0] = projectValues[0] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[0] = projectValues[0] + respWidth / 2.0;
                            } else {
                                projectValues[1] = projectValues[1] - ((double)numberOfCluster / 2.0 - (double)j) * respWidth;
                                projectValues[1] = projectValues[1] + respWidth / 2.0;
                            }
                            adjust_neg = 0.0;
                            adjust_pos = 0.0;
                        } else if (respValue >= 0.0) {
                            adjust_pos += respValue;
                        } else {
                            adjust_neg += respValue;
                        }
                        Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                        if (!rect.intersects(textRect)) continue;
                        Hashtable<Integer, Object> rc = new Hashtable<Integer, Object>();
                        rc.put(DrilldownEvent.DRILLDOWN_KEY_URL, catArray[i]);
                        rc.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, catArray[i]);
                        rc.put(DrilldownEvent.DRILLDOWN_KEY_GROUP, grpValuesArray[j]);
                        return rc;
                    }
                }
                continue;
            }
            ArrayList responseList = (ArrayList)this.renderingData.get(catArray[i]);
            barCenter = this.categoryMapper.getIndex(catArray[i]);
            adjust_neg = 0.0;
            adjust_pos = 0.0;
            Object[] respArray = (Object[])responseList.get(responseList.size() - 1);
            val = (Double)respArray[0];
            if (val == 0.0 || Double.isNaN(val)) continue;
            if (val != null) {
                respValue = val;
            }
            this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
            if (respValue >= 0.0) {
                adjust_pos += respValue;
            } else {
                adjust_neg += respValue;
            }
            Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
            if (!rect.intersects(textRect)) continue;
            Hashtable<Integer, Object> rc = new Hashtable<Integer, Object>();
            rc.put(DrilldownEvent.DRILLDOWN_KEY_URL, catArray[i]);
            rc.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, catArray[i]);
            return rc;
        }
        barCenter = this.categoryMapper.getIndex(this.OTHER_CATEGORY);
        if (barCenter > -1.0) {
            if (this.otherPosRespValue > 0.0) {
                adjust_neg = 0.0;
                adjust_pos = 0.0;
                respValue = this.otherPosRespValue;
                this.getProjectedBar(barCenter, this.otherPosRespValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    adjust_pos += respValue;
                } else {
                    adjust_neg += respValue;
                }
                if (rect.intersects(textRect)) {
                    Hashtable<Integer, ArrayList> rc = new Hashtable<Integer, ArrayList>();
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_URL, this.otherPosCatList);
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, this.otherPosCatList);
                    return rc;
                }
            }
            if (this.otherNegRespValue < 0.0) {
                adjust_neg = 0.0;
                adjust_pos = 0.0;
                respValue = this.otherNegRespValue;
                this.getProjectedBar(barCenter, respValue, adjust_pos, adjust_neg, projectValues, projectValues_1);
                Rectangle rectangle = rect = this.isVerticalBar ? new Rectangle((int)(projectValues[0] - this.barWidth / 2.0), (int)projectValues[1], (int)this.barWidth, (int)projectValues_1[1] - (int)projectValues[1]) : new Rectangle((int)projectValues[0], (int)(projectValues[1] - this.barWidth / 2.0), (int)projectValues_1[0] - (int)projectValues[0], (int)this.barWidth);
                if (respValue >= 0.0) {
                    adjust_pos += respValue;
                } else {
                    adjust_neg += respValue;
                }
                if (rect.intersects(textRect)) {
                    Hashtable<Integer, ArrayList> rc = new Hashtable<Integer, ArrayList>();
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_URL, this.otherNegCatList);
                    rc.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, this.otherNegCatList);
                    return rc;
                }
            }
        }
        return null;
    }

    protected void setOtherBarEnabled() {
        if (this.filter == null) {
            return;
        }
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        if (this.isMultipleResponseBar() || grpVarIndex > -1) {
            this.showOtherBar = false;
            RangeInfoModel rangeInfoModel = (RangeInfoModel)this.filter.getAdapter(RangeInfoModel.class);
            rangeInfoModel.invalidate();
        }
    }

    public boolean isUserShowRespStatOnAxis() {
        return this.userShowRespStatOnAxis;
    }

    public void setUserShowRespStatOnAxis(boolean userShowRespStatOnAxis) {
        this.userShowRespStatOnAxis = userShowRespStatOnAxis;
    }
}

