/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.bar;

import com.sas.graphics.silk.data.JavaDataFilter;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.BarDefaults;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public class BarModel
implements RoleInterface,
DataFilterListenerInterface {
    public static final int ROLE_CATEGORY = 0;
    public static final int ROLE_RESPONSE = 1;
    public static final int ROLE_GROUP = 2;
    public static final int ROLE_SUBGROUP = 3;
    public static final int ROLE_COLORINDEX = 4;
    public static final int ROLE_TIP = 5;
    public static final int ROLE_ERRORHIGH = 6;
    public static final int ROLE_ERRORLOW = 7;
    public static final int ROLE_FREQ = 8;
    public static final int NUM_ROLES = 9;
    public static final int ROLE_MULTI_RESPONSE = 9;
    public static final int STAT_SUM = 1;
    public static final int STAT_MEAN = 2;
    public static final int STAT_FREQ = 3;
    public static final int STAT_PERCENT = 4;
    public static final int SORT_DATA = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static String[] metaNames;
    protected DataFilterReadInterface dataIn;
    protected DataFilterWriteInterface dataOut;
    protected Object[] variables;
    protected Vector respVars;
    protected int respNo = 0;
    protected Hashtable discrete;
    protected Map categoryNames;
    protected Vector groupNames;
    protected Vector subgroupNames;
    protected Vector colorIndexNames;
    protected Vector tipNames;
    protected Vector errorHighNames;
    protected Vector errorLowNames;
    protected boolean[] obsSelected;
    protected int[] obsMapping;
    protected double[] selectedValues;
    protected boolean reSum;
    protected String missingSymbol;
    protected int statType;
    protected int sortType = 0;
    protected int[] sortMapping;
    protected Map sortedCategories;
    protected boolean reMapping;
    protected boolean sortMapped;
    protected boolean summarized;
    protected double userMin;
    protected double userMax;
    protected boolean userSetCategories;
    protected boolean userSetGroups;
    protected ResourceBundle rb;
    protected ArrayList currSelectedObs;
    protected boolean selectedAll;
    protected boolean outOfMemory;
    protected int xValueCount = 0;
    protected int actualXValueCount = 0;
    protected int responseSortType = 0;
    protected Map responseVals = null;
    protected Map responseValsABS = null;
    protected Map uniqueValueList = null;
    protected double totalFreqVal = 0.0;
    protected boolean absSort = false;
    protected static final Roles ROLES;
    private HashMap varColorMap = new HashMap();
    protected static final SILKNumber X_ROLE_NAME;
    protected static final SILKNumber Y_ROLE_NAME;
    protected static final SILKNumber CATEGORY_ROLE_NAME;
    protected static final SILKNumber RESPONSE_ROLE_NAME;
    protected static final SILKNumber SUBGROUP_ROLE_NAME;
    protected static final SILKNumber GROUP_ROLE_NAME;
    protected static final SILKNumber ERRORHIGH_ROLE_NAME;
    protected static final SILKNumber ERRORLOW_ROLE_NAME;
    protected static final SILKNumber TIP_ROLE_NAME;
    protected static final SILKNumber COLORINDEX_ROLE_NAME;
    protected static final SILKNumber FREQ_ROLE_NAME;
    protected int MAX_OBS_IN_MODEL = 100000;

    public BarModel(DataFilterReadInterface data) {
        this.discrete = new Hashtable();
        this.variables = new Object[9];
        this.respVars = new Vector();
        this.userMax = Double.NaN;
        this.userMin = Double.NaN;
        this.setDataSource(data);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.missingSymbol = "";
        metaNames = new String[3];
        BarModel.metaNames[0] = "Frequency";
        BarModel.metaNames[1] = "Observations";
        BarModel.metaNames[2] = "Selected";
        this.currSelectedObs = new ArrayList();
        this.selectedAll = false;
        BarDefaults barDefaults = new BarDefaults();
        if (barDefaults.maximumCombinations > 0) {
            this.MAX_OBS_IN_MODEL = barDefaults.maximumCombinations;
        }
        this.xValueCount = 0;
    }

    public BarModel() {
        this(null);
    }

    protected String getSortType() {
        if (this.sortType == 0) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data");
        }
        if (this.sortType == 1) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending");
        }
        if (this.sortType == 2) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending");
        }
        return null;
    }

    protected void setSortType(String sort) {
        this.responseSortType = 0;
        if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data"))) {
            this.sortType = 0;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending"))) {
            this.sortType = 1;
            this.reMapping = true;
            this.createSortMapping();
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending"))) {
            this.sortType = 2;
            this.reMapping = true;
            this.createSortMapping();
        }
    }

    protected String getResponseSortType() {
        if (this.responseSortType == 0) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data");
        }
        if (this.responseSortType == 1) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending");
        }
        if (this.responseSortType == 2) {
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending");
        }
        return null;
    }

    protected void setResponseSortType(String sort) {
        this.sortType = 0;
        if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data"))) {
            this.responseSortType = 0;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending"))) {
            this.responseSortType = 1;
        } else if (sort.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending"))) {
            this.responseSortType = 2;
        }
        this.reSum = true;
    }

    protected void setStatistic(int stat) {
        if (this.statType != stat) {
            this.statType = stat;
            if (this.dataOut != null) {
                if (this.statType == 3) {
                    SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                    this.dataOut.setFormat((Object)"Frequency", (Object)sf);
                } else {
                    SASFormat sf = SASFormat.getInstance((String)"BEST8.");
                    this.dataOut.setFormat((Object)"Frequency", (Object)sf);
                }
            }
        }
    }

    protected boolean isZeroObservation() {
        long obs = this.dataIn.getNumberObservations(-1);
        return obs <= 0L;
    }

    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    protected boolean isSummarized() {
        return this.summarized;
    }

    public boolean isMultiResponses() {
        return this.respNo > 1 && this.variables[2] == null && this.variables[3] == null;
    }

    protected boolean isUnselectedAll() {
        return this.selectedAll && !this.obsSelected[0];
    }

    protected ArrayList getCurrentSelectedObservations() {
        return this.selectedAll ? null : this.currSelectedObs;
    }

    protected double[] getSelectedValues() {
        return this.selectedValues;
    }

    protected int getNumberCategories() {
        return this.categoryNames.size();
    }

    protected int getNumberGroups() {
        return this.groupNames != null ? this.groupNames.size() : 0;
    }

    protected int getNumberSubgroups() {
        return this.subgroupNames.size();
    }

    protected int getNumberResponses() {
        return this.respVars.size();
    }

    public Vector getCategoryNames() {
        return new Vector(this.categoryNames.keySet());
    }

    protected Vector getGroupNames() {
        Vector<String> name = new Vector<String>(this.groupNames);
        if (name == null || name.size() == 0) {
            return name;
        }
        if (name.lastElement().equals(this.missingSymbol)) {
            name.setElementAt(".", name.size() - 1);
        }
        return name;
    }

    protected Vector getSubgroupNames() {
        return this.subgroupNames;
    }

    protected Vector getColorIndexNames() {
        return this.colorIndexNames;
    }

    protected Vector getResponseNames() {
        return this.respVars;
    }

    protected Vector getResponseDescriptions() {
        Vector<Object> desc = new Vector<Object>();
        for (int i = 0; i < this.respVars.size(); ++i) {
            Object vObj = this.respVars.elementAt(i);
            Object dObj = this.dataIn.getVariableDescription(vObj);
            if (dObj == null || ((String)dObj).equals("")) {
                desc.addElement(vObj);
                continue;
            }
            desc.addElement(dObj);
        }
        return desc;
    }

    protected Object getVariableDescription(Object role) {
        Object desc;
        Object varId = this.getVariable(role);
        if (role.toString().equals("Response") && varId == null) {
            varId = this.getVariable("Freq");
            if (varId != null) {
                Object desc2 = this.dataIn.getVariableDescription(varId);
                if (desc2 == null || ((String)desc2).equals("")) {
                    return varId;
                }
                return desc2;
            }
            if (this.statType == 4) {
                return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Percent.txt", (String)"Percent");
            }
            return ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Frequency.txt", (String)"Frequency");
        }
        String suffix = "";
        if (varId != null && role.toString().length() >= 8 && role.toString().substring(0, 8).equals("Response")) {
            if (this.summarized) {
                if (this.statType == 1) {
                    suffix = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Suffix.Sum.txt", (String)"(Sum)");
                } else if (this.statType == 2) {
                    suffix = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Suffix.Mean.txt", (String)"(Mean)");
                } else if (this.statType == 3) {
                    suffix = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Suffix.Frequency.txt", (String)"(Frequency)");
                } else if (this.statType == 4) {
                    suffix = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Suffix.Percent.txt", (String)"(Percent)");
                }
            }
            if (role.toString().equals("Response") && this.isMultiResponses()) {
                return suffix;
            }
        }
        if ((desc = this.dataIn.getVariableDescription(varId)) == null || ((String)desc).equals("")) {
            return varId + suffix;
        }
        return desc + suffix;
    }

    protected Object getVariableInModel(int roleIndex) {
        Object id = this.variables[roleIndex];
        if (id != null) {
            id = id.toString() + Integer.toString(roleIndex);
        }
        return id;
    }

    protected Object getVariableInModel(Object role) {
        int roleIndex = ((String)role).equalsIgnoreCase("Category") ? 0 : (((String)role).equalsIgnoreCase("Group") ? 2 : (((String)role).equalsIgnoreCase("Subgroup") ? 3 : (((String)role).equalsIgnoreCase("colorIndex") ? 4 : (((String)role).equalsIgnoreCase("tip") ? 5 : (((String)role).equalsIgnoreCase("ErrorHigh") ? 6 : (((String)role).equalsIgnoreCase("ErrorLow") ? 7 : 1))))));
        return this.getVariableInModel(roleIndex);
    }

    protected Object getResponseInModel(Object resp) {
        Object id = resp;
        if (id != null) {
            id = id.toString() + Integer.toString(1);
        }
        return id;
    }

    protected Object getRoleInModel(Object variable) {
        if (this.variables[1] == null && variable.equals("Frequency")) {
            return "Response";
        }
        Object[] roles = new Object[]{"Category", "Response", "Group", "Subgroup"};
        Object role = null;
        for (int i = 0; i < roles.length; ++i) {
            Object id = this.getVariableInModel(i);
            if (id == null || !id.equals(variable)) continue;
            role = roles[i];
            break;
        }
        return role;
    }

    public HashMap getColorIndexNamesByVariable(Object varId, Object colorIndexVariable) {
        Object obj = this.varColorMap.get(varId);
        if (obj == null) {
            HashMap<Object, Object> colorMap = new HashMap<Object, Object>();
            int obs = this.dataOut.getNumberObservations(-1);
            int varIndex = this.dataOut.getVariableIndex(varId);
            int clrIndex = this.dataOut.getVariableIndex(colorIndexVariable);
            for (int i = 0; i < obs; ++i) {
                Object xObj = this.dataOut.getValue(varIndex, (long)i);
                Object clrObj = this.dataOut.getValue(clrIndex, (long)i);
                if (xObj == null || clrObj == null) continue;
                colorMap.put(xObj, clrObj);
            }
            this.varColorMap.put(varId, colorMap);
            obj = colorMap;
        }
        return (HashMap)obj;
    }

    protected boolean doSummarization() {
        int i;
        if (!this.reSum) {
            return true;
        }
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (this.variables[0] == null) {
            return false;
        }
        this.outOfMemory = false;
        this.freeMemory();
        if (!this.userSetCategories) {
            this.categoryNames = this.getUniqueNames(this.variables[0]);
        }
        if (this.variables[2] != null) {
            if (!this.userSetGroups) {
                this.groupNames = new Vector(this.getUniqueNames(this.variables[2]).keySet());
            }
        } else {
            this.groupNames = null;
        }
        this.actualXValueCount = this.getNumberCategories();
        if (this.isMultiResponses()) {
            this.actualXValueCount = this.getNumberResponses() * this.getNumberCategories() + (this.getNumberCategories() - 1);
        } else if (this.groupNames != null) {
            int groups = this.getNumberGroups();
            this.actualXValueCount = this.getNumberCategories() * groups + (groups - 1);
        }
        if (this.isMultiResponses()) {
            return this.summarizeMultiResponses();
        }
        if (this.variables[3] != null) {
            this.subgroupNames = new Vector(this.getUniqueNames(this.variables[3]).keySet());
        }
        if (this.variables[5] != null) {
            int tmp = this.categoryNames.size() * (this.variables[2] != null ? this.groupNames.size() : 1) * (this.variables[3] != null ? this.subgroupNames.size() : 1);
            this.tipNames = new Vector();
            for (int i2 = 0; i2 < tmp; ++i2) {
                this.tipNames.addElement(null);
            }
        }
        this.varColorMap.clear();
        if (this.variables[4] != null) {
            this.colorIndexNames = new Vector(this.getUniqueNamesUnformatted(this.variables[4]).keySet());
            for (int i3 = 0; i3 < this.colorIndexNames.size(); ++i3) {
                if (this.colorIndexNames.elementAt(i3).equals(this.missingSymbol)) {
                    this.colorIndexNames.setElementAt(new Double(0.0), i3);
                    continue;
                }
                if (!(this.colorIndexNames.elementAt(i3) instanceof Number) || ((Number)this.colorIndexNames.elementAt(i3)).intValue() >= 0) continue;
                this.colorIndexNames.setElementAt(new Double(Math.abs(((Number)this.colorIndexNames.elementAt(i3)).intValue())), i3);
            }
        }
        if (this.variables[6] != null && this.subgroupNames != null) {
            this.errorHighNames = new Vector(this.getUniqueNames(this.variables[6]).keySet());
        }
        if (this.variables[7] != null && this.subgroupNames != null) {
            this.errorLowNames = new Vector(this.getUniqueNames(this.variables[7]).keySet());
        }
        int way = -1;
        int obs = 0;
        Object varId = this.variables[0];
        if (this.variables[2] == null && this.variables[3] == null) {
            obs = this.categoryNames.size();
            way = 0;
        } else if (this.variables[2] != null && this.variables[3] == null) {
            obs = this.categoryNames.size() * this.groupNames.size();
            way = 1;
        } else if (this.variables[2] == null && this.variables[3] != null) {
            obs = this.categoryNames.size() * this.subgroupNames.size();
            way = 1;
            varId = this.variables[3];
        } else if (this.variables[2] != null && this.variables[3] != null) {
            obs = this.categoryNames.size() * this.subgroupNames.size() * this.groupNames.size();
            way = 2;
            varId = this.variables[3];
        }
        Object[] uniqueValuesArray = ((DataFilterInfoInterface)this.dataIn).getUniqueValues(varId, false, this.MAX_OBS_IN_MODEL);
        if (uniqueValuesArray != null) {
            this.uniqueValueList = new LinkedHashMap();
            for (int j = 0; j < uniqueValuesArray.length; ++j) {
                this.uniqueValueList.put(uniqueValuesArray[j], new Integer(j));
            }
        } else {
            this.uniqueValueList = null;
        }
        if (obs > this.MAX_OBS_IN_MODEL) {
            this.outOfMemory = true;
            this.reSum = false;
            return false;
        }
        int numColumns = 0;
        for (int i4 = 0; i4 < this.variables.length; ++i4) {
            if (this.variables[i4] == null) continue;
            ++numColumns;
        }
        Object[] columnNames = new Object[numColumns + metaNames.length];
        this.dataOut = new JavaDataFilter();
        numColumns = 0;
        for (i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null) continue;
            this.dataOut.defineVariable(this.getVariableInModel(i), (Object)"", null);
            columnNames[numColumns] = this.getVariableInModel(i);
            ++numColumns;
        }
        for (i = 0; i < metaNames.length; ++i) {
            this.dataOut.defineVariable((Object)metaNames[i], (Object)"", null);
            columnNames[numColumns] = metaNames[i];
            ++numColumns;
        }
        for (i = 0; i < obs; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                this.dataOut.setValue(columnNames[j], -1L, null);
            }
        }
        this.selectedValues = new double[obs];
        for (i = 0; i < obs; ++i) {
            this.selectedValues[i] = 0.0;
        }
        switch (way) {
            case 0: {
                this.summarizeByCategory();
                break;
            }
            case 1: {
                this.summarizeByGroup();
                break;
            }
            case 2: {
                this.summarizeByGroupAndSubgroup();
            }
        }
        String fmt = null;
        if (this.variables[1] != null && (fmt = (String)this.dataIn.getFormat(this.variables[1], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat(this.getVariableInModel(1), (Object)fmt);
        }
        this.reSum = false;
        if (this.reMapping) {
            this.createSortMapping();
        }
        return true;
    }

    protected void createSortMapping() {
        if (this.categoryNames == null) {
            return;
        }
        int size = this.categoryNames.size();
        this.sortMapping = new int[size];
        if (this.responseVals == null || this.responseVals.size() != size || this.responseSortType == 0) {
            int i;
            this.sortedCategories = new TreeMap(this.categoryNames);
            Object[] objArray = this.sortedCategories.keySet().toArray();
            this.sortedCategories.clear();
            for (i = 0; i < size; ++i) {
                this.sortedCategories.put(objArray[i], new Integer(i));
            }
            objArray = this.categoryNames.keySet().toArray();
            for (i = 0; i < size; ++i) {
                this.sortMapping[i] = (Integer)this.sortedCategories.get(objArray[i]);
            }
        } else {
            LinkedHashMap sortedResponseVals = new LinkedHashMap();
            Collection c = CollectionSorter.getValues(this.absSort ? this.responseValsABS.values() : this.responseVals.values(), 1);
            Iterator iter = c.iterator();
            int num = 0;
            sortedResponseVals.clear();
            this.sortedCategories = new LinkedHashMap();
            this.sortedCategories.clear();
            while (iter.hasNext()) {
                sortedResponseVals.put(iter.next(), new Integer(num));
                ++num;
            }
            Object[] responseValsArray = this.absSort ? this.responseValsABS.values().toArray() : this.responseVals.values().toArray();
            Object[] catArray = this.categoryNames.keySet().toArray();
            Object[] sortedSumValsArray = sortedResponseVals.keySet().toArray();
            size = sortedResponseVals.size();
            int j = 0;
            for (int i = 0; i < size; ++i) {
                for (int k = 0; k < responseValsArray.length; ++k) {
                    if (!sortedSumValsArray[i].equals(responseValsArray[k])) continue;
                    this.sortMapping[k] = j;
                    this.sortedCategories.put(catArray[k], new Integer(j));
                    ++j;
                }
            }
        }
        this.reMapping = false;
        this.sortMapped = true;
    }

    protected int getSortedIndex(int dataIdx) {
        int sortedIdx = this.sortType == 1 || this.responseSortType == 1 ? this.sortMapping[dataIdx] : (this.sortType == 2 || this.responseSortType == 2 ? this.sortMapping.length - 1 - this.sortMapping[dataIdx] : dataIdx);
        return sortedIdx;
    }

    protected Vector getSortedCategoryNames() {
        Vector<Object> name = new Vector();
        if (this.responseSortType == 1) {
            name = new Vector(this.sortedCategories.keySet());
            if (name == null || name.size() == 0) {
                return name;
            }
            if (name.firstElement().equals(this.missingSymbol)) {
                name.setElementAt(".", 0);
            }
            return name;
        }
        if (this.responseSortType == 2) {
            int size = this.sortedCategories.size();
            Vector sortedVector = new Vector(this.sortedCategories.keySet());
            for (int i = 0; i < size; ++i) {
                name.addElement(sortedVector.elementAt(size - 1 - i));
            }
            if (name == null || name.size() == 0) {
                return name;
            }
            if (name.lastElement().equals(this.missingSymbol)) {
                name.setElementAt(".", name.size() - 1);
            }
            return name;
        }
        if (this.sortType == 0) {
            name = new Vector(this.categoryNames.keySet());
            if (name == null || name.size() == 0) {
                return name;
            }
            if (name.lastElement().equals(this.missingSymbol)) {
                name.setElementAt(".", name.size() - 1);
            }
            return name;
        }
        if (this.sortType == 1) {
            name = new Vector(this.sortedCategories.keySet());
            if (name == null || name.size() == 0) {
                return name;
            }
            if (name.firstElement().equals(this.missingSymbol)) {
                name.setElementAt(".", 0);
            }
            return name;
        }
        int size = this.sortedCategories.size();
        Vector sortedVector = new Vector(this.sortedCategories.keySet());
        for (int i = 0; i < size; ++i) {
            name.addElement(sortedVector.elementAt(size - 1 - i));
        }
        if (name == null || name.size() == 0) {
            return name;
        }
        if (name.lastElement().equals(this.missingSymbol)) {
            name.setElementAt(".", name.size() - 1);
        }
        return name;
    }

    protected boolean summarizeMultiResponses() {
        int i;
        int i2;
        int obs = this.categoryNames.size();
        this.responseVals = null;
        this.responseValsABS = null;
        if (obs > this.MAX_OBS_IN_MODEL) {
            this.outOfMemory = true;
            this.reSum = false;
            return false;
        }
        int respNum = this.respVars.size();
        int numColumns = 1 + respNum;
        Object[] columnNames = new Object[numColumns + metaNames.length];
        this.dataOut = new JavaDataFilter();
        numColumns = 0;
        this.dataOut.defineVariable(this.getVariableInModel(0), (Object)"", null);
        columnNames[numColumns] = this.getVariableInModel(0);
        ++numColumns;
        for (i2 = 0; i2 < respNum; ++i2) {
            Object v = this.respVars.elementAt(i2);
            this.dataOut.defineVariable(this.getResponseInModel(v), (Object)"", null);
            columnNames[numColumns] = this.getResponseInModel(v);
            ++numColumns;
        }
        for (i2 = 0; i2 < metaNames.length; ++i2) {
            this.dataOut.defineVariable((Object)metaNames[i2], (Object)"", null);
            columnNames[numColumns] = metaNames[i2];
            ++numColumns;
        }
        for (i2 = 0; i2 < obs; ++i2) {
            for (int j = 0; j < numColumns; ++j) {
                this.dataOut.setValue(columnNames[j], -1L, null);
            }
        }
        this.selectedValues = new double[obs];
        for (i2 = 0; i2 < obs; ++i2) {
            this.selectedValues[i2] = 0.0;
        }
        double[][] sum = new double[obs][respNum];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        int[][] nonMissing = new int[obs][respNum];
        for (int i3 = 0; i3 < obs; ++i3) {
            obsNo[i3] = new Vector();
            freq[i3] = 0.0;
            for (int j = 0; j < respNum; ++j) {
                sum[i3][j] = 0.0;
                nonMissing[i3][j] = 0;
            }
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int statId = -1;
        Object x = null;
        Object s = null;
        long rows = this.dataIn.getNumberObservations(-1);
        this.summarized = false;
        for (long i4 = 0L; i4 < rows; ++i4) {
            int index;
            x = this.dataIn.getValue(xId, i4);
            int n = index = this.getNameIndex(xId, this.categoryNames, x);
            freq[n] = freq[n] + 1.0;
            if (!this.summarized && freq[index] > 1.0) {
                this.summarized = true;
            }
            for (int j = 0; j < respNum; ++j) {
                Object v = this.respVars.elementAt(j);
                statId = this.dataIn.getVariableIndex(v);
                if (statId < 0 || this.isDiscrete(this.getRole(v)) || !this.dataIn.isNumericVariable(statId) || this.dataIn.isMissing(statId, s = this.dataIn.getValue(statId, i4))) continue;
                double[] dArray = sum[index];
                int n2 = j;
                dArray[n2] = dArray[n2] + ((Number)s).doubleValue();
                int[] nArray = nonMissing[index];
                int n3 = j;
                nArray[n3] = nArray[n3] + 1;
            }
            if (this.dataIn.isSelected(i4)) {
                this.obsSelected[(int)i4] = true;
                int n4 = index;
                this.selectedValues[n4] = this.selectedValues[n4] + 1.0;
            }
            obsNo[index].addElement(new Integer((int)i4));
            this.obsMapping[(int)i4] = index;
        }
        Object catName = this.getVariableInModel(0);
        Object[] respNames = new Object[respNum];
        Object[] catArray = this.categoryNames.keySet().toArray();
        for (i = 0; i < respNum; ++i) {
            respNames[i] = this.getResponseInModel(this.respVars.elementAt(i));
        }
        for (i = 0; i < obs; ++i) {
            int j;
            int size = obsNo[i].size();
            int[] obsArray = new int[size];
            for (j = 0; j < size; ++j) {
                obsArray[j] = (Integer)obsNo[i].elementAt(j);
            }
            this.dataOut.setValue(catName, (long)i, catArray[i]);
            for (j = 0; j < respNum; ++j) {
                Object v = this.respVars.elementAt(j);
                statId = this.dataIn.getVariableIndex(v);
                if (statId < 0 || nonMissing[i][j] <= 0) continue;
                double[] resp = new double[]{sum[i][j], nonMissing[i][j]};
                this.dataOut.setValue(respNames[j], (long)i, (Object)resp);
            }
            this.dataOut.setValue((Object)"Frequency", (long)i, (Object)new Double(freq[i]));
            this.dataOut.setValue((Object)"Observations", (long)i, (Object)obsArray);
        }
        String fmt = null;
        for (int i5 = 0; i5 < respNum; ++i5) {
            Object v = this.respVars.elementAt(i5);
            if (v == null || !this.dataIn.isNumericVariable(v) || (fmt = (String)this.dataIn.getFormat(v, String.class)) == null || fmt.equals("")) continue;
            this.dataOut.setFormat(this.getResponseInModel(v), (Object)fmt);
        }
        this.reSum = false;
        if (this.reMapping) {
            this.createSortMapping();
        }
        return true;
    }

    protected boolean summarizeByCategory() {
        int obs = this.categoryNames.size();
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        boolean[] missing = new boolean[obs];
        double[] errorHighs = new double[obs];
        double[] errorLows = new double[obs];
        int[] colorIndexs = new int[obs];
        for (int i = 0; i < obs; ++i) {
            obsNo[i] = new Vector();
            sum[i] = 0.0;
            freq[i] = 0.0;
            missing[i] = true;
            errorHighs[i] = 0.0;
            errorLows[i] = 0.0;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int tId = this.dataIn.getVariableIndex(this.variables[5]);
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        int cId = this.dataIn.getVariableIndex(this.variables[4]);
        Object tip = null;
        int eHId = this.dataIn.getVariableIndex(this.variables[6]);
        Object errorH = null;
        int eLId = this.dataIn.getVariableIndex(this.variables[7]);
        Object errorL = null;
        int statId = this.dataIn.getVariableIndex(this.variables[1]);
        Object x = null;
        Object s = null;
        Object clr = null;
        int index = -1;
        long rows = this.dataIn.getNumberObservations(-1);
        this.summarized = false;
        this.responseVals = new LinkedHashMap();
        this.responseVals.clear();
        this.responseValsABS = new LinkedHashMap();
        this.responseValsABS.clear();
        this.totalFreqVal = 0.0;
        for (long i = 0L; i < rows; ++i) {
            boolean addIn = true;
            x = this.dataIn.getValue(xId, i);
            index = this.getNameIndex(xId, this.categoryNames, x);
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, i);
                this.tipNames.setElementAt(tip, index);
            }
            if (cId >= 0) {
                clr = this.dataIn.getValue(cId, i);
                colorIndexs[index] = !this.dataIn.isMissing(cId, clr) ? (int)((Number)clr).doubleValue() : 0;
            }
            double freqVal = 1.0;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, i);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
            }
            if (statId >= 0 && !this.isDiscrete("Y") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, i);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n = index;
                    sum[n] = sum[n] + ((Number)s).doubleValue() * freqVal;
                    missing[index] = false;
                } else {
                    addIn = false;
                }
            }
            if (addIn) {
                int n = index;
                freq[n] = freq[n] + freqVal;
                this.totalFreqVal += freqVal;
                if (!this.summarized && freq[index] > 1.0) {
                    this.summarized = true;
                }
                if (this.dataIn.isSelected(i)) {
                    this.obsSelected[(int)i] = true;
                    int n2 = index;
                    this.selectedValues[n2] = this.selectedValues[n2] + freqVal;
                }
            }
            obsNo[index].addElement(new Integer((int)i));
            this.obsMapping[(int)i] = index;
            if (eHId >= 0) {
                errorH = this.dataIn.getValue(eHId, i);
                errorHighs[index] = ((Number)errorH).doubleValue();
            }
            if (eLId < 0) continue;
            errorL = this.dataIn.getValue(eLId, i);
            errorLows[index] = ((Number)errorL).doubleValue();
        }
        Object catName = this.getVariableInModel(0);
        Object respName = this.getVariableInModel(1);
        Object tName = this.getVariableInModel(5);
        Object cName = this.getVariableInModel(4);
        Object eHName = this.getVariableInModel(6);
        Object eLName = this.getVariableInModel(7);
        Object[] catArray = this.categoryNames.keySet().toArray();
        for (int i = 0; i < obs; ++i) {
            int size = obsNo[i].size();
            int[] obsArray = new int[size];
            for (int j = 0; j < size; ++j) {
                obsArray[j] = (Integer)obsNo[i].elementAt(j);
            }
            double resp = freq[i];
            if (this.statType == 4) {
                resp = freq[i] * 100.0 / this.getTotalFreqVal();
            }
            this.dataOut.setValue(catName, (long)i, catArray[i]);
            if (tId > -1) {
                this.dataOut.setValue(tName, (long)i, this.tipNames.elementAt(i));
            }
            if (cId >= 0) {
                this.dataOut.setValue(cName, (long)i, (Object)new Integer(Math.abs(colorIndexs[i])));
            }
            if (statId >= 0 && !missing[i]) {
                this.dataOut.setValue(respName, (long)i, (Object)new Double(sum[i]));
                resp = this.statType == 2 ? (freq[i] != 0.0 ? sum[i] / freq[i] : 0.0) : sum[i];
            }
            if (eHId > -1) {
                this.dataOut.setValue(eHName, (long)i, (Object)new Double(errorHighs[i]));
            }
            if (eLId > -1) {
                this.dataOut.setValue(eLName, (long)i, (Object)new Double(errorLows[i]));
            }
            this.dataOut.setValue((Object)"Frequency", (long)i, (Object)new Double(freq[i]));
            this.dataOut.setValue((Object)"Observations", (long)i, (Object)obsArray);
            this.responseVals.put(new Integer(i), new Double(resp));
            this.responseValsABS.put(new Integer(i), new Double(Math.abs(resp)));
        }
        if (this.responseSortType == 1 || this.responseSortType == 2) {
            this.reMapping = true;
        }
        return true;
    }

    protected boolean summarizeByGroup() {
        int byIndex = this.variables[2] == null ? 3 : 2;
        Object byVar = this.variables[2] == null ? this.variables[3] : this.variables[2];
        Vector byNames = this.variables[2] == null ? this.subgroupNames : this.groupNames;
        int obs = this.categoryNames.size() * byNames.size();
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        boolean[] missing = new boolean[obs];
        int[] colorIndexs = new int[obs];
        double[] errorHighs = new double[obs];
        double[] errorLows = new double[obs];
        for (int i = 0; i < obs; ++i) {
            obsNo[i] = new Vector();
            sum[i] = 0.0;
            freq[i] = 0.0;
            missing[i] = true;
            colorIndexs[i] = -1;
            errorHighs[i] = 0.0;
            errorLows[i] = 0.0;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        int gId = this.dataIn.getVariableIndex(byVar);
        int cId = byIndex == 3 ? this.dataIn.getVariableIndex(this.variables[4]) : -1;
        int statId = this.dataIn.getVariableIndex(this.variables[1]);
        int tId = this.dataIn.getVariableIndex(this.variables[5]);
        int eHId = this.dataIn.getVariableIndex(this.variables[6]);
        Object errorH = null;
        int eLId = this.dataIn.getVariableIndex(this.variables[7]);
        Object errorL = null;
        Object tip = null;
        Object x = null;
        Object g = null;
        Object s = null;
        Object clr = null;
        long rows = this.dataIn.getNumberObservations(-1);
        int namesPerGroup = this.categoryNames.size();
        int index = -1;
        this.summarized = false;
        this.responseVals = new LinkedHashMap();
        this.responseVals.clear();
        this.responseValsABS = new LinkedHashMap();
        this.responseValsABS.clear();
        this.totalFreqVal = 0.0;
        for (long i = 0L; i < rows; ++i) {
            boolean addIn = true;
            x = this.dataIn.getValue(xId, i);
            g = this.dataIn.getValue(gId, i);
            int xIdx = this.getNameIndex(xId, this.categoryNames, x);
            int gIdx = this.getNameIndex(gId, byNames, g);
            index = xIdx + gIdx * namesPerGroup;
            if (cId >= 0) {
                clr = this.dataIn.getValue(cId, i);
                colorIndexs[index] = !this.dataIn.isMissing(cId, clr) ? (int)((Number)clr).doubleValue() : 0;
            }
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, i);
                this.tipNames.setElementAt(tip, index);
            }
            double freqVal = 1.0;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, i);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
            }
            if (statId >= 0 && !this.isDiscrete("Y") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, i);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n = index;
                    sum[n] = sum[n] + ((Number)s).doubleValue() * freqVal;
                    missing[index] = false;
                } else {
                    addIn = false;
                }
            }
            if (addIn) {
                int n = index;
                freq[n] = freq[n] + freqVal;
                this.totalFreqVal += freqVal;
                if (!this.summarized && freq[index] > 1.0) {
                    this.summarized = true;
                }
                if (this.dataIn.isSelected(i)) {
                    this.obsSelected[(int)i] = true;
                    int n2 = index;
                    this.selectedValues[n2] = this.selectedValues[n2] + freqVal;
                }
            }
            obsNo[index].addElement(new Integer((int)i));
            this.obsMapping[(int)i] = index;
            if (eHId >= 0) {
                errorH = this.dataIn.getValue(eHId, i);
                errorHighs[index] = ((Number)errorH).doubleValue();
            }
            if (eLId < 0) continue;
            errorL = this.dataIn.getValue(eLId, i);
            errorLows[index] = ((Number)errorL).doubleValue();
        }
        Object catName = this.getVariableInModel(0);
        Object respName = this.getVariableInModel(1);
        Object gName = this.getVariableInModel(byIndex);
        Object cName = this.getVariableInModel(4);
        Object tName = this.getVariableInModel(5);
        Object eHName = this.getVariableInModel(6);
        Object eLName = this.getVariableInModel(7);
        Object[] catArray = this.categoryNames.keySet().toArray();
        int num = byNames.size();
        for (int i = 0; i < num; ++i) {
            for (int j = 0; j < namesPerGroup; ++j) {
                index = j + i * namesPerGroup;
                int size = obsNo[index].size();
                int[] obsArray = new int[size];
                for (int k = 0; k < size; ++k) {
                    obsArray[k] = (Integer)obsNo[index].elementAt(k);
                }
                this.dataOut.setValue(catName, (long)index, catArray[j]);
                if (tId > -1) {
                    this.dataOut.setValue(tName, (long)index, this.tipNames.elementAt(index));
                }
                this.dataOut.setValue(gName, (long)index, byNames.elementAt(i));
                if (cId >= 0 && colorIndexs[index] != -1) {
                    this.dataOut.setValue(cName, (long)index, (Object)new Integer(Math.abs(colorIndexs[index])));
                }
                if (eHId > -1) {
                    this.dataOut.setValue(eHName, (long)index, (Object)new Double(errorHighs[index]));
                }
                if (eLId > -1) {
                    this.dataOut.setValue(eLName, (long)index, (Object)new Double(errorLows[index]));
                }
                if (statId >= 0 && !missing[index]) {
                    this.dataOut.setValue(respName, (long)index, (Object)new Double(sum[index]));
                }
                this.dataOut.setValue((Object)"Frequency", (long)index, (Object)new Double(freq[index]));
                this.dataOut.setValue((Object)"Observations", (long)index, (Object)obsArray);
            }
        }
        double resp = 0.0;
        for (int i = 0; i < namesPerGroup; ++i) {
            resp = 0.0;
            for (int j = 0; j < num; ++j) {
                resp += freq[i + j * namesPerGroup];
            }
            this.responseVals.put(new Integer(i), new Double(resp));
            this.responseValsABS.put(new Integer(i), new Double(Math.abs(resp)));
        }
        if (this.responseSortType == 1 || this.responseSortType == 2) {
            this.reMapping = true;
        }
        return true;
    }

    protected boolean summarizeByGroupAndSubgroup() {
        int obs = this.categoryNames.size() * this.subgroupNames.size() * this.groupNames.size();
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        Vector[] obsNo = new Vector[obs];
        boolean[] missing = new boolean[obs];
        for (int i = 0; i < obs; ++i) {
            obsNo[i] = new Vector();
            sum[i] = 0.0;
            freq[i] = 0.0;
            missing[i] = true;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        int sId = this.dataIn.getVariableIndex(this.variables[3]);
        int gId = this.dataIn.getVariableIndex(this.variables[2]);
        int statId = this.dataIn.getVariableIndex(this.variables[1]);
        int tId = this.dataIn.getVariableIndex(this.variables[5]);
        Object tip = null;
        Object x = null;
        Object g = null;
        Object s = null;
        Object stat = null;
        long rows = this.dataIn.getNumberObservations(-1);
        int namesPerGroup = this.categoryNames.size();
        int subsPerCategory = this.subgroupNames.size();
        int index = -1;
        this.summarized = false;
        this.responseVals = null;
        this.responseValsABS = null;
        this.totalFreqVal = 0.0;
        for (long i = 0L; i < rows; ++i) {
            boolean addIn = true;
            x = this.dataIn.getValue(xId, i);
            s = this.dataIn.getValue(sId, i);
            g = this.dataIn.getValue(gId, i);
            int xIdx = this.getNameIndex(xId, this.categoryNames, x);
            int sIdx = this.getNameIndex(sId, this.subgroupNames, s);
            int gIdx = this.getNameIndex(gId, this.groupNames, g);
            index = xIdx + sIdx * namesPerGroup + gIdx * namesPerGroup * subsPerCategory;
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, i);
                this.tipNames.setElementAt(tip, index);
            }
            int freqVal = 1;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, i);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).intValue() >= 0 ? ((Number)s).intValue() : 0;
            }
            if (statId >= 0 && !this.isDiscrete("Y") && this.dataIn.isNumericVariable(statId)) {
                stat = this.dataIn.getValue(statId, i);
                if (!this.dataIn.isMissing(statId, stat)) {
                    int n = index;
                    sum[n] = sum[n] + ((Number)stat).doubleValue() * (double)freqVal;
                    missing[index] = false;
                } else {
                    addIn = false;
                }
            }
            if (addIn) {
                int n = index;
                freq[n] = freq[n] + (double)freqVal;
                this.totalFreqVal += (double)freqVal;
                if (!this.summarized && freq[index] > 1.0) {
                    this.summarized = true;
                }
                if (this.dataIn.isSelected(i)) {
                    this.obsSelected[(int)i] = true;
                    int n2 = index;
                    this.selectedValues[n2] = this.selectedValues[n2] + (double)freqVal;
                }
            }
            obsNo[index].addElement(new Integer((int)i));
            this.obsMapping[(int)i] = index;
        }
        Object catName = this.getVariableInModel(0);
        Object respName = this.getVariableInModel(1);
        Object gName = this.getVariableInModel(2);
        Object sName = this.getVariableInModel(3);
        Object tName = this.getVariableInModel(5);
        Object[] catArray = this.categoryNames.keySet().toArray();
        int num = this.groupNames.size();
        for (int i = 0; i < num; ++i) {
            for (int j = 0; j < subsPerCategory; ++j) {
                for (int k = 0; k < namesPerGroup; ++k) {
                    index = k + j * namesPerGroup + i * namesPerGroup * subsPerCategory;
                    int size = obsNo[index].size();
                    int[] obsArray = new int[size];
                    for (int l = 0; l < size; ++l) {
                        obsArray[l] = (Integer)obsNo[index].elementAt(l);
                    }
                    this.dataOut.setValue(catName, (long)index, catArray[k]);
                    if (tId > -1) {
                        this.dataOut.setValue(tName, (long)index, this.tipNames.elementAt(index));
                    }
                    this.dataOut.setValue(sName, (long)index, this.subgroupNames.elementAt(j));
                    this.dataOut.setValue(gName, (long)index, this.groupNames.elementAt(i));
                    if (statId >= 0 && !missing[index]) {
                        this.dataOut.setValue(respName, (long)index, (Object)new Double(sum[index]));
                    }
                    this.dataOut.setValue((Object)"Frequency", (long)index, (Object)new Double(freq[index]));
                    this.dataOut.setValue((Object)"Observations", (long)index, (Object)obsArray);
                }
            }
        }
        return true;
    }

    public Map getUniqueNames(Object varId) {
        if (varId == null) {
            return null;
        }
        LinkedHashMap<String, Integer> names = new LinkedHashMap<String, Integer>();
        int keyIndex = 0;
        int index = this.dataIn.getVariableIndex(varId);
        Object obj = null;
        String fmtV = null;
        for (long i = 0L; i < (long)this.dataIn.getNumberObservations(index); ++i) {
            obj = this.dataIn.getValue(index, i);
            fmtV = this.dataIn.getFormattedValue(varId, obj, null);
            if (names.containsKey(fmtV)) continue;
            names.put(fmtV, new Integer(keyIndex++));
        }
        return names;
    }

    protected Map getUniqueNamesUnformatted(Object varId) {
        if (varId == null) {
            return null;
        }
        LinkedHashMap<Object, Integer> names = new LinkedHashMap<Object, Integer>();
        int keyIndex = 0;
        int index = this.dataIn.getVariableIndex(varId);
        Object obj = null;
        for (long i = 0L; i < (long)this.dataIn.getNumberObservations(index); ++i) {
            obj = this.dataIn.getValue(index, i);
            if (names.containsKey(obj)) continue;
            names.put(obj, new Integer(keyIndex++));
        }
        return names;
    }

    protected int getNameIndex(int varId, Vector names, Object value) {
        value = this.dataIn.getFormattedValue(this.dataIn.getVariableId(varId), value, null);
        return names.indexOf(value);
    }

    protected int getNameIndex(int varId, Map names, Object value) {
        value = this.dataIn.getFormattedValue(this.dataIn.getVariableId(varId), value, null);
        return (Integer)names.get(value);
    }

    public boolean setSelection(int[] bars, boolean selected) {
        int num = 0;
        int len = bars.length;
        for (int i = 0; i < len; ++i) {
            int[] obsArray = (int[])this.dataOut.getValue((Object)"Observations", (long)bars[i]);
            num += obsArray.length;
        }
        int[] obs = new int[num];
        int idx = 0;
        for (int i = 0; i < len; ++i) {
            for (int obs[idx] : (int[])this.dataOut.getValue((Object)"Observations", (long)bars[i])) {
                ++idx;
            }
        }
        this.dataIn.setSelected((Object)obs, selected);
        return true;
    }

    public boolean setSelection(long i, boolean selected) {
        int[] obsNo = (int[])this.dataOut.getValue((Object)"Observations", i);
        this.dataIn.setSelected((Object)obsNo, selected);
        return true;
    }

    public boolean setSelectionAll(boolean selected) {
        if (!selected) {
            this.dataIn.unselectAll();
        } else {
            int rows = this.dataIn.getNumberObservations(-1);
            int[] obs = new int[rows];
            for (int i = 0; i < rows; ++i) {
                obs[i] = i;
            }
            this.dataIn.setSelected((Object)obs, selected);
        }
        return true;
    }

    protected double getMinimumValue_2(Object varId, long obs1, long obs2) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        if (!Double.isNaN(this.userMin)) {
            return this.userMin;
        }
        if (this.variables[3] != null && this.variables[2] == null) {
            return this.getMinMaxValues(varId, obs1, obs2, false)[1];
        }
        if (this.variables[3] != null && this.variables[2] != null) {
            return this.getMinMaxValues(varId, obs1, obs2, true)[1];
        }
        int idx = this.dataOut.getVariableIndex(varId);
        int fidx = this.statType == 2 ? this.dataOut.getVariableIndex((Object)"Frequency") : -1;
        double min = Double.MAX_VALUE;
        for (long i = obs1; i < obs2; ++i) {
            double f;
            double d;
            Object o = this.dataOut.getValue(idx, i);
            if (o instanceof double[]) {
                d = ((double[])o)[0];
                f = ((double[])o)[1];
                if (this.statType == 2) {
                    d = f != 0.0 ? d / f : 0.0;
                } else if (this.statType == 3) {
                    d = f;
                }
            } else {
                if (this.dataOut.isMissing(idx, o)) continue;
                d = ((Number)o).doubleValue();
                if (fidx >= 0) {
                    f = ((Number)this.dataOut.getValue(fidx, i)).doubleValue();
                    double d2 = d = f != 0.0 ? d / f : 0.0;
                }
            }
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public double getMinimumValue(Object varId, long obs1, long obs2) {
        if (varId != null) {
            return this.getMinimumValue_2(varId, obs1, obs2);
        }
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.respVars.size(); ++i) {
            Object v = this.getResponseInModel(this.respVars.elementAt(i));
            double mi = this.getMinimumValue_2(v, obs1, obs2);
            if (!(mi < min)) continue;
            min = mi;
        }
        return min;
    }

    public double getMinimumValue(Object varId) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        return this.getMinimumValue(varId, 0L, this.dataOut.getNumberObservations(-1));
    }

    protected double getMaximumValue_2(Object varId, long obs1, long obs2) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        if (!Double.isNaN(this.userMax)) {
            return this.userMax;
        }
        if (this.variables[3] != null && this.variables[2] == null) {
            return this.getMinMaxValues(varId, obs1, obs2, false)[0];
        }
        if (this.variables[3] != null && this.variables[2] != null) {
            return this.getMinMaxValues(varId, obs1, obs2, true)[0];
        }
        int idx = this.dataOut.getVariableIndex(varId);
        int fidx = this.statType == 2 ? this.dataOut.getVariableIndex((Object)"Frequency") : -1;
        double max = -1.7976931348623157E308;
        for (long i = obs1; i < obs2; ++i) {
            double f;
            double d;
            Object o = this.dataOut.getValue(idx, i);
            if (o instanceof double[]) {
                d = ((double[])o)[0];
                f = ((double[])o)[1];
                if (this.statType == 2) {
                    d = f != 0.0 ? d / f : 0.0;
                } else if (this.statType == 3) {
                    d = f;
                }
            } else {
                if (this.dataOut.isMissing(idx, o)) continue;
                d = ((Number)o).doubleValue();
                if (fidx >= 0) {
                    f = ((Number)this.dataOut.getValue(fidx, i)).doubleValue();
                    double d2 = d = f != 0.0 ? d / f : 0.0;
                }
            }
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public double getMaximumValue(Object varId, long obs1, long obs2) {
        if (varId != null) {
            return this.getMaximumValue_2(varId, obs1, obs2);
        }
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.respVars.size(); ++i) {
            Object v = this.getResponseInModel(this.respVars.elementAt(i));
            double ma = this.getMaximumValue_2(v, obs1, obs2);
            if (!(ma > max)) continue;
            max = ma;
        }
        return max;
    }

    public double getMaximumValue(Object varId) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        return this.getMaximumValue(varId, 0L, this.dataOut.getNumberObservations(-1));
    }

    protected double[] getMinMaxValues(Object varId, long cat1, long cat2, boolean grouped) {
        if (this.dataOut == null) {
            return null;
        }
        int idx = this.dataOut.getVariableIndex(varId);
        int fidx = this.statType == 2 ? this.dataOut.getVariableIndex((Object)"Frequency") : -1;
        int namesPerGroup = this.categoryNames.size();
        int subsPerCategory = this.subgroupNames.size();
        int nGroups = grouped ? this.groupNames.size() : 1;
        double[][] negative = new double[nGroups][namesPerGroup];
        double[][] positive = new double[nGroups][namesPerGroup];
        long rows = this.dataOut.getNumberObservations(-1);
        if (cat1 == 0L && cat2 == rows) {
            cat1 = 0L;
            cat2 = namesPerGroup * nGroups;
        }
        int i = 0;
        while ((long)i < rows) {
            Object o;
            int catIndex = i % namesPerGroup;
            int grpIndex = (int)((double)i / (double)(namesPerGroup * subsPerCategory));
            int index = catIndex + grpIndex * namesPerGroup;
            if ((long)index >= cat1 && (long)index < cat2 && !this.dataOut.isMissing(idx, o = this.dataOut.getValue(idx, (long)i))) {
                double d = ((Number)o).doubleValue();
                if (fidx >= 0) {
                    double f = ((Number)this.dataOut.getValue(fidx, (long)i)).doubleValue();
                    double d2 = d = f != 0.0 ? d / f : 0.0;
                }
                if (d > 0.0) {
                    double[] dArray = positive[grpIndex];
                    int n = catIndex;
                    dArray[n] = dArray[n] + d;
                } else if (d < 0.0) {
                    double[] dArray = negative[grpIndex];
                    int n = catIndex;
                    dArray[n] = dArray[n] + d;
                }
            }
            ++i;
        }
        double[] values = new double[2];
        values[1] = 0.0;
        values[0] = 0.0;
        for (int j = 0; j < nGroups; ++j) {
            for (int i2 = 0; i2 < namesPerGroup; ++i2) {
                values[0] = Math.max(values[0], positive[j][i2]);
                values[1] = Math.min(values[1], negative[j][i2]);
            }
        }
        return values;
    }

    protected double[] getMinMaxValues(Object varId, boolean grouped) {
        if (this.dataOut == null) {
            return null;
        }
        return this.getMinMaxValues(varId, 0L, this.dataOut.getNumberObservations(-1), grouped);
    }

    protected void setMinimumResponse(double min) {
        this.userMin = min;
    }

    protected void setMaximumResponse(double max) {
        this.userMax = max;
    }

    protected double getMinimumResponse() {
        if (this.dataOut == null) {
            this.getDataSource();
        }
        if (this.isMultiResponses()) {
            return this.getMinimumValue(null);
        }
        Object rVar = this.variables[1];
        rVar = rVar == null || this.statType == 3 ? "Frequency" : this.getVariableInModel(1);
        return this.getMinimumValue(rVar);
    }

    protected double getMaximumResponse() {
        if (this.dataOut == null) {
            this.getDataSource();
        }
        if (this.isMultiResponses()) {
            return this.getMaximumValue(null);
        }
        Object rVar = this.variables[1];
        rVar = rVar == null || this.statType == 3 ? "Frequency" : this.getVariableInModel(1);
        return this.getMaximumValue(rVar);
    }

    public void setCategoryNames(Object[] name) {
        if (this.categoryNames == null) {
            this.categoryNames = new LinkedHashMap();
        } else {
            this.categoryNames.clear();
        }
        boolean numeric = this.dataIn.isNumericVariable(this.variables[0]);
        for (int i = 0; i < name.length; ++i) {
            if (this.dataIn.isMissing(this.variables[0], name[i])) {
                if (numeric) {
                    this.categoryNames.put(new Double(Double.NaN), new Integer(i));
                    continue;
                }
                this.categoryNames.put(this.missingSymbol, new Integer(i));
                continue;
            }
            this.categoryNames.put(name[i], new Integer(i));
        }
        this.userSetCategories = true;
        this.reSum = true;
        this.reMapping = this.sortType != 0;
    }

    protected void setGroupNames(Object[] name) {
        if (this.groupNames == null) {
            this.groupNames = new Vector();
        } else {
            this.groupNames.removeAllElements();
        }
        for (int i = 0; i < name.length; ++i) {
            if (this.dataIn.isMissing(this.variables[2], name[i])) {
                this.groupNames.addElement(this.missingSymbol);
                continue;
            }
            this.groupNames.addElement(name[i]);
        }
        this.userSetGroups = true;
        this.reSum = true;
    }

    public Object getDataSource() {
        if (this.reSum) {
            this.doSummarization();
        }
        return this.dataOut;
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public boolean setDataSource(Object source) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        this.dataIn.addDataFilterListener((Object)this);
        return this.initFromData();
    }

    public boolean initFromData() {
        this.reSum = true;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || ((String)this.variables[i]).equals((String)this.dataIn.getExactVariableId(this.variables[i]))) continue;
            this.variables[i] = null;
        }
        int n = this.dataIn.getNumberObservations(-1);
        this.obsSelected = new boolean[n];
        this.obsMapping = new int[n];
        for (int i = 0; i < n; ++i) {
            this.obsSelected[i] = false;
            this.obsMapping[i] = -1;
        }
        this.userMax = Double.NaN;
        this.userMin = Double.NaN;
        this.userSetCategories = false;
        this.userSetGroups = false;
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    @Override
    public Object getAllVariables(Object role) {
        Object[] out = null;
        if (role instanceof Number && ((Number)role).intValue() != 17 && ((Number)role).intValue() != 25 || role instanceof String && !((String)role).equalsIgnoreCase("Response") && !((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) && !((String)role).equalsIgnoreCase("Y") && !((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString())) {
            return this.getVariable(role);
        }
        if (this.respVars == null || this.respVars.size() <= 0) {
            return null;
        }
        out = new Object[this.respVars.size()];
        if (out == null) {
            return null;
        }
        this.respVars.copyInto(out);
        return out;
    }

    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        int id = -1;
        id = this.getRoleID(role);
        if (id == -1) {
            if (role instanceof String && ((String)role).length() > 8 && (((String)role).substring(0, 8).equalsIgnoreCase("Response") || ((String)role).substring(0, 8).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
                String idxStr = ((String)role).substring(8);
                int idx = -1;
                try {
                    idx = Integer.parseInt(idxStr);
                    if (idx < 0 || idx >= this.respNo) {
                        return null;
                    }
                }
                catch (NumberFormatException e) {
                    return null;
                }
                return this.respVars.elementAt(idx);
            }
            return null;
        }
        return this.variables[id];
    }

    @Override
    public Object getRole(Object variableId) {
        SILKNumber obj;
        int i;
        int id = -1;
        for (i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || !this.variables[i].equals(variableId)) continue;
            id = i;
            break;
        }
        if (id < 0 && this.respNo > 1) {
            for (i = 0; i < this.respVars.size(); ++i) {
                Object v = this.respVars.elementAt(i);
                if (v == null || !v.equals(variableId)) continue;
                id = 9;
                break;
            }
        }
        switch (id) {
            default: {
                obj = null;
                break;
            }
            case 0: {
                obj = CATEGORY_ROLE_NAME;
                break;
            }
            case 1: {
                obj = RESPONSE_ROLE_NAME;
                break;
            }
            case 2: {
                obj = GROUP_ROLE_NAME;
                break;
            }
            case 3: {
                obj = SUBGROUP_ROLE_NAME;
                break;
            }
            case 4: {
                obj = COLORINDEX_ROLE_NAME;
                break;
            }
            case 5: {
                obj = TIP_ROLE_NAME;
                break;
            }
            case 6: {
                obj = ERRORHIGH_ROLE_NAME;
                break;
            }
            case 7: {
                obj = ERRORLOW_ROLE_NAME;
                break;
            }
            case 9: {
                obj = RESPONSE_ROLE_NAME;
                break;
            }
            case 8: {
                obj = FREQ_ROLE_NAME;
            }
        }
        return obj;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        int id;
        block20: {
            if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
                return false;
            }
            id = -1;
            id = this.getRoleID(role);
            if (id == -1) {
                if (role instanceof String && ((String)role).length() > 8 && (((String)role).substring(0, 8).equalsIgnoreCase("Response") || ((String)role).substring(0, 8).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
                    id = 9;
                    String idxStr = ((String)role).substring(8);
                    try {
                        int idx = Integer.parseInt(idxStr);
                        if (idx == 0) {
                            this.respNo = 0;
                        }
                        if (idx != this.respNo) {
                            return false;
                        }
                        break block20;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (variableId == null) {
            return false;
        }
        if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
            return false;
        }
        if (id == 4 && !this.dataIn.isNumericVariable(variableId)) {
            return false;
        }
        if (!(id != 1 && id != 9 || variableId == null || this.dataIn.isNumericVariable(variableId))) {
            return false;
        }
        if (id == 1) {
            this.respVars.removeAllElements();
            if (variableId != null) {
                this.respVars.addElement(variableId);
                this.respNo = 1;
            } else {
                this.respNo = 0;
            }
        }
        if (id == 9) {
            if (this.respNo == 0) {
                this.respNo = 1;
                this.respVars.removeAllElements();
                this.respVars.addElement(variableId);
                this.variables[1] = variableId;
            } else {
                this.respVars.addElement(variableId);
                ++this.respNo;
            }
        } else {
            this.variables[id] = this.dataIn.getExactVariableId(variableId);
        }
        this.reSum = true;
        if (id == 0) {
            this.sortMapped = false;
            this.reMapping |= this.sortType != 0;
        }
        if (id == 2 || id == 3) {
            this.responseSortType = 0;
        }
        this.userMax = Double.NaN;
        this.userMin = Double.NaN;
        this.userSetCategories = false;
        this.userSetGroups = false;
        return true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() != 17 && ((Number)role).intValue() != 25 || role instanceof String && !((String)role).equalsIgnoreCase("Response") && !((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) && !((String)role).equalsIgnoreCase("Y") && !((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString())) {
            return this.setRole(variableId, role);
        }
        if (variableId == null) {
            return false;
        }
        if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
            return false;
        }
        if (variableId != null && !this.dataIn.isNumericVariable(variableId)) {
            return false;
        }
        if (variableId != null) {
            for (int i = 0; i < this.respVars.size(); ++i) {
                if (!((String)this.respVars.elementAt(i)).equalsIgnoreCase((String)variableId)) continue;
                return false;
            }
            this.respVars.addElement(variableId);
            if (this.respNo == 0) {
                this.variables[1] = this.dataIn.getExactVariableId(variableId);
            }
            ++this.respNo;
        }
        this.reSum = true;
        this.userMax = Double.NaN;
        this.userMin = Double.NaN;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        int id = -1;
        id = this.getRoleID(role);
        if (id == -1) {
            return false;
        }
        if (this.variables[id] == null || !((String)this.variables[id]).equalsIgnoreCase((String)variableId)) {
            return false;
        }
        this.variables[id] = null;
        this.reSum = true;
        if (id == 0) {
            this.reMapping = true;
        }
        this.userMax = Double.NaN;
        this.userMin = Double.NaN;
        this.userSetCategories = false;
        this.userSetGroups = false;
        return true;
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (role == null) {
            return true;
        }
        String str = null;
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()))) {
            str = "X";
        } else if (role instanceof Number && (((Number)role).intValue() == 25 || ((Number)role).intValue() == 17) || role instanceof String && (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) {
            str = "Y";
        }
        if (str == null) {
            return false;
        }
        Boolean dis = (Boolean)this.discrete.get(str);
        if (dis != null) {
            return dis;
        }
        return false;
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (role == null) {
            return false;
        }
        String str = null;
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()))) {
            str = "X";
        } else if (role instanceof Number && (((Number)role).intValue() == 25 || ((Number)role).intValue() == 17) || role instanceof String && (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) {
            str = "Y";
        }
        if (str == null) {
            return false;
        }
        this.discrete.put(str, new Boolean(discrete));
        this.reSum = true;
        return true;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString())) {
            return null;
        }
        if (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase("Stat") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString())) {
            if (which == 0) {
                double val = this.getMinimumResponse();
                if (this.statType == 4) {
                    val *= 100.0 / this.getTotalFreqVal();
                }
                return new Double(val);
            }
            if (which == 1) {
                double val = this.getMaximumResponse();
                if (this.statType == 4) {
                    val *= 100.0 / this.getTotalFreqVal();
                }
                return new Double(val);
            }
            return null;
        }
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return -1;
    }

    @Override
    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        String str = null;
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X"))) {
            str = this.getSortType();
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data"))) {
                return new Integer(0);
            }
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending"))) {
                return new Integer(1);
            }
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending"))) {
                return new Integer(-1);
            }
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 25) || role instanceof String && (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) {
            str = this.getResponseSortType();
        }
        if (str != null) {
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data"))) {
                return new Integer(0);
            }
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending"))) {
                return new Integer(1);
            }
            if (str.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending"))) {
                return new Integer(-1);
            }
            return null;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X"))) {
            if (order instanceof Number && ((Number)order).intValue() == 0 || order instanceof String && ((String)order).equalsIgnoreCase("Data")) {
                this.setSortType("Data");
                return false;
            } else if (order instanceof Number && ((Number)order).intValue() == 1 || order instanceof String && ((String)order).equalsIgnoreCase("Ascending")) {
                this.setSortType("Ascending");
                if (this.sortMapped) return false;
                this.createSortMapping();
                return false;
            } else {
                if ((!(order instanceof Number) || ((Number)order).intValue() != -1) && (!(order instanceof String) || !((String)order).equalsIgnoreCase("Descending"))) return false;
                this.setSortType("Descending");
                if (this.sortMapped) return false;
                this.createSortMapping();
            }
            return false;
        } else {
            if ((!(role instanceof Number) || ((Number)role).intValue() != 17 && ((Number)role).intValue() != 25) && (!(role instanceof String) || !((String)role).equalsIgnoreCase("Response") && !((String)role).equalsIgnoreCase("Dependent") && !((String)role).equalsIgnoreCase("Y") && !((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) && !((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) return false;
            if (order instanceof Number && ((Number)order).intValue() == 0 || order instanceof String && ((String)order).equalsIgnoreCase("Data")) {
                this.setResponseSortType("Data");
                return false;
            } else if (order instanceof Number && ((Number)order).intValue() == 1 || order instanceof String && ((String)order).equalsIgnoreCase("Ascending")) {
                this.setResponseSortType("Ascending");
                return false;
            } else {
                if ((!(order instanceof Number) || ((Number)order).intValue() != -1) && (!(order instanceof String) || !((String)order).equalsIgnoreCase("Descending"))) return false;
                this.setResponseSortType("Descending");
            }
        }
        return false;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        if (role != null && role instanceof Number && ((Number)role).intValue() == 55) {
            return new Integer(this.MAX_OBS_IN_MODEL);
        }
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (role != null && role instanceof Number && ((Number)role).intValue() == 55 && value != null && value instanceof Number) {
            this.MAX_OBS_IN_MODEL = ((Number)value).intValue();
            return true;
        }
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.getVariableInModel("Group") == null && this.getVariableInModel("Subgroup") == null) {
            return new Object[][]{{ROLES.getRoleObject("ROLE_X"), ROLES.getRoleObject("ROLE_RESPONSE")}};
        }
        return new Object[][]{{ROLES.getRoleObject("ROLE_X")}};
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()))) {
            return new int[]{1, -1, 0};
        }
        if (role instanceof Number && (((Number)role).intValue() == 25 || ((Number)role).intValue() == 17) || role instanceof String && (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) {
            return new int[]{1, -1, 0};
        }
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (this.dataOut == null) {
            return;
        }
        switch (evt.type) {
            case 1: {
                this.reSum = true;
                this.dataOut.setSource(null);
                break;
            }
            case 3: {
                boolean matter = false;
                this.userSetCategories = false;
                block6: for (int i = evt.varStartIndex; i <= evt.varEndIndex; ++i) {
                    for (int j = 0; j < this.variables.length; ++j) {
                        if (this.variables[j] == null || this.dataIn.getVariableIndex(this.variables[j]) != i) continue;
                        this.reSum = true;
                        matter = true;
                        this.reMapping = this.sortType != 0;
                        break;
                    }
                    if (!this.isMultiResponses()) continue;
                    int size = this.respVars.size();
                    for (int j = 0; j < size; ++j) {
                        Object v = this.respVars.elementAt(j);
                        if (v == null || this.dataIn.getVariableIndex(v) != i) continue;
                        this.reSum = true;
                        matter = true;
                        continue block6;
                    }
                }
                if (!matter) break;
                this.dataOut.setSource(null);
                break;
            }
            case 5: {
                boolean matter = false;
                block9: for (int i = evt.varStartIndex; i <= evt.varEndIndex; ++i) {
                    for (int j = 0; j < this.variables.length; ++j) {
                        if (this.variables[j] == null || this.dataIn.getVariableIndex(this.variables[j]) != i) continue;
                        this.variables[j] = null;
                        this.reSum = true;
                        matter = true;
                        break;
                    }
                    if (!this.isMultiResponses()) continue;
                    int size = this.respVars.size();
                    for (int j = 0; j < size; ++j) {
                        Object v = this.respVars.elementAt(j);
                        if (v == null || this.dataIn.getVariableIndex(v) != i) continue;
                        this.respVars.removeElement(v);
                        this.reSum = true;
                        matter = true;
                        continue block9;
                    }
                }
                if (!matter) break;
                this.dataOut.setSource(null);
                break;
            }
            case 2: {
                if (evt.oldValue == null) {
                    if (this.dataIn.getNumberObservations(-1) <= 0) break;
                    boolean selected = this.dataIn.isSelected(0L);
                    this.processSelectionAll(selected);
                    this.selectedAll = true;
                } else {
                    int[] indicies = (int[])evt.oldValue;
                    for (int o = 0; o < indicies.length; ++o) {
                        this.processSelection(indicies[o]);
                    }
                }
                if (evt.isAdjusting) break;
                this.dataOut.setValue((Object)"Selected", 0L, (Object)new Double(1.0));
                this.currSelectedObs.clear();
                this.selectedAll = false;
            }
        }
        if (evt.type == 7) {
            this.dataOut.sendEvent((Object)new DvrDataFilterEvent(7));
        }
    }

    private void processSelection(int oo) {
        boolean selected;
        if (oo < 0 || oo >= this.dataIn.getNumberObservations(-1)) {
            return;
        }
        boolean bl = selected = this.dataIn.isSelected((long)oo);
        if (this.obsSelected[oo] == selected) {
            return;
        }
        this.obsSelected[oo] = selected;
        int obs = this.obsMapping[oo];
        if (obs == -1) {
            return;
        }
        Integer I = new Integer(obs);
        if (!this.currSelectedObs.contains(I)) {
            this.currSelectedObs.add(I);
        }
        double sValue = this.selectedValues[obs];
        double freqVal = 1.0;
        int fId = this.dataIn.getVariableIndex(this.variables[8]);
        if (fId >= 0) {
            Object s = this.dataIn.getValue(fId, (long)oo);
            freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
        }
        this.selectedValues[obs] = sValue = selected ? sValue + freqVal : sValue - freqVal;
    }

    private void processSelectionAll(boolean selected) {
        long rows = this.dataIn.getNumberObservations(-1);
        int i = 0;
        while ((long)i < rows) {
            this.obsSelected[i] = selected;
            ++i;
        }
        rows = this.dataOut.getNumberObservations(-1);
        if (!selected) {
            i = 0;
            while ((long)i < rows) {
                this.selectedValues[i] = 0.0;
                ++i;
            }
        } else {
            i = 0;
            while ((long)i < rows) {
                this.selectedValues[i] = ((Number)this.dataOut.getValue((Object)"Frequency", (long)i)).doubleValue();
                ++i;
            }
        }
    }

    protected void binarySearch(Vector values, Number obj) {
        double v = obj.doubleValue();
        int size = values.size();
        if (size == 0) {
            values.addElement(obj);
        } else {
            double mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (v < (mid_v = ((Number)values.elementAt(i = (left + right) / 2)).doubleValue())) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (v != mid_v && left <= right);
            if (v != mid_v) {
                int index = Math.max(left, right);
                values.insertElementAt(obj, index);
            }
        }
    }

    protected void binarySearch(Vector values, String obj) {
        int size = values.size();
        if (size == 0) {
            values.addElement(obj);
        } else {
            String mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (StringCompare.compareTo((String)obj, (String)(mid_v = (String)values.elementAt(i = (left + right) / 2))) < 0) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (StringCompare.compareTo((String)obj, (String)mid_v) != 0 && left <= right);
            if (StringCompare.compareTo((String)obj, (String)mid_v) != 0) {
                int index = Math.max(left, right);
                values.insertElementAt(obj, index);
            }
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    protected void freeMemory() {
        if (this.categoryNames != null && !this.userSetCategories) {
            this.categoryNames.clear();
        }
        if (this.groupNames != null && !this.userSetGroups) {
            this.groupNames.removeAllElements();
        }
        if (this.subgroupNames != null) {
            this.subgroupNames.removeAllElements();
        }
        if (this.colorIndexNames != null) {
            this.colorIndexNames.removeAllElements();
        }
        if (this.tipNames != null) {
            this.tipNames.removeAllElements();
        }
        if (this.dataOut != null) {
            this.dataOut = null;
        }
    }

    protected int getXValueCount() {
        return Math.max(this.actualXValueCount, this.xValueCount);
    }

    protected void setXValueCount(int count) {
        this.xValueCount = count;
    }

    protected int getXActualValueCount() {
        return this.actualXValueCount;
    }

    protected int getUniqueValueListIndex(Object key) {
        if (this.uniqueValueList != null && key != null) {
            Object val = this.uniqueValueList.get(key);
            int index = val instanceof Number ? ((Number)val).intValue() : 0;
            return index;
        }
        return 0;
    }

    protected int getRoleID(Object role) {
        if (role == null) {
            return -1;
        }
        int id = -1;
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(CATEGORY_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()))) {
            id = 0;
        } else if (role instanceof Number && (((Number)role).intValue() == 25 || ((Number)role).intValue() == 17) || role instanceof String && (((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase("Dependent") || ((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()))) {
            id = 1;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && (((String)role).equalsIgnoreCase("Group") || ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()))) {
            id = 2;
        } else if (role instanceof Number && ((Number)role).intValue() == 21 || role instanceof String && (((String)role).equalsIgnoreCase("Subgroup") || ((String)role).equalsIgnoreCase(SUBGROUP_ROLE_NAME.toString()))) {
            id = 3;
        } else if (role instanceof Number && ((Number)role).intValue() == 3 || role instanceof String && (((String)role).equalsIgnoreCase("ColorIndex") || ((String)role).equalsIgnoreCase("Color Index") || ((String)role).equalsIgnoreCase(COLORINDEX_ROLE_NAME.toString()))) {
            id = 4;
        } else if (role instanceof Number && ((Number)role).intValue() == 22 || role instanceof String && (((String)role).equalsIgnoreCase("Tip") || ((String)role).equalsIgnoreCase(TIP_ROLE_NAME.toString()))) {
            id = 5;
        } else if (role instanceof Number && ((Number)role).intValue() == 5 || role instanceof String && (((String)role).equalsIgnoreCase("Error High") || ((String)role).equalsIgnoreCase("ErrorHigh") || ((String)role).equalsIgnoreCase(ERRORHIGH_ROLE_NAME.toString()))) {
            id = 6;
        } else if (role instanceof Number && ((Number)role).intValue() == 4 || role instanceof String && (((String)role).equalsIgnoreCase("Error Low") || ((String)role).equalsIgnoreCase("ErrorLow") || ((String)role).equalsIgnoreCase(ERRORLOW_ROLE_NAME.toString()))) {
            id = 7;
        } else if (role instanceof Number && ((Number)role).intValue() == 70 || role instanceof String && (((String)role).equalsIgnoreCase("Freq") || ((String)role).equalsIgnoreCase(FREQ_ROLE_NAME.toString()))) {
            id = 8;
        }
        return id;
    }

    protected double getTotalFreqVal() {
        return this.totalFreqVal > 0.0 ? this.totalFreqVal : 1.0;
    }

    protected void setAbsoluteSort(boolean absoluteSort) {
        this.absSort = absoluteSort;
    }

    protected boolean isAbsoluteSort() {
        return this.absSort;
    }

    static {
        ROLES = Roles.getInstance(null);
        X_ROLE_NAME = ROLES.getRoleObject("ROLE_X");
        Y_ROLE_NAME = ROLES.getRoleObject("ROLE_Y");
        CATEGORY_ROLE_NAME = ROLES.getRoleObject("ROLE_CATEGORY");
        RESPONSE_ROLE_NAME = ROLES.getRoleObject("ROLE_RESPONSE");
        SUBGROUP_ROLE_NAME = ROLES.getRoleObject("ROLE_SUBGROUP");
        GROUP_ROLE_NAME = ROLES.getRoleObject("ROLE_GROUP");
        ERRORHIGH_ROLE_NAME = ROLES.getRoleObject("ROLE_ERROR_HIGH");
        ERRORLOW_ROLE_NAME = ROLES.getRoleObject("ROLE_ERROR_LOW");
        TIP_ROLE_NAME = ROLES.getRoleObject("ROLE_TIP");
        COLORINDEX_ROLE_NAME = ROLES.getRoleObject("ROLE_COLOR_INDEX");
        FREQ_ROLE_NAME = ROLES.getRoleObject("ROLE_FREQUENCY");
    }
}

