/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.bar;

import com.sas.graphics.silk.bar.BarModel;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.histogram.ChartInterface;
import com.sas.graphics.silk.interfaces.BarInterface;
import com.sas.graphics.silk.interfaces.BarPropertyInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FillPattern;
import com.sas.graphics.util.FontManager;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;

public class BarChart
implements GeometryInterface,
BarInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
DataFilterListenerInterface,
ChartInterface,
PropertyInterface,
BarPropertyInterface {
    protected static SILKNumber[] statName;
    public static final double EXTRA_SPACE = 0.02;
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected boolean chartBorderOn = false;
    protected boolean outlineOn = true;
    protected Color chartBorderColor;
    protected Color chartWallColor;
    protected Color selectionColor;
    protected Color outlineColor;
    protected BarModel barModel = null;
    protected DataFilterReadInterface dataIn = null;
    protected DataFilterReadInterface dataOut = null;
    protected ColorInterface colorRamp = null;
    protected TransformInterface transObj = null;
    protected LegendObject legend;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected Axes groupAxis = null;
    protected Object xVariable = null;
    protected Object yVariable = null;
    protected Object subgroupVariable = null;
    protected Object groupVariable = null;
    protected Object colorIndexVariable = null;
    protected Object tipVariable = null;
    protected Object errorHighVariable = null;
    protected Object errorLowVariable = null;
    protected int statistic = 1;
    protected int statistic2;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected Vector displayList;
    protected Vector selectionList;
    protected double[] selectedValues;
    protected Vector redrawListener;
    protected double scaleFactor = 0.85;
    protected boolean dataChanged = false;
    protected boolean dataPrepared = false;
    protected double baseValue = 0.0;
    protected double[] chartBBox = new double[6];
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle2D clipRect;
    protected Dimension chartAreaDimension;
    protected boolean fixedDataRange = true;
    protected boolean redraw = false;
    protected Color barColor;
    protected Color[] dataColors;
    protected boolean colorByChart = true;
    protected int chartType = 0;
    protected int axisLabelLength = 8;
    protected Vector propertyIndex;
    protected Vector propertyValue;
    protected ResourceBundle rb;
    protected Object[] legendValues;
    protected Roles roles;
    protected int numberDisplayBars = Integer.MAX_VALUE;
    protected int startDisplayBar = 1;
    protected int endDisplayBar = Integer.MAX_VALUE;
    protected boolean userSetDisplayBarRange = false;
    protected int numberBars;
    double[] xOffset = new double[2];
    double[] yOffset = new double[2];
    protected Graphics2D graphics2D;
    protected Insets outerMargin;
    protected Insets innerMargin;
    protected double respTickmarkOffset;
    protected boolean barLabel = false;
    protected Font barLabelFont;
    protected Color barLabelColor;
    protected int barLabelWidth = 0;
    protected AxisDefaults axisDefaults;
    protected GlobalDefaults globalDefaults;
    protected boolean gradient = true;
    protected boolean gradientDisable = false;
    protected Object categoryRole = null;
    protected Object responseSign = null;
    protected Object colorBy = null;
    protected Color colorPositive = null;
    protected Color colorNegative = null;
    protected boolean userSetSignColors = false;
    protected boolean abs = false;
    protected boolean isEngraved = true;
    protected Object legendVar = null;
    protected Style style = null;
    protected String styleElement = "GraphDataStyleDefault";
    protected int[] supportedProperties = new int[]{801, 802, 803, 804, 805, 807, 808, 809, 812, 814, 815, 816, 819};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(this.supportedProperties);

    public BarChart(Object dataObject) {
        this.globalDefaults = new GlobalDefaults();
        this.chartBorderColor = Color.black;
        this.outlineColor = Color.black;
        this.barColor = new Color(100, 100, 175);
        this.displayList = new Vector();
        this.selectionList = new Vector();
        this.redrawListener = new Vector();
        this.roles = Roles.getInstance(null);
        this.propertyIndex = new Vector();
        this.propertyValue = new Vector();
        this.setDataSource(dataObject);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.categoryRole = this.roles.getRoleObject("ROLE_CATEGORY");
        this.responseSign = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.ResponseSign.txt", (String)"Response Sign");
        statName = new SILKNumber[5];
        BarChart.statName[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.None.txt", (String)"None"), "None");
        BarChart.statName[1] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Sum.txt", (String)"Sum"), "Sum");
        BarChart.statName[2] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Mean.txt", (String)"Mean"), "Mean");
        BarChart.statName[3] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Frequency.txt", (String)"Frequency"), "Frequency");
        BarChart.statName[4] = new SILKNumber(4, ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Percent.txt", (String)"Percent"), "Percent");
        this.xOffset[1] = 0.0;
        this.xOffset[0] = 0.0;
        this.yOffset[1] = 0.0;
        this.yOffset[0] = 0.0;
        this.graphics2D = null;
        this.outerMargin = new Insets(0, 0, 0, 0);
        this.innerMargin = new Insets(0, 0, 0, 0);
        this.respTickmarkOffset = 0.0;
        this.axisDefaults = new AxisDefaults();
        this.barLabelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)12);
        this.barLabelColor = Color.BLACK;
    }

    public BarChart() {
        this(null);
    }

    public void setXAxis(Axes axis) {
        this.xAxis = axis;
    }

    public void setYAxis(Axes axis) {
        this.yAxis = axis;
    }

    public void setGroupAxis(Axes axis) {
        this.groupAxis = axis;
        if (this.chartAreaDimension != null) {
            this.groupAxis.setChartAreaDimension(this.chartAreaDimension);
        }
        this.dataPrepared = false;
    }

    public void setLegend(LegendObject leg) {
        this.legend = leg;
    }

    @Override
    public boolean isLegendRequired() {
        if (this.barModel == null) {
            return false;
        }
        return this.barModel.getVariable("Subgroup") != null || this.barModel.isMultiResponses() || this.barModel.getVariable("Group") != null || this.colorBy != null || this.barModel.getVariable("ColorIndex") != null;
    }

    @Override
    public boolean isDataChanged() {
        return this.dataChanged;
    }

    @Override
    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.xAxis.setChartAreaDimension(d);
        this.yAxis.setChartAreaDimension(d);
        if (this.groupAxis != null) {
            this.groupAxis.setChartAreaDimension(d);
        }
        this.setDefaultBarLabelFont();
    }

    public void setChartClipArea(Rectangle2D rect) {
        this.clipRect = rect;
        this.xAxis.setAxisLength(this.clipRect.getWidth());
        this.xAxis.setGridLineLength(this.clipRect.getHeight());
        this.yAxis.setAxisLength(this.clipRect.getHeight());
        this.yAxis.setGridLineLength(this.clipRect.getWidth());
        if (this.groupAxis != null) {
            if (this.chartType == 0) {
                this.groupAxis.setAxisLength(this.clipRect.getWidth());
            } else {
                this.groupAxis.setAxisLength(this.clipRect.getHeight());
            }
        }
    }

    @Override
    public Insets getOuterMargin(Graphics2D g) {
        Insets margin = new Insets(0, 0, 0, 0);
        this.graphics2D = g;
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return margin;
        }
        if (!this.prepareChartData()) {
            return margin;
        }
        this.setMargins();
        margin = this.outerMargin;
        return margin;
    }

    public Insets getInnerMargin() {
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return new Insets(0, 0, 0, 0);
        }
        if (!this.prepareChartData()) {
            return new Insets(0, 0, 0, 0);
        }
        this.setMargins();
        return this.innerMargin;
    }

    @Override
    public double getResponseAxisTickmarkOffset() {
        return this.respTickmarkOffset;
    }

    public int getCategoryAxisLabelOffset(Graphics2D g) {
        if (this.chartType == 0) {
            return Math.max(this.xAxis.getTickMarkValueHeight(g), this.xAxis.getLabelHeight(g));
        }
        return this.yAxis.getLeftWidth(g);
    }

    public double[] adjustYMinYMax() {
        if (this.barModel.isZeroObservation()) {
            double[] out = new double[]{0.0, 1.0};
            return out;
        }
        double[] ends = this.yAxis.getMinMaxTickMarkValues();
        if (ends[0] == ends[1]) {
            if (ends[1] >= 0.0) {
                ends[1] = ends[1] + 1.0;
            } else {
                ends[0] = ends[0] - 1.0;
            }
        }
        this.yMin = ends[0];
        this.yMax = ends[1];
        double[] out = new double[]{this.yMin, this.yMax};
        return out;
    }

    public double[] adjustXMinXMax() {
        if (this.barModel.isZeroObservation()) {
            double[] out = new double[]{0.0, 1.0};
            return out;
        }
        double[] ends = this.xAxis.getMinMaxTickMarkValues();
        if (ends[0] == ends[1]) {
            if (ends[1] >= 0.0) {
                ends[1] = ends[1] + 1.0;
            } else {
                ends[0] = ends[0] - 1.0;
            }
        }
        this.xMin = ends[0];
        this.xMax = ends[1];
        double[] out = new double[]{this.xMin, this.xMax};
        return out;
    }

    @Override
    public boolean isHighlightRequired() {
        return this.selectionList.size() > 0;
    }

    protected boolean prepareChartData() {
        TextStyleInterface tsi;
        double min;
        TextStyleInterface tsi2;
        double max;
        if (this.dataPrepared) {
            return true;
        }
        if (this.barModel == null) {
            return false;
        }
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataOut = (DataFilterReadInterface)this.barModel.getDataSource();
        if (this.dataOut == null) {
            return false;
        }
        this.dataOut.addDataFilterListener((Object)this);
        this.xVariable = this.barModel.getVariableInModel("Category");
        if (this.xVariable == null) {
            return false;
        }
        this.yVariable = this.barModel.getVariableInModel("Response");
        if (this.yVariable != null && !this.isDiscrete("Y") && this.statistic != 3) {
            this.statistic2 = this.statistic;
        } else {
            this.yVariable = "Frequency";
            this.statistic2 = 3;
        }
        if (this.statistic == 3 || this.statistic == 4) {
            this.yVariable = "Frequency";
            this.statistic2 = this.statistic == 4 ? 4 : 3;
        }
        this.barModel.setStatistic(this.statistic2);
        this.subgroupVariable = this.barModel.getVariableInModel("Subgroup");
        this.groupVariable = this.barModel.getVariableInModel("Group");
        this.errorHighVariable = null;
        this.errorLowVariable = null;
        if (this.subgroupVariable == null && !this.barModel.isMultiResponses()) {
            this.errorHighVariable = this.barModel.getVariableInModel("ErrorHigh");
            this.errorLowVariable = this.barModel.getVariableInModel("ErrorLow");
        }
        this.colorIndexVariable = this.barModel.getVariableInModel("ColorIndex");
        Object object = this.tipVariable = this.barModel.isMultiResponses() ? null : this.barModel.getVariableInModel("Tip");
        if (this.subgroupVariable != null) {
            this.baseValue = 0.0;
        } else {
            double min2;
            if (this.barModel.isMultiResponses() && this.statistic != 3) {
                min2 = this.barModel.getMinimumValue(null);
                max = this.barModel.getMaximumValue(null);
            } else {
                min2 = this.barModel.getMinimumValue(this.yVariable);
                max = this.barModel.getMaximumValue(this.yVariable);
            }
            if (min2 <= 0.0 && max > 0.0) {
                this.baseValue = 0.0;
            }
        }
        this.xAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
        this.yAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
        if (this.chartType == 0) {
            Vector names;
            this.yAxis.setRole(this.yVariable, "YAxis");
            this.yAxis.setBaseValue(this.baseValue);
            this.yAxis.setTickInCenter(false, 0.0);
            this.yAxis.setGroupAxis(false);
            if (this.statistic == 3) {
                SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                this.yAxis.setFormat(sf);
            } else {
                this.yAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
            }
            if (this.getVariable("Group") != null && this.getVariable("subgroup") == null) {
                this.xAxis.setRole(this.groupVariable, "GroupAxis");
                this.xAxis.setDirection(this.chartType == 0);
                names = this.barModel.getGroupNames();
                this.xAxis.setGroupAxis(true);
                this.xAxis.setNumberOfCategories(this.barModel.getNumberCategories());
                this.xAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.xAxis.setLabel(this.buildAxisLabel(true, "GroupAxis"));
                tsi2 = this.xAxis.getLabel();
                if (tsi2 instanceof TextAttrib) {
                    ((TextAttrib)tsi2).setCurrentValueAsDefault(9015);
                }
            } else {
                this.xAxis.setRole(this.xVariable, "XAxis");
                names = this.barModel.getSortedCategoryNames();
                if (this.getVariable("Group") != null && this.groupAxis != null) {
                    this.xAxis.setNumberOfGroups(this.barModel.getNumberGroups());
                } else {
                    this.xAxis.setNumberOfGroups(0);
                }
                this.xAxis.setGroupAxis(false);
                this.xAxis.setNumberOfResponses(this.barModel.isMultiResponses() ? this.barModel.getNumberResponses() : 0);
                this.xAxis.setTickInCenter(true, 0.0);
                this.xAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.xAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
                tsi2 = this.xAxis.getLabel();
                if (tsi2 instanceof TextAttrib) {
                    ((TextAttrib)tsi2).setCurrentValueAsDefault(9015);
                }
            }
            if (this.barModel.isMultiResponses()) {
                min = Math.min(0.0, this.barModel.getMinimumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
            } else {
                min = Math.min(0.0, this.barModel.getMinimumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
            }
            if (this.statistic == 4) {
                min = min * 100.0 / this.barModel.getTotalFreqVal();
                max = max * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (this.errorHighVariable != null) {
                max += this.barModel.getMaximumValue(this.errorHighVariable);
            }
            if (this.errorLowVariable != null) {
                min -= this.barModel.getMaximumValue(this.errorLowVariable);
            }
            if (this.abs) {
                min = Math.abs(min);
                max = Math.max(min, max);
                min = 0.0;
            }
            this.yAxis.setAxis(new Double(min), new Double(max), -1, -1, null, new Boolean(true), null);
            this.yAxis.setLabel(this.buildAxisLabel(false, "YAxis"));
            tsi = this.yAxis.getLabel();
            if (tsi instanceof TextAttrib) {
                ((TextAttrib)tsi).setCurrentValueAsDefault(9015);
            }
        } else {
            Vector names;
            this.xAxis.setRole(this.yVariable, "XAxis");
            this.xAxis.setBaseValue(this.baseValue);
            this.xAxis.setTickInCenter(false, 0.0);
            if (this.statistic == 3) {
                SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                this.xAxis.setFormat(sf);
            } else {
                this.xAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
            }
            if (this.getVariable("Group") != null && this.getVariable("subgroup") == null) {
                this.yAxis.setRole(this.groupVariable, "GroupAxis");
                names = this.barModel.getGroupNames();
                this.yAxis.setGroupAxis(true);
                this.yAxis.setNumberOfCategories(this.barModel.getNumberCategories());
                this.yAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.yAxis.setLabel(this.buildAxisLabel(true, "GroupAxis"));
                tsi2 = this.yAxis.getLabel();
                if (tsi2 instanceof TextAttrib) {
                    ((TextAttrib)tsi2).setCurrentValueAsDefault(9015);
                }
            } else {
                this.yAxis.setRole(this.xVariable, "YAxis");
                names = this.barModel.getSortedCategoryNames();
                if (this.getVariable("Group") != null && this.groupAxis != null) {
                    this.yAxis.setNumberOfGroups(this.barModel.getNumberGroups());
                } else {
                    this.yAxis.setNumberOfGroups(0);
                }
                this.yAxis.setGroupAxis(false);
                this.yAxis.setNumberOfResponses(this.barModel.isMultiResponses() ? this.barModel.getNumberResponses() : 0);
                this.yAxis.setTickInCenter(true, 0.0);
                this.yAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
                this.yAxis.setLabel(this.buildAxisLabel(true, "XAxis"));
                tsi2 = this.yAxis.getLabel();
                if (tsi2 instanceof TextAttrib) {
                    ((TextAttrib)tsi2).setCurrentValueAsDefault(9015);
                }
            }
            if (this.barModel.isMultiResponses()) {
                min = Math.min(0.0, this.barModel.getMinimumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(null, 0L, this.dataOut.getNumberObservations(-1)));
            } else {
                min = Math.min(0.0, this.barModel.getMinimumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                max = Math.max(0.0, this.barModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
            }
            if (this.statistic == 4) {
                min = min * 100.0 / this.barModel.getTotalFreqVal();
                max = max * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (this.errorHighVariable != null) {
                max += this.barModel.getMaximumValue(this.errorHighVariable);
            }
            if (this.errorLowVariable != null) {
                min -= this.barModel.getMaximumValue(this.errorLowVariable);
            }
            if (this.abs) {
                min = Math.abs(min);
                max = Math.max(min, max);
                min = 0.0;
            }
            this.xAxis.setAxis(new Double(min), new Double(max), -1, -1, null, new Boolean(true), null);
            this.xAxis.setLabel(this.buildAxisLabel(false, "YAxis"));
            tsi = this.xAxis.getLabel();
            if (tsi instanceof TextAttrib) {
                ((TextAttrib)tsi).setCurrentValueAsDefault(9015);
            }
        }
        this.xAxis.setDefaultLabelPosition(true);
        this.setMargins();
        if (this.getVariable("Group") != null && this.getVariable("subgroup") != null && this.groupAxis != null) {
            this.groupAxis.setDataSource((DataFilterReadInterface)this.barModel.getDataSource());
            this.groupAxis.setRole(this.groupVariable, "GroupAxis");
            this.groupAxis.setDirection(this.chartType == 0);
            this.groupAxis.setDefaultLabelPosition(false);
            Vector names = this.barModel.getGroupNames();
            this.groupAxis.setGroupAxis(true);
            this.groupAxis.setNumberOfCategories(this.barModel.getNumberCategories());
            this.groupAxis.setGridLines(new Boolean(false));
            this.groupAxis.setAxis(new Double(0.0), new Double(names.size() - 1), -1, -1, names.toArray(), null, null);
            this.groupAxis.setLabel(this.buildAxisLabel(true, "GroupAxis"));
            tsi2 = this.groupAxis.getLabel();
            if (tsi2 instanceof TextAttrib) {
                ((TextAttrib)tsi2).setCurrentValueAsDefault(9015);
            }
            this.groupAxis.getLine().setVisible(false);
            this.groupAxis.getMajorTicks().setVisible(false);
            if (this.chartType == 0) {
                this.groupAxis.setCollisionResolution(2);
            } else {
                this.groupAxis.setCollisionResolution(5);
            }
            if (this.chartType == 0) {
                this.xAxis.setDefaultLabelPosition(false);
            }
        }
        if (this.subgroupVariable != null || this.barModel.isMultiResponses() || this.groupVariable != null || this.colorBy != null || this.colorIndexVariable != null) {
            Object newLegendVar;
            Color[] colors;
            boolean isColorByResponse;
            Object varId = null;
            Vector items = null;
            String title = null;
            if (this.subgroupVariable != null) {
                varId = this.subgroupVariable;
                items = this.barModel.getSubgroupNames();
                title = (String)this.barModel.getVariableDescription("Subgroup");
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, (String)this.getVariable("Subgroup"));
            } else if (this.barModel.isMultiResponses()) {
                varId = null;
                items = this.barModel.getResponseDescriptions();
                title = null;
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, null);
            } else if (this.groupVariable != null) {
                varId = this.xVariable;
                items = this.barModel.getSortedCategoryNames();
                title = (String)this.barModel.getVariableDescription("Category");
                ((LegendObjectJ2D)this.legend).setData(this.dataIn, (String)this.getVariable("Category"));
            } else if (this.colorBy != null) {
                if (this.colorBy.equals(this.categoryRole) || this.colorBy.toString().equalsIgnoreCase("Category")) {
                    varId = this.xVariable;
                    items = this.barModel.getSortedCategoryNames();
                    title = (String)this.barModel.getVariableDescription("Category");
                    ((LegendObjectJ2D)this.legend).setData(this.dataIn, (String)this.getVariable("Category"));
                } else if (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign")) {
                    varId = this.yVariable;
                    items = new Vector();
                    items.add(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Minus.txt", (String)"-"));
                    items.add(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Plus.txt", (String)"+"));
                    title = (String)this.barModel.getVariableDescription("Response");
                }
            }
            boolean bl = isColorByResponse = this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"));
            if (this.colorIndexVariable != null && this.barModel.getColorIndexNames() != null && !isColorByResponse && this.groupVariable == null) {
                if (varId == null) {
                    varId = this.xVariable;
                }
                if (items == null) {
                    items = this.barModel.getSortedCategoryNames();
                }
                colors = new Color[items.size()];
                this.legendValues = new String[items.size()];
                HashMap map = this.barModel.getColorIndexNamesByVariable(varId, this.colorIndexVariable);
                for (int i = 0; i < items.size(); ++i) {
                    this.legendValues[i] = (String)items.get(i);
                    Integer colorValue = (Integer)map.get(this.legendValues[i]);
                    colors[i] = this.dataColors[colorValue % this.dataColors.length];
                }
            } else {
                int index;
                int size = items.size();
                this.legendValues = new Object[size];
                colors = new Color[size];
                if (this.barModel.isMultiResponses()) {
                    if (size > 0 && items.elementAt(0) instanceof Number) {
                        for (int i = 0; i < size; ++i) {
                            this.legendValues[i] = new Double(((Number)items.elementAt(i)).doubleValue());
                            String attrValueStr = this.legendValues[i].toString();
                            DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 2, this.style, this.styleElement, null).getAsDataStyle();
                            colors[i] = dse.getFillColor();
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            this.legendValues[i] = items.elementAt(i);
                            String attrValueStr = this.legendValues[i].toString();
                            DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.styleElement, null).getAsDataStyle();
                            colors[i] = dse.getFillColor();
                        }
                    }
                } else if (size > 0 && items.elementAt(0) instanceof Number) {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = new Double(((Number)items.elementAt(i)).doubleValue());
                        index = this.barModel.getUniqueValueListIndex(items.elementAt(i));
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                } else if (this.subgroupVariable != null || this.groupVariable != null) {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = items.elementAt(i);
                        index = this.barModel.getUniqueValueListIndex(items.elementAt(i));
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                } else if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                    this.legendValues[0] = items.elementAt(0);
                    this.legendValues[1] = items.elementAt(1);
                    colors[0] = this.colorNegative;
                    colors[1] = this.colorPositive;
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = items.elementAt(i);
                        index = this.barModel.getUniqueValueListIndex(items.elementAt(i));
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                }
            }
            this.legend.setLabel((SASFormat)this.dataOut.getFormat(varId, SASFormat.class));
            this.legend.setValues(colors, null, this.legendValues, null, false);
            Object object2 = newLegendVar = varId == null ? "multipleResponse" : varId;
            if (!newLegendVar.equals(this.legendVar)) {
                this.legendVar = newLegendVar;
                this.legend.setTitle(title);
                TextStyleInterface tsi3 = this.legend.getTitle();
                if (tsi3 instanceof TextAttrib) {
                    ((TextAttrib)tsi3).setCurrentValueAsDefault(9015);
                }
            }
            this.legend.setVisible(true);
            if (this.subgroupVariable == null && !this.barModel.isMultiResponses() && this.groupVariable == null && !this.colorByChart && this.colorIndexVariable == null) {
                this.legend.setVisible(false);
            }
        } else {
            this.legend.setValues(null, null, null, (boolean[])null, false);
            this.legend.setVisible(false);
            this.legendVar = null;
        }
        this.dataPrepared = true;
        return true;
    }

    protected boolean buildVerticalBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.xVariable);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        double x = 0.0;
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        double eH = 0.0;
        double eL = 0.0;
        BarElement e = null;
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double ht;
            double yo;
            Color color;
            DataStyleElement dse;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = this.barModel.getSortedIndex((int)i);
            y = (Double)yObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (y == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                String cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(xObj);
                String xValueStr = xObj.toString();
                dse = SILKUtilities.getStyleElement(xValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                color = y < 0.0 ? (this.colorNegative == null ? this.dataColors[0] : this.colorNegative) : (this.colorPositive == null ? this.dataColors[1] : this.colorPositive);
            }
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                y = Math.abs(y);
            }
            double xo = x + 0.5 - this.scaleFactor * 0.5;
            double wt = this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                yo = Math.max(y, this.baseValue);
                ht = Math.abs(y - this.baseValue);
            } else {
                yo = y >= 0.0 ? y : this.yMax;
                ht = y >= 0.0 ? y - this.yMin : this.yMax - y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                xo = x + 0.5;
                yo = y;
                line2D = new Line2D.Double(xo, yo, xo, yo + eH);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                xo = x + 0.5;
                yo = y;
                line2D = new Line2D.Double(xo, yo, xo, yo - eL);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    protected boolean buildHorizontalBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.xVariable);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        double x = 0.0;
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        double eH = 0.0;
        double eL = 0.0;
        BarElement e = null;
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double wt;
            double xo;
            Color color;
            DataStyleElement dse;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            x = (Double)xObj;
            y = this.barModel.getSortedIndex((int)i);
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (x == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                String cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(yObj);
                String yValueStr = yObj.toString();
                dse = SILKUtilities.getStyleElement(yValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            if (this.colorBy != null && (this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign"))) {
                color = x < 0.0 ? (this.colorNegative == null ? this.dataColors[0] : this.colorNegative) : (this.colorPositive == null ? this.dataColors[1] : this.colorPositive);
            }
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                x = Math.abs(x);
            }
            double yo = y + 0.5 + this.scaleFactor * 0.5;
            double ht = this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                xo = Math.min(x, this.baseValue);
                wt = Math.abs(x - this.baseValue);
            } else {
                xo = x >= 0.0 ? this.xMin : x;
                wt = x >= 0.0 ? x - this.xMin : this.xMax - x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                yo = y + 0.5;
                xo = x;
                line2D = new Line2D.Double(xo, yo, xo + eH, yo);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                yo = y + 0.5;
                xo = x;
                line2D = new Line2D.Double(xo, yo, xo - eL, yo);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    protected boolean buildVerticalSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int gIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        int x = 0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        double[] lastNY = new double[nCat];
        double[] lastPY = new double[nCat];
        int[] countNY = new int[nCat];
        int[] countPY = new int[nCat];
        for (int i = 0; i < nCat; ++i) {
            lastPY[i] = Double.isNaN(this.baseValue) ? this.yMin : this.baseValue;
            lastNY[i] = lastPY[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double ht;
            double yo;
            Color color;
            DataStyleElement dse;
            String cValueStr;
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object gObj = this.dataOut.getValue(gIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = (int)(i % (long)nCat);
            x = this.barModel.getSortedIndex(x);
            y = (Double)yObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (y == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(gObj);
                cValueStr = gObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                y = Math.abs(y);
            }
            double xo = (double)x + 0.5 - this.scaleFactor * 0.5;
            double wt = this.scaleFactor;
            if (y > 0.0) {
                int n = x;
                countPY[n] = countPY[n] + 1;
                if (countPY[x] > 1) {
                    this.gradientDisable = true;
                }
                lastPY[x] = yo = y + lastPY[x];
                ht = y;
            } else {
                int n = x;
                countNY[n] = countNY[n] + 1;
                if (countNY[x] > 1) {
                    this.gradientDisable = true;
                }
                yo = lastNY[x];
                lastNY[x] = yo + y;
                ht = -y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    protected boolean buildHorizontalSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int gIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int cIdx = this.dataOut.getVariableIndex(this.colorIndexVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double x = 0.0;
        double f = 0.0;
        double s = 0.0;
        int y = 0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        double[] lastNX = new double[nCat];
        double[] lastPX = new double[nCat];
        int[] countNX = new int[nCat];
        int[] countPX = new int[nCat];
        for (int i = 0; i < nCat; ++i) {
            lastPX[i] = Double.isNaN(this.baseValue) ? this.xMin : this.baseValue;
            lastNX[i] = lastPX[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double wt;
            double xo;
            Color color;
            DataStyleElement dse;
            String cValueStr;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object gObj = this.dataOut.getValue(gIdx, i);
            Object cObj = this.dataOut.getValue(cIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            y = (int)(i % (long)nCat);
            y = this.barModel.getSortedIndex(y);
            x = (Double)xObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (x == 0.0) continue;
            if (cObj != null) {
                int clrIndex = (Integer)cObj;
                cValueStr = cObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, clrIndex, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            } else {
                int index = this.barModel.getUniqueValueListIndex(gObj);
                cValueStr = gObj.toString();
                dse = SILKUtilities.getStyleElement(cValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
                color = dse.getFillColor();
            }
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                x = Math.abs(x);
            }
            double yo = (double)y + 0.5 + this.scaleFactor * 0.5;
            double ht = this.scaleFactor;
            if (x > 0.0) {
                int n = y;
                countPX[n] = countPX[n] + 1;
                if (countPX[y] > 1) {
                    this.gradientDisable = true;
                }
                xo = lastPX[y];
                lastPX[y] = xo + x;
                wt = x;
            } else {
                int n = y;
                countNX[n] = countNX[n] + 1;
                if (countNX[y] > 1) {
                    this.gradientDisable = true;
                }
                lastNX[y] = xo = lastNX[y] + x;
                wt = -x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private boolean buildVerticalGroupedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.xVariable);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        int x = 0;
        int g = 0;
        double eH = 0.0;
        double eL = 0.0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double ht;
            double yo;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = (int)(i % (long)nCat);
            x = this.barModel.getSortedIndex(x);
            g = (int)((double)i / (double)nCat);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            y = (Double)yObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (y == 0.0) continue;
            int index = this.barModel.getUniqueValueListIndex(xObj);
            String xValueStr = xObj.toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(xValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
            Color color = dse.getFillColor();
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                y = Math.abs(y);
            }
            double xo = (double)x + 0.5 - this.scaleFactor * 0.5;
            xo += (double)g * ((double)nCat + 1.0);
            double wt = this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                yo = Math.max(y, this.baseValue);
                ht = Math.abs(y - this.baseValue);
            } else {
                yo = y >= 0.0 ? y : this.yMax;
                ht = y >= 0.0 ? y - this.yMin : this.yMax - y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                xo = (double)x + 0.5;
                yo = y;
                line2D = new Line2D.Double(xo += (double)g * ((double)nCat + 1.0), yo, xo, yo + eH);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                xo = (double)x + 0.5;
                yo = y;
                line2D = new Line2D.Double(xo += (double)g * ((double)nCat + 1.0), yo, xo, yo - eL);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private boolean buildHorizontalGroupedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int yIdx = this.dataOut.getVariableIndex(this.xVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        int eHIdx = this.dataOut.getVariableIndex(this.errorHighVariable);
        int eLIdx = this.dataOut.getVariableIndex(this.errorLowVariable);
        double x = 0.0;
        double f = 0.0;
        double s = 0.0;
        int y = 0;
        int g = 0;
        double eH = 0.0;
        double eL = 0.0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        for (long i = 0L; i < obs; ++i) {
            Line2D.Double line2D;
            double wt;
            double xo;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            y = (int)(i % (long)nCat);
            y = this.barModel.getSortedIndex(y);
            g = (int)((double)i / (double)nCat);
            Object eHObj = this.dataOut.getValue(eHIdx, i);
            Object eLObj = this.dataOut.getValue(eLIdx, i);
            x = (Double)xObj;
            f = (Double)fObj;
            s = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (x == 0.0) continue;
            int index = this.barModel.getUniqueValueListIndex(yObj);
            String yValueStr = yObj.toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(yValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
            Color color = dse.getFillColor();
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                x = Math.abs(x);
            }
            double yo = (double)y + 0.5 + this.scaleFactor * 0.5;
            yo += (double)g * ((double)nCat + 1.0);
            double ht = this.scaleFactor;
            if (!Double.isNaN(this.baseValue)) {
                xo = Math.min(x, this.baseValue);
                wt = Math.abs(x - this.baseValue);
            } else {
                xo = x >= 0.0 ? this.xMin : x;
                wt = x >= 0.0 ? x - this.xMin : this.xMax - x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (eHObj != null && (eH = ((Double)eHObj).doubleValue()) > 0.0) {
                yo = (double)y + 0.5;
                xo = x;
                line2D = new Line2D.Double(xo, yo += (double)g * ((double)nCat + 1.0), xo + eH, yo);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (eLObj != null && (eL = ((Double)eLObj).doubleValue()) > 0.0) {
                yo = (double)y + 0.5;
                xo = x;
                line2D = new Line2D.Double(xo, yo += (double)g * ((double)nCat + 1.0), xo - eL, yo);
                e = new BarElement(line2D);
                this.displayList.addElement(e);
            }
            if (s == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private boolean buildVerticalGroupedSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable);
        int sIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double y = 0.0;
        double f = 0.0;
        double sel = 0.0;
        int x = 0;
        int g = 0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        int nSub = this.barModel.getNumberSubgroups();
        int nGrp = this.barModel.getNumberGroups();
        int len = nCat * nGrp;
        double[] lastNY = new double[len];
        double[] lastPY = new double[len];
        int[] countNY = new int[len];
        int[] countPY = new int[len];
        for (int i = 0; i < len; ++i) {
            lastPY[i] = Double.isNaN(this.baseValue) ? this.yMin : this.baseValue;
            lastNY[i] = lastPY[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double ht;
            double yo;
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object sObj = this.dataOut.getValue(sIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(yIdx, yObj)) continue;
            x = (int)(i % (long)nCat);
            x = this.barModel.getSortedIndex(x);
            g = (int)((double)i / (double)(nCat * nSub));
            y = (Double)yObj;
            f = (Double)fObj;
            sel = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = y = f != 0.0 ? y / f : 0.0;
            }
            if (this.statistic2 == 4) {
                y = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (y == 0.0) continue;
            int index = this.barModel.getUniqueValueListIndex(sObj);
            String sValueStr = sObj.toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(sValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
            Color color = dse.getFillColor();
            if (this.abs) {
                y = Math.abs(y);
            }
            e = new BarElement(color);
            this.displayList.addElement(e);
            double xo = (double)x + 0.5 - this.scaleFactor * 0.5;
            xo += (double)g * ((double)nCat + 1.0);
            double wt = this.scaleFactor;
            if (y > 0.0) {
                int n = x + g * nCat;
                countPY[n] = countPY[n] + 1;
                if (countPY[x + g * nCat] > 1) {
                    this.gradientDisable = true;
                }
                lastPY[x + g * nCat] = yo = y + lastPY[x + g * nCat];
                ht = y;
            } else {
                int n = x + g * nCat;
                countNY[n] = countNY[n] + 1;
                if (countNY[x + g * nCat] > 1) {
                    this.gradientDisable = true;
                }
                yo = lastNY[x + g * nCat];
                lastNY[x + g * nCat] = yo + y;
                ht = -y;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (sel == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(sel / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private boolean buildHorizontalGroupedSegmentedBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.yVariable);
        int sIdx = this.dataOut.getVariableIndex(this.subgroupVariable);
        int fIdx = this.dataOut.getVariableIndex((Object)"Frequency");
        double x = 0.0;
        double f = 0.0;
        double sel = 0.0;
        int y = 0;
        int g = 0;
        BarElement e = null;
        int nCat = this.barModel.getNumberCategories();
        int nSub = this.barModel.getNumberSubgroups();
        int nGrp = this.barModel.getNumberGroups();
        int len = nCat * nGrp;
        double[] lastNX = new double[len];
        double[] lastPX = new double[len];
        int[] countNX = new int[len];
        int[] countPX = new int[len];
        for (int i = 0; i < len; ++i) {
            lastPX[i] = Double.isNaN(this.baseValue) ? this.xMin : this.baseValue;
            lastNX[i] = lastPX[i];
        }
        for (long i = 0L; i < obs; ++i) {
            double wt;
            double xo;
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object sObj = this.dataOut.getValue(sIdx, i);
            Object fObj = this.dataOut.getValue(fIdx, i);
            if (this.dataOut.isMissing(xIdx, xObj)) continue;
            y = (int)(i % (long)nCat);
            y = this.barModel.getSortedIndex(y);
            g = (int)((double)i / (double)(nCat * nSub));
            x = (Double)xObj;
            f = (Double)fObj;
            sel = this.selectedValues[(int)i];
            if (this.statistic2 == 2) {
                double d = x = f != 0.0 ? x / f : 0.0;
            }
            if (this.statistic2 == 4) {
                x = f * 100.0 / this.barModel.getTotalFreqVal();
            }
            if (x == 0.0) continue;
            int index = this.barModel.getUniqueValueListIndex(sObj);
            String sValueStr = sObj.toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(sValueStr, index, 2, this.style, this.styleElement, null).getAsDataStyle();
            Color color = dse.getFillColor();
            e = new BarElement(color);
            this.displayList.addElement(e);
            if (this.abs) {
                x = Math.abs(x);
            }
            double yo = (double)y + 0.5 + this.scaleFactor * 0.5;
            yo += (double)g * ((double)nCat + 1.0);
            double ht = this.scaleFactor;
            if (x > 0.0) {
                int n = y + g * nCat;
                countPX[n] = countPX[n] + 1;
                if (countPX[y + g * nCat] > 1) {
                    this.gradientDisable = true;
                }
                xo = lastPX[y + g * nCat];
                lastPX[y + g * nCat] = xo + x;
                wt = x;
            } else {
                int n = y + g * nCat;
                countNX[n] = countNX[n] + 1;
                if (countNX[y + g * nCat] > 1) {
                    this.gradientDisable = true;
                }
                lastNX[y + g * nCat] = xo = lastNX[y + g * nCat] + x;
                wt = -x;
            }
            Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
            e = new BarElement(rect2D);
            this.displayList.addElement(e);
            e.obsNo = i;
            if (sel == 0.0) continue;
            Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(sel / f)};
            this.selectionList.addElement(tmp);
        }
        return true;
    }

    private boolean buildVerticalMultiRespBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int xIdx = this.dataOut.getVariableIndex(this.xVariable);
        int yIdx = -1;
        int tIdx = this.dataOut.getVariableIndex(this.tipVariable);
        double y = 0.0;
        double f = 0.0;
        double s = 0.0;
        int x = 0;
        BarElement e = null;
        int nResp = this.barModel.getNumberResponses();
        Vector resps = this.barModel.getResponseNames();
        for (long i = 0L; i < obs; ++i) {
            Object xObj = this.dataOut.getValue(xIdx, i);
            Object tObj = this.dataOut.getValue(tIdx, i);
            for (int j = 0; j < nResp; ++j) {
                double ht;
                double yo;
                Object yObj;
                yIdx = this.dataOut.getVariableIndex(this.barModel.getResponseInModel(resps.elementAt(j)));
                if (this.dataOut.isMissing(yIdx, yObj = this.dataOut.getValue(yIdx, i))) continue;
                x = this.barModel.getSortedIndex((int)i) * (nResp + 1) + j;
                y = ((double[])yObj)[0];
                f = ((double[])yObj)[1];
                s = this.selectedValues[(int)i];
                if (this.statistic2 == 2) {
                    y = f != 0.0 ? y / f : 0.0;
                } else if (this.statistic2 == 3) {
                    y = f;
                }
                if (y == 0.0) continue;
                String respValueStr = resps.get(j).toString();
                DataStyleElement dse = SILKUtilities.getStyleElement(respValueStr, j, 1, this.style, this.styleElement, null).getAsDataStyle();
                Color color = dse.getFillColor();
                e = new BarElement(color);
                this.displayList.addElement(e);
                if (this.abs) {
                    y = Math.abs(y);
                }
                double xo = (double)x + 0.5 - this.scaleFactor * 0.5;
                double wt = this.scaleFactor;
                if (!Double.isNaN(this.baseValue)) {
                    yo = Math.max(y, this.baseValue);
                    ht = Math.abs(y - this.baseValue);
                } else {
                    yo = y >= 0.0 ? y : this.yMax;
                    ht = y >= 0.0 ? y - this.yMin : this.yMax - y;
                }
                Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
                e = new BarElement(rect2D);
                this.displayList.addElement(e);
                e.description = this.getDescription(xObj, new Double(y), tObj, j);
                e.obsNo = i;
                if (s == 0.0) continue;
                Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
                this.selectionList.addElement(tmp);
            }
        }
        return true;
    }

    private boolean buildHorizontalMultiRespBarChart() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.xVariable);
        int xIdx = -1;
        int tIdx = this.dataOut.getVariableIndex(this.tipVariable);
        double x = 0.0;
        double f = 0.0;
        double s = 0.0;
        int y = 0;
        BarElement e = null;
        int nResp = this.barModel.getNumberResponses();
        Vector resps = this.barModel.getResponseNames();
        for (long i = 0L; i < obs; ++i) {
            Object yObj = this.dataOut.getValue(yIdx, i);
            Object tObj = this.dataOut.getValue(tIdx, i);
            for (int j = 0; j < nResp; ++j) {
                double wt;
                double xo;
                Object xObj;
                xIdx = this.dataOut.getVariableIndex(this.barModel.getResponseInModel(resps.elementAt(j)));
                if (this.dataOut.isMissing(xIdx, xObj = this.dataOut.getValue(xIdx, i))) continue;
                y = this.barModel.getSortedIndex((int)i) * (nResp + 1) + j;
                x = ((double[])xObj)[0];
                f = ((double[])xObj)[1];
                s = this.selectedValues[(int)i];
                if (this.statistic2 == 2) {
                    x = f != 0.0 ? x / f : 0.0;
                } else if (this.statistic2 == 3) {
                    x = f;
                }
                if (x == 0.0) continue;
                String respValueStr = resps.get(j).toString();
                DataStyleElement dse = SILKUtilities.getStyleElement(respValueStr, j, 1, this.style, this.styleElement, null).getAsDataStyle();
                Color color = dse.getFillColor();
                e = new BarElement(color);
                this.displayList.addElement(e);
                if (this.abs) {
                    x = Math.abs(x);
                }
                double yo = (double)y + 0.5 + this.scaleFactor * 0.5;
                double ht = this.scaleFactor;
                if (!Double.isNaN(this.baseValue)) {
                    xo = Math.min(x, this.baseValue);
                    wt = Math.abs(x - this.baseValue);
                } else {
                    xo = x >= 0.0 ? this.xMin : x;
                    wt = x >= 0.0 ? x - this.xMin : this.xMax - x;
                }
                Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
                e = new BarElement(rect2D);
                this.displayList.addElement(e);
                e.description = this.getDescription(yObj, new Double(x), tObj, j);
                e.obsNo = i;
                if (s == 0.0) continue;
                Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
                this.selectionList.addElement(tmp);
            }
        }
        return true;
    }

    protected String getDescription(Object x, Object y, Object t, int respIdx) {
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
        String role = "Response" + Integer.toString(respIdx);
        Object yVar = this.barModel.getResponseInModel(this.getVariable(role));
        String xstr = probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Category")), (Object)this.getValueLabel(this.xVariable, x));
        String ystr = "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription(role)), (Object)this.getValueLabel(yVar, y));
        String tstr = t == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Tip")), (Object)this.getValueLabel(this.tipVariable, t));
        return xstr + ystr + tstr;
    }

    protected String getDescription(Object x, Object y, Object s, Object g, Object t) {
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
        String xstr = probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Category")), (Object)this.getValueLabel(this.xVariable, x));
        String ystr = "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Response")), (Object)this.getValueLabel(this.yVariable, y));
        String sstr = s == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Subgroup")), (Object)this.getValueLabel(this.subgroupVariable, s));
        String gstr = g == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Group")), (Object)this.getValueLabel(this.groupVariable, g));
        String tstr = t == null ? "" : "\n" + probeMessage.toString((Object)((String)this.barModel.getVariableDescription("Tip")), (Object)this.getValueLabel(this.tipVariable, t));
        String str = xstr + ystr + sstr + gstr + tstr;
        str = str.replaceAll("=", "\t=\t");
        str = str.replaceAll("\\[", "\t \t\\[");
        return str;
    }

    protected String getValueLabel(Object variableId, Object value) {
        if (variableId == null) {
            return value.toString();
        }
        Object format = this.dataOut.getFormat(variableId, null);
        String label = value instanceof String && value.equals(this.barModel.missingSymbol) ? "." : this.dataOut.getFormattedValue(variableId, value, format);
        return label.trim();
    }

    @Override
    public boolean setSelection(Rectangle2D rect, boolean extend) {
        BarElement e;
        int i;
        Vector<Object> sel = new Vector<Object>();
        int size = this.displayList.size();
        if (extend) {
            for (i = 0; i < this.selectionList.size(); ++i) {
                sel.addElement(((Object[])this.selectionList.elementAt(i))[0]);
            }
            for (i = 0; i < size; ++i) {
                e = (BarElement)this.displayList.elementAt(i);
                if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !rect.intersects(e.projectedRect)) continue;
                Integer obj = new Integer(i);
                if (sel.contains(obj)) {
                    sel.removeElement(obj);
                    continue;
                }
                sel.addElement(obj);
            }
        } else {
            for (i = 0; i < size; ++i) {
                e = (BarElement)this.displayList.elementAt(i);
                if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !rect.intersects(e.projectedRect)) continue;
                sel.addElement(new Integer(i));
            }
        }
        boolean fire = false;
        if (this.selectionList.size() != sel.size()) {
            fire = true;
        } else {
            size = this.selectionList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int idx = (Integer)((Object[])this.selectionList.elementAt(i2))[0];
                double percent = (Double)((Object[])this.selectionList.elementAt(i2))[1];
                if ((Integer)sel.elementAt(i2) == idx && percent == 1.0) continue;
                fire = true;
                break;
            }
        }
        if (fire) {
            this.barModel.setSelectionAll(false);
            size = sel.size();
            if (size > 0) {
                int[] obs = new int[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    int n = (Integer)sel.elementAt(i3);
                    obs[i3] = (int)((BarElement)this.displayList.elementAt((int)n)).obsNo;
                }
                this.barModel.setSelection(obs, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSelection(int mouseX, int mouseY, boolean extend) {
        int index = this.getIndexOfDisplayList(mouseX, mouseY);
        if (extend) {
            if (index >= 0) {
                BarElement e = (BarElement)this.displayList.elementAt(index);
                boolean selected = false;
                for (int i = 0; i < this.selectionList.size(); ++i) {
                    if (index != (Integer)((Object[])this.selectionList.elementAt(i))[0]) continue;
                    selected = true;
                    break;
                }
                if (selected) {
                    this.barModel.setSelection(e.obsNo, false);
                } else {
                    this.barModel.setSelection(e.obsNo, true);
                }
            }
        } else {
            this.barModel.setSelectionAll(false);
            if (index >= 0) {
                BarElement e = (BarElement)this.displayList.elementAt(index);
                this.barModel.setSelection(e.obsNo, true);
            }
        }
    }

    public String getToolTipText(int mouseX, int mouseY) {
        if (!this.visible || this.dataOut == null) {
            return null;
        }
        String desc = null;
        int index = this.getIndexOfDisplayList(mouseX, mouseY);
        if (index >= 0) {
            BarElement e = (BarElement)this.displayList.elementAt(index);
            desc = e.description;
            if (desc == null) {
                Object xObj = this.dataOut.getValue(this.xVariable, e.obsNo);
                Object yObj = this.dataOut.getValue(this.yVariable, e.obsNo);
                Object fObj = this.dataOut.getValue((Object)"Frequency", e.obsNo);
                if (this.statistic2 == 4 && fObj != null) {
                    yObj = new Double((Double)fObj * 100.0 / this.barModel.getTotalFreqVal());
                }
                if (yObj != null && fObj != null && this.statistic2 == 2) {
                    double f = (Double)fObj;
                    double y = (Double)yObj;
                    y = f != 0.0 ? y / f : 0.0;
                    yObj = new Double(y);
                }
                Object sObj = this.dataOut.getValue(this.subgroupVariable, e.obsNo);
                Object gObj = this.dataOut.getValue(this.groupVariable, e.obsNo);
                Object tObj = this.dataOut.getValue(this.tipVariable, e.obsNo);
                desc = this.getDescription(xObj, yObj, sObj, gObj, tObj);
            }
        }
        return desc;
    }

    protected int getIndexOfDisplayList(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        int size = this.displayList.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            BarElement e = (BarElement)this.displayList.elementAt(i);
            if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !e.projectedRect.contains(mouseX, mouseY)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        this.displayList.removeAllElements();
        this.selectionList.removeAllElements();
        this.selectedValues = this.barModel.getSelectedValues();
        boolean rc = false;
        this.gradientDisable = false;
        if (this.chartType == 0) {
            if (this.barModel.isMultiResponses()) {
                rc = this.buildVerticalMultiRespBarChart();
            } else if (this.subgroupVariable == null && this.groupVariable == null) {
                rc = this.buildVerticalBarChart();
            } else if (this.subgroupVariable != null && this.groupVariable == null) {
                rc = this.buildVerticalSegmentedBarChart();
            } else if (this.subgroupVariable == null && this.groupVariable != null) {
                rc = this.buildVerticalGroupedBarChart();
            } else if (this.subgroupVariable != null && this.groupVariable != null) {
                rc = this.buildVerticalGroupedSegmentedBarChart();
            }
        } else if (this.barModel.isMultiResponses()) {
            rc = this.buildHorizontalMultiRespBarChart();
        } else if (this.subgroupVariable == null && this.groupVariable == null) {
            rc = this.buildHorizontalBarChart();
        } else if (this.subgroupVariable != null && this.groupVariable == null) {
            rc = this.buildHorizontalSegmentedBarChart();
        } else if (this.subgroupVariable == null && this.groupVariable != null) {
            rc = this.buildHorizontalGroupedBarChart();
        } else if (this.subgroupVariable != null && this.groupVariable != null) {
            rc = this.buildHorizontalGroupedSegmentedBarChart();
        }
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = this.graphics2D = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        FontRenderContext frc = g.getFontRenderContext();
        int size = this.displayList.size();
        LinkedHashMap<Integer, Double> labelVal = new LinkedHashMap<Integer, Double>();
        double upperLimit = this.chartType == 0 ? this.clipRect.getX() + this.clipRect.getWidth() : this.clipRect.getY() + this.clipRect.getHeight();
        Color clr = g.getColor();
        for (int i = 0; i < size; ++i) {
            BarElement e = (BarElement)this.displayList.elementAt(i);
            if (e.element instanceof Color) {
                clr = this.colorBy != null && (this.colorBy.equals(this.categoryRole) || this.colorBy.toString().equalsIgnoreCase("Category") || this.colorBy.equals(this.responseSign) || this.colorBy.toString().equalsIgnoreCase("Response Sign")) || this.subgroupVariable != null || this.colorIndexVariable != null || this.groupVariable != null || this.barModel.isMultiResponses() ? (Color)e.element : this.barColor;
                g.setColor(clr);
                continue;
            }
            if (e.element instanceof Rectangle2D.Double) {
                Rectangle2D.Double rect2D = (Rectangle2D.Double)e.element;
                e.projectedRect = null;
                if (this.chartType == 0 ? rect2D.x + 1.0 < Math.floor(this.xMin) || rect2D.x > Math.ceil(this.xMax) : rect2D.y < Math.floor(this.yMin) || rect2D.y - 1.0 > Math.ceil(this.yMax)) continue;
                double xVal1 = rect2D.x;
                double xVal2 = rect2D.x + rect2D.width;
                double yVal1 = rect2D.y;
                double yVal2 = rect2D.y - rect2D.height;
                if (this.transObj.isReverse(0)) {
                    xVal1 = rect2D.x + rect2D.width;
                    xVal2 = rect2D.x;
                }
                if (this.transObj.isReverse(1)) {
                    yVal1 = rect2D.y - rect2D.height;
                    yVal2 = rect2D.y;
                }
                this.transObj.project(xVal1, yVal1, 0.0, this.scr1);
                this.transObj.project(xVal2, yVal2, 0.0, this.scr2);
                e.projectedRect = new Rectangle2D.Double(this.scr1[0], this.scr1[1], this.scr2[0] - this.scr1[0], this.scr2[1] - this.scr1[1]);
                if (this.chartType == 0 && e.projectedRect.getWidth() < 1.5) {
                    g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr1[0], (int)this.scr2[1]);
                } else if (this.chartType == 1 && e.projectedRect.getHeight() < 1.5) {
                    g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr1[1]);
                } else {
                    if (!this.gradientDisable && this.gradient) {
                        GradientPaint gp;
                        Color bclr = ColorUtilities.brighter(clr, 0.2);
                        Color clr1 = clr;
                        Color clr2 = bclr;
                        if (this.chartType == 0) {
                            if (rect2D.y != 0.0 && !this.transObj.isReverse(1) || rect2D.y == 0.0 && this.transObj.isReverse(1)) {
                                clr1 = bclr;
                                clr2 = clr;
                            }
                            gp = new GradientPaint((float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr1[1], clr1, (float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr2[1], clr2);
                        } else {
                            if (rect2D.x < 0.0 && !this.transObj.isReverse(0) || rect2D.x >= 0.0 && this.transObj.isReverse(0)) {
                                clr1 = bclr;
                                clr2 = clr;
                            }
                            gp = new GradientPaint((float)this.scr1[0], (float)((this.scr2[1] - this.scr1[1]) / 2.0), clr1, (float)this.scr2[0], (float)((this.scr2[1] - this.scr1[1]) / 2.0), clr2);
                        }
                        g.setPaint(gp);
                    }
                    g.fill(e.projectedRect);
                    if (this.barLabel) {
                        double val;
                        Object tmpVal;
                        double dVal = 0.0;
                        if (this.chartType == 0) {
                            dVal = rect2D.y <= 0.0 ? -rect2D.height : rect2D.height;
                            tmpVal = null;
                            int catKey = (int)(this.scr1[0] + (this.scr2[0] - this.scr1[0]) / 2.0);
                            if (catKey > 0 && (double)catKey < upperLimit) {
                                if (dVal < 0.0) {
                                    catKey = -catKey;
                                }
                                if (labelVal.containsKey(new Integer(catKey)) && (tmpVal = labelVal.get(new Integer(catKey))) != null) {
                                    val = ((Number)tmpVal).doubleValue();
                                    dVal += val;
                                }
                                labelVal.put(new Integer(catKey), new Double(dVal));
                            }
                        } else {
                            dVal = rect2D.x < 0.0 ? -rect2D.width : rect2D.width;
                            tmpVal = null;
                            int catKey = (int)(this.scr1[1] + (this.scr2[1] - this.scr1[1]) / 2.0);
                            if (catKey > 0 && (double)catKey < upperLimit) {
                                if (dVal < 0.0) {
                                    catKey = -catKey;
                                }
                                if (labelVal.containsKey(new Integer(catKey)) && (tmpVal = labelVal.get(new Integer(catKey))) != null) {
                                    val = ((Number)tmpVal).doubleValue();
                                    dVal += val;
                                }
                                labelVal.put(new Integer(catKey), new Double(dVal));
                            }
                        }
                    }
                }
                if (!this.outlineOn || !(this.chartType == 0 && e.projectedRect.getWidth() >= 3.0) && (this.chartType != 1 || !(e.projectedRect.getHeight() >= 3.0))) continue;
                g.setColor(this.outlineColor);
                g.draw(e.projectedRect);
                continue;
            }
            if (!(e.element instanceof Line2D.Double)) continue;
            Line2D.Double line2D = (Line2D.Double)e.element;
            if (this.chartType == 0 ? line2D.x1 + 0.5 < Math.floor(this.xMin) || line2D.x1 - 0.5 > Math.ceil(this.xMax) : line2D.y1 + 0.5 < Math.floor(this.yMin) || line2D.y1 - 0.5 > Math.ceil(this.yMax)) continue;
            this.transObj.project(line2D.x1, line2D.y1, 0.0, this.scr1);
            this.transObj.project(line2D.x2, line2D.y2, 0.0, this.scr2);
            e.projectedLineH = new Line2D.Double(this.scr1[0], this.scr1[1], this.scr2[0], this.scr2[1]);
            g.setColor(this.outlineColor);
            g.draw(e.projectedLineH);
            if (this.chartType == 0) {
                e.projectedLineH.setLine(this.scr1[0] - 3.0, this.scr2[1], this.scr1[0] + 3.0, this.scr2[1]);
            } else {
                e.projectedLineH.setLine(this.scr2[0], this.scr2[1] - 3.0, this.scr2[0], this.scr2[1] + 3.0);
            }
            g.draw(e.projectedLineH);
        }
        if (this.barLabel && this.barLabelWidth > 0) {
            Object[] catArray = labelVal.keySet().toArray();
            Object[] labelValArray = labelVal.values().toArray();
            int xVal = 0;
            int yVal = 0;
            Object format = this.dataOut.getFormat(this.yVariable, SASFormat.class);
            double[] scr3 = new double[3];
            double[] scr4 = new double[3];
            boolean hide = false;
            for (int i = 0; i < catArray.length; ++i) {
                double rVal;
                String label = this.dataOut.getFormattedValue(this.yVariable, labelValArray[i], format);
                label = label.trim();
                TextLayout txtStr = new TextLayout(label, this.getBarLabelFont(), frc);
                hide = false;
                if (this.chartType == 0) {
                    xVal = Math.abs(((Number)catArray[i]).intValue()) - (int)(txtStr.getVisibleAdvance() / 2.0f);
                    rVal = ((Number)labelValArray[i]).doubleValue();
                    if (this.transObj.isReverse(0)) {
                        this.transObj.project(1.0, rVal, 0.0, scr3);
                        this.transObj.project(0.0, 0.0, 0.0, scr4);
                    } else {
                        this.transObj.project(0.0, rVal, 0.0, scr3);
                        this.transObj.project(1.0, 0.0, 0.0, scr4);
                    }
                    if ((double)txtStr.getVisibleAdvance() > scr4[0] - scr3[0]) {
                        hide = true;
                    } else {
                        xVal = Math.abs(((Number)catArray[i]).intValue()) - (int)(txtStr.getVisibleAdvance() / 2.0f);
                        int yAdjust = 0;
                        yAdjust = this.transObj.isReverse(1) ? (rVal < 0.0 ? -((int)txtStr.getDescent()) : this.getBarLabelFontSize()) : (rVal < 0.0 ? this.getBarLabelFontSize() : -((int)txtStr.getDescent()));
                        yVal = (int)scr3[1] + yAdjust;
                    }
                } else {
                    rVal = ((Number)labelValArray[i]).doubleValue();
                    if (this.transObj.isReverse(1)) {
                        this.transObj.project(rVal, 0.0, 0.0, scr3);
                        this.transObj.project(0.0, 1.0, 0.0, scr4);
                    } else {
                        this.transObj.project(rVal, 1.0, 0.0, scr3);
                        this.transObj.project(0.0, 0.0, 0.0, scr4);
                    }
                    if ((double)txtStr.getAscent() > scr4[1] - scr3[1]) {
                        hide = true;
                    } else {
                        yVal = Math.abs(((Number)catArray[i]).intValue()) + (int)(txtStr.getAscent() / 2.0f);
                        int xAdjust = 0;
                        xAdjust = this.transObj.isReverse(0) ? (rVal < 0.0 ? 2 : -((int)txtStr.getVisibleAdvance())) : (rVal < 0.0 ? -((int)txtStr.getVisibleAdvance()) : 2);
                        xVal = (int)scr3[0] + xAdjust;
                    }
                }
                if (hide) continue;
                if (this.isEngraved) {
                    g.setColor(ColorUtilities.brighter(this.chartWallColor));
                    txtStr.draw(g, xVal + 1, yVal + 1);
                }
                g.setColor(this.outlineColor);
                txtStr.draw(g, xVal, yVal);
            }
        }
        if (this.chartBorderOn) {
            g.setColor(this.chartBorderColor);
            this.transObj.project(this.xMin, this.yMin, 0.0, this.scr1);
            this.transObj.project(this.xMax, this.yMax, 0.0, this.scr2);
            g.drawRect((int)this.scr1[0], (int)this.scr2[1], (int)(this.scr2[0] - this.scr1[0]), (int)(this.scr1[1] - this.scr2[1]));
        }
        if (!Double.isNaN(this.baseValue)) {
            Object obj = null;
            if (this.chartType == 0) {
                this.transObj.project(this.xMin, this.baseValue, 0.0, this.scr1);
                this.transObj.project(this.xMax, this.baseValue, 0.0, this.scr2);
                obj = this.xAxis.getPropertyValue(201);
            } else {
                this.transObj.project(this.baseValue, this.yMin, 0.0, this.scr1);
                this.transObj.project(this.baseValue, this.yMax, 0.0, this.scr2);
                obj = this.yAxis.getPropertyValue(201);
            }
            Line2D.Double line = new Line2D.Double(this.scr1[0], this.scr1[1], this.scr2[0], this.scr2[1]);
            g.setColor(obj instanceof Color ? (Color)obj : Color.black);
            g.draw(line);
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    @Override
    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = this.graphics2D = (Graphics2D)p;
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        TexturePaint tp = null;
        if (!this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
            FillPattern fillPattern = new FillPattern();
            tp = fillPattern.getHatch45(this.selectionColor);
        }
        int size = this.selectionList.size();
        for (int i = 0; i < size; ++i) {
            int index = (Integer)((Object[])this.selectionList.elementAt(i))[0];
            double percent = (Double)((Object[])this.selectionList.elementAt(i))[1];
            percent = Math.min(1.0, percent);
            BarElement e = (BarElement)this.displayList.elementAt(index);
            if (e.projectedRect == null) continue;
            double x = 0.0;
            double y = 0.0;
            double w = 0.0;
            double h = 0.0;
            if (this.chartType == 0) {
                x = e.projectedRect.getX();
                y = e.projectedRect.getY() + e.projectedRect.getHeight() * (1.0 - percent);
                w = e.projectedRect.getWidth();
                h = e.projectedRect.getHeight() * percent;
            } else {
                x = e.projectedRect.getX();
                y = e.projectedRect.getY();
                w = e.projectedRect.getWidth() * percent;
                h = e.projectedRect.getHeight();
            }
            Rectangle2D.Double highlightedRect = new Rectangle2D.Double(x, y, w, h);
            g.setColor(this.selectionColor);
            if (this.chartType == 0 && e.projectedRect.getWidth() < 1.5) {
                g.drawLine((int)x, (int)y, (int)x, (int)(y + h));
                continue;
            }
            if (this.chartType == 1 && e.projectedRect.getHeight() < 1.5) {
                g.drawLine((int)x, (int)y, (int)(x + w), (int)y);
                continue;
            }
            if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
                g.fill(highlightedRect);
                if (!this.outlineOn || !(this.chartType == 0 && e.projectedRect.getWidth() >= 3.0) && (this.chartType != 1 || !(e.projectedRect.getHeight() >= 3.0))) continue;
                g.setColor(this.outlineColor);
                g.draw(e.projectedRect);
                continue;
            }
            g.setPaint(tp);
            g.fill(highlightedRect);
            g.setPaint(this.selectionColor);
            g.draw(highlightedRect);
        }
        g.setStroke(oldStroke);
    }

    public Object getDataSource() {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public boolean setDataSource(Object source) {
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.dataIn = (DataFilterReadInterface)source;
        if (this.barModel == null) {
            this.barModel = new BarModel();
        }
        if (this.barModel != null) {
            this.barModel.setDataSource(this.dataIn);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return true;
    }

    public boolean setDataSource(Object source, Object id) {
        return false;
    }

    @Override
    public Object getAllVariables(Object role) {
        if (this.barModel == null) {
            return null;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatisticObject();
        }
        return this.barModel.getAllVariables(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.barModel == null) {
            return null;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatisticObject();
        }
        return this.barModel.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.barModel == null) {
            return null;
        }
        if (variableId instanceof Number) {
            if (this.chartType == 0) {
                return ((Number)variableId).intValue() == -3 ? "Category" : (((Number)variableId).intValue() == -4 ? "Response" : null);
            }
            return ((Number)variableId).intValue() == -3 ? "Response" : (((Number)variableId).intValue() == -4 ? "Category" : null);
        }
        return this.barModel.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.barModel == null || role == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            this.setStatistic(variableId.toString());
            this.barModel.setMaximumResponse(Double.NaN);
            this.barModel.setMinimumResponse(Double.NaN);
            return true;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.barModel.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.barModel == null || role == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            this.setStatistic(variableId.toString());
            this.barModel.setMaximumResponse(Double.NaN);
            this.barModel.setMinimumResponse(Double.NaN);
            return true;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.barModel.addRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.barModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.barModel.removeRole(variableId, role);
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.barModel == null) {
            return false;
        }
        return this.barModel.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.barModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        return this.barModel.setDiscrete(role, discrete);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.barModel == null) {
            return null;
        }
        return this.barModel.getRoleValue(role, which);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] rolesObj = discrete ? new Object[]{this.roles.getRoleObject("ROLE_CATEGORY"), this.roles.getRoleObject("ROLE_FREQUENCY"), this.roles.getRoleObject("ROLE_RESPONSE"), this.roles.getRoleObject("ROLE_GROUP"), this.roles.getRoleObject("ROLE_SUBGROUP"), this.roles.getRoleObject("ROLE_COLOR_INDEX"), this.roles.getRoleObject("ROLE_TIP"), this.roles.getRoleObject("ROLE_ERROR_HIGH"), this.roles.getRoleObject("ROLE_ERROR_LOW")} : new Object[]{this.roles.getRoleObject("ROLE_FREQUENCY"), this.roles.getRoleObject("ROLE_RESPONSE"), this.roles.getRoleObject("ROLE_COLOR_INDEX"), this.roles.getRoleObject("ROLE_ERROR_HIGH"), this.roles.getRoleObject("ROLE_ERROR_LOW")};
        return rolesObj;
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        if (role instanceof String && (((String)role).equals("Response") || ((String)role).equals(this.roles.getRoleNLSName("ROLE_RESPONSE"))) || role instanceof Number && ((Number)role).intValue() == 17) {
            return 100;
        }
        return 1;
    }

    @Override
    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        if (this.barModel != null) {
            return this.barModel.getSortOrder(role);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.barModel == null || order == null || role == null) {
            return false;
        }
        if (role instanceof Number && (((Number)role).intValue() == 24 || ((Number)role).intValue() == 1) || role instanceof String && (((String)role).equalsIgnoreCase("Category") || ((String)role).equalsIgnoreCase("Independent") || ((String)role).equalsIgnoreCase("X"))) {
            if (order instanceof Number && ((Number)order).intValue() == 0 || order instanceof String && ((String)order).equalsIgnoreCase("Data")) {
                this.setSortType("Data");
                return false;
            } else if (order instanceof Number && ((Number)order).intValue() == 1 || order instanceof String && ((String)order).equalsIgnoreCase("Ascending")) {
                this.setSortType("Ascending");
                return false;
            } else {
                if ((!(order instanceof Number) || ((Number)order).intValue() != -1) && (!(order instanceof String) || !((String)order).equalsIgnoreCase("Descending"))) return false;
                this.setSortType("Descending");
            }
            return false;
        } else {
            if ((!(role instanceof Number) || ((Number)role).intValue() != 17 && ((Number)role).intValue() != 25) && (!(role instanceof String) || !((String)role).equalsIgnoreCase("Response") && !((String)role).equalsIgnoreCase("Dependent") && !((String)role).equalsIgnoreCase("Y"))) return false;
            this.barModel.setSortOrder(role, order);
            this.dataChanged = true;
            this.dataPrepared = false;
            this.rebuildRequired = true;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
        return false;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        if (this.barModel == null) {
            return null;
        }
        return this.barModel.getLimit(role);
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (this.barModel == null) {
            return false;
        }
        return this.barModel.setLimit(role, value);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.barModel == null) {
            return null;
        }
        return this.barModel.getSupportedSortableRoles();
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.barModel == null || role == null) {
            return null;
        }
        return this.barModel.getSupportedSortDirections(role);
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public Object getTransformObject() {
        return this.transObj;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transObj = (TransformInterface)transIn;
        return true;
    }

    @Override
    public double[] getBoundingBox() {
        if (!this.dataChanged) {
            return this.chartBBox;
        }
        if (!this.prepareChartData()) {
            return null;
        }
        if (this.barModel.isZeroObservation()) {
            this.yMin = 0.0;
            this.xMin = 0.0;
            this.yMax = 1.0;
            this.xMax = 1.0;
            this.chartBBox[0] = this.xMin;
            this.chartBBox[1] = this.yMin;
            this.chartBBox[2] = 0.0;
            this.chartBBox[3] = this.xMax;
            this.chartBBox[4] = this.yMax;
            this.chartBBox[5] = 0.0;
            return this.chartBBox;
        }
        if (this.chartType == 0) {
            this.xMin = 0.0;
            this.xMax = this.barModel.getXValueCount();
            this.numberBars = (int)this.xMax;
            double[] ends = this.yAxis.getMinMaxTickMarkValues();
            if (ends[0] == ends[1]) {
                if (ends[1] >= 0.0) {
                    ends[1] = ends[1] + 1.0;
                } else {
                    ends[0] = ends[0] - 1.0;
                }
            }
            if (this.barLabel) {
                this.yMax = ends[1];
                this.yMin = ends[0];
            } else {
                this.yMin = ends[0] >= 0.0 ? ends[0] : ends[0] - 0.02 * (ends[1] - ends[0]);
                this.yMax = ends[1] <= 0.0 ? ends[1] : ends[1] + 0.02 * (ends[1] - ends[0]);
            }
            this.respTickmarkOffset = this.yMax - ends[1];
        } else {
            if (this.barModel.isMultiResponses()) {
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberResponses() * this.barModel.getNumberCategories() + (this.barModel.getNumberCategories() - 1);
            } else if (this.groupVariable == null) {
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberCategories();
            } else {
                int groups = this.barModel.getNumberGroups();
                this.yMin = 0.0;
                this.yMax = this.barModel.getNumberCategories() * groups + (groups - 1);
            }
            this.numberBars = (int)this.yMax;
            double[] ends = this.xAxis.getMinMaxTickMarkValues();
            if (ends[0] == ends[1]) {
                if (ends[1] >= 0.0) {
                    ends[1] = ends[1] + 1.0;
                } else {
                    ends[0] = ends[0] - 1.0;
                }
            }
            if (this.barLabel) {
                this.xMax = ends[1];
                this.xMin = ends[0];
            } else {
                this.xMin = ends[0] >= 0.0 ? ends[0] : ends[0] - 0.02 * (ends[1] - ends[0]);
                this.xMax = ends[1] <= 0.0 ? ends[1] : ends[1] + 0.02 * (ends[1] - ends[0]);
            }
            this.respTickmarkOffset = this.xMax - ends[1];
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = 0.0;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = 0.0;
        return this.chartBBox;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        if (this.chartType == 0) {
            this.xMin = xmin;
            this.xMax = xmax;
            this.yMax = Math.max(0.0, ymax);
            this.yMin = Math.min(0.0, ymin);
        } else {
            this.yMin = ymin;
            this.yMax = ymax;
            this.xMax = Math.max(0.0, xmax);
            this.xMin = Math.min(0.0, xmin);
        }
        if (!this.fixedDataRange) {
            long obs1;
            double[] ends = new double[2];
            if (this.chartType == 0) {
                obs1 = (long)this.xMin;
                long obs2 = (long)(this.xMax + 1.0);
                if (this.groupVariable != null) {
                    int nCats = this.barModel.getNumberCategories();
                    int g = (int)((double)obs1 / (double)(nCats + 1));
                    int c = (int)obs1 % (nCats + 1);
                    obs1 = c + g * nCats;
                    g = (int)((double)obs2 / (double)(nCats + 1));
                    c = (int)obs2 % (nCats + 1);
                    obs2 = c + g * nCats;
                }
                if ((ends = this.yAxis.getMinMaxTickMarkValues())[0] == ends[1]) {
                    if (ends[1] >= 0.0) {
                        ends[1] = ends[1] + 1.0;
                    } else {
                        ends[0] = ends[0] - 1.0;
                    }
                }
                this.yMin = ends[0];
                this.yMax = ends[1];
            } else {
                obs1 = (long)this.yMin;
                long obs2 = (long)(this.yMax + 1.0);
                if (this.groupVariable != null) {
                    int nCats = this.barModel.getNumberCategories();
                    int g = (int)((double)obs1 / (double)(nCats + 1));
                    int c = (int)obs1 % (nCats + 1);
                    obs1 = c + g * nCats;
                    g = (int)((double)obs2 / (double)(nCats + 1));
                    c = (int)obs2 % (nCats + 1);
                    obs2 = c + g * nCats;
                }
                if ((ends = this.xAxis.getMinMaxTickMarkValues())[0] == ends[1]) {
                    if (ends[1] >= 0.0) {
                        ends[1] = ends[1] + 1.0;
                    } else {
                        ends[0] = ends[0] - 1.0;
                    }
                }
                this.xMin = ends[0];
                this.xMax = ends[1];
            }
            if (Double.isNaN(this.baseValue)) {
                this.rebuildRequired = true;
            }
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = zmin;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = zmax;
        int tempStartDisplayBar = 1;
        int tempEndDisplayBar = 1;
        if (this.chartType == 0) {
            tempStartDisplayBar = (int)(this.xMin + 1.0);
            tempEndDisplayBar = (int)Math.round(this.xMax);
        } else {
            tempStartDisplayBar = (int)(this.yMin + 1.0);
            tempEndDisplayBar = (int)Math.round(this.yMax);
        }
        if (this.startDisplayBar != tempStartDisplayBar || this.endDisplayBar != tempEndDisplayBar) {
            this.userSetDisplayBarRange = false;
            this.startDisplayBar = tempStartDisplayBar;
            this.endDisplayBar = tempEndDisplayBar;
            if (this.endDisplayBar < this.startDisplayBar) {
                this.endDisplayBar = this.startDisplayBar;
            }
            this.numberDisplayBars = this.endDisplayBar - this.startDisplayBar + 1;
        }
        RedrawEvent e = new RedrawEvent(this);
        e.newBoundingBox = this.chartBBox;
        e.type = 2;
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public Rectangle getScreenArea() {
        return null;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.source == this.dataOut) {
            if (evt.type == 1) {
                this.rebuildRequired = true;
                this.dataChanged = true;
                this.dataPrepared = false;
                if (this.barModel != null) {
                    this.barModel.initFromData();
                }
                this.prepareChartData();
            } else if (evt.type == 3 && this.dataOut.getVariableId(evt.varStartIndex).equals("Selected")) {
                this.selectedValues = this.barModel.getSelectedValues();
                ArrayList currSel = this.barModel.getCurrentSelectedObservations();
                int rows = currSel == null ? this.dataOut.getNumberObservations(-1) : currSel.size();
                if (currSel == null && this.barModel.isUnselectedAll()) {
                    this.selectionList.removeAllElements();
                    RedrawEvent e = new RedrawEvent(this);
                    e.type = 5;
                    this.fireRedrawEvent(e);
                    return;
                }
                block0: for (int cs = 0; cs < rows; ++cs) {
                    int o = currSel == null ? cs : (Integer)currSel.get(cs);
                    double s = this.selectedValues[o];
                    double f = this.dataOut.getNumericValue((Object)"Frequency", (long)o);
                    int size = this.displayList.size();
                    int index = -1;
                    for (int i = 0; i < size; ++i) {
                        BarElement e = (BarElement)this.displayList.elementAt(i);
                        if (!(e.element instanceof Rectangle2D.Double) || e.obsNo != (long)o) continue;
                        index = i;
                        Object[] tmp = new Object[]{new Integer(index), new Double(s / f)};
                        int idx = -1;
                        for (int j = 0; j < this.selectionList.size(); ++j) {
                            if (index != (Integer)((Object[])this.selectionList.elementAt(j))[0]) continue;
                            idx = j;
                            break;
                        }
                        if (idx < 0 && s > 0.0) {
                            this.selectionList.addElement(tmp);
                        } else if (idx >= 0 && s > 0.0) {
                            this.selectionList.setElementAt(tmp, idx);
                        } else if (idx >= 0 && s == 0.0) {
                            this.selectionList.removeElementAt(idx);
                        }
                        if (!this.barModel.isMultiResponses()) continue block0;
                    }
                }
                RedrawEvent e = new RedrawEvent(this);
                e.type = 5;
                this.fireRedrawEvent(e);
            }
        }
    }

    @Override
    public BarModel getBarModel() {
        return this.barModel;
    }

    @Override
    public String getStatistic() {
        this.yVariable = this.barModel.getVariableInModel("Response");
        this.statistic2 = this.yVariable != null ? (this.statistic2 != 2 ? 1 : 2) : (this.statistic2 != 4 ? 3 : 4);
        return statName[this.statistic2].toString();
    }

    public SILKNumber getStatisticObject() {
        this.statistic2 = this.barModel.getVariableInModel("Response") != null ? (this.statistic2 != 2 ? 1 : 2) : (this.statistic2 != 4 ? 3 : 4);
        return statName[this.statistic2];
    }

    @Override
    public void setStatistic(String type) {
        if (type == null) {
            return;
        }
        boolean valid = false;
        for (int i = 0; i < statName.length; ++i) {
            if (!statName[i].toString().equalsIgnoreCase(type) && !statName[i].getEnglishName().equalsIgnoreCase(type)) continue;
            this.statistic = i;
            this.barModel.setStatistic(this.statistic);
            valid = true;
            break;
        }
        if (valid) {
            this.rebuildRequired = true;
            this.dataChanged = true;
            this.dataPrepared = false;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
    }

    @Override
    public double getBarScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setBarScaleFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.scaleFactor = fac;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isFixedDataRange() {
        return this.fixedDataRange;
    }

    @Override
    public void setFixedDataRange(boolean fixed) {
        this.fixedDataRange = fixed;
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    @Override
    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public void setOutlineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outlineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outlineColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    @Override
    public void setOutlineOn(boolean on) {
        this.outlineOn = on;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getChartBorderColor() {
        return this.chartBorderColor;
    }

    @Override
    public void setChartBorderColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartBorderColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartBorderColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isChartBorderOn() {
        return this.chartBorderOn;
    }

    @Override
    public void setChartBorderOn(boolean on) {
        this.chartBorderOn = on;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getChartWallColor() {
        return this.chartWallColor;
    }

    public void setChartWallColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartWallColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartWallColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color[] getDataColors() {
        return this.dataColors;
    }

    @Override
    public void setDataColors(Color[] c) {
        if (c == null) {
            return;
        }
        this.dataColors = c;
        this.rebuildRequired = true;
        if (!this.userSetSignColors) {
            this.colorNegative = this.dataColors[1];
            this.colorPositive = this.dataColors[0];
        }
        if (this.legend != null) {
            int size = this.legendValues == null ? 0 : this.legendValues.length;
            Color[] colors = new Color[size];
            Object clrVector = null;
            if (this.colorIndexVariable != null && size > 0 && this.groupVariable == null) {
                HashMap colorMapByVar = null;
                colorMapByVar = this.subgroupVariable != null ? this.barModel.getColorIndexNamesByVariable(this.subgroupVariable, this.colorIndexVariable) : this.barModel.getColorIndexNamesByVariable(this.xVariable, this.colorIndexVariable);
                for (int i = 0; i < size; ++i) {
                    Integer colorVal = (Integer)colorMapByVar.get(this.legendValues[i]);
                    colors[i] = this.dataColors[colorVal % this.dataColors.length];
                }
            } else if (this.barModel.isMultiResponses()) {
                Vector items = null;
                items = this.barModel.getResponseDescriptions();
                if (size > 0 && items.elementAt(0) instanceof Number) {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = new Double(((Number)items.elementAt(i)).doubleValue());
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 2, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.legendValues[i] = items.elementAt(i);
                        String attrValueStr = this.legendValues[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.styleElement, null).getAsDataStyle();
                        colors[i] = dse.getFillColor();
                    }
                }
            } else if (this.colorBy != null && this.colorBy.equals(this.responseSign)) {
                colors[0] = this.colorNegative;
                colors[1] = this.colorPositive;
            } else {
                for (int i = 0; i < size; ++i) {
                    String attrValueStr = this.legendValues[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 2, this.style, this.styleElement, null).getAsDataStyle();
                    colors[i] = dse.getFillColor();
                }
            }
            this.legend.setValues(colors, null, this.legendValues, null, false);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public void setStyle(Style s) {
        this.style = s;
    }

    @Override
    public Color getBarColor() {
        return this.barColor;
    }

    @Override
    public void setBarColor(Object c) {
        if (c == null) {
            this.colorByChart = false;
        } else if (c instanceof Color) {
            this.barColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.barColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public void setColorByChart(boolean byChart) {
        this.colorByChart = byChart;
        this.dataPrepared = false;
        this.prepareChartData();
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public void setColorByCategory(boolean byCategory) {
        this.colorByChart = !byCategory;
        this.userSetProperties.set(814);
        this.dataPrepared = false;
        this.prepareChartData();
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public void setColorBy(Object role) {
        this.userSetProperties.set(815);
        if (role == null) {
            this.colorBy = null;
            this.colorByChart = true;
        }
        if (role instanceof String && (((String)role).equalsIgnoreCase(this.responseSign.toString()) || ((String)role).equalsIgnoreCase("Response Sign"))) {
            this.colorBy = role;
            this.colorByChart = false;
        }
        if (role instanceof String && (((String)role).equalsIgnoreCase(this.categoryRole.toString()) || ((String)role).equalsIgnoreCase("category"))) {
            this.colorBy = role;
            this.colorByChart = false;
        } else if (role instanceof SILKNumber) {
            this.colorBy = (SILKNumber)((Object)role);
            this.colorByChart = false;
        }
        this.dataPrepared = false;
        this.dataChanged = true;
        this.rebuildRequired = true;
        this.prepareChartData();
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public double getBaseValue() {
        return this.baseValue;
    }

    @Override
    public void setBaseValue(double v) {
        this.baseValue = v;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public String getChartType() {
        if (this.chartType == 0) {
            return "Vertical";
        }
        return "Horizontal";
    }

    @Override
    public void setChartType(String type) {
        int cType;
        if (type.equals("Horizontal") || type.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Horizontal.txt", (String)"Horizontal"))) {
            cType = 1;
        } else if (type.equals("Vertical") || type.equals(ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Vertical.txt", (String)"Vertical"))) {
            cType = 0;
        } else {
            return;
        }
        if (cType != this.chartType) {
            this.chartType = cType;
            LineStyleInterface xGridLines = this.xAxis.getGridLines();
            LineStyleInterface yGridLines = this.yAxis.getGridLines();
            this.xAxis.setGridLines(yGridLines);
            this.yAxis.setGridLines(xGridLines);
            this.swapRefLines();
            this.dataChanged = true;
            this.dataPrepared = false;
            this.rebuildRequired = true;
            boolean isLegVis = this.legend.isVisible();
            if (!this.isLegendRequired() || isLegVis) {
                this.dataChanged = true;
                this.dataPrepared = false;
                this.rebuildRequired = true;
            }
            RedrawEvent e = new RedrawEvent(this);
            e.type = 3;
            this.fireRedrawEvent(e);
            if (this.userSetProperties.get(814) || this.userSetProperties.get(815)) {
                this.legend.setVisible(isLegVis);
            }
        }
    }

    @Override
    public String getSortType() {
        return this.barModel.getSortType();
    }

    @Override
    public void setSortType(String sort) {
        this.barModel.setSortType(sort);
        this.userSetProperties.set(807);
        this.dataChanged = true;
        this.dataPrepared = false;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public int getNumberDisplayBars() {
        return this.numberDisplayBars;
    }

    @Override
    public void setNumberDisplayBars(int n) {
        if (n < 1) {
            return;
        }
        this.numberDisplayBars = n;
        this.startDisplayBar = 1;
        this.endDisplayBar = n;
        this.userSetDisplayBarRange = true;
        this.userSetProperties.set(808);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public int[] getDisplayBarRange() {
        return new int[]{this.startDisplayBar, this.endDisplayBar};
    }

    @Override
    public void setDisplayBarRange(int start, int end) {
        if (start < 1 || end < start) {
            return;
        }
        this.startDisplayBar = start;
        this.endDisplayBar = end;
        this.userSetDisplayBarRange = true;
        this.userSetProperties.set(809);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public int getNumberBars() {
        if (this.isDataChanged()) {
            this.getBoundingBox();
        }
        return this.numberBars;
    }

    public boolean isUserSetDisplayBarRange() {
        return this.userSetDisplayBarRange;
    }

    @Override
    public void setAxisLabelLength(int n) {
        this.axisLabelLength = Math.max(1, n);
        this.rebuildRequired = true;
        RedrawEvent e = new RedrawEvent(this);
        e.type = 3;
        this.fireRedrawEvent(e);
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.elementAt(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.addElement(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.removeElement(listener);
        }
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.elementAt(i);
        }
        switch (idx) {
            case 801: {
                return this.barColor;
            }
            case 802: {
                return this.outlineColor;
            }
            case 803: {
                return new Boolean(this.outlineOn);
            }
            case 804: {
                return new Double(this.scaleFactor);
            }
            case 805: {
                return new Boolean(this.colorByChart);
            }
            case 814: {
                return new Boolean(!this.colorByChart);
            }
            case 815: {
                return this.colorBy;
            }
            case 806: {
                boolean byScheme = this.barModel.isMultiResponses() || this.barModel.getVariable("Subgroup") != null || this.barModel.getVariable("Group") != null;
                return new Boolean(byScheme);
            }
            case 807: {
                return this.getSortOrder(new Integer(24));
            }
            case 808: {
                return new Integer(this.getNumberDisplayBars());
            }
            case 809: {
                return this.getDisplayBarRange();
            }
            case 810: {
                return new Integer(this.getNumberBars());
            }
            case 812: {
                return new Boolean(this.gradient);
            }
            case 816: {
                return new Boolean(this.barLabel);
            }
            case 813: {
                return new Boolean(this.gradientDisable);
            }
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.setElementAt(value, i);
        } else {
            this.propertyIndex.addElement(new Integer(idx));
            this.propertyValue.addElement(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 35;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block15: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.elementAt(i);
            Object value = this.propertyValue.elementAt(i);
            switch (idx) {
                case 801: {
                    if (value != null && !(value instanceof Color)) continue block15;
                    this.barColor = (Color)value;
                    this.userSetProperties.set(801);
                    continue block15;
                }
                case 802: {
                    if (!(value instanceof Color)) continue block15;
                    this.outlineColor = (Color)value;
                    this.userSetProperties.set(802);
                    continue block15;
                }
                case 803: {
                    if (!(value instanceof Boolean)) continue block15;
                    this.outlineOn = (Boolean)value;
                    this.userSetProperties.set(803);
                    continue block15;
                }
                case 804: {
                    if (!(value instanceof Number)) continue block15;
                    this.scaleFactor = ((Number)value).doubleValue();
                    this.userSetProperties.set(804);
                    this.rebuildRequired = true;
                    continue block15;
                }
                case 805: {
                    if (!(value instanceof Boolean)) continue block15;
                    this.setColorByChart((Boolean)value);
                    continue block15;
                }
                case 814: {
                    if (!(value instanceof Boolean)) continue block15;
                    this.setColorByCategory((Boolean)value);
                    continue block15;
                }
                case 815: {
                    this.setColorBy(value);
                    continue block15;
                }
                case 807: {
                    String str = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Data.txt", (String)"Data");
                    if (value instanceof Number) {
                        if (((Number)value).intValue() == 1) {
                            str = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Ascending.txt", (String)"Ascending");
                        } else if (((Number)value).intValue() == -1) {
                            str = ResourceLoader.getResourceString((Object)this.rb, (String)"Bar.Descending.txt", (String)"Descending");
                        }
                    }
                    this.setSortType(str);
                    continue block15;
                }
                case 808: {
                    if (!(value instanceof Integer)) continue block15;
                    this.setNumberDisplayBars((Integer)value);
                    continue block15;
                }
                case 809: {
                    if (!(value instanceof int[])) continue block15;
                    int[] range = (int[])value;
                    this.setDisplayBarRange(range[0], range[1]);
                    continue block15;
                }
                case 810: {
                    continue block15;
                }
                case 812: {
                    if (!(value instanceof Boolean)) continue block15;
                    this.setGradientOn((Boolean)value);
                    continue block15;
                }
                case 816: {
                    if (!(value instanceof Boolean)) continue block15;
                    this.setShowLabel((Boolean)value);
                    continue block15;
                }
            }
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return true;
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.elementAt(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    @Override
    public void addDataListener() {
        if (this.dataOut != null) {
            this.dataOut.addDataFilterListener((Object)this);
        }
        this.dataIn.addDataFilterListener((Object)this.barModel);
    }

    @Override
    public void removeDataListener() {
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataIn.removeDataFilterListener((Object)this.barModel);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    protected String buildAxisLabel(boolean xAxis, String str) {
        String axisLabel = null;
        if (str.equalsIgnoreCase("XAxis")) {
            axisLabel = (String)this.barModel.getVariableDescription("Category");
        } else if (str.equalsIgnoreCase("YAxis")) {
            axisLabel = (String)this.barModel.getVariableDescription("Response");
        } else if (str.equalsIgnoreCase("GroupAxis")) {
            axisLabel = (String)this.barModel.getVariableDescription("Group");
        }
        return axisLabel;
    }

    public void setDataChange() {
        this.rebuildRequired = true;
        this.dataChanged = true;
    }

    public void setDataPrepare() {
        this.rebuildRequired = true;
        this.dataPrepared = false;
    }

    protected void setMargins() {
        int halfBar;
        int axisLen;
        int nbars;
        if (this.graphics2D == null) {
            return;
        }
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return;
        }
        this.assignBarLabelWidth();
        int leftx = (int)((double)this.xAxis.getValueWidth(this.graphics2D, -1) * 0.5);
        int lefty = this.yAxis.getLeftWidth(this.graphics2D);
        int top = this.xAxis.getTopHeight(this.graphics2D);
        int top1 = 0;
        int top2 = this.xAxis.getRangeSliderThumbSize();
        int right = 0;
        int right_rl = this.yAxis.getReferenceLineLabelWidth(this.graphics2D);
        int top_rl = this.xAxis.getReferenceLineLabelHeight(this.graphics2D);
        if (this.getVariable("Group") != null && this.getVariable("subgroup") != null && this.groupAxis != null) {
            if (this.chartType == 0) {
                right += Math.max(this.xAxis.getLabelWidth(this.graphics2D, this.axisLabelLength), this.groupAxis.getLabelWidth(this.graphics2D, this.axisLabelLength));
            } else {
                lefty += this.groupAxis.getTickMarkValueWidth(this.graphics2D) + this.groupAxis.getLabelHeight(this.graphics2D);
            }
        }
        int bottom = 0;
        int n = nbars = this.groupVariable == null ? this.barModel.getNumberCategories() : (this.barModel.getNumberCategories() + 1) * this.barModel.getNumberGroups() - 1;
        if (this.numberDisplayBars > 0) {
            nbars = Math.min(nbars, this.numberDisplayBars);
        }
        int rightSav = right;
        for (int i = 0; i < 2; ++i) {
            int halfBar2;
            right = Math.max(right, right_rl);
            axisLen = this.chartAreaDimension.width - right - Math.max(leftx, lefty);
            this.xAxis.setAxisLength(axisLen);
            bottom = this.xAxis.getBottomHeight(this.graphics2D);
            int r = (int)((double)this.xAxis.getTickMarkValueWidth(this.graphics2D, -1, true) * 0.5);
            if (this.chartType == 0) {
                halfBar2 = (int)(0.5 * (double)axisLen / (double)nbars);
                this.xOffset[0] = this.xOffset[1] = (double)halfBar2;
            } else {
                halfBar2 = (int)(0.02 * (double)axisLen);
                this.xOffset[0] = 0.0;
                this.xOffset[1] = halfBar2;
            }
            r -= halfBar2;
            r = Math.max(0, r);
            right = rightSav + r;
            if (r == 0) break;
        }
        if (this.xAxis.isHideValues()) {
            leftx = 0;
            right = rightSav;
        }
        right = Math.max(right, right_rl);
        right += this.yAxis.getRangeSliderThumbSize();
        if (this.getVariable("Group") != null && this.getVariable("subgroup") != null && this.groupAxis != null && this.chartType == 0) {
            bottom += this.groupAxis.getBottomHeight(this.graphics2D);
            this.xAxis.setLabelOffset(right - rightSav);
            this.groupAxis.setLabelOffset(right - rightSav);
        }
        int n2 = axisLen = this.clipRect != null && this.clipRect.getHeight() > 0.0 ? (int)this.clipRect.getHeight() : this.chartAreaDimension.height - top - bottom;
        if (this.chartType == 1) {
            halfBar = (int)(0.5 * (double)axisLen / (double)nbars);
            this.yOffset[0] = this.yOffset[1] = (double)halfBar;
            this.xOffset[0] = 0.0;
            this.xOffset[1] = 0.0;
            if (this.transObj.isReverse(0)) {
                if (this.xMin < 0.0) {
                    double d = this.xOffset[1] = this.barLabel ? (double)this.barLabelWidth : (double)((int)(0.02 * (double)axisLen));
                }
                if (this.xMax > 0.0) {
                    this.xOffset[0] = this.barLabel ? (double)this.barLabelWidth : (double)((int)(0.02 * (double)axisLen));
                }
            } else {
                if (this.xMin < 0.0) {
                    double d = this.xOffset[0] = this.barLabel ? (double)this.barLabelWidth : (double)((int)(0.02 * (double)axisLen));
                }
                if (this.xMax > 0.0) {
                    this.xOffset[1] = this.barLabel ? (double)this.barLabelWidth : (double)((int)(0.02 * (double)axisLen));
                }
            }
        } else {
            halfBar = (int)(0.02 * (double)axisLen);
            this.yOffset[0] = 0.0;
            this.yOffset[1] = 0.0;
            if (this.transObj.isReverse(1)) {
                if (this.yMax > 0.0) {
                    double d = this.yOffset[0] = this.barLabel ? (double)(this.getBarLabelFontSize() + 2) : (double)halfBar;
                }
                if (this.yMin < 0.0) {
                    this.yOffset[1] = this.barLabel ? (double)(this.getBarLabelFontSize() + 2) : (double)halfBar;
                }
            } else {
                if (this.yMax > 0.0) {
                    double d = this.yOffset[1] = this.barLabel ? (double)(this.getBarLabelFontSize() + 2) : (double)halfBar;
                }
                if (this.yMin < 0.0) {
                    this.yOffset[0] = this.barLabel ? (double)(this.getBarLabelFontSize() + 2) : (double)halfBar;
                }
            }
        }
        top = top1 + top2;
        top = Math.max(top, top_rl);
        this.outerMargin.left = Math.min(Math.max(leftx, lefty), (int)((double)this.chartAreaDimension.width * 0.4));
        this.outerMargin.right = Math.min((int)((double)this.chartAreaDimension.width * 0.4), right);
        this.outerMargin.top = top;
        this.outerMargin.bottom = bottom;
        this.innerMargin.left = (int)this.xOffset[0];
        this.innerMargin.right = (int)this.xOffset[1];
        this.innerMargin.top = (int)this.yOffset[1];
        this.innerMargin.bottom = (int)this.yOffset[0];
    }

    public void setGraphicContent(Graphics2D g) {
        this.graphics2D = g;
    }

    private void swapRefLines() {
        if (this.xAxis != null && this.yAxis != null) {
            Vector refLines = this.xAxis.getRefLinesVector();
            this.xAxis.setRefLinesVector(this.yAxis.getRefLinesVector());
            this.yAxis.setRefLinesVector(refLines);
        }
    }

    public void showBarLabel(boolean flag) {
        this.setShowLabel(flag);
    }

    public void setShowLabel(boolean flag) {
        this.userSetProperties.set(816);
        this.barLabel = flag;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    protected int getBarLabelFontSize() {
        return this.barLabelFont.getSize();
    }

    private Font getBarLabelFont() {
        return this.barLabelFont;
    }

    private void setDefaultBarLabelFont() {
        Font f;
        int size = 0;
        size = (int)(0.5 * Math.sqrt(this.chartAreaDimension.height) * this.axisDefaults.fontSizeAdjust);
        size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
        this.barLabelFont = f = FontManager.getFont((String)this.yAxis.getValues().getFont().getName(), (int)this.yAxis.getValues().getFont().getStyle(), (int)size);
        this.barLabelColor = this.yAxis.getValues().getColor();
    }

    public int getXValueCount() {
        return this.barModel != null ? this.barModel.getXValueCount() : 0;
    }

    public void setXValueCount(int count) {
        if (this.barModel != null) {
            this.barModel.setXValueCount(count);
            this.rebuildRequired = true;
            this.dataChanged = true;
        }
    }

    public int getXActualValueCount() {
        return this.barModel != null ? this.barModel.getXActualValueCount() : 0;
    }

    public void setGradientOn(boolean onOff) {
        if (this.gradient == onOff) {
            return;
        }
        this.gradient = onOff;
        this.userSetProperties.set(812);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean getGradientOn() {
        return this.gradient;
    }

    public void setAbsoluteSort(boolean absoluteSort) {
        if (this.barModel != null) {
            this.barModel.setAbsoluteSort(absoluteSort);
        }
    }

    public void setAbsolute(boolean absolute) {
        this.abs = absolute;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public void setSignColors(Color negativeColor, Color positiveColor) {
        if (negativeColor == null && positiveColor == null) {
            this.userSetSignColors = false;
            this.colorNegative = this.dataColors[1];
            this.colorPositive = this.dataColors[0];
        } else {
            this.userSetSignColors = true;
            this.colorNegative = negativeColor;
            this.colorPositive = positiveColor;
        }
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    private void assignBarLabelWidth() {
        if (this.clipRect == null) {
            return;
        }
        if (this.barLabel) {
            int yIdx = this.dataOut.getVariableIndex(this.yVariable);
            int size = this.barModel.getNumberCategories();
            this.barLabelWidth = 0;
            FontRenderContext frc = new FontRenderContext(null, true, true);
            Object format = this.dataOut.getFormat(this.yVariable, SASFormat.class);
            int nResp = this.barModel.getNumberResponses();
            for (int i = 0; i < size; ++i) {
                TextLayout textString;
                String label;
                Object yObj = this.dataOut.getValue(yIdx, (long)i);
                if (nResp <= 1) {
                    yIdx = this.dataOut.getVariableIndex(this.yVariable);
                    yObj = this.dataOut.getValue(yIdx, (long)i);
                    if (yObj == null) continue;
                    if (this.statistic2 == 4) {
                        double val = ((Number)yObj).doubleValue() * 100.0 / this.barModel.getTotalFreqVal();
                        yObj = new Double(val);
                    }
                    if ((label = this.dataOut.getFormattedValue(this.yVariable, yObj, format)) == null || (textString = new TextLayout(label = label.trim(), this.getBarLabelFont(), frc)) == null) continue;
                    this.barLabelWidth = Math.max(this.barLabelWidth, (int)(textString.getVisibleAdvance() + textString.getAscent()));
                    continue;
                }
                Vector resps = this.barModel.getResponseNames();
                for (int j = 0; j < nResp; ++j) {
                    yIdx = this.dataOut.getVariableIndex(this.barModel.getResponseInModel(resps.elementAt(j)));
                    yObj = this.dataOut.getValue(yIdx, (long)i);
                    if (yObj == null) continue;
                    double rVal = 0.0;
                    if (yObj instanceof double[]) {
                        rVal = ((double[])yObj)[0];
                        label = this.dataOut.getFormattedValue(this.yVariable, (Object)new Double(rVal), format);
                    } else {
                        label = this.dataOut.getFormattedValue(this.yVariable, yObj, format);
                    }
                    if (label == null || (textString = new TextLayout(label = label.trim(), this.getBarLabelFont(), frc)) == null) continue;
                    this.barLabelWidth = Math.max(this.barLabelWidth, (int)(textString.getVisibleAdvance() + textString.getAscent()));
                }
            }
            if ((double)this.barLabelWidth > 0.5 * this.clipRect.getWidth()) {
                this.barLabelWidth = 0;
            }
        } else {
            this.barLabelWidth = 0;
        }
    }

    public Object getVariableInModel(Object role) {
        if (this.barModel == null || role == null) {
            return null;
        }
        return this.barModel.getVariableInModel(role);
    }

    class BarElement {
        public Object element;
        public Rectangle2D projectedRect;
        public Line2D projectedLineH;
        public Line2D projectedLineL;
        public String description;
        public long obsNo;

        public BarElement(Object e, String desc) {
            this.element = e;
            this.description = desc;
            this.projectedRect = null;
            this.projectedLineH = null;
            this.projectedLineL = null;
        }

        public BarElement(Object e) {
            this(e, null);
        }
    }
}

