/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.band;

import com.sas.graphics.silk.band.Band;
import com.sas.graphics.silk.interfaces.BandInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.scatter.ScatterDefaults;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.Sort;
import com.sas.graphics.util.StringCompare;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class BandChart
implements BandInterface,
GeometryInterface,
PropertyInterface,
RenderInterface,
RoleInterface,
UpdateInterface {
    public static final int BAND_OPEN = 2;
    public static final int BAND_CONST = 3;
    protected boolean visible = true;
    protected boolean xBoundsAreExternal = false;
    protected boolean yBoundsAreExternal = false;
    protected boolean rebuildRequired = false;
    protected boolean redrawRequired = false;
    protected boolean singleUse = false;
    protected double respMin;
    protected double respMax;
    protected double catMin;
    protected double catMax;
    protected Object categoryVariable = null;
    protected Object baseLineValue;
    protected Object singleColor = null;
    protected Color defaultColor = null;
    protected Vector bands;
    protected Roles roles;
    protected RoleEvent roleEvt;
    protected DataFilterReadInterface dataFilter = null;
    protected TransformInterface transObj;
    protected ScatterDefaults defaults;
    protected ColorInterface clrRamp = null;
    protected Polygon singleUsePolygon = null;
    protected PropertyList pendingProperties = null;
    protected double[] temp;
    protected Object catSortOrder = RoleInterface.ROLE_SORT_ASCENDING;
    protected boolean catValuesSorted = false;
    protected int[] sortedIndexList = null;
    protected boolean filledBands = false;
    protected double yMin;
    protected double yMax;

    public BandChart(TransformInterface transIn) {
        this.defaults = new ScatterDefaults();
        this.temp = new double[3];
        this.catMax = Double.NaN;
        this.catMin = Double.NaN;
        this.respMax = Double.NaN;
        this.respMin = Double.NaN;
        this.roleEvt = new RoleEvent();
        this.roles = Roles.getInstance(null);
        this.bands = new Vector();
        this.transObj = transIn;
    }

    public BandChart() {
        this(null);
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected String getIntegerSuffix(String s) {
        int idx;
        String out = null;
        if (s == null || s.length() <= 0) {
            return null;
        }
        for (idx = s.length() - 1; idx >= 0 && Character.isDigit(s.charAt(idx)); --idx) {
        }
        if (idx < 0) {
            return s;
        }
        out = s.substring(idx);
        return out;
    }

    protected int stringToInt(String in, int defaultValue) {
        int out = defaultValue;
        try {
            out = Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            out = defaultValue;
        }
        return out;
    }

    protected Object getVariableId(Object variableId, boolean allowIndex) {
        Object out = variableId;
        if (allowIndex && variableId != null && variableId instanceof Number) {
            if (this.dataFilter == null) {
                return null;
            }
            int nVars = this.dataFilter.getNumberVariables();
            int i = ((Number)variableId).intValue();
            if (i < 0 || i >= nVars) {
                return null;
            }
            out = this.dataFilter.getVariableId(i);
        }
        return out;
    }

    protected double getBaseLineSlope() {
        if (this.baseLineValue == null || !(this.baseLineValue instanceof double[])) {
            return 0.0;
        }
        return ((double[])this.baseLineValue)[0];
    }

    protected double getBaseLineIntercept() {
        if (this.baseLineValue == null) {
            return this.respMin;
        }
        if (this.baseLineValue instanceof Number) {
            return ((Number)this.baseLineValue).doubleValue();
        }
        if (this.baseLineValue instanceof double[]) {
            return ((double[])this.baseLineValue)[1];
        }
        return Double.NaN;
    }

    protected BandData getBandData(int idx) {
        if (this.bands == null || idx < 0 || idx >= this.bands.size()) {
            return null;
        }
        return (BandData)this.bands.elementAt(idx);
    }

    protected int isOurBandVariable(Object id, Boolean upper) {
        int n = this.getNumberBands();
        if (id == null || this.bands == null || this.dataFilter == null) {
            return -1;
        }
        if ((id = this.dataFilter.getExactVariableId(id)) == null) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            BandData bd = this.getBandData(i);
            if (bd == null) continue;
            if (bd.upper != null && id.equals(bd.upper) && (upper == null || upper.booleanValue())) {
                return i;
            }
            if (bd.lower == null || !id.equals(bd.lower) || upper != null && upper.booleanValue()) continue;
            return i;
        }
        return -1;
    }

    protected int getFirstEmptyBand(boolean findEmptyLower) {
        int n = this.getNumberBands();
        if (this.bands == null) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            BandData bd = this.getBandData(i);
            if (bd == null) continue;
            if (findEmptyLower && bd.lower == null) {
                return i;
            }
            if (findEmptyLower || bd.upper != null) continue;
            return i;
        }
        return -1;
    }

    protected boolean removeBandRole(Object variableId, int irole) {
        boolean found = false;
        int n = 0;
        Object oldVar = null;
        BandData bd = null;
        if (this.bands == null || (n = this.bands.size()) <= 0) {
            return false;
        }
        variableId = this.dataFilter == null ? variableId : this.dataFilter.getExactVariableId(variableId);
        for (int i = n - 1; i >= 0; --i) {
            bd = this.getBandData(i);
            if (bd == null) continue;
            switch (irole) {
                case 54: 
                case 56: 
                case 57: {
                    if (!(irole != 54 && irole != 56 || bd.upper == null || variableId != null && !variableId.equals(bd.upper))) {
                        if (oldVar == null) {
                            oldVar = bd.upper;
                        }
                        bd.setUpper(null);
                        if (variableId != null) {
                            found = true;
                        }
                    }
                    if (!(irole != 54 && irole != 57 || bd.lower == null || variableId != null && !variableId.equals(bd.lower))) {
                        if (oldVar == null) {
                            oldVar = bd.lower;
                        }
                        bd.setLower(null);
                        if (variableId != null) {
                            found = true;
                        }
                    }
                    if (bd.upper != null || bd.lower != null) break;
                    this.bands.removeElementAt(i);
                }
            }
            if (found) break;
        }
        if (!found) {
            return false;
        }
        if (bd != null) {
            bd.valid = false;
        }
        this.respMax = Double.NaN;
        this.respMin = Double.NaN;
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 3;
            this.roleEvt.role = 25;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = null;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    protected void updateBandMinMax(double d) {
        if (Double.isNaN(d)) {
            return;
        }
        if (Double.isNaN(this.respMin) || d < this.respMin) {
            this.respMin = d;
        }
        if (Double.isNaN(this.respMax) || d > this.respMax) {
            this.respMax = d;
        }
    }

    protected void getAndStoreBandValue(BandData bd, int iobs, double xVal) {
        double d;
        if (bd == null) {
            return;
        }
        if (bd.upperIdx >= 0) {
            d = this.dataFilter.getNumericValue(bd.upperIdx, (long)iobs);
            if (!Double.isNaN(d)) {
                bd.upperIobs.add(iobs);
            }
        } else {
            d = bd.upperConst && bd.upper != null ? ((Number)bd.upper).doubleValue() : Double.NaN;
        }
        this.updateBandMinMax(d);
        if (bd.lowerIdx >= 0) {
            d = this.dataFilter.getNumericValue(bd.lowerIdx, (long)iobs);
            if (!Double.isNaN(d)) {
                bd.lowerIobs.add(iobs);
            }
        } else {
            d = bd.lowerConst && bd.lower != null ? ((Number)bd.lower).doubleValue() : Double.NaN;
        }
        this.updateBandMinMax(d);
    }

    protected int getRoleIntValue(Object role) {
        if (role == null) {
            return -1;
        }
        if (role instanceof Number) {
            return ((Number)role).intValue();
        }
        if (!(role instanceof String)) {
            return -1;
        }
        String s = (String)role;
        if (this.roles.equalsRoleNLSName("ROLE_X", s) || s.equalsIgnoreCase("CATEGORY") || s.equalsIgnoreCase("INDEPENDENT") || s.equalsIgnoreCase("X") || s.equalsIgnoreCase("HORIZONTAL")) {
            return 24;
        }
        if (this.roles.equalsRoleNLSName("ROLE_BAND", s) || s.equalsIgnoreCase("BAND")) {
            return 54;
        }
        if (this.roles.equalsRoleNLSName("ROLE_UPPER_BAND", s) || s.equalsIgnoreCase("UPPER BAND")) {
            return 56;
        }
        if (this.roles.equalsRoleNLSName("ROLE_LOWER_BAND", s) || s.equalsIgnoreCase("LOWER BAND")) {
            return 57;
        }
        return -1;
    }

    protected int getBandPolygon(BandData bd, int xVarIdx, int iLeft, int iBottom, int iRight) {
        boolean pointsLoaded = false;
        boolean curBandIsLower = false;
        int turn = -1;
        int yVarIdx = -1;
        double d = this.respMin;
        Polygon poly = null;
        int[] iobsValues = null;
        if (bd == null || xVarIdx < 0) {
            return -1;
        }
        if (this.singleUse) {
            poly = this.singleUsePolygon == null ? (this.singleUsePolygon = new Polygon()) : this.singleUsePolygon;
        } else if (bd.screenPts == null) {
            poly = bd.screenPts = new Polygon();
        } else {
            if (bd.valid) {
                return bd.turn;
            }
            poly = bd.screenPts;
        }
        if (poly == null) {
            return -1;
        }
        poly.reset();
        for (int i = 0; i < 2; ++i) {
            boolean curBandIsConst;
            int nPoints;
            switch (i) {
                case 0: {
                    if (bd.upperIobs != null && (nPoints = bd.upperIobs.getNumberElements()) > 0) {
                        curBandIsLower = false;
                        break;
                    }
                    curBandIsLower = true;
                    break;
                }
                default: {
                    boolean bl = curBandIsLower = !curBandIsLower;
                }
            }
            if (curBandIsLower) {
                curBandIsConst = bd.lowerConst;
                iobsValues = bd.lowerIobs == null || (nPoints = bd.lowerIobs.getNumberElements()) <= 0 ? null : bd.lowerIobs.getElements();
                nPoints = iobsValues == null ? 0 : bd.lowerIobs.getNumberElements();
                yVarIdx = bd.lowerIdx;
            } else {
                curBandIsConst = bd.upperConst;
                iobsValues = bd.upperIobs == null || (nPoints = bd.upperIobs.getNumberElements()) <= 0 ? null : bd.upperIobs.getElements();
                nPoints = iobsValues == null ? 0 : bd.upperIobs.getNumberElements();
                yVarIdx = bd.upperIdx;
            }
            if (curBandIsConst) {
                d = curBandIsLower ? ((Number)bd.lower).doubleValue() : ((Number)bd.upper).doubleValue();
            }
            if (iobsValues == null || nPoints <= 0) {
                int iy;
                int ixRight;
                int ixLeft;
                if (pointsLoaded) {
                    turn = poly.npoints;
                    if (poly == bd.screenPts) {
                        bd.turn = turn;
                    }
                    ixLeft = poly.xpoints[0];
                    ixRight = poly.xpoints[poly.npoints - 1];
                } else {
                    ixLeft = iLeft;
                    ixRight = iRight;
                }
                if (curBandIsConst) {
                    this.transObj.project(this.catMin, d, 0.0, this.temp);
                    iy = (int)this.temp[1];
                } else {
                    iy = iBottom;
                }
                poly.addPoint(pointsLoaded ? ixRight : ixLeft, iy);
                poly.addPoint(pointsLoaded ? ixLeft : ixRight, iy);
                pointsLoaded = true;
                continue;
            }
            for (int iPoint = 0; iPoint < nPoints; ++iPoint) {
                int idx = pointsLoaded ? nPoints - iPoint - 1 : iPoint;
                double x = this.dataFilter.getNumericValue(xVarIdx, (long)iobsValues[idx]);
                double y = this.dataFilter.getNumericValue(yVarIdx, (long)iobsValues[idx]);
                this.transObj.project(x, y, 0.0, this.temp);
                poly.addPoint((int)this.temp[0], (int)this.temp[1]);
            }
            if (poly.npoints <= 0) continue;
            if (!pointsLoaded) {
                turn = poly.npoints;
                if (poly == bd.screenPts) {
                    bd.turn = turn;
                }
            }
            pointsLoaded = true;
        }
        if (poly == bd.screenPts) {
            bd.valid = true;
        }
        return turn;
    }

    protected void fill(BandData bd, Polygon poly, int turn, Graphics2D g, Color aboveFillColor, Color belowFillColor) {
        int endLower;
        int startLower;
        int endUpper;
        int startUpper;
        int t2;
        double[] out1 = this.transObj.project(this.catMin, this.yMin, 0.0, null);
        double[] out2 = this.transObj.project(this.catMin, this.yMax, 0.0, null);
        if (out1 == null || out2 == null) {
            return;
        }
        int min = (int)out1[1];
        int max = (int)out2[1];
        if (bd.upperConst) {
            t2 = poly.npoints - turn;
            startUpper = turn;
            endUpper = poly.npoints;
            startLower = 0;
            endLower = turn;
        } else {
            t2 = turn;
            startUpper = 0;
            endUpper = turn;
            startLower = turn;
            endLower = poly.npoints;
        }
        if (bd.fillAbove) {
            Polygon p1 = new Polygon();
            for (int j = startUpper; j < endUpper; ++j) {
                p1.addPoint(poly.xpoints[j], poly.ypoints[j]);
            }
            p1.addPoint(poly.xpoints[endUpper - 1], max);
            p1.addPoint(poly.xpoints[startUpper], max);
            Color clr = aboveFillColor == null ? this.getBandColor(0) : aboveFillColor;
            Band.draw(g, p1.xpoints, p1.ypoints, p1.npoints, t2, this.defaults.bandOpacity, clr);
        }
        if (bd.fillBelow) {
            Polygon p2 = new Polygon();
            for (int j = startLower; j < endLower; ++j) {
                p2.addPoint(poly.xpoints[j], poly.ypoints[j]);
            }
            p2.addPoint(poly.xpoints[endLower - 1], min);
            p2.addPoint(poly.xpoints[startLower], min);
            Color clr = belowFillColor == null ? this.getBandColor(0) : belowFillColor;
            Band.draw(g, p2.xpoints, p2.ypoints, p2.npoints, poly.npoints - t2, this.defaults.bandOpacity, clr);
        }
    }

    protected Color getBandColor(int idx) {
        Color out = Color.blue;
        Color single = this.getSingleColorValue();
        if (single != null) {
            out = single;
        } else if (this.bands.size() == 1 && this.defaultColor != null && !this.filledBands) {
            out = this.defaultColor;
        } else if (this.clrRamp != null) {
            out = this.clrRamp.query(idx, true, (int[])null);
        }
        return out;
    }

    protected Color getSingleColorValue() {
        if (this.singleColor == null) {
            return null;
        }
        if (this.singleColor instanceof Color) {
            return (Color)this.singleColor;
        }
        if (this.singleColor instanceof Number && this.clrRamp != null) {
            return this.clrRamp.query(((Number)this.singleColor).intValue(), true, (int[])null);
        }
        return null;
    }

    protected Object fetchProperty(int id) {
        Object out = null;
        return out;
    }

    protected boolean handleProperty(int id, Object value, boolean execute, boolean verify) {
        if (!execute && this.pendingProperties == null && (this.pendingProperties = new PropertyList()) == null) {
            return false;
        }
        return false;
    }

    public boolean isRedrawRequired() {
        return this.rebuildRequired || this.redrawRequired;
    }

    public void invalidateBands() {
        int n = this.getNumberBands();
        if (this.singleUse) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            BandData bd = this.getBandData(i);
            if (bd == null) continue;
            bd.valid = false;
        }
    }

    @Override
    public Object getCategory() {
        return this.categoryVariable;
    }

    @Override
    public boolean setCategory(Object in) {
        Object oldVar = this.categoryVariable;
        if (in != null && this.dataFilter == null) {
            return false;
        }
        if (in != null) {
            in = this.dataFilter.getExactVariableId(in);
        }
        this.categoryVariable = in;
        this.catMax = Double.NaN;
        this.catMin = Double.NaN;
        this.setSortOrder(RoleInterface.ROLE_CATEGORY, RoleInterface.ROLE_SORT_ASCENDING);
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 24;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.categoryVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public Object getBand(Object id) {
        return null;
    }

    @Override
    public Object getBaseLineValue() {
        if (this.baseLineValue == null || this.baseLineValue instanceof Number) {
            return this.baseLineValue;
        }
        double[] d = new double[2];
        if (d == null) {
            return null;
        }
        d[0] = this.getBaseLineSlope();
        d[1] = this.getBaseLineIntercept();
        return d;
    }

    @Override
    public boolean removeBand(Object id) {
        boolean status = true;
        int type = Extract.getSourceType((Object)id);
        int n = Extract.getNumberItems((Object)id, (int)type);
        for (int i = 0; i < n; ++i) {
            Object o = Extract.getObject((Object)id, (int)i, (int)type);
            if (o == null) continue;
            status &= this.removeBandRole(o, 54);
        }
        return status;
    }

    @Override
    public boolean setBand(Object role, Object ids, boolean add) {
        int count = 0;
        int irole = this.getRoleIntValue(role);
        Object varUpper = null;
        Object varLower = null;
        if (this.dataFilter == null) {
            return false;
        }
        int type = Extract.getSourceType((Object)ids);
        count = Extract.getNumberItems((Object)ids, (int)type);
        switch (irole) {
            default: {
                return false;
            }
            case 54: {
                if (count < 2) {
                    return false;
                }
                boolean success = true;
                for (int i = 0; i < count - 1; ++i) {
                    varUpper = Extract.getObject((Object)ids, (int)i, (int)type);
                    success = this.setBand(varUpper, varLower = Extract.getObject((Object)ids, (int)(i + 1), (int)type), true, irole) && success;
                }
                return success;
            }
            case 56: {
                if (count < 1) {
                    return false;
                }
                varUpper = Extract.getObject((Object)ids, (int)0, (int)type);
                return this.setBand(varUpper, varLower, add, irole);
            }
            case 57: 
        }
        if (count < 1) {
            return false;
        }
        varLower = Extract.getObject((Object)ids, (int)0, (int)type);
        return this.setBand(varUpper, varLower, add, irole);
    }

    protected boolean setBand(Object varUpper, Object varLower, boolean add, int irole) {
        boolean varUpperIsNumber = false;
        boolean varLowerIsNumber = false;
        Object temp = null;
        BandData bd = null;
        if (this.dataFilter == null) {
            return false;
        }
        temp = this.dataFilter.getExactVariableId(varUpper);
        if (temp == null && varUpper != null && varUpper instanceof Number) {
            temp = varUpper;
            varUpperIsNumber = true;
        }
        varUpper = temp;
        temp = this.dataFilter.getExactVariableId(varLower);
        if (temp == null && varLower != null && varLower instanceof Number) {
            temp = varLower;
            varLowerIsNumber = true;
        }
        varLower = temp;
        if (!add) {
            this.removeBandRole(null, irole);
        }
        if (this.isOurBandVariable(varUpper, new Boolean(true)) >= 0 || this.isOurBandVariable(varLower, new Boolean(false)) >= 0) {
            return false;
        }
        switch (irole) {
            case 54: {
                if (varUpper == null || varUpper == null) {
                    return false;
                }
                this.bands.addElement(new BandData(varUpper, varUpperIsNumber, varLower, varLowerIsNumber));
                break;
            }
            case 56: {
                if (varUpper == null) {
                    return false;
                }
                int idx = this.getFirstEmptyBand(false);
                if (idx >= 0) {
                    bd = this.getBandData(idx);
                }
                if (bd != null) {
                    bd.setUpper(varUpper);
                    bd.upperConst = varUpperIsNumber;
                    break;
                }
                this.bands.addElement(new BandData(varUpper, varUpperIsNumber, null, false));
                break;
            }
            case 57: {
                if (varLower == null) {
                    return false;
                }
                int idx = this.getFirstEmptyBand(true);
                if (idx >= 0) {
                    bd = this.getBandData(idx);
                }
                if (bd != null) {
                    bd.setLower(varLower);
                    bd.lowerConst = varLowerIsNumber;
                    break;
                }
                this.bands.addElement(new BandData(null, false, varLower, varLowerIsNumber));
            }
        }
        if (bd != null) {
            bd.valid = false;
        }
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = irole;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            Object[] vars = new Object[]{varUpper, varLower};
            this.roleEvt.newValue = vars;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        this.rebuildRequired = true;
        this.respMax = Double.NaN;
        this.respMin = Double.NaN;
        return true;
    }

    @Override
    public boolean setBaseLineValue(Object base) {
        if (base == null) {
            this.baseLineValue = null;
            return true;
        }
        int type = Extract.getSourceType((Object)base);
        int n = Extract.getNumberItems((Object)base, (int)type);
        if (n <= 0) {
            return false;
        }
        switch (n) {
            case 1: {
                double d = Extract.getNumeric((Object)base, (int)0, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                this.baseLineValue = new Double(d);
                break;
            }
            default: {
                double[] temp = new double[2];
                if (temp == null) {
                    return false;
                }
                double d = Extract.getNumeric((Object)base, (int)0, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                temp[0] = d;
                d = Extract.getNumeric((Object)base, (int)1, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                temp[1] = d;
                this.baseLineValue = temp;
            }
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public ColorInterface getColorRamp() {
        return this.clrRamp;
    }

    @Override
    public boolean setColorRamp(Object ramp) {
        if (!(ramp instanceof ColorInterface)) {
            return false;
        }
        this.clrRamp = (ColorInterface)ramp;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public int getNumberBands() {
        return this.bands == null ? 0 : this.bands.size();
    }

    @Override
    public int isInsideBand(Object id, int x, int y) {
        int end;
        int start;
        if (this.transObj == null || this.temp == null) {
            return -1;
        }
        if (id == null) {
            start = 0;
            end = this.getNumberBands() - 1;
        } else {
            start = id instanceof Number ? (end = ((Number)id).intValue()) : (end = this.isOurBandVariable(id, null));
        }
        if (end < start) {
            return -1;
        }
        int xVarIdx = this.dataFilter.getVariableIndex(this.categoryVariable);
        if (xVarIdx < 0) {
            return -1;
        }
        this.transObj.project(this.catMin, this.respMin, 0.0, this.temp);
        int iLeft = (int)this.temp[0];
        int iBottom = (int)this.temp[1];
        this.transObj.project(this.catMax, this.respMax, 0.0, this.temp);
        int iRight = (int)this.temp[0];
        for (int i = start; i <= end; ++i) {
            Polygon poly;
            BandData bd = this.getBandData(i);
            if (bd == null || this.getBandPolygon(bd, xVarIdx, iLeft, iBottom, iRight) <= 0 || (poly = this.singleUse ? this.singleUsePolygon : bd.screenPts) == null || !poly.contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getSingleColor() {
        return this.singleColor;
    }

    @Override
    public boolean setSingleColor(Object color) {
        if (color == null) {
            this.singleColor = null;
        } else if (color instanceof Color) {
            this.singleColor = (Color)color;
        } else if (color instanceof Number) {
            this.singleColor = new Integer(((Number)color).intValue());
        } else if (color instanceof String) {
            this.singleColor = ColorParse.getColorFromString((String)((String)color));
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public Color getDefaultColor() {
        return this.defaultColor;
    }

    @Override
    public boolean setDefaultColor(Object defaultColorIn) {
        if (defaultColorIn == null) {
            this.defaultColor = null;
        } else if (defaultColorIn instanceof Color) {
            this.defaultColor = (Color)defaultColorIn;
        } else if (defaultColorIn instanceof String) {
            this.defaultColor = ColorParse.getColorFromString((String)((String)defaultColorIn));
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean isConstantBand(Object id) {
        BandData bd;
        int idx;
        if (id == null) {
            return false;
        }
        return id instanceof Number && (idx = ((Number)id).intValue()) >= 0 && idx < this.getNumberBands() && (bd = this.getBandData(idx)) != null && bd.lowerConst && bd.upperConst;
    }

    @Override
    public boolean setBandFill(Object band, int fillOption, boolean fill) {
        if (fillOption == 4) {
            BandData bdLow = this.getBandData(this.getNumberBands() - 1);
            BandData bdHigh = this.getBandData(0);
            bdLow.fillBelow = fill;
            bdHigh.fillAbove = fill;
            this.filledBands = fill;
            return true;
        }
        BandData bd = this.getBandData(band);
        if (bd != null) {
            switch (fillOption) {
                case 3: {
                    bd.fillBelow = fill;
                    this.filledBands = true;
                    return true;
                }
                case 2: {
                    bd.fillAbove = fill;
                    this.filledBands = true;
                    return true;
                }
            }
        }
        return false;
    }

    protected BandData getBandData(Object band) {
        if (band == null) {
            return null;
        }
        int idx = -1;
        if (band instanceof String) {
            int index = -1;
            String bandId = band.toString();
            index = bandId.indexOf(":");
            if (index >= 0) {
                String lower = bandId.substring(0, index);
                String upper = bandId.substring(index + 1);
                for (int i = 0; i < this.getNumberBands(); ++i) {
                    BandData bd = this.getBandData(i);
                    if (!this.compare(bd.upper, upper) || !this.compare(bd.lower, lower)) continue;
                    idx = i;
                    break;
                }
            } else {
                for (int i = 0; i < this.getNumberBands(); ++i) {
                    BandData bd = this.getBandData(i);
                    if (!this.compare(bd.upper, bandId) && !this.compare(bd.lower, bandId)) continue;
                    idx = i;
                    break;
                }
            }
        } else if (band instanceof Number) {
            idx = ((Number)band).intValue();
        }
        if (idx >= 0 && idx < this.getNumberBands()) {
            return this.getBandData(idx);
        }
        return null;
    }

    protected boolean compare(Object a, String b) {
        if (a instanceof String) {
            return StringCompare.compareTo((String)a.toString(), (String)b) == 0;
        }
        if (a instanceof Number) {
            double dlower;
            try {
                dlower = Double.parseDouble(b);
            }
            catch (NumberFormatException e) {
                dlower = Double.NaN;
            }
            return ((Number)a).doubleValue() == dlower;
        }
        return false;
    }

    @Override
    public double[] getBoundingBox() {
        double[] out = new double[6];
        if (out == null) {
            return null;
        }
        if (this.rebuildRequired) {
            this.build(null);
        }
        out[0] = this.catMin;
        out[1] = this.respMin;
        out[3] = this.catMax;
        out[4] = this.respMax;
        out[2] = 0.0;
        out[5] = 0.0;
        return out;
    }

    @Override
    public Rectangle getScreenArea() {
        return null;
    }

    @Override
    public Object getTransformObject() {
        return this.transObj;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.catMin = xmin;
        this.catMax = xmax;
        this.respMin = ymin;
        this.respMax = ymax;
        if (Double.isNaN(this.catMin) || Double.isNaN(this.catMax)) {
            this.xBoundsAreExternal = false;
            this.rebuildRequired = true;
        } else {
            this.xBoundsAreExternal = true;
        }
        if (Double.isNaN(this.respMin) || Double.isNaN(this.respMax)) {
            this.yBoundsAreExternal = false;
            this.rebuildRequired = true;
        } else {
            this.yBoundsAreExternal = true;
        }
        return true;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null) {
            this.transObj = null;
        } else if (this.transObj instanceof TransformInterface) {
            this.transObj = (TransformInterface)transIn;
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.pendingProperties == null) {
            return false;
        }
        Vector v = this.pendingProperties.getChangesBySource(source);
        if (v == null || v.size() <= 0) {
            return false;
        }
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)v.elementAt(i);
            if (pe == null) continue;
            this.handleProperty(pe.id, pe.value, true, false);
        }
        this.pendingProperties.removeChangesBySource(source);
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(source);
        }
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        if (this.pendingProperties == null) {
            return null;
        }
        return this.pendingProperties.getPending(source);
    }

    public int getNumberPendingProperties() {
        if (this.pendingProperties == null) {
            return 0;
        }
        return this.pendingProperties.getNumberPending(null);
    }

    public Object getPropertyValue(int idx) {
        return this.fetchProperty(idx);
    }

    public boolean setPropertyValue(int idx, Object value) {
        return this.handleProperty(idx, value, false, false);
    }

    public boolean isPropertySupported(int id) {
        return this.handleProperty(id, null, false, true);
    }

    public boolean isPropertyPending(int id) {
        if (this.pendingProperties == null) {
            return false;
        }
        return this.pendingProperties.isPending(id);
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        int nBands = this.getNumberBands();
        int xVarIdx = -1;
        Color clr = null;
        Graphics2D g = p == null || !(p instanceof Graphics2D) ? null : (Graphics2D)p;
        Polygon poly = null;
        if (g == null || this.transObj == null || this.temp == null || this.dataFilter == null) {
            return;
        }
        this.transObj.project(this.catMin, this.respMin, 0.0, this.temp);
        int iLeft = (int)this.temp[0];
        int iBottom = (int)this.temp[1];
        this.transObj.project(this.catMax, this.respMax, 0.0, this.temp);
        int iRight = (int)this.temp[0];
        xVarIdx = this.dataFilter.getVariableIndex(this.categoryVariable);
        int bandColorIndex = 0;
        for (int iBand = 0; iBand < nBands; ++iBand) {
            int turn;
            BandData bd = this.getBandData(iBand);
            if (bd == null || (turn = this.getBandPolygon(bd, xVarIdx, iLeft, iBottom, iRight)) <= 0) continue;
            poly = this.singleUse ? this.singleUsePolygon : bd.screenPts;
            Color between = null;
            Color above = null;
            Color below = null;
            if (bd.fillBelow) {
                below = this.getBandColor(bandColorIndex++);
            }
            if (bd.fillBetween) {
                between = this.getBandColor(bandColorIndex++);
            }
            if (bd.fillAbove) {
                above = this.getBandColor(bandColorIndex++);
            }
            clr = between == null ? this.getBandColor(0) : between;
            Band.draw(g, poly.xpoints, poly.ypoints, poly.npoints, turn, this.defaults.bandOpacity, clr);
            if (!bd.fillAbove && !bd.fillBelow) continue;
            this.fill(bd, poly, turn, g, above, below);
        }
        this.redrawRequired = false;
    }

    @Override
    public void drawHighlight(Object p) {
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.defaults.bandOpacity);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double d = ((Number)newOpacity).doubleValue();
        if (Double.isNaN(d)) {
            return false;
        }
        this.defaults.bandOpacity = d = Math.max(Math.min(d, 1.0), 0.0);
        this.redrawRequired = true;
        return true;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        this.redrawRequired = true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        boolean allowIndex = true;
        Object s = null;
        if (role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 54: 
            case 56: 
            case 57: {
                return this.setBand(role, variableId, true);
            }
        }
        return this.setRole(variableId, s);
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
        if (this.roles == null) {
            return;
        }
        this.roles.addRoleListener(listener);
    }

    @Override
    public Object getAllVariables(Object role) {
        int nBands = this.getNumberBands();
        int irole = this.getRoleIntValue(role);
        Object[] out = null;
        Vector<Object> v = null;
        switch (irole) {
            default: {
                out = this.getVariable(role);
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                if (nBands <= 0 && (v = new Vector<Object>()) == null) break;
                for (int i = 0; i < nBands; ++i) {
                    BandData bd = this.getBandData(i);
                    if (bd == null) continue;
                    if (bd.upper != null && !bd.upperConst) {
                        v.addElement(bd.upper);
                    }
                    if (bd.upper == null || bd.upperConst) continue;
                    v.addElement(bd.upper);
                }
                if (v.size() <= 0) break;
                out = v.toArray();
            }
        }
        return out;
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (role == null) {
            return 0;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 54: 
            case 56: 
            case 57: {
                return 100;
            }
        }
        return 1;
    }

    @Override
    public Object getRole(Object variableId) {
        if ((variableId = this.getVariableId(variableId, true)) == null) {
            return null;
        }
        if (this.isEqual(variableId, this.categoryVariable)) {
            return this.roles.getRoleObject("ROLE_X");
        }
        int i = this.isOurBandVariable(variableId, null);
        if (i > -1) {
            BandData bd = this.getBandData(i);
            if (bd == null) {
                return null;
            }
            if (bd.upper != null && variableId.equals(bd.upper)) {
                return this.roles.getRoleObject("ROLE_UPPER_BAND");
            }
            if (bd.lower != null && variableId.equals(bd.lower)) {
                return this.roles.getRoleObject("ROLE_LOWER_BAND");
            }
        }
        return null;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        Double out = null;
        if (role == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        if (this.isRebuildRequired()) {
            this.build(new Boolean(true));
        }
        switch (irole) {
            case 1: 
            case 24: {
                if (which == 0) {
                    out = new Double(this.catMin);
                    break;
                }
                if (which != 1) break;
                out = new Double(this.catMax);
                break;
            }
            case 17: 
            case 25: 
            case 54: 
            case 56: 
            case 57: {
                if (which == 0) {
                    out = new Double(this.respMin);
                    break;
                }
                if (which != 1) break;
                out = new Double(this.respMax);
                break;
            }
            default: {
                return null;
            }
        }
        return out;
    }

    @Override
    public Object getSortOrder(Object role) {
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] o = null;
        o = new Object[]{this.roles.getRoleObject("ROLE_X"), this.roles.getRoleObject("ROLE_LOWER_BAND"), this.roles.getRoleObject("ROLE_UPPER_BAND")};
        return o;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 1: 
            case 24: {
                return this.categoryVariable;
            }
            case 54: 
            case 56: 
            case 57: {
                String s = role instanceof String ? (String)role : null;
                int idx = this.stringToInt(this.getIntegerSuffix(s), 0);
                if (this.bands == null || idx < 0 || idx >= this.bands.size()) {
                    return null;
                }
                BandData bd = this.getBandData(idx);
                if (bd == null) {
                    return null;
                }
                switch (irole) {
                    case 54: {
                        idx = 0;
                        if (bd.upper != null && !bd.upperConst) {
                            ++idx;
                        }
                        if (bd.lower != null && !bd.lowerConst) {
                            ++idx;
                        }
                        if (idx <= 0) {
                            return null;
                        }
                        Object[] o = new Object[idx];
                        if (o == null) {
                            return null;
                        }
                        idx = 0;
                        if (bd.upper != null && !bd.upperConst) {
                            o[idx++] = bd.upper;
                        }
                        if (bd.lower == null || bd.lowerConst) return o;
                        o[idx++] = bd.lower;
                        return o;
                    }
                    case 56: {
                        if (bd.upper == null || bd.upperConst) return null;
                        return bd.upper;
                    }
                    case 57: {
                        if (bd.lower == null || bd.lowerConst) return null;
                        return bd.lower;
                    }
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isDiscrete(Object role) {
        return false;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        boolean status = false;
        boolean allowIndex = true;
        if (variableId == null || role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 1: 
            case 24: {
                status = this.setCategory(null);
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                status = this.removeBandRole(variableId, irole);
            }
        }
        return status;
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
        if (this.roles == null) {
            return;
        }
        this.roles.removeRoleListener(listener);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        return false;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        boolean status = false;
        boolean add = false;
        boolean allowIndex = true;
        if (variableId == null || role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 1: 
            case 24: {
                status = this.setCategory(variableId);
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                switch (irole) {
                    case 56: {
                        if (this.getFirstEmptyBand(false) < 0) break;
                        add = true;
                        break;
                    }
                    case 57: {
                        if (this.getFirstEmptyBand(true) < 0) break;
                        add = true;
                    }
                }
                status = this.setBand(role, variableId, add);
            }
        }
        return status;
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        if (irole == 1 && order instanceof Number) {
            switch (((Number)order).intValue()) {
                case 1: {
                    this.catSortOrder = order;
                    this.catValuesSorted = false;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        if (role == null) {
            return true;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 54: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null) {
            this.dataFilter = null;
        } else if (source instanceof DataFilterReadInterface) {
            this.dataFilter = (DataFilterReadInterface)source;
        } else {
            DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)source);
            if (dfri != null) {
                this.dataFilter = dfri;
            } else {
                return false;
            }
        }
        this.respMax = Double.NaN;
        this.respMin = Double.NaN;
        this.rebuildRequired = true;
        return true;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public synchronized boolean build(Object buildData) {
        BandData bd;
        int i;
        int nBands = this.getNumberBands();
        if (this.dataFilter == null) {
            return false;
        }
        int nobs = this.dataFilter.getNumberObservations(-1);
        nobs = Math.max(nobs, 0);
        int catVarIdx = this.dataFilter.getVariableIndex(this.categoryVariable);
        for (i = 0; i < nBands; ++i) {
            bd = this.getBandData(i);
            if (bd == null) continue;
            if (bd.upper != null && !bd.upperConst) {
                bd.upperIdx = this.dataFilter.getVariableIndex(bd.upper);
                if (bd.upperIobs == null) {
                    bd.upperIobs = new DynamicIntArray(nobs);
                } else {
                    bd.upperIobs.removeAll();
                }
            } else {
                bd.upperIdx = -1;
            }
            if (bd.lower != null && !bd.lowerConst) {
                bd.lowerIdx = this.dataFilter.getVariableIndex(bd.lower);
                if (bd.lowerIobs == null) {
                    bd.lowerIobs = new DynamicIntArray(nobs);
                    continue;
                }
                bd.lowerIobs.removeAll();
                continue;
            }
            bd.lowerIdx = -1;
        }
        if (!this.catValuesSorted) {
            this.sortedIndexList = this.getSortIndices(((Number)this.catSortOrder).intValue(), catVarIdx);
            if (this.sortedIndexList == null) {
                return false;
            }
            this.catValuesSorted = true;
        }
        for (int iobs = 0; iobs < nobs; ++iobs) {
            double d = this.dataFilter.getNumericValue(catVarIdx, (long)this.sortedIndexList[iobs]);
            if (Double.isNaN(d)) continue;
            if (Double.isNaN(this.catMin) || d < this.catMin) {
                this.catMin = d;
            }
            if (Double.isNaN(this.catMax) || d > this.catMax) {
                this.catMax = d;
            }
            for (i = 0; i < nBands; ++i) {
                bd = this.getBandData(i);
                if (bd != null) {
                    bd.valid = false;
                }
                this.getAndStoreBandValue(bd, this.sortedIndexList[iobs], d);
            }
        }
        this.rebuildRequired = false;
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    protected int[] getSortIndices(int sortOrder, int varIdx) {
        int i;
        if (this.dataFilter == null || varIdx < 0) {
            return null;
        }
        int nobs = this.dataFilter.getNumberObservations(varIdx);
        int[] indices = new int[nobs];
        Vector<Object> v = new Vector<Object>(nobs);
        for (i = 0; i < nobs; ++i) {
            indices[i] = i;
            v.add(this.dataFilter.getValue(varIdx, (long)i));
        }
        if (sortOrder == 0) {
            return indices;
        }
        Sort.heapsort(Double.class, v, (int[])indices, (int)-1, null);
        if (sortOrder == 1) {
            return indices;
        }
        for (i = 0; i < indices.length / 2; ++i) {
            int temp = indices[i];
            indices[i] = indices[indices.length - i - 1];
            indices[indices.length - i - 1] = temp;
        }
        return indices;
    }

    public void setYMinMax(double yMin, double yMax) {
        this.yMin = yMin;
        this.yMax = yMax;
    }

    class BandData {
        public boolean valid;
        public boolean upperConst;
        public boolean lowerConst;
        public int upperIdx;
        public int lowerIdx;
        public int turn;
        public Object upper;
        public Object lower;
        public DynamicIntArray upperIobs;
        public DynamicIntArray lowerIobs;
        public Polygon screenPts;
        public boolean fillBetween;
        public boolean fillAbove;
        public boolean fillBelow;
        public String bandLabel;
        public String aboveBandLabel;
        public String belowBandLabel;

        public BandData(Object upper, boolean upperConst, Object lower, boolean lowerConst) {
            this.upperConst = upperConst;
            this.lowerConst = lowerConst;
            this.lowerIdx = -1;
            this.upperIdx = -1;
            this.turn = -1;
            this.upper = upper;
            this.lower = lower;
            this.screenPts = null;
            this.valid = false;
            this.fillBetween = true;
            this.fillAbove = false;
            this.fillBelow = false;
            this.generateBandLabels();
        }

        public int getMaxPointCount() {
            int n = 0;
            if (this.upperIobs != null) {
                n = Math.max(n, this.upperIobs.getNumberElements());
            }
            if (this.lowerIobs != null) {
                n = Math.max(n, this.lowerIobs.getNumberElements());
            }
            if (this.upperConst) {
                n = Math.max(n, 2);
            }
            if (this.lowerConst) {
                n = Math.max(n, 2);
            }
            return n;
        }

        public void generateBandLabels() {
            this.bandLabel = this.upper == null ? (this.lower == null ? null : this.lower.toString()) : (this.lower == null ? (this.upper == null ? null : this.upper.toString()) : this.lower.toString() + ":" + this.upper.toString());
            this.aboveBandLabel = "upperFill_" + this.bandLabel;
            this.belowBandLabel = "belowFill_" + this.bandLabel;
        }

        public void setUpper(Object upper) {
            this.upper = upper;
            this.generateBandLabels();
        }

        public void setLower(Object lower) {
            this.lower = lower;
            this.generateBandLabels();
        }
    }
}

