/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.LayerChangedEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.AlphaInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.CustomBaseLineValueInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.GraphInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LayerInterface;
import com.sas.graphics.silk.interfaces.LayerListenerInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.ScatterComponentInterface;
import com.sas.graphics.silk.interfaces.ScatterInterface;
import com.sas.graphics.silk.interfaces.StyleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.scatter.ScatterObjectJ2D;
import com.sas.graphics.silk.scatter.Wall;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.ScatterAdvancedPanel;
import com.sas.graphics.silk.ui.ScatterPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.AlphaRamp;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.Marker;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.RubberbandRectangle;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKInfo;
import com.sas.graphics.silk.util.Style;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.ToolTip;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.xml.Filter2XML;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class ScatterComponent
extends JComponent
implements ActionListener,
CellItemInterface,
CustomBaseLineValueInterface,
DataFilterListenerInterface,
DataRangeInterface,
GraphBackgroundInterface,
LayerInterface,
MouseListener,
MouseMotionListener,
Printable,
PropertyInterface,
RedrawListener,
RoleInterface,
RoleListenerInterface,
ScatterComponentInterface,
TextListenerInterface,
TransformInterface,
UpdateInterface,
URLSourceInterface,
ViewportInterface,
ViewportListenerInterface {
    private static final long serialVersionUID = 7381971686551363442L;
    protected static final int INSET_NONE = 0;
    protected static final int INSET_OUTER = 1;
    protected static final int INSET_INNER = 2;
    protected static final int VERTICAL_SCROLLBAR = 0;
    protected static final int HORIZONTAL_SCROLLBAR = 1;
    protected static final int ZOOM_BUTTON = 2;
    protected static final int ERROR_ALL_MISSING = 1;
    protected static final int ERROR_MAX_GROUPS = 2;
    protected static final int LAYER_ALL_ENUM = -10;
    protected static final int LAYER_BACKGROUND_ENUM = 0;
    protected static final int LAYER_AXIS_ENUM = 20;
    protected static final int LAYER_CHART_ENUM = 30;
    protected static final int LAYER_CHART_SELECTIONS_ENUM = 35;
    protected static final int LAYER_LEGEND_ENUM = 40;
    protected static final int LAYER_TITLE_ENUM = 50;
    protected static Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected static Cursor moveCursorOpen = null;
    protected static Cursor moveCursorClose = null;
    protected static Cursor sizeCursor = Cursor.getPredefinedCursor(1);
    protected boolean equalizeAxes = false;
    protected boolean sbSwitchedOff = false;
    protected boolean redrawXAxis = false;
    protected boolean redrawYAxis = false;
    protected boolean stylesEnabled;
    protected boolean addNotifyCalled = false;
    protected boolean resetView;
    protected boolean viewUpdate;
    protected boolean legendUpdateRequired;
    protected boolean allowPopup;
    protected boolean callShowTip;
    protected boolean noToolBar;
    protected boolean dataListen;
    protected boolean overMarker;
    protected boolean noMinMax;
    protected boolean mouseDown;
    protected boolean creatingBrush;
    protected boolean restrictBrush;
    protected boolean restrictPan;
    protected boolean rubberbanding;
    protected boolean tipsOn;
    protected boolean bufferUpdateRequired;
    protected boolean clipChartArea;
    protected boolean ignorePaint;
    protected boolean grpLegendVisibleLastDraw;
    protected boolean shpLegendVisibleLastDraw;
    protected boolean oneXRange;
    protected boolean oneYRange;
    protected boolean noBackBufferDraw = false;
    protected boolean printToPage;
    protected int actionMode;
    protected int selectBehavior;
    protected int mouseMode;
    protected int compWidth;
    protected int compHeight;
    protected int viewportX;
    protected int viewportY;
    protected int viewportWidth;
    protected int viewportHeight;
    protected int clipAreaX;
    protected int clipAreaY;
    protected int clipAreaWidth;
    protected int clipAreaHeight;
    protected int xMargin;
    protected int yMargin;
    protected int xLegendMargin;
    protected int yLegendMargin;
    protected int gradientOrientation;
    protected int imageFitStyle;
    protected int imageX;
    protected int imageY;
    protected int lastMouseX;
    protected int lastMouseY;
    protected int numRespVars;
    protected int maxLegendWidth;
    protected int maxLegendHeight;
    protected int tipX;
    protected int tipY;
    protected int lastLargestMarker;
    protected int lastLegendWidth1;
    protected int lastLegendWidth2;
    protected int lastLegendHeight1;
    protected int lastLegendHeight2;
    protected double tipOpacity;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double xFraction;
    protected double yFraction;
    protected double imageBlend;
    protected double xScale;
    protected double yScale;
    protected Object grpVarValue;
    protected Object clrVarValue;
    protected Object grpIdxVarValue;
    protected Object shpVarValue;
    protected Object id = null;
    protected Color selectColor;
    protected Boolean selectCrop;
    protected Boolean saveAutoCalculateXAxis;
    protected Boolean saveAutoCalculateYAxis;
    protected Image backBuffer;
    protected Image backImage;
    protected Image gpBackImage;
    protected Image scaledBackImage;
    protected Graphics2D gBack;
    protected Color backColor;
    protected Color backColor2;
    protected Color tipBackColor;
    protected Color tipBackColor2;
    protected Color tipTextColor;
    protected Color tipBorderColor;
    protected Font tipFont;
    protected Dimension nullDim;
    protected Cursor cursor;
    protected Toolkit tk;
    protected GradientPaint gp;
    protected ScatterObjectJ2D chart;
    protected Axes xAxis;
    protected Axes yAxis;
    protected Wall wall;
    protected AlphaInterface alphaRamp;
    protected ColorSchemeInterface scheme;
    protected ColorSchemeInterface userScheme;
    protected StyleInterface style;
    protected DataFilterReadInterface dataFilter;
    protected JPopupMenu menu;
    protected JMenuItem propMI;
    protected String propAC;
    protected JMenuItem dataMI;
    protected String dataAC;
    protected JMenuItem copyMI;
    protected String copyAC;
    protected JMenuItem tbMI;
    protected String tbAC;
    protected JMenuItem lineTypeMI;
    protected JMenuItem plotTypeMI;
    protected JMenuItem bandTypeMI;
    protected String lineTypeAC;
    protected String plotTypeAC;
    protected String bandTypeAC;
    protected JMenuItem saveDataMI;
    protected String saveDataAC;
    protected Frame parentFrame;
    protected TabbedPropertiesDialog newPropDlg;
    protected DataOptionsDialog newDataDlg;
    protected ImageListInterface imageList;
    protected RubberbandRectangle rb;
    protected Title titles;
    protected Footnote footnotes;
    protected Rectangle brushRect;
    protected Point brushLockPoint;
    protected Vector selPickList;
    protected Vector otherPickList;
    protected Vector additionalPickList;
    protected Vector editPickList;
    protected Vector tipList;
    protected Vector drilldownListeners = null;
    protected ToolTip tips;
    protected Component toolBar;
    protected LegendObjectJ2D grpLegend;
    protected LegendObjectJ2D shpLegend;
    protected LegendObjectJ2D curLegend;
    protected Vector marginListeners;
    protected Vector dataRangeListeners;
    protected PropertyList pendingProperties;
    protected PropertyInterface curPropAxis;
    protected GlobalDefaults globalDefaults;
    protected double[] temp;
    protected double[] temp2;
    protected double[] chartBBox;
    protected String nlsGroupLegend = null;
    protected String nlsColorLegend = null;
    protected String nlsShapeLegend = null;
    protected ResourceBundle resbld = null;
    protected Insets innerMargin;
    protected Insets outerMargin;
    protected String[] tipStrings;
    protected DataRange xDataRange;
    protected DataRange yDataRange;
    protected int xAxisMapping;
    protected int yAxisMapping;
    protected boolean selectable;
    protected boolean editable;
    protected Point editAnchor = null;
    protected Point moveDistance;
    protected Point lastMoveDistance;
    protected Vector viewportListeners = null;
    protected EventListenerList layerListenerList = new EventListenerList();
    protected LayerChangedEvent lce = null;
    protected boolean xReverse = false;
    protected boolean yReverse = false;
    protected AxisZoomPanHandler xAxisZoomHandler = null;
    protected AxisZoomPanHandler yAxisZoomHandler = null;
    protected ViewportWarningIcon warningIcon = null;
    protected boolean mouseOnXAxis = false;
    protected boolean mouseOnYAxis = false;
    private boolean clearViewport = false;

    public ScatterComponent(ImageListInterface imageListIn, boolean singleUseIn) {
        this.globalDefaults = new GlobalDefaults();
        this.viewportListeners = new Vector();
        this.selPickList = new Vector();
        this.otherPickList = new Vector();
        this.additionalPickList = new Vector();
        this.editPickList = new Vector();
        if (this.chart == null && (this.chart = new ScatterObjectJ2D(this, singleUseIn)) != null) {
            this.chart.addRoleListener(this);
            this.chart.setTransformObject(this);
            this.chart.setSelectedMarkers(this.selPickList);
            if (this.globalDefaults != null) {
                this.chart.setGraphedHonored(this.globalDefaults.honorGraphed);
                this.chart.setObsColorHonored(this.globalDefaults.honorColors);
            }
        }
        this.warningIcon = new ViewportWarningIcon(this);
        this.xAxis = new Axes();
        this.curPropAxis = this.xAxis;
        if (this.xAxis != null) {
            this.xAxis.setDimension(1);
            this.xAxis.setTransformObject(this);
            this.xAxis.addRedrawListener(this);
            this.xAxisZoomHandler = new AxisZoomPanHandler(this.xAxis);
            this.xAxisZoomHandler.addViewportListener(this);
            this.warningIcon.addZoomPanHandler(this.xAxisZoomHandler);
        }
        this.yAxis = new Axes();
        if (this.yAxis != null) {
            this.yAxis.setDimension(2);
            this.yAxis.setTransformObject(this);
            this.yAxis.addRedrawListener(this);
            this.yAxisZoomHandler = new AxisZoomPanHandler(this.yAxis);
            this.yAxisZoomHandler.addViewportListener(this);
            this.warningIcon.addZoomPanHandler(this.yAxisZoomHandler);
        }
        this.wall = new Wall(this);
        this.grpLegend = new LegendObjectJ2D();
        if (this.grpLegend != null) {
            this.grpLegend.setPosition(2);
        }
        if ((this.shpLegend = new LegendObjectJ2D()) != null) {
            this.shpLegend.setPosition(2);
        }
        this.resetView = false;
        this.legendUpdateRequired = false;
        this.tk = this.getToolkit();
        this.printToPage = false;
        this.oneXRange = false;
        this.oneYRange = false;
        this.xDataRange = null;
        this.yDataRange = null;
        this.outerMargin = null;
        this.innerMargin = null;
        this.nullDim = new Dimension(0, 0);
        this.allowPopup = true;
        this.parentFrame = null;
        this.callShowTip = false;
        this.grpLegendVisibleLastDraw = false;
        this.shpLegendVisibleLastDraw = false;
        this.saveAutoCalculateXAxis = null;
        this.saveAutoCalculateYAxis = null;
        this.noToolBar = false;
        this.tips = null;
        this.setPreferredSize(new Dimension(400, 400));
        this.dataListen = true;
        this.ignorePaint = false;
        this.overMarker = false;
        this.noMinMax = true;
        this.mouseDown = false;
        this.creatingBrush = true;
        this.restrictBrush = true;
        this.restrictPan = true;
        this.rubberbanding = false;
        this.tipsOn = true;
        this.clipChartArea = true;
        this.bufferUpdateRequired = false;
        this.viewUpdate = false;
        this.setDoubleBuffered(false);
        this.mouseMode = 0;
        this.actionMode = 1;
        this.selectBehavior = 0;
        this.xMargin = this.globalDefaults.componentXMargin;
        this.yMargin = this.globalDefaults.componentYMargin;
        this.lastLegendWidth2 = 0;
        this.lastLegendWidth1 = 0;
        this.lastLegendHeight2 = 0;
        this.lastLegendHeight1 = 0;
        this.xLegendMargin = 5;
        this.yLegendMargin = 5;
        this.compWidth = 0;
        this.compHeight = 0;
        this.imageX = 0;
        this.imageY = 0;
        this.tipY = -1;
        this.tipX = -1;
        this.maxLegendWidth = -1;
        this.maxLegendHeight = -1;
        this.lastLargestMarker = -1;
        this.curLegend = null;
        this.imageBlend = 1.0;
        this.tipOpacity = 1.0;
        this.viewportX = this.xMargin;
        this.viewportY = this.yMargin;
        this.viewportWidth = this.compWidth - 2 * this.xMargin;
        this.viewportHeight = this.compHeight - 2 * this.yMargin;
        this.clipAreaY = 0;
        this.clipAreaX = 0;
        this.clipAreaWidth = this.compWidth;
        this.clipAreaHeight = this.compHeight;
        this.gradientOrientation = 0;
        this.numRespVars = 0;
        this.yMin = 0.0;
        this.xMin = 0.0;
        this.yMax = 1.0;
        this.xMax = 1.0;
        this.xFraction = 0.55;
        this.yFraction = 0.55;
        this.grpVarValue = null;
        this.clrVarValue = null;
        this.grpIdxVarValue = null;
        this.shpVarValue = null;
        this.selectColor = null;
        this.selectCrop = null;
        this.backBuffer = null;
        this.imageFitStyle = 1;
        this.backImage = null;
        this.gpBackImage = null;
        this.scaledBackImage = null;
        this.setImageList(imageListIn);
        this.gBack = null;
        this.backColor = Color.white;
        this.backColor2 = null;
        this.cursor = normalCursor;
        this.tipBackColor = null;
        this.tipBackColor2 = null;
        this.tipTextColor = Color.black;
        this.tipBorderColor = Color.black;
        this.tipFont = null;
        this.gp = null;
        this.chartBBox = null;
        this.dataFilter = null;
        this.menu = null;
        this.propMI = null;
        this.dataMI = null;
        this.copyMI = null;
        this.tbMI = null;
        this.lineTypeMI = null;
        this.plotTypeMI = null;
        this.bandTypeMI = null;
        this.propAC = "_scatter_prop_AC";
        this.dataAC = "_scatter_data_AC";
        this.copyAC = "_scatter_copy_AC";
        this.tbAC = "_scatter_tb_AC";
        this.lineTypeAC = "_scatter_lineType_AC";
        this.plotTypeAC = "_scatter_plotType_AC";
        this.bandTypeAC = "_scatter_bandType_AC";
        this.saveDataAC = "_scatter_saveData_AC";
        this.newPropDlg = null;
        this.newDataDlg = null;
        this.tipStrings = new String[10];
        this.scheme = null;
        this.userScheme = null;
        this.style = null;
        this.rb = new RubberbandRectangle(this);
        this.brushRect = null;
        this.brushLockPoint = null;
        this.moveDistance = null;
        this.toolBar = null;
        this.tipList = new Vector();
        this.marginListeners = null;
        this.dataRangeListeners = null;
        this.pendingProperties = new PropertyList();
        this.titles = new Title();
        if (this.titles != null) {
            this.titles.addTextListener(this);
        }
        if ((this.footnotes = new Footnote()) != null) {
            this.footnotes.addTextListener(this);
        }
        if (moveCursorOpen == null) {
            moveCursorOpen = this.getCustomCursor(6, 2, "icons/MoveOpen.gif");
        }
        if (moveCursorClose == null) {
            moveCursorClose = this.getCustomCursor(6, 2, "icons/MoveClosed.gif");
        }
        this.alphaRamp = null;
        this.temp = new double[3];
        this.temp2 = new double[3];
        this.setXAxisMapping(0);
        this.setYAxisMapping(1);
        this.selectable = false;
        SILKGlobal.register(this);
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.setSize(0, 0);
    }

    public ScatterComponent(ImageListInterface imageListIn) {
        this(null, false);
    }

    public ScatterComponent() {
        this(null);
    }

    protected void handleSelectEvent(int n, Vector v) {
        boolean graphed = false;
        if (this.selectBehavior == 0) {
            return;
        }
        if (this.dataFilter == null || v == null || v.size() <= 0 || this.chart == null) {
            return;
        }
        switch (this.selectBehavior) {
            case 2: {
                if (this.selectCrop != null) {
                    graphed = this.selectCrop == false;
                }
                this.dataFilter.setGraphed((Object)v, graphed, (IOBSInterface)this.chart);
                break;
            }
            case 1: {
                this.dataFilter.setObservationColor((Object)v, this.selectColor, (IOBSInterface)this.chart);
            }
        }
    }

    protected ToolTip getTipBackGround() {
        if (this.tips == null) {
            this.tips = new ToolTip();
        }
        return this.tips;
    }

    protected void throwDrilldownEvent(int n) {
        int nl = 0;
        DrilldownEvent e = new DrilldownEvent();
        Object ddVar = null;
        if (this.dataFilter == null || this.selPickList == null || this.selPickList.size() <= 0 || this.chart == null || e == null) {
            return;
        }
        ddVar = this.chart.getVariable(RoleInterface.ROLE_URL);
        if (ddVar == null) {
            return;
        }
        if (this.drilldownListeners == null || this.drilldownListeners.size() <= 0) {
            return;
        }
        nl = this.drilldownListeners.size();
        for (int i = 0; i < nl; ++i) {
            Object o;
            Marker m;
            DrilldownListenerInterface d = (DrilldownListenerInterface)this.drilldownListeners.elementAt(i);
            if (d == null || (m = (Marker)this.selPickList.elementAt(n - 1)) == null || (o = this.dataFilter.getValue(ddVar, (long)m.getObsIndex())) == null) continue;
            e.url = o.toString();
            d.drilldown(e);
        }
    }

    protected LegendObjectJ2D getNextLegend() {
        if (this.curLegend != null || this.chart == null) {
            return this.curLegend;
        }
        if (this.chart.getVariable(RoleInterface.ROLE_COLOR) != null || this.chart.getVariable(RoleInterface.ROLE_GROUP) != null || this.chart.getNumberResponse() >= 2) {
            return this.grpLegend;
        }
        if (this.chart.getVariable(RoleInterface.ROLE_SHAPE) != null) {
            return this.shpLegend;
        }
        return null;
    }

    protected Object getMinOrMaxValue(Object var, boolean min) {
        DataFilterInfoInterface info = null;
        if (var == null) {
            return null;
        }
        if (this.dataFilter == null || !(this.dataFilter instanceof DataFilterInfoInterface)) {
            return null;
        }
        info = (DataFilterInfoInterface)this.dataFilter;
        if (min && !info.isMinimumValueValid(var) || !min && !info.isMaximumValueValid(var)) {
            info.rerunStatistics();
        }
        if (min && info.isMinimumValueValid(var)) {
            return info.getMinimumValue(var);
        }
        if (!min && info.isMaximumValueValid(var)) {
            return info.getMaximumValue(var);
        }
        return null;
    }

    protected void eraseBackground(Graphics g) {
        Composite c = null;
        Graphics2D g2 = null;
        if (g == null) {
            return;
        }
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
        }
        if (this.gpBackImage != null) {
            g.drawImage(this.gpBackImage, 0, 0, this);
        } else {
            g.setColor(this.backColor);
            g.fillRect(0, 0, this.compWidth, this.compHeight);
        }
        if (g2 != null && this.imageBlend < 1.0) {
            c = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, (float)this.imageBlend));
        }
        if (this.backImage != null) {
            switch (this.imageFitStyle) {
                default: {
                    break;
                }
                case 0: {
                    if (this.scaledBackImage == null) break;
                    g.drawImage(this.scaledBackImage, 0, 0, this);
                    break;
                }
                case 1: {
                    int w = this.backImage.getWidth(this);
                    int h = this.backImage.getHeight(this);
                    if (w <= 0 || h <= 0) break;
                    for (int iy = 0; iy < this.compHeight; iy += h) {
                        for (int ix = 0; ix < this.compWidth; ix += w) {
                            g.drawImage(this.backImage, ix, iy, this);
                        }
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int ix;
                    int iy;
                    int h = this.backImage.getHeight(this);
                    int w = this.backImage.getWidth(this);
                    if (this.imageFitStyle == 4) {
                        iy = 0;
                        ix = w > 0 ? (this.compWidth - w) / 2 : 0;
                    } else if (this.imageFitStyle == 6) {
                        ix = 0;
                        iy = 0;
                    } else if (this.imageFitStyle == 5) {
                        iy = h > 0 ? this.compHeight - h : 0;
                        ix = w > 0 ? this.compWidth - w : 0;
                    } else if (this.imageFitStyle == 7) {
                        iy = h > 0 ? this.compHeight - h : 0;
                        ix = 0;
                    } else {
                        ix = w > 0 ? (this.compWidth - w) / 2 : 0;
                        iy = h > 0 ? (this.compHeight - h) / 2 : 0;
                    }
                    g.drawImage(this.backImage, ix, iy, this);
                }
            }
        }
        if (c != null && g2 != null) {
            g2.setComposite(c);
        }
    }

    protected Graphics2D getGraphics2D(Image source) {
        Graphics g = null;
        g = source == null ? this.getGraphics() : source.getGraphics();
        if (g instanceof Graphics2D) {
            return (Graphics2D)g;
        }
        if (g != null) {
            g.dispose();
        }
        return null;
    }

    protected Color getAverageShading(Color oldColor1, Color oldColor2, Color newColor1) {
        Color c = newColor1;
        if (newColor1 == null) {
            return null;
        }
        if (oldColor1 != null && oldColor2 != null) {
            int r1 = oldColor1.getRed();
            int g1 = oldColor1.getGreen();
            int b1 = oldColor1.getBlue();
            int r2 = oldColor2.getRed();
            int g2 = oldColor2.getGreen();
            int b2 = oldColor2.getBlue();
            int rn = newColor1.getRed();
            int gn = newColor1.getGreen();
            int bn = newColor1.getBlue();
            double sum1 = r1 + g1 + b1;
            double sum2 = r2 + g2 + b2;
            if (sum1 <= 0.0) {
                return newColor1;
            }
            double factor = sum2 / sum1;
            int r = (int)((double)rn * factor);
            int g = (int)((double)gn * factor);
            int b = (int)((double)bn * factor);
            if (r < 0) {
                r = 0;
            } else if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            } else if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            } else if (b > 255) {
                b = 255;
            }
            c = new Color(r, g, b);
        }
        return c;
    }

    protected Image createImage() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return null;
        }
        return this.createImage(this.compWidth, this.compHeight);
    }

    protected void createBackBuffer() {
        if (this.gBack != null) {
            this.gBack.dispose();
        }
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = this.createImage();
        this.gBack = this.getGraphics2D(this.backBuffer);
        if (this.gp != null) {
            this.setGradientBackground(this.gp.getColor1(), this.gp.getColor2(), null);
        }
    }

    protected void setupAxisFonts(int height) {
        if (this.compHeight == height) {
            return;
        }
        if (this.xAxis != null) {
            this.xAxis.setDefaultFontSize(height);
        }
        if (this.yAxis != null) {
            this.yAxis.setDefaultFontSize(height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResize(int width, int height, boolean create) {
        int lgW = this.maxLegendWidth;
        int lgH = this.maxLegendHeight;
        if (this.compWidth == width && this.compHeight == height) {
            return;
        }
        this.setupAxisFonts(height);
        this.compWidth = width;
        this.compHeight = height;
        if (create) {
            this.createBackBuffer();
        }
        if (lgW < 0) {
            lgW = (int)((double)this.compWidth * 0.2);
        }
        if (lgH < 0) {
            lgH = this.compHeight;
        }
        if (this.grpLegend != null) {
            this.grpLegend.setMaximumSize(lgW, lgH);
        }
        if (this.shpLegend != null) {
            this.shpLegend.setMaximumSize(lgW, lgH);
        }
        if (this.chart != null) {
            this.chart.calculateMarkerSize(this.compWidth, this.compHeight);
            this.chart.setPickAreaBounds(0, 0, this.compWidth, this.compHeight);
        }
        if (this.titles != null) {
            this.titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        }
        if (this.footnotes != null) {
            this.footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        }
        this.viewUpdate = true;
        if (this.scaledBackImage != null) {
            this.setImageBackground(this.backImage, new Integer(0), 0, 0, this.imageBlend);
        }
        ScatterComponent scatterComponent = this;
        synchronized (scatterComponent) {
            this.bufferUpdateRequired = true;
        }
    }

    protected int[] getViewport() {
        int[] out = new int[4];
        if (out == null) {
            return null;
        }
        out[0] = this.viewportX;
        out[1] = this.viewportY;
        out[2] = this.viewportWidth;
        out[3] = this.viewportHeight;
        return out;
    }

    protected boolean setViewport(int x, int y, int width, int height) {
        if (x < 0 || y < 0 || width <= 0 || height <= 0) {
            return false;
        }
        this.viewportX = x;
        this.viewportY = y;
        this.viewportWidth = width;
        this.viewportHeight = height;
        return true;
    }

    protected int getTipContents(Vector v, String[] contents) {
        if (this.chart == null || v == null || contents == null) {
            return 0;
        }
        return this.chart.getPickContents(v, contents);
    }

    protected boolean isScrollItemVisible(int which) {
        return false;
    }

    protected void showTip(Graphics g, int x, int y) {
        ToolTip tip = this.getTipBackGround();
        if (g == null || !(g instanceof Graphics2D)) {
            return;
        }
        String s = this.getTipText(x, y);
        if (s == null) {
            return;
        }
        tip.paint(this, (Graphics2D)g, new Point(x, y), s);
    }

    protected JPopupMenu buildMenu() {
        String s;
        JPopupMenu m = new JPopupMenu();
        URL url = null;
        if (m == null) {
            return null;
        }
        this.loadNLSStrings();
        m.setLightWeightPopupEnabled(false);
        JMenuItem mi = this.propMI = new JMenuItem(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Graph_Properties_MenuItem.txt", (String)"Graph Properties..."));
        if (this.propMI != null) {
            m.add(mi);
            mi.setMnemonic(71);
            mi.setActionCommand(this.propAC);
            mi.addActionListener(this);
        }
        JMenu actionMenu = MenuUtilities.getMenu(this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/StandardActionMenu.xml"), (ActionListener)this);
        m.add(actionMenu);
        m.addSeparator();
        JMenu m2 = new JMenu(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Chart_Type_MenuItem.txt", (String)"Chart Type"));
        if (m2 != null) {
            m2.setMnemonic(89);
            JPopupMenu m3 = m2.getPopupMenu();
            if (m3 != null) {
                m3.setLightWeightPopupEnabled(false);
            }
            mi = this.lineTypeMI = new JMenuItem(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Line_PlotType_MenuItem.txt", (String)"Line"));
            if (this.lineTypeMI != null) {
                m2.add(mi);
                mi.setMnemonic(76);
                mi.setActionCommand(this.lineTypeAC);
                mi.addActionListener(this);
            }
            mi = this.plotTypeMI = new JMenuItem(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Plot_PlotType_MenuItem.txt", (String)"Plot"));
            if (this.plotTypeMI != null) {
                m2.add(mi);
                mi.setMnemonic(80);
                mi.setActionCommand(this.plotTypeAC);
                mi.addActionListener(this);
            }
            m.add(m2);
        }
        mi = this.dataMI = new JMenuItem(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Data_Options_MenuItem.txt", (String)"Data Options..."));
        if (this.dataMI != null) {
            m.add(mi);
            mi.setMnemonic(68);
            mi.setActionCommand(this.dataAC);
            mi.addActionListener(this);
        }
        m.addSeparator();
        mi = this.copyMI = new JMenuItem(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Copy_ClipboardMenuItem.txt", (String)"Copy"));
        if (this.copyMI != null) {
            m.add(mi);
            mi.setMnemonic(67);
            mi.setActionCommand(this.copyAC);
            mi.addActionListener(this);
        }
        m.addSeparator();
        url = SILKInfo.findClass("com.sas.graphics.silk.ScatterComponent");
        if (url != null && (s = url.toExternalForm()) != null && s.indexOf("MyProjects/Java/Silk9.1") >= 0) {
            mi = this.saveDataMI = new JMenuItem("Save Data to XML");
            if (this.saveDataMI != null) {
                m.add(mi);
                mi.setMnemonic(83);
                mi.setActionCommand(this.saveDataAC);
                mi.addActionListener(this);
            }
        }
        return m;
    }

    protected boolean isOurVariable(int firstVar, int lastVar) {
        String[] roles = new String[]{"Category", "Response", "Color", "Size", "Opacity"};
        for (int i = firstVar; i <= lastVar; ++i) {
            Object varId = this.dataFilter.getVariableId(i);
            if (varId == null) continue;
            for (int j = 0; j < roles.length; ++j) {
                if (!varId.equals(this.getVariable(roles[j]))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Color getBackground() {
        return this.backColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color bg) {
        if (bg != null) {
            this.gp = null;
            this.gpBackImage = null;
            this.backColor = bg;
            this.backColor2 = null;
            ScatterComponent scatterComponent = this;
            synchronized (scatterComponent) {
                this.bufferUpdateRequired = true;
            }
        }
        super.setBackground(bg);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D g = (Graphics2D)graphics;
        int maxWidth = (int)pageFormat.getImageableWidth();
        if (this.globalDefaults != null && this.globalDefaults.maxPrintableResolutionX > 0) {
            maxWidth = Math.min(maxWidth, this.globalDefaults.maxPrintableResolutionX);
        }
        int maxHeight = (int)pageFormat.getImageableHeight();
        if (this.globalDefaults != null && this.globalDefaults.maxPrintableResolutionY > 0) {
            maxHeight = Math.min(maxHeight, this.globalDefaults.maxPrintableResolutionY);
        }
        switch (pageIndex) {
            case 0: {
                int newHeight;
                int newWidth;
                int oldWidth = this.compWidth;
                int oldHeight = this.compHeight;
                double compAspect = (double)this.compWidth / (double)this.compHeight;
                double maxAspect = (double)maxWidth / (double)maxHeight;
                if (this.printToPage || compAspect == maxAspect) {
                    newWidth = maxWidth;
                    newHeight = maxHeight;
                } else if (compAspect > maxAspect) {
                    newWidth = maxWidth;
                    newHeight = (int)((double)newWidth / compAspect);
                } else {
                    newHeight = maxHeight;
                    newWidth = (int)((double)newHeight * compAspect);
                }
                int xTrans = (int)Math.max((pageFormat.getImageableWidth() - (double)newWidth) / 2.0, 0.0);
                int yTrans = (int)Math.max((pageFormat.getImageableHeight() - (double)newHeight) / 2.0, 0.0);
                AffineTransform defaultXfm = g.getTransform();
                AffineTransform xfm = new AffineTransform(defaultXfm);
                xfm.translate(pageFormat.getImageableX() + (double)xTrans, pageFormat.getImageableY() + (double)yTrans);
                g.setTransform(xfm);
                this.doResize(newWidth, newHeight, false);
                if (this.chart != null) {
                    this.chart.setRebuildRequired(true);
                }
                this.viewUpdate = true;
                boolean oldDraw = this.noBackBufferDraw;
                this.noBackBufferDraw = true;
                this.paint(graphics);
                this.doResize(oldWidth, oldHeight, false);
                if (this.chart != null) {
                    this.chart.setRebuildRequired(true);
                }
                this.viewUpdate = true;
                this.noBackBufferDraw = oldDraw;
                return 0;
            }
        }
        return 1;
    }

    protected boolean updateLegend(LegendObjectJ2D legend) {
        boolean update = false;
        int n = 0;
        Object curGrpVar = null;
        Object typVar = null;
        Object curGrpIdxVar = null;
        Object curClrVar = null;
        Object[] values = null;
        Object[] v = null;
        Color[] clrs = null;
        if (legend == null || this.chart == null || this.dataFilter == null) {
            return false;
        }
        n = this.chart.getNumberResponse();
        curGrpVar = this.chart.getGroup();
        curClrVar = this.chart.getVariable("Color");
        curGrpIdxVar = this.chart.getGroupIndex();
        typVar = this.chart.getMarkerShape();
        if (typVar != null && !(typVar instanceof String)) {
            typVar = null;
        }
        if (legend == this.grpLegend) {
            if (legend.isVisible() && (this.legendUpdateRequired || curGrpVar != null && this.grpVarValue != curGrpVar || curClrVar != null && this.clrVarValue != curClrVar || this.grpIdxVarValue != curGrpIdxVar || n != this.numRespVars)) {
                if (curGrpVar == null && curClrVar != null) {
                    ColorInterface ci = this.chart.getColorRamp();
                    if (ci != null) {
                        legend.setValues(ci.getColors(), null, ci.getBreaks(), null, true);
                    }
                } else {
                    values = this.chart.getValues(RoleInterface.ROLE_GROUP);
                    if (values == null) {
                        legend.setVisible(false);
                    } else {
                        v = this.chart.getLabels(RoleInterface.ROLE_GROUP);
                        if (v == null) {
                            v = values;
                        }
                        legend.setValues(v, this.chart.getMarkers(RoleInterface.ROLE_GROUP, values, true), this.chart.getLines(RoleInterface.ROLE_GROUP, values, true), false);
                    }
                }
            }
        } else if (legend == this.shpLegend) {
            values = this.chart.getValues(RoleInterface.ROLE_SHAPE);
            if (values == null) {
                legend.setVisible(false);
            } else if (values.length > 0) {
                clrs = this.chart.getColors(RoleInterface.ROLE_SHAPE, values);
                legend.setValues(clrs, this.chart.getShapeTypes(values), values, this.chart.getShapeFills(values), false);
            }
        }
        this.curLegend = this.getNextLegend();
        return update || legend.isUpdateRequired();
    }

    protected void drawMissingMessage(Graphics g, int errCond) {
        String s;
        Color c;
        Color ctext = Color.black;
        Color clines = Color.black;
        if (g == null) {
            return;
        }
        Font f = g.getFont();
        if (f == null) {
            return;
        }
        int x = this.xMargin;
        int y = this.yMargin;
        int y2 = this.compHeight - this.yMargin;
        FontMetrics fm = g.getFontMetrics(f);
        this.eraseBackground(g);
        if (this.scheme != null && (c = this.scheme.getColorSchemeItemColor(0)) != null) {
            clines = c;
        }
        if (this.scheme != null && (c = this.scheme.getColorSchemeItemColor(11)) != null) {
            ctext = c;
        }
        g.setColor(ctext);
        if (this.chart != null) {
            x = this.xMargin;
            y = this.yMargin;
            y2 = this.compHeight - this.yMargin;
            Object o = this.chart.getVariable("Response");
            if (o != null) {
                s = o.toString();
                if (fm != null) {
                    y = fm.getHeight() + this.yMargin;
                    g.drawString(s, x, y);
                    y += 2;
                    x = this.xMargin + fm.stringWidth(s) / 2;
                }
            }
            if ((o = this.chart.getVariable("Category")) != null) {
                s = o.toString();
                if (fm != null) {
                    y2 = this.compHeight - this.yMargin;
                    g.drawString(s, x + (this.compWidth - fm.stringWidth(s) - x) / 2, y2);
                    y2 -= fm.getHeight() + 2;
                }
            }
            g.setColor(clines);
            g.drawLine(x, y, x, y2);
            g.drawLine(x, y2, this.compWidth - this.xMargin, y2);
        }
        this.loadNLSStrings();
        switch (errCond) {
            case 1: {
                s = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Chart_has_no_data.txt", (String)"Chart has no data");
                break;
            }
            case 2: {
                s = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Chart_max_groups.txt", (String)"Number of Groups exceeds maximum limit.");
                break;
            }
            default: {
                s = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Chart_generic_error.txt", (String)"Chart has an error");
            }
        }
        if (fm != null) {
            x += (this.compWidth - fm.stringWidth(s) - x) / 2;
            y = (y + y2) / 2;
        }
        g.setColor(ctext);
        g.drawString(s, x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.ignorePaint) {
            return;
        }
        super.paintComponent(g);
        this.drawScatterContents(g, -10);
        if (this.xAxisZoomHandler != null && this.mouseOnXAxis) {
            this.xAxisZoomHandler.drawZoomPanIndicator(g);
        }
        if (this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.drawViewportIndicator(g);
        }
        if (this.yAxisZoomHandler != null && this.mouseOnYAxis) {
            this.yAxisZoomHandler.drawZoomPanIndicator(g);
        }
        if (this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.drawViewportIndicator(g);
        }
        this.warningIcon.draw(g);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.callShowTip) {
            this.showTip(g, this.tipX, this.tipY);
        }
    }

    protected void loadNLSStrings() {
        if (this.resbld != null) {
            return;
        }
        this.resbld = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.nlsColorLegend = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.ColorLegendName.txt", (String)"Color");
        this.nlsGroupLegend = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.GroupLegendName.txt", (String)"Group");
        this.nlsShapeLegend = ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.ShapeLegendName.txt", (String)"Shape");
    }

    protected void drawScatterContents(Graphics g, int layer) {
        boolean doBuild = this.doChartBuild(null);
        boolean updateView = this.didChartDataChange() || this.viewUpdate;
        boolean noBackDraw = this.noBackBufferDraw || layer != -10;
        int n = 0;
        int errCond = 0;
        Object o = null;
        Object o2 = null;
        Object o3 = null;
        Object o4 = null;
        Image img = this.backBuffer;
        FontRenderContext fr = null;
        if (this.chart == null) {
            return;
        }
        if (g instanceof Graphics2D) {
            fr = ((Graphics2D)g).getFontRenderContext();
        }
        if (doBuild) {
            n = this.chart.getNumberResponse();
            o = this.chart.getGroup();
            o3 = this.chart.getGroupIndex();
            o4 = this.chart.getVariable("Color");
            o2 = this.chart.getMarkerShape();
            if (o2 != null && !(o2 instanceof String)) {
                o2 = null;
            }
            this.chart.build(null);
            if (this.xAxisZoomHandler != null) {
                this.xAxisZoomHandler.setDataRange(this.chart.getMinX(true), this.chart.getMaxX(true), this.clearViewport);
            }
            if (this.yAxisZoomHandler != null) {
                this.yAxisZoomHandler.setDataRange(this.chart.getMinY(true), this.chart.getMaxY(true), this.clearViewport);
            }
            this.clearViewport = false;
            updateView = this.updateLegend(this.grpLegend) || updateView;
            updateView = this.updateLegend(this.shpLegend) || updateView;
            this.legendUpdateRequired = false;
            this.grpVarValue = o;
            this.clrVarValue = o4;
            this.grpIdxVarValue = o3;
            this.numRespVars = n;
            this.shpVarValue = o2;
        } else if (this.grpLegend != null && this.grpLegend.isVisible() != this.grpLegendVisibleLastDraw || this.shpLegend != null && this.shpLegend.isVisible() != this.shpLegendVisibleLastDraw) {
            updateView = true;
        }
        int curLargestMarker = this.chart.getLargestMarkerDrawn();
        if (curLargestMarker < 0) {
            curLargestMarker = this.chart.getMaximumMarkerSize();
        }
        if (curLargestMarker != this.lastLargestMarker) {
            updateView = true;
        }
        this.lastLargestMarker = curLargestMarker;
        errCond = this.chart.areAllMissing() ? 1 : (this.chart.areMaxGroupsExceeded() ? 2 : 0);
        switch (errCond) {
            case 1: 
            case 2: {
                if (!this.sbSwitchedOff) {
                    this.sbSwitchedOff = this.isScrollItemVisible(0) || this.isScrollItemVisible(1) || this.isScrollItemVisible(2);
                }
                this.drawMissingMessage(g, errCond);
                return;
            }
        }
        if (this.grpLegend != null && this.grpLegend.isVisible()) {
            boolean bl = updateView = updateView || this.grpLegend.isUpdateRequired();
        }
        if (this.shpLegend != null && this.shpLegend.isVisible()) {
            boolean bl = updateView = updateView || this.shpLegend.isUpdateRequired();
        }
        if (updateView) {
            this.updateViewParameters(g, 0);
            this.chart.setDataChanged(false);
        }
        if (noBackDraw || this.bufferUpdateRequired || doBuild || updateView || this.doChartRedraw() || this.wall != null && this.wall.redrawRequired || this.grpLegend != null && this.grpLegend.isVisible() && this.grpLegend.isRedrawRequired() || this.shpLegend != null && this.shpLegend.isVisible() && this.shpLegend.isRedrawRequired()) {
            this.fullDraw(g, layer);
        }
        if (!noBackDraw && img != null) {
            g.drawImage(img, 0, 0, this);
        }
        if (layer == -10 || layer == 35) {
            if (this.chart != null && this.selPickList != null && this.selPickList.size() > 0) {
                this.chart.drawSelectedMarkers((Graphics2D)g, fr, this.selPickList);
            }
            this.drawBrush(g, fr);
        }
        if (this.actionMode == 9) {
            this.drawEditedMarkers(g, fr);
        }
        this.grpLegendVisibleLastDraw = this.grpLegend != null ? this.grpLegend.isVisible() : false;
        this.shpLegendVisibleLastDraw = this.shpLegend != null ? this.shpLegend.isVisible() : false;
    }

    protected void drawBrush(Graphics g, FontRenderContext fr) {
        if (g == null) {
            return;
        }
        if (this.brushRect != null) {
            g.setColor(Color.black);
            g.drawRect(this.brushRect.x, this.brushRect.y, this.brushRect.width, this.brushRect.height);
        }
    }

    protected void drawEditedMarkers(Graphics g, FontRenderContext fr) {
        if (this.chart != null && this.editPickList != null && this.editPickList.size() > 0) {
            this.chart.drawSelectedMarkers((Graphics2D)g, fr, this.editPickList);
            if (this.moveDistance != null && (this.moveDistance.x != 0 || this.moveDistance.y != 0)) {
                this.chart.drawEditedMarkers((Graphics2D)g, fr, this.editPickList, this.moveDistance);
            }
        }
    }

    public void doEdit(MouseEvent e) {
        if (this.actionMode != 9 || !this.isEditable()) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (e == null) {
            return;
        }
        Point p = e.getPoint();
        switch (e.getID()) {
            case 501: {
                this.chart.pick(p.x, p.y, true, -1, true, true, this.additionalPickList);
                if (this.additionalPickList.size() > 0) {
                    for (int i = 0; i < this.additionalPickList.size(); ++i) {
                        if (this.selPickList.contains(this.additionalPickList.elementAt(i))) continue;
                        this.selPickList.add(this.additionalPickList.elementAt(i));
                    }
                }
                this.additionalPickList.removeAllElements();
                this.editPickList.removeAllElements();
                this.editPickList.addAll(this.selPickList);
                if (this.editAnchor == null) {
                    this.editAnchor = new Point();
                }
                this.editAnchor.x = p.x;
                this.editAnchor.y = p.y;
                break;
            }
            case 502: {
                this.updateMoveDistance(p.x, p.y);
                if (this.lastMoveDistance == null) {
                    this.lastMoveDistance = new Point();
                }
                this.lastMoveDistance.x = this.moveDistance.x;
                this.lastMoveDistance.y = this.moveDistance.y;
                this.resetMoveDistance();
                this.chart.moveMarkers(this.editPickList, this.lastMoveDistance);
                this.dataFilter.setSelected((Object)this.editPickList, true, (IOBSInterface)this.chart);
                this.repaint();
                break;
            }
            case 506: {
                this.updateMoveDistance(p.x, p.y);
                this.repaint();
            }
        }
    }

    protected void updateMoveDistance(int x, int y) {
        if (this.moveDistance == null) {
            this.moveDistance = new Point();
        }
        this.moveDistance.x = x - this.editAnchor.x;
        this.moveDistance.y = y - this.editAnchor.y;
    }

    protected void resetMoveDistance() {
        if (this.moveDistance == null) {
            return;
        }
        this.moveDistance.x = 0;
        this.moveDistance.y = 0;
    }

    protected void undoLastEdit() {
        Point p = new Point();
        p.x = -this.lastMoveDistance.x;
        p.y = -this.lastMoveDistance.y;
        this.chart.moveMarkers(this.editPickList, p);
        this.dataFilter.setSelected((Object)this.editPickList, true, (IOBSInterface)this.chart);
    }

    protected void moveBrush(Point p) {
        if (this.brushRect == null || p == null || this.brushLockPoint == null) {
            return;
        }
        int diffx = p.x - this.brushLockPoint.x;
        int diffy = p.y - this.brushLockPoint.y;
        this.brushRect.x += diffx;
        this.brushRect.y += diffy;
        if (this.restrictBrush) {
            if (this.brushRect.x < this.clipAreaX) {
                this.brushRect.x = this.clipAreaX;
            } else if (this.brushRect.x + this.brushRect.width > this.clipAreaX + this.clipAreaWidth) {
                this.brushRect.x = this.clipAreaX + this.clipAreaWidth - this.brushRect.width;
            }
            if (this.brushRect.y < this.clipAreaY) {
                this.brushRect.y = this.clipAreaY;
            } else if (this.brushRect.y + this.brushRect.height > this.clipAreaY + this.clipAreaHeight) {
                this.brushRect.y = this.clipAreaY + this.clipAreaHeight - this.brushRect.height;
            }
        }
        this.brushLockPoint.x = p.x;
        this.brushLockPoint.y = p.y;
        this.doUnSelection(this.selPickList, null);
        this.doSelection(this.selPickList, this.brushRect);
    }

    protected void doUnSelection(Vector selList, Object region) {
        this.chart.setOurPicking(true);
        if (!this.dataListen) {
            selList.removeAllElements();
        } else if (selList.size() > 0) {
            this.ignorePaint = true;
            this.chart.unPick(region, selList);
            this.ignorePaint = false;
        }
        this.chart.setOurPicking(false);
    }

    protected void doSelection(Vector selList, Object region) {
        if (this.chart == null || selList == null) {
            return;
        }
        this.chart.setOurPicking(true);
        this.chart.pick(region, false, 0, true, false, selList);
        if (!this.dataListen || selList.size() <= 0) {
            this.repaint();
        } else {
            this.dataFilter.setSelected((Object)selList, true, (IOBSInterface)this.chart);
        }
        this.chart.setOurPicking(false);
    }

    protected void removeBrush(boolean paint) {
        this.brushRect = null;
        if (this.chart != null) {
            this.chart.setOurPicking(false);
        }
        if (paint) {
            this.paintImmediately(0, 0, this.compWidth, this.compHeight);
        }
    }

    protected boolean checkPopupTrigger(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (!this.allowPopup) {
                return true;
            }
            if (this.menu == null && (this.menu = this.buildMenu()) != null) {
                this.add(this.menu);
            }
            if (this.menu == null) {
                return true;
            }
            if (!this.menu.isVisible()) {
                this.menu.show(this, x, y);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullDraw(Graphics g, int layer) {
        boolean noBackDraw = this.noBackBufferDraw || layer != -10;
        Graphics gDraw = g;
        Rectangle rect = null;
        if (!noBackDraw && this.gBack != null) {
            gDraw = this.gBack;
        }
        if (gDraw == null) {
            return;
        }
        switch (layer) {
            case -10: 
            case 0: {
                this.eraseBackground(gDraw);
            }
        }
        if (this.clipChartArea && this.xAxis != null && (rect = this.xAxis.getScreenArea()) != null) {
            this.clipAreaX = rect.x;
            this.clipAreaY = rect.y;
            this.clipAreaWidth = rect.width;
            this.clipAreaHeight = rect.height;
        }
        switch (layer) {
            case -10: {
                if (this.wall == null) break;
                if (this.clipChartArea) {
                    gDraw.setClip(this.clipAreaX, this.clipAreaY, this.clipAreaWidth + 1, this.clipAreaHeight + 1);
                }
                if (this.wall != null) {
                    this.wall.draw(gDraw, this.clipAreaX, this.clipAreaY, this.clipAreaWidth, this.clipAreaHeight);
                }
                if (!this.clipChartArea) break;
                gDraw.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        switch (layer) {
            case -10: 
            case 20: {
                if (this.xAxis == null) break;
                this.xAxis.draw(gDraw, false);
                this.redrawXAxis = false;
            }
        }
        switch (layer) {
            case -10: 
            case 20: {
                if (this.yAxis == null) break;
                this.yAxis.draw(gDraw, false);
                this.redrawYAxis = false;
            }
        }
        switch (layer) {
            case -10: 
            case 30: {
                if (this.chart == null) break;
                if (this.clipChartArea) {
                    gDraw.setClip(this.clipAreaX, this.clipAreaY, this.clipAreaWidth + 1, this.clipAreaHeight + 1);
                }
                this.chart.draw(gDraw, false);
                if (!this.clipChartArea) break;
                gDraw.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        switch (layer) {
            case -10: 
            case 20: {
                this.xAxis.drawReferenceLines(gDraw);
                this.yAxis.drawReferenceLines(gDraw);
            }
        }
        switch (layer) {
            case -10: 
            case 40: {
                if (this.grpLegend != null) {
                    this.grpLegend.draw(gDraw, false);
                }
                if (this.shpLegend == null) break;
                this.shpLegend.draw(gDraw, false);
            }
        }
        switch (layer) {
            case -10: 
            case 50: {
                if (this.titles != null) {
                    this.titles.draw(gDraw, false);
                }
                if (this.footnotes == null) break;
                this.footnotes.draw(gDraw, false);
            }
        }
        ScatterComponent scatterComponent = this;
        synchronized (scatterComponent) {
            this.bufferUpdateRequired = false;
        }
    }

    protected ColorSchemeInterface getCustomScheme() {
        Color wallClr;
        Color axisClr = null;
        Color labelClr = null;
        Color valueClr = null;
        Color outlineClr = null;
        Color[] dataClrs = null;
        Color[] itemClrs = null;
        ColorScheme out = null;
        ColorInterface colorRamp = null;
        TextStyleInterface ts = null;
        LineStyleInterface ls = null;
        if (this.chart == null || (colorRamp = this.chart.getColorRamp()) == null) {
            return null;
        }
        dataClrs = colorRamp.getColors();
        itemClrs = new Color[18];
        if (itemClrs == null) {
            return null;
        }
        if (this.chart != null) {
            outlineClr = this.chart.getMarkerOutlineColor();
            if (outlineClr == null) {
                outlineClr = Color.black;
            }
        } else {
            outlineClr = Color.black;
        }
        if (this.wall != null) {
            wallClr = this.wall.getSolidBackground();
            if (wallClr == null) {
                wallClr = new Color(225, 225, 255);
            }
        } else {
            wallClr = new Color(225, 225, 255);
        }
        if (this.xAxis != null) {
            ls = this.xAxis.getLine();
            if (ls != null) {
                axisClr = ls.getColor();
            }
            if ((ts = this.xAxis.getLabel()) != null) {
                labelClr = ts.getColor();
            }
            if ((ts = this.xAxis.getValues()) != null) {
                valueClr = ts.getColor();
            }
        } else {
            labelClr = valueClr = Color.black;
            axisClr = valueClr;
        }
        if (labelClr == null) {
            labelClr = Color.black;
        }
        if (valueClr == null) {
            valueClr = Color.black;
        }
        if (axisClr == null) {
            axisClr = Color.black;
        }
        itemClrs[1] = this.backColor;
        itemClrs[15] = wallClr;
        itemClrs[3] = wallClr;
        itemClrs[5] = Color.black;
        itemClrs[10] = Color.black;
        itemClrs[9] = new Color(128, 128, 128);
        itemClrs[8] = Color.black;
        itemClrs[0] = axisClr;
        itemClrs[4] = Color.black;
        itemClrs[6] = outlineClr;
        itemClrs[2] = Color.black;
        itemClrs[11] = labelClr;
        itemClrs[12] = valueClr;
        itemClrs[13] = Color.black;
        out = new ColorScheme("Custom", dataClrs, itemClrs);
        return out;
    }

    protected boolean didChartDataChange() {
        if (this.chart == null) {
            return false;
        }
        return this.chart.getDataChanged();
    }

    protected boolean doChartRedraw() {
        boolean redraw = false;
        if (this.chart == null || this.xAxis == null || this.yAxis == null) {
            return false;
        }
        boolean bl = redraw = this.chart.isRedrawRequired() || this.redrawXAxis || this.redrawYAxis;
        if (this.redrawXAxis || this.redrawYAxis) {
            this.updateViewParameters(null, 0);
        }
        return redraw;
    }

    protected boolean doChartBuild(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (buildData != null && buildData instanceof Boolean && ((Boolean)buildData).booleanValue()) {
            return true;
        }
        return this.chart.isRebuildRequired();
    }

    protected double getXZoom() {
        double dataMin = this.chart.getMinX(true);
        double dataMax = this.chart.getMaxX(true);
        double zoomMin = this.chart.getMinX(false);
        double dataLen = dataMax - dataMin;
        double zoomMax = this.chart.getMaxX(false);
        double zoomLen = zoomMax - zoomMin;
        if (dataLen == zoomLen) {
            return 1.0;
        }
        return zoomLen / dataLen;
    }

    protected double getYZoom() {
        double dataMin = this.chart.getMinY(true);
        double dataMax = this.chart.getMaxY(true);
        double zoomMin = this.chart.getMinY(false);
        double dataLen = dataMax - dataMin;
        double zoomMax = this.chart.getMaxY(false);
        double zoomLen = zoomMax - zoomMin;
        if (dataLen == zoomLen) {
            return 1.0;
        }
        return zoomLen / dataLen;
    }

    protected void doZoom(double xZoom, double yZoom) {
        boolean maintainRatio = false;
        double xlen = 0.0;
        double ylen = 0.0;
        double limit = 1.0E-4;
        if (this.chart == null || Double.isNaN(xZoom) && Double.isNaN(yZoom)) {
            return;
        }
        if (this.chart.isBubbleStylePlot()) {
            maintainRatio = true;
        }
        if (this.globalDefaults != null) {
            limit = this.globalDefaults.zoomLimitParm;
        }
        if (maintainRatio) {
            if (Double.isNaN(yZoom)) {
                yZoom = xZoom;
            } else if (Double.isNaN(xZoom)) {
                xZoom = yZoom;
            } else if (xZoom > yZoom) {
                yZoom = xZoom;
            } else if (yZoom > xZoom) {
                xZoom = yZoom;
            }
        }
        double minX = this.chart.getMinX(false);
        double minY = this.chart.getMinY(false);
        double maxX = this.chart.getMaxX(false);
        double maxY = this.chart.getMaxY(false);
        double fullMinX = this.chart.getMinX(true);
        double fullMinY = this.chart.getMinY(true);
        double fullMaxX = this.chart.getMaxX(true);
        double fullMaxY = this.chart.getMaxY(true);
        double fullLenX = fullMaxX - fullMinX;
        double fullLenY = fullMaxY - fullMinY;
        if (!Double.isNaN(xZoom)) {
            xlen = (fullMaxX - fullMinX) * xZoom;
        }
        if (!Double.isNaN(yZoom)) {
            ylen = (fullMaxY - fullMinY) * yZoom;
        }
        double newMinX = Math.max(minX + xlen / 2.0, fullMinX);
        double newMinY = Math.max(minY + ylen / 2.0, fullMinY);
        double newMaxX = Math.min(maxX - xlen / 2.0, fullMaxX);
        double newMaxY = Math.min(maxY - ylen / 2.0, fullMaxY);
        newMinX = Math.min(newMinX, fullMinX + fullLenX / 2.0 - fullLenX * limit);
        newMinY = Math.min(newMinY, fullMinY + fullLenY / 2.0 - fullLenY * limit);
        newMaxX = Math.max(newMaxX, fullMaxX - fullLenX / 2.0 + fullLenX * limit);
        newMaxY = Math.max(newMaxY, fullMaxY - fullLenY / 2.0 + fullLenY * limit);
        this.setViewport(1, newMinX, newMaxX, newMinY, newMaxY, Double.NaN, Double.NaN);
        this.removeBrush(false);
    }

    @Override
    public void update(Graphics g) {
        this.fullDraw(g, -10);
        this.paint(g);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        Container c = this;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof Frame)) continue;
            this.parentFrame = (Frame)c;
            break;
        }
        if (this.backBuffer == null) {
            this.createBackBuffer();
        }
        try {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.chart != null) {
            this.chart.setRebuildRequired(true);
        }
        this.repaint();
    }

    @Override
    public synchronized void removeNotify() {
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.gBack != null) {
            this.gBack.dispose();
        }
        this.gBack = null;
        if (this.toolBar != null && this.toolBar.isVisible()) {
            this.toolBar.setVisible(false);
        }
        this.addNotifyCalled = false;
        super.removeNotify();
    }

    protected Dimension setLegendDimension(LegendObjectJ2D legend, int lgW, int lgH) {
        Dimension dim = this.nullDim;
        if (this.chart == null || legend == null) {
            return dim;
        }
        int pos = legend.getPosition();
        if (legend.isVisible()) {
            if (pos == 4 || pos == 3) {
                if (lgW < 0) {
                    lgW = (int)((double)this.compWidth * 0.2);
                }
                if (lgH < 0) {
                    lgH = this.compHeight;
                }
                legend.setMaximumSize(lgW, lgH);
            } else {
                if (lgW < 0) {
                    lgW = this.compWidth;
                }
                if (lgH < 0) {
                    lgH = (int)((double)this.compHeight * 0.2);
                }
                legend.setMaximumSize(lgW, lgH);
            }
            dim = legend.getPreferredSize();
            if (dim == null) {
                return this.nullDim;
            }
        }
        return dim;
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.doResize(width, height, true);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.doResize(width, height, true);
    }

    protected Insets updateViewParameters(Graphics g, int insetType) {
        Enumeration e;
        int i;
        int n;
        double[] d;
        Rectangle rect;
        int halfMaxMkrSize;
        double chartMaxY;
        double chartMaxX;
        double chartMinY;
        double chartMinX;
        boolean autoCalcX = true;
        boolean autoCalcY = true;
        boolean dataViewported = false;
        int minLeftWidth = 0;
        int minRightWidth = 0;
        int minBottomHeight = 0;
        int minTopHeight = 0;
        int legendWidth1 = 0;
        int legendHeight1 = 0;
        int legendWidth2 = 0;
        int legendHeight2 = 0;
        int labelHeight = 0;
        int vpWidthAdjust = 0;
        int vpHeightAdjust = 0;
        int vpXOffset = 0;
        int vpYOffset = 0;
        int titleHeight = 0;
        int footnoteHeight = 0;
        int scrollBarWidth = 0;
        int scrollBarHeight = 0;
        int pos1 = -1;
        int pos2 = -1;
        int lgW1 = this.maxLegendWidth;
        int lgH1 = this.maxLegendHeight;
        Insets inset = null;
        Object[] catValues = null;
        Object[] respValues = null;
        Graphics2D gg = g != null && g instanceof Graphics2D ? (Graphics2D)g : this.gBack;
        int lgW2 = lgW1;
        int lgH2 = lgH1;
        if (this.chart == null || this.xAxis == null || this.yAxis == null || this.compWidth <= 0 || this.compHeight <= 0) {
            this.viewUpdate = false;
            switch (insetType) {
                default: {
                    break;
                }
                case 1: {
                    inset = new Insets(this.yMargin, this.xMargin, this.yMargin, this.xMargin);
                    break;
                }
                case 2: {
                    inset = new Insets(0, 0, 0, 0);
                }
            }
            return inset;
        }
        if (this.chart.getLabel() != null) {
            Font f;
            TextStyleInterface ts = this.chart.getLabelText();
            if (ts == null && gg != null) {
                f = gg.getFont();
            } else {
                f = ts.getFont();
                if (f == null && gg != null) {
                    f = gg.getFont();
                }
            }
            if (!this.chart.isBubbleStylePlot() && f != null) {
                FontMetrics fm;
                labelHeight = gg != null && (fm = gg.getFontMetrics(f)) != null ? fm.getHeight() : f.getSize();
            }
        }
        dataViewported = this.chart.isDataViewported();
        catValues = this.chart.getValues(RoleInterface.ROLE_X);
        respValues = this.chart.getValues(RoleInterface.ROLE_Y);
        if (this.mouseDown && (this.mouseMode == 4 || this.mouseMode == 3)) {
            autoCalcY = false;
            autoCalcX = false;
        } else if (this.resetView) {
            if (this.saveAutoCalculateXAxis != null) {
                autoCalcX = this.saveAutoCalculateXAxis;
                this.saveAutoCalculateXAxis = null;
            }
            if (this.saveAutoCalculateYAxis != null) {
                autoCalcY = this.saveAutoCalculateYAxis;
                this.saveAutoCalculateYAxis = null;
            }
        } else if (dataViewported) {
            autoCalcY = false;
            autoCalcX = false;
        } else {
            autoCalcX = this.xAxis.isAxisAutoCalculated();
            autoCalcY = this.yAxis.isAxisAutoCalculated();
        }
        this.chartBBox = this.chart.getBoundingBox();
        if (this.chartBBox == null) {
            this.viewUpdate = false;
            switch (insetType) {
                default: {
                    break;
                }
                case 1: {
                    inset = new Insets(this.yMargin, this.xMargin, this.yMargin, this.xMargin);
                    break;
                }
                case 2: {
                    inset = new Insets(0, 0, 0, 0);
                }
            }
            return inset;
        }
        double axisMinX = chartMinX = this.chartBBox[0];
        double axisMinY = chartMinY = this.chartBBox[1];
        double axisMaxX = chartMaxX = this.chartBBox[3];
        double axisMaxY = chartMaxY = this.chartBBox[4];
        if (this.chart.isBubbleStylePlot()) {
            halfMaxMkrSize = 0;
        } else {
            halfMaxMkrSize = this.chart.getLargestMarkerDrawn();
            if (halfMaxMkrSize < 0) {
                halfMaxMkrSize = this.chart.getMaximumMarkerSize();
            }
        }
        halfMaxMkrSize = (int)Math.ceil((double)halfMaxMkrSize / 2.0);
        this.noMinMax = false;
        if (this.titles != null && (rect = this.titles.getBounds()) != null) {
            titleHeight = rect.height;
        }
        if (this.footnotes != null && (rect = this.footnotes.getBounds()) != null) {
            footnoteHeight = rect.height;
        }
        if (!autoCalcX && (d = this.xAxis.getEndPoint(false, false)) != null) {
            axisMinX = d[0];
            axisMaxX = d[1];
        }
        if (Double.isNaN(axisMinX)) {
            autoCalcX = true;
            axisMinX = chartMinX;
        } else if (dataViewported || this.resetView) {
            axisMinX = chartMinX;
        }
        if (Double.isNaN(axisMaxX)) {
            autoCalcX = true;
            axisMaxX = chartMaxX;
        } else if (dataViewported || this.resetView) {
            axisMaxX = chartMaxX;
        }
        if (!autoCalcY && (d = this.yAxis.getEndPoint(false, false)) != null) {
            axisMinY = d[0];
            axisMaxY = d[1];
        }
        if (Double.isNaN(axisMinY)) {
            autoCalcY = true;
            axisMinY = chartMinY;
        } else if (dataViewported || this.resetView) {
            axisMinY = chartMinY;
        }
        if (Double.isNaN(axisMaxY)) {
            autoCalcY = true;
            axisMaxY = chartMaxY;
        } else if (dataViewported || this.resetView) {
            axisMaxY = chartMaxY;
        }
        if (this.chart.isBubbleStylePlot() && this.equalizeAxes) {
            double min = Math.min(axisMinX, axisMinY);
            double max = Math.max(axisMaxX, axisMaxY);
            axisMinX = axisMinY = min;
            axisMaxX = axisMaxY = max;
        }
        if (this.xDataRange != null && !dataViewported) {
            if (this.xDataRange instanceof ContinuousRange) {
                axisMinX = ((ContinuousRange)this.xDataRange).getMin();
                axisMaxX = ((ContinuousRange)this.xDataRange).getMax();
            } else if (this.xDataRange instanceof DiscreteRange && (n = ((DiscreteRange)this.xDataRange).getValuesSize()) > 0 && (catValues = new Object[n]) != null) {
                i = 0;
                e = ((DiscreteRange)this.xDataRange).getEnumeration();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        catValues[i++] = e.nextElement();
                    }
                }
            }
        }
        if (this.yDataRange != null && !dataViewported) {
            if (this.yDataRange instanceof ContinuousRange) {
                axisMinY = ((ContinuousRange)this.yDataRange).getMin();
                axisMaxY = ((ContinuousRange)this.yDataRange).getMax();
            } else if (this.yDataRange instanceof DiscreteRange && (n = ((DiscreteRange)this.yDataRange).getValuesSize()) > 0 && (respValues = new Object[n]) != null) {
                i = 0;
                e = ((DiscreteRange)this.yDataRange).getEnumeration();
                if (e != null) {
                    while (e.hasMoreElements()) {
                        respValues[i++] = e.nextElement();
                    }
                }
            }
        }
        this.xAxis.setAxis(new Double(axisMinX), new Double(axisMaxX), -1, -1, catValues, new Boolean(autoCalcX), new Boolean(false));
        this.yAxis.setAxis(new Double(axisMinY), new Double(axisMaxY), -1, -1, respValues, new Boolean(autoCalcY), new Boolean(false));
        if (catValues != null && catValues.length > 1) {
            this.xAxis.setAxisEndPoints(axisMinX, axisMinY, 0.0, axisMaxX, axisMaxY, 0.0);
        }
        if (this.grpLegend != null && this.grpLegend.isVisible()) {
            pos1 = this.grpLegend.getPosition();
        }
        if (this.shpLegend != null && this.shpLegend.isVisible()) {
            pos2 = this.shpLegend.getPosition();
        }
        if (pos1 == pos2) {
            switch (pos1) {
                case 3: 
                case 4: {
                    if (lgH1 < 0) {
                        lgH1 = lgH2 = (int)((double)this.compHeight * 0.5);
                        break;
                    }
                    lgH1 = lgH2 = (int)(0.5 * (double)lgH1);
                    break;
                }
                case 1: 
                case 2: {
                    lgW1 = lgW1 < 0 ? (lgW2 = (int)((double)this.compWidth * 0.5)) : (lgW2 = (int)(0.5 * (double)lgW1));
                }
            }
        }
        if (this.grpLegend != null) {
            Dimension dim1 = this.setLegendDimension(this.grpLegend, lgW1, lgH1);
            legendWidth1 += dim1.width;
            legendHeight1 += dim1.height;
            if (dim1.width <= 0 && dim1.height <= 0) {
                pos1 = -1;
            }
        }
        if (this.shpLegend != null) {
            Dimension dim2 = this.setLegendDimension(this.shpLegend, lgW2, lgH2);
            legendWidth2 += dim2.width;
            legendHeight2 += dim2.height;
            if (dim2.width <= 0 && dim2.height <= 0) {
                pos2 = -1;
            }
        }
        if (this.lastLegendWidth1 != legendWidth1 || this.lastLegendHeight1 != legendHeight1 || this.lastLegendWidth2 != legendWidth2 || this.lastLegendHeight2 != legendHeight2) {
            this.lastLegendWidth1 = legendWidth1;
            this.lastLegendHeight1 = legendHeight1;
            this.lastLegendWidth2 = legendWidth2;
            this.lastLegendHeight2 = legendHeight2;
            this.throwMarginChangeEvent();
        }
        block12 : switch (pos1) {
            case 3: {
                switch (pos2) {
                    default: {
                        this.grpLegend.setStartPoint(this.compWidth - legendWidth1 - this.xMargin, (this.compHeight - legendHeight1) / 2);
                        vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                        break block12;
                    }
                    case 3: {
                        this.grpLegend.setStartPoint(this.compWidth - legendWidth1 - this.xMargin, (this.compHeight / 2 - legendHeight1) / 2);
                        this.shpLegend.setStartPoint(this.compWidth - legendWidth2 - this.xMargin, (this.compHeight / 2 - legendHeight2) / 2 + this.compHeight / 2);
                        vpWidthAdjust = Math.max(legendWidth1, legendWidth2) + this.xLegendMargin;
                        break block12;
                    }
                    case 4: {
                        this.grpLegend.setStartPoint(this.compWidth - legendWidth1 - this.xMargin, (this.compHeight - legendHeight1) / 2);
                        this.shpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth1 + legendWidth2 + this.xLegendMargin;
                        vpXOffset = legendWidth2 + this.xLegendMargin;
                        break block12;
                    }
                    case 1: {
                        this.grpLegend.setStartPoint(this.compWidth - legendWidth1 - this.xMargin, (this.compHeight - legendHeight1) / 2);
                        this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.yMargin + titleHeight);
                        vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                        vpYOffset = legendHeight2 + this.yLegendMargin;
                        break block12;
                    }
                    case 2: 
                }
                this.grpLegend.setStartPoint(this.compWidth - legendWidth1 - this.xMargin, (this.compHeight - legendHeight1) / 2);
                this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.compHeight - legendHeight2 - this.yMargin - footnoteHeight);
                vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                break;
            }
            case 4: {
                switch (pos2) {
                    default: {
                        this.grpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight1) / 2);
                        vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                        vpXOffset = legendWidth1 + this.xLegendMargin;
                        break block12;
                    }
                    case 3: {
                        this.grpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight1) / 2);
                        this.shpLegend.setStartPoint(this.compWidth - legendWidth2 - this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth1 + legendWidth2 + this.xLegendMargin;
                        vpXOffset = legendWidth1 + this.xLegendMargin;
                        break block12;
                    }
                    case 4: {
                        this.grpLegend.setStartPoint(this.xMargin, (this.compHeight / 2 - legendHeight1) / 2);
                        this.shpLegend.setStartPoint(this.xMargin, (this.compHeight / 2 - legendHeight2) / 2 + this.compHeight / 2);
                        vpWidthAdjust = Math.max(legendWidth1, legendWidth2) + this.xLegendMargin;
                        vpXOffset = Math.max(legendWidth1, legendWidth2) + this.xLegendMargin;
                        break block12;
                    }
                    case 1: {
                        this.grpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight1) / 2);
                        this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.yMargin + titleHeight);
                        vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                        vpYOffset = legendHeight2 + this.yLegendMargin;
                        vpXOffset = legendWidth1 + this.xLegendMargin;
                        break block12;
                    }
                    case 2: 
                }
                this.grpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight1) / 2);
                this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.compHeight - legendHeight2 - this.yMargin - footnoteHeight);
                vpWidthAdjust = legendWidth1 + this.xLegendMargin;
                vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                vpXOffset = legendWidth1 + this.xLegendMargin;
                break;
            }
            case 1: {
                switch (pos2) {
                    default: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.yMargin + titleHeight);
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        vpYOffset = legendHeight1 + this.yLegendMargin;
                        break block12;
                    }
                    case 3: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.yMargin + titleHeight);
                        this.shpLegend.setStartPoint(this.compWidth - legendWidth2 - this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        vpYOffset = legendHeight1 + this.yLegendMargin;
                        break block12;
                    }
                    case 4: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.yMargin + titleHeight);
                        this.shpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        vpYOffset = legendHeight1 + this.yLegendMargin;
                        vpXOffset = legendWidth2 + this.xLegendMargin;
                        break block12;
                    }
                    case 1: {
                        this.grpLegend.setStartPoint((this.compWidth / 2 - legendWidth1) / 2, this.yMargin + titleHeight);
                        this.shpLegend.setStartPoint((this.compWidth / 2 - legendWidth2) / 2 + this.compWidth / 2, this.yMargin + titleHeight);
                        vpHeightAdjust = Math.max(legendHeight1, legendHeight2) + this.yLegendMargin;
                        vpYOffset = Math.max(legendHeight1, legendHeight2) + this.yLegendMargin;
                        break block12;
                    }
                    case 2: 
                }
                this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.yMargin + titleHeight);
                this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.compHeight - legendHeight2 - this.yMargin - footnoteHeight);
                vpHeightAdjust = legendHeight1 + legendHeight2 + this.yLegendMargin;
                vpYOffset = legendHeight1 + this.yLegendMargin;
                break;
            }
            case 2: {
                switch (pos2) {
                    default: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.compHeight - legendHeight1 - this.yMargin - footnoteHeight);
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        break block12;
                    }
                    case 3: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.compHeight - legendHeight1 - this.yMargin - footnoteHeight);
                        this.shpLegend.setStartPoint(this.compWidth - legendWidth2 - this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        break block12;
                    }
                    case 4: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.compHeight - legendHeight1 - this.yMargin - footnoteHeight);
                        this.shpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        vpHeightAdjust = legendHeight1 + this.yLegendMargin;
                        vpXOffset = legendWidth2 + this.xLegendMargin;
                        break block12;
                    }
                    case 1: {
                        this.grpLegend.setStartPoint((this.compWidth - legendWidth1) / 2, this.compHeight - legendHeight1 - this.yMargin - footnoteHeight);
                        this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.yMargin + titleHeight);
                        vpHeightAdjust = legendHeight1 + legendHeight2 + this.yLegendMargin;
                        vpYOffset = legendHeight2 + this.yLegendMargin;
                        break block12;
                    }
                    case 2: 
                }
                this.grpLegend.setStartPoint((this.compWidth / 2 - legendWidth1) / 2, this.compHeight - legendHeight1 - this.yMargin - footnoteHeight);
                this.shpLegend.setStartPoint((this.compWidth / 2 - legendWidth2) / 2 + this.compWidth / 2, this.compHeight - legendHeight2 - this.yMargin - footnoteHeight);
                vpHeightAdjust = Math.max(legendHeight1, legendHeight2) + this.yLegendMargin;
                break;
            }
            default: {
                switch (pos2) {
                    case 3: {
                        this.shpLegend.setStartPoint(this.compWidth - legendWidth2 - this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        break block12;
                    }
                    case 4: {
                        this.shpLegend.setStartPoint(this.xMargin, (this.compHeight - legendHeight2) / 2);
                        vpWidthAdjust = legendWidth2 + this.xLegendMargin;
                        vpXOffset = legendWidth2 + this.xLegendMargin;
                        break block12;
                    }
                    case 1: {
                        this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.yMargin + titleHeight);
                        vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                        vpYOffset = legendHeight2 + this.yLegendMargin;
                        break block12;
                    }
                    case 2: {
                        this.shpLegend.setStartPoint((this.compWidth - legendWidth2) / 2, this.compHeight - legendHeight2 - this.yMargin - footnoteHeight);
                        vpHeightAdjust = legendHeight2 + this.yLegendMargin;
                    }
                }
            }
        }
        vpYOffset += titleHeight;
        if (insetType == 2 || this.innerMargin == null) {
            this.xAxis.setOffset(halfMaxMkrSize, halfMaxMkrSize);
            this.yAxis.setOffset(halfMaxMkrSize, halfMaxMkrSize + labelHeight);
        } else {
            this.xAxis.setOffset(this.innerMargin.left, this.innerMargin.right);
            this.yAxis.setOffset(this.innerMargin.bottom, this.innerMargin.top);
        }
        if (this.yAxis.getAxisLength() <= 0.0) {
            this.yAxis.setAxisLength(this.compHeight - 2 * this.yMargin - labelHeight - 2 * halfMaxMkrSize - vpHeightAdjust - titleHeight - footnoteHeight);
        }
        minLeftWidth = this.yAxis.getLeftWidth(gg);
        minRightWidth = Math.max(this.yAxis.getRightWidth(gg), this.xAxis.getValueWidth(gg, -1) / 2) + scrollBarWidth;
        minTopHeight = this.xAxis.getTopHeight(gg) + scrollBarHeight;
        if (insetType == 1 || this.outerMargin == null) {
            this.viewportX = this.xMargin + minLeftWidth + halfMaxMkrSize + vpXOffset;
            this.viewportY = this.yMargin + halfMaxMkrSize + vpYOffset + minTopHeight + labelHeight;
            this.viewportWidth = this.compWidth - minLeftWidth - minRightWidth - 2 * this.xMargin - 2 * halfMaxMkrSize - vpWidthAdjust;
        } else {
            this.viewportX = this.outerMargin.left + this.xAxis.getStartOffset();
            this.viewportY = this.outerMargin.top + this.yAxis.getEndOffset();
            this.viewportWidth = this.compWidth - this.outerMargin.right - this.viewportX - this.xAxis.getEndOffset();
        }
        this.xAxis.setAxisLength(this.viewportWidth);
        minBottomHeight = this.xAxis.getBottomHeight(gg);
        this.viewportHeight = insetType == 1 || this.outerMargin == null ? this.compHeight - minBottomHeight - minTopHeight - 2 * this.yMargin - labelHeight - 2 * halfMaxMkrSize - vpHeightAdjust - titleHeight - footnoteHeight : this.compHeight - this.outerMargin.bottom - this.viewportY - this.yAxis.getStartOffset();
        this.yAxis.setAxisLength(this.viewportHeight);
        if (dataViewported) {
            this.xMin = axisMinX;
            this.xMax = axisMaxX;
        } else if (this.xDataRange == null || this.oneXRange || this.xDataRange != null && this.xDataRange instanceof DiscreteRange) {
            if (catValues != null && catValues.length > 1) {
                this.xMin = axisMinX;
                this.xMax = axisMaxX;
            } else {
                d = this.xAxis.getEndPoint(false, false);
                if (d != null) {
                    this.xMin = axisMinX = d[0];
                    this.xMax = axisMaxX = d[1];
                }
            }
        } else if (this.xDataRange instanceof ContinuousRange) {
            this.xMin = axisMinX = ((ContinuousRange)this.xDataRange).getMin();
            this.xMax = axisMaxX = ((ContinuousRange)this.xDataRange).getMax();
        }
        if (dataViewported) {
            this.yMin = axisMinY;
            this.yMax = axisMaxY;
        } else if (this.yDataRange == null || this.oneYRange || this.yDataRange != null && this.yDataRange instanceof DiscreteRange) {
            if (respValues != null && respValues.length > 1) {
                this.yMin = axisMinY;
                this.yMax = axisMaxY;
            } else {
                d = this.yAxis.getEndPoint(false, false);
                if (d != null) {
                    this.yMin = axisMinY = d[0];
                    this.yMax = axisMaxY = d[1];
                }
            }
        } else if (this.yDataRange instanceof ContinuousRange) {
            this.yMin = axisMinY = ((ContinuousRange)this.yDataRange).getMin();
            this.yMax = axisMaxY = ((ContinuousRange)this.yDataRange).getMax();
        }
        this.xScale = (double)this.viewportWidth / (this.xMax - this.xMin);
        this.yScale = (double)this.viewportHeight / (this.yMax - this.yMin);
        if (this.chart.isBubbleStylePlot()) {
            double ylen = this.yMax - this.yMin;
            double xlen = this.xMax - this.xMin;
            if (ylen < xlen) {
                n = (int)((double)this.viewportHeight * ylen / xlen);
                this.viewportY = (this.viewportHeight - n) / 2 + this.viewportY;
                this.viewportHeight = n;
                this.yAxis.setAxisLength(this.viewportHeight);
            } else {
                n = (int)((double)this.viewportWidth * xlen / ylen);
                this.viewportX = (this.viewportWidth - n) / 2 + this.viewportX;
                this.viewportWidth = n;
                this.xAxis.setAxisLength(this.viewportWidth);
            }
            this.xScale = (double)this.viewportWidth / (this.xMax - this.xMin);
            this.yScale = (double)this.viewportHeight / (this.yMax - this.yMin);
        }
        if (pos1 == pos2 && pos1 > 0) {
            switch (pos1) {
                case 3: 
                case 4: {
                    if (legendHeight1 + legendHeight2 > this.viewportHeight) break;
                    Point p = this.grpLegend.getStartPoint();
                    this.grpLegend.setStartPoint(p.x, (this.viewportHeight / 2 - legendHeight1) / 2 + this.viewportY);
                    p = this.shpLegend.getStartPoint();
                    this.shpLegend.setStartPoint(p.x, (this.viewportHeight / 2 - legendHeight2) / 2 + this.viewportHeight / 2 + this.viewportY);
                    break;
                }
                case 1: 
                case 2: {
                    if (legendWidth1 + legendWidth2 > this.viewportWidth) break;
                    Point p = this.grpLegend.getStartPoint();
                    this.grpLegend.setStartPoint((this.viewportWidth / 2 - legendWidth1) / 2 + this.viewportX, p.y);
                    p = this.shpLegend.getStartPoint();
                    this.shpLegend.setStartPoint((this.viewportWidth / 2 - legendWidth2) / 2 + this.viewportWidth / 2 + this.viewportX, p.y);
                }
            }
        } else {
            Point p;
            switch (pos1) {
                case 3: 
                case 4: {
                    if (legendHeight1 > this.viewportHeight) break;
                    p = this.grpLegend.getStartPoint();
                    this.grpLegend.setStartPoint(p.x, (this.viewportHeight - legendHeight1) / 2 + this.viewportY);
                    break;
                }
                case 1: 
                case 2: {
                    if (legendWidth1 > this.viewportWidth) break;
                    p = this.grpLegend.getStartPoint();
                    this.grpLegend.setStartPoint((this.viewportWidth - legendWidth1) / 2 + this.viewportX, p.y);
                }
            }
            switch (pos2) {
                case 3: 
                case 4: {
                    if (legendHeight2 > this.viewportHeight) break;
                    p = this.shpLegend.getStartPoint();
                    this.shpLegend.setStartPoint(p.x, (this.viewportHeight - legendHeight2) / 2 + this.viewportY);
                    break;
                }
                case 1: 
                case 2: {
                    if (legendWidth2 > this.viewportWidth) break;
                    p = this.shpLegend.getStartPoint();
                    this.shpLegend.setStartPoint((this.viewportWidth - legendWidth2) / 2 + this.viewportX, p.y);
                }
            }
        }
        this.project(axisMinX, axisMinY, 0.0, this.temp);
        this.unProject(this.temp[0] - (double)halfMaxMkrSize, this.temp[1] + (double)halfMaxMkrSize, 0.0, this.temp);
        double cbMinX = this.temp[0];
        double cbMinY = this.temp[1];
        this.project(axisMaxX, axisMaxY, 0.0, this.temp);
        this.unProject(this.temp[0] + (double)halfMaxMkrSize, this.temp[1] - (double)halfMaxMkrSize - (double)labelHeight, 0.0, this.temp);
        double cbMaxX = this.temp[0];
        double cbMaxY = this.temp[1];
        this.chart.setChartBorderArea(cbMinX, cbMinY, cbMaxX, cbMaxY);
        this.xAxis.setScreenArea(this.viewportX - this.xAxis.getStartOffset(), this.viewportY - this.yAxis.getEndOffset(), this.viewportWidth + this.xAxis.getStartOffset() + this.xAxis.getEndOffset(), this.viewportHeight + this.yAxis.getStartOffset() + this.yAxis.getEndOffset());
        this.yAxis.setScreenArea(this.viewportX - this.xAxis.getStartOffset(), this.viewportY - this.yAxis.getEndOffset(), this.viewportWidth + this.xAxis.getStartOffset() + this.xAxis.getEndOffset(), this.viewportHeight + this.yAxis.getStartOffset() + this.yAxis.getEndOffset());
        this.viewUpdate = false;
        this.resetView = false;
        switch (insetType) {
            default: {
                break;
            }
            case 1: {
                inset = new Insets(this.viewportY - this.yAxis.getEndOffset(), this.viewportX - this.xAxis.getStartOffset(), this.compHeight - (this.viewportY + this.viewportHeight + this.yAxis.getStartOffset()), this.compWidth - (this.viewportX + this.viewportWidth + this.xAxis.getEndOffset()));
                break;
            }
            case 2: {
                inset = new Insets(halfMaxMkrSize + labelHeight, halfMaxMkrSize, halfMaxMkrSize, halfMaxMkrSize);
            }
        }
        return inset;
    }

    protected Cursor getCustomCursor(int x, int y, String imgName) {
        Image img = null;
        if (imgName == null || this.tk == null || GraphicsEnvironment.isHeadless()) {
            return null;
        }
        img = ResourceLoader.getImage((Component)this, (String)imgName);
        if (img == null) {
            return null;
        }
        return this.tk.createCustomCursor(img, new Point(x, y), imgName);
    }

    protected void checkCursor(int x, int y) {
        if (this.isEditable() && this.actionMode == 9) {
            if (this.mouseDown) {
                this.cursor = moveCursorClose;
                this.setCursor(this.cursor);
            } else {
                this.cursor = moveCursorOpen;
                this.setCursor(this.cursor);
            }
        } else {
            boolean insideBrush;
            boolean bl = insideBrush = this.brushRect == null ? false : this.brushRect.contains(x, y);
            if (insideBrush) {
                if (this.mouseDown && this.cursor != moveCursorClose) {
                    this.cursor = moveCursorClose;
                    this.setCursor(this.cursor);
                } else if (!this.mouseDown && this.cursor != moveCursorOpen) {
                    this.cursor = moveCursorOpen;
                    this.setCursor(this.cursor);
                }
            } else {
                this.cursor = normalCursor;
                this.setCursor(this.cursor);
            }
        }
    }

    protected void setupListeners(boolean listen) {
        if (this.dataFilter == null || this.chart == null) {
            return;
        }
        if (listen) {
            this.dataFilter.addDataFilterListener((Object)this.chart);
            this.dataFilter.addDataFilterListener((Object)this);
        } else {
            this.dataFilter.removeDataFilterListener((Object)this.chart);
            this.dataFilter.removeDataFilterListener((Object)this);
        }
    }

    protected Object fetchProperty(int id) {
        Object out = null;
        MarkerStyleInterface[] ms = null;
        LineStyleInterface[] ls = null;
        if (this.isPropertyPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        if (this.curPropAxis != null && this.curPropAxis.isPropertySupported(id)) {
            switch (id) {
                default: {
                    return this.curPropAxis.getPropertyValue(id);
                }
                case 244: 
                case 245: 
            }
        } else {
            if (this.curLegend != null && this.curLegend.isPropertySupported(id) && id != 443) {
                return this.curLegend.getPropertyValue(id);
            }
            if (this.chart != null && this.chart.isPropertySupported(id)) {
                return this.chart.getPropertyValue(id);
            }
        }
        switch (id) {
            case 433: {
                if (this.chart == null) break;
                Vector<LegendEntry> v = new Vector<LegendEntry>();
                ls = this.chart.getLineStyles();
                ms = this.chart.getMarkerStyles();
                if (ls != null && ms != null && ls.length == ms.length) {
                    for (int l = 0; l < ls.length; ++l) {
                        v.addElement(new LegendEntry(this.getId(), ms[l], ls[l]));
                    }
                } else {
                    int l;
                    if (ls != null) {
                        for (l = 0; l < ls.length; ++l) {
                            v.addElement(new LegendEntry(this.getId(), null, ls[l]));
                        }
                    }
                    if (ms != null) {
                        for (l = 0; l < ms.length; ++l) {
                            v.addElement(new LegendEntry(this.getId(), ms[l], null));
                        }
                    }
                }
                out = v;
                break;
            }
            case 38: {
                if (this.chart == null) break;
                out = new Boolean(this.chart.getUsageMode(2));
                break;
            }
            case 34: {
                if (this.xAxisZoomHandler == null || this.yAxisZoomHandler == null) break;
                out = new Boolean(this.xAxisZoomHandler.isZoomPanEnabled() && this.yAxisZoomHandler.isZoomPanEnabled());
                break;
            }
            case 37: {
                if (this.chart == null) break;
                out = new Boolean(this.chart.isUsingSimpleMarkers());
                break;
            }
            case 24: 
            case 25: {
                this.loadNLSStrings();
                int n = 0;
                Object[] temp = new Object[3];
                if (temp == null) break;
                if (this.chart.getVariable(RoleInterface.ROLE_COLOR) != null) {
                    temp[n++] = this.nlsColorLegend;
                }
                if (this.chart.getVariable(RoleInterface.ROLE_GROUP) != null || this.chart.getNumberResponse() > 1) {
                    temp[n++] = this.nlsGroupLegend;
                }
                if (this.chart.getVariable(RoleInterface.ROLE_SHAPE) != null) {
                    temp[n++] = this.nlsShapeLegend;
                }
                if (n <= 0) break;
                out = new String[n];
                if (out != null) {
                    for (int i = 0; i < n; ++i) {
                        ((String[])out)[i] = (String)temp[i];
                    }
                }
                temp = null;
                break;
            }
            case 32: {
                out = new Integer(this.xMargin);
                break;
            }
            case 33: {
                out = new Integer(this.yMargin);
                break;
            }
            case 28: {
                out = new Boolean(this.getStylesEnabled());
                break;
            }
            case 29: {
                out = this.style;
                break;
            }
            case 31: {
                out = new Boolean(this.isBrushRestricted());
                break;
            }
            case 0: {
                out = this.getColorScheme();
                break;
            }
            case 2: {
                out = new Boolean(this.tipsOn);
                break;
            }
            case 3: {
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null) break;
                out = tbg.getFontObject();
                break;
            }
            case 4: {
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null) break;
                out = tbg.getChartTipTextColor();
                break;
            }
            case 5: {
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null) break;
                out = tbg.getChartTipBorderColor();
                break;
            }
            case 6: {
                out = this.tipBackColor;
                break;
            }
            case 8: {
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null) break;
                out = new Double(tbg.getChartTipOpacity());
                break;
            }
            case 9: 
            case 10: {
                out = this.getGraphBackground();
                break;
            }
            case 11: {
                out = new Boolean(this.supportsGradientBackground());
                break;
            }
            case 12: {
                out = new Boolean(this.supportsImageBackground());
                break;
            }
            case 13: {
                out = this.backColor;
                break;
            }
            case 14: {
                out = this.backColor2;
                break;
            }
            case 7: {
                out = this.getTipBackGround();
                break;
            }
            case 15: {
                out = new Integer(this.gradientOrientation);
                break;
            }
            case 16: {
                out = this.backImage;
                break;
            }
            case 17: {
                out = new Integer(this.imageFitStyle);
                break;
            }
            case 18: {
                out = new Integer(this.imageX);
                break;
            }
            case 19: {
                out = new Integer(this.imageY);
                break;
            }
            case 20: {
                out = new Double(this.imageBlend);
                break;
            }
            case 21: {
                out = this.getSolidBackground();
                break;
            }
            case 22: {
                break;
            }
            case 443: {
                if (this.curLegend == null) break;
                out = this.curLegend.getLegendNumber(this.curLegend.getPosition());
                break;
            }
            case 27: {
                if (this.wall == null) break;
                out = this.wall.getGraphBackground();
                break;
            }
            case 26: {
                if (this.wall == null) break;
                out = new Boolean(this.wall.isVisible());
                break;
            }
            case 23: {
                this.loadNLSStrings();
                if (this.curLegend == null) {
                    out = null;
                    break;
                }
                if (this.curLegend == this.shpLegend) {
                    out = this.nlsShapeLegend;
                    break;
                }
                if (this.clrVarValue != null) {
                    out = this.nlsColorLegend;
                    break;
                }
                out = this.nlsGroupLegend;
                break;
            }
            case 2059: {
                out = new Boolean(this.restrictPan);
                break;
            }
            case 2060: {
                out = new Boolean(this.printToPage);
                break;
            }
            case 601: {
                out = this.titles.getTitle(0);
                break;
            }
            case 602: {
                out = this.titles.getTitle(1);
                break;
            }
            case 603: {
                out = this.footnotes.getFootnote(0);
                break;
            }
            case 244: {
                out = new Boolean(this.xReverse);
                break;
            }
            case 245: {
                out = new Boolean(this.yReverse);
            }
        }
        return out;
    }

    protected boolean handleProperty(int id, Object valueIn, boolean execute, boolean verify) {
        Object c1 = null;
        Object c2 = null;
        Object dir = null;
        if (!execute && this.pendingProperties == null) {
            return false;
        }
        Object value = valueIn == null || !(valueIn instanceof PropertyEvent) ? valueIn : ((PropertyEvent)valueIn).value;
        switch (id) {
            case 38: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                if (((Boolean)value).booleanValue()) {
                    this.noBackBufferDraw = true;
                }
                if (this.chart == null) break;
                this.chart.setUsageMode(2, (Boolean)value);
                break;
            }
            case 24: 
            case 25: {
                return verify;
            }
            case 62: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.setId(value);
                break;
            }
            case 34: {
                if (verify) {
                    return true;
                }
                if (!execute || !(value instanceof Boolean)) break;
                if (this.xAxisZoomHandler != null) {
                    this.xAxisZoomHandler.setZoomPanEnabled((Boolean)value);
                }
                if (this.yAxisZoomHandler != null) {
                    this.yAxisZoomHandler.setZoomPanEnabled((Boolean)value);
                }
                this.viewUpdate = true;
                break;
            }
            case 238: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                switch (((Number)value).intValue()) {
                    case 0: {
                        this.curPropAxis = this.xAxis;
                        break;
                    }
                    case 1: {
                        this.curPropAxis = this.yAxis;
                    }
                }
                return true;
            }
            case 244: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                boolean bValue = (Boolean)value;
                if (this.chart == null) break;
                this.xReverse = bValue;
                this.viewUpdate = true;
                break;
            }
            case 245: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                boolean bValue = (Boolean)value;
                if (this.chart == null) break;
                this.yReverse = bValue;
                this.viewUpdate = true;
                break;
            }
            case 37: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute || this.chart == null) break;
                this.chart.setUseSimpleMarkers((Boolean)value);
                break;
            }
            case 32: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.xMargin = ((Number)value).intValue();
                break;
            }
            case 33: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.yMargin = ((Number)value).intValue();
                break;
            }
            case 31: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setBrushRestricted((Boolean)value);
                break;
            }
            case 28: {
                if (!verify) break;
                return true;
            }
            case 29: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.setStyle(value);
                break;
            }
            case 0: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.setColorScheme(value);
                break;
            }
            case 2: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.tipsOn = (Boolean)value;
                break;
            }
            case 3: {
                if (verify) {
                    return true;
                }
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null || value == null || !(value instanceof Font)) {
                    return false;
                }
                if (!execute) break;
                tbg.setFontObject((Font)value);
                break;
            }
            case 4: {
                if (verify) {
                    return true;
                }
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null || value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute) break;
                tbg.setChartTipTextColor(value);
                break;
            }
            case 5: {
                if (verify) {
                    return true;
                }
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null || value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute) break;
                tbg.setChartTipBorderColor(value);
                break;
            }
            case 6: {
                if (verify) {
                    return true;
                }
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null || value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute) break;
                tbg.setSolidBackground(value);
                break;
            }
            case 8: {
                if (verify) {
                    return true;
                }
                ToolTip tbg = this.getTipBackGround();
                if (tbg == null || value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                tbg.setChartTipOpacity(((Number)value).doubleValue());
                break;
            }
            case 10: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                if (verify) {
                    return true;
                }
                switch (id) {
                    case 13: {
                        c1 = value;
                        break;
                    }
                    case 14: {
                        c2 = value;
                        break;
                    }
                    case 15: {
                        dir = value;
                    }
                }
                if (!execute) break;
                this.setGradientBackground(c1, c2, dir);
                break;
            }
            case 16: {
                if (verify) {
                    return true;
                }
                if (value != null && !(value instanceof Image)) {
                    return false;
                }
                if (!execute) break;
                this.setImageBackground((Image)value, new Integer(this.imageFitStyle), this.imageX, this.imageY, this.imageBlend);
                break;
            }
            case 17: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number) && !(value instanceof String)) {
                    return false;
                }
                if (!execute) break;
                this.setImageBackground(this.backImage, value, this.imageX, this.imageY, this.imageBlend);
                break;
            }
            case 18: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setImageBackground(this.backImage, new Integer(this.imageFitStyle), ((Number)value).intValue(), this.imageY, this.imageBlend);
                break;
            }
            case 19: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setImageBackground(this.backImage, new Integer(this.imageFitStyle), this.imageX, ((Number)value).intValue(), this.imageBlend);
                break;
            }
            case 20: {
                if (verify) {
                    return true;
                }
                if (value != null && !(value instanceof Image)) {
                    return false;
                }
                if (!execute) break;
                this.setImageBackground((Image)value, new Integer(this.imageFitStyle), this.imageX, this.imageY, this.imageBlend);
                break;
            }
            case 21: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Color)) {
                    return false;
                }
                if (!execute) break;
                this.setSolidBackground(value);
                break;
            }
            case 22: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.repaint();
                break;
            }
            case 443: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof String) && !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setLegendPosition(null, value);
                break;
            }
            case 27: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute || this.wall == null || !(value instanceof Color)) break;
                this.wall.setSolidBackground((Color)value);
                break;
            }
            case 26: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute || this.wall == null) break;
                this.wall.setVisible((Boolean)value);
                break;
            }
            case 23: {
                if (verify) {
                    return true;
                }
                if (value == null || this.chart == null) {
                    return false;
                }
                int i = this.chart.getRoleIntValue(value);
                switch (i) {
                    case 2: 
                    case 6: {
                        this.curLegend = this.grpLegend;
                        break;
                    }
                    case 18: {
                        this.curLegend = this.shpLegend;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            case 2059: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.restrictPan = (Boolean)value;
                break;
            }
            case 2060: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.printToPage = (Boolean)value;
                break;
            }
            case 604: 
            case 605: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                int i = id == 605 ? 1 : 0;
                if (!execute) break;
                if (value instanceof String) {
                    this.setTitle(i, (String)value);
                    break;
                }
                if (!(value instanceof TextStyleInterface)) break;
                this.setTitle(i, (TextStyleInterface)value);
                break;
            }
            case 606: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                if (value instanceof String) {
                    this.setFootnote(0, (String)value);
                    break;
                }
                if (!(value instanceof TextStyleInterface)) break;
                this.setFootnote(0, (TextStyleInterface)value);
                break;
            }
            default: {
                if (this.curPropAxis != null && this.curPropAxis.isPropertySupported(id)) {
                    if (verify) {
                        return true;
                    }
                    return this.curPropAxis.setPropertyValue(id, value);
                }
                if (this.chart != null && this.chart.isPropertySupported(id)) {
                    if (verify) {
                        return true;
                    }
                    return this.chart.setPropertyValue(id, value);
                }
                if (this.curLegend != null && this.curLegend.isPropertySupported(id)) {
                    if (verify) {
                        return true;
                    }
                    return this.curLegend.setPropertyValue(id, value);
                }
                return false;
            }
        }
        if (!execute) {
            this.pendingProperties.store(id, value);
        }
        return true;
    }

    protected boolean insideChartArea(Point p) {
        return p.x >= this.clipAreaX && p.x <= this.clipAreaX + this.clipAreaWidth && p.y >= this.clipAreaY && p.y <= this.clipAreaY + this.clipAreaHeight;
    }

    protected Point limitBrushPoint(Point p) {
        int ix = p.x;
        int iy = p.y;
        if (ix < this.clipAreaX) {
            ix = this.clipAreaX;
        } else if (ix > this.clipAreaX + this.clipAreaWidth) {
            ix = this.clipAreaX + this.clipAreaWidth;
        }
        if (iy < this.clipAreaY) {
            iy = this.clipAreaY;
        } else if (iy > this.clipAreaY + this.clipAreaHeight) {
            iy = this.clipAreaY + this.clipAreaHeight;
        }
        return new Point(ix, iy);
    }

    protected TabbedPropertiesDialog ensurePropertyDialog(Object listener) {
        JComponent jc = this;
        ScatterComponent pi = this;
        if (this.newPropDlg != null) {
            return this.newPropDlg;
        }
        if (listener != null && listener instanceof PropertyInterface) {
            pi = (PropertyInterface)listener;
        }
        if (listener != null && listener instanceof JComponent) {
            jc = (JComponent)listener;
        }
        if ((this.newPropDlg = new TabbedPropertiesDialog(this.parentFrame, jc, ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Scatter_Properties_Dialog_Title.txt", (String)"Scatter Properties"))) == null) {
            return null;
        }
        this.loadNLSStrings();
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Graph_Panel_Title.txt", (String)"Graph"), new GraphPanel(pi, this.getTipBackGround()));
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Plot_Panel_Title.txt", (String)"Plot"), new ScatterPanel(pi));
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Axis_Panel_Title.txt", (String)"Axis"), new AxisPanel(pi, pi));
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Legend_Panel_Title.txt", (String)"Legend"), new LegendPanel(pi));
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.TitleAndFootnote_Panel_Title.txt", (String)"Title/Footnote"), new TitlePanel(pi, jc));
        this.newPropDlg.addTab(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Advanced_Panel_Title.txt", (String)"Advanced"), new ScatterAdvancedPanel(pi));
        this.newPropDlg.setActiveTab(1);
        return this.newPropDlg;
    }

    protected DataOptionsDialog ensureDataDialog(Object listener) {
        JComponent jc = this;
        RoleInterface ri = this;
        if (this.newDataDlg != null) {
            return this.newDataDlg;
        }
        if (listener != null) {
            if (listener instanceof RoleInterface) {
                ri = (RoleInterface)listener;
            }
            if (listener instanceof JComponent) {
                jc = (JComponent)listener;
            }
        }
        this.newDataDlg = new DataOptionsDialog(ri, jc, this.parentFrame);
        return this.newDataDlg;
    }

    protected void throwMarginChangeEvent() {
        int n = 0;
        MarginChangeEvent e = null;
        if (this.marginListeners == null || (n = this.marginListeners.size()) <= 0) {
            return;
        }
        Object[] listeners = new MarginListener[n];
        if (listeners == null) {
            return;
        }
        e = new MarginChangeEvent((Object)this);
        this.marginListeners.copyInto(listeners);
        for (int i = 0; i < n; ++i) {
            if (listeners[i] == null) continue;
            listeners[i].marginChanged(e);
        }
    }

    protected void throwRangeChangeEvent(Object source, byte type, DataRange range, byte dimension) {
        int n = 0;
        RangeChangedEvent e = null;
        if (this.dataRangeListeners == null || (n = this.dataRangeListeners.size()) <= 0) {
            return;
        }
        Object[] listeners = new RangeChangeListener[n];
        if (listeners == null) {
            return;
        }
        e = new RangeChangedEvent(source, type, range, dimension);
        this.dataRangeListeners.copyInto(listeners);
        for (int i = 0; i < n; ++i) {
            if (listeners[i] == null) continue;
            listeners[i].rangeChanged(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.callShowTip = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean ctrlIsDown = false;
        if (this.xAxis != null && this.saveAutoCalculateXAxis == null) {
            this.saveAutoCalculateXAxis = new Boolean(this.xAxis.isAxisAutoCalculated());
        }
        if (this.yAxis != null && this.saveAutoCalculateYAxis == null) {
            this.saveAutoCalculateYAxis = new Boolean(this.yAxis.isAxisAutoCalculated());
        }
        if (this.xAxisZoomHandler != null && this.mouseOnXAxis) {
            this.xAxisZoomHandler.mousePressed(e);
            return;
        }
        if (this.yAxisZoomHandler != null && this.mouseOnYAxis) {
            this.yAxisZoomHandler.mousePressed(e);
            return;
        }
        if (this.checkPopupTrigger(e)) {
            return;
        }
        this.mouseDown = true;
        if ((e.getModifiers() & 2) != 0) {
            ctrlIsDown = true;
        }
        this.mouseMode = this.actionMode;
        Point p = e.getPoint();
        this.checkCursor(p.x, p.y);
        switch (this.mouseMode) {
            case 2: {
                this.lastMouseX = p.x;
                this.lastMouseY = p.y;
                this.rb.anchor(p);
                break;
            }
            case 3: 
            case 4: {
                this.lastMouseX = p.x;
                this.lastMouseY = p.y;
                break;
            }
            case 1: {
                boolean bl = this.creatingBrush = this.brushRect == null || !this.brushRect.contains(p);
                if (this.creatingBrush) {
                    if (this.restrictBrush && !this.insideChartArea(p)) {
                        this.creatingBrush = false;
                        this.dataFilter.unselectAll();
                        this.removeBrush(true);
                        return;
                    }
                    this.removeBrush(true);
                    this.rb.anchor(p);
                    break;
                }
                this.brushLockPoint = p;
                break;
            }
            case 9: {
                this.doEdit(e);
                break;
            }
            case 6: 
            case 8: {
                int n;
                boolean selecting;
                if (this.chart == null) break;
                this.editPickList.removeAllElements();
                boolean bl = selecting = this.mouseMode == 6 && this.selectBehavior == 0;
                if (selecting && !ctrlIsDown && this.dataFilter != null) {
                    this.dataFilter.setSelected((Object)this.selPickList, false, (IOBSInterface)this.chart);
                }
                this.rubberbanding = false;
                switch (this.selectBehavior) {
                    default: {
                        n = this.chart.pick(p.x, p.y, selecting, -1, false, selecting, null);
                        break;
                    }
                    case 1: 
                    case 2: {
                        n = this.chart.pick(p.x, p.y, false, -1, true, false, this.otherPickList);
                    }
                }
                if (this.mouseMode == 8) {
                    this.throwDrilldownEvent(n);
                } else if (!selecting) {
                    this.handleSelectEvent(n, this.otherPickList);
                }
                if (n > 0) break;
                this.lastMouseX = p.x;
                this.lastMouseY = p.y;
                this.rubberbanding = true;
                this.rb.anchor(p);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean ctrlIsDown = false;
        Point p = e.getPoint();
        Rectangle rect = null;
        if (this.warningIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.resetViewport();
            this.xAxisZoomHandler.viewportChanged(new ViewportEvent(this, 0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN));
            this.yAxisZoomHandler.viewportChanged(new ViewportEvent(this, 0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN));
            return;
        }
        if (this.xAxisZoomHandler != null && this.mouseOnXAxis) {
            this.xAxisZoomHandler.mouseReleased(e);
            return;
        }
        if (this.yAxisZoomHandler != null && this.mouseOnYAxis) {
            this.yAxisZoomHandler.mouseReleased(e);
            return;
        }
        if (this.checkPopupTrigger(e)) {
            return;
        }
        this.mouseDown = false;
        if ((e.getModifiers() & 2) != 0) {
            ctrlIsDown = true;
        }
        this.checkCursor(p.x, p.y);
        switch (this.mouseMode) {
            case 9: {
                this.doEdit(e);
                break;
            }
            case 6: {
                int n;
                boolean selecting;
                if (!this.rubberbanding) break;
                this.rb.end(p);
                boolean bl = selecting = this.selectBehavior == 0;
                if (selecting && !ctrlIsDown && this.dataFilter != null) {
                    this.ignorePaint = true;
                    this.dataFilter.setSelected((Object)this.selPickList, false, (IOBSInterface)this.chart);
                    this.ignorePaint = false;
                }
                rect = this.rb.bounds();
                switch (this.selectBehavior) {
                    default: {
                        n = this.chart.pick(rect, true, -1, false, true, null);
                        break;
                    }
                    case 1: 
                    case 2: {
                        n = this.chart.pick(rect, false, 0, true, false, this.otherPickList);
                        this.handleSelectEvent(n, this.otherPickList);
                    }
                }
                if (n > 0) break;
                this.repaint();
                break;
            }
            case 2: {
                this.rb.end(p);
                if (this.chart == null || (rect = this.rb.bounds()) == null) break;
                int rw = rect.width;
                int rh = rect.height;
                if (rw > 5 && rh > 5) {
                    double x1 = rect.x;
                    double x2 = rect.x + rect.width;
                    double y1 = rect.y;
                    double y2 = rect.y + rect.height;
                    if (this.xReverse) {
                        x1 = rect.x + rect.width;
                        x2 = rect.x;
                    }
                    if (this.yReverse) {
                        y1 = rect.y + rect.height;
                        y2 = rect.y;
                    }
                    this.unProject(x1, y1, 0.0, this.temp);
                    double minx = this.temp[0];
                    double maxy = this.temp[1];
                    this.unProject(x2, y2, 0.0, this.temp);
                    double maxx = this.temp[0];
                    double miny = this.temp[1];
                    this.setViewport(1, minx, maxx, miny, maxy, Double.NaN, Double.NaN);
                    this.repaint();
                    break;
                }
                return;
            }
            case 3: 
            case 4: {
                if (this.chart == null) break;
                this.chart.setDataChanged(true);
                this.repaint();
                break;
            }
            case 1: {
                if (!this.creatingBrush) break;
                if (this.restrictBrush) {
                    p = this.limitBrushPoint(p);
                }
                this.rb.end(p);
                this.brushRect = this.rb.bounds();
                this.creatingBrush = false;
                this.doUnSelection(this.selPickList, null);
                this.doSelection(this.selPickList, this.brushRect);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        int x = p.x;
        int y = p.y;
        if (this.xAxisZoomHandler != null && this.mouseOnXAxis) {
            this.xAxisZoomHandler.mouseDragged(e);
            return;
        }
        if (this.yAxisZoomHandler != null && this.mouseOnYAxis) {
            this.yAxisZoomHandler.mouseDragged(e);
            return;
        }
        switch (this.mouseMode) {
            case 9: {
                if (!this.isEditable() || this.chart == null) break;
                this.doEdit(e);
                break;
            }
            case 6: {
                if (!this.rubberbanding) break;
            }
            case 2: {
                this.rb.stretch(p);
                break;
            }
            case 3: {
                x = p.x;
                y = p.y;
                double xdiff = (double)(x - this.lastMouseX) / (double)this.compWidth;
                double ydiff = (double)(this.lastMouseY - y) / (double)this.compHeight;
                this.doZoom(xdiff, ydiff);
                this.chart.setDataChanged(true);
                this.viewUpdate = true;
                this.repaint();
                this.lastMouseX = x;
                this.lastMouseY = y;
                break;
            }
            case 4: {
                if (this.chart == null) break;
                double minX = this.chart.getMinX(false);
                double minY = this.chart.getMinY(false);
                double maxX = this.chart.getMaxX(false);
                double maxY = this.chart.getMaxY(false);
                double xlen = maxX - minX;
                double ylen = maxY - minY;
                double fullMinX = this.chart.getMinX(true);
                double fullMinY = this.chart.getMinY(true);
                double fullMaxX = this.chart.getMaxX(true);
                double fullMaxY = this.chart.getMaxY(true);
                this.unProject(this.lastMouseX, this.lastMouseY, 0.0, this.temp);
                double oldX = this.temp[0];
                double oldY = this.temp[1];
                this.unProject(x, y, 0.0, this.temp);
                double newX = this.temp[0];
                double newY = this.temp[1];
                double xdiff = newX - oldX;
                double ydiff = newY - oldY;
                double newMinX = minX - xdiff;
                double newMinY = minY - ydiff;
                double newMaxX = newMinX + xlen;
                double newMaxY = newMinY + ylen;
                if (this.restrictPan) {
                    if (newMinX < fullMinX) {
                        newMinX = fullMinX;
                        newMaxX = newMinX + xlen;
                    } else if (newMaxX > fullMaxX) {
                        newMaxX = fullMaxX;
                        newMinX = newMaxX - xlen;
                    }
                    if (newMinY < fullMinY) {
                        newMinY = fullMinY;
                        newMaxY = newMinY + ylen;
                    } else if (newMaxY > fullMaxY) {
                        newMaxY = fullMaxY;
                        newMinY = newMaxY - ylen;
                    }
                }
                this.lastMouseX = x;
                this.lastMouseY = y;
                this.setViewport(1, newMinX, newMaxX, newMinY, newMaxY, Double.NaN, Double.NaN);
                this.viewUpdate = true;
                this.repaint();
                break;
            }
            case 1: {
                if (this.creatingBrush) {
                    if (this.restrictBrush) {
                        p = this.limitBrushPoint(p);
                    }
                    this.rb.stretch(p);
                    break;
                }
                this.moveBrush(p);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.xAxisZoomHandler != null && this.xAxisZoomHandler.isMouseInZoomPanArea(e)) {
            this.xAxisZoomHandler.mouseMoved(e);
            this.mouseOnXAxis = true;
            return;
        }
        this.mouseOnXAxis = false;
        if (this.yAxisZoomHandler != null && this.yAxisZoomHandler.isMouseInZoomPanArea(e)) {
            this.yAxisZoomHandler.mouseMoved(e);
            this.mouseOnYAxis = true;
            return;
        }
        this.mouseOnYAxis = false;
        this.checkCursor(x, y);
        if (this.chart == null) {
            return;
        }
        if (!this.tipsOn) {
            return;
        }
        this.callShowTip = true;
        this.tipX = x;
        this.tipY = y;
        this.paintImmediately(0, 0, this.compWidth, this.compHeight);
        this.callShowTip = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object item = e.getSource();
        String ac = e.getActionCommand();
        if (item == this.propMI || ac != null && ac.equals(this.propAC)) {
            if (this.newPropDlg == null) {
                this.newPropDlg = this.ensurePropertyDialog(this);
            }
            if (this.newPropDlg != null && this.newPropDlg.isShowing()) {
                this.newPropDlg.toFront();
            } else if (this.newPropDlg != null) {
                this.newPropDlg.setVisible(true);
            }
            return;
        }
        if (item == this.dataMI || ac != null && ac.equals(this.dataAC)) {
            if (this.newDataDlg == null && (this.newDataDlg = this.ensureDataDialog(this)) == null) {
                return;
            }
            if (this.newDataDlg.isShowing()) {
                this.newDataDlg.toFront();
            } else {
                this.newDataDlg.setVisible(true);
            }
            return;
        }
        if (item == this.copyMI || ac != null && ac.equals(this.copyAC)) {
            CopyToClipboard.toClipboard(this);
        } else if (this.chart != null && (item == this.plotTypeMI || item == this.lineTypeMI || ac != null && (ac.equals(this.plotTypeAC) || ac.equals(this.lineTypeAC)))) {
            boolean b = item == this.lineTypeMI || ac.equals(this.lineTypeAC);
            this.setLineStylePlot(b);
            this.repaint();
        } else if (this.chart == null || item != this.bandTypeMI && (ac == null || !ac.equals(this.bandTypeAC))) {
            if (item == this.tbMI || ac != null && ac.equals(this.tbAC)) {
                Component dlg = this.getToolBar();
                if (dlg == null) {
                    return;
                }
                if (dlg.isShowing()) {
                    if (dlg instanceof Dialog) {
                        ((Dialog)dlg).toFront();
                    }
                } else {
                    dlg.setVisible(true);
                }
            } else if (item == this.saveDataMI || ac != null && ac.equals(this.saveDataAC)) {
                if (Filter2XML.saveAsXML((DataFilterReadInterface)this.dataFilter, (String)"SaveOutput.xml", (boolean)false, (boolean)false, (boolean)false)) {
                    System.out.println("Data saved to 'SaveOutput.xml'");
                } else {
                    System.out.println("Data save failed");
                }
            } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_BRUSH")) {
                this.setActionMode(1);
            } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_SELECT")) {
                this.setActionMode(6);
            } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_VIEWPORT")) {
                this.setActionMode(2);
            } else if (ac != null && ac.equalsIgnoreCase("ACTION_MODE_RESET")) {
                this.setActionMode(5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0xC0) != 0) {
            return false;
        }
        if ((flags & 0x20) != 0) {
            if (this.imageFitStyle == 0) {
                this.scaledBackImage = img;
            }
            ScatterComponent scatterComponent = this;
            synchronized (scatterComponent) {
                this.bufferUpdateRequired = true;
            }
            this.repaint();
            return false;
        }
        return true;
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] array = null;
        if (this.backImage != null) {
            array = new Object[4];
            if (array == null) {
                return null;
            }
            array[0] = this.gp != null ? this.gp : this.getBackground();
            array[1] = this.backImage;
            array[2] = new Integer(this.imageFitStyle);
            array[3] = new Double(this.imageBlend);
            return array;
        }
        array = new Object[1];
        if (array == null) {
            return null;
        }
        array[0] = this.backImage != null ? this.backImage : (this.gp != null ? this.gp : this.getBackground());
        return array;
    }

    @Override
    public boolean supportsImageBackground() {
        if (this.globalDefaults == null) {
            return true;
        }
        return this.globalDefaults.allowImageBackgrounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        ScatterComponent scatterComponent;
        int fit = this.imageFitStyle;
        int flags = 0;
        Image tmp = null;
        if (img == null) {
            this.backImage = null;
            this.scaledBackImage = null;
            ScatterComponent scatterComponent2 = this;
            synchronized (scatterComponent2) {
                this.bufferUpdateRequired = true;
                return true;
            }
        }
        if (fitStyle != null) {
            if (fitStyle instanceof String) {
                if (((String)fitStyle).equalsIgnoreCase("Stretch") || ((String)fitStyle).equalsIgnoreCase("Stretch to fit")) {
                    fit = 0;
                } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                    fit = 1;
                } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                    fit = 2;
                } else if (((String)fitStyle).equalsIgnoreCase("Locate")) {
                    fit = 3;
                    this.imageX = x;
                    this.imageY = y;
                } else if (((String)fitStyle).equalsIgnoreCase("Top Center")) {
                    fit = 4;
                } else if (((String)fitStyle).equalsIgnoreCase("Top Left")) {
                    fit = 6;
                } else if (((String)fitStyle).equalsIgnoreCase("Bottom Left")) {
                    fit = 7;
                } else {
                    if (!((String)fitStyle).equalsIgnoreCase("Bottom Right")) return false;
                    fit = 5;
                }
            } else if (fitStyle instanceof Number) {
                fit = ((Number)fitStyle).intValue();
            }
        }
        if (!Double.isNaN(blend) && !Double.isInfinite(blend)) {
            this.imageBlend = blend;
        }
        if (this.imageBlend < 0.0) {
            this.imageBlend = 0.0;
        } else if (this.imageBlend > 1.0) {
            this.imageBlend = 1.0;
        }
        switch (fit) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.backImage = img;
                this.scaledBackImage = null;
                this.imageFitStyle = fit;
                break;
            }
            case 0: {
                if (this.tk == null) {
                    return false;
                }
                scatterComponent = this;
                synchronized (scatterComponent) {
                    this.imageFitStyle = fit;
                    this.backImage = img;
                    this.scaledBackImage = null;
                }
                tmp = img.getScaledInstance(this.compWidth, this.compHeight, 1);
                if (tmp == null || ((flags = this.tk.checkImage(img, -1, -1, this)) & 0x20) == 0) break;
                this.scaledBackImage = tmp;
            }
        }
        scatterComponent = this;
        synchronized (scatterComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        int y2;
        int y1;
        int x1;
        int x2;
        Color c2;
        Color c1;
        int orient = this.gradientOrientation;
        GradientPaint gpNew = null;
        Image img = null;
        Graphics2D g = null;
        if (startColor == null) {
            c1 = this.backColor;
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = ColorParse.getColorFromString((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = this.backColor2 == null ? this.backColor : this.backColor2;
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = ColorParse.getColorFromString((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof String) {
                if (((String)orientation).equalsIgnoreCase("Left to right")) {
                    orient = 0;
                } else if (((String)orientation).equalsIgnoreCase("Right to left")) {
                    orient = 1;
                } else if (((String)orientation).equalsIgnoreCase("Top to bottom")) {
                    orient = 2;
                } else if (((String)orientation).equalsIgnoreCase("Bottom to top")) {
                    orient = 3;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    orient = 4;
                }
            } else {
                if (!(orientation instanceof Number)) return false;
                orient = ((Number)orientation).intValue();
            }
        }
        switch (orient) {
            default: {
                return false;
            }
            case 2: {
                x1 = x2 = this.compWidth / 2;
                y1 = 0;
                y2 = this.compHeight;
                break;
            }
            case 3: {
                x1 = x2 = this.compWidth / 2;
                y1 = this.compHeight;
                y2 = 0;
                break;
            }
            case 0: {
                x1 = 0;
                x2 = this.compWidth;
                y1 = y2 = this.compHeight / 2;
                break;
            }
            case 1: {
                x1 = this.compWidth;
                x2 = 0;
                y1 = y2 = this.compHeight / 2;
                break;
            }
            case 4: {
                y1 = 0;
                x1 = 0;
                x2 = this.compWidth;
                y2 = this.compHeight;
            }
        }
        gpNew = new GradientPaint(x1, y1, c1, x2, y2, c2);
        if (gpNew == null) {
            return false;
        }
        img = this.createImage();
        if (img == null) {
            return false;
        }
        g = this.getGraphics2D(img);
        if (g == null) {
            return false;
        }
        g.setPaint(gpNew);
        g.fillRect(0, 0, this.compWidth, this.compHeight);
        g.dispose();
        this.gp = gpNew;
        this.gpBackImage = img;
        this.backColor = c1;
        this.backColor2 = c2;
        this.gradientOrientation = orient;
        ScatterComponent scatterComponent = this;
        synchronized (scatterComponent) {
            this.bufferUpdateRequired = true;
            return true;
        }
    }

    @Override
    public Color getSolidBackground() {
        if (this.gp != null) {
            return this.gp.getColor1();
        }
        return this.getBackground();
    }

    @Override
    public boolean setSolidBackground(Object c) {
        Color color;
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            color = (Color)c;
        } else if (c instanceof String) {
            color = ColorParse.getColorFromString((String)((String)c));
            if (color == null) {
                return false;
            }
        } else {
            return false;
        }
        this.setBackground(color);
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        this.repaint();
    }

    @Override
    public boolean getUsageMode(int mode) {
        switch (mode) {
            case 2: {
                if (this.chart == null) {
                    return false;
                }
                return this.chart.getUsageMode(mode);
            }
        }
        return false;
    }

    @Override
    public void setUsageMode(int mode, boolean on) {
        switch (mode) {
            case 2: {
                if (this.chart == null) break;
                this.chart.setUsageMode(mode, on);
            }
        }
    }

    protected Component createToolBar() {
        if (!this.noToolBar && this.toolBar == null && (this.toolBar = new SILKToolbar(this.parentFrame)) != null) {
            this.loadNLSStrings();
            ((SILKToolbar)this.toolBar).setTitle(ResourceLoader.getResourceString((Object)this.resbld, (String)"ScatterComponent.Scatter_Toolbar_Title.txt", (String)"Scatter Toolbar"));
            ((SILKToolbar)this.toolBar).addListener(this);
        }
        return this.toolBar;
    }

    @Override
    public Component getToolBar() {
        this.toolBar = this.createToolBar();
        if (this.toolBar == null) {
            return null;
        }
        return this.toolBar;
    }

    @Override
    public boolean setToolBar(Component toolBarIn) {
        this.noToolBar = toolBarIn == null;
        this.toolBar = toolBarIn;
        if (this.toolBar != null && this.toolBar instanceof SILKToolbar) {
            ((SILKToolbar)this.toolBar).addListener(this);
        }
        return true;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (this.menu == null && (this.menu = this.buildMenu()) != null) {
            this.add(this.menu);
        }
        return this.menu;
    }

    @Override
    public int getActionMode() {
        return this.actionMode;
    }

    @Override
    public boolean setActionMode(int mode) {
        switch (mode) {
            case 5: {
                if (this.chart == null) {
                    return true;
                }
                return this.resetViewport();
            }
            case 9: {
                if (!this.isEditable()) {
                    return false;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                this.removeBrush(true);
            }
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        this.actionMode = mode;
        return true;
    }

    @Override
    public int getSelectionBehavior() {
        return this.selectBehavior;
    }

    @Override
    public Object getSelectionBehaviorValue() {
        Serializable out = null;
        switch (this.selectBehavior) {
            default: {
                break;
            }
            case 2: {
                out = this.selectCrop;
                break;
            }
            case 1: {
                out = this.selectColor;
            }
        }
        return out;
    }

    @Override
    public boolean setSelectionBehavior(int behavior, Object value) {
        switch (behavior) {
            case 1: {
                if (value != null && !(value instanceof Color)) break;
                this.selectColor = (Color)value;
                break;
            }
            case 2: {
                if (value != null && !(value instanceof Boolean)) break;
                this.selectCrop = (Boolean)value;
                break;
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        this.selectBehavior = behavior;
        switch (behavior) {
            case 1: {
                this.setHonorModelAttribute(GraphInterface.MODEL_COLOR, true);
                break;
            }
            case 2: {
                this.setHonorModelAttribute(GraphInterface.MODEL_GRAPHED, true);
                break;
            }
            case 0: {
                this.setHonorModelAttribute(GraphInterface.MODEL_SELECTIONS, true);
            }
        }
        return true;
    }

    @Override
    public boolean areChartTipsOn() {
        return this.tipsOn;
    }

    @Override
    public void setChartTipsOn(boolean on) {
        this.tipsOn = on;
    }

    @Override
    public TipInterface getChartTip() {
        return this.getTipBackGround();
    }

    @Override
    public String getStyle() {
        if (this.style == null) {
            return null;
        }
        return this.style.getStyleName();
    }

    @Override
    public boolean setStyle(Object newStyle) {
        Image img = null;
        String name = null;
        String fit = null;
        if (newStyle == null) {
            this.style = null;
        } else if (newStyle instanceof StyleInterface) {
            this.style = (StyleInterface)newStyle;
        } else if (newStyle instanceof String) {
            this.style = ((String)newStyle).equalsIgnoreCase("None") ? null : new Style((String)newStyle);
        } else {
            return false;
        }
        if (this.style != null) {
            double d;
            this.setColorScheme(this.style.getColorScheme());
            if (this.stylesEnabled && this.imageList != null) {
                name = this.style.getStringItemByName("BackgroundImage");
                if (name != null && (img = this.imageList.getImageByName(name, false)) == null) {
                    img = this.imageList.loadImage(name, null, true);
                }
                if (img != null) {
                    fit = this.style.getStringItemByName("BackgroundImageFit");
                    d = this.style.getNumericItemByName("BackgroundImageBlend");
                    if (!Double.isNaN(d)) {
                        this.imageBlend = d;
                    }
                }
                this.setImageBackground(img, fit, 0, 0, this.imageBlend);
            }
            if (this.chart != null) {
                this.chart.setChartBorderOn(this.style.getBooleanItemByName("ChartBorderOn", this.chart.isChartBorderOn()));
                d = this.style.getNumericItemByName("ChartBorderLineWidth");
                if (!Double.isNaN(d)) {
                    this.chart.setChartBorderLineWidth((int)d);
                }
                this.chart.setOpacityValue(this.style.getItemByName("ChartOpacity"));
            }
            if (this.wall != null) {
                this.wall.setVisible(this.style.getBooleanItemByName("ShowWall", this.wall.isVisible()));
                this.wall.setOpacityValue(this.style.getItemByName("WallOpacity"));
            }
            boolean b = this.style.getBooleanItemByName("GridLinesOn", true);
            if (this.xAxis != null) {
                this.xAxis.setGridLines(new Boolean(b));
            }
            if (this.yAxis != null) {
                this.yAxis.setGridLines(new Boolean(b));
            }
        } else {
            this.setImageBackground(null, null, 0, 0, this.imageBlend);
        }
        return true;
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return this.scheme;
    }

    @Override
    public String getColorSchemeName() {
        if (this.scheme == null) {
            return null;
        }
        return this.scheme.getSchemeName();
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        Color c = null;
        Color[] clrs = null;
        ColorInterface colorRamp = null;
        if (this.userScheme == null) {
            this.userScheme = this.getCustomScheme();
        }
        if (newScheme == null) {
            this.scheme = null;
        } else if (newScheme instanceof com.sas.graphics.styles.Style) {
            this.scheme = new ColorScheme((com.sas.graphics.styles.Style)newScheme);
        } else if (newScheme instanceof ColorSchemeInterface) {
            this.scheme = (ColorSchemeInterface)newScheme;
        } else if (newScheme instanceof String) {
            this.scheme = ((String)newScheme).equalsIgnoreCase("User Defined") ? (this.userScheme != null ? this.userScheme : null) : new ColorScheme((String)newScheme);
        } else {
            return false;
        }
        if (this.scheme == null) {
            return true;
        }
        this.chart.setSelectionColor(this.scheme.getColorSchemeItemColor(8));
        com.sas.graphics.styles.Style mainStyle = null;
        if (this.scheme instanceof ColorScheme) {
            mainStyle = ((ColorScheme)this.scheme).getStyle();
        }
        if (mainStyle != null) {
            if (this.grpLegend != null) {
                this.grpLegend.applyStyle(mainStyle);
            }
            if (this.shpLegend != null) {
                this.shpLegend.applyStyle(mainStyle);
            }
            this.chart.setSelectionColor(mainStyle.getStyleElement("Selection").getAsDataStyle().getLineColor());
        }
        if ((c = this.scheme.getColorSchemeItemColor(1)) != null) {
            if (this.gp != null) {
                this.setGradientBackground(c, this.getAverageShading(this.gp.getColor1(), this.gp.getColor2(), c), null);
            } else {
                this.setSolidBackground(c);
            }
        }
        if (this.wall != null) {
            this.wall.setSolidBackground(this.scheme.getColorSchemeItemColor(15));
        }
        Color wc = this.scheme.getColorSchemeItemColor(15);
        if (this.xAxis != null) {
            this.xAxis.setBackgroundColor(c);
            this.xAxis.setWallColor(wc);
        }
        if (this.yAxis != null) {
            this.yAxis.setBackgroundColor(c);
            this.yAxis.setWallColor(wc);
        }
        if (this.xAxisZoomHandler != null) {
            this.xAxisZoomHandler.setStyle(this.scheme.getStyle());
        }
        if (this.yAxisZoomHandler != null) {
            this.yAxisZoomHandler.setStyle(this.scheme.getStyle());
        }
        if (this.titles != null) {
            this.titles.setColor(this.scheme.getColorSchemeItemColorByName("Titles"));
        }
        if (this.footnotes != null) {
            this.footnotes.setColor(this.scheme.getColorSchemeItemColorByName("Titles"));
        }
        if ((c = this.scheme.getColorSchemeItemColorByName("Tool_Tip")) != null) {
            this.tipBackColor = c;
            this.tipBackColor2 = null;
        }
        if ((c = this.scheme.getColorSchemeItemColorByName("Grid Lines")) != null) {
            if (this.xAxis != null) {
                this.xAxis.setGridLines(c);
            }
            if (this.yAxis != null) {
                this.yAxis.setGridLines(c);
            }
        }
        if ((c = this.scheme.getColorSchemeItemColorByName("Axis Lines")) != null) {
            if (this.xAxis != null) {
                this.xAxis.setLine(c);
                this.xAxis.setMajorTicks(c);
                this.xAxis.setLabel(this.scheme.getColorSchemeItemColorByName("Text Labels"));
                this.xAxis.setValues(this.scheme.getColorSchemeItemColorByName("Text Values"));
            }
            if (this.yAxis != null) {
                this.yAxis.setLine(c);
                this.yAxis.setMajorTicks(c);
                this.yAxis.setLabel(this.scheme.getColorSchemeItemColorByName("Text Labels"));
                this.yAxis.setValues(this.scheme.getColorSchemeItemColorByName("Text Values"));
            }
        }
        if (this.chart != null) {
            clrs = this.scheme.getDataColors(false, true);
            colorRamp = this.chart.getColorRamp(true);
            if (colorRamp != null) {
                colorRamp.setColors(clrs);
            }
            if ((colorRamp = this.chart.getColorRamp(false)) != null) {
                colorRamp.setColors(this.scheme.getRampColors(false, true, true));
            }
            if (clrs != null && clrs.length > 0) {
                this.chart.setDefaultMarkerColor(clrs[0]);
                Object o = this.chart.getMarkerColor();
                if (o == null || o instanceof Color) {
                    this.chart.setMarkerColor(clrs[0]);
                }
            }
            this.chart.setRebuildRequired(true);
            c = this.scheme.getColorSchemeItemColorByName("Outlines");
            if (c != null) {
                this.chart.setMarkerOutlineColor(c);
                this.chart.setJoinLineColor(c);
            }
            if ((c = this.scheme.getColorSchemeItemColorByName("Border Lines")) != null) {
                this.chart.setChartBorderColor(c);
                this.tipBorderColor = c;
            }
            if ((c = this.scheme.getColorSchemeItemColorByName("Text Values")) != null) {
                this.tipTextColor = c;
            }
            this.bufferUpdateRequired = true;
        }
        if (this.grpLegend != null) {
            if (this.chart.getGroup() == null && this.chart.getVariable("Color") != null) {
                colorRamp = this.chart.getColorRamp();
                if (colorRamp != null) {
                    this.grpLegend.setValues(colorRamp.getColors(), null, colorRamp.getBreaks(), null, true);
                }
            } else {
                Object[] v = this.chart.getValues(RoleInterface.ROLE_GROUP);
                this.grpLegend.setValues(this.chart.getColors(RoleInterface.ROLE_GROUP, v), null, v, null, false);
            }
            this.grpLegend.setBackgroundColor(this.scheme.getColorSchemeItemColorByName("Legend"));
            this.grpLegend.setBorder(this.scheme.getColorSchemeItemColorByName("Border Lines"));
            this.grpLegend.setTitle(this.scheme.getColorSchemeItemColorByName("Text Labels"));
            this.grpLegend.setLabel(this.scheme.getColorSchemeItemColorByName("Text Values"));
            this.legendUpdateRequired = true;
        }
        if (this.shpLegend != null) {
            this.shpLegend.setBackgroundColor(this.scheme.getColorSchemeItemColorByName("Legend"));
            this.shpLegend.setBorder(this.scheme.getColorSchemeItemColorByName("Border Lines"));
            this.shpLegend.setTitle(this.scheme.getColorSchemeItemColorByName("Text Labels"));
            this.shpLegend.setLabel(this.scheme.getColorSchemeItemColorByName("Text Values"));
        }
        return true;
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.dataFilter;
    }

    @Override
    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    @Override
    public synchronized boolean setDataListening(boolean listen) {
        this.setupListeners(listen);
        this.dataListen = listen;
        return true;
    }

    @Override
    public boolean isDataListening() {
        return this.dataListen;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        if (which == null) {
            return null;
        }
        int irole = this.chart.getRoleIntValue(which);
        switch (irole) {
            case 1: 
            case 24: {
                return this.xAxis;
            }
            case 17: 
            case 25: {
                return this.yAxis;
            }
        }
        return null;
    }

    @Override
    public boolean setExternalAxis(Object which, AxisInterface axis) {
        return false;
    }

    @Override
    public LegendInterface getLegend(Object which) {
        String s = null;
        if (which == null) {
            return this.curLegend;
        }
        if (which instanceof String) {
            s = (String)which;
        }
        if (s == null) {
            return null;
        }
        this.loadNLSStrings();
        if (s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase("Group") || s.equalsIgnoreCase("Color")) {
            return this.grpLegend;
        }
        if (s.equalsIgnoreCase(this.nlsShapeLegend) || s.equalsIgnoreCase("Type") || s.equalsIgnoreCase("Shape")) {
            return this.shpLegend;
        }
        return null;
    }

    @Override
    public String getWhereClause() {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getWhereClause();
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        if (this.dataFilter == null) {
            return false;
        }
        if (!this.dataFilter.applyWhereClause(clause, clearPrevious)) {
            return false;
        }
        this.setActionMode(5);
        return true;
    }

    @Override
    public boolean setTitle(int index, String textString) {
        if (this.titles == null || !this.titles.setTitle(index, textString)) {
            return false;
        }
        this.titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        return true;
    }

    @Override
    public boolean setTitle(int index, TextStyleInterface textObject) {
        if (this.titles == null || !this.titles.setTitle(index, textObject)) {
            return false;
        }
        this.titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        return true;
    }

    @Override
    public TextStyleInterface getTitle(int index) {
        if (this.titles == null) {
            return null;
        }
        return this.titles.getTitle(index);
    }

    @Override
    public boolean setFootnote(int index, String textString) {
        if (this.footnotes == null || !this.footnotes.setFootnote(index, textString)) {
            return false;
        }
        this.footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        return true;
    }

    @Override
    public boolean setFootnote(int index, TextStyleInterface textObject) {
        if (this.footnotes == null || !this.footnotes.setFootnote(index, textObject)) {
            return false;
        }
        this.footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        return true;
    }

    @Override
    public TextStyleInterface getFootnote(int index) {
        if (this.footnotes == null) {
            return null;
        }
        return this.footnotes.getFootnote(index);
    }

    @Override
    public synchronized void enablePopup(boolean on) {
        this.allowPopup = on;
    }

    @Override
    public void dispose() {
        if (this.dataFilter != null) {
            this.dataFilter.removeDataFilterListener((Object)this);
            if (this.chart != null) {
                this.dataFilter.removeDataFilterListener((Object)this.chart);
            }
        }
        this.ignorePaint = true;
        if (this.chart != null) {
            this.chart.removeRoleListener(this);
        }
        this.chart = null;
        this.xAxis = null;
        this.yAxis = null;
        this.curLegend = null;
        this.shpLegend = null;
        this.grpLegend = null;
        this.nullDim = null;
        this.tips = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.gBack != null) {
            this.gBack.dispose();
        }
        this.gBack = null;
        this.tipStrings = null;
        this.scheme = null;
        this.userScheme = null;
        this.style = null;
        this.rb = null;
        this.brushRect = null;
        this.brushLockPoint = null;
        if (this.selPickList != null) {
            this.selPickList.removeAllElements();
        }
        this.selPickList = null;
        if (this.editPickList != null) {
            this.editPickList.removeAllElements();
        }
        this.editPickList = null;
        if (this.marginListeners != null) {
            this.marginListeners.removeAllElements();
        }
        this.marginListeners = null;
        if (this.dataRangeListeners != null) {
            this.dataRangeListeners.removeAllElements();
        }
        this.dataRangeListeners = null;
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(null);
        }
        this.pendingProperties = null;
        if (this.viewportListeners != null) {
            this.viewportListeners.removeAllElements();
        }
        this.viewportListeners = null;
        this.titles = null;
        this.footnotes = null;
        this.alphaRamp = null;
        this.temp = null;
        this.backImage = null;
        this.gpBackImage = null;
        this.scaledBackImage = null;
        this.wall = null;
        this.dataFilter = null;
        if (this.menu != null) {
            this.remove(this.menu);
        }
        this.menu = null;
        this.propMI = null;
        this.dataMI = null;
        this.tbMI = null;
        this.bandTypeMI = null;
        this.plotTypeMI = null;
        this.lineTypeMI = null;
        this.parentFrame = null;
        if (this.newPropDlg != null) {
            this.newPropDlg.setVisible(false);
            this.newPropDlg.dispose();
        }
        this.newPropDlg = null;
        if (this.newDataDlg != null) {
            this.newDataDlg.setVisible(false);
            this.newDataDlg.dispose();
        }
        this.newDataDlg = null;
        this.imageList = null;
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        this.toolBar = null;
        this.chartBBox = null;
        this.moveDistance = null;
        this.editAnchor = null;
        SILKGlobal.unregister(this);
    }

    @Override
    public Dialog getDialog(Object id, Object listener) {
        if (id == null) {
            return null;
        }
        if (id.toString().equalsIgnoreCase("Properties")) {
            return this.ensurePropertyDialog(listener);
        }
        if (id.toString().equalsIgnoreCase("Data")) {
            return this.ensureDataDialog(listener);
        }
        return null;
    }

    @Override
    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    @Override
    public void addDrilldownListener(DrilldownListenerInterface d) {
        if (this.drilldownListeners == null) {
            this.drilldownListeners = new Vector();
        }
        if (d == null || this.drilldownListeners == null) {
            return;
        }
        if (this.drilldownListeners.contains(d)) {
            return;
        }
        this.drilldownListeners.addElement(d);
    }

    @Override
    public void removeDrilldownListener(DrilldownListenerInterface d) {
        int idx = -1;
        if (d == null || this.drilldownListeners == null) {
            return;
        }
        idx = this.drilldownListeners.indexOf(d);
        if (idx >= 0) {
            this.drilldownListeners.removeElementAt(idx);
        }
    }

    @Override
    public void addViewportListener(Object listener) {
        if (listener instanceof ViewportListenerInterface && !this.viewportListeners.contains(listener)) {
            this.viewportListeners.addElement(listener);
        }
    }

    @Override
    public void removeViewportListener(Object listener) {
        this.viewportListeners.removeElement(listener);
    }

    @Override
    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public ScatterInterface getChart(Object id) {
        return this.chart;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object idIn) {
        this.id = idIn;
    }

    @Override
    public boolean setEditable(boolean editable) {
        if (editable) {
            this.setSelectable(true);
        }
        this.editable = editable;
        return true;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    @Override
    public boolean isActionEnabled(String action) {
        return true;
    }

    @Override
    public AnnotateInterface getAnnotate() {
        return null;
    }

    @Override
    public Object getWall() {
        return this.wall;
    }

    @Override
    public boolean getStylesEnabled() {
        return this.stylesEnabled && this.imageList != null && this.supportsImageBackground();
    }

    @Override
    public void setStylesEnabled(boolean on) {
        this.stylesEnabled = on;
    }

    @Override
    public Object getImageList() {
        return this.imageList;
    }

    @Override
    public boolean setImageList(Object list) {
        if (list == null) {
            this.imageList = null;
            return true;
        }
        if (!(list instanceof ImageListInterface)) {
            return false;
        }
        this.imageList = (ImageListInterface)list;
        this.stylesEnabled = this.imageList != null;
        return true;
    }

    @Override
    public boolean isLineStylePlot() {
        if (this.chart == null) {
            return false;
        }
        int style = this.chart.getJoinLineStyle(null);
        if (style < 0) {
            return false;
        }
        return !this.chart.areMarkersOn() && style != 0;
    }

    @Override
    public void setLineStylePlot(boolean lineStyleOn) {
        if (this.chart == null) {
            return;
        }
        String style = lineStyleOn ? "Simple" : "None";
        this.chart.setMarkersOn(!lineStyleOn);
        this.chart.setJoinLineStyle(style);
        if (lineStyleOn) {
            this.chart.setJoinLineThickness(2);
        }
        if (lineStyleOn) {
            this.chart.setSortOrder(null, RoleInterface.ROLE_SORT_ASCENDING);
        } else {
            this.chart.setSortOrder(null, RoleInterface.ROLE_SORT_DATA);
        }
    }

    @Override
    public boolean areAxesEqualized() {
        return this.equalizeAxes;
    }

    @Override
    public boolean isBubbleStylePlot() {
        if (this.chart == null) {
            return false;
        }
        return this.chart.isBubbleStylePlot();
    }

    @Override
    public void setBubbleStylePlot(boolean bubble, boolean equalAxes) {
        if (this.chart == null) {
            return;
        }
        this.chart.setBubbleStylePlot(bubble);
        this.equalizeAxes = equalAxes;
        this.viewUpdate = true;
    }

    @Override
    public boolean isBrushRestricted() {
        return this.restrictBrush;
    }

    @Override
    public void setBrushRestricted(boolean restrict) {
        this.restrictBrush = restrict;
    }

    @Override
    public Object getLegendPosition(Object which) {
        int pos = -1;
        String s = null;
        LegendObjectJ2D legend = null;
        this.loadNLSStrings();
        if (which == null) {
            legend = this.curLegend;
        } else if (which instanceof String) {
            s = (String)which;
        }
        if (s != null) {
            if (s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase("Group") || s.equalsIgnoreCase("Color")) {
                legend = this.grpLegend;
            } else if (s.equalsIgnoreCase(this.nlsShapeLegend) || s.equalsIgnoreCase("Type") || s.equalsIgnoreCase("Shape")) {
                legend = this.shpLegend;
            }
        }
        if (legend == null) {
            return null;
        }
        pos = legend.getPosition();
        return legend.getLegendNumber(pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLegendPosition(Object which, Object positionIn) {
        int pos;
        String s = null;
        LegendObjectJ2D legend = null;
        if (positionIn == null) {
            return false;
        }
        this.loadNLSStrings();
        if (which == null) {
            legend = this.curLegend;
        } else if (which instanceof String) {
            s = (String)which;
        }
        if (s != null) {
            if (s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase(this.nlsColorLegend) || s.equalsIgnoreCase("Group") || s.equalsIgnoreCase("Color")) {
                legend = this.grpLegend;
            } else if (s.equalsIgnoreCase(this.nlsShapeLegend) || s.equalsIgnoreCase("Type") || s.equalsIgnoreCase("Shape")) {
                legend = this.shpLegend;
            }
        }
        if (legend == null) {
            return false;
        }
        if (positionIn instanceof String) {
            s = (String)positionIn;
            if (s.equalsIgnoreCase("North")) {
                pos = 1;
            } else if (s.equalsIgnoreCase("South")) {
                pos = 2;
            } else if (s.equalsIgnoreCase("East")) {
                pos = 3;
            } else {
                if (!s.equalsIgnoreCase("West")) return false;
                pos = 4;
            }
        } else {
            if (!(positionIn instanceof Number)) return false;
            pos = ((Number)positionIn).intValue();
        }
        legend.setPosition(pos);
        this.throwMarginChangeEvent();
        return true;
    }

    @Override
    public Rectangle getLegendBounds() {
        Rectangle out = null;
        if (this.curLegend == null) {
            return null;
        }
        Point p = this.curLegend.getStartPoint();
        Dimension d = this.curLegend.getPreferredSize();
        if (p == null || d == null) {
            return null;
        }
        out = new Rectangle(p.x, p.y, d.width, d.height);
        return out;
    }

    @Override
    public boolean setLegendBounds(Rectangle rect) {
        if (rect == null) {
            return false;
        }
        this.maxLegendWidth = rect.width;
        this.maxLegendHeight = rect.height;
        this.bufferUpdateRequired = true;
        return false;
    }

    @Override
    public boolean isBackBufferDrawEnabled() {
        return !this.noBackBufferDraw;
    }

    @Override
    public void setBackBufferDrawEnabled(boolean drawback) {
        this.noBackBufferDraw = !drawback;
    }

    @Override
    public boolean isModelAttributeHonored(Object attribute) {
        boolean b = false;
        if (attribute == null || !(attribute instanceof Number)) {
            throw new IllegalArgumentException();
        }
        int ival = ((Number)attribute).intValue();
        switch (ival) {
            case 0: {
                b = true;
                break;
            }
            case 1: {
                if (this.chart == null) break;
                b = this.chart.isGraphedHonored();
                break;
            }
            case 2: {
                if (this.chart == null) break;
                b = this.chart.isObsColorHonored();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return b;
    }

    @Override
    public boolean setHonorModelAttribute(Object attribute, boolean honorit) {
        if (attribute == null || !(attribute instanceof Number)) {
            return false;
        }
        int ival = ((Number)attribute).intValue();
        switch (ival) {
            case 1: {
                if (this.chart == null) {
                    return false;
                }
                this.chart.setGraphedHonored(honorit);
                break;
            }
            case 2: {
                if (this.chart == null) {
                    return false;
                }
                this.chart.setObsColorHonored(honorit);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean isPropertySupported(int id) {
        return this.handleProperty(id, null, false, true);
    }

    public boolean isPropertyPending(int id) {
        if (this.pendingProperties == null) {
            return false;
        }
        return this.pendingProperties.isPending(id);
    }

    public Object getPropertyValue(int idx) {
        return this.fetchProperty(idx);
    }

    public boolean setPropertyValue(int idx, Object value) {
        return this.handleProperty(idx, value, false, false);
    }

    public int getNumberPendingProperties() {
        if (this.pendingProperties == null) {
            return 0;
        }
        return this.pendingProperties.getNumberPending(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.chart != null) {
            this.chart.applyPropertyChanges(source);
        }
        if (this.xAxis != null) {
            this.xAxis.applyPropertyChanges(source);
        }
        if (this.yAxis != null) {
            this.yAxis.applyPropertyChanges(source);
        }
        if (this.curLegend != null) {
            this.curLegend.applyPropertyChanges(source);
        }
        if (this.pendingProperties == null) {
            return false;
        }
        Vector v = this.pendingProperties.getChangesBySource(source);
        if (v == null || v.size() <= 0) {
            return false;
        }
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)v.elementAt(i);
            if (pe == null) continue;
            this.handleProperty(pe.id, pe.value, true, false);
        }
        this.pendingProperties.removeChangesBySource(source);
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.chart != null) {
            this.chart.cancelPropertyChanges(source);
        }
        if (this.xAxis != null) {
            this.xAxis.cancelPropertyChanges(source);
        }
        if (this.yAxis != null) {
            this.yAxis.cancelPropertyChanges(source);
        }
        if (this.curLegend != null) {
            this.curLegend.cancelPropertyChanges(source);
        }
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(source);
        }
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        if (this.pendingProperties == null) {
            return null;
        }
        return this.pendingProperties.getPending(source);
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        Object role = null;
        if (evt == null) {
            return;
        }
        int evtType = evt.type;
        switch (evtType) {
            case 8: 
            case 9: {
                if (evt.isAdjusting) break;
                this.repaint();
                break;
            }
            case 2: {
                if (this.chart == null || !this.chart.getOurPicking()) {
                    this.removeBrush(false);
                }
                if (evt.isAdjusting) break;
                this.repaint();
                break;
            }
            case 1: {
                this.chart.setDataChanged(true);
                this.repaint();
                break;
            }
            case 3: {
                if (!this.isOurVariable(evt.varStartIndex, evt.varEndIndex)) break;
                this.chart.setDataChanged(true);
                if (this.brushRect != null) {
                    this.removeBrush(false);
                }
                if (this.selPickList != null) {
                    this.selPickList.removeAllElements();
                }
                this.ignorePaint = true;
                if (this.dataFilter != null) {
                    this.dataFilter.unselectAll();
                }
                this.ignorePaint = false;
                this.repaint();
                break;
            }
            case 5: {
                if (!this.isOurVariable(evt.varStartIndex, evt.varEndIndex) || (role = this.getRole(this.dataFilter.getVariableId(evt.varStartIndex))) == null) break;
                this.setRole(role, null);
                this.repaint();
                break;
            }
            case 7: {
                this.repaint();
            }
        }
    }

    public Object[] getDataIds() {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getDataIds();
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        DataFilterReadInterface filter = null;
        if (source == null) {
            return false;
        }
        filter = FilterFactory.getDataSourceFilter((Object)source);
        if (filter == null) {
            return false;
        }
        this.setupListeners(false);
        this.dataFilter = filter;
        this.setupListeners(this.dataListen);
        if (this.chart != null) {
            this.chart.setDataSource(filter);
        }
        if (this.xAxis != null) {
            this.xAxis.setDataSource(source);
        }
        if (this.yAxis != null) {
            this.yAxis.setDataSource(source);
        }
        this.fireLayerListenerChanged(3);
        return true;
    }

    @Override
    public Object getAllVariables(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getAllVariables(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        Number num = null;
        if (this.chart == null) {
            return null;
        }
        if (variableId != null && variableId instanceof Number) {
            num = (Number)variableId;
        }
        if (num != null) {
            int i = num.intValue();
            if (i == -3) {
                return this.chart.getRole(this.chart.getCategory());
            }
            if (i == -4) {
                return this.chart.getRole(this.chart.getResponse(i));
            }
        }
        return this.chart.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setRole(variableId, role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        Object prev = this.getVariable(role);
        if (role == null || this.chart == null) {
            return false;
        }
        if (this.chart != null && this.chart.supportsMultipleAssignments(role) && prev != null) {
            return this.chart.addRole(variableId, role);
        }
        return this.setRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.removeRole(variableId, role);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getRoleValue(role, which);
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setDiscrete(role, discrete);
    }

    @Override
    public Object getSortOrder(Object variableId) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSortOrder(variableId);
    }

    @Override
    public boolean setSortOrder(Object variableId, Object sort) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setSortOrder(variableId, sort);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSupportedRoles(id, discrete);
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (this.chart == null) {
            return 0;
        }
        return this.chart.getMaxAllowed(role);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.supportsMultipleAssignments(role);
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
        if (this.chart == null) {
            return;
        }
        this.chart.addRoleListener(listener);
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
        if (this.chart == null) {
            return;
        }
        this.chart.removeRoleListener(listener);
    }

    @Override
    public Object getLimit(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getLimit(role);
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setLimit(role, value);
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSupportedSortableRoles();
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSupportedSortDirections(role);
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public double[] project(double x, double y, double z, double[] out) {
        double[] ret = out;
        if ((ret == null || this.noMinMax) && (ret = new double[3]) == null) {
            return null;
        }
        ret[0] = this.xReverse ? (double)this.viewportWidth * (x - this.xMax) / (this.xMin - this.xMax) + (double)this.viewportX : (double)this.viewportWidth * (x - this.xMin) / (this.xMax - this.xMin) + (double)this.viewportX;
        ret[1] = this.yReverse ? (double)this.viewportHeight - (double)this.viewportHeight * (y - this.yMax) / (this.yMin - this.yMax) + (double)this.viewportY : (double)this.viewportHeight - (double)this.viewportHeight * (y - this.yMin) / (this.yMax - this.yMin) + (double)this.viewportY;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        double[] ret = out;
        if ((ret == null || this.noMinMax) && (ret = new double[3]) == null) {
            return null;
        }
        ret[0] = this.xReverse ? (this.xMin - this.xMax) * (pixelX - (double)this.viewportX) / (double)this.viewportWidth + this.xMax : (this.xMax - this.xMin) * (pixelX - (double)this.viewportX) / (double)this.viewportWidth + this.xMin;
        ret[1] = this.yReverse ? (this.yMax - this.yMin) * (pixelY - (double)this.viewportY) / (double)this.viewportHeight + this.yMin : (this.yMin - this.yMax) * (pixelY - (double)this.viewportY) / (double)this.viewportHeight + this.yMax;
        ret[2] = 0.0;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public void setReverse(int axis, boolean flag) {
        switch (axis) {
            case 0: {
                this.xReverse = flag;
                break;
            }
            case 1: {
                this.yReverse = flag;
            }
        }
    }

    @Override
    public boolean isReverse(int axis) {
        switch (axis) {
            case 0: {
                return this.xReverse;
            }
            case 1: {
                return this.yReverse;
            }
        }
        return false;
    }

    public int getNumRanges(byte dim) {
        return 1;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
        if (this.xAxis != null) {
            this.xAxis.setVisible(axesVisible);
        }
        if (this.yAxis != null) {
            this.yAxis.setVisible(axesVisible);
        }
        this.repaint();
    }

    public boolean getAxesVisible() {
        boolean xOn = false;
        boolean yOn = false;
        if (this.xAxis != null) {
            xOn = this.xAxis.isVisible();
        }
        if (this.yAxis != null) {
            yOn = this.yAxis.isVisible();
        }
        return xOn || yOn;
    }

    public void setRange(byte dim, int index, DataRange range) {
        boolean sameRange = false;
        Integer role = null;
        if (range == null) {
            switch (dim) {
                case 1: {
                    this.xDataRange = null;
                    this.oneXRange = false;
                    role = RoleInterface.ROLE_X;
                    break;
                }
                case 2: {
                    this.yDataRange = null;
                    this.oneYRange = false;
                    role = RoleInterface.ROLE_Y;
                }
            }
            if (this.chart != null) {
                this.chart.setValues(role, null);
            }
            return;
        }
        if (!(range instanceof ContinuousRange) && !(range instanceof DiscreteRange)) {
            return;
        }
        if (range instanceof ContinuousRange && ((ContinuousRange)range).getMin() == ((ContinuousRange)range).getMax()) {
            sameRange = true;
        }
        switch (dim) {
            default: {
                return;
            }
            case 1: {
                this.xDataRange = range;
                this.oneXRange = sameRange;
                role = RoleInterface.ROLE_X;
                break;
            }
            case 2: {
                this.yDataRange = range;
                this.oneYRange = sameRange;
                role = RoleInterface.ROLE_Y;
            }
        }
        if (this.chart != null && range instanceof DiscreteRange) {
            this.chart.setValues(role, ((DiscreteRange)range).getEnumeration());
        }
    }

    public Insets getOuterMargin() {
        Graphics2D g = null;
        if (this.gBack != null) {
            g = this.gBack;
        }
        if (this.doChartBuild(null)) {
            this.build(null);
        }
        return this.updateViewParameters(g, 1);
    }

    public Insets getInnerMargin() {
        Graphics2D g = null;
        if (this.gBack != null) {
            g = this.gBack;
        }
        if (this.doChartBuild(null)) {
            this.build(null);
        }
        return this.updateViewParameters(g, 2);
    }

    public void setOuterMargin(Insets margin) {
        this.outerMargin = margin;
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        this.repaint();
    }

    public void setInnerMargin(Insets margin) {
        this.innerMargin = margin;
        this.viewUpdate = true;
        this.bufferUpdateRequired = true;
        this.repaint();
    }

    public Insets getPreferredOuterMargin() {
        return this.getOuterMargin();
    }

    public Insets getPreferredInnerMargin() {
        return this.getInnerMargin();
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void addMarginListener(MarginListener listener) {
        if (this.marginListeners == null) {
            this.marginListeners = new Vector();
        }
        if (this.marginListeners != null && !this.marginListeners.contains(listener)) {
            this.marginListeners.addElement(listener);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (this.marginListeners != null && this.marginListeners.contains(listener)) {
            this.marginListeners.removeElement(listener);
        }
    }

    @Override
    public void textUpdated(DvrTextEvent e) {
        if (this.titles != null) {
            this.titles.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        }
        if (this.footnotes != null) {
            this.footnotes.setComponentBounds(this.xMargin, this.yMargin, this.compWidth - 2 * this.xMargin, this.compHeight - 2 * this.yMargin);
        }
        this.viewUpdate = true;
        this.repaint();
    }

    protected DataRange getChartRange(byte dim) {
        DiscreteRange range = null;
        double[] d = null;
        Object[] values = null;
        if (this.chart == null) {
            return null;
        }
        if (this.chart.isRebuildRequired()) {
            this.build(null);
        }
        switch (dim) {
            default: {
                break;
            }
            case 1: {
                values = this.chart.getValues(RoleInterface.ROLE_X);
                break;
            }
            case 2: {
                values = this.chart.getValues(RoleInterface.ROLE_Y);
            }
        }
        if (values == null && (d = this.chart.getBoundingBox()) == null) {
            return null;
        }
        switch (dim) {
            default: {
                break;
            }
            case 1: {
                if (values != null) {
                    range = new DiscreteRange(values);
                    break;
                }
                if (Double.isNaN(d[0]) || Double.isNaN(d[3])) break;
                range = new ContinuousRange(d[0], d[3]);
                break;
            }
            case 2: {
                if (values != null) {
                    range = new DiscreteRange(values);
                    break;
                }
                if (Double.isNaN(d[1]) || Double.isNaN(d[4])) break;
                range = new ContinuousRange(d[1], d[4]);
            }
        }
        return range;
    }

    public DataRange getDataRange(byte dim) {
        return this.getChartRange(dim);
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        if (this.dataRangeListeners == null) {
            this.dataRangeListeners = new Vector();
        }
        if (this.dataRangeListeners == null || this.dataRangeListeners.contains(listener)) {
            return;
        }
        this.dataRangeListeners.addElement(listener);
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        if (this.dataRangeListeners == null || !this.dataRangeListeners.contains(listener)) {
            return;
        }
        this.dataRangeListeners.removeElement(listener);
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
    }

    @Override
    public void outerMarginChanged(RedrawEvent e) {
    }

    @Override
    public void redraw(RedrawEvent e) {
        Object source = e.getSource();
        if (source == this.xAxis) {
            this.redrawXAxis = true;
        } else if (source == this.yAxis) {
            this.redrawYAxis = true;
        }
    }

    @Override
    public boolean build(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (!this.chart.build(null)) {
            return false;
        }
        this.updateLegend(this.grpLegend);
        this.updateLegend(this.shpLegend);
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        if (!this.build(buildData)) {
            return false;
        }
        this.repaint();
        return true;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.chart != null && this.chart.isRebuildRequired();
    }

    @Override
    public void roleChanged(RoleEvent e) {
        byte dim = -1;
        Object v = null;
        ColorInterface colorRamp = null;
        TextStyleInterface ts = null;
        SASFormat fmt = null;
        Color[] clrs = null;
        if (e == null) {
            return;
        }
        switch (e.type) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.viewUpdate = true;
                return;
            }
            default: {
                return;
            }
        }
        this.removeBrush(false);
        switch (e.role) {
            case 1: 
            case 24: {
                if (this.xAxis != null) {
                    if (e.type == 1) {
                        this.xAxis.setRole(e.newValue, RoleInterface.ROLE_X);
                        this.xAxis.setLabel(this.dataFilter.getVariableDescription(e.newValue));
                        this.xAxis.setAxis(new Double(Double.NaN), new Double(Double.NaN), -1, -1, null, new Boolean(true), null);
                    } else if (e.type == 3) {
                        this.xAxis.removeRole(e.oldValue, RoleInterface.ROLE_X);
                    }
                }
                dim = 1;
                this.clearViewport = true;
                break;
            }
            case 17: 
            case 25: {
                if (this.yAxis != null) {
                    if (e.type == 1) {
                        this.yAxis.setRole(e.newValue, RoleInterface.ROLE_Y);
                        this.yAxis.setLabel(this.dataFilter.getVariableDescription(e.newValue));
                        this.yAxis.setAxis(new Double(Double.NaN), new Double(Double.NaN), -1, -1, null, new Boolean(true), null);
                        if (this.chart.getNumberResponse() <= 1 && this.grpLegend != null && this.chart.getVariable(RoleInterface.ROLE_GROUP) == null) {
                            this.grpLegend.setVisible(false);
                            ts = this.grpLegend.getLabel();
                            if (ts != null) {
                                ts.setFormat(null);
                            }
                        }
                    } else if (e.type == 2) {
                        if (this.chart.getNumberResponse() > 1 && this.chart.getVariable(RoleInterface.ROLE_GROUP) == null) {
                            this.yAxis.setLabel(null);
                            this.yAxis.setAxis(new Double(Double.NaN), new Double(Double.NaN), -1, -1, null, new Boolean(true), null);
                            if (this.grpLegend != null) {
                                this.grpLegend.setVisible(true);
                                this.grpLegend.setTitle(null);
                                ts = this.grpLegend.getLabel();
                                if (ts != null) {
                                    ts.setFormat(null);
                                }
                            }
                        }
                    } else if (e.type == 3) {
                        this.yAxis.removeRole(e.oldValue, RoleInterface.ROLE_Y);
                        this.yAxis.setRole(this.chart.getVariable(RoleInterface.ROLE_Y), RoleInterface.ROLE_Y);
                    }
                }
                if (e.type == 1 && this.chart.getNumberResponse() > 1) {
                    this.curLegend = this.grpLegend;
                } else if (e.type == 3 && this.curLegend == this.grpLegend) {
                    this.curLegend = null;
                    this.curLegend = this.getNextLegend();
                }
                dim = 2;
                this.legendUpdateRequired = true;
                this.clearViewport = true;
                break;
            }
            case 6: {
                if (e.newValue != null) {
                    if (this.scheme != null) {
                        clrs = this.scheme.getDataColors(false, true);
                    }
                    if ((colorRamp = this.chart.getColorRamp(true)) == null) {
                        colorRamp = new ColorRamp();
                        this.chart.setColorRamp(colorRamp, true);
                    }
                    colorRamp.setColors(clrs);
                }
                if ((e.type == 1 || e.type == 2) && e.newValue != null) {
                    this.curLegend = this.grpLegend;
                    if (this.grpLegend != null) {
                        this.grpLegend.setVisible(true);
                        this.grpLegend.setTitle((String)this.dataFilter.getVariableDescription(e.newValue));
                        fmt = (SASFormat)this.dataFilter.getFormat(e.newValue, SASFormat.class);
                        if (fmt != null) {
                            this.grpLegend.setLabel(fmt);
                        } else {
                            ts = this.grpLegend.getLabel();
                            if (ts != null) {
                                ts.setFormat(null);
                            }
                        }
                    }
                } else if (e.type == 3) {
                    if (this.curLegend == this.grpLegend) {
                        this.curLegend = null;
                        this.curLegend = this.getNextLegend();
                    }
                    if (this.grpLegend != null) {
                        this.grpLegend.setVisible(false);
                    }
                }
                dim = 4;
                this.legendUpdateRequired = true;
                break;
            }
            case 2: {
                if (e.newValue != null) {
                    colorRamp = this.chart.getColorRamp(false);
                    if (colorRamp == null) {
                        if (this.scheme != null) {
                            clrs = this.scheme.getRampColors(false, true, true);
                        }
                        colorRamp = new ColorRamp((Object)clrs, this.getMinOrMaxValue(e.newValue, true), this.getMinOrMaxValue(e.newValue, false), 0L);
                        this.chart.setColorRamp(colorRamp, false);
                    }
                    colorRamp.setRange(this.getMinOrMaxValue(e.newValue, true), this.getMinOrMaxValue(e.newValue, false));
                }
                if ((e.type == 1 || e.type == 2) && e.newValue != null) {
                    this.curLegend = this.grpLegend;
                    if (this.grpLegend != null) {
                        this.grpLegend.setVisible(true);
                        this.grpLegend.setTitle((String)this.dataFilter.getVariableDescription(e.newValue));
                        fmt = (SASFormat)this.dataFilter.getFormat(e.newValue, SASFormat.class);
                        if (fmt != null) {
                            this.grpLegend.setLabel(fmt);
                        } else {
                            ts = this.grpLegend.getLabel();
                            if (ts != null) {
                                ts.setFormat(null);
                            }
                        }
                    }
                } else if (e.type == 3) {
                    if (this.curLegend == this.grpLegend) {
                        this.curLegend = null;
                        this.curLegend = this.getNextLegend();
                    }
                    if (this.grpLegend != null) {
                        this.grpLegend.setVisible(false);
                    }
                }
                dim = 4;
                break;
            }
            case 11: 
            case 52: {
                if (e.newValue != null && (this.alphaRamp = this.chart.getAlphaRamp()) == null) {
                    if (this.alphaRamp == null) {
                        this.alphaRamp = new AlphaRamp(null, this.getMinOrMaxValue(e.newValue, true), this.getMinOrMaxValue(e.newValue, false), 0L);
                    } else {
                        this.alphaRamp.setRange(this.getMinOrMaxValue(e.newValue, true), this.getMinOrMaxValue(e.newValue, false));
                    }
                    this.chart.setAlphaRamp(this.alphaRamp);
                }
                dim = 16;
                break;
            }
            case 19: {
                if (e.newValue != null) {
                    this.chart.setMinimumMarkerDataValue(Double.NaN);
                    this.chart.setMaximumMarkerDataValue(Double.NaN);
                }
                dim = 5;
                break;
            }
            case 18: {
                if ((e.type == 1 || e.type == 2) && e.newValue != null) {
                    this.curLegend = this.shpLegend;
                    if (this.shpLegend != null) {
                        this.shpLegend.setVisible(true);
                        this.shpLegend.setTitle(this.dataFilter.getVariableDescription(e.newValue));
                        fmt = (SASFormat)this.dataFilter.getFormat(e.newValue, SASFormat.class);
                        if (fmt != null) {
                            this.shpLegend.setLabel(fmt);
                        } else {
                            ts = this.shpLegend.getLabel();
                            if (ts != null) {
                                ts.setFormat(null);
                            }
                        }
                    }
                } else if (e.type == 3) {
                    if (this.curLegend == this.shpLegend) {
                        this.curLegend = null;
                        this.curLegend = this.getNextLegend();
                    }
                    if (this.shpLegend != null) {
                        this.shpLegend.setVisible(false);
                    }
                }
                dim = 6;
            }
        }
        this.viewUpdate = true;
        if (e.type == 3 && this.yAxis != null) {
            v = this.chart.getVariable(RoleInterface.ROLE_Y);
            if (this.chart.getNumberResponse() >= 2) {
                this.yAxis.setLabel(null);
            } else {
                this.yAxis.setLabel(this.dataFilter.getVariableDescription(v));
            }
        }
        if (e.rangeChangeEvent) {
            this.throwRangeChangeEvent(this, (byte)4, null, dim);
        }
        switch (e.role) {
            case 24: 
            case 25: {
                this.throwMarginChangeEvent();
            }
        }
        this.fireLayerListenerChanged(3);
        this.repaint();
    }

    @Override
    public synchronized void addURLConsumer(Object context, URLConsumerInterface consumer) {
        if (this.chart == null) {
            return;
        }
        this.chart.addURLConsumer(context, consumer);
    }

    @Override
    public synchronized void removeURLConsumer(URLConsumerInterface consumer) {
        if (this.chart == null) {
            return;
        }
        this.chart.removeURLConsumer(consumer);
    }

    protected void fireViewportEvent(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (this.viewportListeners.size() <= 0) {
            return;
        }
        ViewportEvent ve = new ViewportEvent(this, type, xmin, xmax, ymin, ymax, zmin, zmax);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.elementAt(i)).viewportChanged(ve);
        }
    }

    @Override
    public double[] getViewport(int type, int level, int dimension) {
        double[] d = new double[2];
        if (this.chart == null || d == null) {
            return null;
        }
        switch (dimension) {
            default: {
                d[0] = 0.0;
                d[1] = 1.0;
                break;
            }
            case 1: {
                d[0] = this.chart.getMinX(false);
                d[1] = this.chart.getMaxX(false);
                break;
            }
            case 2: {
                d[0] = this.chart.getMinY(false);
                d[1] = this.chart.getMaxY(false);
            }
        }
        return d;
    }

    public double getZoomFactor(int dimension) {
        double z = 1.0;
        switch (dimension) {
            case 1: {
                z = this.getXZoom();
                break;
            }
            case 2: {
                z = this.getYZoom();
            }
        }
        return z;
    }

    @Override
    public boolean resetViewport() {
        this.chart.clearDataViewport();
        this.chart.setDataChanged(true);
        this.removeBrush(false);
        this.creatingBrush = false;
        this.resetView = true;
        this.viewUpdate = true;
        if (this.grpVarValue != null || this.clrVarValue != null) {
            this.legendUpdateRequired = true;
        }
        this.fireViewportEvent(0, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        this.repaint();
        return true;
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        if (this.chart == null) {
            return false;
        }
        double xmin = this.chart.getMinX(false);
        double xmax = this.chart.getMaxX(false);
        double ymin = this.chart.getMinY(false);
        double ymax = this.chart.getMaxY(false);
        switch (dimension) {
            default: {
                break;
            }
            case 1: {
                xmin = min;
                xmax = max;
                break;
            }
            case 2: {
                ymin = min;
                ymax = max;
            }
        }
        return this.setViewport(type, xmin, xmax, ymin, ymax, Double.NaN, Double.NaN);
    }

    @Override
    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        if (this.chart == null) {
            return false;
        }
        if (xmin == xmax && ymin == ymax) {
            return false;
        }
        if (xmin == xmax) {
            xmin = this.xMin;
            xmax = this.xMax;
        }
        if (ymin == ymax) {
            ymin = this.yMin;
            ymax = this.yMax;
        }
        this.chart.setDataViewport(xmin, ymin, xmax, ymax);
        this.chart.setDataChanged(true);
        this.fireViewportEvent(type, xmin, xmax, ymin, ymax, zmin, zmax);
        this.repaint();
        return true;
    }

    public boolean setZoomFactor(int dimension, double factor) {
        double xz = Double.NaN;
        double yz = Double.NaN;
        switch (dimension) {
            default: {
                return false;
            }
            case 1: 
            case 4: {
                xz = factor;
                if (dimension == 1) break;
            }
            case 2: {
                yz = factor;
            }
        }
        this.doZoom(xz, yz);
        this.chart.setDataChanged(true);
        this.repaint();
        return true;
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (evt != null) {
            double xmin = Double.isNaN(evt.xMin) ? this.chart.getMinX(false) : evt.xMin;
            double xmax = Double.isNaN(evt.xMax) ? this.chart.getMaxX(false) : evt.xMax;
            double ymin = Double.isNaN(evt.yMin) ? this.chart.getMinY(false) : evt.yMin;
            double ymax = Double.isNaN(evt.yMax) ? this.chart.getMaxY(false) : evt.yMax;
            this.setViewport(1, xmin, xmax, ymin, ymax, Double.NaN, Double.NaN);
        }
    }

    @Override
    public void drawLayer(Graphics g) {
        this.drawScatterContents(g, 30);
    }

    @Override
    public void drawLayerSelections(Graphics g) {
        this.drawScatterContents(g, 35);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (!select) {
            this.doUnSelection(this.selPickList, selectRegion);
            return true;
        }
        this.doSelection(this.selPickList, selectRegion);
        this.doEdit(event);
        return true;
    }

    @Override
    public boolean setSelectable(boolean selectable) {
        this.selectable = selectable;
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        boolean displayTip = true;
        int n = 0;
        String s = null;
        if (this.chart == null || !this.tipsOn) {
            return null;
        }
        if (this.warningIcon.isMouseOverIcon(screenX, screenY)) {
            return this.warningIcon.getTooltipText();
        }
        this.tipList.removeAllElements();
        if (this.chart.pick(screenX, screenY, false, 0, true, false, this.tipList) <= 0 || this.tipList.size() <= 0) {
            this.overMarker = false;
            displayTip = false;
            if (this.xAxis != null) {
                s = this.xAxis.getToolTipText(screenX, screenY);
                boolean bl = displayTip = s != null;
            }
            if (!displayTip && this.yAxis != null) {
                s = this.yAxis.getToolTipText(screenX, screenY);
                displayTip = s != null;
            }
        } else {
            this.overMarker = true;
        }
        if (!displayTip) {
            return null;
        }
        if (s != null) {
            n = 1;
            this.tipStrings[0] = s;
        } else {
            n = this.getTipContents(this.tipList, this.tipStrings);
        }
        s = "";
        for (int i = 0; i < n; ++i) {
            s = s + this.tipStrings[i] + "\n";
        }
        return s;
    }

    @Override
    public TabPanelInterface getChartTab() {
        return this.getChartTab(this);
    }

    @Override
    public TabPanelInterface getChartTab(Object listener) {
        TabbedPropertiesDialog dlg = this.ensurePropertyDialog(listener);
        return dlg.getTab(ScatterPanel.class);
    }

    @Override
    public int getDataRangeType(byte dimension) {
        return 1;
    }

    @Override
    public int getXAxisMapping() {
        return this.xAxisMapping;
    }

    @Override
    public int getYAxisMapping() {
        return this.yAxisMapping;
    }

    @Override
    public boolean setXAxisMapping(int mapping) {
        switch (mapping) {
            case 0: 
            case 3: {
                this.xAxisMapping = mapping;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setYAxisMapping(int mapping) {
        switch (mapping) {
            case 1: 
            case 4: {
                this.yAxisMapping = mapping;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addLayerListener(LayerListenerInterface lli) {
        if (lli != null) {
            this.layerListenerList.add(LayerListenerInterface.class, lli);
        }
    }

    @Override
    public void removeLayerListener(LayerListenerInterface lli) {
        if (lli != null) {
            this.layerListenerList.remove(LayerListenerInterface.class, lli);
        }
    }

    protected void fireLayerListenerChanged(int action) {
        Object[] listeners = this.layerListenerList.getListenerList();
        if (this.lce == null) {
            this.lce = new LayerChangedEvent(this, action);
        } else {
            this.lce.setSource(this);
            this.lce.setAction(action);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LayerListenerInterface.class) continue;
            ((LayerListenerInterface)listeners[i + 1]).layerChanged(this.lce);
        }
    }

    @Override
    public Object getCustomBaseLineValue(Object context, int which) {
        double[] d;
        double min = Double.NaN;
        double max = Double.NaN;
        Double out = null;
        if (this.yDataRange != null && this.yDataRange instanceof ContinuousRange) {
            min = ((ContinuousRange)this.yDataRange).getMin();
            max = ((ContinuousRange)this.yDataRange).getMax();
        } else if (this.yAxis != null && (d = this.yAxis.getMinMaxTickMarkValues()) != null) {
            min = d[0];
            max = d[1];
        }
        if (!Double.isNaN(min) && !Double.isNaN(max)) {
            out = max >= 0.0 && min <= 0.0 ? new Double(0.0) : new Double(min);
        }
        return out;
    }
}

