/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.event.DrilldownEvent;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.ImageListInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.pie.PieDataModel;
import com.sas.graphics.silk.pie.PieDefaults;
import com.sas.graphics.silk.pie.Slice;
import com.sas.graphics.silk.pie.SliceRenderer;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.PieOptionsPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JPopupMenu;

public class PieComponent
extends SILKComponent
implements PropertyInterface,
PropertyChangeListener,
TextListenerInterface,
URLSourceInterface {
    private static final long serialVersionUID = -7309595436476122840L;
    PieDataModel model = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    JPopupMenu menu = null;
    private PropertyList pending = null;
    private SliceRenderer sliceRenderer = null;
    private LegendObjectJ2D legend = null;
    private boolean invalid = true;
    private BufferedImage backBuffer = null;
    private SILKNumber categoryRole;
    private SILKNumber responseRole;
    private SILKNumber colorIndexRole;
    private SILKNumber opacityRole;
    private SILKNumber transparencyRole;
    private SILKNumber urlRole;
    private SILKNumber groupRole;
    private SILKNumber groupIndexRole;
    private boolean addNotifyCalled = false;
    private PieDefaults pieDefaults = new PieDefaults();
    private Slice mouseOverSlice = null;
    public static int[] supportedPieComponentProperties = new int[]{39, 28, 2, 23, 8001, 8002, 8003, 8004, 8005, 8006, 8018, 8015, 8016, 8017, 8014, 8013, 8007, 8008, 8009, 8010, 8011, 8019, 8020, 8021, 601, 602, 603, 439};

    public PieComponent(Object dataIn) {
        this();
        this.setDataSource(dataIn);
    }

    public PieComponent() {
        this.categoryRole = this.roleIndex.getRoleObject("ROLE_CATEGORY");
        this.roles.newRole((Object)this.categoryRole, "CATEGORY", 1);
        this.responseRole = this.roleIndex.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "RESPONSE", 1);
        this.roles.setSortsSupported((Object)this.responseRole, new int[]{1, 0, -1});
        this.colorIndexRole = this.roleIndex.getRoleObject("ROLE_COLOR_INDEX");
        this.roles.newRole((Object)this.colorIndexRole, "COLORINDEX", 1);
        this.opacityRole = this.roleIndex.getRoleObject("ROLE_OPACITY");
        this.roles.newRole((Object)this.opacityRole, "OPACITY", 1);
        this.transparencyRole = this.roleIndex.getRoleObject("ROLE_TRANSPARENCY");
        this.roles.newRole((Object)this.transparencyRole, "TRANSPARENCY", 1);
        this.urlRole = this.roleIndex.getRoleObject("ROLE_URL");
        this.roles.newRole((Object)this.urlRole, "URL", 1);
        this.groupRole = this.roleIndex.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "GROUP", 1);
        this.roles.setSortsSupported((Object)this.groupRole, new int[]{1, 0, -1});
        this.groupIndexRole = this.roleIndex.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.newRole((Object)this.groupIndexRole, "GROUP_INDEX", 1);
        this.roles.setSortsSupported((Object)this.groupIndexRole, new int[]{1, 0, -1});
        this.legend = new LegendObjectJ2D();
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.menu = MenuUtilities.getPopupMenu(this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/PieMenu.xml"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                PieComponent.this.handleMenuCommand(actionCommand);
            }
        });
        this.pending = new PropertyList();
        this.noToolBar = true;
        this.legend.setPosition(2);
        this.addMouseListener(this.legend);
        this.addMouseMotionListener(this.legend);
        this.legend.setVisible(false);
        this.graphLayout.addLegend(this.legend);
        this.userSetProperties.appendProperties(supportedPieComponentProperties);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.addNotifyCalled) {
            return;
        }
        this.addNotifyCalled = true;
        this.build(new Boolean(true));
    }

    @Override
    protected void buildPropertiesDialog(Object listner) {
        super.buildPropertiesDialog(listner);
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Pie_Properties.txt", (String)"Pie Properties"));
        this.addTabs("Properties", this.propertiesDialog, 999, listner);
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        if (id == null || dialogIn == null) {
            return false;
        }
        if (id.equals("Properties")) {
            PieComponent pi = this;
            if (listener instanceof PropertyInterface) {
                pi = (PropertyInterface)listener;
            }
            if (dialogIn instanceof TabbedPropertiesDialog) {
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        legend = true;
                        chart = true;
                        graph = true;
                    }
                }
                TabbedPropertiesDialog tpd = (TabbedPropertiesDialog)dialogIn;
                TabPanelInterface tpi = null;
                if (graph && (tpi = tpd.getTab(GraphPanel.class)) == null) {
                    tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Graph.txt", (String)"Graph"), new GraphPanel(pi, pi));
                }
                if (chart) {
                    tpi = tpd.getTab(PieOptionsPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Pie.txt", (String)"Pie"), new PieOptionsPanel(pi));
                    }
                }
                if (legend) {
                    tpi = tpd.getTab(LegendPanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Legend.txt", (String)"Legend"), new LegendPanel(pi));
                    }
                }
                if (titles) {
                    tpi = tpd.getTab(TitlePanel.class);
                    if (tpi != null) {
                        tpi.addPropertyListener(pi);
                    } else {
                        tpd.addTab(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Title_Footnote.txt", (String)"Title/Footnote"), new TitlePanel(pi, this));
                    }
                }
            } else if (dialogIn instanceof GraphPropertiesDialog && dialogIn instanceof GraphPropertiesDialog) {
                GraphPropertiesDialog.PropertiesTreeNode node;
                boolean graph = false;
                boolean chart = false;
                boolean legend = false;
                boolean axes = false;
                boolean titles = false;
                switch (category) {
                    case 0: {
                        graph = true;
                        break;
                    }
                    case 1: {
                        chart = true;
                        break;
                    }
                    case 3: {
                        legend = true;
                        break;
                    }
                    case 2: {
                        axes = true;
                        break;
                    }
                    case 4: {
                        titles = true;
                        break;
                    }
                    case 999: {
                        titles = true;
                        axes = true;
                        legend = true;
                        chart = true;
                        graph = true;
                    }
                }
                GraphPropertiesDialog gpd = (GraphPropertiesDialog)dialogIn;
                if (graph) {
                    super.addTabs(id, dialogIn, 0, listener);
                }
                if (chart) {
                    node = gpd.getRootNode("Chart", true);
                    node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Pie.txt", (String)"Pie"));
                    Component c = node.getPanel();
                    if (c instanceof PieOptionsPanel) {
                        ((PieOptionsPanel)c).addPropertyListener(pi);
                    } else {
                        node.setPanel(new PieOptionsPanel(pi));
                    }
                }
                if (axes) {
                    super.addTabs(id, dialogIn, 2, listener);
                }
                if (legend) {
                    node = gpd.getRootNode("Legend", true);
                    node.setDisplayName(ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Legend.txt", (String)"Legend"));
                    Component panel = node.getPanel();
                    if (panel instanceof LegendPanel) {
                        ((LegendPanel)panel).addPropertyListener(pi);
                    } else if (panel == null) {
                        LegendPanel p = new LegendPanel(pi);
                        node.setPanel(p);
                    }
                }
                if (titles) {
                    super.addTabs(id, dialogIn, 4, listener);
                }
            }
        }
        return false;
    }

    private void buildLegend() {
        LegendEntryInterface[] legEntries;
        if (this.model == null || this.model.getNumGroups() <= 0) {
            if (this.legend != null) {
                this.graphLayout.removeLegend(this.legend);
            }
            return;
        }
        if (!this.graphLayout.containsLegend(this.legend)) {
            this.graphLayout.addLegend(this.legend);
        }
        if (this.legend != null && (legEntries = this.sliceRenderer.getLegendEntries()) != null) {
            this.legend.setValues(legEntries, false);
        }
        if (this.graphLayout != null) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.invalid || this.legend != null && this.legend.isUpdateRequired()) {
            this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
            this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
            this.setCenters(g2);
            if (this.backBuffer != null) {
                this.backBuffer.flush();
            }
            this.backBuffer = null;
            this.invalid = false;
        }
        if (this.isUsingBackBuffer()) {
            if (this.backBuffer == null) {
                this.buildBackBuffer();
            }
            g.drawImage(this.backBuffer, 0, 0, null);
        } else {
            this.drawChart(g2);
        }
        if (this.sliceRenderer != null) {
            this.sliceRenderer.paintSelections(g2);
        }
    }

    private void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0 || !this.isUsingBackBuffer()) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = SILKUtilities.createCompatibleImage((int)this.compWidth, (int)this.compHeight, (int)3);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    private void drawChart(Graphics2D g) {
        Rectangle rectangle = new Rectangle(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g, this, rectangle);
        if (this.sliceRenderer != null) {
            this.sliceRenderer.paint(g, this.graphLayout.getChartArea());
        }
        this.graphLayout.draw(g);
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        Object group;
        Object transparency;
        this.mouseOverSlice = this.sliceRenderer.getSliceAtPoint(me.getPoint());
        if (this.mouseOverSlice == null) {
            return null;
        }
        Object category = this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0);
        if (category == null) {
            return null;
        }
        Object obj = this.dataFilter.getVariableDescription(category);
        if (obj == null) {
            return null;
        }
        String rc = obj.toString();
        if (rc == null) {
            rc = this.dataFilter.getVariableId(this.dataFilter.getVariableIndex(category)).toString();
        }
        rc = rc + "\t = \t" + this.mouseOverSlice.getNonTruncatedDisplayName();
        Object response = this.roles.getVariable(RoleInterface.ROLE_RESPONSE, 0);
        if (response != null) {
            obj = this.dataFilter.getVariableDescription(response);
            if (obj == null) {
                return null;
            }
            if ((rc = rc + "\n" + obj.toString()) == null) {
                rc = this.dataFilter.getVariableId(this.dataFilter.getVariableIndex(response)).toString();
            }
            rc = rc + "\t = \t";
            double value = this.mouseOverSlice.getResponseValue();
            rc = Double.isNaN(value) ? rc + ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.pie.silk_pie_NLS", (String)"Slice.Missing.txt", (String)"Missing") : rc + this.formatValue(value, response);
        } else {
            rc = rc + "\n" + ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.pie.silk_pie_NLS", (String)"PieComponent.StatisticsType.txt", (String)"Frequency");
            rc = rc + "\t = \t" + this.mouseOverSlice.getObservationCount();
        }
        Object opacity = this.roles.getVariable(RoleInterface.ROLE_OPACITY, 0);
        if (opacity != null) {
            obj = this.dataFilter.getVariableDescription(opacity);
            if (obj == null) {
                return null;
            }
            if ((rc = rc + "\n" + obj.toString()) == null) {
                rc = this.dataFilter.getVariableId(this.dataFilter.getVariableIndex(opacity)).toString();
            }
            rc = rc + "\t = \t";
            double value = this.mouseOverSlice.getTransparencyValue();
            rc = Double.isNaN(value) ? rc + ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.pie.silk_pie_NLS", (String)"Slice.Missing.txt", (String)"Missing") : rc + this.formatValue(value, opacity);
        }
        if ((transparency = this.roles.getVariable(RoleInterface.ROLE_TRANSPARENCY, 0)) != null) {
            obj = this.dataFilter.getVariableDescription(transparency);
            if (obj == null) {
                return null;
            }
            if ((rc = rc + "\n" + obj.toString()) == null) {
                rc = this.dataFilter.getVariableId(this.dataFilter.getVariableIndex(transparency)).toString();
            }
            rc = rc + "\t = \t";
            double value = this.mouseOverSlice.getTransparencyValue();
            rc = Double.isNaN(value) ? rc + ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.pie.silk_pie_NLS", (String)"Slice.Missing.txt", (String)"Missing") : rc + this.formatValue(value, transparency);
        }
        if ((group = this.roles.getVariable(RoleInterface.ROLE_GROUP, 0)) != null && (obj = this.dataFilter.getVariableDescription(group)) != null) {
            Object value;
            String str = obj.toString();
            if (str == null) {
                str = this.dataFilter.getVariableId(this.dataFilter.getVariableIndex(group)).toString();
            }
            if ((value = this.mouseOverSlice.getGroupId()) instanceof Number && Double.isNaN(((Number)value).doubleValue())) {
                value = ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.pie.silk_pie_NLS", (String)"Slice.Missing.txt", (String)"Missing");
            } else if (value instanceof Number) {
                value = this.formatValue(((Number)value).doubleValue(), group);
            }
            rc = rc + "\n" + str + "\t = \t" + value;
        }
        return rc;
    }

    private String formatValue(double val, Object var) {
        SASFormat fmt = SASFormat.getInstance((String)"BEST8.");
        if (var != null && this.model.getDataFilter().getFormat(var, SASFormat.class) != null) {
            fmt = (SASFormat)this.model.getDataFilter().getFormat(var, SASFormat.class);
        }
        return fmt.format((Object)new Double(val));
    }

    private void setCenters(Graphics2D g) {
        if (this.compWidth * this.compHeight == 0) {
            return;
        }
        if (this.sliceRenderer == null) {
            return;
        }
        double rad = 100.0;
        Rectangle pieArea = this.graphLayout.getChartArea();
        double minPieWidthPercent = this.pieDefaults.minimumPiePercentage;
        double minWidth = pieArea.getWidth() * minPieWidthPercent;
        int width = (int)(pieArea.getWidth() - (double)((int)minWidth)) / 2;
        this.sliceRenderer.setMaxLabelWidth(width / 2);
        int maxWidth = (pieArea.width - 2 * this.sliceRenderer.getOuterLabelWidth(g)) / 2;
        int maxHeight = (pieArea.height - 2 * this.sliceRenderer.getOuterLabelHeight(g)) / 2;
        Point centerPoint = new Point(pieArea.x + pieArea.width / 2, pieArea.y + pieArea.height / 2);
        if (this.roles.getNumVariablesAssigned((Object)this.groupRole) > 0 && this.sliceRenderer != null && this.sliceRenderer.isDrawGroupLabels()) {
            double wi = this.sliceRenderer.calculateGroupLabelWidth(g);
            if (pieArea.getWidth() - wi < minWidth || Math.min(maxWidth, maxHeight -= this.model.getNumGroups() * 3) < this.model.getNumGroups() * 6) {
                this.sliceRenderer.setGroupLabelAreaWidth(0);
                rad = Math.min(maxWidth -= this.model.getNumGroups() * 3, maxHeight);
                this.sliceRenderer.setGroupLabelAreaWidth(0);
            } else {
                maxWidth = Math.max(maxWidth, this.model.getNumGroups() * 15);
                this.sliceRenderer.setGroupLabelAreaWidth((int)wi);
                centerPoint = new Point(pieArea.x + (pieArea.width - (int)wi) / 2, pieArea.y + pieArea.height / 2);
                rad = Math.min(maxWidth - (int)wi, maxHeight - 8);
            }
        } else if (this.roles.getNumVariablesAssigned((Object)this.groupRole) > 0) {
            rad = Math.min(maxWidth, maxHeight) - this.model.getNumGroups() * 5;
            rad = Math.max(rad, 5.0);
        } else {
            rad = Math.min(maxWidth, maxHeight);
        }
        if (this.sliceRenderer != null) {
            this.sliceRenderer.setComponentBounds(this.graphLayout.getChartArea());
        }
        this.sliceRenderer.setCenter(centerPoint);
        this.sliceRenderer.setRadius(rad);
    }

    @Override
    public int getActionMode() {
        return 6;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle.equals(this.style)) {
            return true;
        }
        super.setStyle(newStyle);
        if (this.legend != null) {
            this.legend.applyStyle(this.style);
        }
        if (this.sliceRenderer != null) {
            this.sliceRenderer.setStyle(this.style);
        }
        return this.buildAndDraw(null, null, null);
    }

    @Override
    public LegendInterface getLegend(Object which) {
        return this.legend;
    }

    @Override
    public Object getLegendPosition(Object which) {
        return this.legend.getLegendNumber(this.legend.getPosition());
    }

    @Override
    public boolean setLegendPosition(Object which, Object positionIn) {
        if (positionIn instanceof Number) {
            this.legend.setPosition(((Number)positionIn).intValue());
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getLegendBounds() {
        return null;
    }

    @Override
    public boolean setLegendBounds(Rectangle rect) {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.model != null) {
            this.model.dispose();
        }
        this.dataDlg = null;
        this.menu = null;
        this.pending = null;
        if (this.sliceRenderer != null) {
            this.sliceRenderer.dispose();
        }
        this.sliceRenderer = null;
        this.legend = null;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.menu;
    }

    @Override
    public boolean setDataSource(Object source) {
        boolean rc = super.setDataSource(source);
        if (rc) {
            this.model = new PieDataModel(this.dataFilter, this.roles);
            this.sliceRenderer = new SliceRenderer(this.model);
            this.sliceRenderer.labels.addTextListener(this);
            this.build(new Boolean(true));
            if (this.dataDlg != null) {
                this.createDataDialog(this);
            }
        }
        return rc;
    }

    @Override
    public void roleChanged(RoleEvent re) {
        Object variableId;
        if (this.dataFilter == null) {
            return;
        }
        if (this.sliceRenderer != null) {
            this.sliceRenderer.reset();
        }
        if (this.legend != null) {
            if (this.dataFilter != null) {
                this.legend.setTitle(this.dataFilter.getVariableDescription(this.roles.getVariable((Object)this.categoryRole, 0)));
                this.currentLegend = this.categoryRole;
            }
            this.legend.getLabel().setFormat(null);
        }
        if (this.legend != null && (variableId = this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0)) != null) {
            Object format = this.dataFilter.getFormat(variableId, SASFormat.class);
            if (this.legend != null && format != null && this.legend.getLabel() != null) {
                this.legend.getLabel().setFormat(format);
            }
            this.legend.setData(this.dataFilter, variableId.toString());
        }
        if (re.type == 2 || re.type == 1) {
            if (re.role == 52) {
                this.roles.removeRole(this.roles.getVariable(RoleInterface.ROLE_OPACITY, 0), (Object)this.opacityRole);
                this.sliceRenderer.setTreatOpacityValueAsTransparency(true);
            } else if (re.role == 11) {
                this.roles.removeRole(this.roles.getVariable(RoleInterface.ROLE_TRANSPARENCY, 0), (Object)this.transparencyRole);
                this.sliceRenderer.setTreatOpacityValueAsTransparency(false);
            }
        }
        this.buildAndDraw(new Boolean(true), null, null);
    }

    @Override
    public boolean isDiscrete(Object variableId) {
        return variableId == this.roles.getVariable((Object)this.categoryRole, 0);
    }

    @Override
    public boolean setDiscrete(Object variableId, boolean discrete) {
        return false;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean b) {
        if (!b) {
            return new Object[]{this.responseRole, this.colorIndexRole, this.groupIndexRole, this.opacityRole, this.transparencyRole};
        }
        return new Object[]{this.categoryRole, this.responseRole, this.colorIndexRole, this.opacityRole, this.transparencyRole, this.urlRole, this.groupRole, this.groupIndexRole};
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        Object rc = null;
        if (role == null) {
            return null;
        }
        switch (which) {
            case 2: {
                if (this.mouseOverSlice == null) break;
                if (role.equals((Object)this.categoryRole)) {
                    rc = this.mouseOverSlice.getDisplayName();
                    break;
                }
                if (role.equals((Object)this.colorIndexRole)) {
                    rc = new Integer(this.mouseOverSlice.getColorIndex());
                    break;
                }
                if (role.equals((Object)this.opacityRole) || role.equals((Object)this.transparencyRole)) {
                    rc = new Double(this.mouseOverSlice.getTransparencyValue());
                    break;
                }
                if (role.equals((Object)this.responseRole)) {
                    rc = new Double(this.mouseOverSlice.getResponseValue());
                    break;
                }
                if (!role.equals((Object)this.urlRole)) break;
                rc = this.mouseOverSlice.getSliceURL();
                break;
            }
        }
        return rc;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt.type == 2) {
            if (this.model == null) {
                return;
            }
            int[] arr = (int[])evt.oldValue;
            if (arr == null) {
                Enumeration e = this.model.getGroups();
                while (e.hasMoreElements()) {
                    Slice[] slices = this.model.getSlices(e.nextElement());
                    for (int i = 0; i < slices.length; ++i) {
                        slices[i].updateSelection(-999, this.dataFilter);
                    }
                }
            } else {
                int numInList = arr.length;
                if (evt.newValue != null && evt.newValue instanceof Number) {
                    numInList = ((Number)evt.newValue).intValue();
                }
                if (numInList > arr.length) {
                    numInList = arr.length;
                }
                for (int i = 0; i < numInList; ++i) {
                    Slice[] s = this.getSlicesWithObsIndex(arr[i]);
                    if (s == null) continue;
                    for (int j = 0; j < s.length; ++j) {
                        s[j].updateSelection(arr[i], this.dataFilter);
                    }
                }
            }
        } else if (!evt.isAdjusting) {
            this.build(new Boolean(true));
        }
        this.repaint();
    }

    private Slice[] getSlicesWithObsIndex(int ob) {
        if (this.model == null) {
            return null;
        }
        Vector<Slice> v = new Vector<Slice>();
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Slice[] slices = this.model.getSlices(e.nextElement());
            for (int i = 0; i < slices.length; ++i) {
                if (!slices[i].containsObservation(ob)) continue;
                v.addElement(slices[i]);
            }
        }
        Object[] rc = new Slice[v.size()];
        v.copyInto(rc);
        return rc;
    }

    @Override
    protected void doResize(int w, int h) {
        super.doResize(w, h);
        this.buildLegend();
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setCenters(g);
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.sliceRenderer != null) {
            this.sliceRenderer.setComponentBounds(this.graphLayout.getChartArea());
        }
        this.buildAndDraw(null, null, null);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int flags = me.getModifiers();
        if (this.menu != null && (flags & 4) != 0 && this.allowPopup) {
            int x = me.getX();
            int y = me.getY();
            this.menu.show(this, x, y);
        } else if (this.model != null) {
            Slice s;
            if (this.actionMode == 8) {
                s = this.sliceRenderer.getSliceAtPoint(me.getPoint());
                if (s != null) {
                    Hashtable<Integer, Object> drillData = new Hashtable<Integer, Object>();
                    drillData.put(DrilldownEvent.DRILLDOWN_KEY_URL, s.getSliceURL() == null ? s.getDisplayName() : s.getSliceURL());
                    drillData.put(DrilldownEvent.DRILLDOWN_KEY_CATEGORY, s.getDisplayName());
                    if (s.getGroupId() != null) {
                        drillData.put(DrilldownEvent.DRILLDOWN_KEY_GROUP, s.getGroupId());
                    }
                    this.fireDrillDownEvent(drillData);
                }
                if (!this.selectOnDrilldown) {
                    super.mousePressed(me);
                    return;
                }
            }
            if (!me.isControlDown()) {
                Enumeration e = this.model.getGroups();
                while (e.hasMoreElements()) {
                    Slice[] slices = this.model.getSlices(e.nextElement());
                    for (int i = 0; i < slices.length; ++i) {
                        slices[i].updateSelection(-999, this.dataFilter);
                    }
                }
                this.dataFilter.unselectAll();
            }
            if ((s = this.sliceRenderer.getSliceAtPoint(me.getPoint())) != null) {
                if (me.isControlDown()) {
                    s.toggleAll(this.dataFilter);
                } else {
                    s.selectAll(this.dataFilter);
                }
            }
        }
        super.mousePressed(me);
    }

    @Override
    public boolean isPropertySupported(int id) {
        for (int i = 0; i < supportedPieComponentProperties.length; ++i) {
            if (id != supportedPieComponentProperties[i]) continue;
            return true;
        }
        return super.isPropertySupported(id);
    }

    @Override
    public boolean isPropertyPending(int id) {
        return this.pending.isPending(id);
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pending != null && this.pending.isPending(id)) {
            return this.pending.getValueById(id);
        }
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.getPropertyValue(id);
        }
        Object rc = null;
        switch (id) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                rc = this.background.getPropertyValue(id);
                break;
            }
            case 0: {
                rc = this.getColorScheme();
                break;
            }
            case 30: {
                rc = this.imageList;
                break;
            }
            case 39: {
                rc = Boolean.TRUE;
                break;
            }
            case 28: {
                rc = new Boolean(this.imageList != null);
                break;
            }
            case 2: {
                rc = new Boolean(this.tipsOn);
                break;
            }
            case 23: {
                rc = this.legend;
                break;
            }
            case 24: {
                if (this.legend == null) break;
                rc = this.currentLegend;
                break;
            }
            case 25: {
                TextStyleInterface txt;
                if (this.legend == null || (txt = this.legend.getTitle()) == null) break;
                rc = txt.toString();
                break;
            }
            case 433: {
                rc = this.sliceRenderer.getLegendEntries();
                break;
            }
            case 8001: {
                rc = this.sliceRenderer.getNameLabelPosition();
                break;
            }
            case 8002: {
                rc = this.sliceRenderer.getDataLabelPosition();
                break;
            }
            case 8003: {
                rc = this.sliceRenderer.getPercentLabelPosition();
                break;
            }
            case 8004: {
                rc = this.sliceRenderer.getLabels();
                break;
            }
            case 8005: {
                rc = new Boolean(this.sliceRenderer.areOutlinesVisible());
                break;
            }
            case 8006: {
                rc = new Integer(this.sliceRenderer.getOutlineThickness());
                break;
            }
            case 8018: {
                rc = new Boolean(this.model.isOtherVisible());
                break;
            }
            case 8015: {
                rc = new Integer(this.model.getOtherThresholdType());
                break;
            }
            case 8016: {
                rc = new Double(this.model.getOtherThresholdPct());
                break;
            }
            case 8017: {
                rc = new Integer(this.model.getOtherThresholdMaxSlices());
                break;
            }
            case 8014: {
                rc = this.model.getOtherColor();
                break;
            }
            case 8013: {
                rc = this.model.getOtherLabel();
                break;
            }
            case 8007: {
                rc = new Integer(this.sliceRenderer.getPieDirection());
                break;
            }
            case 8008: {
                rc = new Integer(this.sliceRenderer.getStartAngle());
                break;
            }
            case 8009: {
                rc = new Boolean(this.model.categoryByFormattedValue);
                break;
            }
            case 8010: {
                rc = new Boolean(this.sliceRenderer.isDrawGroupLabels());
                break;
            }
            case 8011: {
                rc = new Integer(this.sliceRenderer.getLabelScheme());
                break;
            }
            case 601: {
                rc = this.graphLayout.getTitle().getTitle(0);
                break;
            }
            case 602: {
                rc = this.graphLayout.getTitle().getTitle(1);
                break;
            }
            case 603: {
                rc = this.graphLayout.getFootnote().getFootnote(0);
                break;
            }
            case 439: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"PieComponent.Overlay.txt", (String)"Overlay");
                break;
            }
            case 434: {
                rc = this.roles.getVariable(RoleInterface.ROLE_CATEGORY, 0);
                break;
            }
            case 8012: {
                if (this.model == null) {
                    rc = Boolean.FALSE;
                    break;
                }
                rc = this.roles.getVariable((Object)this.groupRole, 0) != null ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 8020: {
                rc = new Integer(this.sliceRenderer.getLabelCompMask());
                break;
            }
            case 8019: {
                rc = this.sliceRenderer.getLabelPosition();
                break;
            }
            case 8021: {
                rc = this.sliceRenderer.getLabelSeparator();
                break;
            }
            case 62: {
                rc = this.getId();
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        if (this.background != null && this.background.isPropertySupported(id)) {
            this.background.setPropertyValue(id, value);
        }
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            this.legend.setPropertyValue(id, value);
        }
        if (this.pending == null) {
            this.pending = new PropertyList();
        }
        this.pending.store(id, value);
        return true;
    }

    @Override
    public int getNumberPendingProperties() {
        return this.pending.getNumberPending(null);
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        if (this.background != null) {
            this.background.applyPropertyChanges(source);
        }
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
        this.buildLegend();
        Vector changes = this.pending.getChangesBySource(source);
        block27: for (int i = 0; i < changes.size(); ++i) {
            PropertyEvent event = (PropertyEvent)changes.elementAt(i);
            int key = event.id;
            Object value = event.value;
            switch (key) {
                case 0: {
                    this.setColorScheme(value);
                    continue block27;
                }
                case 29: {
                    this.setStyle(value);
                    continue block27;
                }
                case 30: {
                    if (!(value instanceof ImageListInterface)) continue block27;
                    this.setImageList((ImageListInterface)value);
                    continue block27;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block27;
                    this.tipsOn = (Boolean)value;
                    continue block27;
                }
                case 8001: {
                    if (!(value instanceof String) || this.sliceRenderer.getNameLabelPosition().equalsIgnoreCase((String)value)) continue block27;
                    this.sliceRenderer.setNameLabelPosition((String)value);
                    this.userSetProperties.set(key);
                    this.sliceRenderer.reset();
                    continue block27;
                }
                case 8002: {
                    if (!(value instanceof String) || this.sliceRenderer.getDataLabelPosition().equalsIgnoreCase((String)value)) continue block27;
                    this.sliceRenderer.setDataLabelPosition((String)value);
                    this.userSetProperties.set(key);
                    this.sliceRenderer.reset();
                    continue block27;
                }
                case 8003: {
                    if (!(value instanceof String) || this.sliceRenderer.getPercentLabelPosition().equalsIgnoreCase((String)value)) continue block27;
                    this.sliceRenderer.setPercentLabelPosition((String)value);
                    this.userSetProperties.set(key);
                    this.sliceRenderer.reset();
                    continue block27;
                }
                case 8005: {
                    if (!(value instanceof Boolean) || ((Boolean)value).booleanValue() == this.sliceRenderer.areOutlinesVisible()) continue block27;
                    this.sliceRenderer.setOutlinesVisible((Boolean)value);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8006: {
                    if (!(value instanceof Number) || ((Number)value).intValue() == this.sliceRenderer.getOutlineThickness()) continue block27;
                    this.sliceRenderer.setOutlineThickness(((Number)value).intValue());
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8004: {
                    if (!(value instanceof Text)) continue block27;
                    this.sliceRenderer.labels = (Text)value;
                    continue block27;
                }
                case 8007: {
                    int dir = -1;
                    if (value instanceof Number) {
                        dir = ((Number)value).intValue();
                    } else {
                        String str = value.toString();
                        if (str.equalsIgnoreCase("Clockwise")) {
                            dir = 0;
                        } else if (str.equalsIgnoreCase("CounterClockwise")) {
                            dir = 1;
                        }
                    }
                    if (dir == this.sliceRenderer.getPieDirection()) continue block27;
                    this.sliceRenderer.setPieDirection(dir);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8008: {
                    if (value instanceof Number) {
                        this.sliceRenderer.setStartAngle(((Number)value).intValue());
                    }
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8009: {
                    if (!(value instanceof Boolean)) continue block27;
                    this.model.categoryByFormattedValue = (Boolean)value;
                    continue block27;
                }
                case 8010: {
                    if (!(value instanceof Boolean) || ((Boolean)value).booleanValue() == this.sliceRenderer.isDrawGroupLabels()) continue block27;
                    this.sliceRenderer.setDrawGroupLabels((Boolean)value);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8011: {
                    int scheme = -1;
                    if (value instanceof Number) {
                        scheme = ((Number)value).intValue();
                    } else {
                        String str = value.toString();
                        if (str.equalsIgnoreCase("Default")) {
                            scheme = 0;
                        } else if (str.equalsIgnoreCase("Margin")) {
                            scheme = 2;
                        } else if (str.equalsIgnoreCase("Radial")) {
                            scheme = 1;
                        }
                    }
                    if (scheme == this.sliceRenderer.getLabelScheme()) continue block27;
                    this.sliceRenderer.setLabelScheme(scheme);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8013: {
                    if (!(value instanceof String)) continue block27;
                    this.model.setOtherLabel((String)value);
                    this.sliceRenderer.setOtherLabel((String)value);
                    this.model.build(null);
                    this.sliceRenderer.reset();
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8014: {
                    if (!(value instanceof Color)) continue block27;
                    this.model.setOtherColor((Color)value);
                    this.model.build(null);
                    this.sliceRenderer.reset();
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8018: {
                    if (value instanceof Boolean) {
                        this.model.setOtherVisible((Boolean)value);
                        this.model.build(null);
                        this.sliceRenderer.reset();
                    }
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8015: {
                    int tt = -1;
                    if (value instanceof Number) {
                        tt = ((Number)value).intValue();
                    } else {
                        String str = value.toString();
                        if (str.equalsIgnoreCase("Percent")) {
                            tt = 0;
                        } else if (str.equalsIgnoreCase("MaxSlices")) {
                            tt = 1;
                        }
                    }
                    this.model.setOtherThresholdType(tt);
                    this.model.build(null);
                    this.sliceRenderer.reset();
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8016: {
                    if (!(value instanceof Number)) continue block27;
                    this.model.setOtherThresholdPct(((Number)value).doubleValue());
                    this.model.build(null);
                    this.sliceRenderer.reset();
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8017: {
                    if (!(value instanceof Number)) continue block27;
                    this.model.setOtherThresholdMaxSlices(((Number)value).intValue());
                    this.model.build(null);
                    this.sliceRenderer.reset();
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8020: {
                    if (!(value instanceof Number)) continue block27;
                    this.sliceRenderer.setLabelCompMask(((Number)value).intValue());
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8019: {
                    if (!(value instanceof String)) continue block27;
                    this.sliceRenderer.setLabelPosition((String)value);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 8021: {
                    if (!(value instanceof String)) continue block27;
                    this.sliceRenderer.setLabelSeparator((String)value);
                    this.userSetProperties.set(key);
                    continue block27;
                }
                case 62: {
                    this.setId(value);
                }
            }
        }
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
        this.buildLegend();
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setCenters(g);
        this.buildAndDraw(null, null, null);
        this.pending.removeChangesBySource(source);
        return true;
    }

    @Override
    public void cancelPropertyChanges(Object source) {
        this.pending.removeChangesBySource(source);
    }

    @Override
    public int[] getPendingChanges(Object source) {
        return this.pending.getPending(source);
    }

    @Override
    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    @Override
    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    @Override
    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.sliceRenderer.reset();
        this.buildLegend();
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setCenters(g);
        this.buildAndDraw(null, null, null);
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        if (this.sliceRenderer != null) {
            this.sliceRenderer.reset();
        }
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setCenters(g);
        this.buildAndDraw(null, null, null);
    }

    @Override
    public boolean build(Object obj) {
        this.background.rebuildBackground();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue() && this.model != null) {
            this.model.build(obj);
        }
        if (this.sliceRenderer != null) {
            this.sliceRenderer.reset();
        }
        this.buildLegend();
        this.graphLayout.doLayout(new Rectangle(this.getX(), this.getY(), this.compWidth, this.compHeight));
        this.graphLayout.setDataRegion(this.graphLayout.getChartArea());
        Graphics2D g = (Graphics2D)this.getGraphics();
        this.setCenters(g);
        if (this.isUsingBackBuffer()) {
            this.buildBackBuffer();
        }
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        this.build(buildData);
        this.repaint();
        return true;
    }

    public TextStyleInterface getLabels() {
        if (this.sliceRenderer == null) {
            return null;
        }
        return this.sliceRenderer.getLabels();
    }

    public boolean getDrawGroupLabels() {
        if (this.sliceRenderer == null) {
            return false;
        }
        return this.sliceRenderer.isDrawGroupLabels();
    }

    public void setDrawGroupLabels(boolean draw) {
        if (this.sliceRenderer != null) {
            this.sliceRenderer.setDrawGroupLabels(draw);
        }
    }

    @Override
    public void addURLConsumer(Object context, URLConsumerInterface consumer) {
        if (consumer != null && !this.sliceRenderer.getURLConsumers().contains(consumer)) {
            this.sliceRenderer.getURLConsumers().addElement(consumer);
        }
    }

    @Override
    public void removeURLConsumer(URLConsumerInterface consumer) {
        this.sliceRenderer.getURLConsumers().remove(consumer);
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        if (action != null && !enable && ("GRAPH_PROPERTIES".equalsIgnoreCase(action) || "DATA_OPTIONS".equalsIgnoreCase(action) || "ACTION_MENU".equalsIgnoreCase(action) || "COPY".equalsIgnoreCase(action))) {
            this.actions.put(action, Boolean.FALSE);
            MenuUtilities.removeMenuItem(this.menu, action);
            return true;
        }
        return super.setActionEnabled(action, enable);
    }
}

