/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.data.Filter2TableModel;
import com.sas.graphics.silk.data.TableSelectionModelAdapter;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DrilldownListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.interfaces.AnnotateInterface;
import com.sas.graphics.silk.interfaces.ColorSchemeInterface;
import com.sas.graphics.silk.interfaces.ComponentInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TipInterface;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.Footnote;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.Title;
import com.sas.graphics.silk.util.table.ColumnHeaderRenderer;
import com.sas.graphics.silk.util.table.HeaderTextPaneRenderer;
import com.sas.graphics.silk.util.table.SILKTableInterface;
import com.sas.graphics.silk.util.table.TableSorter;
import com.sas.graphics.silk.util.table.TableStyle;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleCollection;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.PropertyEvent;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JTableComponent
extends JComponent
implements DataFilterListenerInterface,
ComponentInterface,
SourceInterface,
PropertyInterface,
PropertyChangeListener,
SILKTableInterface,
Printable,
Pageable {
    private static final long serialVersionUID = 6059689034191243991L;
    private Object dataSource = null;
    private DataFilterReadInterface filter;
    Filter2TableModel f2tModel = null;
    private boolean listenToEvents = true;
    private JTable table;
    private JScrollPane tablePane;
    private TitleComponent title;
    private FootnoteComponent footnote;
    private String[] formatStrings;
    private JTableHeader tableHeader;
    private int[] subTableSplit = null;
    private boolean pageinfoCalculated = false;
    private int totalNumPages = 0;
    private int prevPageIndex = 0;
    private int subPageIndex = 0;
    private int subTableSplitSize = 0;
    private double tableHeightOnFullPage;
    private double headerHeight;
    private double pageWidth;
    private double pageHeight;
    private int fontHeight;
    private double tableHeight;
    private double rowHeight;
    private TableSorter tableSorter = null;
    private ImageIcon ascendingIcon = null;
    private ImageIcon descendingIcon = null;
    private final String ascendingIconPath = "icons/ascendingIcon.gif";
    private final String descendingIconPath = "icons/descendingIcon.gif";
    private final String DEFAULT_FORMAT = "best8.";
    private ResourceBundle rb = null;
    private Object id = null;
    private TableStyle style = new TableStyle(0);
    private ColorSchemeInterface colorScheme;
    private HashMap pendingProperties = new HashMap();
    private TableSelectionModelAdapter selectionAdapter = null;
    private boolean sortEnabled = true;
    private boolean scrollToSelected = false;
    protected boolean editable = false;
    protected boolean headerWrap = false;
    private Style graphStyle = null;
    private int lastColCount = 0;
    protected int headerHt = 0;

    public JTableComponent() {
        this.table = new JTable();
        this.table.setAutoCreateColumnsFromModel(true);
        this.table.setAutoResizeMode(0);
        this.tablePane = new JScrollPane(this.table);
        this.title = new TitleComponent(this);
        this.footnote = new FootnoteComponent(this);
        this.tableSorter = new TableSorter();
        this.selectionAdapter = new TableSelectionModelAdapter();
        this.selectionAdapter.setModel(this.table.getSelectionModel());
        this.selectionAdapter.setSorter(this.tableSorter);
        this.setLayout(new BorderLayout());
        this.add(this.tablePane);
        this.loadIcons();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        SILKGlobal.register(this);
    }

    public JTableComponent(Object source) {
        this();
        this.setDataSource(source);
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean setDataSource(Object source) {
        if (source == null) {
            return false;
        }
        this.dataSource = source;
        boolean throwDummyEvent = false;
        if (this.filter != null) {
            this.filter.removeDataFilterListener((Object)this);
            this.filter = null;
            this.table.clearSelection();
            throwDummyEvent = true;
            if (this.tableSorter != null) {
                this.tableSorter.removeMouseListenerToHeaderInTable(this.table);
            }
            this.tableSorter = new TableSorter();
        }
        this.filter = FilterFactory.getDataSourceFilter((Object)this.dataSource);
        if (this.filter == null) {
            return false;
        }
        this.f2tModel = new Filter2TableModel(this.filter);
        this.f2tModel.setTableEditable(this.editable);
        this.tableSorter.setModel((TableModel)this.f2tModel);
        if (this.sortEnabled) {
            this.tableSorter.addMouseListenerToHeaderInTable(this.table, this.ascendingIcon, this.descendingIcon, null);
        }
        this.table.setModel(this.tableSorter);
        this.filter.addDataFilterListener((Object)this);
        this.selectionAdapter.setSorter(this.tableSorter);
        this.selectionAdapter.setFilter(this.filter);
        this.selectionAdapter.addPropertyChangeListener(this);
        this.formatStrings = new String[this.table.getColumnCount()];
        this.initColumnFormats();
        this.setUpColumnHeaderRenderers();
        this.lastColCount = this.tableSorter.getColumnCount();
        if (this.tableSorter.isObsNumberColumnVisible()) {
            --this.lastColCount;
        }
        if (throwDummyEvent) {
            this.throwTableModelEvent();
        }
        return true;
    }

    public boolean setDataSource(Object source, Object type) {
        return this.setDataSource(source);
    }

    public Object getDataSource() {
        if (this.dataSource != null && this.dataSource instanceof DataFilterReadInterface) {
            return ((DataFilterReadInterface)this.dataSource).getSource();
        }
        return this.dataSource;
    }

    public Object getDataSource(Object type) {
        return this.getDataSource();
    }

    public Object[] getDataIds() {
        return null;
    }

    public void initColumnFormats() {
        if (this.filter != null) {
            int numCols = this.table.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                Object varId = this.filter.getVariableId(i);
                if (varId != null) {
                    Object o = this.filter.getFormat(varId, String.class);
                    if (o instanceof String) {
                        this.formatStrings[i] = (String)o;
                        if (this.formatStrings[i].trim().length() != 0) continue;
                        this.formatStrings[i] = "best8.";
                        continue;
                    }
                    this.formatStrings[i] = "best8.";
                    continue;
                }
                this.formatStrings[i] = "best8.";
            }
        }
        this.setColumnFormats();
    }

    public void setColumnFormats() {
        int numCols = this.table.getColumnCount();
        if (this.formatStrings == null || this.formatStrings.length != numCols) {
            this.formatStrings = new String[numCols];
        }
        for (int i = 0; i < numCols; ++i) {
            if (this.filter == null) {
                this.formatStrings[i] = null;
            } else {
                Object fmt = null;
                if (this.isObsNumberColumnVisible()) {
                    if (i > 0) {
                        fmt = this.filter.getFormat(this.filter.getVariableId(i - 1), String.class);
                    }
                } else {
                    fmt = this.filter.getFormat(this.filter.getVariableId(i), String.class);
                }
                if (fmt != null) {
                    this.formatStrings[i] = fmt.toString();
                }
            }
            if (this.formatStrings[i] == null) {
                this.formatStrings[i] = "best8.";
            }
            this.setColumnFormat(i, this.formatStrings[i]);
        }
    }

    public boolean setColumnFormat(int col, String formatStr) {
        Color textColor;
        if (col < 0 || col > this.table.getColumnCount() || formatStr == null) {
            return false;
        }
        boolean numericColumn = false;
        if (this.isObsNumberColumnVisible()) {
            if (col > 0) {
                numericColumn = this.filter.isNumericVariable(col - 1);
            }
        } else {
            numericColumn = this.filter.isNumericVariable(col);
        }
        this.formatStrings[col] = formatStr;
        FormattedCellRenderer renderer = new FormattedCellRenderer(this.formatStrings[col], numericColumn);
        Color color = this.style.getItemColor(0);
        if (color != null) {
            renderer.setBackground(color);
        }
        if ((textColor = this.style.getItemColor(1)) != null) {
            renderer.setForeground(textColor);
        }
        if (this.isObsNumberColumnVisible() && col == 0 && this.style != null && (color = this.style.getItemColor(2)) != null) {
            renderer.setBackground(color);
        }
        TableColumn column = this.table.getColumnModel().getColumn(col);
        column.setCellRenderer(renderer);
        return true;
    }

    private void throwTableModelEvent() {
        TableModelEvent e = new TableModelEvent(this.table.getModel());
        this.table.tableChanged(e);
    }

    public void enableEvents() {
        this.filter.addDataFilterListener((Object)this);
    }

    public void disableEvents() {
        this.filter.removeDataFilterListener((Object)this);
    }

    private void scrollTableToSelectedRow() {
        if (!this.scrollToSelected) {
            return;
        }
        if (this.table == null) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Rectangle visibleRect = this.table.getVisibleRect();
        Rectangle selectedCellRect = this.table.getCellRect(selectedRow, 0, true);
        if (visibleRect.contains(visibleRect.x, selectedCellRect.y)) {
            return;
        }
        Rectangle newVisibleRect = new Rectangle(visibleRect.x, selectedCellRect.y, visibleRect.width, visibleRect.height);
        this.table.scrollRectToVisible(newVisibleRect);
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: {
                this.dataSourceChanged(evt);
                break;
            }
            case 3: {
                this.valueChanged(evt);
                break;
            }
            case 4: {
                this.variableAdded(evt);
                break;
            }
            case 5: {
                this.variableRemoved(evt);
                break;
            }
            case 6: {
                this.formatChanged(evt);
            }
        }
    }

    public void dataSourceChanged(DvrDataFilterEvent evt) {
    }

    public void valueChanged(DvrDataFilterEvent evt) {
        if (this.filter.getNumberObservations(-1) != this.tableSorter.getRowCount() || this.filter.getNumberVariables() != this.lastColCount) {
            this.fullBuild();
        } else {
            this.tableSorter.fireTableDataChanged();
            if (this.tableSorter.getSortColumnIndex() >= 0) {
                this.tableSorter.clearSort();
                this.setUpColumnHeaderRenderers();
                this.repaint();
            }
        }
    }

    private void fullBuild() {
        Filter2TableModel f2tModel = new Filter2TableModel(this.filter);
        f2tModel.setTableEditable(this.editable);
        this.tableSorter.setModel((TableModel)f2tModel);
        this.tableSorter.fireTableStructureChanged();
        this.tableSorter.fireTableDataChanged();
        this.tableSorter.clearSort();
        this.setColumnFormats();
        this.setUpColumnHeaderRenderers();
        this.lastColCount = this.tableSorter.getColumnCount();
        if (this.tableSorter.isObsNumberColumnVisible()) {
            --this.lastColCount;
        }
        this.repaint();
    }

    public void variableAdded(DvrDataFilterEvent evt) {
    }

    public void variableRemoved(DvrDataFilterEvent evt) {
    }

    public void formatChanged(DvrDataFilterEvent evt) {
    }

    @Override
    public int getNumberOfPages() {
        if (!this.pageinfoCalculated) {
            this.getPageInfo(this.getGraphics(), (PageFormat)SILKGlobal.getInstance().getPropertyValue(57));
        }
        return this.totalNumPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return (PageFormat)SILKGlobal.getInstance().getPropertyValue(57);
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        Graphics2D g2 = (Graphics2D)graphics;
        if (!this.pageinfoCalculated) {
            this.getPageInfo(graphics, pageFormat);
        }
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.subTableSplitSize - 1) {
                this.subPageIndex = 0;
            }
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int rowIndex = pageIndex / (this.subTableSplitSize - 1);
        this.printTablePart(g2, pageFormat, rowIndex, this.subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    public void getPageInfo(Graphics g, PageFormat pageFormat) {
        this.subTableSplit = null;
        this.subTableSplitSize = 0;
        this.subPageIndex = 0;
        this.prevPageIndex = 0;
        this.fontHeight = g.getFontMetrics().getHeight();
        this.tableHeader = this.table.getTableHeader();
        this.headerHeight = this.tableHeader.getHeight() + this.table.getRowMargin();
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        this.tableHeight = this.table.getHeight();
        this.rowHeight = this.table.getRowHeight() + this.table.getRowMargin();
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = this.tableHeightOnFullPage / this.rowHeight * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int columns = tableColumnModel.getColumnCount();
        int columnMargin = tableColumnModel.getColumnMargin();
        int[] temp = new int[columns];
        temp[0] = 0;
        int length = 0;
        this.subTableSplitSize = 0;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            int columnWidth = tableColumnModel.getColumn(columnIndex).getWidth();
            if ((double)(length + columnWidth + columnMargin) > this.pageWidth) {
                temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                length = columnWidth;
                ++this.subTableSplitSize;
                continue;
            }
            length += columnWidth + columnMargin;
        }
        if (length > 0) {
            temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
            ++this.subTableSplitSize;
        }
        ++this.subTableSplitSize;
        this.subTableSplit = new int[this.subTableSplitSize];
        for (int i = 0; i < this.subTableSplitSize; ++i) {
            this.subTableSplit[i] = temp[i];
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.subTableSplitSize - 1;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D g2, PageFormat pageFormat, int rowIndex, int columnIndex) {
        String pageNumber = ResourceLoader.getResourceString((Object)this.rb, (String)"JTableComponent.Page.txt", (String)"Page: ") + (rowIndex + 1);
        int pageLeft = this.subTableSplit[columnIndex];
        int pageRight = this.subTableSplit[columnIndex + 1];
        int pageWidth = pageRight - pageLeft;
        g2.drawString(pageNumber, pageWidth / 2 - 35, (int)(this.pageHeight - (double)this.fontHeight));
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        g2.translate(-this.subTableSplit[columnIndex], 0);
        g2.setClip(pageLeft, 0, pageWidth, (int)this.headerHeight);
        this.tableHeader.paint(g2);
        g2.translate(0.0, this.headerHeight);
        g2.translate(0.0, -this.tableHeightOnFullPage * (double)rowIndex);
        g2.setClip(pageLeft, (int)this.tableHeightOnFullPage * rowIndex, pageWidth, (int)clipHeight);
        this.table.paint(g2);
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        g2.drawRect(pageLeft, (int)pageTop, pageWidth, (int)(clipHeight + this.headerHeight));
    }

    private void loadIcons() {
        Image img = ResourceLoader.getImage((Component)this, (String)"icons/ascendingIcon.gif");
        if (img != null) {
            this.ascendingIcon = new ImageIcon(img);
        }
        if ((img = ResourceLoader.getImage((Component)this, (String)"icons/descendingIcon.gif")) != null) {
            this.descendingIcon = new ImageIcon(img);
        }
    }

    private void setUpColumnHeaderRenderers() {
        TableColumnModel columnModel = this.table.getColumnModel();
        int columnCount = this.tableSorter.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            JComponent headerRenderer;
            TableColumn viewColumn = columnModel.getColumn(i);
            if (this.headerWrap) {
                headerRenderer = new HeaderTextPaneRenderer(this.ascendingIcon, this.descendingIcon, null, this, this.tableSorter, this.style);
                viewColumn.setHeaderRenderer((TableCellRenderer)((Object)headerRenderer));
                continue;
            }
            headerRenderer = new ColumnHeaderRenderer(this.ascendingIcon, this.descendingIcon, null, this.table);
            headerRenderer.setStyle(this.style);
            viewColumn.setHeaderRenderer((TableCellRenderer)((Object)headerRenderer));
        }
    }

    @Override
    public void addDrilldownListener(DrilldownListenerInterface dli) {
    }

    @Override
    public void removeDrilldownListener(DrilldownListenerInterface dli) {
    }

    @Override
    public Dialog getDialog(Object id, Object listener) {
        return null;
    }

    @Override
    public boolean setDialog(Object id, Dialog dialogIn, boolean addSelf) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category) {
        return false;
    }

    @Override
    public boolean addTabs(Object id, Dialog dialogIn, int category, Object listener) {
        return false;
    }

    @Override
    public AnnotateInterface getAnnotate() {
        return null;
    }

    @Override
    public boolean areChartTipsOn() {
        return false;
    }

    @Override
    public void setChartTipsOn(boolean on) {
    }

    @Override
    public TipInterface getChartTip() {
        return null;
    }

    @Override
    public String getStyle() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setStyle(Object newStyle) {
        if (newStyle == null) {
            return false;
        }
        if (newStyle instanceof Style) {
            this.graphStyle = (Style)newStyle;
        } else if (newStyle instanceof ColorScheme) {
            this.graphStyle = ((ColorScheme)newStyle).getStyle();
        } else {
            if (!(newStyle instanceof String)) return false;
            StyleCollection sc = (StyleCollection)SILKGlobal.getInstance().getPropertyValue(48);
            if (sc.getStyle((String)newStyle) == null) return false;
            this.graphStyle = sc.getStyle((String)newStyle);
        }
        if (this.graphStyle == null) {
            return false;
        }
        Color backSelection = this.graphStyle.getFillStyleElement("Selection").getFillColor();
        Color backSelectionSoft = ColorUtilities.setSB(backSelection, 0.1, 0.9);
        if (this.table != null) {
            this.table.setBackground(this.graphStyle.getFillStyleElement("TableDataFill").getFillColor());
            this.table.setGridColor(this.graphStyle.getLineStyleElement("TableGridLines").getLineColor());
            this.table.setSelectionBackground(backSelectionSoft);
            if (this.tablePane != null) {
                this.tablePane.getViewport().setBackground(this.graphStyle.getFillStyleElement("TableHeaderFill").getFillColor());
            }
        }
        if (this.style != null) {
            TextStyleElement tableDataStyle = this.graphStyle.getTextStyleElement("TableDataText");
            TextStyleElement tableHeaderStyle = this.graphStyle.getTextStyleElement("TableHeaderText");
            this.style.setItemColor(1, tableDataStyle.getTextColor());
            this.style.setItemColor(0, this.graphStyle.getFillStyleElement("TableDataFill").getFillColor());
            this.style.setItemColor(3, tableHeaderStyle.getTextColor());
            this.style.setItemColor(2, this.graphStyle.getFillStyleElement("TableHeaderFill").getFillColor());
            this.style.setItemColor(4, backSelectionSoft);
            if (this.table != null) {
                this.table.setFont(tableDataStyle.getAdjustedFont());
                if (this.table.getTableHeader() != null) {
                    this.table.getTableHeader().setFont(tableHeaderStyle.getAdjustedFont());
                }
            }
        }
        this.table.tableChanged(new TableModelEvent(this.tableSorter, -1));
        if (this.dataSource == null || this.filter == null) return false;
        this.setColumnFormats();
        this.setUpColumnHeaderRenderers();
        this.synchSortState();
        return false;
    }

    @Override
    public ColorSchemeInterface getColorScheme() {
        return null;
    }

    @Override
    public String getColorSchemeName() {
        return null;
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        return this.setStyle(newScheme);
    }

    @Override
    public DataFilterReadInterface getFilter() {
        return this.filter;
    }

    @Override
    public DataFilterReadInterface getFilter(Object id) {
        return this.getFilter();
    }

    @Override
    public boolean setDataListening(boolean listen) {
        this.listenToEvents = listen;
        if (this.listenToEvents) {
            this.enableEvents();
        } else {
            this.disableEvents();
        }
        return true;
    }

    @Override
    public boolean isDataListening() {
        return false;
    }

    @Override
    public boolean setTitle(int index, TextStyleInterface text) {
        if (index < 0 || text == null) {
            return false;
        }
        this.title.setTitle(index, text);
        this.add((Component)this.title, "North");
        this.validate();
        return true;
    }

    @Override
    public boolean setTitle(int index, String text) {
        if (index < 0 || text == null) {
            return false;
        }
        this.title.setTitle(index, text);
        this.add((Component)this.title, "North");
        this.validate();
        return true;
    }

    public boolean setTitle(String text) {
        return this.setTitle(0, text);
    }

    @Override
    public TextStyleInterface getTitle(int index) {
        return this.title.getTitle(index);
    }

    public TextStyleInterface getTitle() {
        return this.getTitle(0);
    }

    @Override
    public boolean setFootnote(int index, TextStyleInterface text) {
        if (index < 0 || text == null) {
            return false;
        }
        this.footnote.setFootnote(index, text);
        this.add((Component)this.footnote, "South");
        this.validate();
        return true;
    }

    @Override
    public boolean setFootnote(int index, String text) {
        if (index < 0 || text == null) {
            return false;
        }
        this.footnote.setFootnote(index, text);
        this.add((Component)this.footnote, "South");
        this.validate();
        return true;
    }

    public boolean setFootnote(String text) {
        return this.setFootnote(0, text);
    }

    @Override
    public TextStyleInterface getFootnote(int index) {
        return this.footnote.getFootnote(index);
    }

    public TextStyleInterface getFootnote() {
        return this.getFootnote(0);
    }

    @Override
    public void enablePopup(boolean on) {
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public void dispose() {
        SILKGlobal.unregister(this);
        if (this.pendingProperties != null) {
            this.pendingProperties.clear();
        }
        this.pendingProperties = null;
        if (this.filter != null) {
            this.filter.removeDataFilterListener((Object)this);
            this.filter = null;
        }
        if (this.selectionAdapter != null) {
            this.selectionAdapter.removePropertyChangeListener(this);
        }
        if (this.footnote != null) {
            this.footnote.dispose();
        }
        this.footnote = null;
        if (this.title != null) {
            this.title.dispose();
        }
        this.title = null;
        if (this.selectionAdapter != null) {
            this.selectionAdapter.dispose();
        }
        if (this.tableSorter != null) {
            this.tableSorter.dispose();
        }
        this.tableSorter = null;
    }

    @Override
    public boolean applyWhereClause(String whereClause, boolean clear) {
        if (this.filter == null) {
            return false;
        }
        boolean flag = this.filter.applyWhereClause(whereClause, clear);
        this.throwTableModelEvent();
        return flag;
    }

    @Override
    public String getWhereClause() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getWhereClause();
    }

    @Override
    public boolean getUsageMode(int mode) {
        return false;
    }

    @Override
    public void setUsageMode(int mode, boolean on) {
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object idIn) {
        this.id = idIn;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean setEditable(boolean editable) {
        this.editable = editable;
        if (this.f2tModel != null) {
            this.f2tModel.setTableEditable(this.editable);
        }
        return true;
    }

    @Override
    public int getActionMode() {
        return 0;
    }

    @Override
    public boolean setActionMode(int mode) {
        return false;
    }

    @Override
    public Object getChartObject(Object id) {
        return this.getChart(id);
    }

    public Object getChart(Object id) {
        return null;
    }

    @Override
    public boolean isBackBufferDrawEnabled() {
        return false;
    }

    @Override
    public void setBackBufferDrawEnabled(boolean drawback) {
    }

    @Override
    public boolean setActionEnabled(String action, boolean enable) {
        return false;
    }

    @Override
    public boolean isActionEnabled(String action) {
        return true;
    }

    public boolean isPropertySupported(int id) {
        switch (id) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int id) {
        return this.pendingProperties.containsKey(new Integer(id));
    }

    public Object getPropertyValue(int id) {
        switch (id) {
            case 0: {
                if (this.pendingProperties.containsKey(new Integer(id))) {
                    return this.pendingProperties.get(new Integer(id));
                }
                return this.colorScheme;
            }
        }
        return null;
    }

    public boolean setPropertyValue(int id, Object value) {
        if (id == 0 && value != null) {
            this.pendingProperties.put(new Integer(id), value);
            return true;
        }
        return false;
    }

    public int getNumberPendingProperties() {
        return this.pendingProperties.size();
    }

    public boolean applyPropertyChanges() {
        boolean rc = false;
        Set keys = this.pendingProperties.keySet();
        if (keys != null) {
            Iterator i = keys.iterator();
            while (i != null && i.hasNext()) {
                Object pvalue;
                Object id = i.next();
                if (!(id instanceof Number)) continue;
                int pid = ((Number)id).intValue();
                Object value = pvalue = this.pendingProperties.get(id);
                if (pvalue instanceof PropertyEvent) {
                    value = ((PropertyEvent)pvalue).value;
                }
                switch (pid) {
                    case 0: {
                        this.setColorScheme(value);
                        rc = true;
                        break;
                    }
                }
            }
        }
        return rc;
    }

    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    public void cancelPropertyChanges() {
        this.pendingProperties.clear();
    }

    public void cancelPropertyChanges(Object source) {
        this.cancelPropertyChanges();
    }

    public int[] getPendingChanges() {
        return null;
    }

    public int[] getPendingChanges(Object source) {
        return null;
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.table.addMouseListener(listener);
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        super.removeMouseListener(listener);
        this.table.removeMouseListener(listener);
    }

    public boolean isVariableDescriptionUsed() {
        TableModel tm;
        if (this.table != null && this.tableSorter != null && (tm = this.tableSorter.getModel()) instanceof Filter2TableModel) {
            return ((Filter2TableModel)tm).isVariableDescriptionUsed();
        }
        return true;
    }

    public void setUseVariableDescription(boolean useVariableDescription) {
        TableModel tm;
        if (this.table != null && this.tableSorter != null && (tm = this.tableSorter.getModel()) instanceof Filter2TableModel) {
            ((Filter2TableModel)tm).setUseVariableDescription(useVariableDescription);
            this.table.tableChanged(new TableModelEvent(this.tableSorter, -1));
            this.setColumnFormats();
            this.setUpColumnHeaderRenderers();
            this.synchSortState();
        }
    }

    public void setObsNumberColumnVisible(boolean obsNumberColumnVisible) {
        if (this.tableSorter != null) {
            this.tableSorter.setObsNumberColumnVisible(obsNumberColumnVisible);
            this.tableSorter.initializeSortState();
            this.table.tableChanged(new TableModelEvent(this.tableSorter, -1));
            this.setColumnFormats();
            this.setUpColumnHeaderRenderers();
            this.synchSortState();
        }
    }

    public boolean isObsNumberColumnVisible() {
        return this.tableSorter != null && this.tableSorter.isObsNumberColumnVisible();
    }

    public void setObsColumnHeader(String obsHeader) {
        if (this.table != null && this.tableSorter != null) {
            this.tableSorter.setObsColumnHeader(obsHeader);
            this.table.tableChanged(new TableModelEvent(this.tableSorter, -1));
        }
    }

    public String getObsColumnHeader() {
        if (this.tableSorter != null) {
            return this.tableSorter.getObsColumnHeader();
        }
        return null;
    }

    private void synchSortState() {
        if (this.tableSorter == null || this.dataSource == null) {
            return;
        }
        int column = this.tableSorter.getSortColumnIndex();
        this.tableSorter.sortByColumn(this.table, column, this.tableSorter.getAscending(), false);
    }

    public void setSortingEnabled(boolean sortEnabled) {
        if (this.sortEnabled == sortEnabled) {
            return;
        }
        this.sortEnabled = sortEnabled;
        if (this.tableSorter == null || this.table == null) {
            return;
        }
        if (this.sortEnabled) {
            this.tableSorter.addMouseListenerToHeaderInTable(this.table, this.ascendingIcon, this.descendingIcon, null);
        } else {
            this.tableSorter.removeMouseListenerToHeaderInTable(this.table);
        }
    }

    public boolean isSortingEnabled() {
        return this.sortEnabled;
    }

    public boolean isTableScrollingToSelectedCell() {
        return this.scrollToSelected;
    }

    public void setScrollTableToSelectedCell(boolean scrollToSelected) {
        this.scrollToSelected = scrollToSelected;
    }

    public void setHeaderWrap(boolean headerWrap) {
        if (this.headerWrap == headerWrap) {
            return;
        }
        if (this.table == null) {
            return;
        }
        this.headerWrap = headerWrap;
        this.setUpColumnHeaderRenderers();
        this.headerHt = 0;
        this.table.getTableHeader().setSize(this.table.getTableHeader().getWidth(), 0);
        this.revalidate();
        this.repaint();
    }

    public boolean isHeaderWrapped() {
        return this.headerWrap;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DATA_MODEL_SELECTION".equalsIgnoreCase(evt.getPropertyName()) && this.scrollToSelected) {
            this.scrollTableToSelectedRow();
        }
    }

    @Override
    public void setHeaderHeight(int height) {
        if (this.table == null) {
            return;
        }
        JTableHeader jth = this.table.getTableHeader();
        if (jth == null) {
            return;
        }
        boolean heightDiff = height > this.headerHt;
        int curHeight = jth.getHeight();
        this.headerHt = Math.max(Math.max(curHeight, height), this.headerHt);
        if (heightDiff) {
            this.table.getTableHeader().setSize(this.table.getTableHeader().getWidth(), this.headerHt);
            this.revalidate();
            this.repaint();
        }
    }

    public void setColumnGap(int gap) {
        if (this.table != null) {
            this.table.setIntercellSpacing(new Dimension(gap, (int)this.table.getIntercellSpacing().getHeight()));
        }
    }

    public int getColumnGap() {
        Dimension d;
        if (this.table != null && (d = this.table.getIntercellSpacing()) != null) {
            return (int)d.getWidth();
        }
        return 0;
    }

    private class FormattedCellRenderer
    implements TableCellRenderer {
        SASFormat format;
        Color cellBackgroundColor = null;
        Color cellTextColor = null;
        JLabel cellValue = null;

        FormattedCellRenderer(String formatString, boolean numericColumn) {
            if (formatString.compareTo("NONE") != 0) {
                this.format = SASFormat.getInstance((String)formatString);
            }
            if (numericColumn) {
                boolean insertBlanks = true;
                Object o = SILKGlobal.getInstance().getPropertyValue(74);
                if (o instanceof Boolean) {
                    insertBlanks = (Boolean)o;
                }
                this.format.setInsertBlanks(insertBlanks);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String val = null;
            int orientation = 0;
            if (value == null) {
                val = ".";
            } else if (value instanceof Number) {
                val = Double.isNaN(((Number)value).doubleValue()) ? "." : (this.format != null ? this.format.format(value) : value.toString());
                orientation = 4;
            } else {
                String v;
                val = this.format != null && this.format.isCharacterFormat() ? this.format.format((Object)value.toString()) : ((v = value.toString().trim()).length() > 0 ? v : "");
                orientation = 2;
            }
            this.cellValue = new JLabel(val, orientation);
            this.cellValue.setForeground(Color.black);
            this.cellValue.setFont(table.getFont());
            if (table.isCellSelected(row, column)) {
                this.cellValue.setBackground(table.getSelectionBackground());
            } else if (this.cellBackgroundColor != null) {
                this.cellValue.setBackground(this.cellBackgroundColor);
            } else {
                this.cellValue.setBackground(table.getBackground());
            }
            if (this.cellTextColor != null) {
                this.cellValue.setForeground(this.cellTextColor);
            }
            this.cellValue.setOpaque(true);
            return this.cellValue;
        }

        private void setBackground(Color backgroundColor) {
            if (backgroundColor != null) {
                this.cellBackgroundColor = backgroundColor;
            }
        }

        private void setForeground(Color foregroundColor) {
            if (foregroundColor != null) {
                this.cellTextColor = foregroundColor;
            }
        }
    }

    private class FootnoteComponent
    extends JComponent
    implements TextListenerInterface {
        private static final long serialVersionUID = -2333053487664038044L;
        private Footnote ftNote = new Footnote();
        private JComponent parent;
        private int minHeight = 250;

        public FootnoteComponent(JComponent parnt) {
            this.ftNote.addTextListener(this);
            this.parent = parnt;
        }

        public FootnoteComponent(String text) {
            this.ftNote.setFootnote(0, text);
            this.ftNote.addTextListener(this);
        }

        public TextStyleInterface getFootnote(int index) {
            return this.ftNote.getFootnote(index);
        }

        public void setFootnote(int index, String text) {
            this.ftNote.setFootnote(index, text);
            this.ftNote.setComponentBounds(this.parent.getBounds());
            Rectangle ftNoteBounds = this.ftNote.getBounds();
            this.setSize(this.getSize().width, Math.max(ftNoteBounds.height, this.getSize().height));
            this.setPreferredSize(this.getSize());
            this.parent.validate();
        }

        public void setFootnote(int index, TextStyleInterface text) {
            this.ftNote.setFootnote(index, text);
            this.ftNote.setComponentBounds(this.parent.getBounds());
            Rectangle ftNoteBounds = this.ftNote.getBounds();
            this.setSize(this.getSize().width, Math.max(ftNoteBounds.height, this.getSize().height));
            this.setPreferredSize(this.getSize());
            this.parent.validate();
        }

        public void setFootnote(String text) {
            this.ftNote.setFootnote(0, text);
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle r = this.ftNote.getBounds();
            return new Dimension(r.width, r.height);
        }

        @Override
        public void paintComponent(Graphics g) {
            int i;
            Rectangle tableBounds = this.parent.getBounds();
            Rectangle footnoteBounds = new Rectangle(0, 0, tableBounds.width, Math.max(tableBounds.height, this.minHeight));
            this.ftNote.setComponentBounds(footnoteBounds);
            Rectangle ftNoteBounds = this.ftNote.getBounds();
            this.setSize(tableBounds.width, ftNoteBounds.height);
            this.setPreferredSize(this.getSize());
            this.parent.validate();
            int numFootnotes = 5;
            Font[] ftNoteFonts = new Font[numFootnotes];
            for (i = 0; i < numFootnotes; ++i) {
                TextStyleInterface text = this.ftNote.getFootnote(i);
                if (text == null) {
                    numFootnotes = i;
                    break;
                }
                ftNoteFonts[i] = text.getFont();
            }
            this.ftNote.setComponentBounds(0, 0, this.getSize().width, this.getSize().height);
            for (i = 0; i < numFootnotes; ++i) {
                this.ftNote.getFootnote(i).setFont(ftNoteFonts[i]);
            }
            this.ftNote.draw(g, false);
        }

        @Override
        public void textUpdated(DvrTextEvent evt) {
        }

        void dispose() {
            this.ftNote = null;
            this.parent = null;
        }
    }

    private class TitleComponent
    extends JComponent
    implements TextListenerInterface {
        private static final long serialVersionUID = -4365147540053927544L;
        private Title title = new Title();
        private JComponent parent;
        private int minHeight = 250;

        public TitleComponent(JComponent parnt) {
            this.title.addTextListener(this);
            this.parent = parnt;
        }

        public TitleComponent(String text) {
            this.title.setTitle(0, text);
            this.title.addTextListener(this);
        }

        public TextStyleInterface getTitle(int index) {
            return this.title.getTitle(index);
        }

        public void setTitle(int index, String text) {
            this.title.setTitle(index, text);
        }

        public void setTitle(int index, TextStyleInterface text) {
            this.title.setTitle(index, text);
        }

        public void setTitle(String text) {
            this.setTitle(0, text);
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle r = this.title.getBounds();
            return new Dimension(r.width, r.height);
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle tableBounds = this.parent.getBounds();
            Rectangle titleBounds = new Rectangle(0, 0, tableBounds.width, Math.max(tableBounds.height, this.minHeight));
            this.title.setComponentBounds(titleBounds);
            titleBounds = this.title.getBounds();
            this.setSize(this.getSize().width, Math.max(titleBounds.height, this.getSize().height));
            this.setPreferredSize(this.getSize());
            this.parent.validate();
            this.title.draw(g, false);
        }

        @Override
        public void textUpdated(DvrTextEvent evt) {
        }

        void dispose() {
            this.title = null;
            this.parent = null;
        }
    }
}

