/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.histogram.AbstractComponent;
import com.sas.graphics.silk.histogram.HistogramChart;
import com.sas.graphics.silk.histogram.HistogramModel;
import com.sas.graphics.silk.histogram.HistogramPreviewPanel;
import com.sas.graphics.silk.histogram.HistogramPreviewRedrawEvent;
import com.sas.graphics.silk.histogram.HistogramPreviewRedrawListener;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.HistogramComponentInterface;
import com.sas.graphics.silk.interfaces.HistogramInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.DataOptionsDialog;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.HistogramPanel;
import com.sas.graphics.silk.ui.LegendPanel;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.CopyToClipboard;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.xml.SILKParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HistogramComponent
extends AbstractComponent
implements HistogramComponentInterface {
    private static final long serialVersionUID = -8470050272623729424L;
    protected HistogramPreviewPanel previewPanel;
    protected JFrame previewWindow;
    protected HistogramPanel histPanel;
    protected LegendPanel legendPanel;
    protected ResourceBundle histRB = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    protected HistogramComponent instance = this;

    @Override
    protected void createActionComponents() {
        JMenuItem mi = null;
        AbstractAction graph = new AbstractAction(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Popup_Graph_Properties___.txt", (String)"Graph Properties...")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramComponent.this.getPropertyDialog(HistogramComponent.this);
                HistogramComponent.this.propertyDialog.setVisible(true);
            }
        };
        mi = this.popup.add(graph);
        mi.setMnemonic(71);
        JMenu actionMenu = MenuUtilities.getMenu(this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/StandardActionMenu.xml"), (ActionListener)this);
        mi = this.popup.add(actionMenu);
        mi.setMnemonic(89);
        this.popup.addSeparator();
        AbstractAction data = new AbstractAction(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Popup_Data_Options___.txt", (String)"Data Options...")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramComponent.this.getDataDialog();
                HistogramComponent.this.dataDialog.setVisible(true);
            }
        };
        mi = this.popup.add(data);
        mi.setMnemonic(68);
        this.popup.addSeparator();
        AbstractAction copy = new AbstractAction(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Popup_Copy.txt", (String)"Copy")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyToClipboard.toClipboard(HistogramComponent.this.instance);
            }
        };
        mi = this.popup.add(copy);
        mi.setMnemonic(67);
        if (SILKGlobal.isTestMode()) {
            this.popup.addSeparator();
            AbstractAction saveXML = new AbstractAction(ResourceLoader.getResourceString((Object)ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.menus.silk_menus_NLS"), (String)"Popup.Save_As_XML.txt", (String)"Save_As_XML...")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SILKParser.saveAsXML(HistogramComponent.this, null, true);
                }
            };
            mi = this.popup.add(saveXML);
        }
    }

    protected void setShowPreview(boolean show) {
        if (show) {
            if (this.previewWindow != null && this.previewWindow.isShowing()) {
                return;
            }
            if (this.previewWindow == null) {
                this.previewWindow = new JFrame("Histogram Preview");
                this.previewWindow.setSize(300, 200);
                this.previewWindow.setBackground(Color.white);
                this.previewWindow.getContentPane().setLayout(new BorderLayout());
            }
            if (this.previewPanel == null) {
                this.previewPanel = new HistogramPreviewPanel(this);
                this.previewWindow.getContentPane().add(this.previewPanel);
            }
            this.previewWindow.show();
        } else {
            this.previewWindow.hide();
        }
    }

    @Override
    public void setZoomFactor(double fac) {
        if (fac <= this.globalDefaults.zoomLimitParm || fac > 1.0) {
            return;
        }
        this.zoomFactor = fac;
        this.doDataZoom();
        this.brushMode = false;
    }

    @Override
    public HistogramInterface getChart() {
        return (HistogramInterface)this.chart;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        if (which == null) {
            return null;
        }
        if (which instanceof Number && (((Number)which).intValue() == 24 || ((Number)which).intValue() == 1) || which instanceof String && (((String)which).equalsIgnoreCase("X") || ((String)which).equalsIgnoreCase("XAxis"))) {
            return (AxisInterface)this.xAxis;
        }
        if (which instanceof Number && (((Number)which).intValue() == 25 || ((Number)which).intValue() == 17) || which instanceof String && (((String)which).equalsIgnoreCase("Y") || ((String)which).equalsIgnoreCase("YAxis"))) {
            return (AxisInterface)this.yAxis;
        }
        return null;
    }

    @Override
    public Object getWall() {
        return this.wall;
    }

    @Override
    protected void doDataZoom() {
        double rangeX = this.dataXMax - this.dataXMin;
        double rangeY = this.dataYMax - this.dataYMin;
        double midX = (this.dataXMin + this.dataXMax) * 0.5;
        double midY = (this.dataYMin + this.dataYMax) * 0.5;
        this.min[0] = midX - rangeX * 0.5 * this.zoomFactor;
        this.max[0] = midX + rangeX * 0.5 * this.zoomFactor;
        if (((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram()) {
            this.min[1] = midY - rangeY * 0.5 * this.zoomFactor;
            this.max[1] = midY + rangeY * 0.5 * this.zoomFactor;
        }
        ((HistogramChart)this.chart).setBoundingBox(this.min[0], this.min[1], 0.0, this.max[0], this.max[1], 0.0);
        this.viewportXMin = this.min[0];
        this.viewportXMax = this.max[0];
        this.viewportYMin = this.min[1];
        this.viewportYMax = this.max[1];
        double[] rubber = new double[]{this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]};
        HistogramPreviewRedrawEvent e = new HistogramPreviewRedrawEvent(this);
        e.newRubberband = rubber;
        e.type = 2;
        this.firePreviewRedrawEvent(e);
    }

    @Override
    protected int getRubberbandingDirection() {
        if (((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram() || this.dataYMin < 0.0) {
            return 3;
        }
        return 1;
    }

    @Override
    protected double[] getMinimumViewportRange() {
        double[] range = new double[2];
        int dir = this.getRubberbandingDirection();
        if (dir == 3) {
            range[0] = ((HistogramChart)this.chart).getXBinWidth();
            range[1] = ((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram() ? ((HistogramChart)this.chart).getYBinWidth() : 0.05 * (this.dataYMax - this.dataYMin);
        } else {
            range[0] = ((HistogramChart)this.chart).getXBinWidth();
            range[1] = 0.05 * (this.dataYMax - this.dataYMin);
        }
        return range;
    }

    @Override
    protected void setColorsToChart() {
        if (this.chart == null) {
            return;
        }
        ((HistogramChart)this.chart).setStyle(this.colorScheme.getStyle());
        ((HistogramChart)this.chart).setOutlineColor(this.colorScheme.getColorSchemeItemColor(6));
        ((HistogramChart)this.chart).setSelectionColor(this.colorScheme.getColorSchemeItemColor(8));
        ((HistogramChart)this.chart).setChartBorderColor(this.colorScheme.getColorSchemeItemColor(2));
        ((HistogramChart)this.chart).setBarColor(this.colorScheme.getDataColors(false, false)[0]);
        ((HistogramChart)this.chart).setColorRamp(this.colorRamp);
        ((HistogramChart)this.chart).setDataColor(this.colorScheme.getDataColors(false, false), this.colorScheme.getDataColors(false, true));
        ((HistogramChart)this.chart).setDensityCurveColor(this.colorScheme.getDataColors(false, true)[1]);
    }

    @Override
    protected void updateChartBoundingBox() {
        if (!this.userSetOuterMargin) {
            this.chartMargin = ((HistogramChart)this.chart).getOuterMargin((Graphics2D)this.getGraphics());
            this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
            this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
            this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
            this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        }
        this.updateChartClipArea();
        ((HistogramChart)this.chart).setChartClipArea(this.chartClipRect);
        this.chartBBox = ((HistogramChart)this.chart).getBoundingBox();
        if (this.chartBBox == null) {
            return;
        }
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setOffset(0, 0);
            ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setOffset(0, 0);
            ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
    }

    @Override
    protected void adjustBoundingBox() {
        if (this.chart == null || (this.chartBBox = ((HistogramChart)this.chart).getBoundingBox()) == null) {
            return;
        }
        if (this.chartBBox != null && ((HistogramChart)this.chart).setChartClipArea(this.chartClipRect) && this.xAxis != null && this.yAxis != null) {
            this.min[1] = this.dataYMin;
            this.max[1] = this.dataYMax;
            ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            double[] bbox = new double[]{this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0};
            HistogramPreviewRedrawEvent e = new HistogramPreviewRedrawEvent(this);
            e.newChartBoundingBox = bbox;
            e.chart = (HistogramChart)this.chart;
            e.type = 1;
            this.firePreviewRedrawEvent(e);
            double[] rubber = new double[]{this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]};
            e.newRubberband = rubber;
            e.type = 2;
            this.firePreviewRedrawEvent(e);
        }
    }

    @Override
    protected String getToolTipText(int x, int y) {
        String toolTipText = null;
        if (this.warningIcon.isMouseOverIcon(x, y)) {
            return this.warningIcon.getTooltipText();
        }
        if (toolTipText == null && this.xAxis != null) {
            toolTipText = ((Axes)this.xAxis).getToolTipText(x, y);
        }
        if (toolTipText == null && this.yAxis != null) {
            toolTipText = ((Axes)this.yAxis).getToolTipText(x, y);
        }
        if (toolTipText == null && this.chartClipRect.contains(x, y) && this.chart != null) {
            toolTipText = ((HistogramChart)this.chart).getToolTipText(x, y);
        }
        return toolTipText;
    }

    @Override
    protected boolean createChartElements(Object source, Object id) {
        if (this.chart == null) {
            this.chart = new HistogramChart();
        }
        if (this.chart != null) {
            ((HistogramChart)this.chart).setGraphicContent((Graphics2D)this.getGraphics());
            ((HistogramChart)this.chart).setDataSource(source, id);
            ((HistogramChart)this.chart).setTransformObject(this);
            ((HistogramChart)this.chart).addRedrawListener(this);
            this.setColorsToChart();
        }
        DataFilterReadInterface dataOut = null;
        if (source instanceof HistogramModel) {
            HistogramModel histModel = (HistogramModel)source;
            dataOut = (DataFilterReadInterface)histModel.getDataSource();
        }
        if (this.xAxis == null) {
            this.xAxis = new Axes(dataOut);
        }
        if (this.xAxis != null) {
            ((Axes)this.xAxis).setTransformObject(this);
            ((Axes)this.xAxis).addRedrawListener(this);
            ((Axes)this.xAxis).setDimension(1);
            this.setColorsToAxis(true);
            ((Axes)this.xAxis).setChartTip(this.toolTip);
        }
        if (this.yAxis == null) {
            this.yAxis = new Axes(dataOut);
        }
        if (this.yAxis != null) {
            ((Axes)this.yAxis).setTransformObject(this);
            ((Axes)this.yAxis).addRedrawListener(this);
            ((Axes)this.yAxis).setDimension(2);
            this.setColorsToAxis(false);
            ((Axes)this.yAxis).setChartTip(this.toolTip);
        }
        if (this.legend == null) {
            this.legend = new LegendObjectJ2D();
            this.legend.setVisible(true);
            this.addMouseListener((LegendObjectJ2D)this.legend);
            this.addMouseMotionListener((LegendObjectJ2D)this.legend);
            this.setColorsToLegend();
        }
        if (this.chart != null) {
            if (((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram()) {
                ((Axes)this.xAxis).setGridLines(Boolean.TRUE);
                ((Axes)this.yAxis).setGridLines(Boolean.TRUE);
            } else {
                ((Axes)this.xAxis).setGridLines(Boolean.FALSE);
                ((Axes)this.yAxis).setGridLines(Boolean.TRUE);
            }
            ((HistogramChart)this.chart).setXAxis((Axes)this.xAxis);
            ((HistogramChart)this.chart).setYAxis((Axes)this.yAxis);
            ((HistogramChart)this.chart).setLegend(this.legend);
        }
        this.warningIcon.removeAllZoomPanHandlers();
        if (this.xHandler == null) {
            this.xHandler = new AxisZoomPanHandler((Axes)this.xAxis);
            if (this.xHandler != null) {
                this.warningIcon.addZoomPanHandler(this.xHandler);
                this.xHandler.addViewportListener(this);
                this.addViewportListener(this.xHandler);
            }
        }
        if (this.yHandler == null) {
            this.yHandler = new AxisZoomPanHandler((Axes)this.yAxis);
            if (this.yHandler != null) {
                this.warningIcon.addZoomPanHandler(this.yHandler);
                this.yHandler.addViewportListener(this);
                this.addViewportListener(this.yHandler);
            }
        }
        return true;
    }

    @Override
    protected void buildOtherElements(Object buildData) {
        if (this.updatePanels) {
            if (this.propertyDialog != null && this.propertyDialog.getActivePanel() instanceof HistogramPanel) {
                this.histPanel.setInitialValues();
            }
            this.updatePanels = false;
        }
    }

    @Override
    protected boolean isTooManyBars() {
        if (this.chart == null) {
            return false;
        }
        if (((HistogramChart)this.chart).getHistogramModel() == null) {
            return false;
        }
        return ((HistogramChart)this.chart).getHistogramModel().isOutOfMemory();
    }

    @Override
    protected void updateRubberbandInPreview(double[] rubber) {
        HistogramPreviewRedrawEvent hpre = new HistogramPreviewRedrawEvent(this);
        hpre.newRubberband = rubber;
        hpre.type = 2;
        this.firePreviewRedrawEvent(hpre);
    }

    @Override
    protected void syncPreviewPanel() {
        HistogramPreviewRedrawEvent e;
        if (this.syncPreview) {
            e = new HistogramPreviewRedrawEvent(this);
            e.newChartBoundingBox = this.chartBBox;
            e.chart = (HistogramChart)this.chart;
            e.type = 1;
            this.firePreviewRedrawEvent(e);
            this.syncPreview = false;
        }
        if (this.redrawPreview) {
            e = new HistogramPreviewRedrawEvent(this);
            e.type = 3;
            this.firePreviewRedrawEvent(e);
            this.redrawPreview = false;
        }
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
        this.chartInnerMargin = null;
        this.fireMarginChangeEvent(false, true);
        if (e.newBoundingBox != null) {
            if (e.getSource() == this.chart) {
                this.chartBBox = e.newBoundingBox;
            } else if (e.getSource() == this.yAxis) {
                this.chartBBox[1] = e.newBoundingBox[1];
                this.chartBBox[4] = e.newBoundingBox[4];
                this.dataYMin = this.chartBBox[1];
                this.dataYMax = this.chartBBox[4];
                if (((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram()) {
                    this.min[1] = Math.max(this.min[1], this.dataYMin);
                    this.max[1] = Math.min(this.max[1], this.dataYMax);
                } else {
                    this.min[1] = this.dataYMin;
                    this.max[1] = this.dataYMax;
                }
            } else if (e.getSource() == this.xAxis) {
                this.chartBBox[0] = e.newBoundingBox[0];
                this.chartBBox[3] = e.newBoundingBox[3];
                this.dataXMin = this.chartBBox[0];
                this.dataXMax = this.chartBBox[3];
                this.min[0] = Math.max(this.min[0], this.dataXMin);
                this.max[0] = Math.min(this.max[0], this.dataXMax);
            }
            if (this.xAxis != null) {
                ((Axes)this.xAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            }
            if (this.yAxis != null) {
                ((Axes)this.yAxis).setFireEvent(false);
                if (!((HistogramChart)this.chart).getHistogramModel().isBivariateHistogram()) {
                    double yDiff = this.dataYMax - this.chartBBox[4];
                    double offset = ((HistogramChart)this.chart).getResponseAxisTickmarkOffset();
                    double yOffset = yDiff < offset ? offset - yDiff : 0.0;
                    ((Axes)this.yAxis).setAxis(new Double(this.chartBBox[1]), new Double(this.chartBBox[4] - yOffset), -1, 0, null, new Boolean(true), null);
                } else {
                    ((Axes)this.yAxis).setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
                }
                ((Axes)this.yAxis).setFireEvent(true);
            }
            if (e.getSource() != this.chart) {
                double[] bbox = new double[]{this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0};
                HistogramPreviewRedrawEvent e2 = new HistogramPreviewRedrawEvent(this);
                e2.newChartBoundingBox = bbox;
                e2.type = 1;
                this.firePreviewRedrawEvent(e2);
                double[] rubber = new double[]{this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]};
                e2.newRubberband = rubber;
                e2.type = 2;
                this.firePreviewRedrawEvent(e2);
            }
            this.redrawBKBuffer = true;
            this.repaint();
        }
    }

    protected void firePreviewRedrawEvent(HistogramPreviewRedrawEvent e) {
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            HistogramPreviewRedrawListener listener = (HistogramPreviewRedrawListener)this.redrawListener.elementAt(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                }
                case 1: {
                    listener.chartChanged(e);
                    continue block4;
                }
                case 2: {
                    listener.rubberbandChanged(e);
                }
            }
        }
    }

    public void addHistogramPreviewRedrawListener(HistogramPreviewRedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.addElement(listener);
            if (this.chartBBox != null) {
                ((HistogramPreviewPanel)listener).setChartBoundingBox(this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0);
                ((HistogramPreviewPanel)listener).setRubberbandBoundingBox(this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]);
            }
        }
    }

    public void removeHistogramPreviewRedrawListener(HistogramPreviewRedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.removeElement(listener);
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    protected Frame getParentFrame(Container con) {
        Container parentFrame;
        for (parentFrame = con; parentFrame != null && !(parentFrame instanceof Frame); parentFrame = parentFrame.getParent()) {
        }
        return (Frame)parentFrame;
    }

    @Override
    protected TabbedPropertiesDialog getPropertyDialog(PropertyInterface p) {
        PropertyInterface p1 = null;
        JComponent comp = null;
        if (p != null) {
            p1 = p;
            if (p instanceof JComponent) {
                comp = (JComponent)p;
            }
        } else {
            p1 = this;
            comp = this;
        }
        if (this.propertyDialog == null) {
            this.propertyDialog = new TabbedPropertiesDialog(this.getParentFrame(this.getParent()), comp, ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Graph_Properties_Title.txt", (String)"Histogram Properties"));
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Graph_Panel_Title.txt", (String)"Graph"), new GraphPanel(p1, this.toolTip));
            this.histPanel = new HistogramPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Bin_Panel_Title.txt", (String)"Bin"), this.histPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Axis_Panel_Title.txt", (String)"Axis"), new AxisPanel(p1, p1));
            this.legendPanel = new LegendPanel(p1);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.Legend_Panel_Title.txt", (String)"Legend"), this.legendPanel);
            this.propertyDialog.addTab(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.TitleAndFootnote_Panel_Title.txt", (String)"Title/Footnote"), new TitlePanel(p1, comp));
            this.propertyDialog.setActiveTab(1);
        }
        return this.propertyDialog;
    }

    @Override
    protected DataOptionsDialog getDataDialog() {
        if (this.dataDialog == null) {
            this.dataDialog = new DataOptionsDialog(this, this, this.getParentFrame(this.getParent()));
        }
        return this.dataDialog;
    }

    @Override
    public Component getToolBar() {
        if (this.toolbar == null && !this.userSetToolbar) {
            this.toolbar = new SILKToolbar(this.getParentFrame(this.getParent()));
            ((SILKToolbar)this.toolbar).addListener(this);
            ((SILKToolbar)this.toolbar).setTitle(ResourceLoader.getResourceString((Object)this.histRB, (String)"HistogramComponent.HistogramToolbar.txt", (String)"Histogram Toolbar"));
        }
        return this.toolbar;
    }

    @Override
    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        if (range == null) {
            return;
        }
        HistogramChart ch = (HistogramChart)this.chart;
        HistogramModel histModel = ch.getHistogramModel();
        if (dim == 1) {
            if (range instanceof ContinuousRange) {
                ContinuousRange cr = new ContinuousRange(range);
                histModel.setMinimumData("X", cr.getMin());
                histModel.setMaximumData("X", cr.getMax());
            } else {
                DiscreteRange cr = new DiscreteRange(range);
                Object[] obj = new Object[cr.getValuesSize()];
                Enumeration enum1 = cr.getEnumeration();
                int i = 0;
                while (enum1.hasMoreElements()) {
                    obj[i] = enum1.nextElement();
                    ++i;
                }
                histModel.setXBinNames(obj, true);
            }
            ch.setDataChange();
            ch.setDataPrepare();
            this.build("X");
        } else if (dim == 2) {
            if (range instanceof ContinuousRange) {
                ContinuousRange cr = new ContinuousRange(range);
                if (!histModel.isBivariateHistogram()) {
                    ((Axes)this.yAxis).setAxis(new Double(cr.getMin()), new Double(cr.getMax()), -1, -1, null, new Boolean(true), null);
                    ch.setDataChange();
                    this.build("Y");
                } else {
                    histModel.setMinimumData("Y", cr.getMin());
                    histModel.setMaximumData("Y", cr.getMax());
                    ch.setDataChange();
                    ch.setDataPrepare();
                    this.build("Y");
                }
            } else {
                DiscreteRange cr = new DiscreteRange(range);
                Object[] obj = new Object[cr.getValuesSize()];
                Enumeration enum1 = cr.getEnumeration();
                int i = 0;
                while (enum1.hasMoreElements()) {
                    obj[i] = enum1.nextElement();
                    ++i;
                }
                histModel.setYBinNames(obj, true);
                ch.setDataChange();
                ch.setDataPrepare();
                this.build("Y");
            }
        }
    }

    public DataRange getDataRange(byte dim) {
        HashMap binNames;
        boolean numericAxis;
        if (this.error == 1) {
            return null;
        }
        HistogramChart ch = (HistogramChart)this.chart;
        HistogramModel histModel = ch.getHistogramModel();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        Object vRole = ch.getRole(new Integer(dim == 1 ? -3 : -4));
        Object var1 = histModel.getVariable(vRole);
        boolean bl = numericAxis = var1 != null && this.dataFilter.isNumericVariable(var1) && !this.isDiscrete(vRole);
        if (numericAxis || var1 == null) {
            Object val = histModel.getRoleValue(vRole, 0);
            if (val != null) {
                double d = min = histModel.isBivariateHistogram() || dim == 1 ? ((Number)val).doubleValue() : Math.min(0.0, ((Number)val).doubleValue());
            }
            if ((val = histModel.getRoleValue(vRole, 1)) != null) {
                max = ((Number)val).doubleValue();
            }
            if (min != Double.MAX_VALUE && max != Double.MIN_VALUE) {
                return new ContinuousRange(min, max);
            }
        } else if (dim == 1) {
            HashMap binNames2 = ch.getBinNames("X");
            if (binNames2 != null) {
                return new DiscreteRange(binNames2.keySet().toArray());
            }
        } else if (dim == 2 && (binNames = ch.getBinNames("Y")) != null) {
            return new DiscreteRange(binNames.keySet().toArray());
        }
        return null;
    }

    @Override
    public Insets getPreferredInnerMargin() {
        HistogramChart ch = (HistogramChart)this.chart;
        return ch.getInnerMargin();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.getChart() != null) {
            ((HistogramChart)this.getChart()).setGraphicContent((Graphics2D)this.getGraphics());
        }
    }

    @Override
    protected boolean isDiscreteAxis(String which) {
        if (which.equalsIgnoreCase("XAXIS")) {
            return !this.dataFilter.isNumericVariable(this.getVariable("X")) || this.isDiscrete("X");
        }
        if (((Boolean)((Axes)this.yAxis).getPropertyValue(241)).booleanValue()) {
            return !this.dataFilter.isNumericVariable(this.getVariable("Y")) || this.isDiscrete("Y");
        }
        return false;
    }

    public void setBinRange(Object role, double low, double high, double stride) {
        HistogramChart ch = (HistogramChart)this.chart;
        HistogramModel histModel = ch.getHistogramModel();
        Roles ROLES = Roles.getInstance(null);
        if (role != null && role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(ROLES.getRoleObject("ROLE_X").toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            int num = (int)Math.round((high - low) / stride);
            histModel.setMinimumData("X", low);
            histModel.setMaximumData("X", low + (double)num * stride);
            histModel.setNumberXBins(num);
        }
    }

    public void setRebinOnZoom(boolean rebin) {
        if (this.chart != null && this.chart instanceof HistogramChart) {
            ((HistogramChart)this.chart).setRebinOnZoom(rebin);
        }
    }

    public void setXBinNames(Object[] values) {
        HistogramChart ch = (HistogramChart)this.chart;
        HistogramModel histModel = ch.getHistogramModel();
        histModel.setXBinNames(values);
    }

    public void setYBinNames(Object[] values) {
        HistogramChart ch = (HistogramChart)this.chart;
        HistogramModel histModel = ch.getHistogramModel();
        histModel.setYBinNames(values);
    }

    @Override
    public Object getDataSource(Object id) {
        if (this.dataFilter == null) {
            return null;
        }
        return this.dataFilter.getSource();
    }

    @Override
    public Object getDataSource() {
        return this.getDataSource(null);
    }
}

