/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.applets.statgraph.sgchart.grid.CellItemInterface;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginListener;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRangeInterface;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangeListener;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.boxplot.BoxPlotChart;
import com.sas.graphics.silk.boxplot.BoxPlotModel;
import com.sas.graphics.silk.event.DvrTextEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.event.TextListenerInterface;
import com.sas.graphics.silk.event.ViewportEvent;
import com.sas.graphics.silk.event.ViewportListenerInterface;
import com.sas.graphics.silk.interfaces.AxisInterface;
import com.sas.graphics.silk.interfaces.GraphPropertyInterface;
import com.sas.graphics.silk.interfaces.GraphToolbarInterface;
import com.sas.graphics.silk.interfaces.LegendInterface;
import com.sas.graphics.silk.interfaces.PrintInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.interfaces.ViewportInterface;
import com.sas.graphics.silk.ui.AxisPanel;
import com.sas.graphics.silk.ui.BoxPlotBoxPanel;
import com.sas.graphics.silk.ui.GraphPanel;
import com.sas.graphics.silk.ui.GraphPropertiesDialog;
import com.sas.graphics.silk.ui.SILKToolbar;
import com.sas.graphics.silk.ui.TitlePanel;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.AxisZoomPanHandler;
import com.sas.graphics.silk.util.ColorScheme;
import com.sas.graphics.silk.util.GraphBackground;
import com.sas.graphics.silk.util.LegendObjectJ2D;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.ViewportWarningIcon;
import com.sas.graphics.util.PropertyEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class BoxPlotComponent
extends SILKComponent
implements UpdateInterface,
TransformInterface,
PrintInterface,
Printable,
RedrawListener,
TextListenerInterface,
CellItemInterface,
DataRangeInterface,
PropertyInterface,
GraphPropertyInterface,
ViewportInterface,
ViewportListenerInterface {
    private static final long serialVersionUID = 8420876407570202591L;
    protected static final int BORDER = 5;
    protected static final int MIN_WIDTH = 1;
    protected static final int MIN_HEIGHT = 1;
    protected static final int ERROR_DATA = 1;
    protected static final int ERROR_SPACE = 2;
    protected static final int ERROR_NO_DATA = 4;
    protected static final int NONE = 0;
    protected static final int MOVE = 1;
    protected static final int RESIZE_L = 2;
    protected static final int RESIZE_R = 3;
    protected static final int RESIZE_T = 4;
    protected static final int RESIZE_B = 5;
    protected static final int RESIZE_TL = 6;
    protected static final int RESIZE_TR = 7;
    protected static final int RESIZE_BL = 8;
    protected static final int RESIZE_BR = 9;
    protected static final int MIN_SIZE = 4;
    protected static final int HANDLE_SIZE = 6;
    protected static final int DIRECTION_X = 1;
    protected static final int DIRECTION_Y = 2;
    protected static final int DIRECTION_XY = 3;
    protected static final int X_AXIS = 1;
    protected static final int Y_AXIS = 2;
    protected static final int GROUP_AXIS = 3;
    protected int viewportX = 0;
    protected int viewportY = 0;
    protected int viewportWidth;
    protected int viewportHeight;
    protected Rectangle chartClipRect;
    protected double[] chartBBox = null;
    protected double dataXMin;
    protected double dataXMax;
    protected double dataYMin;
    protected double dataYMax;
    protected Insets chartOuterMargin;
    protected Insets compMargin;
    protected Insets chartMargin;
    protected Insets chartInnerMargin = null;
    protected boolean userSetOuterMargin = false;
    protected Image backBuffer = null;
    protected Image backBuffer2 = null;
    protected Image backImage = null;
    protected BoxPlotChart chart = null;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected Axes groupAxis = null;
    protected LegendObjectJ2D legend = null;
    protected int legendPosition = 2;
    protected Rectangle legendBounds = null;
    protected boolean wallOn = true;
    protected GraphBackground wall;
    protected Rectangle2D.Double rubberband = null;
    protected Color brushColor;
    protected Point startPt;
    protected boolean rectSelection = false;
    protected double zoomFactor = 1.0;
    protected int error = 0;
    protected boolean brushMode = false;
    protected int brushAction;
    protected Rectangle2D.Double resizeL;
    protected Rectangle2D.Double resizeR;
    protected Rectangle2D.Double resizeT;
    protected Rectangle2D.Double resizeB;
    protected Rectangle2D.Double resizeTL;
    protected Rectangle2D.Double resizeTR;
    protected Rectangle2D.Double resizeBL;
    protected Rectangle2D.Double resizeBR;
    protected boolean redrawBKBuffer = true;
    protected boolean mouseAction = false;
    protected boolean updateComp = true;
    protected Cursor openMoveCursor;
    protected Cursor closeMoveCursor;
    protected Image openMoveImage;
    protected Image closeMoveImage;
    protected JPopupMenu popup;
    protected boolean addPanels;
    protected Action tBar;
    protected boolean userSetToolbar;
    protected ArrayList marginListeners;
    protected ArrayList rangeListeners;
    protected boolean updatePanels;
    protected ArrayList propertyIndex = new ArrayList();
    protected ArrayList propertyValue = new ArrayList();
    protected int selectedAxis;
    protected boolean applyingChanges;
    protected boolean hScrollbarOn;
    protected boolean vScrollbarOn;
    protected double viewportXMin;
    protected double viewportXMax;
    protected double viewportYMin;
    protected double viewportYMax;
    protected BoxPlotComponent instance = null;
    protected boolean sbarAreaTooSmall;
    protected int vBarRightMargin;
    protected ArrayList viewportListeners;
    protected Graphics gc;
    protected boolean xReverse = false;
    protected boolean yReverse = false;
    protected AxisZoomPanHandler xHandler;
    protected AxisZoomPanHandler yHandler;
    protected ViewportWarningIcon warningIcon;
    protected boolean mouseOnXAxis;
    protected boolean mouseOnYAxis;
    protected boolean panning = false;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.silk_NLS");
    public static int[] supportedProperties = new int[]{26, 0, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 32, 33, 34, 443, 402, 604, 605, 606, 607, 608, 601, 609, 610, 602, 611, 612, 603, 238};
    private Object id = null;

    public BoxPlotComponent() {
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        this.chartClipRect = new Rectangle(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.chartOuterMargin = new Insets(0, 0, 0, 0);
        this.compMargin = new Insets(0, 0, 0, 0);
        this.chartMargin = new Insets(0, 0, 0, 0);
        this.brushColor = Color.black;
        this.wall = new GraphBackground(this);
        this.openMoveImage = ResourceLoader.getImage((Component)this, (String)"icons/MoveOpen.gif");
        this.closeMoveImage = ResourceLoader.getImage((Component)this, (String)"icons/MoveClosed.gif");
        this.setDoubleBuffered(false);
        this.popup = null;
        this.addPanels = false;
        this.userSetToolbar = false;
        this.actionMode = 1;
        this.marginListeners = new ArrayList();
        this.rangeListeners = new ArrayList();
        this.selectedAxis = 0;
        this.updatePanels = false;
        this.applyingChanges = false;
        this.viewportListeners = new ArrayList();
        this.hScrollbarOn = true;
        this.vScrollbarOn = true;
        this.instance = this;
        this.setColorScheme(SILKGlobal.getInstance().getPropertyValue(0));
        this.userSetProperties.appendProperties(supportedProperties);
    }

    @Override
    protected void handleMenuCommand(String command) {
        if ("CHART_TYPE_HORIZONTAL".equalsIgnoreCase(command)) {
            this.getChart().setOrientation(1);
        } else if ("CHART_TYPE_VERTICAL".equalsIgnoreCase(command)) {
            this.getChart().setOrientation(0);
        } else {
            super.handleMenuCommand(command);
        }
    }

    @Override
    protected void buildPropertiesDialog(Object listner) {
        if (this.propertiesDialog != null) {
            return;
        }
        this.getPropertyDialog();
    }

    protected GraphPropertiesDialog getPropertyDialog() {
        this.createPropertyDialog(this);
        this.propertiesDialog.addRootNode(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.Graph.txt", (String)"Graph"), new GraphPanel(this, this.tooltip));
        this.propertiesDialog.addRootNode(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.Box.txt", (String)"Box"), new BoxPlotBoxPanel(this.chart));
        this.propertiesDialog.addRootNode(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.Axis.txt", (String)"Axis"), new AxisPanel(this, this));
        this.propertiesDialog.addRootNode(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.TitleFootnote.txt", (String)"Title/Footnote"), new TitlePanel(this, this));
        this.propertiesDialog.setSelectedNode(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.Box.txt", (String)"Box"));
        this.propertiesDialog.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.BoxPlotPropertiesDialogTitle.txt", (String)"Box Plot Properties"));
        this.addPanels = true;
        return this.propertiesDialog;
    }

    public void printComponent() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(job.defaultPage());
        job.setPrintable(this, pf);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected Insets getComponentMargin() {
        Insets margin = new Insets(this.yMargin, this.xMargin, this.yMargin, this.xMargin);
        margin.top += this.getTitleHeight();
        margin.bottom += this.getFootnoteHeight();
        if (this.legend != null && this.legend.isVisible()) {
            Dimension d = this.legend.getPreferredSize();
            if (d.width > 0 && d.height > 0) {
                switch (this.legendPosition) {
                    case 2: {
                        margin.bottom += d.height + 5;
                        break;
                    }
                    case 1: {
                        margin.top += d.height + 5;
                        break;
                    }
                    case 3: {
                        margin.right += d.width + 5;
                        break;
                    }
                    case 4: {
                        margin.left += d.width + 5;
                    }
                }
            }
        }
        return margin;
    }

    protected int getTitleHeight() {
        int h = 0;
        if (this.graphLayout.getTitle() != null) {
            Rectangle r = this.graphLayout.getTitle().getBounds();
            h = r.height;
        }
        return h;
    }

    protected int getFootnoteHeight() {
        int h = 0;
        if (this.graphLayout.getFootnote() != null) {
            Rectangle r = this.graphLayout.getFootnote().getBounds();
            h += r.height;
        }
        return h;
    }

    protected void setColorsToChart() {
        if (this.chart == null) {
            return;
        }
        Color outlineColor = this.style.getLineStyleElement("Outlines").getLineColor();
        this.chart.setOutlineColor(outlineColor);
        this.chart.setMedianColor(outlineColor);
        this.chart.setMarkerColor(outlineColor);
        this.chart.setWhiskerColor(outlineColor);
        this.chart.setCapColor(outlineColor);
        this.chart.setMeanColor(outlineColor);
        this.chart.setLineColor(outlineColor);
        this.chart.setFillColor(this.style.getDataStyleElement("GraphDataStyle1").getFillColor());
        this.chart.setSelectionColor(this.style.getFillStyleElement("Selection").getFillColor());
        this.chart.setChartBorderColor(this.style.getLineStyleElement("BorderLines").getLineColor());
        this.chart.setStyle(this.style);
    }

    protected void setColorsToAxis(int type) {
        Axes axis = null;
        if (type == 1) {
            axis = this.xAxis;
        } else if (type == 2) {
            axis = this.yAxis;
        } else if (type == 3) {
            axis = this.groupAxis;
        }
        if (axis == null) {
            return;
        }
        axis.applyStyle(this.style);
    }

    protected void setColorsToLegend() {
        if (this.legend == null) {
            return;
        }
        this.legend.applyStyle(this.style);
    }

    protected void updateChartOuterMargin() {
        this.chartMargin = this.chart.getOuterMargin((Graphics2D)this.gc);
        this.compMargin = this.getComponentMargin();
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
    }

    protected boolean updateChartClipArea() {
        boolean imce;
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        this.error = w < 1 || h < 1 ? (this.error |= 2) : (this.error &= 0xFFFFFFFD);
        Rectangle newRect = new Rectangle(xo, yo, w, h);
        boolean omce = !this.chartClipRect.equals(newRect);
        boolean bl = imce = this.chartClipRect.width != newRect.width || this.chartClipRect.height != newRect.height;
        if (imce) {
            this.chartInnerMargin = null;
        }
        if (this.brushMode && this.rubberband != null) {
            double wRatio = (double)newRect.width / (double)this.chartClipRect.width;
            double hRatio = (double)newRect.height / (double)this.chartClipRect.height;
            this.rubberband.x = (double)newRect.x + (this.rubberband.x - (double)this.chartClipRect.x) * wRatio;
            this.rubberband.y = (double)newRect.y + (this.rubberband.y - (double)this.chartClipRect.y) * hRatio;
            this.rubberband.width *= wRatio;
            this.rubberband.height *= hRatio;
            this.createHandleRects();
        }
        this.chartClipRect.setRect(newRect);
        this.chart.setChartClipArea(this.chartClipRect);
        this.chartBBox = this.chart.getBoundingBox();
        if (this.chartBBox == null) {
            return false;
        }
        if (this.xAxis != null) {
            this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null) {
            this.setGroupAxisScreenArea();
        }
        this.fireMarginChangeEvent(imce, omce);
        return true;
    }

    public void updateComponent() {
        if (this.getFilter() == null || this.getVariable(BoxPlotModel.Y_ROLE_NAME) == null || this.getVariable(BoxPlotModel.X_ROLE_NAME) == null || this.getVariable(BoxPlotModel.STAT_ROLE_NAME) == null) {
            return;
        }
        Dimension d = new Dimension(this.compWidth, this.compHeight);
        this.chart.setChartAreaDimension(d);
        this.updateChartOuterMargin();
        this.updateChartClipArea();
        this.graphLayout.doLayout(this);
        this.updateComp = false;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.resizeComponent(width, height);
    }

    protected void resizeComponent(int width, int height) {
        this.compWidth = width;
        this.compHeight = height;
        if (this.useBackBuffer) {
            if (this.backBuffer == null || width > this.backBuffer.getWidth(this) || height > this.backBuffer.getHeight(this)) {
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                }
                this.backBuffer = SILKUtilities.createCompatibleImage((int)width, (int)height, (int)3);
            }
            if (this.backBuffer2 == null || width > this.backBuffer2.getWidth(this) || height > this.backBuffer2.getHeight(this)) {
                if (this.backBuffer2 != null) {
                    this.backBuffer2.flush();
                }
                this.backBuffer2 = SILKUtilities.createCompatibleImage((int)width, (int)height, (int)3);
            }
        }
        this.viewportWidth = this.compWidth;
        this.viewportHeight = this.compHeight;
        this.updateComp = true;
        this.redrawBKBuffer = true;
    }

    protected void setGroupAxisScreenArea() {
        if (this.chart.getOrientation() == 0) {
            int ht = this.xAxis.getBottomHeight((Graphics2D)this.gc);
            this.groupAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height + ht);
        } else {
            int wt = this.yAxis.getLeftWidth((Graphics2D)this.gc);
            this.groupAxis.setScreenArea(this.chartClipRect.x - wt, this.chartClipRect.y, this.chartClipRect.width + wt, this.chartClipRect.height);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.gc = g;
        if (this.applyingChanges) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.useBackBuffer && (this.backBuffer == null || this.backBuffer2 == null)) {
            return;
        }
        if (this.updateComp || this.chart.isDataChanged()) {
            this.updateComponent();
        }
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        if ((this.error & 1) != 0 || (this.error & 4) != 0) {
            this.drawErrorMessage(g);
            return;
        }
        if (!this.useBackBuffer || this.redrawBKBuffer) {
            this.drawToBackBuffer(g);
        }
        if (!this.useBackBuffer) {
            if (this.brushMode && this.rubberband != null) {
                g.setColor(this.brushColor);
                ((Graphics2D)g).draw(this.rubberband);
            }
            if (this.mouseOnXAxis) {
                this.xHandler.drawZoomPanIndicator(g);
            } else if (this.mouseOnYAxis) {
                this.yHandler.drawZoomPanIndicator(g);
            }
            this.xHandler.drawViewportIndicator(g);
            this.yHandler.drawViewportIndicator(g);
            this.warningIcon.draw(g);
            return;
        }
        if (this.chart.isHighlightRequired() || this.brushMode && this.rubberband != null) {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            if (this.chart.isHighlightRequired()) {
                backGraphics2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
                this.chart.drawHighlight(backGraphics2);
                backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
            }
            if (this.brushMode && this.rubberband != null) {
                backGraphics2.setColor(this.brushColor);
                backGraphics2.draw(this.rubberband);
            }
            if (this.xAxis != null) {
                this.xAxis.drawReferenceRanges(backGraphics2);
            }
            if (this.yAxis != null) {
                this.yAxis.drawReferenceRanges(backGraphics2);
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            backGraphics2.dispose();
        } else {
            Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
            backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            if (this.xAxis != null) {
                this.xAxis.drawReferenceRanges(backGraphics2);
            }
            if (this.yAxis != null) {
                this.yAxis.drawReferenceRanges(backGraphics2);
            }
            g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
            backGraphics2.dispose();
        }
        if (this.mouseOnXAxis) {
            this.xHandler.drawZoomPanIndicator(g);
        } else if (this.mouseOnYAxis) {
            this.yHandler.drawZoomPanIndicator(g);
        }
        this.xHandler.drawViewportIndicator(g);
        this.yHandler.drawViewportIndicator(g);
        this.warningIcon.draw(g);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int y;
        String toolTipText = null;
        int x = e.getX();
        if (this.warningIcon.isMouseOverIcon(x, y = e.getY())) {
            return this.warningIcon.getTooltipText();
        }
        if (toolTipText == null && this.xAxis != null) {
            toolTipText = this.xAxis.getToolTipText(x, y);
        }
        if (toolTipText == null && this.yAxis != null) {
            toolTipText = this.yAxis.getToolTipText(x, y);
        }
        if (toolTipText == null && this.chartClipRect.contains(x, y) && this.chart != null) {
            toolTipText = this.chart.getToolTipText(x, y);
        }
        return toolTipText;
    }

    protected boolean createChartElements(Object source) {
        if (this.chart == null) {
            this.chart = new BoxPlotChart();
        }
        if (this.chart != null) {
            this.chart.setDataSource(this.dataFilter);
            this.chart.setTransformObject(this);
            this.chart.addRedrawListener(this);
            this.chart.setMarginListener(this.marginListeners, this);
        }
        if (this.xAxis == null) {
            this.xAxis = new Axes();
        }
        if (this.xAxis != null) {
            this.xAxis.setTransformObject(this);
            this.xAxis.addRedrawListener(this);
            this.setColorsToAxis(1);
        }
        if (this.yAxis == null) {
            this.yAxis = new Axes();
        }
        if (this.yAxis != null) {
            this.yAxis.setTransformObject(this);
            this.yAxis.addRedrawListener(this);
            this.setColorsToAxis(2);
        }
        if (this.chart != null) {
            this.chart.setXAxis(this.xAxis);
            this.chart.setYAxis(this.yAxis);
            this.chart.setLegend(this.legend);
        }
        this.xHandler = new AxisZoomPanHandler(this.xAxis);
        this.yHandler = new AxisZoomPanHandler(this.yAxis);
        this.warningIcon = new ViewportWarningIcon(this);
        this.warningIcon.addZoomPanHandler(this.xHandler);
        this.warningIcon.addZoomPanHandler(this.yHandler);
        this.xHandler.addViewportListener(this);
        this.yHandler.addViewportListener(this);
        this.addViewportListener(this.xHandler);
        this.addViewportListener(this.yHandler);
        return true;
    }

    protected void createGroupAxis() {
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis == null) {
            this.groupAxis = new Axes();
            if (this.groupAxis != null) {
                this.groupAxis.setTransformObject(this);
                this.groupAxis.addRedrawListener(this);
                this.chart.setGroupAxis(this.groupAxis);
                this.setColorsToAxis(3);
            }
        }
    }

    protected void buildOtherElements(Object buildData) {
        if (this.updatePanels) {
            if (this.propertiesDialog != null) {
                // empty if block
            }
            this.updatePanels = false;
        }
    }

    protected void drawErrorMessage(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        String errorMessage = "";
        if ((this.error & 1) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.DataNotAssigned.txt", (String)"Data is not assigned correctly.");
        } else if ((this.error & 2) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.GraphAreaSmall.txt", (String)"Graph area is too small.");
        } else if ((this.error & 4) != 0) {
            errorMessage = ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.NoData.txt", (String)"No Data");
        }
        Font f = this.xAxis.getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout errorString = new TextLayout(errorMessage, f, frc);
        Rectangle2D bounds = errorString.getBounds();
        g2.setColor(Color.red);
        errorString.draw(g2, 0.0f, (float)bounds.getHeight());
    }

    protected void drawZeroObservation(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Font f = this.xAxis.getLabel().getFont();
        FontRenderContext frc = g2.getFontRenderContext();
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.NoData.txt", (String)"No Data");
        TextLayout msgString = new TextLayout(msg, f, frc);
        Rectangle2D bounds = msgString.getBounds();
        double x = this.chartClipRect.getX() + (this.chartClipRect.getWidth() - bounds.getWidth()) * 0.5;
        double y = this.chartClipRect.getY() + this.chartClipRect.getHeight() * 0.5;
        msgString.draw(g2, (float)x, (float)y);
    }

    protected void drawToBackBuffer(Graphics g) {
        Graphics2D g2 = !this.useBackBuffer ? (Graphics2D)g : (Graphics2D)this.backBuffer.getGraphics();
        g2.setClip(0, 0, this.compWidth, this.compHeight);
        this.background.drawBackground(g2, this, new Rectangle(0, 0, this.compWidth, this.compHeight));
        if (this.error == 0) {
            if (this.wall != null && this.wallOn) {
                this.wall.drawBackground(g2, this, this.chartClipRect);
            }
            if (this.xAxis != null) {
                this.xAxis.draw(g2, false);
            }
            if (this.yAxis != null) {
                this.yAxis.draw(g2, false);
            }
            if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null) {
                this.groupAxis.draw(g2, false);
            }
            if (this.chart != null) {
                g2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
                this.chart.draw(g2, !this.useBackBuffer);
                g2.setClip(0, 0, this.compWidth, this.compHeight);
            }
        }
        this.graphLayout.draw(g2);
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            this.drawZeroObservation(g2);
        }
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        g2.dispose();
        backGraphics2.dispose();
        this.redrawBKBuffer = false;
    }

    protected synchronized void drawChartTips(int x, int y, String tipText, Graphics g) {
        Rectangle2D bounds;
        double chartTipOpacity = this.tooltip.getChartTipOpacity();
        Color chartTipBorderColor = this.tooltip.getChartTipBorderColor();
        Color chartTipTextColor = this.tooltip.getChartTipTextColor();
        Color chartTipBackgroundColor = this.tooltip.getSolidBackground();
        Font chartTipFont = this.tooltip.getFontObject();
        Graphics2D g2 = (Graphics2D)g;
        Font f = chartTipFont == null ? this.getFont() : chartTipFont;
        FontRenderContext frc = g2.getFontRenderContext();
        StringTokenizer st = new StringTokenizer(tipText, "\n", false);
        ArrayList<String> textLines = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String text = st.nextToken();
            textLines.add(text);
        }
        TextLayout[] textString = new TextLayout[textLines.size()];
        double width = 0.0;
        double height = 0.0;
        double lineGap = 2.0;
        height += lineGap;
        for (int i = 0; i < textLines.size(); ++i) {
            textString[i] = new TextLayout((String)textLines.get(i), f, frc);
            bounds = textString[i].getBounds();
            width = Math.max(width, bounds.getWidth());
            height += bounds.getHeight() + lineGap;
        }
        if ((double)x + (width += 2.0 * lineGap) > (double)this.compWidth) {
            x = (int)((double)x - ((double)x + width - (double)this.compWidth));
            x -= 2;
            x = Math.max(1, x);
        }
        if ((double)y - height > 0.0) {
            y = (int)((double)y - height);
        }
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, (float)chartTipOpacity));
        if (chartTipBackgroundColor != null) {
            g2.setColor(chartTipBackgroundColor);
            g2.fillRect(x, y, (int)width, (int)height);
        }
        if (chartTipBorderColor != null) {
            g2.setColor(chartTipBorderColor);
            g2.drawRect(x, y, (int)width, (int)height);
        }
        g2.setColor(chartTipTextColor);
        x = (int)((double)x + lineGap);
        y = (int)((double)y + lineGap);
        for (int i = 0; i < textLines.size(); ++i) {
            bounds = textString[i].getBounds();
            y = (int)((double)y + bounds.getHeight());
            textString[i].draw(g2, x, y);
            y = (int)((double)y + lineGap);
        }
        g2.setComposite(composite);
    }

    protected void brushing(Point pt) {
        double chartClipX = this.chartClipRect.getX();
        double chartClipY = this.chartClipRect.getY();
        double chartClipWidth = this.chartClipRect.getWidth();
        double chartClipHeight = this.chartClipRect.getHeight();
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        switch (this.brushAction) {
            case 1: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, chartClipX + chartClipWidth - this.rubberband.width);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, chartClipY + chartClipHeight - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 6: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            case 9: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, chartClipX + chartClipWidth - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, chartClipY + chartClipHeight - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        this.rubberband.x = x;
        this.rubberband.y = y;
        this.rubberband.width = width;
        this.rubberband.height = height;
        boolean sel = this.chart.setSelection(this.rubberband, false);
        this.startPt = pt;
        if (!sel) {
            this.repaint();
        }
    }

    protected void setCursorShape(int action, boolean down) {
        switch (action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                Toolkit tk = Toolkit.getDefaultToolkit();
                if (down) {
                    this.setCursor(tk.createCustomCursor(this.closeMoveImage, new Point(6, 2), "icons/MoveClosed.gif"));
                    break;
                }
                this.setCursor(tk.createCustomCursor(this.openMoveImage, new Point(6, 2), "icons/MoveOpen.gif"));
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    protected int getMouseSpot(Point pt) {
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    protected void createHandleRects() {
        if (this.rubberband.width > 24.0 && this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
        } else {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
        }
    }

    protected int getRubberbandingDirection() {
        if (this.chart.getOrientation() == 0) {
            return 1;
        }
        return 2;
    }

    protected void zoomGraph(Point pt) {
        double middle;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        int dy = (int)((double)(pt.y - this.startPt.y) * 0.5);
        int dx = (int)((double)(this.startPt.x - pt.x) * 0.5);
        if (dx != 0) {
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            xmin -= offset;
            xmax += offset;
            if (this.getRubberbandingDirection() == 1) {
                if (xmax - xmin < 1.0) {
                    return;
                }
                middle = 0.5 * (this.viewportXMax + this.viewportXMin);
                xmin = Math.min(middle, Math.max(xmin, this.dataXMin));
                xmax = Math.max(xmin + 1.0, Math.min(xmax, this.dataXMax));
            } else {
                xmin = this.dataXMin;
                xmax = Math.max(xmin + this.silkDefaults.zoomLimitParm * (this.dataXMax - this.dataXMin), Math.min(xmax, this.dataXMax));
            }
        }
        if (dy != 0) {
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            ymin += offset;
            ymax -= offset;
            if (this.getRubberbandingDirection() == 2) {
                if (ymax - ymin < 1.0) {
                    return;
                }
                middle = 0.5 * (this.viewportYMax + this.viewportYMin);
                ymin = Math.min(middle, Math.max(ymin, this.dataYMin));
                ymax = Math.max(ymin + 1.0, Math.min(ymax, this.dataYMax));
            } else {
                ymin = this.dataYMin;
                ymax = Math.max(ymin + this.silkDefaults.zoomLimitParm * (this.dataYMax - this.dataYMin), Math.min(ymax, this.dataYMax));
            }
        }
        this.chart.setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.viewportXMin = xmin;
        this.viewportXMax = xmax;
        this.viewportYMin = ymin;
        this.viewportYMax = ymax;
        this.fireViewportChangeEvent();
        this.startPt = pt;
    }

    protected void panGraph(Point pt) {
        double delta;
        double offset;
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.unProject(0.0, 0.0, 0.0, v1);
        double xmin = this.chartBBox[0];
        double xmax = this.chartBBox[3];
        double ymin = this.chartBBox[1];
        double ymax = this.chartBBox[4];
        if (this.getRubberbandingDirection() == 1) {
            int dx = pt.x - this.startPt.x;
            this.unProject(dx, 0.0, 0.0, v2);
            offset = v2[0] - v1[0];
            xmin -= offset;
            xmax -= offset;
            if (xmin < this.dataXMin) {
                delta = this.dataXMin - xmin;
                xmin = this.dataXMin;
                xmax += delta;
            }
            if (xmax > this.dataXMax) {
                delta = xmax - this.dataXMax;
                xmin -= delta;
                xmax = this.dataXMax;
            }
        }
        if (this.getRubberbandingDirection() == 2) {
            int dy = pt.y - this.startPt.y;
            this.unProject(0.0, dy, 0.0, v2);
            offset = v2[1] - v1[1];
            ymin -= offset;
            ymax -= offset;
            if (ymin < this.dataYMin) {
                delta = this.dataYMin - ymin;
                ymin = this.dataYMin;
                ymax += delta;
            }
            if (ymax > this.dataYMax) {
                delta = ymax - this.dataYMax;
                ymin -= delta;
                ymax = this.dataYMax;
            }
        }
        this.chart.setBoundingBox(xmin, ymin, 0.0, xmax, ymax, 0.0);
        this.viewportXMin = xmin;
        this.viewportXMax = xmax;
        this.viewportYMin = ymin;
        this.viewportYMax = ymax;
        this.fireViewportChangeEvent();
        this.startPt = pt;
    }

    protected void dragRubberband(Point pt) {
        if (Math.abs(pt.x - this.startPt.x) < 5 || Math.abs(pt.y - this.startPt.y) < 5) {
            return;
        }
        this.rectSelection = true;
        if (this.rubberband == null) {
            this.rubberband = new Rectangle2D.Double();
        }
        if (this.rubberband != null) {
            int x1 = Math.min(this.startPt.x, pt.x);
            int x2 = Math.max(this.startPt.x, pt.x);
            x1 = Math.max(x1, this.chartClipRect.x);
            x2 = Math.min(x2, this.chartClipRect.x + this.chartClipRect.width);
            int y1 = Math.min(this.startPt.y, pt.y);
            int y2 = Math.max(this.startPt.y, pt.y);
            y1 = Math.max(y1, this.chartClipRect.y);
            y2 = Math.min(y2, this.chartClipRect.y + this.chartClipRect.height);
            this.rubberband.x = x1;
            this.rubberband.y = y1;
            this.rubberband.width = x2 - x1;
            this.rubberband.height = y2 - y1;
        }
        if (!this.useBackBuffer) {
            return;
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        if (this.chart.isHighlightRequired()) {
            backGraphics2.setClip(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width + 1, this.chartClipRect.height + 1);
            this.chart.drawHighlight(backGraphics2);
            backGraphics2.setClip(0, 0, this.compWidth, this.compHeight);
        }
        if (this.xAxis != null) {
            this.xAxis.drawReferenceRanges(backGraphics2);
        }
        if (this.yAxis != null) {
            this.yAxis.drawReferenceRanges(backGraphics2);
        }
        if (this.rubberband != null) {
            backGraphics2.setColor(this.brushColor);
            backGraphics2.setXORMode(Color.white);
            backGraphics2.draw(this.rubberband);
        }
        int x = this.chartClipRect.x;
        int y = this.chartClipRect.y;
        int w = this.chartClipRect.width;
        int h = this.chartClipRect.height;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.drawImage(this.backBuffer2, x, y, x + w, y + h, x, y, x + w, y + h, this);
        backGraphics2.dispose();
        g2.dispose();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        int oldWidth = this.compWidth;
        int oldHeight = this.compHeight;
        boolean backOn = this.useBackBuffer;
        this.useBackBuffer = false;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle bounds = this.getBounds();
        double width = pageFormat.getImageableWidth();
        double height = pageFormat.getImageableHeight();
        double s_aspect = (double)bounds.width / (double)bounds.height;
        double p_aspect = width / height;
        double p_width = width;
        double p_height = height;
        if (p_aspect <= 1.0) {
            if (s_aspect < 1.0 && s_aspect < p_aspect) {
                p_width = height * s_aspect;
            } else {
                p_height = width / s_aspect;
            }
        } else if (s_aspect > 1.0 && s_aspect > p_aspect) {
            p_height = width / s_aspect;
        } else {
            p_width = height * s_aspect;
        }
        this.resizeComponent((int)p_width, (int)p_height);
        float tx = (float)((width - p_width) * 0.5);
        float ty = (float)((height - p_height) * 0.5);
        g2.translate(tx, ty);
        g2.setClip(0, 0, (int)p_width, (int)p_height);
        this.paint(graphics);
        this.useBackBuffer = backOn;
        this.resizeComponent(oldWidth, oldHeight);
        return 0;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.tipsOn && this.tipText != null) {
            this.tipText = null;
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            return;
        }
        this.startPt = e.getPoint();
        if (this.mouseOnXAxis) {
            this.xHandler.mousePressed(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mousePressed(e);
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.brushAction = this.getMouseSpot(this.startPt);
            this.setCursorShape(this.brushAction, true);
            if (this.brushAction == 0) {
                this.brushMode = false;
            }
        } else {
            if (!this.chartClipRect.contains(this.startPt)) {
                return;
            }
            this.setCursor(new Cursor(0));
        }
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.chart == null) {
            return;
        }
        if (this.warningIcon.isMouseOverIcon(e.getX(), e.getY())) {
            this.resetViewport();
            return;
        }
        if (this.mouseOnXAxis) {
            this.xHandler.mouseReleased(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseReleased(e);
            return;
        }
        if (e.isPopupTrigger() || (e.getModifiers() & 4) != 0) {
            if (!this.allowPopup) {
                return;
            }
            if (this.popup == null) {
                this.popup = this.getPopupMenu();
                this.add(this.popup);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
            return;
        }
        if (this.error > 0) {
            return;
        }
        super.mouseReleased(e);
        if (this.brushMode && this.actionMode == 1) {
            this.setCursor(new Cursor(0));
            this.createHandleRects();
            return;
        }
        this.brushMode = false;
        boolean sel = false;
        if (this.rectSelection) {
            if (this.actionMode == 2) {
                boolean viewporting = true;
                double min_viewport = 0.1;
                if (this.getRubberbandingDirection() == 1) {
                    if (this.chartBBox[3] - this.chartBBox[0] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 2) {
                    if (this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                        viewporting = false;
                    }
                } else if (this.getRubberbandingDirection() == 3 && this.chartBBox[3] - this.chartBBox[0] < min_viewport && this.chartBBox[4] - this.chartBBox[1] < min_viewport) {
                    viewporting = false;
                }
                if (!viewporting) {
                    this.rectSelection = false;
                    this.repaint();
                    return;
                }
                double[] min = new double[3];
                double[] max = new double[3];
                this.unProject(this.rubberband.x, this.rubberband.y + this.rubberband.height, 0.0, min);
                this.unProject(this.rubberband.x + this.rubberband.width, this.rubberband.y, 0.0, max);
                if (this.getRubberbandingDirection() == 1) {
                    min[0] = Math.max(min[0], this.dataXMin);
                    min[1] = this.dataYMin;
                    max[0] = Math.min(max[0], this.dataXMax);
                    max[1] = Math.min(max[1], this.dataYMax);
                } else {
                    min[0] = this.dataXMin;
                    min[1] = Math.max(min[1], this.dataYMin);
                    max[0] = Math.min(max[0], this.dataXMax);
                    max[1] = Math.min(max[1], this.dataYMax);
                }
                this.panning = false;
                this.chart.setBoundingBox(min[0], min[1], 0.0, max[0], max[1], 0.0);
                this.viewportXMin = min[0];
                this.viewportXMax = max[0];
                this.viewportYMin = min[1];
                this.viewportYMax = max[1];
                this.fireViewportChangeEvent();
            } else if (this.actionMode == 1) {
                this.brushMode = true;
                this.mouseAction = true;
                sel = this.chart.setSelection(this.rubberband, false);
                this.createHandleRects();
                this.mouseAction = false;
            } else if (this.actionMode == 6) {
                sel = e.isControlDown() ? this.chart.setSelection(this.rubberband, true) : this.chart.setSelection(this.rubberband, false);
            }
            this.rectSelection = false;
        } else if (this.actionMode == 6) {
            if (e.isControlDown()) {
                this.chart.setSelection(e.getX(), e.getY(), true);
            } else {
                this.chart.setSelection(e.getX(), e.getY(), false);
            }
        } else if (this.actionMode == 1) {
            this.chart.setSelection(e.getX(), e.getY(), false);
        }
        if (!sel) {
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        this.startPt = e.getPoint();
        this.mouseOnYAxis = false;
        this.mouseOnXAxis = false;
        if (!this.warningIcon.isMouseOverIcon(e.getX(), e.getY()) && this.xHandler.isMouseInZoomPanArea(e)) {
            this.xHandler.mouseMoved(e);
            this.mouseOnXAxis = true;
            this.tipText = null;
            return;
        }
        if (!this.warningIcon.isMouseOverIcon(e.getX(), e.getY()) && this.yHandler.isMouseInZoomPanArea(e)) {
            this.yHandler.mouseMoved(e);
            this.mouseOnYAxis = true;
            this.tipText = null;
            return;
        }
        if (this.brushMode && this.actionMode == 1) {
            this.setCursorShape(this.getMouseSpot(this.startPt), false);
        } else {
            this.setCursor(new Cursor(0));
        }
        super.mouseMoved(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.chart == null || this.error > 0) {
            return;
        }
        if (this.dataFilter.getNumberObservations(-1) <= 0) {
            return;
        }
        Point pt = e.getPoint();
        if (this.mouseOnXAxis) {
            this.xHandler.mouseDragged(e);
            return;
        }
        if (this.mouseOnYAxis) {
            this.yHandler.mouseDragged(e);
            return;
        }
        switch (this.actionMode) {
            case 3: {
                this.zoomGraph(pt);
                break;
            }
            case 4: {
                this.panGraph(pt);
                break;
            }
            case 2: 
            case 6: {
                this.dragRubberband(pt);
                break;
            }
            case 1: {
                if (this.brushMode) {
                    this.mouseAction = true;
                    this.brushing(pt);
                    this.mouseAction = false;
                    break;
                }
                this.dragRubberband(pt);
                break;
            }
        }
    }

    @Override
    public void addViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (!this.viewportListeners.contains(listener)) {
            this.viewportListeners.add(listener);
        }
    }

    @Override
    public void removeViewportListener(Object listener) {
        if (listener == null || !(listener instanceof ViewportListenerInterface)) {
            return;
        }
        if (this.viewportListeners.contains(listener)) {
            this.viewportListeners.remove(listener);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = MenuUtilities.getPopupMenu(this.getClass().getResourceAsStream("/com/sas/graphics/silk/util/menus/BoxPlotMenu.xml"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    BoxPlotComponent.this.handleMenuCommand(actionCommand);
                }
            });
        }
        if (this.chart.getOrientation() == 0) {
            MenuUtilities.setMenuItemSelected(this.popup, "CHART_TYPE_VERTICAL", true);
        } else {
            MenuUtilities.setMenuItemSelected(this.popup, "CHART_TYPE_HORIZONTAL", true);
        }
        return this.popup;
    }

    @Override
    public Component getToolBar() {
        Component tb = super.getToolBar();
        if (tb != null && tb instanceof GraphToolbarInterface && !this.userSetToolbar) {
            ((SILKToolbar)tb).setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"BoxPlotComponent.BoxPlotToolbar.txt", (String)"BoxPlot Toolbar"));
        }
        return tb;
    }

    @Override
    public boolean setToolBar(Component toolBarIn) {
        if (toolBarIn != null) {
            if (this.toolBar == null && this.popup != null) {
                this.popup.insert(this.tBar, 1);
            }
            this.toolBar = toolBarIn;
            if (this.toolBar instanceof GraphToolbarInterface) {
                ((GraphToolbarInterface)((Object)this.toolBar)).addListener(this);
            }
        } else if (this.toolBar != null) {
            if (this.toolBar.isShowing()) {
                this.toolBar.setVisible(false);
            }
            this.toolBar = null;
            if (this.popup != null) {
                this.popup.remove(1);
            }
        }
        this.userSetToolbar = true;
        return true;
    }

    @Override
    public boolean setActionMode(int mode) {
        boolean rc = true;
        if (mode == 5) {
            if (this.chart != null && this.error == 0) {
                this.panning = false;
                this.chart.setBoundingBox(this.dataXMin, this.dataYMin, 0.0, this.dataXMax, this.dataYMax, 0.0);
                this.viewportXMin = this.dataXMin;
                this.viewportXMax = this.dataXMax;
                this.viewportYMin = this.dataYMin;
                this.viewportYMax = this.dataYMax;
                this.fireViewportChangeEvent();
            }
        } else {
            rc = super.setActionMode(mode);
        }
        if (this.actionMode != 1 && this.brushMode) {
            this.brushMode = false;
            this.repaint();
        }
        return rc;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (!rc || this.style == null) {
            return rc;
        }
        this.wall.setSolidBackground(this.style.getFillStyleElement("WallFill").getFillColor());
        this.graphLayout.getTitle().applyStyle(this.style);
        this.graphLayout.getFootnote().applyStyle(this.style);
        this.tooltip.applyStyle(this.style);
        if (this.chart != null) {
            this.setColorsToChart();
        }
        if (this.xAxis != null) {
            this.setColorsToAxis(1);
            this.xHandler.setStyle(this.style);
        }
        if (this.yAxis != null) {
            this.setColorsToAxis(2);
            this.yHandler.setStyle(this.style);
        }
        if (this.groupAxis != null) {
            this.setColorsToAxis(3);
        }
        if (this.legend != null) {
            this.setColorsToLegend();
        }
        return true;
    }

    @Override
    public AxisInterface getAxis(Object which) {
        if (which == null || !(which instanceof String)) {
            return null;
        }
        if (((String)which).equalsIgnoreCase(BoxPlotModel.X_ROLE_NAME) || ((String)which).equalsIgnoreCase("X") || ((String)which).equalsIgnoreCase("XAxis")) {
            return this.xAxis;
        }
        if (((String)which).equalsIgnoreCase(BoxPlotModel.Y_ROLE_NAME) || ((String)which).equalsIgnoreCase("Y") || ((String)which).equalsIgnoreCase("YAxis")) {
            return this.yAxis;
        }
        if (((String)which).equalsIgnoreCase(BoxPlotModel.GROUP_ROLE_NAME) || ((String)which).equalsIgnoreCase("group") || ((String)which).equalsIgnoreCase("groupAxis")) {
            return this.groupAxis;
        }
        return null;
    }

    @Override
    public LegendInterface getLegend(Object which) {
        return this.chart != null && this.chart.isLegendRequired() ? this.legend : null;
    }

    @Override
    public Object getLegendPosition(Object which) {
        return this.legend.getLegendNumber(this.legend.getPosition());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLegendPosition(Object which, Object pos) {
        if (this.legend == null) {
            return true;
        }
        int position = -1;
        if (pos instanceof String) {
            if (((String)pos).equalsIgnoreCase("South")) {
                position = 2;
            } else if (((String)pos).equalsIgnoreCase("North")) {
                position = 1;
            } else if (((String)pos).equalsIgnoreCase("East")) {
                position = 3;
            } else if (((String)pos).equalsIgnoreCase("West")) {
                position = 4;
            } else {
                if (!((String)pos).equalsIgnoreCase("Custom")) return false;
                position = 5;
            }
        } else if (pos instanceof Number) {
            position = ((Number)pos).intValue();
            switch (position) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.legendPosition == position) return true;
        this.legendPosition = position;
        this.legend.setPosition(this.legendPosition);
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    @Override
    public Rectangle getLegendBounds() {
        if (this.legend == null) {
            return null;
        }
        int x = this.legend.getStartPoint().x;
        int y = this.legend.getStartPoint().y;
        int w = this.legend.getPreferredSize().width;
        int h = this.legend.getPreferredSize().height;
        return new Rectangle(x, y, w, h);
    }

    @Override
    public boolean setLegendBounds(Rectangle rect) {
        if (this.legend == null) {
            return true;
        }
        this.legendBounds = rect;
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.chartClipRect = null;
        if (this.backBuffer != null) {
            this.backBuffer.flush();
        }
        this.backBuffer = null;
        if (this.backBuffer2 != null) {
            this.backBuffer2.flush();
        }
        this.backBuffer2 = null;
        this.backImage = null;
        if (this.chart != null) {
            this.chart.removeDataListener();
        }
        this.chart = null;
        this.xAxis = null;
        this.yAxis = null;
        this.groupAxis = null;
        this.removeMouseListener(this.legend);
        this.removeMouseMotionListener(this.legend);
        this.legend = null;
        this.legendBounds = null;
        this.wall = null;
        if (this.graphLayout.getTitle() != null) {
            this.graphLayout.getTitle().removeTextListener(this);
        }
        if (this.graphLayout.getFootnote() != null) {
            // empty if block
        }
        this.graphLayout.getFootnote().removeTextListener(this);
        this.chartBBox = null;
        this.dataFilter = null;
        this.chartOuterMargin = null;
        this.compMargin = null;
        this.rubberband = null;
        this.popup = null;
        if (this.toolBar != null) {
            this.toolBar.setVisible(false);
        }
        this.toolBar = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    @Override
    public Object getDataSource(Object id) {
        return super.getDataSource(id);
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        if (!rc) {
            return rc;
        }
        this.updatePanels = true;
        return this.createChartElements(source);
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.chart == null) {
            return null;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        return this.chart.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.chart == null) {
            return null;
        }
        if (variableId instanceof Number) {
            SILKNumber obj = ((Number)variableId).intValue() == -3 ? (this.chart.getOrientation() == 0 ? BoxPlotModel.X_ROLE_NUMBER : BoxPlotModel.Y_ROLE_NUMBER) : (((Number)variableId).intValue() == -4 ? (this.chart.getOrientation() == 0 ? BoxPlotModel.Y_ROLE_NUMBER : BoxPlotModel.X_ROLE_NUMBER) : null);
            return obj;
        }
        return this.chart.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        if (!this.chart.setRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        if (role instanceof String && ((String)role).equalsIgnoreCase("Group") || role instanceof String && ((String)role).equalsIgnoreCase(BoxPlotModel.GROUP_ROLE_NAME) || role instanceof Number && ((Number)role).equals(ROLE_GROUP)) {
            this.createGroupAxis();
        }
        if (this.roles != null) {
            this.roles.fireRoleChangeEvent(false, false, 1, this.roles.getRoleInt(role), this, null, null, variableId, null);
        }
        return true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        if (!this.chart.addRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        if (role instanceof String && ((String)role).equalsIgnoreCase("Group") || role instanceof String && ((String)role).equalsIgnoreCase(BoxPlotModel.GROUP_ROLE_NAME) || role instanceof Number && ((Number)role).equals(ROLE_GROUP)) {
            this.createGroupAxis();
        }
        return true;
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.chart == null || role == null) {
            return false;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        if (!this.chart.removeRole(variableId, role)) {
            return false;
        }
        this.updatePanels = true;
        if (this.roles != null) {
            this.roles.fireRoleChangeEvent(false, false, 3, this.roles.getRoleInt(role), this, null, null, variableId, null);
        }
        return true;
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setDiscrete(role, discrete);
    }

    @Override
    public Object getSortOrder(Object role) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSortOrder(role);
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.chart == null) {
            return false;
        }
        return this.chart.setSortOrder(role, order);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.chart == null) {
            return null;
        }
        if (role instanceof SILKNumber) {
            role = ((SILKNumber)((Object)role)).toString();
        }
        return this.chart.getRoleValue(role, which);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        if (this.chart == null) {
            return null;
        }
        return this.chart.getSupportedRoles(id, discrete);
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (this.chart == null) {
            return -1;
        }
        return this.chart.getMaxAllowed(role);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    @Override
    public boolean create(Object createData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.chart.isRebuildRequired() || this.xAxis.isRebuildRequired() || this.yAxis.isRebuildRequired() || this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null && this.groupAxis.isRebuildRequired();
    }

    @Override
    public synchronized boolean build(Object buildData) {
        if (this.chart == null) {
            return false;
        }
        if (!this.isRebuildRequired()) {
            return true;
        }
        this.redrawBKBuffer = true;
        if (this.getFilter() == null || this.getVariable(BoxPlotModel.Y_ROLE_NAME) == null || this.getVariable(BoxPlotModel.X_ROLE_NAME) == null || this.getVariable(BoxPlotModel.STAT_ROLE_NAME) == null) {
            if ((this.error & 4) != 0) {
                this.error &= 0xFFFFFFFB;
            }
            this.error |= 1;
            return false;
        }
        if (this.chart != null && !this.chart.isChartDataValid()) {
            if ((this.error & 1) != 0) {
                this.error &= 0xFFFFFFFE;
            }
            this.error |= 4;
            return false;
        }
        if ((this.error & 4) != 0) {
            this.error &= 0xFFFFFFFB;
        }
        if ((this.error & 1) != 0) {
            this.error &= 0xFFFFFFFE;
        }
        if (this.chart.isDataChanged()) {
            this.chartBBox = this.chart.getBoundingBox();
            if (this.chartBBox == null) {
                return false;
            }
            this.dataXMin = this.chartBBox[0];
            this.dataXMax = this.chartBBox[3];
            this.dataYMin = this.chartBBox[1];
            this.dataYMax = this.chartBBox[4];
            this.viewportXMin = this.dataXMin;
            this.viewportYMin = this.dataYMin;
            this.viewportXMax = this.dataXMax;
            this.viewportYMax = this.dataYMax;
            this.xHandler.setDataRange(this.dataXMin, this.dataXMax);
            this.yHandler.setDataRange(this.dataYMin, this.dataYMax);
            if (this.getRubberbandingDirection() == 1) {
                this.xHandler.setMinimumViewportRange(1.0);
                this.yHandler.setMinimumViewportRange(this.silkDefaults.zoomLimitParm * (this.dataYMax - this.dataYMin));
            } else if (this.getRubberbandingDirection() == 2) {
                this.yHandler.setMinimumViewportRange(1.0);
                this.xHandler.setMinimumViewportRange(this.silkDefaults.zoomLimitParm * (this.dataXMax - this.dataXMin));
            }
            this.fireViewportChangeEvent();
            this.fireRangeChangeEvent((byte)1);
            this.fireRangeChangeEvent((byte)2);
            this.brushMode = false;
        }
        if (this.chart.isRebuildRequired()) {
            this.chart.build(null);
        }
        if (this.xAxis != null && this.xAxis.isRebuildRequired()) {
            this.xAxis.build(null);
        }
        if (this.yAxis != null && this.yAxis.isRebuildRequired()) {
            this.yAxis.build(null);
        }
        if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null && this.groupAxis.isRebuildRequired()) {
            this.groupAxis.build(null);
        }
        this.buildOtherElements(null);
        return true;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(null);
        this.repaint();
        return status;
    }

    @Override
    public void setReverse(int axis, boolean flag) {
        switch (axis) {
            case 0: 
            case 3: {
                this.xReverse = flag;
                break;
            }
            case 1: 
            case 4: {
                this.yReverse = flag;
            }
        }
    }

    @Override
    public boolean isReverse(int axis) {
        boolean rc = false;
        switch (axis) {
            case 0: 
            case 3: {
                rc = this.xReverse;
                break;
            }
            case 1: 
            case 4: {
                rc = this.yReverse;
            }
        }
        return rc;
    }

    @Override
    public double[] project(double x, double y, double z, double[] out) {
        if (this.chartBBox == null) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        Insets im = this.chartInnerMargin != null ? this.chartInnerMargin : this.chart.getInnerMargin(false);
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right - im.left - im.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom - im.top - im.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left + im.left;
        int yo = this.viewportY + this.chartOuterMargin.top + im.top;
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        if (this.chartInnerMargin != null) {
            if (this.chart.getOrientation() == 0) {
                w += this.chart.getSizePerBox();
                xo -= (int)(0.5 * (double)this.chart.getSizePerBox());
            } else {
                h += this.chart.getSizePerBox();
                yo -= (int)(0.5 * (double)this.chart.getSizePerBox());
            }
        }
        ret[0] = this.xReverse ? (double)w * (x - xMax) / (xMin - xMax) + (double)xo : (double)w * (x - xMin) / (xMax - xMin) + (double)xo;
        ret[1] = this.yReverse ? (double)h - (double)h * (y - yMax) / (yMin - yMax) + (double)yo : (double)h - (double)h * (y - yMin) / (yMax - yMin) + (double)yo;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        if (this.chartBBox == null) {
            return null;
        }
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        Insets im = this.chartInnerMargin != null ? this.chartInnerMargin : this.chart.getInnerMargin(false);
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right - im.left - im.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom - im.top - im.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left + im.left;
        int yo = this.viewportY + this.chartOuterMargin.top + im.top;
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        if (this.chartInnerMargin != null) {
            if (this.chart.getOrientation() == 0) {
                w += this.chart.getSizePerBox();
                xo -= (int)(0.5 * (double)this.chart.getSizePerBox());
            } else {
                h += this.chart.getSizePerBox();
                yo -= (int)(0.5 * (double)this.chart.getSizePerBox());
            }
        }
        ret[0] = this.xReverse ? (xMin - xMax) * (pixelX - (double)xo) / (double)w + xMax : (xMax - xMin) * (pixelX - (double)xo) / (double)w + xMin;
        ret[1] = this.yReverse ? (yMin - yMax) * ((double)(h + yo) - pixelY) / (double)h + yMax : (yMax - yMin) * ((double)(h + yo) - pixelY) / (double)h + yMin;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public void redraw(RedrawEvent e) {
        if (e.type == 5 && !this.mouseAction) {
            this.brushMode = false;
        }
        if (e.type != 5) {
            this.redrawBKBuffer = true;
        }
        if (this.chart != null && this.chart.isInnerMarginChanged()) {
            this.fireMarginChangeEvent(true, false);
            if (this.xAxis != null) {
                this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            }
            if (this.yAxis != null) {
                this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            }
            if (this.groupAxis != null) {
                this.setGroupAxisScreenArea();
            }
        }
        this.repaint();
    }

    @Override
    public void boundingBoxChanged(RedrawEvent e) {
        this.chartInnerMargin = null;
        if (e.newBoundingBox != null) {
            Object[] tickValues;
            if (e.getSource() == this.chart) {
                this.chartBBox = e.newBoundingBox;
            } else if (e.getSource() == this.yAxis) {
                this.chartBBox[1] = e.newBoundingBox[1];
                this.chartBBox[4] = e.newBoundingBox[4];
            } else if (e.getSource() == this.xAxis) {
                this.chartBBox[0] = e.newBoundingBox[0];
                this.chartBBox[3] = e.newBoundingBox[3];
            }
            if (this.xAxis != null) {
                if (this.chart.getOrientation() == 1) {
                    if (this.panning) {
                        tickValues = AxisZoomPanHandler.panTickValues(this.chartBBox[0], this.chartBBox[3], this.xAxis.getTickMarkValues(false));
                        this.xAxis.setAxis(new Double(this.chartBBox[0]), new Double(this.chartBBox[3]), -1, 0, tickValues, new Boolean(true), Boolean.FALSE);
                    } else {
                        this.xAxis.setAxis(new Double(this.chartBBox[0]), new Double(this.chartBBox[3]), -1, 0, null, new Boolean(true), null);
                    }
                }
                this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            }
            if (this.yAxis != null) {
                if (this.chart.getOrientation() == 0) {
                    if (this.panning) {
                        tickValues = AxisZoomPanHandler.panTickValues(this.chartBBox[1], this.chartBBox[4], this.yAxis.getTickMarkValues(false));
                        this.yAxis.setAxis(new Double(this.chartBBox[1]), new Double(this.chartBBox[4]), -1, 0, tickValues, new Boolean(true), Boolean.FALSE);
                    } else {
                        this.yAxis.setAxis(new Double(this.chartBBox[1]), new Double(this.chartBBox[4]), -1, 0, null, new Boolean(true), null);
                    }
                }
                this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
            }
            if (this.getVariable(BoxPlotModel.GROUP_ROLE_NAME) != null && this.groupAxis != null) {
                this.setGroupAxisScreenArea();
            }
            this.brushMode = false;
        }
    }

    @Override
    public void outerMarginChanged(RedrawEvent e) {
        this.chartMargin = this.chart.getOuterMargin((Graphics2D)this.gc);
        this.chartOuterMargin.top = this.compMargin.top + this.chartMargin.top;
        this.chartOuterMargin.bottom = this.compMargin.bottom + this.chartMargin.bottom;
        this.chartOuterMargin.left = this.compMargin.left + this.chartMargin.left;
        this.chartOuterMargin.right = this.compMargin.right + this.chartMargin.right;
        if (this.updateChartClipArea()) {
            this.redrawBKBuffer = true;
            this.repaint();
        }
    }

    @Override
    public int numPages(PageFormat pf) {
        return 1;
    }

    @Override
    public int numPagesX(PageFormat pf) {
        return 1;
    }

    @Override
    public int numPagesY(PageFormat pf) {
        return 1;
    }

    @Override
    public void textUpdated(DvrTextEvent evt) {
        if (evt.isBoundsChanged) {
            this.updateComp = true;
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public int getNumRanges(byte dim) {
        return 0;
    }

    public DataRangeInterface getRangeSource(byte dim, int index) {
        return this;
    }

    public void setAxesVisible(boolean axesVisible) {
    }

    public boolean getAxesVisible() {
        return true;
    }

    public void setRange(byte dim, int index, DataRange range) {
        Axes axis;
        if (dim == 1) {
            axis = this.xAxis;
        } else if (dim == 2) {
            axis = this.yAxis;
        } else {
            return;
        }
        if (range instanceof ContinuousRange) {
            double min = ((ContinuousRange)range).getMin();
            double max = ((ContinuousRange)range).getMax();
            axis.setAxis(new Double(min), new Double(max), -1, -1, null, Boolean.TRUE, null);
            this.chart.getBoxPlotModel().setYMinimum(min);
            this.chart.getBoxPlotModel().setYMaximum(max);
        } else if (range instanceof DiscreteRange) {
            int size = ((DiscreteRange)range).getValuesSize();
            Enumeration e = ((DiscreteRange)range).getEnumeration();
            Object[] vals = new Object[size];
            int i = 0;
            while (e.hasMoreElements()) {
                vals[i] = e.nextElement();
                ++i;
            }
            axis.setAxis(new Double(0.0), new Double(size - 1), -1, -1, vals, Boolean.TRUE, null);
            this.chart.getBoxPlotModel().setXValues(vals);
        }
        this.chart.setDataChanged(true);
    }

    public Insets getOuterMargin() {
        if (this.userSetOuterMargin) {
            return this.chartOuterMargin;
        }
        return this.getPreferredOuterMargin();
    }

    public Insets getInnerMargin() {
        if (this.chartInnerMargin != null) {
            return this.chartInnerMargin;
        }
        return this.getPreferredInnerMargin();
    }

    public void setOuterMargin(Insets margin) {
        Insets oldOM = this.chartOuterMargin;
        this.chartOuterMargin = margin;
        this.userSetOuterMargin = true;
        if (this.chartOuterMargin.equals(oldOM)) {
            return;
        }
        this.updateChartClipArea();
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public void setInnerMargin(Insets margin) {
        this.chartInnerMargin = margin;
        this.chart.setInnerMargin(margin);
        if (this.xAxis != null) {
            this.xAxis.setOffset(this.chartInnerMargin.left, this.chartInnerMargin.right);
            this.xAxis.setLabelOffset(this.chartInnerMargin.right);
            this.xAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.yAxis != null) {
            this.yAxis.setOffset(this.chartInnerMargin.bottom, this.chartInnerMargin.top);
            this.yAxis.setScreenArea(this.chartClipRect.x, this.chartClipRect.y, this.chartClipRect.width, this.chartClipRect.height);
        }
        if (this.groupAxis != null) {
            this.setGroupAxisScreenArea();
        }
        this.redrawBKBuffer = true;
        this.repaint();
    }

    public Insets getPreferredOuterMargin() {
        Insets margin = new Insets(0, 0, 0, 0);
        if (this.chart != null) {
            Insets m2 = this.chart.getOuterMargin((Graphics2D)this.gc);
            Insets m1 = this.getComponentMargin();
            margin.top = m1.top + m2.top;
            margin.bottom = m1.bottom + m2.bottom;
            margin.left = m1.left + m2.left;
            margin.right = m1.right + m2.right;
        }
        return margin;
    }

    public Insets getPreferredInnerMargin() {
        if (this.chart == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.chart.getInnerMargin(true);
    }

    public void disableMarginPrefCalc() {
    }

    public void enableMarginPrefCalc() {
    }

    public boolean getMarginsAligned() {
        return true;
    }

    public void addMarginListener(MarginListener listener) {
        if (!this.marginListeners.contains(listener)) {
            this.marginListeners.add(listener);
        }
        if (this.chart != null) {
            this.chart.setMarginListener(this.marginListeners, this);
        }
    }

    public void removeMarginListener(MarginListener listener) {
        if (this.marginListeners.contains(listener)) {
            this.marginListeners.remove(this.marginListeners.indexOf(listener));
        }
        if (this.chart != null) {
            this.chart.setMarginListener(this.marginListeners, this);
        }
    }

    public DataRange getDataRange(byte dimension) {
        double max;
        BoxPlotModel model = this.chart.getBoxPlotModel();
        if (model == null) {
            return null;
        }
        Object[] vals = model.getUniqueXValues();
        Number MIN = (Number)this.getRoleValue(BoxPlotModel.Y_ROLE_NAME, 0);
        Number MAX = (Number)this.getRoleValue(BoxPlotModel.Y_ROLE_NAME, 1);
        double min = MIN == null ? Double.NaN : MIN.doubleValue();
        double d = max = MAX == null ? Double.NaN : MAX.doubleValue();
        if (dimension == 1) {
            if (this.chart.getOrientation() == 0) {
                return new DiscreteRange(vals);
            }
            return new ContinuousRange(min, max);
        }
        if (dimension == 2) {
            if (this.chart.getOrientation() == 1) {
                return new DiscreteRange(vals);
            }
            return new ContinuousRange(min, max);
        }
        return null;
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        if (!this.rangeListeners.contains(listener)) {
            this.rangeListeners.add(listener);
        }
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        if (this.rangeListeners.contains(listener)) {
            this.rangeListeners.remove(this.rangeListeners.indexOf(listener));
        }
    }

    private boolean isRefLineSupported() {
        if (this.xAxis != null) {
            if (this.selectedAxis == 0) {
                return !this.xAxis.isDiscrete();
            }
            return !this.yAxis.isDiscrete();
        }
        return false;
    }

    @Override
    public Object getPropertyValue(int idx) {
        if (this.propertyIndex == null) {
            return null;
        }
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.get(i);
        }
        switch (idx) {
            case 27: {
                if (this.wall != null) {
                    return this.wall.getGraphBackground();
                }
                return null;
            }
            case 26: {
                if (this.wall != null) {
                    return new Boolean(this.wallOn);
                }
            }
            case 0: {
                return new ColorScheme(this.style);
            }
            case 2: {
                return new Boolean(this.tipsOn);
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.tooltip.getPropertyValue(idx);
            }
            case 10: {
                return this.getGraphBackground();
            }
            case 21: {
                return this.getSolidBackground();
            }
            case 11: {
                return new Boolean(this.supportsGradientBackground());
            }
            case 12: {
                return new Boolean(this.supportsImageBackground());
            }
            case 32: {
                return new Integer(this.xMargin);
            }
            case 33: {
                return new Integer(this.yMargin);
            }
            case 34: {
                return new Boolean(this.hScrollbarOn);
            }
            case 238: {
                return new Integer(this.selectedAxis);
            }
            case 260: {
                return new Boolean(this.isRefLineSupported());
            }
            case 23: {
                return this.legend;
            }
            case 443: {
                return this.getLegendPosition(null);
            }
            case 402: {
                if (this.getLegend(null) == null) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 601: {
                return this.getTitle(0);
            }
            case 602: {
                return this.getTitle(1);
            }
            case 603: {
                return this.getFootnote(0);
            }
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                if (text == null) {
                    return null;
                }
                switch (idx) {
                    case 607: 
                    case 609: 
                    case 611: {
                        return new Boolean(text.isVisible());
                    }
                    case 608: 
                    case 610: 
                    case 612: {
                        return text.getText();
                    }
                }
            }
        }
        if (this.legend != null && this.legend.isPropertySupported(idx)) {
            return this.legend.getPropertyValue(idx);
        }
        if (this.chart != null && this.chart.isPropertySupported(idx)) {
            return this.chart.getPropertyValue(idx);
        }
        if (this.xAxis != null && this.xAxis.isPropertySupported(idx)) {
            if (this.selectedAxis == 0) {
                return this.xAxis.getPropertyValue(idx);
            }
            return this.yAxis.getPropertyValue(idx);
        }
        return null;
    }

    @Override
    public boolean setPropertyValue(int idx, Object value) {
        if (this.propertyIndex == null) {
            this.propertyIndex = new ArrayList();
        }
        if (this.isPropertySupported(idx)) {
            int i = this.propertyIndex.indexOf(new Integer(idx));
            if (i >= 0) {
                this.propertyValue.set(i, value);
            } else {
                this.propertyIndex.add(new Integer(idx));
                this.propertyValue.add(value);
            }
            if (idx == 238) {
                if (value instanceof PropertyEvent) {
                    Object obj = ((PropertyEvent)value).value;
                    if (obj instanceof Number) {
                        this.selectedAxis = ((Number)obj).intValue();
                    }
                } else if (value instanceof Number) {
                    this.selectedAxis = ((Number)value).intValue();
                }
            }
        } else {
            if (this.legend != null && this.legend.isPropertySupported(idx)) {
                return this.legend.setPropertyValue(idx, value);
            }
            if (this.chart != null && this.chart.isPropertySupported(idx)) {
                return this.chart.setPropertyValue(idx, value);
            }
            if (this.xAxis != null && this.xAxis.isPropertySupported(idx)) {
                if (this.selectedAxis == 0) {
                    return this.xAxis.setPropertyValue(idx, value);
                }
                if (this.yAxis != null) {
                    return this.yAxis.setPropertyValue(idx, value);
                }
            }
        }
        return true;
    }

    public int getNumberProperties() {
        return 8;
    }

    @Override
    public boolean applyPropertyChanges() {
        this.applyingChanges = true;
        if (this.propertyIndex == null) {
            return false;
        }
        if (this.propertyIndex.size() <= 0) {
            if (this.legend != null) {
                this.legend.applyPropertyChanges();
            }
            if (this.chart != null) {
                this.chart.applyPropertyChanges();
            }
            if (this.xAxis != null) {
                this.xAxis.applyPropertyChanges();
            }
            if (this.yAxis != null) {
                this.yAxis.applyPropertyChanges();
            }
            this.applyingChanges = false;
            this.updateComp = true;
            this.redrawBKBuffer = true;
            this.repaint();
            return true;
        }
        Object startColor = null;
        Object endColor = null;
        block26: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.get(i);
            Object value = this.propertyValue.get(i);
            if (value instanceof PropertyEvent) {
                value = ((PropertyEvent)value).value;
            }
            switch (idx) {
                case 26: {
                    this.wallOn = (Boolean)value;
                    continue block26;
                }
                case 0: {
                    this.setColorScheme(value);
                    continue block26;
                }
                case 2: {
                    if (!(value instanceof Boolean)) continue block26;
                    this.tipsOn = (Boolean)value;
                    continue block26;
                }
                case 3: {
                    if (!(value instanceof Font)) continue block26;
                    this.tooltip.setFontObject((Font)value);
                    continue block26;
                }
                case 4: {
                    this.tooltip.setChartTipTextColor(value);
                    continue block26;
                }
                case 5: {
                    this.tooltip.setChartTipBorderColor(value);
                    continue block26;
                }
                case 6: {
                    this.tooltip.getChartTipBackground().setSolidBackground(value);
                    continue block26;
                }
                case 8: {
                    if (!(value instanceof Double)) continue block26;
                    this.tooltip.setChartTipOpacity((Double)value);
                    continue block26;
                }
                case 21: {
                    this.setSolidBackground(value);
                    continue block26;
                }
                case 13: {
                    startColor = value;
                    continue block26;
                }
                case 14: {
                    endColor = value;
                    continue block26;
                }
                case 15: {
                    this.setGradientBackground(startColor, endColor, value);
                    continue block26;
                }
                case 32: {
                    this.xMargin = value instanceof Number ? ((Number)value).intValue() : this.xMargin;
                    continue block26;
                }
                case 33: {
                    this.yMargin = value instanceof Number ? ((Number)value).intValue() : this.yMargin;
                    continue block26;
                }
                case 34: {
                    boolean vis;
                    if (!(value instanceof Boolean)) continue block26;
                    this.hScrollbarOn = this.vScrollbarOn = (vis = ((Boolean)value).booleanValue());
                    if (this.xHandler != null) {
                        this.xHandler.setZoomPanEnabled(this.hScrollbarOn);
                    }
                    if (this.yHandler == null) continue block26;
                    this.yHandler.setZoomPanEnabled(this.hScrollbarOn);
                    continue block26;
                }
                case 443: {
                    if (!(value instanceof String) && !(value instanceof Number)) continue block26;
                    this.setLegendPosition(null, value);
                    continue block26;
                }
                case 604: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setTitle(0, (TextStyleInterface)value);
                    continue block26;
                }
                case 605: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setTitle(1, (TextStyleInterface)value);
                    continue block26;
                }
                case 606: {
                    if (!(value instanceof TextStyleInterface)) continue block26;
                    this.setFootnote(0, (TextStyleInterface)value);
                    continue block26;
                }
                case 601: 
                case 602: 
                case 603: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 611: 
                case 612: {
                    TextStyleInterface text = idx >= 607 ? this.getTitle(0) : (idx >= 609 ? this.getTitle(1) : this.getFootnote(0));
                    if (text == null) {
                        return false;
                    }
                    switch (idx) {
                        case 607: 
                        case 609: 
                        case 611: {
                            text.setVisible((Boolean)value);
                            break;
                        }
                        case 608: 
                        case 610: 
                        case 612: {
                            text.setText(value);
                        }
                    }
                    continue block26;
                }
            }
        }
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.applyPropertyChanges();
        }
        if (this.chart != null) {
            this.chart.applyPropertyChanges();
        }
        if (this.xAxis != null) {
            this.xAxis.applyPropertyChanges();
        }
        if (this.yAxis != null) {
            this.yAxis.applyPropertyChanges();
        }
        this.applyingChanges = false;
        this.updateComp = true;
        this.redrawBKBuffer = true;
        this.repaint();
        return true;
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        return this.applyPropertyChanges();
    }

    @Override
    public void cancelPropertyChanges() {
        this.propertyIndex.clear();
        this.propertyValue.clear();
        if (this.legend != null) {
            this.legend.cancelPropertyChanges();
        }
        this.chart.cancelPropertyChanges();
        this.xAxis.cancelPropertyChanges();
        this.yAxis.cancelPropertyChanges();
    }

    @Override
    public void cancelPropertyChanges(Object source) {
    }

    @Override
    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.get(i);
        }
        return index;
    }

    @Override
    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    @Override
    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 238: 
            case 260: 
            case 402: 
            case 443: 
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 608: 
            case 609: 
            case 610: 
            case 611: 
            case 612: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPropertyPending(int idx) {
        return false;
    }

    @Override
    public int getNumberPendingProperties() {
        return -1;
    }

    @Override
    public boolean hasUserSetValue(int id) {
        if (this.legend != null && this.legend.isPropertySupported(id)) {
            return this.legend.hasUserSetValue(id);
        }
        if (this.chart != null && this.chart.isPropertySupported(id)) {
            return this.chart.hasUserSetValue(id);
        }
        if (this.xAxis != null && this.xAxis.isPropertySupported(id)) {
            return this.xAxis.hasUserSetValue(id);
        }
        if (this.yAxis != null && this.yAxis.isPropertySupported(id)) {
            return this.yAxis.hasUserSetValue(id);
        }
        return super.hasUserSetValue(id);
    }

    @Override
    public double[] getViewport(int type, int level, int dimension) {
        double[] vport = new double[2];
        switch (dimension) {
            case 1: {
                vport[0] = this.viewportXMin;
                vport[1] = this.viewportXMax;
                break;
            }
            case 2: {
                vport[0] = this.viewportYMin;
                vport[1] = this.viewportYMax;
                break;
            }
            default: {
                return null;
            }
        }
        return vport;
    }

    @Override
    public boolean setViewport(int type, int dimension, double min, double max) {
        switch (dimension) {
            case 1: {
                this.viewportXMin = Math.max(this.dataXMin, min);
                this.viewportXMax = Math.min(this.dataXMax, max);
                break;
            }
            case 2: {
                this.viewportYMin = Math.max(this.dataYMin, min);
                this.viewportYMax = Math.min(this.dataYMax, max);
                break;
            }
            default: {
                return false;
            }
        }
        if (this.chart != null) {
            this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        return true;
    }

    @Override
    public boolean setViewport(int type, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        this.viewportXMin = Math.max(this.dataXMin, xmin);
        this.viewportXMax = Math.min(this.dataXMax, xmax);
        this.viewportYMin = Math.max(this.dataYMin, ymin);
        this.viewportYMax = Math.min(this.dataYMax, ymax);
        if (this.chart != null) {
            this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
        }
        return true;
    }

    public double getZoomFactor(int dimension) {
        return 1.0;
    }

    public boolean setZoomFactor(int dimension, double fac) {
        boolean hori;
        if (fac <= 0.0 || fac > 1.0) {
            return false;
        }
        switch (dimension) {
            case 1: {
                if (this.chart.getOrientation() == 0) {
                    hori = true;
                    break;
                }
                return true;
            }
            case 2: {
                if (this.chart.getOrientation() == 1) {
                    hori = false;
                    break;
                }
                return true;
            }
            case 4: {
                if (this.chart.getOrientation() == 0) {
                    hori = true;
                    break;
                }
                hori = false;
                break;
            }
            default: {
                return false;
            }
        }
        this.zoomFactor = fac;
        this.doDataZoom(hori);
        return true;
    }

    @Override
    public void roleChanged(RoleEvent arg0) {
        this.repaint();
    }

    @Override
    public boolean resetViewport() {
        this.setActionMode(5);
        return true;
    }

    public BoxPlotChart getChart() {
        return this.chart;
    }

    public Object getWall() {
        return this.wall;
    }

    protected void doDataZoom(boolean hori) {
        double rangeX = this.dataXMax - this.dataXMin;
        double rangeY = this.dataYMax - this.dataYMin;
        if (hori && this.chart.getOrientation() == 0) {
            this.viewportXMin = 0.0;
            this.viewportXMax = rangeX * this.zoomFactor;
        } else if (this.chart.getOrientation() == 1) {
            this.viewportYMin = 0.0;
            this.viewportYMax = rangeY * this.zoomFactor;
        }
        this.chart.setBoundingBox(this.viewportXMin, this.viewportYMin, 0.0, this.viewportXMax, this.viewportYMax, 0.0);
    }

    protected void fireRangeChangeEvent(byte dimension) {
        DataRange dr = this.getDataRange(dimension);
        RangeChangedEvent rce = new RangeChangedEvent((Object)this, 3, dr, dimension, dr);
        int numListeners = this.rangeListeners.size();
        if (numListeners > 0) {
            for (int i = 0; i < numListeners; ++i) {
                ((RangeChangeListener)this.rangeListeners.get(i)).rangeChanged(rce);
            }
        }
    }

    protected void fireMarginChangeEvent(boolean inner, boolean outer) {
        int numListeners;
        if (inner) {
            this.chartInnerMargin = null;
        }
        if (outer) {
            this.userSetOuterMargin = false;
        }
        if ((numListeners = this.marginListeners.size()) > 0) {
            MarginChangeEvent mce = new MarginChangeEvent((Object)this);
            if (inner) {
                mce.setInnerChanged(true);
            }
            if (outer) {
                mce.setOuterChanged(true);
            }
            for (int i = 0; i < numListeners; ++i) {
                ((MarginListener)this.marginListeners.get(i)).marginChanged(mce);
            }
        }
    }

    protected void fireViewportChangeEvent() {
        ViewportEvent evt = new ViewportEvent(this, 1, this.viewportXMin, this.viewportXMax, this.viewportYMin, this.viewportYMax, 0.0, 0.0);
        for (int i = 0; i < this.viewportListeners.size(); ++i) {
            ((ViewportListenerInterface)this.viewportListeners.get(i)).viewportChanged(evt);
        }
    }

    @Override
    public void viewportChanged(ViewportEvent evt) {
        if (this.mouseOnXAxis) {
            this.panning = this.xHandler.getCurrentZoomPanStatus() == 0;
            this.setViewport(1, 1, evt.xMin, evt.xMax);
        } else if (this.mouseOnYAxis) {
            this.panning = this.yHandler.getCurrentZoomPanStatus() == 0;
            this.setViewport(1, 2, evt.yMin, evt.yMax);
        }
    }

    @Override
    public Object getId() {
        if (this.id == null) {
            this.id = "BoxPlotParm";
        }
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }
}

