/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk;

import com.sas.graphics.silk.SILKComponent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementGridCellProvider;
import com.sas.graphics.silk.interfaces.BaseComponentInterface;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class BaseElementGridComponent
extends SILKComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 4487067382751975103L;
    protected BaseElementGridCellProvider source = null;
    protected Dimension cellSize = null;
    protected Insets outerMargin = new Insets(3, 3, 3, 3);
    protected Insets innerMargin = new Insets(0, 0, 0, 0);
    protected boolean showLabels = false;
    protected int labelPosition = 3;
    protected String[][] labels = null;
    protected Font labelFont = FontManager.getFont((String)"Dialog", (int)0, (int)12);
    protected Dimension labelBouds = new Dimension(0, 0);
    protected int textMargin = 5;
    private Image backBuffer = null;
    private boolean rolloverEnabled = false;
    private BaseElement mouseOverElement = null;
    private BaseElement selectedElement = null;

    public BaseElementGridComponent() {
    }

    public BaseElementGridComponent(Object source) {
        this.setDataSource(source);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void buildBackBuffer() {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.backBuffer = this.createImage(this.compWidth, this.compHeight);
        }
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        this.drawChart(g);
    }

    private void drawChart(Graphics g) {
        if (this.source == null) {
            return;
        }
        int startX = this.outerMargin.left;
        int startY = this.outerMargin.top;
        int numX = this.source.getNumberColumns();
        int numY = this.source.getNumberRows();
        int cellWidth = this.calculateCellWidth(numX);
        int cellHeight = this.calculateCellHeight(numY);
        int chartWidth = cellWidth - this.innerMargin.right - this.innerMargin.left;
        int chartHeight = cellHeight - this.innerMargin.top - this.innerMargin.bottom;
        if (this.labels == null) {
            this.buildLabels(g);
        }
        for (int i = 0; i < numY; ++i) {
            for (int j = 0; j < numX; ++j) {
                BaseElement element;
                Object o = this.source.getCellElement(j, i);
                if (!(o instanceof BaseElement) || (element = (BaseElement)o) == null) continue;
                element.setBounds(startX + j * cellWidth + this.innerMargin.left, startY + i * cellHeight + this.innerMargin.top, chartWidth, chartHeight);
                element.draw(g, false);
                if (!this.showLabels) continue;
                this.drawLabel(g, element);
            }
        }
        this.graphLayout.draw(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.compWidth <= 0 || this.compHeight <= 0) {
            return;
        }
        if (this.backBuffer == null) {
            this.buildBackBuffer();
        }
        g.drawImage(this.backBuffer, 0, 0, null);
        if (this.rolloverEnabled && this.mouseOverElement != null) {
            g.setColor(Color.black);
            g.drawRect(this.mouseOverElement.getBounds().x, this.mouseOverElement.getBounds().y, this.mouseOverElement.getBounds().width, this.mouseOverElement.getBounds().height);
        }
    }

    private void drawLabel(Graphics g, BaseElement element) {
        int x = 0;
        int y = 0;
        Rectangle bounds = element.getBounds();
        FontRenderContext frc = null;
        if (g instanceof Graphics2D) {
            frc = ((Graphics2D)g).getFontRenderContext();
        } else if (this.getGraphics() instanceof Graphics2D) {
            frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        }
        Rectangle2D rect = this.labelFont.getStringBounds(element.getId().toString(), frc);
        switch (this.labelPosition) {
            case 1: {
                x = bounds.x + 5;
                y = bounds.y + this.textMargin;
                break;
            }
            case 5: {
                x = bounds.x + 5;
                y = bounds.y + bounds.height;
                break;
            }
            case 3: {
                x = bounds.x + bounds.width + this.textMargin;
                y = bounds.y + bounds.height - (int)((double)bounds.height - rect.getHeight()) / 2;
                break;
            }
            case 7: {
                x = bounds.x;
                y = bounds.y;
            }
        }
        g.setFont(this.labelFont);
        g.setColor(this.style.getTextStyleElement("LabelText").getTextColor());
        g.drawString(element.getId().toString(), x, y);
    }

    private void buildLabels(Graphics g) {
        if (!this.showLabels || this.source == null) {
            return;
        }
        FontRenderContext frc = null;
        if (g instanceof Graphics2D) {
            frc = ((Graphics2D)g).getFontRenderContext();
        } else if (this.getGraphics() instanceof Graphics2D) {
            frc = ((Graphics2D)this.getGraphics()).getFontRenderContext();
        }
        this.labelBouds.width = 0;
        this.labelBouds.height = 0;
        for (int i = 0; i < this.source.getNumberColumns(); ++i) {
            for (int j = 0; j < this.source.getNumberRows(); ++j) {
                Rectangle2D rect;
                BaseElement obj;
                Object o = this.source.getCellElement(i, j);
                if (!(o instanceof BaseElement) || (obj = (BaseElement)o) == null) continue;
                String str = obj.toString();
                if (obj instanceof BaseComponentInterface && obj.getId() != null) {
                    str = obj.getId().toString();
                }
                if ((rect = this.labelFont.getStringBounds(str, frc)).getWidth() > (double)this.labelBouds.width) {
                    this.labelBouds.width = (int)rect.getWidth();
                }
                if (!(rect.getHeight() > (double)this.labelBouds.height)) continue;
                this.labelBouds.height = (int)rect.getHeight();
            }
        }
        Insets margin = new Insets(0, 0, 0, 0);
        switch (this.labelPosition) {
            case 1: {
                margin.top += this.labelBouds.height + 2 * this.textMargin;
                break;
            }
            case 5: {
                margin.bottom += this.labelBouds.height + 2 * this.textMargin;
                break;
            }
            case 3: {
                margin.right += this.labelBouds.width + 2 * this.textMargin;
                break;
            }
            case 7: {
                margin.left += this.labelBouds.width + 2 * this.textMargin;
            }
        }
        for (int i = 0; i < this.source.getNumberColumns(); ++i) {
            for (int j = 0; j < this.source.getNumberRows(); ++j) {
                BaseElement obj;
                Object o = this.source.getCellElement(i, j);
                if (!(o instanceof BaseElement) || (obj = (BaseElement)o) == null) continue;
                obj.setOuterMargin(margin);
            }
        }
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int labelPosition) {
        this.labelPosition = labelPosition;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    private int calculateCellWidth(int numX) {
        if (numX <= 0) {
            return 0;
        }
        int rc = this.getWidth();
        rc -= this.outerMargin.left;
        rc -= this.outerMargin.right;
        return rc /= numX;
    }

    private int calculateCellHeight(int numY) {
        if (numY <= 0) {
            return 0;
        }
        int rc = this.getHeight();
        rc -= this.outerMargin.bottom;
        rc -= this.outerMargin.top;
        return rc /= numY;
    }

    @Override
    public boolean setDataSource(Object source) {
        if (!(source instanceof BaseElementGridCellProvider)) {
            return false;
        }
        this.source = (BaseElementGridCellProvider)source;
        this.init();
        return true;
    }

    @Override
    public Object getDataSource() {
        return this.source;
    }

    private void init() {
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }

    public boolean setCellSize(int width, int height) {
        this.cellSize.setSize(width, height);
        return true;
    }

    public Insets getOuterMargin() {
        return new Insets(this.outerMargin.top, this.outerMargin.left, this.outerMargin.bottom, this.outerMargin.right);
    }

    protected void setOuterMargin(Insets i) {
        if (i == null) {
            return;
        }
        this.outerMargin.top = i.top;
        this.outerMargin.left = i.left;
        this.outerMargin.bottom = i.bottom;
        this.outerMargin.right = i.right;
    }

    public Insets getInnerMargin() {
        return new Insets(this.innerMargin.top, this.innerMargin.left, this.innerMargin.bottom, this.innerMargin.right);
    }

    protected void setInnerMargin(Insets i) {
        if (i == null) {
            return;
        }
        this.innerMargin.top = i.top;
        this.innerMargin.left = i.left;
        this.innerMargin.bottom = i.bottom;
        this.innerMargin.right = i.right;
    }

    public BaseElement getElementForLocation(int x, int y) {
        for (int i = 0; i < this.source.getNumberColumns(); ++i) {
            for (int j = 0; j < this.source.getNumberRows(); ++j) {
                BaseElement e;
                Object o = this.source.getCellElement(i, j);
                if (!(o instanceof BaseElement) || (e = (BaseElement)o) == null || !e.getBounds().contains(x, y)) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    protected void doResize(int compWidthIn, int compHeightIn) {
        this.backBuffer = null;
        super.doResize(compWidthIn, compHeightIn);
        this.computeMargins();
    }

    private void computeMargins() {
        Rectangle bounds = this.getBounds();
        Rectangle ca = this.graphLayout.getChartArea();
        this.outerMargin.top = ca.y;
        this.outerMargin.left = ca.x;
        this.outerMargin.right = bounds.width - (ca.x + ca.width);
        this.outerMargin.bottom = bounds.height - (ca.y + ca.height);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.selectedElement != null) {
            this.selectedElement.setSelected(false);
        }
        this.selectedElement = this.getElementForLocation(e.getX(), e.getY());
        if (this.selectedElement != null) {
            this.selectedElement.setSelected(true);
        }
        this.backBuffer = null;
        this.mouseOverElement = this.getElementForLocation(e.getX(), e.getY());
        super.mouseClicked(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseOverElement = this.getElementForLocation(e.getX(), e.getY());
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseOverElement = null;
        super.mouseExited(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseOverElement = this.getElementForLocation(e.getX(), e.getY());
        super.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseOverElement = this.getElementForLocation(e.getX(), e.getY());
        super.mouseMoved(e);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        BaseElement be = this.getElementForLocation(me.getX(), me.getY());
        if (be == null) {
            return null;
        }
        return be.getId().toString();
    }

    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        this.rolloverEnabled = rolloverEnabled;
    }
}

