/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.tablecomparator;

import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.ComparisonTemplateNodeInterface;
import com.sas.metadata.logical.table.ComparisonObjectNode;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.tools.tablecomparator.ComparisonControllerFactory;
import com.sas.metadata.tools.tablecomparator.ComparisonResultObjectPool;
import com.sas.metadata.tools.tablecomparator.HashedComparisonResultNode;
import com.sas.metadata.tools.tablecomparator.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultController
implements ComparisonControllerInterface {
    ComparisonControllerFactory factory;
    Map comparisionResultMap = new HashMap();
    Map tableIdToTableObject = new HashMap();
    List<String> comparedObjects = null;
    private static ComparisonResultObjectPool resultPool;

    DefaultController(ComparisonControllerFactory factory) {
        this.factory = factory;
    }

    @Override
    public Log getLogger() {
        return this.factory.getImportOperation().getLogger();
    }

    @Override
    public ComparisonResultNodeInterface getComparisonResult(String objectId) {
        CMetadata targetTable = (CMetadata)this.tableIdToTableObject.get(objectId);
        ComparisonObjectNode node = (ComparisonObjectNode)this.comparisionResultMap.get(targetTable);
        ComparisonResultNodeInterface retNode = HashedComparisonResultNode.constructRootNode(objectId);
        return retNode;
    }

    @Override
    public ComparisonTemplateNodeInterface getComparisonTemplate(String logicalObject) throws ComparisonConfigurationException {
        return this.factory.getComparisonTemplate();
    }

    @Override
    public List<String> getObjects() {
        return this.comparedObjects;
    }

    static ComparisonResultObjectPool getResultObjectsPool() {
        return resultPool;
    }

    @Override
    public List<String> getObjectComparison(List objects) throws RemoteException, MdException, ComparisonConfigurationException, MetadataPromotionException {
        Map mapExternalFiles = this.factory.getImportOperation().getAssociationsForObjects(objects, this.factory.getDeploymentTemplate());
        CMetadata targetTable = null;
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2 && importItem.getImportState() != 0) continue;
            Map mapExtFile = (Map)mapExternalFiles.get(importItem.getID());
            try {
                targetTable = this.getTargetTable(this.factory.getImportOperation().getStore(), importItem);
            }
            catch (MdException e) {
                this.getLogger().warn((Object)Message.format((String)RB.getStringResource("DefaultController.GetTargetTable.Warning.fmt.txt"), (Object)importItem.getName(), (Object)e.getMessage()));
                targetTable = null;
            }
            if (targetTable == null) continue;
            ComparisonObjectNode ResultNode = new ComparisonObjectNode(targetTable, mapExtFile, this.factory.getImportOperation(), importItem, this.factory.getDeploymentTemplate(), this.factory.getMetadataExtractionTemplate());
            this.comparisionResultMap.put(targetTable, ResultNode);
            this.tableIdToTableObject.put(targetTable.getName(), targetTable);
            if (this.comparedObjects == null) {
                this.comparedObjects = new ArrayList<String>();
            }
            this.comparedObjects.add(targetTable.getName());
        }
        resultPool = ComparisonResultObjectPool.getObjectPool(this.comparisionResultMap);
        return this.comparedObjects;
    }

    private CMetadata getTargetTable(MdObjectStore mdStore, ImportItemInterface importItem) throws RemoteException, MdException, ComparisonConfigurationException {
        CMetadata returnValue = null;
        returnValue = this.getTableMetadataObject(mdStore, importItem.getTypeInterface().getMetadataType(), importItem.getTargetID(), this.factory.getMetadataExtractionTemplate());
        return returnValue;
    }

    private CMetadata getTableMetadataObject(MdObjectStore store, String type, String fqid, String template) throws MdException, RemoteException {
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return object;
    }

    @Override
    public String getType() {
        return this.factory != null ? this.factory.getType() : null;
    }
}

