/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.tools.tablecomparator;

import com.sas.metadata.logical.comparison.ComparisonResultsException;
import com.sas.metadata.logical.table.ComparisonObjectNode;
import com.sas.metadata.remote.CMetadata;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ComparisonResultObjectPool {
    private Map<CMetadata, ComparisonObjectNode> comparisonPool;
    private Map<String, CMetadata> poolKeys;

    private ComparisonResultObjectPool(Map<CMetadata, ComparisonObjectNode> comparisons) {
        this.comparisonPool = comparisons;
        if (comparisons != null) {
            this.poolKeys = new HashMap<String, CMetadata>();
            Iterator<CMetadata> objectKeys = comparisons.keySet().iterator();
            CMetadata object = null;
            while (objectKeys.hasNext()) {
                object = objectKeys.next();
                try {
                    this.poolKeys.put(object.getName(), object);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ComparisonResultObjectPool getObjectPool(Map<CMetadata, ComparisonObjectNode> comparisons) {
        return new ComparisonResultObjectPool(comparisons);
    }

    public Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, Map<String, String>>>>>>> getAssociationComparisonResult(String objectId) throws ComparisonResultsException {
        ComparisonObjectNode comparison = this.getComparisonObjectNode(objectId);
        return comparison.getAssocComparisonResult();
    }

    public Map<String, Map<String, String>> getNodeComparisonResult(String objectId) throws ComparisonResultsException {
        ComparisonObjectNode comparison = this.getComparisonObjectNode(objectId);
        return comparison.getNodeComparisonResult();
    }

    public void addObject(CMetadata objectId, ComparisonObjectNode result) {
        this.comparisonPool.put(objectId, result);
    }

    ComparisonObjectNode getComparisonObjectNode(String objectId) throws ComparisonResultsException {
        if (!this.poolKeys.containsKey(objectId)) {
            throw new ComparisonResultsException("Comparison result for Object " + objectId + " not found in the pool");
        }
        CMetadata object = this.poolKeys.get(objectId);
        return this.comparisonPool.get(object);
    }
}

