/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.logical.table.Table;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SecurityUtil;
import com.sas.util.UsageVersion;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

@SASScope
public class TableUtil {
    public static final String CONTENT_PROPERTY_KEY = "Content";
    public static final String TABLENAME_PROPERTY_KEY = "SASTableName";
    public static final String PHYSICAL_TABLE_KEY = "###PHYSICALTABLE###";
    public static final String SCD_X_TABLE_KEY = "###SCDXTABLE###";
    static final String METADATA_CHANGES = "METADATA_CHANGES";
    static final String LIB_HAS_NO_APP_SERVER = "LibHasNoAppServer";
    public static final String TABLENAME_DEPLOYMENT_TEMPLATE = "<Template><PhysicalTable SASTableName=\"\"/></Template>";
    public static final String TABLE_DEPENDENCIES_TEMPLATE = "<Templates><PhysicalTable><Columns/><Documents/><Notes/><ResponsibleParties/><PropertySets/><TablePackage/></PhysicalTable><Column><Documents/><Notes/></Column><PropertySet><Properties/></PropertySet><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></Templates>";
    public static final String TABLE_COLUMNS_DEPLOYMENT_TEMPLATE = "<Template><PhysicalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></PhysicalTable><RelationalTable Name=\"\" ><Columns><Column Name=\"\" SASColumnType=\"\"></Column></Columns></RelationalTable></Template>";
    public static final String PHYSICALTABLE_EXPORTCONTENT_TEMPLATE = "<Templates><PhysicalTable><TablePackage><SASLibrary/><DatabaseSchema/></TablePackage><Roles/><PropertySets><PropertySet/></PropertySets></PhysicalTable></Templates>";
    public static final String DATABASESCHEMA_CONTENT_TEMPLATE = "<Templates><DatabaseSchema><Tables/><UsedByPackages/></DatabaseSchema></Templates>";
    public static final String SASLIBRARY_CONTENT_TEMPLATE = "<Templates><SASLibrary><UsingPackages/></SASLibrary><DatabaseSchema/></Templates>";
    public static final String PHYSICALTABLE_IMPORTCONTENT_TEMPLATE = "<Templates><PhysicalTable><TablePackage><SASLibrary/><DatabaseSchema/></TablePackage></PhysicalTable></Templates>";
    public static final String PHYSICALTABLE_DEPLOYMENT_PARSE_TEMPLATE = "<Template><PhysicalTable><TablePackage><DatabaseSchema><UsedByPackages><SASLibrary/></UsedByPackages></DatabaseSchema></TablePackage></PhysicalTable></Template>";
    public static final String PHYSICALTABLE_IMPORTKEYS_TEMPLATE = "<Templates><PhysicalTable><ForeignKeys/></PhysicalTable><ForeignKey><PartnerUniqueKey/></ForeignKey></Templates>";
    public static final String PHYSICALTABLE_PROMPTS_TEMPLATE = "<Templates><PhysicalTable><PropertySets/><Prompts/></PhysicalTable></Templates>";
    public static final String TABLE_COLUMN_DEPENDENCIES_TEMPLATE = "<Templates><PhysicalTable><Columns/></PhysicalTable><Column><Documents/><Notes/><SourceFeatureMaps/><TargetFeatureMaps/><Keys/><QueryClauses/><ReferencedObjects/><SpecSourceTransformations/><SpecTargetTransformations/><Variables/></Column></Templates>";
    public static final String TABLE_METADATASERVER_TEMPLATE = "<Templates><PhysicalTable><Columns/><ForeignKeys/><Indexes/><Notes/><UniqueKeys/></PhysicalTable><Column><Keys/></Column><ForeignKey><KeyedColumns/></ForeignKey><UniqueKey><KeyedColumns/></UniqueKey><Index><Columns/></Index></Templates>";
    public static final String SOURCE_LIBRARY = "SourceLibrary";
    public static final Object PORT_APP_SERVER = "PORT_APPLICATION_SERVER";

    public static String genNameLiterals(String sTableName) {
        if (sTableName.indexOf("&") < 0 && sTableName.indexOf("\"") > -1) {
            return "'" + sTableName + "'n";
        }
        return "\"" + sTableName + "\"n";
    }

    public static boolean isTableNameUniqueToLibrary(ImportOperationInterface importOperation, ImportItemInterface importItem, String tableName, ConnectionPointInterface library, String repID) throws MdException {
        boolean returnValue = false;
        try {
            String libraryId = library.getTargetID();
            RelationalSchema libraryObject = (RelationalSchema)importOperation.getStore().getObject(library.getTargetID());
            if (libraryObject == null && libraryId != null) {
                int options = 16668;
                libraryObject = (RelationalSchema)importOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)importOperation.getStore(), library.getMetadataType(), library.getTargetID(), null, null, SASLIBRARY_CONTENT_TEMPLATE, options);
                if (libraryObject == null) {
                    importOperation.getLogger().debug((Object)("Unable to find Library: " + library.getName()));
                }
            }
            if (libraryObject != null) {
                Object obj;
                AssociationList packages;
                if (libraryObject instanceof SASLibrary && (packages = ((SASLibrary)libraryObject).getUsingPackages()) != null && packages.size() == 1 && (obj = packages.get(0)) instanceof RelationalSchema) {
                    libraryObject = (RelationalSchema)packages.get(0);
                }
                String schemaType = libraryObject.getCMetadataType();
                String xmlSelect = TableUtil.buildXMLSelectForTable(tableName, libraryObject.getId(), schemaType);
                ISecurity isec = importOperation.getISecurity();
                int count = SecurityUtil.getCountNoSecurity((ISecurity)isec, (String)repID, (String)xmlSelect, (String)importItem.getTypeInterface().getMetadataType(), (int)24576);
                if (count == 0) {
                    returnValue = true;
                }
            } else {
                returnValue = true;
            }
        }
        catch (RemoteException re) {
            MdException me = new MdException((Throwable)re);
            throw me;
        }
        return returnValue;
    }

    private static String buildXMLSelectForTable(String tableName, String libraryId, String schemaType) {
        StringBuffer sb = new StringBuffer();
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.cleanStringForXML((String)tableName));
        sb.append("'][");
        sb.append("TablePackage/");
        sb.append(schemaType);
        sb.append("[@Id='");
        sb.append(libraryId);
        sb.append("']]");
        sb.append("\"/>");
        return sb.toString();
    }

    static int deleteColumns(MdObjectStore store, List<String> columnIds) throws MdException, RemoteException {
        for (String columnId : columnIds) {
            store.getFactory().getOMIUtil().deleteMetadataObject("Column", columnId);
        }
        return 0;
    }

    static void genNoAppserverAssignmentWarning(PromotionInterface operation, SASLibrary currentLibrary, boolean bLibHasNoAppServer) {
        if (bLibHasNoAppServer) {
            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportExportListener.LibraryNoAppServerWarning.txt"), (Object)currentLibrary));
        }
    }

    static String generateTableReferenceName(PhysicalTable table, String strLibRef) throws RemoteException {
        String infoTableRefName = table.getName() + " (" + strLibRef + "." + table.getSASTableName() + ")";
        return infoTableRefName;
    }

    static int displayErrorsFromSAS(PromotionInterface operation, LogListHolder llhSASLog) {
        int returnValue = 0;
        try {
            if (llhSASLog != null) {
                String[] saSASLogLines = llhSASLog.getLineArray();
                LineType[] ltaSASLogLineTypes = llhSASLog.getLineTypes();
                for (int j = 0; j < saSASLogLines.length; ++j) {
                    if (ltaSASLogLineTypes[j] != LineType.LineTypeError || saSASLogLines[j].equals(saSASLogLines[j - 1])) continue;
                    operation.getLogger().error((Object)saSASLogLines[j]);
                    if (returnValue == 8) continue;
                    returnValue = 8;
                }
            }
        }
        catch (Exception asfx) {
            operation.getLogger().error((Object)asfx.getLocalizedMessage());
        }
        return returnValue;
    }

    static int handleSASException(PromotionInterface operation, Exception e, LogListHolder llhSASLog) {
        int returnValue = 8;
        operation.getLogger().error((Object)e.getLocalizedMessage());
        return returnValue |= TableUtil.displayErrorsFromSAS(operation, llhSASLog);
    }

    static int getSourceLibrary(PromotionInterface operation, PhysicalTable o_PTable, Map values) throws RemoteException {
        int returnValue = 0;
        SASLibrary sourceLibrary = null;
        try {
            DatabaseSchema m_currentSchema = null;
            RelationalSchema assocMetadata = null;
            AssociationList tempLst = o_PTable.getTablePackages();
            if (tempLst.size() > 0 && (assocMetadata = (RelationalSchema)tempLst.get(0)) != null) {
                if (assocMetadata instanceof SASLibrary) {
                    sourceLibrary = (SASLibrary)assocMetadata;
                } else if (assocMetadata instanceof DatabaseSchema) {
                    m_currentSchema = (DatabaseSchema)assocMetadata;
                    AssociationList usedByPackages = m_currentSchema.getUsedByPackages(true);
                    if (usedByPackages.size() > 0) {
                        assocMetadata = (RelationalSchema)usedByPackages.get(0);
                        if (assocMetadata instanceof SASLibrary) {
                            sourceLibrary = (SASLibrary)assocMetadata;
                        }
                    } else {
                        sourceLibrary = null;
                    }
                }
            }
        }
        catch (MdException ex) {
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            returnValue = 8;
        }
        if (sourceLibrary != null) {
            values.put(SOURCE_LIBRARY, sourceLibrary);
        }
        return returnValue;
    }

    static StringBuffer getBufferFromAppLog(LogListHolder logHolder) {
        StringBuffer logBuffer = new StringBuffer();
        String[] logLines = logHolder.getLineArray();
        for (int i = 0; i < logLines.length; ++i) {
            logBuffer.append(logLines[i]).append("\n");
        }
        return logBuffer;
    }

    static int displayWarningsFromSAS(PromotionInterface operation, LogListHolder llhSASLog) {
        int returnValue = 0;
        try {
            if (llhSASLog != null) {
                String[] saSASLogLines = llhSASLog.getLineArray();
                LineType[] ltaSASLogLineTypes = llhSASLog.getLineTypes();
                for (int j = 0; j < saSASLogLines.length; ++j) {
                    if (ltaSASLogLineTypes[j] != LineType.LineTypeWarning || saSASLogLines[j].indexOf("VALIDVARNAME") >= 0 || saSASLogLines[j - 1].indexOf("VALIDVARNAME") >= 0 || saSASLogLines[j + 1].indexOf("VALIDVARNAME") >= 0) continue;
                    operation.getLogger().warn((Object)saSASLogLines[j]);
                    returnValue = 4;
                }
            }
        }
        catch (Exception asfx) {
            operation.getLogger().error((Object)asfx.getLocalizedMessage());
        }
        return returnValue;
    }

    static PhysicalTable getTableMetadataObject(MdObjectStore store, String type, String fqid, String template) throws MdException, RemoteException {
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return (PhysicalTable)object;
    }

    static boolean setPublicTypeAndVersion(PhysicalTable table) throws RemoteException, MdException {
        boolean usageVersionChanged;
        boolean bMetadataChanges = false;
        boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)table, (String)"Table");
        if (publicTypeChanged) {
            bMetadataChanges = true;
        }
        if (usageVersionChanged = UtilMetadata.setUsageVersion((Root)table, (UsageVersion)Table.FAILED_MIGRATION_VERSION)) {
            bMetadataChanges = true;
        }
        AssociationList columns = table.getColumns();
        for (Column col : columns) {
            boolean colUsageVersionChanged;
            boolean colPublicTypeChanged = UtilMetadata.setPublicType((PrimaryType)col, (String)"Column");
            if (colPublicTypeChanged) {
                bMetadataChanges = true;
            }
            if (!(colUsageVersionChanged = UtilMetadata.setUsageVersion((Root)col, (UsageVersion)Table.FAILED_MIGRATION_VERSION))) continue;
            bMetadataChanges = true;
        }
        return bMetadataChanges;
    }

    static int assignLibraryAndServer(PromotionInterface operation, WsAppServer currentAppServer, PhysicalTable pTable, Map exportProperties) {
        int localRC = 0;
        boolean bLibHasNoAppServer = false;
        SASLibrary currentLibrary = null;
        WsAppServer cportAppServer = null;
        exportProperties.put(LIB_HAS_NO_APP_SERVER, Boolean.FALSE);
        try {
            SASLibrary sourceLibrary;
            localRC = TableUtil.getSourceLibrary(operation, pTable, exportProperties);
            currentLibrary = sourceLibrary = (SASLibrary)exportProperties.get(SOURCE_LIBRARY);
            if (localRC == 8) {
                return localRC;
            }
            if (currentLibrary != null && pTable.getSASTableName().length() > 0) {
                if (currentLibrary.getDeployedComponents().size() < 1) {
                    bLibHasNoAppServer = true;
                    exportProperties.put(LIB_HAS_NO_APP_SERVER, Boolean.TRUE);
                }
                if ((sourceLibrary = LibraryUtil.getClientLibrary((SASLibrary)currentLibrary, (WsAppServer)currentAppServer)) == null) {
                    TableUtil.genNoAppserverAssignmentWarning(operation, currentLibrary, bLibHasNoAppServer);
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.GetClientLibError.txt"), (Object)currentLibrary));
                    localRC = 8;
                    return localRC;
                }
                exportProperties.put(SOURCE_LIBRARY, sourceLibrary);
                cportAppServer = LibraryUtil.interactiveAccessPath((SASLibrary)sourceLibrary, (WsAppServer)currentAppServer, (String)"", (!operation.isBatchProcess() ? 1 : 0) != 0);
                exportProperties.put(PORT_APP_SERVER, cportAppServer);
            } else {
                if (currentLibrary == null) {
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.NullLibraryError.txt"), (Object)pTable.getName()));
                }
                if (pTable.getSASTableName().length() < 0) {
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.NoTableNameError.txt"), (Object)pTable.getName()));
                }
                localRC = 8;
            }
        }
        catch (WsAppServerLibraryException acx) {
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), currentLibrary));
            operation.getLogger().error((Object)acx.getLocalizedMessage());
            TableUtil.genNoAppserverAssignmentWarning(operation, currentLibrary, bLibHasNoAppServer);
            if (cportAppServer != null) {
                try {
                    LogListHolder llhSASLog = cportAppServer.getLog();
                    localRC |= TableUtil.displayWarningsFromSAS(operation, llhSASLog);
                    localRC |= TableUtil.displayErrorsFromSAS(operation, llhSASLog);
                }
                catch (WsAppServerFailException e) {
                    e.printStackTrace();
                }
            }
            localRC = 8;
            operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), (Object)currentLibrary), (Throwable)acx);
        }
        catch (WsAppServerCodeException acx) {
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), currentLibrary));
            if (cportAppServer != null) {
                try {
                    LogListHolder llhSASLog = cportAppServer.getLog();
                    localRC |= TableUtil.displayWarningsFromSAS(operation, llhSASLog);
                    localRC |= TableUtil.displayErrorsFromSAS(operation, llhSASLog);
                }
                catch (WsAppServerFailException e) {
                    e.printStackTrace();
                }
            }
            operation.getLogger().error((Object)acx.getLocalizedMessage());
            TableUtil.genNoAppserverAssignmentWarning(operation, currentLibrary, bLibHasNoAppServer);
            localRC = 8;
            operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), (Object)currentLibrary), (Throwable)acx);
        }
        catch (Exception ex) {
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), currentLibrary));
            TableUtil.genNoAppserverAssignmentWarning(operation, currentLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            operation.getLogger().debug((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.AsgLibFailureError.txt"), (Object)currentLibrary), (Throwable)ex);
            localRC = 8;
        }
        return localRC;
    }

    public static String generateColumnUniqueId(Column column) throws RemoteException {
        return TableUtil.generateColumnUniqueId(column, true);
    }

    public static String generateColumnUniqueId(Column column, boolean ignoreCase) throws RemoteException {
        String name = ignoreCase ? column.getName().toUpperCase() : column.getName();
        String columnUniqueId = column.getSASColumnType() + "::##::" + name;
        return columnUniqueId;
    }

    public static String generateColumnUniqueId(Map columnMap) throws RemoteException {
        return TableUtil.generateColumnUniqueId(columnMap, true);
    }

    public static String generateColumnUniqueId(Map columnMap, boolean ignoreCase) throws RemoteException {
        String sasColumnType = (String)columnMap.get("SASColumnType");
        String name = (String)columnMap.get("Name");
        if (ignoreCase) {
            name = name.toUpperCase();
        }
        String columnUniqueId = sasColumnType + "::##::" + name;
        return columnUniqueId;
    }
}

