/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;

class TableTristateCheckBox
extends JCheckBox {
    private final TristateDecorator model;
    private boolean isCycleThroughAllStates = true;

    public TableTristateCheckBox(String text, Icon icon, CheckedState initial) {
        super(text, icon);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TableTristateCheckBox.this.grabFocus();
                TableTristateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("pressed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableTristateCheckBox.this.grabFocus();
                TableTristateCheckBox.this.model.nextState();
            }
        });
        map.put("released", null);
        SwingUtilities.replaceUIActionMap(this, map);
        this.model = new TristateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(initial);
    }

    public TableTristateCheckBox(String text, CheckedState initial) {
        this(text, null, initial);
    }

    public TableTristateCheckBox(String text) {
        this(text, CheckedState.MIXED);
    }

    public TableTristateCheckBox() {
        this((String)null);
    }

    @Override
    public void addMouseListener(MouseListener l) {
    }

    public void setState(CheckedState checkedState) {
        this.model.setState(checkedState);
    }

    public CheckedState getState() {
        return this.model.getState();
    }

    @Override
    public void setSelected(boolean b) {
        if (b) {
            this.setState(CheckedState.ON);
        } else {
            this.setState(CheckedState.OFF);
        }
    }

    public void setCycleThroughAllStates(boolean value) {
        this.isCycleThroughAllStates = value;
    }

    private class TristateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private TristateDecorator(ButtonModel other) {
            this.other = other;
        }

        private void setState(CheckedState checkedState) {
            if (checkedState == CheckedState.OFF) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            } else if (checkedState == CheckedState.ON) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            }
        }

        private CheckedState getState() {
            if (this.isSelected() && !this.isArmed()) {
                return CheckedState.ON;
            }
            if (this.isSelected() && this.isArmed()) {
                return CheckedState.MIXED;
            }
            return CheckedState.OFF;
        }

        private void nextState() {
            CheckedState current = this.getState();
            if (current == CheckedState.OFF) {
                this.setState(CheckedState.ON);
            } else if (current == CheckedState.ON) {
                if (TableTristateCheckBox.this.isCycleThroughAllStates) {
                    this.setState(CheckedState.MIXED);
                } else {
                    this.setState(CheckedState.OFF);
                }
            } else if (current == CheckedState.MIXED) {
                this.setState(CheckedState.OFF);
            }
        }

        @Override
        public void setArmed(boolean b) {
        }

        @Override
        public void setEnabled(boolean b) {
            TableTristateCheckBox.this.setFocusable(b);
            this.other.setEnabled(b);
        }

        @Override
        public boolean isArmed() {
            return this.other.isArmed();
        }

        @Override
        public boolean isSelected() {
            return this.other.isSelected();
        }

        @Override
        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        @Override
        public boolean isPressed() {
            return this.other.isPressed();
        }

        @Override
        public boolean isRollover() {
            return this.other.isRollover();
        }

        @Override
        public void setSelected(boolean b) {
            this.other.setSelected(b);
        }

        @Override
        public void setPressed(boolean b) {
            this.other.setPressed(b);
        }

        @Override
        public void setRollover(boolean b) {
            this.other.setRollover(b);
        }

        @Override
        public void setMnemonic(int key) {
            this.other.setMnemonic(key);
        }

        @Override
        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        @Override
        public void setActionCommand(String s) {
            this.other.setActionCommand(s);
        }

        @Override
        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        @Override
        public void setGroup(ButtonGroup group) {
            this.other.setGroup(group);
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.other.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.other.removeActionListener(l);
        }

        @Override
        public void addItemListener(ItemListener l) {
            this.other.addItemListener(l);
        }

        @Override
        public void removeItemListener(ItemListener l) {
            this.other.removeItemListener(l);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.other.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.other.removeChangeListener(l);
        }

        @Override
        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    public static enum CheckedState {
        OFF,
        ON,
        MIXED;

    }
}

