/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.table.TableUtil;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.MdException;
import java.rmi.RemoteException;
import java.util.List;

@SASScope
public class TableNameValidator
implements ImportNameValidatorInterface {
    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean isUnique = true;
        String proposedName = importItem.getName();
        if (importItem.getImportState() == 1) {
            List connectionPoints = importItem.getConnectionPoints();
            for (int i = 0; i < connectionPoints.size(); ++i) {
                ConnectionPointInterface pt = (ConnectionPointInterface)connectionPoints.get(i);
                if (pt == null) continue;
                if ("SASLibrary".equals(pt.getMetadataType()) || "DatabaseSchema".equals(pt.getMetadataType())) {
                    try {
                        isUnique = TableUtil.isTableNameUniqueToLibrary(importOperation, importItem, proposedName, pt, importOperation.getFoundationRepositoryID());
                    }
                    catch (RemoteException re) {
                        throw new MdException((Throwable)re);
                    }
                }
                if (!isUnique) break;
            }
        }
        return isUnique;
    }
}

