/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.editor.LogListHolder;
import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.logical.table.TableExportItem;
import com.sas.metadata.logical.table.TableImportListener;
import com.sas.metadata.logical.table.TableOptionsPanel;
import com.sas.metadata.logical.table.TableUtil;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertySet;
import com.sas.metadata.remote.Role;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.TransportException;
import com.sas.wadmin.visuals.ParametersModel;
import com.sas.workspace.DBMSNamesUtil;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

@SASScope
class TableExportListener
extends AbstractExportListener
implements PromotionOptionsInterface {
    private TableOptionsPanel m_pnlOptions;

    public TableExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return TableImportListener.CONNECTION_TYPES;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new TableExportItem(name, id, type);
    }

    public int exportContent(ExportOperationInterface operation, List lTableExportItems) throws TransportException, IOException, MdException, RemoteException {
        int iRC = 0;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        if (operation.getPromotionType() == 2) {
            return iRC;
        }
        boolean bVVNsubmitted = false;
        WsAppServer currentAppServer = null;
        for (int i = 0; i < lTableExportItems.size(); ++i) {
            int localRC = 0;
            HashMap exportProperties = new HashMap();
            Object defaultExportedItem = lTableExportItems.get(i);
            if (!(defaultExportedItem instanceof TableExportItem)) continue;
            TableExportItem exportItem = (TableExportItem)((Object)lTableExportItems.get(i));
            String sSourceFqid = exportItem.getID();
            if (!exportItem.m_bContentIncluded) {
                PromotionPropertiesFile ppf = operation.getPropertiesFile();
                ppf.addProperty(sSourceFqid + "Content", "false");
                continue;
            }
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("TableExportListener.StatusIndicator.fmt.txt"), (Object)exportItem.getName()));
            if (currentAppServer == null && (currentAppServer = WsAppServer.createDefaultAppServer((!operation.isBatchProcess() ? 1 : 0) != 0)) == null) {
                operation.getLogger().error((Object)RB.getStringResource("TableImportListener.DefaultAppServerError.txt"));
                return 8;
            }
            PhysicalTable pTable = TableUtil.getTableMetadataObject(operation.getStore(), "PhysicalTable", sSourceFqid, "<Templates><PhysicalTable><TablePackage><SASLibrary/><DatabaseSchema/></TablePackage><Roles/><PropertySets><PropertySet/></PropertySets></PhysicalTable></Templates>");
            localRC = TableUtil.assignLibraryAndServer((PromotionInterface)operation, currentAppServer, pTable, exportProperties);
            iRC |= localRC;
            if (localRC != 0) continue;
            String strLibRef = null;
            SASLibrary sourceLibrary = (SASLibrary)exportProperties.get("SourceLibrary");
            if (sourceLibrary != null) {
                strLibRef = sourceLibrary.getLibref();
            }
            WsAppServer cPortAppSever = (WsAppServer)exportProperties.get(TableUtil.PORT_APP_SERVER);
            String sXtableName = "";
            sXtableName = this.scdCheck(operation, pTable, sXtableName);
            boolean bLibHasNoAppServer = false;
            Boolean libNoAppServer = (Boolean)exportProperties.get("LibHasNoAppServer");
            if (libNoAppServer != null && Boolean.TRUE == libNoAppServer) {
                bLibHasNoAppServer = true;
            }
            localRC = this.createStreamFromTransportFile(operation, contentHandler, cPortAppSever, exportItem, sourceLibrary, pTable, strLibRef, sXtableName, bLibHasNoAppServer, bVVNsubmitted);
            iRC |= localRC;
            if (localRC == 8) {
                iRC |= this.deAssignLibref(operation, cPortAppSever, strLibRef, pTable);
                continue;
            }
            PromotionPropertiesFile ppf = operation.getPropertiesFile();
            ppf.addProperty(sSourceFqid + "Content", "true");
            if (sXtableName.length() > 0) {
                ppf.addProperty(sSourceFqid + "###SCDXTABLE###", "true");
            }
            if (cPortAppSever == null) continue;
            if (sourceLibrary.getIsPreassigned() == 0) {
                iRC |= this.deAssignLibref(operation, cPortAppSever, strLibRef, pTable);
            }
            if (cPortAppSever.equals(currentAppServer)) continue;
            cPortAppSever.dispose();
            bVVNsubmitted = false;
        }
        if (currentAppServer != null) {
            currentAppServer.dispose();
            currentAppServer = null;
        }
        return iRC;
    }

    private int deAssignLibref(ExportOperationInterface operation, WsAppServer cportAppServer, String strLibRef, PhysicalTable pTable) throws RemoteException {
        try {
            if (cportAppServer.isLibrefAssigned(strLibRef)) {
                cportAppServer.clearLibref(strLibRef);
            }
        }
        catch (Exception ex) {
            operation.getLogger().warn((Object)ex.getLocalizedMessage());
            operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableImportListener.LibrefDeassignError.txt"), (Object)TableUtil.generateTableReferenceName(pTable, strLibRef)));
            return 4;
        }
        return 0;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface handler) {
        if (this.m_pnlOptions == null) {
            this.m_pnlOptions = new TableOptionsPanel(true);
        }
        this.m_pnlOptions.populateExportOptions(aItems, handler);
        return this.m_pnlOptions;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface handler) {
        return null;
    }

    public void saveSettings() {
        this.m_pnlOptions.saveSettings();
    }

    private String scdCheck(ExportOperationInterface operation, PhysicalTable pTable, String sXtableName) {
        String returnValue = sXtableName;
        try {
            AssociationList tempLst = pTable.getRoles();
            for (int i = 0; i < tempLst.size(); ++i) {
                AssociationList tempLst2;
                if (!((Role)tempLst.get(i)).getName().equalsIgnoreCase("ETLS_SCD2") || (tempLst2 = pTable.getPropertySets()).size() <= 0) continue;
                for (int j = 0; j < tempLst2.size(); ++j) {
                    AssociationList tempLst3;
                    PropertySet psTemp = (PropertySet)tempLst2.get(j);
                    if (!psTemp.getName().equalsIgnoreCase("ETLS_SCD2") || (tempLst3 = psTemp.getSetProperties()).size() <= 0) continue;
                    for (int k = 0; k < tempLst3.size(); ++k) {
                        Property pTemp = (Property)tempLst3.get(k);
                        if (!pTemp.getName().equalsIgnoreCase("XREF")) continue;
                        returnValue = pTemp.getDefaultValue();
                    }
                }
            }
        }
        catch (MdException m) {
            operation.getLogger().error((Object)m.getLocalizedMessage());
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        return returnValue;
    }

    private int submitProcCport(ExportOperationInterface operation, WsAppServer cportAppServer, TableExportItem exportItem, SASLibrary currentLibrary, PhysicalTable pTable, String strLibRef, String sXTableName, boolean bLibHasNoAppServer, boolean bVVNsubmitted) throws RemoteException {
        int localRC = 0;
        operation.getLogger().info((Object)(exportItem.getTypeInterface().getPublicType() + " \"" + exportItem.toString() + "\" (" + pTable.getId() + ")"));
        operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("TableExportListener.ExportContentInfo.txt"), (Object)TableUtil.generateTableReferenceName(pTable, strLibRef)));
        if (cportAppServer == null) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, currentLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)RB.getStringResource("TableImportListener.UnableToCreateAppServer.txt"));
            localRC = 8;
            return localRC;
        }
        LogListHolder appLog = null;
        try {
            boolean quoted = DBMSNamesUtil.isTableQuoted((DataTable)pTable);
            if (!cportAppServer.doesTableExist(strLibRef, pTable.getSASTableName(), quoted)) {
                operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("TableExportListener.ExportContentDoesNotExist.txt"), (Object)TableUtil.generateTableReferenceName(pTable, strLibRef)));
                localRC = 4;
                return localRC;
            }
            StringBuffer sbTemp = new StringBuffer();
            if (!bVVNsubmitted) {
                sbTemp.append("options validvarname = any validmemname = extend;");
                bVVNsubmitted = true;
            }
            if (sXTableName.length() < 1) {
                String sNlitsName = TableUtil.genNameLiterals(pTable.getSASTableName());
                sbTemp.append("PROC CPORT DATA=").append(strLibRef).append(".").append(sNlitsName).append(" FILE=CPORTREF; run;");
            } else {
                String sNlitsXrefName;
                String sNlitsName;
                if (currentLibrary.getEngine().equalsIgnoreCase("BASE")) {
                    sNlitsName = pTable.getSASTableName();
                    sNlitsXrefName = sXTableName;
                } else {
                    sNlitsName = TableUtil.genNameLiterals(pTable.getSASTableName());
                    sNlitsXrefName = TableUtil.genNameLiterals(sXTableName);
                }
                sbTemp.append("PROC CPORT LIB=").append(strLibRef).append(" FILE=CPORTREF MEMTYPE=DATA; ").append("SELECT ").append(sNlitsName).append(" ").append(sNlitsXrefName).append("; run;");
            }
            StringBuffer sbLetStatement = new ParametersModel((Root)pTable).getParameterMacroCode();
            if (sbLetStatement != null) {
                sbTemp.insert(0, sbLetStatement.toString());
            }
            operation.getLogger().debug((Object)("Submitting code to sas for CPORT: " + sbTemp.toString()));
            cportAppServer.submitSASCode(sbTemp.toString());
            appLog = cportAppServer.getLog();
            operation.getLogger().debug((Object)("Log from CPORT Execution: \n" + TableUtil.getBufferFromAppLog(appLog)));
            localRC |= TableUtil.displayErrorsFromSAS((PromotionInterface)operation, appLog);
            localRC |= TableUtil.displayWarningsFromSAS((PromotionInterface)operation, appLog);
        }
        catch (SQLException ex) {
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            localRC = 8;
        }
        catch (MdException ex) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, currentLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            localRC = 8;
        }
        catch (WsAppServerFailException ex) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, currentLibrary, bLibHasNoAppServer);
            operation.getLogger().error((Object)ex.getLocalizedMessage());
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableExportListener.ExeCportError.txt"), (Object)TableUtil.generateTableReferenceName(pTable, strLibRef)));
            localRC = 8;
        }
        catch (WsAppServerCodeException acx) {
            TableUtil.genNoAppserverAssignmentWarning((PromotionInterface)operation, currentLibrary, bLibHasNoAppServer);
            localRC = TableUtil.handleSASException((PromotionInterface)operation, (Exception)((Object)acx), appLog);
        }
        return localRC;
    }

    private int createStreamFromTransportFile(ExportOperationInterface operation, ContentHandlerInterface contentHandler, WsAppServer cportAppServer, TableExportItem exportItem, SASLibrary currentLibrary, PhysicalTable pTable, String strLibRef, String sXTableName, boolean bLibHasNoAppServer, boolean bVVNsubmitted) throws RemoteException {
        int localRC = 0;
        try {
            IFileService fileService = cportAppServer.getWorkspace().FileService();
            IFileref fileRef = fileService.AssignFileref("CPORTREF", "TEMP", "", "", new StringHolder());
            localRC = this.submitProcCport(operation, cportAppServer, exportItem, currentLibrary, pTable, strLibRef, sXTableName, bLibHasNoAppServer, bVVNsubmitted);
            if (localRC == 8) {
                fileService.DeassignFileref("CPORTREF");
                return localRC;
            }
            IBinaryStream inStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
            InputStream stream = contentHandler.getInputStream(inStream);
            contentHandler.addBinaryContent(pTable.getId(), pTable.getId(), stream);
            fileService.DeassignFileref("CPORTREF");
        }
        catch (Exception e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("TableExportListener.CreatePackageError.txt"), (Object)TableUtil.generateTableReferenceName(pTable, strLibRef)));
            localRC = 8;
            return localRC;
        }
        return localRC;
    }
}

