/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.promotion.AbstractFolderMemberConnectionType;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPropertiesInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.SearchCriteria;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import java.rmi.RemoteException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SASScope
public class TableConnectionType
extends AbstractFolderMemberConnectionType
implements ConnectionPropertiesInterface {
    private static final String PROPERTY_LIBRARY = "LIBRARY";
    private static final String PROPERTY_TABLENAME = "TABLE_NAME";
    private static final String TYPE_NAME = "Table";
    private static final String TABLE_TEMPLATE = "<Templates><PhysicalTable Name=\"\" SASTableName=\"\" Desc=\"\"><TablePackage/></PhysicalTable><SASLibrary Name=\"\"/><DatabaseSchema Name=\"\"/></Templates>";
    private static final String LIB_SCHEMA_TEMPLATE = "<Templates><SASLibrary Name=\"\"><UsingPackages/></SASLibrary><DatabaseSchema Name=\"\"/></Templates>";

    public TableConnectionType(PromotionInterface operation) {
        super(TYPE_NAME, operation);
    }

    public String getConnectionTypeName() {
        return TYPE_NAME;
    }

    public String getLocalizedTypeName() {
        return RB.getStringResource("TableConnectionType.Type.txt");
    }

    public String getPanelName() {
        return "com.sas.metadata.logical.table.TableConnectionPanel";
    }

    public void analyzeConnections() throws MdException, RemoteException {
        List tables = this._connectionManager.getConnections(ConnectionObjectType.PublicType, TYPE_NAME, true);
        for (ConnectionPointInterface pt : tables) {
            PhysicalTable table;
            if (pt.isUnknown() || (table = this.getTable(pt.getSourceID())) == null) continue;
            RelationalSchema tablePackage = table.getTablePackage();
            if (tablePackage != null) {
                AssociationList schemas;
                if (tablePackage instanceof SASLibrary) {
                    pt.addUserDefinedProperty(PROPERTY_LIBRARY, tablePackage.getName());
                } else if (tablePackage instanceof DatabaseSchema && (schemas = tablePackage.getUsedByPackages()).size() > 0) {
                    pt.addUserDefinedProperty(PROPERTY_LIBRARY, ((CMetadata)schemas.get(0)).getName());
                }
            }
            pt.addUserDefinedProperty(PROPERTY_TABLENAME, table.getSASTableName());
        }
    }

    private PhysicalTable getTable(String id) throws MdException, RemoteException {
        MdFactory factory = this._operation.getMetadataFactory();
        PhysicalTable table = (PhysicalTable)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "PhysicalTable", id, null, null, TABLE_TEMPLATE, 4);
        return table;
    }

    private String getSchemaNameFromLibraryId(String id) {
        String returnValue = null;
        try {
            Root usingPkg;
            AssociationList usingPackages;
            MdFactory factory = this._operation.getMetadataFactory();
            SASLibrary library = (SASLibrary)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "SASLibrary", id, null, null, LIB_SCHEMA_TEMPLATE, 4);
            if (library != null && (usingPackages = library.getUsingPackages()).size() > 0 && (usingPkg = (Root)usingPackages.get(0)) instanceof DatabaseSchema) {
                returnValue = ((DatabaseSchema)usingPkg).getName();
            }
        }
        catch (MdException me) {
            this._operation.getLogger().debug((Object)me.getLocalizedMessage(), (Throwable)me);
        }
        catch (RemoteException e) {
            this._operation.getLogger().debug((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public static String getAssociatedLibraryName(ConnectionPointInterface pt) {
        List searchList = pt.getSourceSearchList();
        for (String searchAttribute : searchList) {
            int index;
            int sasLibraryStartIndex;
            int startIndex;
            if (searchAttribute == null || searchAttribute.length() <= 0 || (startIndex = searchAttribute.indexOf("TablePackage")) <= -1 || !((sasLibraryStartIndex = searchAttribute.indexOf("UsedByPackages")) > -1 ? (index = searchAttribute.indexOf("@Name='", sasLibraryStartIndex)) > -1 : (index = searchAttribute.indexOf("@Name='", startIndex)) > -1)) continue;
            return searchAttribute.substring(index + 7, searchAttribute.indexOf("']", index + 7));
        }
        String libraryName = pt.getUserDefinedProperty(PROPERTY_LIBRARY);
        if (libraryName != null && libraryName.length() > 0) {
            return libraryName;
        }
        return null;
    }

    public static String getAssociatedSchemaName(ConnectionPointInterface pt) {
        List searchList = pt.getSourceSearchList();
        for (String searchAttribute : searchList) {
            int index;
            int sasLibraryStartIndex;
            int startIndex;
            if (searchAttribute == null || searchAttribute.length() <= 0 || (startIndex = searchAttribute.indexOf("TablePackage")) <= -1 || (sasLibraryStartIndex = searchAttribute.indexOf("UsedByPackages")) <= -1 || (index = searchAttribute.indexOf("@Name='", startIndex)) <= -1) continue;
            return searchAttribute.substring(index + 7, searchAttribute.indexOf("']", index + 7));
        }
        return null;
    }

    public Map getPropertyNames() {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(3);
        propertyMap.put(PROPERTY_LIBRARY, RB.getStringResource("TableConnectionType.Library.txt"));
        propertyMap.put(PROPERTY_TABLENAME, RB.getStringResource("TableConnectionType.TableName.txt"));
        return propertyMap;
    }

    public Map getSourcePropertyValues(SourceConnectionInterface source) throws MdException, RemoteException {
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(3);
        ConnectionPointInterface pt = source.getConnectionPoint();
        if (pt != null) {
            String tableName;
            String libraryName = pt.getUserDefinedProperty(PROPERTY_LIBRARY);
            if (libraryName != null) {
                propertyValues.put(PROPERTY_LIBRARY, libraryName);
            }
            if ((tableName = pt.getUserDefinedProperty(PROPERTY_TABLENAME)) != null) {
                propertyValues.put(PROPERTY_TABLENAME, tableName);
            }
            if (libraryName == null && (libraryName = TableConnectionType.getAssociatedLibraryName(pt)) != null) {
                propertyValues.put(PROPERTY_LIBRARY, libraryName);
            }
        }
        return propertyValues;
    }

    public Map getTargetPropertyValues(TargetConnectionInterface target) throws MdException, RemoteException {
        LinkedHashMap<String, String> propertyValues = new LinkedHashMap<String, String>(3);
        CMetadata meta = target.getMetadataObject();
        if (meta instanceof PhysicalTable) {
            PhysicalTable table = (PhysicalTable)meta;
            RelationalSchema tablePackage = table.getTablePackage();
            if (tablePackage != null) {
                AssociationList schemas;
                if (tablePackage instanceof SASLibrary) {
                    propertyValues.put(PROPERTY_LIBRARY, tablePackage.getName());
                } else if (tablePackage instanceof DatabaseSchema && (schemas = tablePackage.getUsedByPackages()).size() > 0) {
                    propertyValues.put(PROPERTY_LIBRARY, ((CMetadata)schemas.get(0)).getName());
                }
            }
            propertyValues.put(PROPERTY_TABLENAME, table.getSASTableName());
        }
        return propertyValues;
    }

    public SearchCriteria generateSearchCriteria(SourceConnectionInterface connection, String objectName) {
        Map serverMapping;
        ConnectionTypeInterface serverType;
        Map libraryMapping;
        SearchCriteria criteria = new SearchCriteria(connection);
        criteria.setSearchType(1);
        criteria.setMetadataType("PhysicalTable");
        String targetLibraryName = null;
        String targetSchemaName = null;
        ConnectionPointInterface pt = connection.getConnectionPoint();
        String library = TableConnectionType.getAssociatedLibraryName(pt);
        String schema = TableConnectionType.getAssociatedSchemaName(pt);
        ConnectionTypeInterface libraryType = this._operation.getConnectionType(LibraryConnectionType.getTypeClassName());
        if (libraryType != null && (libraryMapping = libraryType.getConnectionMapping()) != null && library != null) {
            for (SourceConnectionInterface sc : libraryMapping.keySet()) {
                TargetConnectionInterface tc;
                if (!sc.getDisplayName().equals(library) || (tc = (TargetConnectionInterface)libraryMapping.get(sc)) == null) continue;
                targetLibraryName = tc.getDisplayName();
                targetSchemaName = this.getSchemaNameFromLibraryId(tc.getTargetID());
                break;
            }
        }
        if (targetLibraryName == null) {
            targetLibraryName = library;
            targetSchemaName = schema;
        }
        String targetServerName = null;
        String server = this.getAssociatedServerName(pt);
        if (server != null && (serverType = this._operation.getConnectionType(AppServerConnectionType.getTypeClassName())) != null && (serverMapping = serverType.getConnectionMapping()) != null && server != null) {
            for (SourceConnectionInterface sc : serverMapping.keySet()) {
                TargetConnectionInterface tc;
                if (!sc.getDisplayName().equals(server) || (tc = (TargetConnectionInterface)serverMapping.get(sc)) == null) continue;
                targetServerName = tc.getDisplayName();
                break;
            }
        }
        if (targetLibraryName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("*[@Name='");
            sb.append(objectName);
            sb.append("'][TablePackage/*[@Name='");
            if (targetSchemaName != null) {
                sb.append(targetSchemaName);
                sb.append("']/UsedByPackages/*[@Name='");
            }
            sb.append(targetLibraryName);
            sb.append("']");
            if (targetServerName != null) {
                sb.append("/DeployedComponents/*[@ClassIdentifier='SAS Application Server' and @Name='");
                sb.append(targetServerName);
                sb.append("']");
            }
            sb.append("]");
            criteria.setSearchString(sb.toString());
        }
        return criteria;
    }

    private String getAssociatedServerName(ConnectionPointInterface pt) {
        List searchList = pt.getSourceSearchList();
        for (String searchAttribute : searchList) {
            int index;
            int startIndex = searchAttribute.indexOf("DeployedComponents");
            if (startIndex <= -1 || (index = searchAttribute.indexOf("@Name='", startIndex)) <= -1) continue;
            return searchAttribute.substring(index + 7, searchAttribute.indexOf(39, index + 7));
        }
        return null;
    }
}

