/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.PhysicalTable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

@SASScope
public class TableConnectionPanel
extends AbstractConnectionPanel {
    public TableConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
    }

    public String getDefaultSelectionValue() {
        return RB.getStringResource("TableConnectionPanel.NoneSelection.txt");
    }

    public String getHelpTopicSuffix() {
        return "tableswin";
    }

    public String getPanelBorderLabel() {
        return RB.getStringResource("TableConnectionPanel.BorderTitle.txt");
    }

    public String getPanelDescription() {
        return RB.getStringResource("TableConnectionPanel.Desc.txt");
    }

    public String getPanelTitle() {
        return RB.getStringResource("TableConnectionPanel.Title.txt");
    }

    protected boolean shouldResetTargetSelections() {
        boolean reset = false;
        ConnectionTypeInterface libraryType = this._importOperation.getConnectionType(LibraryConnectionType.getTypeClassName());
        if (libraryType != null) {
            Map libraryTargetMapping = libraryType.getConnectionMapping();
            if (this._originalParentMapping == null) {
                reset = true;
            } else {
                boolean changesMade = this.compareTargetMappings(this._originalParentMapping, libraryTargetMapping);
                if (changesMade) {
                    reset = true;
                }
            }
            if (libraryTargetMapping != null) {
                this._originalParentMapping = new LinkedHashMap(libraryTargetMapping);
            }
        }
        return reset;
    }

    @SASScope
    class TableComparator
    implements Comparator {
        TableComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 instanceof SourceConnectionInterface && obj2 instanceof TargetConnectionInterface) {
                SourceConnectionInterface source = (SourceConnectionInterface)obj1;
                TargetConnectionInterface target = (TargetConnectionInterface)obj2;
                if (source.getDisplayName().equals(target.getDisplayName())) {
                    try {
                        CMetadata meta = target.getMetadataObject();
                        if (meta == null || !(meta instanceof PhysicalTable)) {
                            return -1;
                        }
                        String sourceLibraryName = null;
                        ConnectionPointInterface connection = source.getConnectionPoint();
                        if (connection != null) {
                            Map libraryMapping;
                            String library = TableConnectionType.getAssociatedLibraryName(connection);
                            ConnectionTypeInterface libraryType = TableConnectionPanel.this._importOperation.getConnectionType(LibraryConnectionType.getTypeClassName());
                            if (libraryType != null && (libraryMapping = libraryType.getConnectionMapping()) != null && library != null) {
                                for (SourceConnectionInterface sc : libraryMapping.keySet()) {
                                    TargetConnectionInterface tc;
                                    if (!sc.getDisplayName().equals(library) || (tc = (TargetConnectionInterface)libraryMapping.get(sc)) == null) continue;
                                    sourceLibraryName = tc.getDisplayName();
                                    break;
                                }
                            }
                            if (sourceLibraryName == null) {
                                sourceLibraryName = library;
                            }
                        }
                        String targetLibraryName = null;
                        PhysicalTable table = (PhysicalTable)meta;
                        AssociationList assoc = table.getTablePackages(false);
                        if (assoc != null && assoc.size() > 0) {
                            targetLibraryName = ((CMetadata)assoc.get(0)).getName();
                        }
                        if (sourceLibraryName != null && sourceLibraryName.equals(targetLibraryName)) {
                            return 0;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return -1;
        }
    }
}

