/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.BaseLogicalObject;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PhysicalTableFilter;
import com.sas.services.util.XMLUtil;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

@SASScope
public class Table
extends BaseLogicalObject {
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    public static final UsageVersion FAILED_MIGRATION_VERSION = new UsageVersion(0, 5);

    public Table(PhysicalTable mdoTable, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoTable, type, factory);
        this.setCompatibility(FAILED_MIGRATION_VERSION, CURRENT_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String sName, OperationUserInteractionInterface opUI) throws LogicalTypeException {
        block12: {
            if (sName.equals(this.getName())) {
                return;
            }
            try {
                Object reposObject;
                MetadataInterface mi = UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
                if (mi == null || !((reposObject = mi.getRepositoryEntity()) instanceof PhysicalTable)) break block12;
                PhysicalTable pTable = (PhysicalTable)reposObject;
                MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "TableLogicalObject:rename:" + this.getID());
                try {
                    PhysicalTable tableMetadataObject = (PhysicalTable)store.getFactory().createComplexMetadataObject(store, (CMetadata)pTable);
                    RelationalSchema schema = tableMetadataObject.getTablePackage();
                    if (schema != null) {
                        AssociationList usedByPackages;
                        if (schema instanceof DatabaseSchema && (usedByPackages = schema.getUsedByPackages()) != null && usedByPackages.size() > 0) {
                            schema = (RelationalSchema)usedByPackages.get(0);
                        }
                        TableFilter newFilter = new TableFilter("Name", 0, sName);
                        newFilter.setType(pTable.getCMetadataType());
                        newFilter.setLibraryName(schema.getName());
                        newFilter.setName(sName);
                        int count = ((MetadataServerInterface)mi.getRepository().getServer()).getCountNoSecurity((Filter)newFilter, null);
                        if (count > 0) {
                            LogicalTypeException loe = new LogicalTypeException(UtilMisc.getMessage((String)RB.getStringResource("Table.DuplicateTableObjectFound.fmt.txt"), (Object)this.getTypeInterface().getDisplayType(), (Object)sName, (Object)schema.getName()));
                            throw loe;
                        }
                    }
                    super.rename(sName, opUI);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Writing");
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
        }
    }

    public boolean isExportAllowed() throws LogicalTypeException {
        boolean exportAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            exportAllowed = false;
        }
        if (exportAllowed) {
            exportAllowed = super.isExportAllowed();
        }
        return exportAllowed;
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        boolean renameAllowed = true;
        UsageVersion uv = this.getUsageVersion();
        if (uv != null && uv.encode() < CURRENT_VERSION.encode()) {
            renameAllowed = false;
        }
        if (renameAllowed) {
            renameAllowed = super.isRenameAllowed();
        }
        return renameAllowed;
    }

    @SASScope
    public class TableFilter
    extends PhysicalTableFilter {
        private static final long serialVersionUID = 1285637267752128392L;
        private String _libName;
        private static final int SELECTBUFFER_INIT = 128;

        public TableFilter(String key, int relation, String value) {
            super(key, relation, value);
            this._libName = null;
        }

        public void setLibraryName(String inName) {
            this._libName = inName;
        }

        public String getXMLSelectString() {
            String baseSelect = this.component2Select(this._component);
            StringBuffer buffer = new StringBuffer(128);
            String name = this.getName();
            if (name != null || baseSelect.length() > 0) {
                buffer.append("<XMLSelect Search=\"PhysicalTable");
                if (name != null) {
                    buffer.append("[@Name='" + XMLUtil.normalize((String)name) + '\'' + ']');
                }
                if (this._libName != null) {
                    buffer.append("[TablePackage/SASLibrary[@Name='" + this._libName + "']]\"");
                }
                buffer.append(" />\n");
            }
            return buffer.toString();
        }
    }
}

