/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.table;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.table.RB;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.DataTable;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsColumnMetadataUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope
public class ColumnsNotInSourceDialog
extends WAStandardDialog {
    public ColumnsNotInSourceDialog(Dialog dlgParent, Map mapTablesToColumns) {
        super(dlgParent, RB.getStringResource("ColumnsNotInSourceDialog.Title.txt"), true);
        this.initialize(mapTablesToColumns);
    }

    public ColumnsNotInSourceDialog(Frame frmParent, Map mapTablesToColumns) {
        super(frmParent, RB.getStringResource("ColumnsNotInSourceDialog.Title.txt"), true);
        this.initialize(mapTablesToColumns);
    }

    private void initialize(Map mapTablesToColumns) {
        this.setMainPanel(new MainPanel(mapTablesToColumns));
        this.setHelpButtonVisible(false);
        this.setCancelButtonVisible(false);
        this.setResizable(true);
    }

    @SASScope
    private static class TheTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private TheTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bFocus) {
            TheTreeCellRenderer rdr = (TheTreeCellRenderer)super.getTreeCellRendererComponent(tree, value, bSelected, bExpanded, bLeaf, iRow, bFocus);
            if (value instanceof ATreeNode) {
                ATreeNode node = (ATreeNode)value;
                rdr.setText(node.getName());
                rdr.setIcon(node.getIcon());
            }
            return rdr;
        }
    }

    @SASScope
    private static class ATreeNode
    extends DefaultMutableTreeNode {
        private Icon m_icon;

        public ATreeNode(String sName, Icon icon) {
            super(sName);
            this.m_icon = icon;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public String getName() {
            return (String)this.getUserObject();
        }
    }

    @SASScope
    private static class TheTreeModel
    extends DefaultTreeModel {
        public TheTreeModel(Map mapTablesToColumns) {
            super(new ATreeNode("Root", null));
            ATreeNode nodeRoot = (ATreeNode)this.getRoot();
            try {
                Set setKeys = mapTablesToColumns.keySet();
                DataTable[] aTables = setKeys.toArray(new DataTable[setKeys.size()]);
                for (int iTable = 0; iTable < aTables.length; ++iTable) {
                    Icon iconTable = WsAbstractIconFactory.getInstance().getIconForPublicType(aTables[iTable].getPublicType());
                    ATreeNode nodeTable = new ATreeNode(aTables[iTable].getName(), iconTable);
                    this.insertNodeInto(nodeTable, nodeRoot, nodeRoot.getChildCount());
                    List lColumns = (List)mapTablesToColumns.get(aTables[iTable]);
                    for (int iColumn = 0; iColumn < lColumns.size(); ++iColumn) {
                        Column column = (Column)lColumns.get(iColumn);
                        Icon iconColumn = WsColumnMetadataUtil.getColumnTypeIcon((Column)column);
                        ATreeNode nodeColumn = new ATreeNode(column.getName(), iconColumn);
                        this.insertNodeInto(nodeColumn, nodeTable, nodeTable.getChildCount());
                    }
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
    }

    @SASScope
    private static class MainPanel
    extends WAPanel {
        public MainPanel(Map mapTablesToColumns) {
            JLabel lblColumns = new JLabel(RB.getStringResource("ColumnsNotInSourceDialog.Label.txt"));
            TheTreeModel mdlColumns = new TheTreeModel(mapTablesToColumns);
            JTree treeColumns = new JTree(mdlColumns);
            treeColumns.setRootVisible(false);
            treeColumns.setShowsRootHandles(true);
            treeColumns.setCellRenderer(new TheTreeCellRenderer());
            TreeNode node = (TreeNode)mdlColumns.getRoot();
            for (int iChild = 0; iChild < node.getChildCount(); ++iChild) {
                DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getChildAt(iChild);
                treeColumns.expandPath(new TreePath(nodeChild.getPath()));
            }
            JScrollPane scrColumns = new JScrollPane(treeColumns);
            scrColumns.setPreferredSize(new Dimension(200, 400));
            this.setLayout(new BorderLayout(0, 5));
            this.add(lblColumns, "North");
            this.add(scrColumns, "Center");
        }
    }
}

