/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.secureddata.ImportOptionsPanel;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryImportItem;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.ExternalIdentity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASPassword;
import com.sas.metadata.remote.SecuredLibrary;
import com.sas.metadata.remote.SecuredTable;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.swing.JPanel;

public class SecuredLibraryImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    private static final String CREDENTIAL_HISTORY = "SecuredLibraryCredentialHistory";
    private Map<String, List<SASPassword>> _passwordCache = null;
    private Map<String, String> _guidCache = null;
    private ImportOptionsPanel _optionsPanel;

    public SecuredLibraryImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getSubstitutionTypes() {
        return new Class[]{DirectoryPathSubstitutionType.class};
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new SecuredLibraryImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        int rc = 0;
        for (int index = 0; index < importItems.size(); ++index) {
            ImportItemInterface item = (ImportItemInterface)importItems.get(index);
            String name = item.getName();
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)item.getTypeInterface(), (String)name, (int)(index + 1), (int)importItems.size()));
            this.verifyImportLocation(item);
            if (item.getImportState() != 2) continue;
            rc |= this.analyzeObjectForOvewrite(operation, item);
        }
        return rc;
    }

    private int analyzeObjectForOvewrite(ImportOperationInterface operation, ImportItemInterface item) {
        com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary;
        int rc = 0;
        try {
            if (this._passwordCache == null) {
                this._passwordCache = new HashMap<String, List<SASPassword>>();
            }
            if (this._guidCache == null) {
                this._guidCache = new HashMap<String, String>();
            }
            if ((targetLibrary = (com.sas.services.information.metadata.secureddata.SecuredLibrary)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)item.getTargetID(), (String)item.getTypeInterface().getMetadataType())) == null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryImportListener.TargetTableNotFound.fmt", (Object)item.getName(), (Object)item.getTargetID());
                operation.getLogger().error((Object)msg);
                return 8;
            }
            rc |= this.mergeTables(operation, item, targetLibrary);
            rc |= this.preservePasswords(operation, item, targetLibrary);
        }
        catch (Exception e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            return 8;
        }
        return rc |= this.preserveGUIDs(operation, item, targetLibrary);
    }

    private int mergeTables(ImportOperationInterface operation, ImportItemInterface item, com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary) {
        try {
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)("Merging tables for library \"" + item + "\"."));
            }
            List targetTables = targetLibrary.getTables();
            List importTables = item.getNestedItems();
            for (ImportItemInterface importTable : importTables) {
                com.sas.services.information.metadata.secureddata.SecuredTable targetTable = this.findTableByName(targetTables, importTable.getName());
                if (targetTable != null) {
                    importTable.setImportState(2);
                    importTable.setTargetID(targetTable.getIdentifier());
                    continue;
                }
                importTable.setImportState(1);
            }
        }
        catch (Exception e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            return 8;
        }
        return 0;
    }

    private int preservePasswords(ImportOperationInterface operation, ImportItemInterface item, com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary) {
        try {
            SecuredLibrary library = (SecuredLibrary)targetLibrary.getRepositoryEntity();
            ArrayList<SASPassword> saveList = new ArrayList<SASPassword>(3);
            AssociationList passwords = library.getDefaultPasswords();
            for (SASPassword password : passwords) {
                saveList.add(password);
            }
            this._passwordCache.put(item.getTargetID(), saveList);
        }
        catch (Exception e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            return 8;
        }
        return 0;
    }

    private int preserveGUIDs(ImportOperationInterface operation, ImportItemInterface item, com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary) {
        try {
            this.cacheGUID((MetadataInterface)targetLibrary);
            List tables = targetLibrary.getTables();
            for (com.sas.services.information.metadata.secureddata.SecuredTable table : tables) {
                this.cacheGUID((MetadataInterface)table);
            }
        }
        catch (Exception e) {
            operation.getLogger().error((Object)e.getLocalizedMessage());
            return 8;
        }
        return 0;
    }

    private void cacheGUID(MetadataInterface mi) throws RemoteException, MdException {
        Root root = (Root)mi.getRepositoryEntity();
        AssociationList identities = root.getExternalIdentities();
        if (identities != null && !identities.isEmpty()) {
            ExternalIdentity tableIdentity = (ExternalIdentity)identities.get(0);
            this._guidCache.put(root.getId(), tableIdentity.getIdentifier());
        }
    }

    private com.sas.services.information.metadata.secureddata.SecuredTable findTableByName(List<com.sas.services.information.metadata.secureddata.SecuredTable> tables, String tableName) throws RemoteException {
        if (tables != null && !tables.isEmpty()) {
            for (com.sas.services.information.metadata.secureddata.SecuredTable table : tables) {
                if (!tableName.equalsIgnoreCase(table.getName())) continue;
                return table;
            }
        }
        return null;
    }

    private void verifyImportLocation(ImportItemInterface item) throws MetadataPromotionException {
        String[] targetPath;
        String[] sourcePath = item.getSourcePath();
        if (!SASFoldersUtil.areFolderPathsEqual((String[])sourcePath, (String[])(targetPath = item.getTargetPath()))) {
            String msg = "The secured library \"" + item + "\" cannot be imported into this location.  It must be imported into the same path in which it was exported from; \"" + BIPTreeUtil.pathToString((String[])sourcePath) + "\".";
            throw new MetadataPromotionException(msg);
        }
    }

    public int updateObjects(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        int rc = 0;
        for (int index = 0; index < importItems.size(); ++index) {
            ImportItemInterface item = (ImportItemInterface)importItems.get(index);
            String name = item.getName();
            this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)item.getTypeInterface(), (String)name, (int)(index + 1), (int)importItems.size()));
            try {
                com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary = (com.sas.services.information.metadata.secureddata.SecuredLibrary)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)item.getTargetID(), (String)item.getTypeInterface().getMetadataType());
                if (targetLibrary == null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryImportListener.TargetLibraryNotFound.fmt", (Object)item.getName(), (Object)item.getTargetID());
                    operation.getLogger().error((Object)msg);
                    return 8;
                }
                targetLibrary.refresh();
                rc |= this.updatePasswords(operation, item, targetLibrary);
                rc |= this.updateGUIDs(operation, item, targetLibrary);
                continue;
            }
            catch (Exception e) {
                operation.getLogger().error((Object)e.getLocalizedMessage());
                rc |= 8;
            }
        }
        return rc;
    }

    private int updatePasswords(ImportOperationInterface operation, ImportItemInterface item, com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary) {
        try {
            SecuredLibrary library = (SecuredLibrary)targetLibrary.getRepositoryEntity();
            AssociationList defaultPasswords = library.getDefaultPasswords();
            this.removePasswords((List<SASPassword>)defaultPasswords);
            AssociationList customAssocsList = library.getCustomAssociations();
            if (customAssocsList != null && !customAssocsList.isEmpty()) {
                CustomAssociation[] customAssocs;
                for (CustomAssociation customAssoc : customAssocs = customAssocsList.toArray(new CustomAssociation[customAssocsList.size()])) {
                    if (!CREDENTIAL_HISTORY.equalsIgnoreCase(customAssoc.getName())) continue;
                    ArrayList<SASPassword> passwords = new ArrayList<SASPassword>();
                    AssociationList objects = customAssoc.getAssociatedObjects();
                    if (objects != null && !objects.isEmpty()) {
                        for (Root obj : objects) {
                            if (!(obj instanceof SASPassword)) continue;
                            passwords.add((SASPassword)obj);
                        }
                    }
                    this.removePasswords(passwords);
                    customAssoc.delete();
                }
            }
            targetLibrary.update();
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryImportListener.PasswordError.fmt", (Object)item, (Object)e.getLocalizedMessage());
            operation.getLogger().error((Object)msg);
            return 8;
        }
        return 0;
    }

    private void removePasswords(List<SASPassword> passwordList) throws RemoteException {
        SASPassword[] passwords;
        for (SASPassword password : passwords = passwordList.toArray(new SASPassword[passwordList.size()])) {
            password.delete();
        }
    }

    private int updateGUIDs(ImportOperationInterface operation, ImportItemInterface item, com.sas.services.information.metadata.secureddata.SecuredLibrary targetLibrary) {
        try {
            SecuredLibrary library = (SecuredLibrary)targetLibrary.getRepositoryEntity();
            AssociationList extIdentities = library.getExternalIdentities();
            if (item.getImportState() == 1) {
                SecuredLibraryImportItem importItem = (SecuredLibraryImportItem)item;
                if (!importItem.isSharingData() && extIdentities != null && !extIdentities.isEmpty()) {
                    ExternalIdentity identity = (ExternalIdentity)extIdentities.get(0);
                    identity.setIdentifier(UUID.randomUUID().toString());
                    List tables = targetLibrary.getTables();
                    for (com.sas.services.information.metadata.secureddata.SecuredTable table : tables) {
                        SecuredTable st = (SecuredTable)table.getRepositoryEntity();
                        AssociationList identities = st.getExternalIdentities();
                        if (identities == null || identities.isEmpty()) continue;
                        ExternalIdentity tableIdentity = (ExternalIdentity)identities.get(0);
                        tableIdentity.setIdentifier(UUID.randomUUID().toString());
                    }
                }
            } else if (item.getImportState() == 2) {
                if (extIdentities != null && !extIdentities.isEmpty()) {
                    this.preserveOriginalGUID((MetadataInterface)targetLibrary, (ExternalIdentity)extIdentities.get(0));
                }
                List targetTables = targetLibrary.getTables();
                List importTables = item.getNestedItems();
                for (ImportItemInterface importTable : importTables) {
                    com.sas.services.information.metadata.secureddata.SecuredTable targetTable = this.getTargetTable(operation, importTable, targetTables);
                    if (targetTable == null) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryImportListener.TargetTableNotFound.fmt", (Object)item.getName(), (Object)item.getTargetID());
                        operation.getLogger().error((Object)msg);
                        return 8;
                    }
                    targetTable.refresh();
                    SecuredTable st = (SecuredTable)targetTable.getRepositoryEntity();
                    AssociationList tableIdentities = st.getExternalIdentities();
                    if (tableIdentities == null || tableIdentities.isEmpty()) continue;
                    ExternalIdentity identity = (ExternalIdentity)tableIdentities.get(0);
                    if (importTable.getImportState() == 1) {
                        identity.setIdentifier(UUID.randomUUID().toString());
                        continue;
                    }
                    if (importTable.getImportState() != 2) continue;
                    this.preserveOriginalGUID((MetadataInterface)targetTable, identity);
                }
            }
            targetLibrary.update();
        }
        catch (Exception e) {
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Setting unique identifiers", (Throwable)e);
            }
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredLibraryImportListener.GUIDError.fmt", (Object)item, (Object)e.getLocalizedMessage());
            operation.getLogger().error((Object)msg);
            return 8;
        }
        return 0;
    }

    private com.sas.services.information.metadata.secureddata.SecuredTable getTargetTable(ImportOperationInterface operation, ImportItemInterface importTable, List<com.sas.services.information.metadata.secureddata.SecuredTable> tables) throws ServiceException, RemoteException {
        com.sas.services.information.metadata.secureddata.SecuredTable targetTable = importTable.getTargetID() != null ? (com.sas.services.information.metadata.secureddata.SecuredTable)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)importTable.getTargetID(), (String)importTable.getTypeInterface().getMetadataType()) : this.findTableByName(tables, importTable.getName());
        return targetTable;
    }

    private void preserveOriginalGUID(MetadataInterface mi, ExternalIdentity identity) throws ServiceException, RemoteException {
        String originalGUID = this._guidCache.get(mi.getIdentifier());
        if (originalGUID != null) {
            identity.setIdentifier(originalGUID);
        }
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface handler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface handler) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new ImportOptionsPanel();
        }
        this._optionsPanel.populateImportOptions(aItems, handler);
        return this._optionsPanel;
    }

    public void saveSettings() {
        if (this._optionsPanel != null) {
            this._optionsPanel.saveSettings();
        }
    }
}

