/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryAppServerUtil;
import com.sas.metadata.logical.secureddata.SecuredLibraryDataObject;
import com.sas.metadata.logical.visuals.EditableComboBox;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.ServerComponentListElement;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SecuredLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WsAppServer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class SecuredLibraryAppServerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Root _root;
    private String _serverRepositoryID;
    private JPanel appServerPanel;
    private JPanel libraryPathPanel;
    private DefaultComboBoxModel _serverComboBoxModel;
    private EditableComboBox _comboServer;
    private WATextField _txtLibraryPath;
    private JFileChooser _pathDialog = null;
    private JButton _btnBrowsePath;
    private ServerContext _displayedServerContext;
    private ServerComponentListElement _displayedServerContextListElement;
    private boolean _dataPreviouslyMovedToView;
    private ArrayList<ServerComponentListElement> _servers = new ArrayList();

    public SecuredLibraryAppServerPanel(Root root, String serverRepositoryID) {
        this._root = root;
        this._serverRepositoryID = serverRepositoryID;
        this.initializePanel();
        this.layoutWidgets();
    }

    private void initializePanel() {
        this._serverComboBoxModel = new DefaultComboBoxModel();
        this._comboServer = new EditableComboBox(this._serverComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
                try {
                    SecuredLibraryAppServerPanel.this.doServerSelected(le, (Component)((Object)this));
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        };
        this._comboServer.setToolTipText(RB.getStringResource("ConnectionData.AppSrvr.Tooltip.txt"));
        this._txtLibraryPath = new WATextField();
        this._txtLibraryPath.setMaxCharacters(256);
        this._txtLibraryPath.setToolTipText(RB.getStringResource("ConnectionData.LibraryPath.Tooltip.txt"));
        this._pathDialog = new JFileChooser();
        this._pathDialog.setDialogTitle(RB.getStringResource("ConnectionData.LibraryPathDialog.Title.txt"));
        this._pathDialog.setFileSelectionMode(1);
        this._pathDialog.setApproveButtonText(RB.getStringResource("ConnectionData.OKButton.txt"));
        this._btnBrowsePath = UtilGui.createButton((String)RB.getStringResource("ConnectionData.BrowseButton.txt"));
        this._btnBrowsePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SecuredLibraryAppServerPanel.this.launchBrowseDialog();
            }
        });
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.appServerPanel = new JPanel();
        this.appServerPanel.setLayout(new GridBagLayout());
        TitledBorder appBorder = BorderFactory.createTitledBorder(RB.getStringResource("ConnectionData.AppSrvr.Lbl.txt"));
        this.appServerPanel.setBorder(appBorder);
        this.appServerPanel.add((Component)this._comboServer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.libraryPathPanel = new JPanel();
        TitledBorder pathBorder = BorderFactory.createTitledBorder(RB.getStringResource("ConnectionData.LibraryPath.Lbl.txt"));
        this.libraryPathPanel.setBorder(pathBorder);
        this.libraryPathPanel.setLayout(new GridBagLayout());
        this.libraryPathPanel.add((Component)this._txtLibraryPath, new GridBagConstraints(0, 0, -1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.libraryPathPanel.add((Component)this._btnBrowsePath, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.appServerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.libraryPathPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 10, 0), 0, 0));
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this._dataPreviouslyMovedToView) {
            this.setServersInVisual();
            this._dataPreviouslyMovedToView = true;
        }
    }

    public void populateServerData() throws RemoteException, MdException {
        this.determineAvailableServers();
    }

    public void loadDialogPanelData() throws MdException, RemoteException {
        this.populateServerData();
        this.moveDataToView();
        AssociationList assocList = ((SecuredLibrary)this._root).getUsingPackages();
        if (!assocList.isEmpty()) {
            for (int i = 0; i < assocList.size(); ++i) {
                Object obj = assocList.get(i);
                if (!(obj instanceof Directory)) continue;
                Directory dir = (Directory)obj;
                this._txtLibraryPath.setText(dir.getDirectoryName());
                break;
            }
        }
    }

    private void doServerSelected(ListElementInterface lei, Component c) throws RemoteException {
        ServerComponentListElement le = (ServerComponentListElement)lei;
        ServerContext selectedSC = (ServerContext)le.getServerComponent();
        if (this._displayedServerContext == selectedSC) {
            return;
        }
        this._displayedServerContextListElement = le;
        this._displayedServerContext = selectedSC;
    }

    private void determineAvailableServers() throws MdException, RemoteException {
        String serverNameOfDesiredServer = null;
        this._displayedServerContext = null;
        this._displayedServerContextListElement = null;
        this._servers.clear();
        List<ServerContext> servers = this.findServerContextsWithWorkspaceServers(this._root.getObjectStore(), this._serverRepositoryID);
        for (ServerContext sc : servers) {
            ServerComponentListElement scle = new ServerComponentListElement((ServerComponent)sc);
            this._servers.add(scle);
            if (serverNameOfDesiredServer == null || !serverNameOfDesiredServer.equals(sc.getName())) continue;
            this._displayedServerContext = sc;
            this._displayedServerContextListElement = scle;
        }
    }

    private List<ServerContext> findServerContextsWithWorkspaceServers(MdStore objectStore, String repositoryID) throws MdException, RemoteException {
        String searchClassid = "@ClassIdentifier = '440196d4-90f0-11d0-9f41-00a024bb830c'";
        int flags = 8584;
        List servers = objectStore.getFactory().getOMIUtil().getMetadataObjectsSubset(objectStore, repositoryID, "ServerContext", flags, "<XMLSELECT search=\"ServerContext[UsingComponents/LogicalServer[" + searchClassid + "]]\"/>");
        return servers;
    }

    private void setServersInVisual() throws MdException {
        this.setServerListener(false);
        this._serverComboBoxModel.removeAllElements();
        if (this._displayedServerContext == null) {
            this._displayedServerContextListElement = ServerComponentListElement.SELECT_A_SERVER;
            this._serverComboBoxModel.addElement(this._displayedServerContextListElement);
        }
        for (ServerComponentListElement scle : this._servers) {
            this._serverComboBoxModel.addElement(scle);
        }
        if (this._displayedServerContextListElement != null) {
            this._serverComboBoxModel.setSelectedItem(this._displayedServerContextListElement);
        }
        this.setServerListener(true);
    }

    protected void launchBrowseDialog() {
        ServerComponentListElement serverSelected = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        String targetLocation = null;
        ServerComponent sc = serverSelected.getServerComponent();
        if (sc == null || !serverSelected.isRealServer()) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.ApplicationServerSelectionRequired.Warning.txt"), (String)RB.getStringResource("AppServerPanel.BrowseErrorTitle.txt"), (int)0);
        } else {
            targetLocation = this.browseOnWorkspaceServer(targetLocation, sc);
        }
        if (targetLocation != null) {
            this._txtLibraryPath.setText(targetLocation);
        }
    }

    protected boolean dataValidate() {
        WAWizardDialog wizard = (WAWizardDialog)this.getTopLevelAncestor();
        ServerComponentListElement serverSelected = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        ServerComponent sc = serverSelected.getServerComponent();
        if (sc == null || !serverSelected.isRealServer()) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.ApplicationServerSelectionRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        wizard.replaceWizardData("SL_AppServer", (Object)sc);
        String libraryPath = this._txtLibraryPath.getText();
        if (libraryPath == null || libraryPath.length() == 0) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.LibraryPathRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        if (!this.validateFolderPathExists(libraryPath, (ServerContext)sc)) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.LibraryPathNotFound.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        wizard.replaceWizardData("LibraryPath", (Object)libraryPath);
        return true;
    }

    protected boolean dataDialogValidate(SecuredLibraryDataObject slDataObject) {
        ServerComponentListElement serverSelected = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        ServerComponent sc = serverSelected.getServerComponent();
        if (sc == null || !serverSelected.isRealServer()) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.ApplicationServerSelectionRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        slDataObject.setServerComponent(sc);
        String libraryPath = this._txtLibraryPath.getText();
        if (libraryPath == null || libraryPath.length() == 0) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.LibraryPathRequired.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        if (!this.validateFolderPathExists(libraryPath, (ServerContext)sc)) {
            MessageUtil.displayMessage((String)RB.getStringResource("AppServerPanel.LibraryPathNotFound.Error.txt"), (String)RB.getStringResource("Common.ErrorTitle.txt"), (int)0);
            return false;
        }
        slDataObject.setLibraryPath(libraryPath);
        return true;
    }

    private boolean validateFolderPathExists(String folderPath, ServerContext serverComp) {
        SecuredLibraryAppServerUtil appServerUtil = new SecuredLibraryAppServerUtil(serverComp);
        return appServerUtil.doesFileExist(folderPath);
    }

    private void setServerListener(boolean on) {
        this._comboServer.setListener(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String browseOnWorkspaceServer(String targetLocation, ServerComponent serverComp) {
        WsAppServer appServer = null;
        if (serverComp instanceof ServerContext) {
            appServer = WsAppServer.createAppServer((ServerContext)((ServerContext)serverComp));
        }
        if (appServer != null) {
            try {
                appServer.open();
                targetLocation = appServer.promptForDirectory(RB.getStringResource("AppServerPanel.BrowseAppServerTitle.txt"), targetLocation, null);
            }
            catch (Exception e) {
                String sMsg = Message.format((ResourceBundle)RB.getResources(), (String)"AppServerPanel.BrowseError.fmt", (Object)e.getMessage());
                MessageUtil.displayMessage((String)sMsg, (String)RB.getStringResource("AppServerPanel.BrowseErrorTitle.txt"), (int)0);
            }
            finally {
                appServer.dispose();
            }
        } else {
            String sMsg = Message.format((ResourceBundle)RB.getResources(), (String)"AppServerPanel.BrowseError.fmt", (Object)RB.getStringResource("AppServerPanel.NoApplicationServerFound.txt"));
            MessageUtil.displayMessage((String)sMsg, (String)RB.getStringResource("AppServerPanel.BrowseErrorTitle.txt"), (int)0);
        }
        return targetLocation;
    }
}

