/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderLogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecuredDataFolderLogicalObject
extends FolderLogicalObject {
    private static final Logger log = LogManager.getLogger(SecuredDataFolderLogicalObject.class);
    private static final String DELETE_TEMPLATE = "<Templates><Tree><SubTrees/><Members/></Tree></Templates>";
    private boolean _isCreateChildTested = false;
    private boolean _isCreateChildAllowed;

    public SecuredDataFolderLogicalObject(Tree root, TypeInterface ti, Factory factory) throws LogicalTypeException, MdException, RemoteException {
        super(root, ti, factory);
    }

    public boolean isCreateChildAllowed() throws LogicalTypeException, RemoteException {
        if (!this._isCreateChildTested) {
            this._isCreateChildTested = true;
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                FolderInterface folder = (FolderInterface)detachedTransaction.getSmartObject((SimpleLogicalObjectInterface)this);
                if (folder != null) {
                    this._isCreateChildAllowed = folder.isAuthorized("WriteMetadata");
                }
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                if (detachedTransaction != null) {
                    detachedTransaction.rollback();
                }
            }
        }
        return this._isCreateChildAllowed;
    }

    public boolean isCustomRepositoryRoot() {
        return false;
    }

    public boolean delete(OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        int choice;
        if (!this.isDeleteAllowed()) {
            throw new UnsupportedOperationException("This object cannot be deleted.");
        }
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        if (!oui.isUserInteractionSupported()) {
            if (!SecuredLibraryUtil.isDeletePromptDisplayed(oui)) {
                log.warn(RB.getStringResource("Common.BatchDeleteWarning.txt"));
                SecuredLibraryUtil.setDeletePromptResponse(oui, true);
            }
            choice = 3;
        } else if (SecuredLibraryUtil.isDeletePromptDisplayed(oui)) {
            boolean response = SecuredLibraryUtil.getDeletePromptResponse(oui);
            choice = response ? 0 : 3;
        } else {
            try {
                if (this.getChildCount() > 0) {
                    String message;
                    String title = RB.getStringResource("Common.WarningTitle.txt");
                    choice = oui.displayMessage(title, message = Message.format((ResourceBundle)RB.getResources(), (String)"Common.DeleteWarning.fmt.txt", (Object)this.getName()), 1, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
                    boolean response = choice == 0;
                    SecuredLibraryUtil.setDeletePromptResponse(oui, response);
                } else {
                    choice = 0;
                }
            }
            catch (Exception e) {
                if (oui.continueOperationWithPrompting()) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderLogicalObject.DeleteErrorMsg.fmt.txt", (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                    int choice2 = oui.displayMessage(RB.getStringResource("Common.ErrorTitle.txt"), msg, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                    OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice2);
                }
                return false;
            }
        }
        if (choice == 0) {
            return super.delete(oui);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getChildCount() throws RemoteException, MdException {
        MdObjectStore store = null;
        MdFactory factory = this.getFactory().getMdFactory();
        Tree folder = null;
        try {
            store = factory.createObjectStore(null, "SecuredDataFolder:delete:" + this.getID());
            int flags = 260;
            folder = (Tree)this.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "Tree", this.getID(), null, null, DELETE_TEMPLATE, flags);
            int n = this.getChildCount(folder);
            return n;
        }
        finally {
            if (store != null) {
                store.dispose();
            }
        }
    }

    private int getChildCount(Tree folder) throws RemoteException, MdException {
        int count = 0;
        AssociationList members = folder.getMembers();
        for (CMetadata meta : members) {
            if (!"SecuredLibrary".equalsIgnoreCase(meta.getCMetadataType())) continue;
            ++count;
        }
        AssociationList subfolders = folder.getSubTrees();
        for (Tree subfolder : subfolders) {
            count += this.getChildCount(subfolder);
        }
        return count;
    }

    public void rename(String name, OperationUserInteractionInterface oui) throws LogicalTypeException, RemoteException {
        if (!this.isRenameAllowed()) {
            throw new UnsupportedOperationException("This object cannot be deleted.");
        }
        if (this.getName().equals(name)) {
            return;
        }
        int choice = 0;
        if (!oui.isUserInteractionSupported()) {
            choice = 3;
        } else {
            try {
                if (this.getChildCount() > 0) {
                    String title = RB.getStringResource("Common.WarningTitle.txt");
                    String message = Message.format((ResourceBundle)RB.getResources(), (String)"SecuredDataFolderLogicalObject.RenameWarning.fmt.txt", (Object)this.getName());
                    choice = oui.displayMessage(title, message, 1, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
                } else {
                    choice = 0;
                }
            }
            catch (Exception e) {
                throw new LogicalTypeException(e.getLocalizedMessage());
            }
        }
        if (choice == 0) {
            super.rename(name, oui);
        }
    }
}

