/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.secureddata;

import com.sas.metadata.logical.secureddata.RB;
import com.sas.metadata.logical.secureddata.SecuredLibraryImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.swing.visuals.TriStateCheckBox;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;

public class ImportOptionsPanel
extends JPanel {
    private TriStateCheckBox _shareDataCheckBox = new TriStateCheckBox();
    private boolean _dataChanged;
    private ImportItemInterface[] _importItems;

    public ImportOptionsPanel() {
        Util.configureMnemonicForButton((AbstractButton)this._shareDataCheckBox, (String)RB.getStringResource("ImportOptionsPanel.ShareDataOption.txt"));
        this._shareDataCheckBox.setToolTipText(RB.getStringResource("ImportOptionsPanel.ShareDataOption.Tooltip.txt"));
        this._shareDataCheckBox.setCycleEnabled(false);
        this._shareDataCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportOptionsPanel.this._dataChanged = true;
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this._shareDataCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void populateImportOptions(ImportItemInterface[] aItems, ImportOperationInterface importHandler) {
        this._importItems = aItems;
        boolean enabled = true;
        for (int i = 0; i < aItems.length; ++i) {
            ImportItemInterface item = aItems[i];
            if (item.getImportState() != 2) continue;
            enabled = false;
            break;
        }
        if (!enabled) {
            this._shareDataCheckBox.setSelectedValue(0);
            this._shareDataCheckBox.setEnabled(false);
            return;
        }
        this._shareDataCheckBox.setEnabled(true);
        this._shareDataCheckBox.setSelectedValue(this.determineCheckBoxState(aItems));
    }

    private int determineCheckBoxState(ImportItemInterface[] items) {
        boolean bAllOn = true;
        boolean bAllOff = true;
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof SecuredLibraryImportItem)) continue;
            boolean bOn = ((SecuredLibraryImportItem)items[i]).isSharingData();
            bAllOn &= bOn;
            bAllOff &= !bOn;
        }
        if (bAllOn) {
            return 2;
        }
        if (bAllOff) {
            return 0;
        }
        return 1;
    }

    public void saveSettings() {
        if (!this._dataChanged) {
            return;
        }
        for (int i = 0; i < this._importItems.length; ++i) {
            ((SecuredLibraryImportItem)this._importItems[i]).setSharingData(this._shareDataCheckBox.isSelected());
        }
        this._dataChanged = false;
    }
}

