/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.library.LibraryImportItem;
import com.sas.metadata.logical.library.LibraryNameValidator;
import com.sas.metadata.logical.library.LibraryOptionsPanel;
import com.sas.metadata.logical.library.LibraryOtherServerConnectionValidator;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Prototype;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.mgmt.visuals.PrototypeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

public class LibraryImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    public static final String PROPERTY_SUFFIX_DIRPATH = "DirPath";
    public static final String PROPERTY_SUFFIX_FILEPATH = "FilePath";
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);
    private Map m_mapContentInfo = null;
    private Map _tableCache = null;
    LibraryOptionsPanel m_optionsPanel;

    public LibraryImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public void initialize(ImportOperationInterface operation) {
        this._tableCache = new LinkedHashMap(10);
    }

    public ConnectionValidatorInterface[] getConnectionValidatorInterfaces() {
        ConnectionValidatorInterface[] validators = new ConnectionValidatorInterface[]{new LibraryOtherServerConnectionValidator()};
        return validators;
    }

    public Class[] getConnectionTypes() {
        return new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, LibraryConnectionType.class};
    }

    public Class[] getSubstitutionTypes() {
        return new Class[]{DirectoryPathSubstitutionType.class, FilePathSubstitutionType.class};
    }

    public ImportNameValidatorInterface getNameValidatorInterface() {
        return new LibraryNameValidator();
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        if (operation.getPromotionType() != 1) {
            return 0;
        }
        for (int iiIndex = 0; iiIndex < importItems.size(); ++iiIndex) {
            ImportItemInterface iif = (ImportItemInterface)importItems.get(iiIndex);
            String name = iif.getName();
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)iif.getTypeInterface(), (String)name, (int)(iiIndex + 1), (int)importItems.size()));
            if (iif.getImportState() == 2) {
                this.analyzeUpdatedLibrary(operation, iif);
            }
            if (operation.getPackageFileVersion() >= 9200) continue;
            Map objectMap = operation.getAssociationsForObject((PromotionItemInterface)iif, "<Template><SASLibrary> <DeployedComponents> <ServerContext Name =\"\"/> </DeployedComponents><UsingPackages> <File FileName=\"\" TextRole=\"\"/> <Directory Name=\"\" /> </UsingPackages> </SASLibrary> </Template>");
            Map libMap = (Map)objectMap.get(iif.getID());
            if (libMap == null) {
                operation.getLogger().debug((Object)("The map for " + name + " was unexpectedly null."));
                continue;
            }
            List usingPackagesFileList = (List)libMap.get("UsingPackages");
            if (usingPackagesFileList != null) {
                Iterator iterUsingPackages = usingPackagesFileList.iterator();
                int fileSubIndex = 1;
                while (iterUsingPackages.hasNext()) {
                    Map mapUsingPackage = (Map)iterUsingPackages.next();
                    String metadataType = (String)mapUsingPackage.get("MetadataObjectType");
                    if (!"File".equals(metadataType)) continue;
                    String textRole = (String)mapUsingPackage.get("TextRole");
                    String fileName = (String)mapUsingPackage.get("FileName");
                    if (!"XMLLibraryFile".equalsIgnoreCase(textRole) && !"XMLLibraryMap".equalsIgnoreCase(textRole)) continue;
                    operation.getPropertiesManager().createSubstitutionProperty(iif, "FilePath[" + fileSubIndex + "]", fileName);
                    ++fileSubIndex;
                }
            }
            List connectionPoints = iif.getConnectionPoints();
            Iterator cpIter = connectionPoints.iterator();
            String appServerName = null;
            while (cpIter.hasNext()) {
                ConnectionPointInterface cp = (ConnectionPointInterface)cpIter.next();
                if (!cp.getMetadataType().equalsIgnoreCase("ServerContext")) continue;
                String serverName = PromotionUtil.getAttrValue((String)cp.getSourceSearchString(), (String)"Name");
                String classid = PromotionUtil.getAttrValue((String)cp.getSourceSearchString(), (String)"ClassIdentifier");
                if (!"SAS Application Server".equalsIgnoreCase(classid)) continue;
                appServerName = serverName;
                break;
            }
            int dirSubIndex = 1;
            for (ConnectionPointInterface cp : connectionPoints) {
                if (!cp.getMetadataType().equalsIgnoreCase("Directory")) continue;
                cp.setActive(false);
                String path = PromotionUtil.getAttrValue((String)cp.getSourceSearchString(), (String)"DirectoryName");
                operation.getPropertiesManager().createSubstitutionProperty(iif, "DirPath[" + dirSubIndex + "]", path);
                if (appServerName != null) {
                    operation.getPropertiesManager().createSubstitutionProperty(iif, "DirPath[" + dirSubIndex + "].ApplicationServer", appServerName);
                }
                ++dirSubIndex;
            }
        }
        return 0;
    }

    private void analyzeUpdatedLibrary(ImportOperationInterface operation, ImportItemInterface importItem) throws MetadataPromotionException {
        MdObjectStore store = null;
        try {
            if (importItem.getTargetID() == null) {
                return;
            }
            store = operation.getMetadataFactory().createObjectStore(null, "PartialPromotion:LibraryImportStore");
            int flags = 268;
            SASLibrary library = (SASLibrary)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "SASLibrary", importItem.getTargetID(), null, null, "<TEMPLATES><SASLibrary><UsingPackages/></SASLibrary><DatabaseSchema><Tables/></DatabaseSchema></TEMPLATES>", flags);
            if (library != null) {
                AssociationList packages = library.getUsingPackages();
                if (packages.isEmpty()) {
                    return;
                }
                HashMap schemaMap = new HashMap(1);
                for (Root root : packages) {
                    String name;
                    DatabaseSchema schema;
                    AssociationList tables;
                    if (!(root instanceof DatabaseSchema) || (tables = (schema = (DatabaseSchema)root).getTables()).isEmpty()) continue;
                    LinkedHashSet<String> tableSet = new LinkedHashSet<String>();
                    for (Root tableRoot : tables) {
                        if (!(tableRoot instanceof PhysicalTable)) continue;
                        PhysicalTable table = (PhysicalTable)tableRoot;
                        tableSet.add(table.getId());
                    }
                    if (tableSet.isEmpty()) continue;
                    if (operation.getLogger().isDebugEnabled()) {
                        operation.getLogger().debug((Object)("Caching " + tableSet.size() + " table(s) associated to the library \"" + importItem.toString() + "\"."));
                    }
                    if (schemaMap.containsKey(name = schema.getName())) {
                        Set set = (Set)schemaMap.get(name);
                        set.addAll(tableSet);
                        continue;
                    }
                    schemaMap.put(schema.getName(), tableSet);
                }
                if (schemaMap.size() > 0) {
                    this._tableCache.put(library.getId(), schemaMap);
                }
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        finally {
            try {
                if (store != null) {
                    store.dispose();
                }
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new LibraryImportItem(name, id, type);
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        int iRC = 0;
        try {
            List lConnectionPoints = operation.getConnectionManager().getConnections();
            for (ConnectionPointInterface connPoint : lConnectionPoints) {
                ConnectionTypeInterface type;
                if ("Login".equals(connPoint.getMetadataType())) {
                    String searchCriteria = "<XMLSelect search=\"" + connPoint.getSourceSearchString() + "\"/>";
                    int flags = 8576;
                    List loginList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Login", flags, searchCriteria);
                    if (loginList.isEmpty()) continue;
                    Login loginObj = (Login)loginList.get(0);
                    connPoint.setTargetID(loginObj.getFQID());
                    connections.add(connPoint);
                    continue;
                }
                if (!"SASClientConnection".equals(connPoint.getMetadataType())) continue;
                String srcServerName = "";
                String searchAttribute = connPoint.getSourceSearchString();
                int index = searchAttribute.indexOf("@Name='");
                if (index > -1) {
                    srcServerName = searchAttribute.substring(index + 7, searchAttribute.indexOf("']", index + 7));
                }
                if ((type = operation.getConnectionType(OtherServerConnectionType.getTypeClassName())) == null) continue;
                Map connectionMap = type.getConnectionMapping();
                for (Map.Entry entry : connectionMap.entrySet()) {
                    String targetID;
                    SourceConnectionInterface sourceConnection = (SourceConnectionInterface)entry.getKey();
                    TargetConnectionInterface targetConnection = (TargetConnectionInterface)entry.getValue();
                    if (!sourceConnection.getDisplayName().equals(srcServerName) || targetConnection == null || (targetID = targetConnection.getTargetID()) == null) continue;
                    String strType = "ServerComponent";
                    String strSelect = "<Templates><ServerComponent><SourceConnections/></ServerComponent></Templates>";
                    int flags = 8584;
                    ServerComponent server = (ServerComponent)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), strType, targetID, null, null, strSelect, flags);
                    AssociationList sccList = server.getSourceConnections();
                    Connection bestMatch = null;
                    for (Connection c : sccList) {
                        if (!(c instanceof SASClientConnection)) continue;
                        bestMatch = c;
                        if (c.getName() == null || connPoint.getName() == null || !c.getName().equals(connPoint.getName())) continue;
                        break;
                    }
                    if (bestMatch != null) {
                        connPoint.setTargetID(bestMatch.getFQID());
                        connections.add(connPoint);
                        continue;
                    }
                    operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.NoSasClientConnectionLog.txt"), (Object)server.getName()));
                    iRC = 8;
                }
            }
        }
        catch (MdException mde) {
            operation.getLogger().error((Object)mde.getLocalizedMessage());
            iRC = 8;
        }
        catch (RemoteException re) {
            iRC = 8;
            throw new MetadataPromotionException((Throwable)re);
        }
        return iRC;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        String strTemplate = "<TEMPLATES><SASLibrary><UsingPackages/><UsingPrototype/><Properties/></SASLibrary><DatabaseSchema><UsedByPackages/></DatabaseSchema></TEMPLATES>";
        int flags = 16652;
        try {
            for (LibraryImportItem libItem : objects) {
                Prototype usingPrototype;
                Object obj2;
                Directory directory;
                SASLibrary sasLib = (SASLibrary)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "SASLibrary", libItem.getTargetID(), null, null, "<TEMPLATES><SASLibrary><UsingPackages/><UsingPrototype/><Properties/></SASLibrary><DatabaseSchema><UsedByPackages/></DatabaseSchema></TEMPLATES>", flags);
                if (operation.getPackageFileVersion() < 9200) {
                    List subList = libItem.getSubstitutions();
                    if (subList != null && !subList.isEmpty() && sasLib.getUsingPackages().isEmpty()) {
                        for (int index = 0; index < subList.size(); ++index) {
                            SubstitutionInterface s = (SubstitutionInterface)subList.get(index);
                            if (s.getSubstitutionType().getSubstitutionTypeName().startsWith(PROPERTY_SUFFIX_DIRPATH)) {
                                directory = (Directory)operation.getStore().getFactory().createComplexMetadataObject(operation.getStore(), "Path", "Directory", sasLib.getRepositoryID());
                                directory.setDirectoryName(s.getTargetValue());
                                directory.setDirectoryRole("LibraryPath");
                                directory.setUsageVersion(CURRENT_VERSION.encode());
                                sasLib.getUsingPackages().add((Object)directory);
                                operation.getStore().updatedMetadataAll();
                                continue;
                            }
                            if (!s.getSubstitutionType().getSubstitutionTypeName().startsWith(PROPERTY_SUFFIX_FILEPATH)) continue;
                            File file = (File)operation.getStore().getFactory().createComplexMetadataObject(operation.getStore(), "XML File", "File", sasLib.getRepositoryID());
                            file.setFileName(s.getTargetValue());
                            sasLib.getUsingPackages().add((Object)file);
                            operation.getStore().updatedMetadataAll();
                        }
                    }
                } else {
                    AssociationList usingPackages = sasLib.getUsingPackages();
                    for (Object obj2 : usingPackages) {
                        if (!(obj2 instanceof Directory)) continue;
                        directory = (Directory)obj2;
                        directory.setUsageVersion(CURRENT_VERSION.encode());
                        operation.getStore().updatedMetadataAll();
                    }
                }
                List connPoints = libItem.getConnectionPoints();
                ConnectionPointInterface prototype = null;
                obj2 = connPoints.iterator();
                while (obj2.hasNext()) {
                    ConnectionPointInterface connPoint = (ConnectionPointInterface)obj2.next();
                    if (!"Prototype".equals(connPoint.getMetadataType())) continue;
                    prototype = connPoint;
                    break;
                }
                if ((usingPrototype = prototype != null ? this.retrievePrototypeByName(operation, prototype.getName()) : this.retrievePrototypeByEngine(operation, connPoints, sasLib.getEngine())) != null) {
                    sasLib.getUsingPrototypes().add((Object)usingPrototype);
                    operation.getStore().updatedMetadataAll();
                } else {
                    operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.UsingPrototypeNotFound.txt"), (Object)sasLib.getEngine()));
                    rc |= 4;
                }
                if ("SASIOIME".equalsIgnoreCase(sasLib.getEngine())) {
                    AssociationList propertyList = sasLib.getProperties();
                    for (Property prop : propertyList) {
                        if (!prop.getPropertyName().trim().equalsIgnoreCase("MAPPATH")) continue;
                        String oldMapPath = this.mapPathToCanonicalPath(prop.getDefaultValue());
                        String mapPath = "";
                        List mapList = operation.getPromotionItems("InformationMap.Relational");
                        for (ImportItemInterface mapIif : mapList) {
                            String s = BIPTreeUtil.pathToString((String[])mapIif.getSourcePath());
                            if (!oldMapPath.equals(s)) continue;
                            mapPath = BIPTreeUtil.pathToString((String[])mapIif.getTargetPath());
                            break;
                        }
                        if (mapPath.equals("")) {
                            String sPathWithType = oldMapPath + "(Folder)";
                            PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)sPathWithType);
                            MetadataInterface metadataObject = PromotionUtil.getObjectFromPath((ServerInterface)operation.getServer(), (PathUrl)pathUrl);
                            boolean mapPathExistsOnTarget = metadataObject != null;
                            mapPath = mapPathExistsOnTarget ? oldMapPath : BIPTreeUtil.pathToString((String[])libItem.getTargetPath());
                        }
                        if (!mapPath.equals(oldMapPath)) {
                            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.MapPathUpdate.txt"), (Object)sasLib.getName(), (Object)mapPath));
                        }
                        if (mapPath.equals("")) {
                            mapPath = "\"\"";
                        } else {
                            if (!mapPath.startsWith("\"")) {
                                mapPath = "\"" + mapPath;
                            }
                            if (!mapPath.endsWith("\"")) {
                                mapPath = mapPath + "\"";
                            }
                        }
                        prop.setDefaultValue(mapPath);
                        operation.getStore().updatedMetadataAll();
                        break;
                    }
                }
                if (operation.getPackageFileVersion() < 9200) {
                    AssociationList upList = sasLib.getUsingPackages();
                    for (Root root : upList) {
                        DatabaseSchema schema;
                        AssociationList objList;
                        if (!(root instanceof DatabaseSchema) || (objList = (schema = (DatabaseSchema)root).getUsedByPackages()) == null || objList.size() <= 1) continue;
                        ArrayList<Root> schemaLibList = new ArrayList<Root>();
                        for (int j = 0; j < objList.size(); ++j) {
                            Root obj3 = (Root)objList.get(j);
                            if (!obj3.getCMetadataType().equals("SASLibrary")) continue;
                            schemaLibList.add(obj3);
                        }
                        if (schemaLibList == null || schemaLibList.size() <= 1) continue;
                        DatabaseSchema newSchema = (DatabaseSchema)operation.getMetadataFactory().createComplexMetadataObject(operation.getStore(), schema.getName(), "DatabaseSchema", sasLib.getRepositoryID());
                        newSchema.setSchemaName(schema.getSchemaName());
                        AssociationList dcList = schema.getDeployedComponents(true);
                        if (dcList != null && dcList.size() >= 1) {
                            DeployedComponent dc = (DeployedComponent)dcList.get(0);
                            newSchema.getDeployedComponents().add((Object)dc);
                        }
                        sasLib.getUsingPackages().remove((Object)schema);
                        sasLib.getUsingPackages().add((Object)newSchema);
                        operation.getStore().updatedMetadataAll();
                        operation.getLogger().warn((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.SharedTables.txt"), (Object)sasLib.getName()));
                    }
                }
                if (libItem.getImportState() != 2 || !this._tableCache.containsKey(sasLib.getId())) continue;
                rc |= this.updateTableAssociations(operation, libItem, sasLib);
            }
            return rc;
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        catch (MdException me) {
            throw new MetadataPromotionException((Throwable)me);
        }
        catch (ServiceException se) {
            throw new MetadataPromotionException((Throwable)se);
        }
    }

    public Prototype retrievePrototypeByEngine(ImportOperationInterface operation, List<ConnectionPointInterface> connPoints, String engine) throws RemoteException, MdException {
        Prototype usingPrototype = null;
        if ("DB2".equalsIgnoreCase(engine)) {
            for (ConnectionPointInterface connPoint : connPoints) {
                if (!"ServerComponent".equals(connPoint.getMetadataType())) continue;
                String classId = null;
                classId = connPoint.getSourceSearchList().toString().indexOf("DB2UNXPC") > 0 ? "DB2UNXPC" : "DB2OS390";
                usingPrototype = PrototypeUtil.getPrototypeByIdentifier((MdFactory)operation.getMetadataFactory(), (String)"Extensions", (String)"ServerClassIdentifier", (String)classId, (String)operation.getFoundationRepositoryID(), (String)"SASLibrary", null, (MdStore)operation.getStore());
            }
        } else {
            usingPrototype = PrototypeUtil.getPrototypeByIdentifier((MdFactory)operation.getMetadataFactory(), (String)"PrototypeProperties", (String)"Engine", (String)engine, (String)operation.getFoundationRepositoryID(), (String)"SASLibrary", null, (MdStore)operation.getStore());
        }
        if (usingPrototype == null) {
            usingPrototype = this.retrievePrototypeByName(operation, "Library.Generic.Prototype.Name.xmlKey.txt");
        }
        return usingPrototype;
    }

    private Prototype retrievePrototypeByName(ImportOperationInterface operation, String name) throws RemoteException, MdException {
        int flags = 392;
        String select = "<XMLSELECT search = \"*[@Name='" + name + "']\"/>";
        List upList = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getFoundationRepositoryID(), "Prototype", flags, select);
        Prototype usingPrototype = upList.size() >= 1 ? (Prototype)upList.get(0) : null;
        return usingPrototype;
    }

    private int updateTableAssociations(ImportOperationInterface operation, LibraryImportItem libItem, SASLibrary sasLib) {
        int rc = 0;
        try {
            Map schemaMap = (Map)this._tableCache.get(sasLib.getId());
            for (String originalSchemaName : schemaMap.keySet()) {
                AssociationList usingPackages = sasLib.getUsingPackages();
                for (Root schema : usingPackages) {
                    boolean updateSchema = false;
                    if (schema instanceof DatabaseSchema && originalSchemaName.equals(schema.getName())) {
                        Set originalTables = (Set)schemaMap.get(originalSchemaName);
                        for (String tableID : originalTables) {
                            AssociationList tablePackages;
                            String options = "<XMLSELECT search=\"@Id='" + tableID + "'\"/>";
                            int objCount = operation.getMetadataFactory().getOMIUtil().doesObjectExist("A0000001." + tableID.substring(0, 8), "WorkTable", options);
                            PhysicalTable table = null;
                            table = objCount > 0 ? (PhysicalTable)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "WorkTable", tableID, null, null, "", 8) : (PhysicalTable)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "PhysicalTable", tableID, null, null, "", 8);
                            if (table == null || !(tablePackages = table.getTablePackages(true)).isEmpty()) continue;
                            ((DatabaseSchema)schema).getTables().add((Object)table);
                            updateSchema = true;
                        }
                    }
                    if (!updateSchema) continue;
                    if (operation.getLogger().isDebugEnabled()) {
                        operation.getLogger().debug((Object)("Preserving tables association for the library \"" + libItem.toString() + "\"."));
                    }
                    schema.updateMetadataAll();
                }
            }
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"LibraryImportListener.AttachTables.fmt.txt", (Object)libItem.toString(), (Object)e.getLocalizedMessage());
            operation.getLogger().warn((Object)msg);
            rc = 4;
        }
        return rc;
    }

    String mapPathToCanonicalPath(String oldMapPath) {
        StringBuffer temp = oldMapPath == null ? new StringBuffer("/") : new StringBuffer(oldMapPath);
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '\"') continue;
            temp.deleteCharAt(i);
        }
        return temp.toString();
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        Log importLogger = operation.getLogger();
        int iRC = 0;
        if (operation.getPromotionType() == 2) {
            return iRC;
        }
        this.m_mapContentInfo = new HashMap();
        for (LibraryImportItem libImportItem : objects) {
            Map mapContentStreams = contentHandler.getBinaryContent(libImportItem.getID());
            if (mapContentStreams.isEmpty()) continue;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.StatusIndicator.txt"), (Object)libImportItem.getName()));
            try {
                String engine = operation.getMetadataFactory().getOMIUtil().getMetadataSimple("SASLibrary", libImportItem.getTargetID(), "Engine");
                if (!engine.equalsIgnoreCase("XML")) continue;
                this.createContentObjects(operation, (ImportItemInterface)libImportItem, mapContentStreams, importLogger);
            }
            catch (MdException mde) {
                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.ErrorRetrievingLibrary.txt"), (Object)mde.getMessage()));
                iRC |= 8;
            }
        }
        for (ServerContext mdSC : this.m_mapContentInfo.keySet()) {
            List lContentInfo = (List)this.m_mapContentInfo.get(mdSC);
            if (lContentInfo == null || lContentInfo.isEmpty()) continue;
            this.fireDisplayMessage(RB.getStringResource("LibraryImportListener.WritingContent.txt"));
            int iTempRC = this.writeContentToServer(mdSC, lContentInfo, operation, importLogger);
            if (iTempRC <= iRC) continue;
            iRC = iTempRC;
        }
        return iRC;
    }

    private List getContentListForServer(ServerContext mdSC) {
        ArrayList lContentInfo = (ArrayList)this.m_mapContentInfo.get(mdSC);
        if (lContentInfo == null) {
            lContentInfo = new ArrayList();
            this.m_mapContentInfo.put(mdSC, lContentInfo);
        }
        return lContentInfo;
    }

    private void createContentObjects(ImportOperationInterface operation, ImportItemInterface importItem, Map mapContentStreams, Log importLogger) throws RemoteException {
        List lContentInfo = null;
        InputStream inStream = null;
        LibraryImportItem libImportItem = (LibraryImportItem)importItem;
        importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.ImpExpLogObj.fmt.txt"), (Object)this.getTypeInterface().getDisplayType(), (Object)libImportItem.toString(), (Object)libImportItem.getTargetID()));
        try {
            int iOptions = 268;
            String strPackageTemplate = "<Templates><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></Templates>";
            SASLibrary sasLib = (SASLibrary)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "SASLibrary", libImportItem.getTargetID(), null, null, strPackageTemplate, iOptions);
            ServerContext libServer = null;
            AssociationList serverContextList = sasLib.getDeployedComponents();
            for (DeployedComponent dc : serverContextList) {
                if (!(dc instanceof ServerContext)) continue;
                libServer = (ServerContext)dc;
            }
            if (libServer == null) {
                if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No ServerContext found on Library " + sasLib.getFQID() + " : " + sasLib.getName() + "\n Using default application server. "));
                }
                return;
            }
            AssociationList files = sasLib.getUsingPackages();
            for (int i = 0; i < files.size(); ++i) {
                File libFile = (File)files.get(i);
                String role = libFile.getTextRole();
                if (!libImportItem.m_bIncludeContent) {
                    String contentNotImported = "Optional content \"{0}\" not imported for library \"{1}\"";
                    importLogger.debug(contentNotImported, (Object)libFile.getFileName(), (Object)sasLib.getName());
                }
                if (!role.equalsIgnoreCase("XMLLibraryMap") && !libImportItem.m_bIncludeContent) continue;
                inStream = (InputStream)mapContentStreams.get(role.equalsIgnoreCase("XMLLibraryMap") ? "###MAP_FILE###" : "###XML_FILE###");
                if (inStream != null) {
                    lContentInfo = this.getContentListForServer(libServer);
                    lContentInfo.add(new LibraryContentObject(inStream, libFile.getFileName(), sasLib.getName()));
                    continue;
                }
                importLogger.debug((Object)("No content stream found for " + libFile.getFileName()));
            }
        }
        catch (MdException e) {
            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryImportListener.ErrorRetrievingLibrary.txt"), (Object)e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeContentToServer(ServerContext mdSC, List lContentInfo, ImportOperationInterface operation, Log importLogger) throws RemoteException {
        int iRC = 0;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)mdSC);
            ContentHandlerInterface contentHandler = operation.getContentHandler();
            for (LibraryContentObject libContentObj : lContentInfo) {
                InputStream inStream = libContentObj.m_inStream;
                try {
                    importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.ImpExpLogObj2.fmt.txt"), (Object)this.getTypeInterface().getDisplayType(), (Object)libContentObj.m_name));
                    IFileService fileService = appServer.getWorkspace().FileService();
                    try {
                        IFileref fileRef = fileService.AssignFileref("TEMPREF", "DISK", libContentObj.m_path, "", new StringHolder());
                        IBinaryStream outStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
                        contentHandler.writeToBinaryStream(inStream, outStream);
                    }
                    finally {
                        fileService.DeassignFileref("TEMPREF");
                    }
                }
                catch (Exception e) {
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.ImportContentError.txt"), (Object)mdSC.getName(), (Object)e.getMessage()));
                }
            }
        }
        catch (WsAppServerFailException e) {
            iRC = 8;
            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.ServerError.txt"), (Object)mdSC.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return iRC;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface handler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface handler) {
        if (this.m_optionsPanel == null) {
            this.m_optionsPanel = new LibraryOptionsPanel(handler.getPromotionType());
        }
        this.m_optionsPanel.populateImportOptions(items, handler);
        return this.m_optionsPanel;
    }

    public void saveSettings() {
        if (this.m_optionsPanel != null) {
            this.m_optionsPanel.saveSettings();
        }
    }

    private static class LibraryContentObject {
        InputStream m_inStream;
        String m_path;
        String m_name;

        LibraryContentObject(InputStream inStream, String path, String name) {
            this.m_inStream = inStream;
            this.m_name = name;
            this.m_path = path;
        }
    }
}

