/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.library.LibraryExportItem;
import com.sas.metadata.logical.library.LibraryOptionsPanel;
import com.sas.metadata.logical.library.RB;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.TransportException;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

public class LibraryExportListener
extends AbstractExportListener
implements PromotionOptionsInterface {
    LibraryOptionsPanel m_optionsPanel;

    public LibraryExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, LibraryConnectionType.class};
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new LibraryExportItem(name, id, type);
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface exportOperation) {
        if (this.m_optionsPanel == null) {
            this.m_optionsPanel = new LibraryOptionsPanel(exportOperation.getPromotionType());
        }
        this.m_optionsPanel.populateExportOptions(items, exportOperation);
        return this.m_optionsPanel;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface handler) {
        return null;
    }

    public void saveSettings() {
        if (this.m_optionsPanel != null) {
            this.m_optionsPanel.saveSettings();
        }
    }

    public int exportContent(ExportOperationInterface exportOperation, List objects) throws TransportException, IOException, MdException, RemoteException {
        Log exportLogger = exportOperation.getLogger();
        int rc = 0;
        for (LibraryExportItem libExportItem : objects) {
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.StatusIndicator.txt"), (Object)libExportItem.getName()));
            String engine = exportOperation.getMetadataFactory().getOMIUtil().getMetadataSimple("SASLibrary", libExportItem.getID(), "Engine");
            if (!engine.equalsIgnoreCase("XML")) continue;
            int flags = 268;
            String strTemplate = "<Templates><SASLibrary><DeployedComponents/><UsingPackages/></SASLibrary></Templates>";
            SASLibrary sasLib = (SASLibrary)exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)exportOperation.getStore(), "SASLibrary", libExportItem.getID(), null, null, strTemplate, flags);
            ServerContext libServer = null;
            AssociationList serverContextList = sasLib.getDeployedComponents();
            for (DeployedComponent dc : serverContextList) {
                if (!(dc instanceof ServerContext)) continue;
                libServer = (ServerContext)dc;
                break;
            }
            if (libServer == null) {
                if (!exportLogger.isDebugEnabled()) continue;
                exportLogger.debug((Object)("No ServerContext found on Library " + sasLib.getFQID() + " : " + sasLib.getName() + "\n Using default application server. "));
                continue;
            }
            flags = 396;
            String select = "<XMLSELECT search = \"*[@Name='XML Map' OR @Name='XML File'][UsedByPackages/SASLibrary[@Id ='" + libExportItem.getID() + "']]\"/>";
            String template = "<TEMPLATES><File><UsedByPackages/><SASLibrary/></File></TEMPLATES>";
            String options = select + template;
            List xmlFiles = exportOperation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)exportOperation.getStore(), exportOperation.getRepositoryID(), "File", flags, options);
            if (xmlFiles == null || xmlFiles.size() == 0) {
                if (!exportLogger.isDebugEnabled()) continue;
                exportLogger.debug((Object)("No Files associated to " + sasLib.getName() + " (" + sasLib.getFQID() + ")"));
                continue;
            }
            ArrayList<LibraryContentObject> contentObjectList = new ArrayList<LibraryContentObject>();
            for (int i = 0; i < xmlFiles.size(); ++i) {
                String key;
                File xmlFile = (File)xmlFiles.get(i);
                String string = key = xmlFile.getTextRole().equalsIgnoreCase("XMLLibraryMap") ? "###MAP_FILE###" : "###XML_FILE###";
                if (!key.equalsIgnoreCase("###MAP_FILE###") && !libExportItem.m_bIncludeContent) continue;
                contentObjectList.add(new LibraryContentObject(libExportItem.getName(), libExportItem.getID(), xmlFile.getFileName(), key, libServer));
                if (!key.equalsIgnoreCase("###XML_FILE###")) continue;
                exportOperation.getPropertiesFile().addProperty(libExportItem.getID() + "Optional Content: ", "true");
            }
            if (contentObjectList.isEmpty()) continue;
            rc |= this.retrieveContentFromServer(contentObjectList, exportOperation, exportLogger);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retrieveContentFromServer(List libContentObjects, ExportOperationInterface exportOperation, Log exportLogger) throws RemoteException {
        int rc = 0;
        if (libContentObjects == null || libContentObjects.size() == 0) {
            return rc;
        }
        LibraryContentObject libContentObject = (LibraryContentObject)libContentObjects.get(0);
        ServerContext libServer = libContentObject.m_server;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)exportOperation, (ServerContext)libServer);
            ContentHandlerInterface contentHandler = exportOperation.getContentHandler();
            for (int i = 0; i < libContentObjects.size(); ++i) {
                LibraryContentObject libObj = (LibraryContentObject)libContentObjects.get(i);
                exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.ImpExpLogObj.fmt.txt"), (Object)this.getTypeInterface().getDisplayType(), (Object)libObj.m_name, (Object)libObj.m_id));
                IFileService fileService = appServer.getWorkspace().FileService();
                IFileref fileRef = fileService.AssignFileref("TEMPREF", "DISK", libObj.m_path, "", new StringHolder());
                IBinaryStream inStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForReading);
                InputStream stream = contentHandler.getInputStream(inStream);
                contentHandler.addBinaryContent(libObj.m_id, libObj.m_key, stream);
                fileService.DeassignFileref("TEMPREF");
            }
        }
        catch (WsAppServerFailException e) {
            rc = 8;
            exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.ServerError.txt"), (Object)libServer.getName(), (Object)e.getMessage()));
        }
        catch (Exception e) {
            rc = 8;
            exportLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("LibraryExportListener.ExportContentError.txt"), (Object)appServer.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return rc;
    }

    private static class LibraryContentObject {
        String m_name;
        String m_id;
        String m_path;
        String m_key;
        ServerContext m_server;

        LibraryContentObject(String name, String id, String path, String key, ServerContext server) {
            this.m_name = name;
            this.m_id = id;
            this.m_path = path;
            this.m_key = key;
            this.m_server = server;
        }
    }
}

