/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.library;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Transformation;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LibraryExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    boolean m_bIncludeContent = true;

    public LibraryExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObject> relatedObjects = new ArrayList<SimpleLogicalObject>();
        try {
            int options = 16652;
            String strLibTemplate = "<Templates><SASLibrary><Tables/><UsingPackages/><TargetTransformations/><SourceTransformations/></SASLibrary><DatabaseSchema><Tables/></DatabaseSchema><Transformation><TransformationSources/><TransformationTargets/></Transformation></Templates>";
            SASLibrary library = (SASLibrary)this.getExportOperation().getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)this.getExportOperation().getStore(), "SASLibrary", this.getID(), null, null, strLibTemplate, options);
            if (relationshipType == 1) {
                ArrayList physicalTableList = new ArrayList();
                if (library.getIsDBMSLibname() == 1) {
                    AssociationList usingPackages = library.getUsingPackages();
                    if (!usingPackages.isEmpty()) {
                        Object obj = usingPackages.get(0);
                        if (obj instanceof DatabaseSchema) {
                            DatabaseSchema schema = (DatabaseSchema)usingPackages.get(0);
                            physicalTableList.addAll(schema.getTables());
                        } else if (obj instanceof SASLibrary) {
                            SASLibrary saslib = (SASLibrary)obj;
                            TypeInterface type = Factory.getInstance().locateTypeInterfaceForRoot((Root)saslib);
                            SimpleLogicalObject simpObject = new SimpleLogicalObject(saslib.getName(), saslib.getFQID(), type);
                            relatedObjects.add(simpObject);
                        }
                    }
                } else {
                    physicalTableList.addAll(library.getTables());
                }
                for (int i = 0; i < physicalTableList.size(); ++i) {
                    DataTable table = (DataTable)physicalTableList.get(i);
                    TypeInterface type = Factory.getInstance().locateTypeInterfaceForRoot((Root)table);
                    if (type == null) continue;
                    SimpleLogicalObject simpObject = new SimpleLogicalObject(table.getName(), table.getFQID(), type);
                    relatedObjects.add(simpObject);
                }
                Transformation dataProviderTransformation = null;
                AssociationList Trans = library.getSourceTransformations();
                for (Object trans : Trans) {
                    if (!(trans instanceof Transformation) || !trans.getTransformRole().equalsIgnoreCase("DataProviderLibrary")) continue;
                    dataProviderTransformation = (Transformation)trans;
                    break;
                }
                if (dataProviderTransformation != null) {
                    AssociationList trans = dataProviderTransformation.getTransformationTargets();
                    for (Root target : trans) {
                        if (!(target instanceof SASLibrary)) continue;
                        SimpleLogicalObject simpObject = new SimpleLogicalObject(target.getName(), target.getFQID(), this.getTypeInterface());
                        relatedObjects.add(simpObject);
                    }
                }
            } else if (relationshipType == 0) {
                relatedObjects.addAll(NoteUtil.getDependentNotes((Root)library));
                relatedObjects.addAll(DocumentUtil.getDependentDocuments((Root)library));
                AssociationList usedByPackages = library.getUsedByPackages();
                for (int i = 0; i < usedByPackages.size(); ++i) {
                    Object obj = usedByPackages.get(i);
                    if (!(obj instanceof SASLibrary)) continue;
                    SASLibrary associatedLibrary = (SASLibrary)obj;
                    SimpleLogicalObject simpObject = new SimpleLogicalObject(associatedLibrary.getName(), associatedLibrary.getFQID(), this.getTypeInterface());
                    relatedObjects.add(simpObject);
                }
                Transformation dataProviderTransformation = null;
                AssociationList tgtTrans = library.getTargetTransformations();
                for (AbstractTransformation trans : tgtTrans) {
                    if (!(trans instanceof Transformation) || !trans.getTransformRole().equalsIgnoreCase("DataProviderLibrary")) continue;
                    dataProviderTransformation = (Transformation)trans;
                    break;
                }
                if (dataProviderTransformation != null) {
                    AssociationList transSources = dataProviderTransformation.getTransformationSources();
                    for (Root source : transSources) {
                        if (!(source instanceof SASLibrary)) continue;
                        SimpleLogicalObject simpObject = new SimpleLogicalObject(source.getName(), source.getFQID(), this.getTypeInterface());
                        relatedObjects.add(simpObject);
                    }
                }
            }
            return relatedObjects;
        }
        catch (MdException mde) {
            throw new LogicalTypeException((Exception)((Object)mde));
        }
        catch (RemoteException re) {
            throw new LogicalTypeException((Exception)re);
        }
    }
}

