/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.externalfile;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.comparison.ComparisonTemplateFactory;
import com.sas.metadata.logical.externalfile.ExternalFileImportItem;
import com.sas.metadata.logical.externalfile.ExternalFileOptionsPanel;
import com.sas.metadata.logical.externalfile.ExternalFileUtil;
import com.sas.metadata.logical.externalfile.RB;
import com.sas.metadata.logical.library.LibraryConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.FilePathSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.table.ColumnMergeManager;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASFileRef;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.tools.tablecomparator.NestedItemMergeManager;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

public class ExternalFileImportListener
extends AbstractImportListener
implements PromotionOptionsInterface,
NotificationListener {
    private ExternalFileOptionsPanel m_pnlOptions;
    private Map m_mapContentInfo;
    private Map m_mapLocations;
    private ColumnMergeManager m_manager = null;
    private String PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS = "sas.promotion.columns.excludenewcolumns";
    private String PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS = "sas.promotion.columns.deletetargetcolumns";
    protected static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, LibraryConnectionType.class, TableConnectionType.class});
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{FilePathSubstitutionType.class};
    private static final String MAIN_FILE_PATH = "OwningFile.FilePath";
    private static final String MAIN_FILE_PATH_SERVER = "OwningFile.FilePath.ApplicationServer";
    private static final String FORMAT_FILE_PATH = "FormatFile.FilePath";
    private static final String FORMAT_FILE_PATH_SERVER = "FormatFile.FilePath.ApplicationServer";
    private static final String COBOL_FILE_PATH = "CobolFormatFile.FilePath";
    private static final String COBOL_FILE_PATH_SERVER = "CobolFormatFile.FilePath.ApplicationServer";
    private static final String USERWRITTEN_FILE_PATH = "UserWrittenSourceCode.FilePath";
    private static final String USER_WRITTEN_FILE_PATH_SERVER = "UserWrittenSourceCode.FilePath.ApplicationServer";

    public ExternalFileImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new ExternalFileImportItem(name, id, type);
    }

    public JPanel getOptionsPanel(ExportItemInterface[] aItems, ExportOperationInterface exportHandler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] aItems, ImportOperationInterface importHandler) {
        Boolean listenerExists;
        if (this.m_pnlOptions == null) {
            this.m_pnlOptions = new ExternalFileOptionsPanel(importHandler.getPromotionType());
        }
        if ((listenerExists = (Boolean)importHandler.getObjectFromCache((Object)"ExternalFile.ImportListener.OptionsNotificationListener")) == null || !listenerExists.booleanValue()) {
            importHandler.addNotificationListener((NotificationListener)this.m_pnlOptions);
            importHandler.addObjectToCache((Object)"ExternalFile.ImportListener.OptionsNotificationListener", (Object)Boolean.TRUE);
        }
        this.m_pnlOptions.populateImportOptions(aItems, importHandler.getPropertiesFile());
        return this.m_pnlOptions;
    }

    public void saveSettings() {
        this.m_pnlOptions.saveSettings();
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        boolean deleteSrcCols = Boolean.getBoolean(this.PROPERTY_EXCLUDE_SOURCE_ONLY_COLUMNS);
        boolean deleteTgtCols = Boolean.getBoolean(this.PROPERTY_EXCLUDE_TARGET_ONLY_COLUMNS);
        NestedItemMergeManager _mergeManager = NestedItemMergeManager.getInstance(objects);
        if (operation.getPackageFileVersion() < 9200) {
            Map mapExternalFiles = operation.getAssociationsForObjects(objects, "<Template><ExternalTable><OwningFile><File FileName=\"\"><FileRefs><SASFileRef><DeployedComponents><ServerContext ClassIdentifier=\"\"/></DeployedComponents></SASFileRef></FileRefs></File></OwningFile><TargetTransformations><ClassifierMap TransformRole=\"\"><TransformationSources><File FileName=\"\"><DeployedComponents><ServerContext/></DeployedComponents><TargetTransformations><ClassifierMap TransformRole=\"\"><TransformationSources><File FileName=\"\"><DeployedComponents><ServerContext/></DeployedComponents></File></TransformationSources></ClassifierMap></TargetTransformations></File></TransformationSources></ClassifierMap></TargetTransformations></ExternalTable></Template>");
            PropertiesManager propMgr = operation.getPropertiesManager();
            int index = 1;
            int count = objects.size();
            for (ImportItemInterface importItem : objects) {
                this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
                Map mapExternalTable = (Map)mapExternalFiles.get(importItem.getID());
                List lOwningFiles = (List)mapExternalTable.get("OwningFile");
                Map mapOwningFile = (Map)lOwningFiles.get(0);
                String sFileName = (String)mapOwningFile.get("FileName");
                String sDefaultSC = null;
                List lFileRefs = (List)mapOwningFile.get("FileRefs");
                if (!lFileRefs.isEmpty()) {
                    Map mapFileRef = (Map)lFileRefs.get(0);
                    List lDeployedComponents = (List)mapFileRef.get("DeployedComponents");
                    for (Map mapDeployedComponent : lDeployedComponents) {
                        if (!"ServerContext".equals(mapDeployedComponent.get("MetadataObjectType"))) continue;
                        sDefaultSC = (String)mapDeployedComponent.get("Name");
                        propMgr.createSubstitutionProperty(importItem, MAIN_FILE_PATH, ExternalFileUtil.decodeXMLEncodedString(sFileName));
                        propMgr.createSubstitutionProperty(importItem, MAIN_FILE_PATH_SERVER, ExternalFileUtil.decodeXMLEncodedString(sDefaultSC));
                        break;
                    }
                }
                List lCMs = (List)mapExternalTable.get("TargetTransformations");
                for (Map mapClassifierMap : lCMs) {
                    Map mapSourceFile;
                    List lSourceFiles;
                    String sTransformRole = (String)mapClassifierMap.get("TransformRole");
                    if ("FormatFile".equals(sTransformRole)) {
                        List lCopyBookFiles;
                        Map mapCopyBookCM;
                        List lEFFFiles = (List)mapClassifierMap.get("TransformationSources");
                        if (lEFFFiles.isEmpty()) continue;
                        Map mapEFFFile = (Map)lEFFFiles.get(0);
                        String sEFFFileName = (String)mapEFFFile.get("FileName");
                        String sEFFFileSC = sDefaultSC;
                        List lEFFFileSCs = (List)mapEFFFile.get("DeployedComponents");
                        if (!lEFFFileSCs.isEmpty()) {
                            Map mapEFFFileSC = (Map)lEFFFileSCs.get(0);
                            sEFFFileSC = (String)mapEFFFileSC.get("Name");
                        }
                        propMgr.createSubstitutionProperty(importItem, FORMAT_FILE_PATH, ExternalFileUtil.decodeXMLEncodedString(sEFFFileName));
                        propMgr.createSubstitutionProperty(importItem, FORMAT_FILE_PATH_SERVER, ExternalFileUtil.decodeXMLEncodedString(sEFFFileSC));
                        List lCopyBookCMs = (List)mapEFFFile.get("TargetTransformations");
                        if (lCopyBookCMs.isEmpty() || !"CobolFormatFile".equals((mapCopyBookCM = (Map)lCopyBookCMs.get(0)).get("TransformRole")) || (lCopyBookFiles = (List)mapCopyBookCM.get("TransformationSources")).isEmpty()) continue;
                        Map mapCopyBookFile = (Map)lCopyBookFiles.get(0);
                        String sCopyBookFileName = (String)mapCopyBookFile.get("FileName");
                        String sCopyBookFileSC = sDefaultSC;
                        List lCopyBookFileSCs = (List)mapCopyBookFile.get("DeployedComponents");
                        if (!lCopyBookFileSCs.isEmpty()) {
                            Map mapCopyBookFileSC = (Map)lCopyBookFileSCs.get(0);
                            sCopyBookFileSC = (String)mapCopyBookFileSC.get("Name");
                        }
                        propMgr.createSubstitutionProperty(importItem, COBOL_FILE_PATH, ExternalFileUtil.decodeXMLEncodedString(sCopyBookFileName));
                        propMgr.createSubstitutionProperty(importItem, COBOL_FILE_PATH_SERVER, ExternalFileUtil.decodeXMLEncodedString(sCopyBookFileSC));
                        continue;
                    }
                    if (!"UserWrittenSourceCode".equals(sTransformRole) || (lSourceFiles = (List)mapClassifierMap.get("TransformationSources")).isEmpty() || !"File".equals((mapSourceFile = (Map)lSourceFiles.get(0)).get("MetadataObjectType"))) continue;
                    String sSourceFileName = (String)mapSourceFile.get("FileName");
                    List lSourceFileSCs = (List)mapSourceFile.get("DeployedComponents");
                    if (lSourceFileSCs.isEmpty()) continue;
                    Map mapSourceFileSC = (Map)lSourceFileSCs.get(0);
                    String sSourceFileSC = (String)mapSourceFileSC.get("Name");
                    propMgr.createSubstitutionProperty(importItem, USERWRITTEN_FILE_PATH, ExternalFileUtil.decodeXMLEncodedString(sSourceFileName));
                    propMgr.createSubstitutionProperty(importItem, USER_WRITTEN_FILE_PATH_SERVER, ExternalFileUtil.decodeXMLEncodedString(sSourceFileSC));
                }
            }
            iRC |= this.m_manager.analyzeTableForPreviousVersionOverwrite(objects);
            try {
                iRC |= this.m_manager.reportUnmatchedColumnsPreviousVersion(this, operation, objects);
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
            catch (MdException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        int index = 1;
        int count = objects.size();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        for (ImportItemInterface importItem : objects) {
            ExternalFileImportItem itemEFIImport;
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)importItem.getTypeInterface(), (String)importItem.getName(), (int)index++, (int)count));
            _mergeManager.setImportOptions(deleteSrcCols, deleteTgtCols, importItem);
            if (operation.getPackageFileVersion() >= 9200) {
                _mergeManager.mergeColumns(importItem);
                _mergeManager.restoreColumnConnectionPoints(importItem);
            }
            if (!(importItem instanceof ExternalFileImportItem) || !(itemEFIImport = (ExternalFileImportItem)importItem).isContentIncluded()) continue;
            try {
                List subs;
                Map mapContentStreams = contentHandler.getBinaryContent(itemEFIImport.getID());
                if (mapContentStreams.isEmpty() || (subs = itemEFIImport.getSubstitutions()) == null) continue;
                for (SubstitutionInterface subItem : subs) {
                    if (!"FilePath".equals(subItem.getSubstitutionType().getSubstitutionTypeName())) continue;
                    subItem.setOption(1, (Object)Boolean.FALSE);
                }
            }
            catch (TransportException e) {
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ErrorRetrievingExternalFile.fmt"), (Object)e.getMessage()));
                iRC |= 8;
            }
            catch (IOException e) {
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ErrorRetrievingExternalFile.fmt"), (Object)e.getMessage()));
                iRC |= 8;
            }
        }
        return iRC;
    }

    public void initialize(ImportOperationInterface operation) {
        super.initialize(operation);
        this.m_manager = new ColumnMergeManager(this, operation);
        operation.addNotificationListener((NotificationListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        Log importLogger = operation.getLogger();
        int iRC = 0;
        this.m_mapLocations = this.getLocationMapping(operation.getConnectionManager().getConnections());
        this.m_mapContentInfo = new HashMap();
        int iOptions = 268;
        MdObjectStore mdStore = operation.getMetadataFactory().createObjectStore(null, "ExternalFileImportListener::importContent");
        try {
            for (ImportItemInterface efImportItem : objects) {
                Map mapContentStreams = contentHandler.getBinaryContent(efImportItem.getID());
                if (mapContentStreams.isEmpty()) continue;
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ContentStatusIndicator.fmt"), (Object)efImportItem.getName()));
                operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ContentInfo.fmt"), (Object)efImportItem.getName()));
                try {
                    ExternalTable mdET = (ExternalTable)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "ExternalTable", efImportItem.getTargetID(), null, null, "<Templates><ExternalTable><OwningFile/><TargetTransformations/></ExternalTable><ClassifierMap><TransformationSources/></ClassifierMap><File><DeployedComponents/><FileRefs/><TargetTransformations/></File><SASFileRef><DeployedComponents/></SASFileRef></Templates>", iOptions);
                    if (mdET == null) continue;
                    boolean bIncludeOptionalContent = this.includeOptionalContentForItem(efImportItem, operation);
                    this.searchETForContent(mdET, efImportItem, mapContentStreams, bIncludeOptionalContent, importLogger);
                }
                catch (MdException mde) {
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ErrorRetrievingExternalFile.fmt"), (Object)mde.getMessage()));
                    iRC |= 8;
                }
            }
            for (ServerContext mdSC : this.m_mapContentInfo.keySet()) {
                List lContentInfo = (List)this.m_mapContentInfo.get(mdSC);
                if (lContentInfo == null || lContentInfo.isEmpty()) continue;
                this.fireDisplayMessage(RB.getStringResource("ExternalFileImportListener.WritingContent.txt"));
                int iTempRC = this.writeContentToServer(mdSC, lContentInfo, operation, importLogger);
                if (iTempRC <= iRC) continue;
                iRC = iTempRC;
            }
        }
        finally {
            if (mdStore != null && !mdStore.isDisposed()) {
                mdStore.dispose();
            }
        }
        return iRC;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        int iTempRC = 0;
        try {
            NestedItemMergeManager _mergeManager = NestedItemMergeManager.getInstance(objects);
            _mergeManager.logUserChanges();
            iTempRC = this.updateAttributes(operation, objects);
        }
        catch (RemoteException e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        if (operation.getPackageFileVersion() < 9200) {
            iTempRC |= this.m_manager.updateTableForPreviousVersionOverwrite(objects);
        }
        if (iTempRC > iRC) {
            iRC = iTempRC;
        }
        return iRC;
    }

    private boolean searchETForContent(ExternalTable mdET, ImportItemInterface efImportItem, Map mapContentStreams, boolean bIncludeOptionalContent, Log importLogger) throws MdException, RemoteException {
        boolean bContentFound = false;
        ServerContext mdDefaultSC = null;
        List lContentInfo = null;
        InputStream inStream = null;
        File mdPhysFile = mdET.getOwningFile();
        if (mdPhysFile == null) {
            if (importLogger.isDebugEnabled()) {
                importLogger.debug((Object)("No File object found on ExternalTable " + mdET.getFQID()));
            }
            return bContentFound;
        }
        AssociationList lFileRefs = mdPhysFile.getFileRefs();
        if (!lFileRefs.isEmpty()) {
            SASFileRef mdFileRef = (SASFileRef)lFileRefs.get(0);
            AssociationList lSCs = mdFileRef.getDeployedComponents();
            if (lSCs.isEmpty()) {
                if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No ServerContext found on ExternalTable " + mdET.getFQID()));
                }
                return bContentFound;
            }
            mdDefaultSC = (ServerContext)lSCs.get(0);
            if (bIncludeOptionalContent) {
                inStream = (InputStream)mapContentStreams.get("###PHYSICAL###");
                if (inStream != null) {
                    lContentInfo = this.getContentListForServer(mdDefaultSC);
                    lContentInfo.add(new EFContentInfo(inStream, mdPhysFile.getFileName(), mdET.getName(), true));
                    bContentFound = true;
                } else if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No content stream found for " + mdPhysFile.getFileName()));
                }
            }
        }
        this.removeDuplicateEFFandCobolFiles(mdET, importLogger);
        AssociationList lCMs = mdET.getTargetTransformations();
        for (AbstractTransformation mdTransformation : lCMs) {
            ServerContext mdSourceFileSC;
            AssociationList lSourceFileSCs;
            File mdSourceFile;
            if (!(mdTransformation instanceof ClassifierMap)) continue;
            ClassifierMap mdCM = (ClassifierMap)mdTransformation;
            if ("FormatFile".equals(mdCM.getTransformRole())) {
                AssociationList lFiles = mdCM.getTransformationSources();
                if (lFiles.isEmpty()) continue;
                File mdEFFFile = (File)lFiles.get(lFiles.size() - 1);
                if (lFiles.size() > 1) {
                    lFiles.clear();
                    lFiles.add(mdEFFFile);
                    mdCM.updateMetadataAll();
                }
                if ((inStream = (InputStream)mapContentStreams.get("###EFF###")) != null) {
                    ServerContext mdEFFSC = mdDefaultSC;
                    AssociationList lEFFSCs = mdEFFFile.getDeployedComponents();
                    if (!lEFFSCs.isEmpty()) {
                        mdEFFSC = (ServerContext)lEFFSCs.get(0);
                    }
                    lContentInfo = this.getContentListForServer(mdEFFSC);
                    lContentInfo.add(new EFContentInfo(inStream, mdEFFFile.getFileName(), mdET.getName(), false));
                    bContentFound = true;
                } else if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No content stream found for " + mdEFFFile.getFileName()));
                }
                AssociationList lCobolCMs = mdEFFFile.getTargetTransformations();
                for (ClassifierMap mdCobolCM : lCobolCMs) {
                    AssociationList lCobolFiles;
                    if (!"CobolFormatFile".equals(mdCobolCM.getTransformRole()) || (lCobolFiles = mdCobolCM.getTransformationSources()).isEmpty()) continue;
                    File mdCopyBookFile = (File)lCobolFiles.get(lCobolFiles.size() - 1);
                    if (lCobolFiles.size() > 1) {
                        lCobolFiles.clear();
                        lCobolFiles.add(mdCopyBookFile);
                        mdCobolCM.updateMetadataAll();
                    }
                    if ((inStream = (InputStream)mapContentStreams.get("###COPYBOOK###")) != null) {
                        ServerContext mdCopyBookSC = mdDefaultSC;
                        AssociationList lCopyBookSCs = mdEFFFile.getDeployedComponents();
                        if (!lCopyBookSCs.isEmpty()) {
                            mdCopyBookSC = (ServerContext)lCopyBookSCs.get(0);
                        }
                        lContentInfo = this.getContentListForServer(mdCopyBookSC);
                        lContentInfo.add(new EFContentInfo(inStream, mdCopyBookFile.getFileName(), mdET.getName(), false));
                        bContentFound = true;
                        continue;
                    }
                    if (!importLogger.isDebugEnabled()) continue;
                    importLogger.debug((Object)("No content stream found for " + mdCopyBookFile.getFileName()));
                }
                continue;
            }
            if (!"UserWrittenSourceCode".equals(mdCM.getTransformRole())) continue;
            AssociationList lSourceFiles = mdCM.getTransformationSources();
            if (!lSourceFiles.isEmpty() && lSourceFiles.get(0) instanceof File) {
                mdSourceFile = (File)lSourceFiles.get(0);
                inStream = (InputStream)mapContentStreams.get("###SOURCE###");
                if (inStream != null) {
                    lSourceFileSCs = mdSourceFile.getDeployedComponents();
                    if (lSourceFileSCs.isEmpty()) {
                        if (importLogger.isDebugEnabled()) {
                            importLogger.debug((Object)("No ServerContext found on ExternalTable " + mdET.getFQID()));
                        }
                        return bContentFound;
                    }
                    mdSourceFileSC = (ServerContext)lSourceFileSCs.get(0);
                    lContentInfo = this.getContentListForServer(mdSourceFileSC);
                    lContentInfo.add(new EFContentInfo(inStream, mdSourceFile.getFileName(), mdET.getName(), true));
                    bContentFound = true;
                } else if (importLogger.isDebugEnabled()) {
                    importLogger.debug((Object)("No content stream found for " + mdSourceFile.getFileName()));
                }
            }
            if ((lSourceFiles = mdCM.getSourceCodes()).isEmpty() || !(lSourceFiles.get(0) instanceof File)) continue;
            mdSourceFile = (File)lSourceFiles.get(0);
            inStream = (InputStream)mapContentStreams.get("###SOURCE###");
            if (inStream != null) {
                lSourceFileSCs = mdSourceFile.getDeployedComponents();
                if (lSourceFileSCs.isEmpty()) {
                    if (importLogger.isDebugEnabled()) {
                        importLogger.debug((Object)("No ServerContext found on ExternalTable " + mdET.getFQID()));
                    }
                    return bContentFound;
                }
                mdSourceFileSC = (ServerContext)lSourceFileSCs.get(0);
                lContentInfo = this.getContentListForServer(mdSourceFileSC);
                lContentInfo.add(new EFContentInfo(inStream, mdSourceFile.getFileName(), mdET.getName(), true));
                bContentFound = true;
                continue;
            }
            if (!importLogger.isDebugEnabled()) continue;
            importLogger.debug((Object)("No content stream found for " + mdSourceFile.getFileName()));
        }
        return bContentFound;
    }

    private List removeDuplicateEFFandCobolFiles(ExternalTable mdET, Log importLogger) throws RemoteException, MdException {
        AssociationList lCMToDeletes = mdET.getTargetTransformations();
        ArrayList<ClassifierMap> FormatFileCMs = new ArrayList<ClassifierMap>();
        for (AbstractTransformation mdTransformation : lCMToDeletes) {
            ClassifierMap mdCM;
            if (!(mdTransformation instanceof ClassifierMap) || !"FormatFile".equals((mdCM = (ClassifierMap)mdTransformation).getTransformRole())) continue;
            FormatFileCMs.add(mdCM);
        }
        if (FormatFileCMs.size() > 1) {
            importLogger.debug((Object)("Found multiple EFF file references from \"" + mdET.getName() + "\""));
            FormatFileCMs.remove(FormatFileCMs.size() - 1);
            ArrayList<Object> objectsToBeDeleted = new ArrayList<Object>();
            for (ClassifierMap cm : FormatFileCMs) {
                objectsToBeDeleted.add(cm);
                AssociationList lFiles = cm.getTransformationSources();
                for (File mdEFFFile : lFiles) {
                    objectsToBeDeleted.add(mdEFFFile);
                    AssociationList lCobolCMs = mdEFFFile.getTargetTransformations();
                    for (ClassifierMap mdCobolCM : lCobolCMs) {
                        if (!"CobolFormatFile".equals(mdCobolCM.getTransformRole())) continue;
                        objectsToBeDeleted.add(mdCobolCM.getTransformationSources());
                    }
                }
            }
            mdET.getObjectStore().getFactory().deleteMetadataObjects(objectsToBeDeleted);
            importLogger.debug((Object)("Removed multiple EFF file references from \"" + mdET.getName() + "\""));
        }
        return FormatFileCMs;
    }

    private List getContentListForServer(ServerContext mdSC) {
        ArrayList lContentInfo = (ArrayList)this.m_mapContentInfo.get(mdSC);
        if (lContentInfo == null) {
            lContentInfo = new ArrayList();
            this.m_mapContentInfo.put(mdSC, lContentInfo);
        }
        return lContentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeContentToServer(ServerContext mdSC, List lContentInfo, ImportOperationInterface operation, Log importLogger) throws RemoteException {
        int iRC = 0;
        WsAppServer appServer = null;
        try {
            appServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)mdSC);
            ContentHandlerInterface contentHandler = operation.getContentHandler();
            EFContentInfo processing = null;
            Iterator iterContentInfo = lContentInfo.iterator();
            while (iterContentInfo.hasNext()) {
                EFContentInfo efContentInfo;
                processing = efContentInfo = (EFContentInfo)iterContentInfo.next();
                InputStream inStream = efContentInfo.m_inStream;
                try {
                    IFileService fileService = appServer.getWorkspace().FileService();
                    IFileref fileRef = fileService.AssignFileref("TEMPREF", "DISK", efContentInfo.m_sPath, "", new StringHolder());
                    try {
                        IBinaryStream outStream = fileRef.OpenBinaryStream(StreamOpenMode.StreamOpenModeForWriting);
                        contentHandler.writeToBinaryStream(inStream, outStream);
                    }
                    finally {
                        fileService.DeassignFileref("TEMPREF");
                    }
                    importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ImportInfo.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sEFName));
                }
                catch (Exception e) {
                    if (processing != null && !processing.m_bRequired) {
                        iRC = 4;
                        importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ImportError.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sEFName, (Object)e.getMessage()));
                        continue;
                    }
                    iRC = 8;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ImportError.fmt"), (Object)efContentInfo.m_sPath, (Object)mdSC.getName(), (Object)efContentInfo.m_sEFName, (Object)e.getMessage()));
                }
            }
        }
        catch (WsAppServerFailException e) {
            iRC = 8;
            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.ServerError.fmt"), (Object)mdSC.getName(), (Object)e.getMessage()));
        }
        finally {
            if (appServer != null) {
                appServer.dispose();
            }
        }
        return iRC;
    }

    private Map getLocationMapping(List lReferences) {
        HashMap mapLocations = new HashMap();
        return mapLocations;
    }

    private boolean includeOptionalContentForItem(ImportItemInterface importItem, ImportOperationInterface importHandler) {
        boolean bIncludeContent = false;
        if (importHandler.getPromotionType() == 1) {
            bIncludeContent = ((ExternalFileImportItem)importItem).isContentIncluded();
        } else if (importHandler.getPromotionType() == 3) {
            String sIncludeContent = importHandler.getPropertiesFile().getProperty(importItem.getID() + "Content");
            bIncludeContent = "true".equals(sIncludeContent);
        }
        return bIncludeContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateAttributes(ImportOperationInterface operation, List objects) throws RemoteException {
        int rc = 0;
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            String name;
            boolean bMetadataChanged = false;
            ImportItemInterface importItem = (ImportItemInterface)iterator.next();
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.AttributesStatusIndicator.fmt"), (Object)importItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.AttributesInfo.fmt"), (Object)importItem.getName()));
            MdObjectStore mdStore = operation.getMetadataFactory().createObjectStore(null, "ExternalFileImportListener::updateAttributes");
            try {
                ExternalTable metaObj = this.getMetadataObject(operation, mdStore, importItem.getTargetID(), "<Templates><ExternalTable><Documents/><Notes/></ExternalTable></Templates>");
                PromotionUtil.updateProductInfo((Root)metaObj, (ImportOperationInterface)operation);
                bMetadataChanged = true;
                boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)metaObj, (String)"ExternalFile");
                if (publicTypeChanged) {
                    bMetadataChanged = true;
                }
                if (bMetadataChanged) {
                    bMetadataChanged = false;
                    metaObj.updateMetadataAll();
                }
                PrivateObjectImportUtility.updatePromptsForImportChanges((ImportOperationInterface)operation, (Root)metaObj);
            }
            catch (RemoteException e) {
                String type = importItem.getTypeInterface().getDisplayType();
                name = importItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (MdException e) {
                String type = importItem.getTypeInterface().getDisplayType();
                name = importItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (ServiceException e) {
                String type = importItem.getTypeInterface().getDisplayType();
                name = importItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ExternalFileImportListener.errorValidatingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            finally {
                if (mdStore == null || mdStore.isDisposed()) continue;
                mdStore.dispose();
            }
        }
        return rc;
    }

    private ExternalTable getMetadataObject(ImportOperationInterface operation, MdObjectStore store, String fqid, String template) throws MdException, RemoteException {
        String type = "ExternalTable";
        int options = 268;
        CMetadata object = operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return (ExternalTable)object;
    }

    public void notify(NotificationEvent event) {
        if (event != null && event.getEventType() == 200) {
            ComparisonTemplateFactory.getInstance().dispose();
        }
    }

    private class EFContentInfo {
        InputStream m_inStream;
        String m_sPath;
        String m_sEFName;
        boolean m_bRequired = true;

        EFContentInfo(InputStream inStream, String sPath, String sEFName, boolean bRequired) {
            this.m_inStream = inStream;
            this.m_sEFName = sEFName;
            this.m_bRequired = bRequired;
            String sNewPath = (String)ExternalFileImportListener.this.m_mapLocations.get(sPath);
            this.m_sPath = sNewPath != null ? sNewPath : sPath;
        }
    }
}

