/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonCheckBoxTreeManager;
import com.sas.metadata.promotion.visuals.ImportTreeNode;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.tools.tablecomparator.PromotionComparisonNodeInterface;
import com.sas.services.ServiceException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class ComparisonTreeNode
extends DefaultMutableTreeNode {
    private static final int UNKNOWN_TYPE = 0;
    private static final int LOGICAL_OBJECT_TYPE = 1;
    private static final int ASSOCIATION_TYPE = 2;
    private Icon m_icon;
    private ComparisonResultNodeInterface m_CmpRsltNode;
    private AssociationWrapperNode m_AssWrprNode;
    private int m_nodeType = 0;
    private ComparisonCheckBoxTreeManager m_manager;

    public ComparisonTreeNode(ComparisonCheckBoxTreeManager manager, ComparisonResultNodeInterface nodeObject, Icon icon) {
        super(nodeObject.getObjectName());
        this.m_manager = manager;
        this.m_icon = icon;
        this.m_nodeType = 1;
        this.m_CmpRsltNode = nodeObject;
    }

    public ComparisonTreeNode(ComparisonCheckBoxTreeManager manager, AssociationWrapperNode nodeObject, Icon icon) {
        super(nodeObject.getAssociationDisplayName());
        this.m_manager = manager;
        this.m_icon = icon;
        this.m_nodeType = 2;
        this.m_AssWrprNode = nodeObject;
    }

    public ComparisonTreeNode(String nodeObject, Icon icon) {
        super(nodeObject);
        this.m_icon = icon;
    }

    public PromotionComparisonNodeInterface.ImportState getImportState() {
        if (this.m_CmpRsltNode instanceof PromotionComparisonNodeInterface) {
            return ((PromotionComparisonNodeInterface)this.m_CmpRsltNode).getImportstate();
        }
        return null;
    }

    public void setImportState(PromotionComparisonNodeInterface.ImportState state) {
        if (this.m_CmpRsltNode instanceof PromotionComparisonNodeInterface) {
            ((PromotionComparisonNodeInterface)this.m_CmpRsltNode).setImportState(state);
        }
    }

    public void update() {
        if (this.m_CmpRsltNode instanceof PromotionComparisonNodeInterface) {
            ((PromotionComparisonNodeInterface)this.m_CmpRsltNode).updateState();
        }
    }

    public boolean isImportItem() {
        if (this.m_CmpRsltNode instanceof PromotionComparisonNodeInterface) {
            return ((PromotionComparisonNodeInterface)this.m_CmpRsltNode).isImportItem();
        }
        return false;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public String getName() {
        return (String)this.getUserObject();
    }

    public String getId() {
        if (this.m_CmpRsltNode != null && this.isNodeTypeLogicalObject()) {
            return this.m_CmpRsltNode.getId();
        }
        return null;
    }

    public ComparisonResultNodeInterface getComparisonResultNode() {
        return this.m_CmpRsltNode;
    }

    public AssociationWrapperNode getAssociationWrapperNode() {
        return this.m_AssWrprNode;
    }

    public int getNodeType() {
        return this.m_nodeType;
    }

    public boolean isNodeTypeLogicalObject() {
        return this.m_nodeType == 1;
    }

    public boolean isNodeTypeAssociation() {
        return this.m_nodeType == 2;
    }

    public boolean isNodeTypeUnknown() {
        return this.m_nodeType == 0;
    }

    private boolean isTableNodeChecked() {
        TreeNodeInterface[] checkedNodes;
        ComparisonTreeNode ctnTableNode = this.getTableNode();
        if (ctnTableNode != null && (checkedNodes = this.m_manager.getCheckedNodesFromImportTree()) != null) {
            for (TreeNodeInterface nodeName : checkedNodes) {
                String tableID = ctnTableNode.getId();
                try {
                    if (nodeName instanceof ImportTreeNode && tableID != null && tableID.equals(((ImportTreeNode)nodeName).getObjectID())) {
                        return true;
                    }
                }
                catch (RemoteException e) {
                    this.m_manager.getLogger().error((Object)e);
                }
                catch (ServiceException e) {
                    this.m_manager.getLogger().error((Object)e);
                }
            }
        }
        return false;
    }

    public boolean isCheckBoxVisible() {
        Enumeration<TreeNode> children;
        if (this.isNodeTypeLogicalObject()) {
            return this.isImportItem() && this.isTableNodeChecked();
        }
        if (this.isNodeTypeAssociation() && (children = this.children()) != null && children.hasMoreElements()) {
            ComparisonTreeNode childNode = (ComparisonTreeNode)children.nextElement();
            boolean isVisible = childNode.isImportItem();
            return isVisible && this.isTableNodeChecked();
        }
        return false;
    }

    private ComparisonTreeNode getTableNode() {
        int tableNodeIndex;
        TreeNode[] nodes = this.getPath();
        if (nodes != null && nodes.length > 2 && nodes[tableNodeIndex = 1] instanceof ComparisonTreeNode) {
            return (ComparisonTreeNode)nodes[tableNodeIndex];
        }
        return null;
    }

    protected static class AssociationWrapperNode {
        private ComparisonResultNodeInterface _parentNode = null;
        private String _associationName = null;
        private String _associationDisplayName = null;
        private Collection<ComparisonResultNodeInterface> _associatedComparisonResultNodes = null;

        public AssociationWrapperNode(ComparisonResultNodeInterface node, String name, String strDisplayName) {
            this._parentNode = node;
            this._associationName = name;
            this._associationDisplayName = strDisplayName;
        }

        public Collection<ComparisonResultNodeInterface> getAssociatedComparisonResultNodes() {
            if (this._associatedComparisonResultNodes == null) {
                this.retrieveChildren();
            }
            return this._associatedComparisonResultNodes;
        }

        public void setAssociatedComparisonResultNodes(Collection<ComparisonResultNodeInterface> comparisonResultNodes) {
            this._associatedComparisonResultNodes = comparisonResultNodes;
        }

        public ComparisonResultNodeInterface getParentNode() {
            return this._parentNode;
        }

        public String getAssociationName() {
            return this._associationName;
        }

        public String getAssociationDisplayName() {
            return this._associationDisplayName;
        }

        public void retrieveChildren() {
            this._associatedComparisonResultNodes = this._parentNode.getComparisonResults(this._associationName);
        }
    }
}

