/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.AttributeComparisonResult;
import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.ComparisonResultNodeInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonCheckBoxTreeManager;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNode;
import com.sas.metadata.logical.comparison.visual.ComparisonTreeNodeSelectionListener;
import com.sas.metadata.logical.comparison.visual.NodeSummaryPanel;
import com.sas.metadata.logical.comparison.visual.RB;
import com.sas.metadata.logical.images.IconFactory;
import com.sas.metadata.logical.table.DefaultMergeImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PublicObjectPromotionOptions;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.tools.tablecomparator.PromotionComparisonNodeInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.text.Message;
import com.sas.workspace.WAPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComparisonMainPanel
extends WAPanel
implements ComparisonTreeNodeSelectionListener {
    protected static Log LOGGER = null;
    private static final String OBJECT_COLUMN = "#Object#";
    private static final String ATTRIBNAME_NAME_COLUMN = RB.getStringResource("ComparisonDialog.AttribName.Colheader.txt");
    private static final String ATTRIBNAME_ORIGVAL_COLUMN = RB.getStringResource("ComparisonDialog.OrigVal.Colheader.txt");
    private static final String ATTRIBNAME_TARGETVAL_COLUMN = RB.getStringResource("ComparisonDialog.TargetVal.Colheader.txt");
    private static final Color COLOR_FOR_NEW = Color.YELLOW;
    private static final Color COLOR_FOR_MODIFIED = new Color(97, 210, 243);
    private static final Color COLOR_FOR_DELETED = new Color(165, 174, 175);
    private static final Color COLOR_FOR_HEADER = Color.GRAY;
    private ComparisonResultNodeInterface _selectedCRN;
    private NodeSummaryPanel _pnlSummary;
    private JScrollPane _scrDetails = null;
    private JTable _tabDetails = null;
    private String _currentTableName = null;
    private String _currentAssoName = null;
    private ComparisonControllerInterface _comparisonController = null;
    private IconFactory _iconFactory;
    private List _objectsToCompare;
    ComparisonCheckBoxTreeManager _treeManager;
    private static int SELECTED = 1;
    private static int UNSELECTED = 2;
    private int _selectionStatusNew;
    private int _selectionStatusDeleted;

    public ComparisonMainPanel(ComparisonControllerInterface comparisonController, List objectsToCompare, IconFactory iconFactory) throws RemoteException, MdException, ComparisonConfigurationException, MetadataPromotionException {
        this._comparisonController = comparisonController;
        LOGGER = comparisonController.getLogger();
        this._objectsToCompare = objectsToCompare;
        this._iconFactory = iconFactory;
        this.initialize();
    }

    private void initObjectsToCompare() {
        DefaultMergeImportItem importItem = null;
        for (Object object : this._objectsToCompare) {
            importItem = (DefaultMergeImportItem)((Object)object);
            if (!this._treeManager.isTableNodeChecked((ImportItemInterface)importItem) || !importItem.isReinitilizationRequired()) continue;
            importItem.renitilize();
        }
    }

    public void loadUIData() throws RemoteException, MetadataPromotionException, MdException, ComparisonConfigurationException {
        this.initObjectsToCompare();
        List<String> listComparedObjects = this._comparisonController.getObjectComparison(this._objectsToCompare);
        if (listComparedObjects == null || listComparedObjects.size() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("ComparisonMainPanel.ObjectsToCompare.Deleted.txt"));
        }
        this._treeManager.loadUIData();
        this.treePathSelected(this._treeManager.setDefaultTreePathSelected());
    }

    protected synchronized void initialize() {
        int margin;
        super.initialize();
        int currentX = margin = 5;
        int currentY = margin;
        JLabel lblTableCaption = new JLabel();
        ImportItemInterface slo = (ImportItemInterface)this._objectsToCompare.get(0);
        String type = slo.getTypeInterface().getDisplayType();
        int version = slo.getImportOperation().getPackageFileVersion();
        LabelView lblColumns = new LabelView();
        lblColumns.setLineWrap(true);
        lblColumns.setWrapStyleWord(true);
        lblColumns.setText(Message.format((String)RB.getStringResource("ComparisonMainPanel.Comparison.dialog.info.text.at.top.fmt"), (Object[])new Object[]{type}));
        if (version < 9200) {
            lblColumns.setText(Message.format((String)RB.getStringResource("ComparisonMainPanel.Comparison.dialog.info.packagebefore92.text.at.top.fmt"), (Object[])new Object[]{type}));
        }
        lblColumns.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        lblColumns.setPreferredSpanSize(new Dimension(40, 50));
        this._treeManager = new ComparisonCheckBoxTreeManager(this, this._comparisonController, this._iconFactory);
        JScrollPane scrColumns = new JScrollPane(this._treeManager.getTree());
        scrColumns.setPreferredSize(new Dimension(200, 330));
        currentX = currentX + 200 + margin;
        this._scrDetails = new JScrollPane();
        this._scrDetails.setPreferredSize(new Dimension(200, 120));
        JPanel pnlDetails = new JPanel();
        pnlDetails.setLayout(new BorderLayout());
        pnlDetails.setMaximumSize(new Dimension(200, 170));
        pnlDetails.setPreferredSize(new Dimension(200, 170));
        pnlDetails.setMinimumSize(new Dimension(200, 170));
        lblTableCaption.setText(RB.getStringResource("ComparisonMainPanel.details.table.caption.txt"));
        lblTableCaption.setSize(60, 30);
        lblTableCaption.setBorder(new EmptyBorder(6, 2, 3, 0));
        pnlDetails.add((Component)lblTableCaption, "North");
        pnlDetails.add((Component)this._scrDetails, "Center");
        currentX += 200 + margin;
        currentY += 600 + margin;
        this._pnlSummary = new NodeSummaryPanel();
        this._pnlSummary.setversion(version);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setDividerLocation(-1);
        splitPane.setTopComponent(scrColumns);
        splitPane.setBottomComponent(pnlDetails);
        this.setLayout(new BorderLayout());
        this.add((Component)lblColumns, "North");
        this.add(splitPane, "Center");
        this.setPreferredSize(new Dimension(currentX, currentY));
        this.setMinimumSize(new Dimension(currentX, currentY));
    }

    @Override
    public void treePathSelected(TreePath path) {
        Object nodeObject;
        if (path != null && (nodeObject = path.getLastPathComponent()) instanceof ComparisonTreeNode) {
            boolean isCompactColumnWidth = false;
            ComparisonTreeNode ctn = (ComparisonTreeNode)nodeObject;
            ComparisonTableModel tm = new ComparisonTableModel(0, 0);
            if (ctn.isNodeTypeLogicalObject()) {
                this._selectedCRN = ctn.getComparisonResultNode();
                isCompactColumnWidth = true;
                List<AttributeComparisonResult> attributeComparisons = ctn.getComparisonResultNode().getAttributeComparisons();
                if (attributeComparisons != null) {
                    Object[] colHeaders = new String[]{OBJECT_COLUMN, ATTRIBNAME_NAME_COLUMN, ATTRIBNAME_ORIGVAL_COLUMN, ATTRIBNAME_TARGETVAL_COLUMN};
                    tm = new ComparisonTableModel(colHeaders, attributeComparisons.size());
                    this.insertDataToTAbleModel(tm, attributeComparisons.toArray(new AttributeComparisonResult[attributeComparisons.size()]));
                }
            } else if (ctn.isNodeTypeAssociation()) {
                this._pnlSummary.buildSummary(ctn);
                this._scrDetails.setViewportView((Component)((Object)this._pnlSummary));
                tm = null;
            }
            if (tm != null) {
                this._tabDetails = new JTable(tm);
                this.finalizeVisualsForTable(isCompactColumnWidth, ctn.isNodeTypeAssociation());
                this._scrDetails.setViewportView(this._tabDetails);
            }
        }
    }

    private void finalizeVisualsForTable(boolean isCompactColumnWidth, boolean isAssociationTypeObject) {
        Enumeration<TableColumn> columns;
        TableColumnModel tcm = this._tabDetails.getColumnModel();
        if (tcm != null && (columns = tcm.getColumns()) != null && columns.hasMoreElements()) {
            if (!isCompactColumnWidth) {
                // empty if block
            }
            TableCellRenderer headerRenderer = new TableCellRenderer(){
                private JButton rendererIconButton = new JButton();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.rendererIconButton.setIcon(ComparisonMainPanel.this._iconFactory.getInformationIcon());
                    return this.rendererIconButton;
                }
            };
            ComparisonTableHeaderCellRenderer headerRendererForAssociationTypeObject = new ComparisonTableHeaderCellRenderer();
            while (columns.hasMoreElements()) {
                TableColumn tc = columns.nextElement();
                String header = null;
                Object objHeader = tc.getHeaderValue();
                if (objHeader instanceof String) {
                    header = (String)objHeader;
                }
                if (OBJECT_COLUMN.equalsIgnoreCase(header)) {
                    tc.setMaxWidth(18);
                    tc.setMinWidth(18);
                    tc.setPreferredWidth(18);
                    tc.setHeaderRenderer(headerRenderer);
                }
                if (isAssociationTypeObject) {
                    tc.setHeaderRenderer(headerRendererForAssociationTypeObject);
                }
                tc.setCellRenderer(new ComparisonTableCellRenderer());
            }
        }
    }

    private void insertDataToTAbleModel(ComparisonTableModel dtm, AttributeComparisonResult[] attribComparisons) {
        if (attribComparisons != null) {
            try {
                int iObjCol = this.locateColumn(dtm, OBJECT_COLUMN);
                int iNameCol = this.locateColumn(dtm, ATTRIBNAME_NAME_COLUMN);
                int iSrc1ValCol = this.locateColumn(dtm, ATTRIBNAME_TARGETVAL_COLUMN);
                int iSrc2ValCol = this.locateColumn(dtm, ATTRIBNAME_ORIGVAL_COLUMN);
                for (int rowIndex = 0; rowIndex < attribComparisons.length; ++rowIndex) {
                    dtm.setValueAt(attribComparisons[rowIndex], rowIndex, iObjCol);
                    dtm.setValueAt(attribComparisons[rowIndex].getName(), rowIndex, iNameCol);
                    dtm.setValueAt(attribComparisons[rowIndex].getSource2Val(), rowIndex, iSrc1ValCol);
                    dtm.setValueAt(attribComparisons[rowIndex].getSource1Val(), rowIndex, iSrc2ValCol);
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void insertDataToTAbleModel(ComparisonTableModel dtm, ComparisonResultNodeInterface[] comparisonResults) {
        if (comparisonResults != null) {
            for (int row = 0; row < comparisonResults.length; ++row) {
                List<AttributeComparisonResult> lstAttribCmpResults;
                int colIndex = dtm.findColumn(OBJECT_COLUMN);
                if (colIndex != -1) {
                    dtm.setValueAt(comparisonResults[row], row, colIndex);
                }
                if ((lstAttribCmpResults = comparisonResults[row].getAttributeComparisons()) == null) continue;
                AttributeComparisonResult[] attribCmpResults = lstAttribCmpResults.toArray(new AttributeComparisonResult[lstAttribCmpResults.size()]);
                for (int attribIndex = 0; attribIndex < attribCmpResults.length; ++attribIndex) {
                    String attribName = attribCmpResults[attribIndex].getName();
                    int iCol = dtm.findColumn(attribName);
                    if (iCol == -1) continue;
                    dtm.setValueAt(attribCmpResults[attribIndex], row, iCol);
                }
            }
        }
    }

    private int locateColumn(ComparisonTableModel dtm, String colName) {
        int index = dtm.findColumn(colName);
        if (index == -1) {
            dtm.addColumn(colName);
            index = dtm.findColumn(colName);
        }
        return index;
    }

    private Color getRenderingColor(ComparisonResultNodeInterface.Result res, ComparisonResultNodeInterface.Location loc) {
        Color color = null;
        block0 : switch (res) {
            case UNMACHED: {
                switch (loc) {
                    case SOURCE1: {
                        color = COLOR_FOR_NEW;
                        break block0;
                    }
                    case SOURCE2: {
                        color = COLOR_FOR_DELETED;
                        break block0;
                    }
                    case BOTH: {
                        color = COLOR_FOR_MODIFIED;
                    }
                }
            }
        }
        return color;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        ComparisonTreeNode rootNode;
        Enumeration<TreeNode> allTableNodes;
        Object root = this._treeManager.getRootObject();
        if (root instanceof ComparisonTreeNode && (allTableNodes = (rootNode = (ComparisonTreeNode)root).children()) != null && allTableNodes.hasMoreElements()) {
            while (allTableNodes.hasMoreElements()) {
                ImportItemInterface importItem;
                this._selectionStatusDeleted = 0;
                this._selectionStatusNew = 0;
                ComparisonTreeNode tableNode = (ComparisonTreeNode)allTableNodes.nextElement();
                this.getImportStatesOfAllSubordinateNodes(tableNode);
                PromotionComparisonNodeInterface pcn = null;
                ComparisonResultNodeInterface crn = tableNode.getComparisonResultNode();
                if (crn instanceof PromotionComparisonNodeInterface) {
                    pcn = (PromotionComparisonNodeInterface)crn;
                }
                if (pcn == null || !((importItem = pcn.getImportItem()) instanceof PublicObjectPromotionOptions)) continue;
                PublicObjectPromotionOptions options = (PublicObjectPromotionOptions)importItem;
                if ((this._selectionStatusDeleted & SELECTED) == SELECTED) {
                    if ((this._selectionStatusDeleted & UNSELECTED) == UNSELECTED) {
                        options.setStateOfKeepDeletedOption(PublicObjectPromotionOptions.SelectionState.MIXED);
                    } else {
                        options.setStateOfKeepDeletedOption(PublicObjectPromotionOptions.SelectionState.ON);
                    }
                } else if ((this._selectionStatusDeleted & UNSELECTED) == UNSELECTED) {
                    options.setStateOfKeepDeletedOption(PublicObjectPromotionOptions.SelectionState.OFF);
                }
                if ((this._selectionStatusNew & SELECTED) == SELECTED) {
                    if ((this._selectionStatusNew & UNSELECTED) == UNSELECTED) {
                        options.setStateOfKeepNewOption(PublicObjectPromotionOptions.SelectionState.MIXED);
                        continue;
                    }
                    options.setStateOfKeepNewOption(PublicObjectPromotionOptions.SelectionState.ON);
                    continue;
                }
                if ((this._selectionStatusNew & UNSELECTED) != UNSELECTED) continue;
                options.setStateOfKeepNewOption(PublicObjectPromotionOptions.SelectionState.OFF);
            }
        }
        super.moveDataToStore();
    }

    private Map<String, Integer> getImportStatesOfAllSubordinateNodes(ComparisonTreeNode parentNode) {
        Enumeration<TreeNode> children;
        HashMap<String, Integer> mpImportStates = new HashMap<String, Integer>();
        if (parentNode != null && (children = parentNode.children()) != null) {
            while (children.hasMoreElements()) {
                this.updateImportStateIfChanged(mpImportStates, (ComparisonTreeNode)children.nextElement());
            }
        }
        return mpImportStates.isEmpty() ? null : mpImportStates;
    }

    private void updateImportStateIfChanged(Map<String, Integer> mpChangedStates, ComparisonTreeNode descendentNode) {
        Enumeration<TreeNode> children;
        PromotionComparisonNodeInterface.ImportState state;
        if (descendentNode.isNodeTypeLogicalObject() && (state = descendentNode.getImportState()) != null) {
            PromotionComparisonNodeInterface.ImportState newState = null;
            if (descendentNode.isImportItem()) {
                boolean isSelected = this._treeManager.isNodeSelected(descendentNode);
                ComparisonResultNodeInterface compNode = descendentNode.getComparisonResultNode();
                PromotionComparisonNodeInterface.ImportState origImportState = ((PromotionComparisonNodeInterface)compNode).getImportstate();
                if (origImportState != null) {
                    ComparisonResultNodeInterface.Location location = compNode.getLocation();
                    if (location == ComparisonResultNodeInterface.Location.SOURCE2) {
                        this._selectionStatusDeleted = isSelected ? (this._selectionStatusDeleted |= SELECTED) : (this._selectionStatusDeleted |= UNSELECTED);
                    } else if (location == ComparisonResultNodeInterface.Location.SOURCE1) {
                        this._selectionStatusNew = isSelected ? (this._selectionStatusNew |= SELECTED) : (this._selectionStatusNew |= UNSELECTED);
                    }
                }
                if ((newState = isSelected ? PromotionComparisonNodeInterface.ImportState.ON : PromotionComparisonNodeInterface.ImportState.OFF) != null) {
                    descendentNode.setImportState(newState);
                }
            }
        }
        if ((children = descendentNode.children()) != null) {
            while (children.hasMoreElements()) {
                this.updateImportStateIfChanged(mpChangedStates, (ComparisonTreeNode)children.nextElement());
            }
        }
    }

    private class ComparisonTableCellRenderer
    extends JTable
    implements TableCellRenderer {
        private JLabel defaultRenderer;

        public ComparisonTableCellRenderer() {
            super(1, 2);
            this.defaultRenderer = new JLabel();
            this.setTableHeader(null);
            this.setAutoResizeMode(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ComparisonMainPanel.OBJECT_COLUMN.equalsIgnoreCase(table.getColumnName(column))) {
                if (value instanceof AttributeComparisonResult) {
                    Icon icon = null;
                    AttributeComparisonResult acr = (AttributeComparisonResult)value;
                    if (ComparisonResultNodeInterface.Result.MATCHED.equals((Object)acr.getResult())) {
                        icon = ComparisonMainPanel.this._iconFactory.getSuccessIcon();
                    } else {
                        int state;
                        PromotionComparisonNodeInterface.ImportState importState;
                        if (ComparisonMainPanel.this._selectedCRN instanceof PromotionComparisonNodeInterface && (importState = ((PromotionComparisonNodeInterface)ComparisonMainPanel.this._selectedCRN).getImportstate()) != null && (state = importState.getImportState()) == 1) {
                            icon = ComparisonMainPanel.this._iconFactory.getNewIcon();
                        }
                        if (icon == null) {
                            icon = ComparisonMainPanel.this._iconFactory.getAttentionIcon();
                        }
                    }
                    if (icon != null) {
                        this.defaultRenderer.setIcon(icon);
                    }
                } else if (value instanceof PromotionComparisonNodeInterface) {
                    Icon icon = null;
                    PromotionComparisonNodeInterface pcn = (PromotionComparisonNodeInterface)value;
                    PromotionComparisonNodeInterface.ImportState importState = pcn.getImportstate();
                    if (importState != null) {
                        int state = importState.getState();
                        icon = state == 1 ? ComparisonMainPanel.this._iconFactory.getNewIcon() : (state == 2 ? ComparisonMainPanel.this._iconFactory.getAttentionIcon() : ComparisonMainPanel.this._iconFactory.getDeletedIcon());
                    }
                    if (icon != null) {
                        this.defaultRenderer.setIcon(icon);
                    }
                }
                return this.defaultRenderer;
            }
            if (value instanceof AttributeComparisonResult) {
                AttributeComparisonResult att = (AttributeComparisonResult)value;
                this.setValueAt(" " + att.getSource2Val(), 0, 0);
                this.setValueAt(" " + att.getSource1Val(), 0, 1);
                TableColumn tableColumn = table.getColumn(table.getColumnName(column));
                TableCellRenderer renderer = tableColumn.getHeaderRenderer();
                return this;
            }
            if (value instanceof ComparisonResultNodeInterface) {
                this.defaultRenderer.setText(" " + ((ComparisonResultNodeInterface)value).getObjectName());
                return this.defaultRenderer;
            }
            this.defaultRenderer.setText(" " + (String)value);
            return this.defaultRenderer;
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class ComparisonTableHeaderCellRenderer
    implements TableCellRenderer {
        private JButton rendererIconButton = new JButton();
        private JPanel rendererPanel = new JPanel();
        private JButton btnHeader;
        private JButton btnExisting;
        private JButton btnNew;

        private ComparisonTableHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String columnName = table.getColumnName(column);
            return this.rendererPanel;
        }
    }

    private class ComparisonTableModel
    extends DefaultTableModel {
        public ComparisonTableModel(int row, int col) {
            super(row, col);
        }

        public ComparisonTableModel(Object[] columnsNames, int rowCount) {
            super(columnsNames, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

