/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.ComparisonConfigurationException;
import com.sas.metadata.logical.comparison.ComparisonControllerInterface;
import com.sas.metadata.logical.comparison.visual.ComparisonMainPanel;
import com.sas.metadata.logical.comparison.visual.RB;
import com.sas.metadata.logical.images.IconFactory;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAStandardDialog;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JDialog;

public class ComparisonDialog
extends WAStandardDialog {
    private ComparisonMainPanel _comparisonMainPanel;
    private boolean loadUIDataFail;
    private static Log logger;

    public ComparisonDialog(Dialog dlgParent, ComparisonControllerInterface comparisonController, List objectsToCompare, IconFactory iconFactory) {
        super(dlgParent, RB.getStringResource("ComparisonDialog.Title.txt"), true);
        this.initialize(comparisonController, objectsToCompare, iconFactory);
    }

    public ComparisonDialog(Frame frmParent, ComparisonControllerInterface comparisonController, List objectsToCompare, IconFactory iconFactory) {
        super(frmParent, RB.getStringResource("ComparisonDialog.Title.txt"), true);
        this.initialize(comparisonController, objectsToCompare, iconFactory);
    }

    private boolean initialize(ComparisonControllerInterface comparisonController, List objectsToCompare, IconFactory iconFactory) {
        try {
            this._comparisonMainPanel = new ComparisonMainPanel(comparisonController, objectsToCompare, iconFactory);
            logger = comparisonController.getLogger();
            this.setHelpProduct("promotion");
            this.setHelpTopic("imp_changeanalysis");
            this.setMainPanel(this._comparisonMainPanel);
            this.setHelpButtonVisible(true);
            this.setCancelButtonVisible(true);
            this.setResizable(true);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (MetadataPromotionException e) {
            e.printStackTrace();
        }
        catch (MdException e) {
            e.printStackTrace();
        }
        catch (ComparisonConfigurationException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void loadUIData() {
        OpRequestUI opRequestUI = new OpRequestUI((JDialog)((Object)this), RB.getStringResource("ComparisonDialog.SplashScreen.Label.txt"), RB.getStringResource("ComparisonDialog.Title.txt"));
        opRequestUI.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ComparisonDialog.this._comparisonMainPanel.loadUIData();
                }
                catch (RemoteException e) {
                    this.handleException(e);
                }
                catch (MetadataPromotionException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (MdException e) {
                    this.handleException((Exception)((Object)e));
                }
                catch (ComparisonConfigurationException e) {
                    this.handleException(e);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }

            public void handleException(Exception e) {
                logger.warn((Object)e.getMessage());
                MessageUtil.displayMessage((String)RB.getStringResource("ComparisonDialog.LoadUIData.Exception.txt"));
                ComparisonDialog.this.setLoadUIDataFail(true);
                if (ComparisonDialog.this.isVisible()) {
                    ComparisonDialog.this.setVisible(false);
                    ComparisonDialog.this.dispose();
                }
            }
        });
    }

    public boolean isLoadUIDataFail() {
        return this.loadUIDataFail;
    }

    public void setLoadUIDataFail(boolean loadUIDataFail) {
        this.loadUIDataFail = loadUIDataFail;
    }
}

