/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison.visual;

import com.sas.metadata.logical.comparison.visual.RB;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ComparisonCheckBoxTreeSelectionModel
extends DefaultTreeSelectionModel {
    private TreeModel model;

    public ComparisonCheckBoxTreeSelectionModel(TreeModel model) {
        this.model = model;
        this.setSelectionMode(4);
    }

    public boolean isPartiallySelected(TreePath path) {
        if (this.isPathSelected(path, true)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        for (int j = 0; j < selectionPaths.length; ++j) {
            if (!this.isDescendant(selectionPaths[j], path)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathSelected(TreePath path, boolean dig) {
        if (!dig) {
            return super.isPathSelected(path);
        }
        while (path != null && !super.isPathSelected(path)) {
            path = path.getParentPath();
        }
        return path != null;
    }

    private boolean isDescendant(TreePath path1, TreePath path2) {
        Object[] obj2;
        Object[] obj1 = path1.getPath();
        if (obj1.length <= (obj2 = path2.getPath()).length) {
            return false;
        }
        for (int i = 0; i < obj2.length; ++i) {
            if (obj1[i] == obj2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSelectionPaths(TreePath[] pPaths) {
        throw new UnsupportedOperationException(RB.getStringResource("ComparisonCheckBoxTreeSelectionModel.unsupported.op.exception.message.txt"));
    }

    @Override
    public void addSelectionPaths(TreePath[] paths) {
        int i;
        for (i = 0; i < paths.length; ++i) {
            TreePath parentPath = paths[i];
            TreePath[] selectionPaths = this.getSelectionPaths();
            if (selectionPaths == null) break;
            ArrayList<TreePath> toBeRemoved = new ArrayList<TreePath>();
            for (int j = 0; j < selectionPaths.length; ++j) {
                if (!this.isDescendant(selectionPaths[j], parentPath)) continue;
                toBeRemoved.add(selectionPaths[j]);
            }
            super.removeSelectionPaths(toBeRemoved.toArray(new TreePath[0]));
        }
        for (i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            TreePath temp = null;
            while (this.areSiblingsSelected(path)) {
                temp = path;
                if (path.getParentPath() == null) break;
                path = path.getParentPath();
            }
            if (temp != null) {
                if (temp.getParentPath() != null) {
                    this.addSelectionPath(temp.getParentPath());
                    continue;
                }
                if (!this.isSelectionEmpty()) {
                    this.removeSelectionPaths(this.getSelectionPaths());
                }
                super.addSelectionPaths(new TreePath[]{temp});
                continue;
            }
            super.addSelectionPaths(new TreePath[]{path});
        }
    }

    private boolean areSiblingsSelected(TreePath path) {
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        Object node = path.getLastPathComponent();
        Object parentNode = parent.getLastPathComponent();
        int childCount = this.model.getChildCount(parentNode);
        for (int i = 0; i < childCount; ++i) {
            Object childNode = this.model.getChild(parentNode, i);
            if (childNode == node || this.isPathSelected(parent.pathByAddingChild(childNode))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeSelectionPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            if (path.getPathCount() == 1) {
                super.removeSelectionPaths(new TreePath[]{path});
                continue;
            }
            this.toggleRemoveSelection(path);
        }
    }

    private void toggleRemoveSelection(TreePath path) {
        TreePath parent;
        Stack<TreePath> stack = new Stack<TreePath>();
        for (parent = path.getParentPath(); parent != null && !this.isPathSelected(parent); parent = parent.getParentPath()) {
            stack.push(parent);
        }
        if (parent != null) {
            stack.push(parent);
        } else {
            super.removeSelectionPaths(new TreePath[]{path});
            return;
        }
        while (!stack.isEmpty()) {
            TreePath temp = (TreePath)stack.pop();
            TreePath peekPath = stack.isEmpty() ? path : (TreePath)stack.peek();
            Object node = temp.getLastPathComponent();
            Object peekNode = peekPath.getLastPathComponent();
            int childCount = this.model.getChildCount(node);
            for (int i = 0; i < childCount; ++i) {
                Object childNode = this.model.getChild(node, i);
                if (childNode == peekNode) continue;
                super.addSelectionPaths(new TreePath[]{temp.pathByAddingChild(childNode)});
            }
        }
        super.removeSelectionPaths(new TreePath[]{parent});
    }
}

