/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.comparison;

import com.sas.metadata.logical.comparison.ComparisonTemplateNodeInterface;
import com.sas.metadata.logical.comparison.DependentAssociation;
import com.sas.metadata.tools.tablecomparator.ComparisonControllerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComparisonTemplateNode
implements ComparisonTemplateNodeInterface {
    Node thisNode;

    ComparisonTemplateNode(Node root) {
        this.thisNode = root;
    }

    @Override
    public ComparisonTemplateNodeInterface.ComparisonPriorityType getComparisonPriorityType() {
        return null;
    }

    @Override
    public boolean compareSequence() {
        return this.getParentBooleanAttribute("compareseq");
    }

    private boolean getParentBooleanAttribute(String attribute) {
        boolean booleanAttrib = false;
        boolean flgpackage = this.checkPackageversion();
        if (!this.isRoot()) {
            String seqAttribute = ((Element)this.thisNode.getParentNode()).getAttribute(attribute);
            booleanAttrib = seqAttribute != null && Boolean.parseBoolean(seqAttribute) && flgpackage;
        }
        return booleanAttrib;
    }

    private boolean checkPackageversion() {
        return ComparisonControllerFactory.getPackageVersion() >= 9200;
    }

    @Override
    public boolean compareAssociation(String association) {
        List<String> assocs = this.getAssociations();
        return assocs != null && assocs.contains(association);
    }

    @Override
    public boolean compareAttribute(String attributeName) {
        List<String> attributes = this.getAttributes();
        return attributes != null && attributes.contains(attributeName);
    }

    @Override
    public ComparisonTemplateNode getTemplateNode(String association) {
        NodeList assocNodes;
        NodeList chileNodes;
        ComparisonTemplateNode templateNode = null;
        Object assocNames = null;
        if (this.compareAssociation(association) && (chileNodes = (assocNodes = ((Element)this.thisNode).getElementsByTagName(association)).item(0).getChildNodes()).getLength() > 0) {
            for (int index = 0; index < chileNodes.getLength(); ++index) {
                if (chileNodes.item(index).getNodeName() == "#text") continue;
                templateNode = new ComparisonTemplateNode(chileNodes.item(index));
            }
        }
        return templateNode;
    }

    @Override
    public List<String> getAssociations() {
        NodeList associations = this.thisNode.getChildNodes();
        ArrayList<String> assocNames = null;
        if (associations != null) {
            assocNames = new ArrayList<String>(associations.getLength());
            for (int index = 0; index < associations.getLength(); ++index) {
                if (associations.item(index).getNodeName() == "#text") continue;
                assocNames.add(associations.item(index).getNodeName());
            }
        }
        return assocNames;
    }

    @Override
    public List<String> getAttributes() {
        Element node = (Element)this.thisNode;
        NamedNodeMap attributeMap = node.getAttributes();
        ArrayList<String> attributes = null;
        if (attributeMap != null) {
            attributes = new ArrayList<String>(attributeMap.getLength());
            for (int index = 0; index < attributeMap.getLength(); ++index) {
                attributes.add(attributeMap.item(index).getNodeName());
            }
        }
        return attributes;
    }

    @Override
    public String getLogicalTypeName() {
        return this.thisNode.getNodeName();
    }

    @Override
    public boolean isLeaf() {
        return this.thisNode.getFirstChild() == null;
    }

    @Override
    public boolean isRoot() {
        return this.thisNode.getParentNode() == null;
    }

    @Override
    public String getPathToParent() {
        String pathToParent = "";
        for (Node parentNode = this.thisNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
            pathToParent = "/" + parentNode.getNodeName() + pathToParent;
        }
        return pathToParent;
    }

    @Override
    public String getXML() {
        return this.nodeToString(this.thisNode);
    }

    private String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            System.out.println("nodeToString Transformer Exception");
        }
        String strNodeContents = sw.toString();
        strNodeContents = strNodeContents.replaceAll("\n", "");
        strNodeContents = strNodeContents.replaceAll("\t", "");
        strNodeContents = strNodeContents.replaceAll("\r", "");
        while (strNodeContents.indexOf("  ") != -1) {
            strNodeContents = strNodeContents.replaceAll("  ", " ");
        }
        return strNodeContents;
    }

    @Override
    public boolean importable() {
        return this.getParentBooleanAttribute("importable");
    }

    @Override
    public List<DependentAssociation> getDependentAssociations() {
        return null;
    }

    @Override
    public String getAssociationName() {
        Node parent = this.thisNode.getParentNode();
        return parent != null ? parent.getNodeName() : null;
    }

    private Element getAssociationElement(String type, boolean isAttrib) {
        NodeList nodes = this.thisNode.getChildNodes();
        Node child = null;
        Element assoc = null;
        if (nodes != null) {
            for (int index = 0; index < nodes.getLength(); ++index) {
                child = nodes.item(index);
                if (child.getNodeName() == "#text") continue;
                assoc = (Element)child;
                if (!(isAttrib ? type.equals(assoc.getAttribute("publictype")) : assoc.getNodeName().equals(type))) continue;
                return assoc;
            }
        }
        return null;
    }

    @Override
    public String getAssociationPublicType(String associationName) {
        Node parent;
        if (associationName != null && (parent = this.thisNode.getParentNode()) != null) {
            return ((Element)parent).getAttribute("publictype");
        }
        return null;
    }

    @Override
    public ComparisonTemplateNode getTemplateNodeByPublicType(String publicType) {
        Element element = this.getAssociationElement(publicType, true);
        if (element != null) {
            NodeList nodes = element.getChildNodes();
            Node child = null;
            if (nodes != null && nodes.getLength() > 0) {
                for (int index = 0; index < nodes.getLength(); ++index) {
                    child = nodes.item(index);
                    if (child.getNodeName() == "#text") continue;
                    return new ComparisonTemplateNode(child);
                }
            }
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return ((Element)this.thisNode.getParentNode()).getAttribute("DisplayName");
    }

    @Override
    public boolean hasDisplayName() {
        return this.checkAssocAttribute();
    }

    private boolean checkAssocAttribute() {
        String seqAttribute;
        boolean booleanAttrib = false;
        if (!this.isRoot() && (seqAttribute = ((Element)this.thisNode.getParentNode()).getAttribute("DisplayName")) != null && seqAttribute != "") {
            booleanAttrib = true;
        }
        return booleanAttrib;
    }
}

