/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities.threadpool;

import com.sas.scheduler.api.servers.sasjfs.utilities.threadpool.WorkerThread;
import com.sas.scheduler.api.servers.sasjfs.utilities.threadpool.WorkerThreadInterface;
import java.util.ArrayList;
import java.util.Stack;

public class ThreadPool {
    private static final String THREAD_NAME_BASE = "SchedPool ";
    private static int _nextThreadNumber = 1;
    private int _minSizeToShrinkTo = 30;
    private static final int MAX_IDLE = 100;
    private static final int MAX_SHRINK = 5;
    private static final long SHRINK_CHECK_INTERVAL_MSEC = 600000L;
    private static final float PERCENTAGE_SHRINK_FROM_MAX_BUSY = 0.1f;
    private static final ThreadPool _instance = new ThreadPool();
    private Stack<WorkerThread> _idle = new Stack();
    private int _numBusy;
    private int _maxBusyBeforeThrottle;
    private long _throttleDelayMsec;
    private long _nextShrinkCheckTime;
    private int _maxBusyThisPeriod;
    private boolean _okToRun;

    private ThreadPool() {
        this.setMaxBusyBeforeThrottle(50);
        this._throttleDelayMsec = 0L;
        this._nextShrinkCheckTime = ThreadPool.now() + 600000L;
        this._okToRun = true;
    }

    public static ThreadPool instance() {
        return _instance;
    }

    public WorkerThreadInterface executeAsynchronously(Runnable work) {
        WorkerThread rval = this.getWorker();
        rval.executeAsynchronously(work);
        this.maybeShrinkIdlePool();
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerThread getWorker() {
        boolean delayNeeded;
        WorkerThread rval = null;
        Stack<WorkerThread> stack = this._idle;
        synchronized (stack) {
            delayNeeded = ++this._numBusy > this._maxBusyBeforeThrottle;
            this._maxBusyThisPeriod = Math.max(this._maxBusyThisPeriod, this._numBusy);
            if (!this._idle.empty()) {
                rval = this._idle.pop();
            }
        }
        if (rval == null) {
            rval = this.createNewWorker();
        }
        if (delayNeeded) {
            try {
                Thread.sleep(this._throttleDelayMsec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rval;
    }

    public void setMaxBusyBeforeThrottle(int maxBusyBeforeThrottle) {
        this._maxBusyBeforeThrottle = maxBusyBeforeThrottle;
    }

    public int getMaxBusyBeforeThrottle() {
        return this._maxBusyBeforeThrottle;
    }

    public String toString() {
        StringBuffer rval = new StringBuffer(100);
        rval.append("ThreadPool: ").append(" num active workers (").append(this._numBusy).append("), max active workers this period(").append(this._maxBusyThisPeriod).append("), num idle workers (").append(this._idle.size()).append(")");
        return rval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readyForNewAssignment(WorkerThread worker) {
        Stack<WorkerThread> stack = this._idle;
        synchronized (stack) {
            if (this._idle.size() >= 100 || !this._okToRun) {
                worker.terminateWhenCurrentWorkCompletes();
            } else {
                this._idle.push(worker);
            }
            --this._numBusy;
        }
        this.maybeShrinkIdlePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerPhonesInSick(WorkerThread worker) {
        Stack<WorkerThread> stack = this._idle;
        synchronized (stack) {
            boolean removed = this._idle.remove(worker);
            if (removed) {
                --this._numBusy;
            }
        }
    }

    private WorkerThread createNewWorker() {
        return new WorkerThread(this, THREAD_NAME_BASE + _nextThreadNumber++);
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeShrinkIdlePool() {
        block10: {
            try {
                if (ThreadPool.now() <= this._nextShrinkCheckTime) break block10;
                ArrayList<WorkerThread> slackers = null;
                Stack<WorkerThread> stack = this._idle;
                synchronized (stack) {
                    this._nextShrinkCheckTime = ThreadPool.now() + 600000L;
                    int numIdle = this._idle.size();
                    this._minSizeToShrinkTo = Math.max(this._minSizeToShrinkTo, (int)((float)this._maxBusyThisPeriod * 0.5f));
                    if (numIdle > this._minSizeToShrinkTo) {
                        int desiredIdle = Math.max(this._minSizeToShrinkTo, (int)(1.0f * (float)this._maxBusyThisPeriod * 0.9f));
                        for (int numToRemove = Math.min(numIdle - desiredIdle, 5); numToRemove > 0; --numToRemove) {
                            if (slackers == null) {
                                slackers = new ArrayList<WorkerThread>();
                            }
                            slackers.add(this._idle.pop());
                        }
                    }
                    this._maxBusyThisPeriod = this._numBusy;
                }
                if (slackers != null) {
                    for (WorkerThread slacker : slackers) {
                        slacker.terminateWhenCurrentWorkCompletes();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public void initShutdown() {
        this._okToRun = false;
        this.stopAllIdleWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllIdleWorkers() {
        Stack<WorkerThread> stack = this._idle;
        synchronized (stack) {
            while (!this._idle.empty()) {
                WorkerThread idle = this._idle.pop();
                idle.terminateWhenCurrentWorkCompletes();
            }
        }
    }

    public void completeShutdown() {
        this._okToRun = false;
        this.stopAllIdleWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInUseCount() {
        Stack<WorkerThread> stack = this._idle;
        synchronized (stack) {
            return this._numBusy;
        }
    }
}

