/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.utilities;

import com.sas.scheduler.api.servers.sasjfs.engine.ClientLogger;
import com.sas.scheduler.api.servers.sasjfs.utilities.FileUtilities;
import com.sas.scheduler.api.servers.sasjfs.utilities.OSCommand;
import com.sas.scheduler.api.servers.sasjfs.utilities.SASJFSXMLFactory;
import com.sas.scheduler.api.servers.sasjfs.utilities.threadpool.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GridCommand {
    public static int RC_FailedToStart = -10;
    public static int RC_MissingReturnCode = -20;
    private ClientLogger m_logger;
    private boolean m_killed = false;
    private String m_jobCommand;
    private String m_gridCommand;
    private File m_logDirectory;
    private String m_commonOptions;

    public GridCommand(String jobCommand, String gridCommand, String logDirectory, boolean useSASProgram, ClientLogger logger) {
        File f;
        String sasProgramPath;
        this.m_gridCommand = gridCommand;
        this.m_logger = logger;
        this.m_commonOptions = this.getCommonOptionsString();
        this.m_jobCommand = useSASProgram ? ((sasProgramPath = GridCommand.getSASProgramPath(jobCommand, this.m_logger)) != null ? this.m_gridCommand + " -gridsubmitpgm " + sasProgramPath + this.m_commonOptions : this.m_gridCommand + " -gridruncmd " + jobCommand + this.m_commonOptions) : this.m_gridCommand + " -gridruncmd " + jobCommand + this.m_commonOptions;
        if (logDirectory != null && (f = new File(logDirectory)).exists()) {
            this.m_logDirectory = f.getParentFile();
        }
    }

    public int runJob(PrintStream outputStream, PrintStream errorStream) throws InterruptedException {
        this.m_logger.logMessage(Level.FINE, "Attempting to run job with gsub: " + this.m_jobCommand + " (" + this.m_gridCommand + ")");
        File tempFileArea = new File(this.m_logDirectory, "gridScripts");
        tempFileArea.mkdirs();
        MyProcess ep = null;
        MyProcess sp = null;
        MyProcess rp = null;
        try {
            int rc;
            String jobID;
            ep = new MyProcess(this.m_jobCommand, outputStream, errorStream, this.m_logger);
            Process executeProcess = ep.runJob();
            executeProcess.waitFor();
            GridCommand.waitForOutputToFinish(ep.mc_outputStreamFlag, ep.mc_errorStreamFlag);
            if (ep.mc_capturedOutputStream.size() > 0) {
                this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stdout: " + ep.mc_capturedOutputStream.toString());
            }
            if (ep.mc_capturedErrorStream.size() > 0) {
                this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stderr: " + ep.mc_capturedErrorStream.toString());
            }
            if ((jobID = GridCommand.processJobStartResultsXML(ep.mc_capturedOutputStream.toString(), ep.mc_capturedErrorStream.toString(), outputStream, errorStream, this.m_gridCommand, this.m_logger)) == null) {
                int n = RC_FailedToStart;
                return n;
            }
            boolean killAttempted = false;
            while (true) {
                boolean isJobFinished;
                if (!killAttempted && this.m_killed) {
                    killAttempted = true;
                    this.m_logger.logMessage(Level.FINE, "Attempting to kill job: " + this.m_jobCommand + " (" + this.m_gridCommand + ")");
                    String kill = this.m_gridCommand + " -gridkilljob " + jobID + this.m_commonOptions;
                    MyProcess kp = new MyProcess(kill, outputStream, errorStream, this.m_logger);
                    Process killProcess = kp.runJob();
                    killProcess.waitFor();
                    GridCommand.waitForOutputToFinish(kp.mc_outputStreamFlag, kp.mc_errorStreamFlag);
                    if (kp.mc_capturedOutputStream.size() > 0) {
                        this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stdout: " + kp.mc_capturedOutputStream.toString());
                    }
                    if (kp.mc_capturedErrorStream.size() > 0) {
                        this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stderr: " + kp.mc_capturedErrorStream.toString());
                    }
                    kp.close();
                }
                this.m_logger.logMessage(Level.FINE, "Attempting to check job status on gsub: " + this.m_jobCommand + " (" + this.m_gridCommand + ")");
                String status = this.m_gridCommand + " -gridgetstatus " + jobID + this.m_commonOptions;
                sp = new MyProcess(status, outputStream, errorStream, this.m_logger);
                Process statusProcess = sp.runJob();
                statusProcess.waitFor();
                GridCommand.waitForOutputToFinish(sp.mc_outputStreamFlag, sp.mc_errorStreamFlag);
                if (sp.mc_capturedOutputStream.size() > 0) {
                    this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stdout: " + sp.mc_capturedOutputStream.toString());
                }
                if (sp.mc_capturedErrorStream.size() > 0) {
                    this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stderr: " + sp.mc_capturedErrorStream.toString());
                }
                if (isJobFinished = GridCommand.processJobStatusResultsXML(sp.mc_capturedOutputStream.toString(), sp.mc_capturedErrorStream.toString(), this.m_gridCommand, jobID, outputStream, errorStream, this.m_logger)) break;
                Thread.sleep(30000L);
            }
            this.m_logger.logMessage(Level.FINE, "gsub job complete.  Attempting to copy output from gsub: " + this.m_jobCommand + " (" + this.m_gridCommand + ")");
            File outputDir = null;
            if (this.m_logDirectory != null) {
                outputDir = new File(this.m_logDirectory, this.m_gridCommand);
                outputDir.mkdirs();
            }
            String results = this.m_gridCommand + " -gridgetresults " + jobID + this.m_commonOptions;
            if (outputDir != null) {
                results = results + " -GRIDRESULTSDIR " + outputDir.getAbsolutePath();
            }
            rp = new MyProcess(results, outputStream, errorStream, this.m_logger);
            Process resultsProcess = rp.runJob();
            resultsProcess.waitFor();
            GridCommand.waitForOutputToFinish(rp.mc_outputStreamFlag, rp.mc_errorStreamFlag);
            if (rp.mc_capturedOutputStream.size() > 0) {
                this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stdout: " + rp.mc_capturedOutputStream.toString());
            }
            if (rp.mc_capturedErrorStream.size() > 0) {
                this.m_logger.logMessage(Level.FINEST, "SASGSUB: " + this.m_gridCommand + " stderr: " + rp.mc_capturedErrorStream.toString());
            }
            int n = rc = GridCommand.processJobResultsXML(rp.mc_capturedOutputStream.toString(), rp.mc_capturedErrorStream.toString(), outputDir, outputStream, errorStream, this.m_gridCommand, jobID, this.m_logger);
            return n;
        }
        catch (Exception e) {
            this.m_logger.logMessage(Level.WARNING, e);
            e.printStackTrace(errorStream);
            throw new RuntimeException(e);
        }
        finally {
            if (ep != null) {
                ep.close();
            }
            if (sp != null) {
                sp.close();
            }
            if (rp != null) {
                rp.close();
            }
        }
    }

    public void killJob() {
        this.m_killed = true;
    }

    private String getCommonOptionsString() {
        String commonOptions = " -GRIDOUTPUTXML";
        return commonOptions;
    }

    private static boolean validateJobId(String jobID, ClientLogger logger) {
        if (!jobID.isEmpty()) {
            try {
                int jobNum = Integer.parseInt(jobID);
                if (jobNum > 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                logger.logMessage(Level.INFO, e);
            }
        }
        return false;
    }

    private static void waitForOutputToFinish(AtomicInteger outputStreamFlag, AtomicInteger errorStreamFlag) throws Exception {
        int outputWaitTicks = 0;
        while (errorStreamFlag.get() == 0 || outputStreamFlag.get() == 0) {
            Thread.sleep(500L);
            if (++outputWaitTicks <= 120) continue;
            break;
        }
    }

    private static String getSASProgramPath(String commandLine, ClientLogger logger) {
        String sasFile;
        String searchString = "-sysin ";
        int sysinIndex = commandLine.indexOf(searchString);
        if (sysinIndex >= 0 && (sasFile = commandLine.substring(sysinIndex + searchString.length()).trim()).length() > 0) {
            if (sasFile.charAt(0) == '\"') {
                sasFile = sasFile.substring(1);
                sysinIndex = sasFile.indexOf(34);
            } else {
                sysinIndex = sasFile.indexOf(32);
            }
            if (sysinIndex < 0) {
                sysinIndex = sasFile.length();
            }
            if (!(sasFile = sasFile.substring(0, sysinIndex).trim()).isEmpty()) {
                logger.logMessage(Level.FINE, "Target file found: " + sasFile + " from command line: " + commandLine);
                File f = new File(sasFile);
                if (f.exists()) {
                    if (f.getName().toLowerCase().endsWith(".sas")) {
                        return sasFile;
                    }
                    logger.logMessage(Level.FINE, "Target file appears not to be a SAS program: " + f.getAbsolutePath());
                    return null;
                }
                logger.logMessage(Level.FINE, "Target file appears not to exist locally, so not allowed to send file as input to sasgsub: " + f.getAbsolutePath());
                return null;
            }
        }
        logger.logMessage(Level.FINE, "No target file found from command line: " + commandLine);
        return null;
    }

    private static int processJobResultsXML(String outputData, String errorData, File outputDir, PrintStream outputStream, PrintStream errorStream, String rendevousID, String jobID, ClientLogger logger) {
        String[] outputLines;
        logger.logMessage(Level.FINER, "gsub job results output (" + rendevousID + ") " + outputData);
        int rc = RC_MissingReturnCode;
        for (String line : outputLines = outputData.split("\n")) {
            if (!(line = line.trim()).startsWith("<") || line.startsWith("<?xml")) continue;
            try {
                NodeList rcNodes;
                InputSource source = new InputSource(new BufferedReader(new StringReader(line)));
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                NodeList jobIDNodes = doc.getElementsByTagName("jobid");
                if (jobIDNodes == null || jobIDNodes.getLength() <= 0) continue;
                Node foundJobIDNode = jobIDNodes.item(0);
                String foundJobID = SASJFSXMLFactory.getCData(foundJobIDNode).trim();
                if (!GridCommand.validateJobId(jobID, logger) || !foundJobID.equals(jobID) || (rcNodes = doc.getElementsByTagName("returncode")) == null || rcNodes.getLength() <= 0) continue;
                String rcString = SASJFSXMLFactory.getCData(rcNodes.item(0)).trim();
                if (!rcString.isEmpty()) {
                    try {
                        rc = Integer.parseInt(rcString);
                    }
                    catch (NumberFormatException e) {
                        logger.logMessage(Level.WARNING, "Error processing return code in gsub output: " + line);
                        logger.logMessage(Level.WARNING, e);
                    }
                    continue;
                }
                logger.logMessage(Level.WARNING, "No return code in gsub output: " + line);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.logMessage(Level.WARNING, e);
            }
        }
        if (outputDir != null && outputDir.exists()) {
            try {
                List<File> allFiles = FileUtilities.findAllFiles(outputDir);
                for (File outputFile : allFiles) {
                    logger.logMessage(Level.FINE, "Reading content from file: " + outputFile.getAbsolutePath() + " for job: " + rendevousID);
                    outputStream.append("Content from file: " + outputFile.getAbsolutePath() + "\n");
                    try {
                        String data = FileUtilities.getFileContents(outputFile, 100000);
                        outputStream.append(data);
                    }
                    catch (Exception e) {
                        errorStream.append("Error reading: " + outputFile.getAbsolutePath() + "\n");
                        e.printStackTrace(errorStream);
                    }
                }
                FileUtilities.deleteDirAndContents(outputDir);
            }
            catch (Exception e) {
                errorStream.append("Error reading output files in: " + outputDir.getAbsolutePath() + "\n");
                e.printStackTrace(errorStream);
            }
        }
        return rc;
    }

    private static boolean processJobStatusResultsXML(String outputData, String errorData, String rendevousID, String jobID, PrintStream outputStream, PrintStream errorStream, ClientLogger logger) {
        String[] outputLines;
        logger.logMessage(Level.FINER, "gsub job status output (" + rendevousID + ") " + outputData);
        for (String line : outputLines = outputData.split("\n")) {
            if (!(line = line.trim()).startsWith("<") || line.startsWith("<?xml")) continue;
            try {
                InputSource source = new InputSource(new BufferedReader(new StringReader(line)));
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                NodeList jobIDNodes = doc.getElementsByTagName("jobid");
                if (jobIDNodes == null || jobIDNodes.getLength() <= 0) continue;
                Node foundJobIDNode = jobIDNodes.item(0);
                String foundJobID = SASJFSXMLFactory.getCData(foundJobIDNode).trim();
                if (!GridCommand.validateJobId(jobID, logger) || !foundJobID.equals(jobID)) continue;
                NodeList statusNodes = doc.getElementsByTagName("status");
                if (statusNodes != null && statusNodes.getLength() > 0) {
                    String endTimeString;
                    String status = SASJFSXMLFactory.getCData(statusNodes.item(0)).trim();
                    if (status.equals("FINISHED") || status.equals("FAILED")) {
                        return true;
                    }
                    NodeList endtimeNodes = doc.getElementsByTagName("endtime");
                    if (endtimeNodes != null && endtimeNodes.getLength() > 0 && (endTimeString = SASJFSXMLFactory.getCData(endtimeNodes.item(0)).trim()).length() > 0) {
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.logMessage(Level.WARNING, e);
            }
        }
        outputStream.append("Output from running sasgsub -gridgetstatus\n");
        outputStream.append(outputData);
        outputStream.append("End of sysout\n");
        errorStream.append("Error output from running sasgsub -gridgetstatus\n");
        errorStream.append(errorData);
        errorStream.append("End of syserr\n");
        throw new IllegalStateException("Job ID not found in gsub output: " + rendevousID + "/" + jobID);
    }

    private static String processJobStartResultsXML(String outputData, String errorData, PrintStream outputStream, PrintStream errorStream, String rendevousID, ClientLogger logger) {
        String[] outputLines;
        logger.logMessage(Level.FINER, "gsub job start output (" + rendevousID + ") " + outputData);
        for (String line : outputLines = outputData.split("\n")) {
            if (!(line = line.trim()).startsWith("<") || line.startsWith("<?xml")) continue;
            try {
                Node foundNode;
                String jobID;
                InputSource source = new InputSource(new BufferedReader(new StringReader(line)));
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(source);
                NodeList result = doc.getElementsByTagName("jobid");
                if (result == null || result.getLength() <= 0 || !GridCommand.validateJobId(jobID = SASJFSXMLFactory.getCData(foundNode = result.item(0)).trim(), logger)) continue;
                return jobID;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.logMessage(Level.WARNING, e);
            }
        }
        return null;
    }

    private static void grabStreamOutput(final InputStream iStream, final OutputStream oStream, final AtomicInteger completeFlag, final ClientLogger logger) {
        ThreadPool.instance().executeAsynchronously(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedInputStream input = null;
                try {
                    input = new BufferedInputStream(iStream);
                    byte[] buf = new byte[1024];
                    try {
                        int bytesRead;
                        while ((bytesRead = ((InputStream)input).read(buf)) >= 0) {
                            oStream.write(buf, 0, bytesRead);
                        }
                    }
                    catch (IOException e) {
                        logger.logMessage(Level.FINE, e);
                    }
                }
                finally {
                    completeFlag.incrementAndGet();
                    try {
                        if (input != null) {
                            ((InputStream)input).close();
                        }
                    }
                    catch (Exception e) {
                        logger.logMessage(Level.FINE, e);
                    }
                }
            }
        });
    }

    private static class MyProcess {
        private String mc_command;
        private PrintStream mc_outputStream;
        private PrintStream mc_errorStream;
        private ClientLogger mc_logger;
        private OSCommand mc_osCommand;
        private AtomicInteger mc_errorStreamFlag = new AtomicInteger(0);
        private AtomicInteger mc_outputStreamFlag = new AtomicInteger(0);
        private ByteArrayOutputStream mc_capturedErrorStream = new ByteArrayOutputStream();
        private ByteArrayOutputStream mc_capturedOutputStream = new ByteArrayOutputStream();

        public MyProcess(String command, PrintStream outputStream, PrintStream errorStream, ClientLogger logger) {
            this.mc_command = command;
            this.mc_outputStream = outputStream;
            this.mc_errorStream = errorStream;
            this.mc_logger = logger;
        }

        public Process runJob() throws InterruptedException {
            this.mc_osCommand = new OSCommand(this.mc_command, this.mc_logger);
            this.mc_osCommand.runJob(this.mc_outputStream, this.mc_errorStream);
            Process process = this.mc_osCommand.getProcess();
            GridCommand.grabStreamOutput(process.getErrorStream(), this.mc_capturedErrorStream, this.mc_errorStreamFlag, this.mc_logger);
            GridCommand.grabStreamOutput(process.getInputStream(), this.mc_capturedOutputStream, this.mc_outputStreamFlag, this.mc_logger);
            return process;
        }

        public void close() {
            if (this.mc_capturedErrorStream != null) {
                try {
                    this.mc_capturedErrorStream.close();
                }
                catch (IOException e) {
                    this.mc_logger.logMessage(Level.WARNING, e);
                }
            }
            if (this.mc_capturedOutputStream != null) {
                try {
                    this.mc_capturedOutputStream.close();
                }
                catch (IOException e) {
                    this.mc_logger.logMessage(Level.WARNING, e);
                }
            }
        }
    }
}

