/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.AbstractTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.CronTab;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.CronTriggers;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.IUNIXTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIHelper;
import com.sas.scheduler.model.TimeEventInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractUNIXTaskScheduler
extends AbstractTaskScheduler {
    protected static Logger LOGGER = null;

    public AbstractUNIXTaskScheduler(String schedulerBinary, List<TimeEventInfo> triggers, String command, String flowId, Logger logger) {
        super(schedulerBinary, flowId);
        this._triggers = triggers;
        this._command = command;
        LOGGER = logger != null ? logger : LogManager.getLogger(AbstractUNIXTaskScheduler.class);
    }

    @Override
    public String scheduleTask() {
        LOGGER.debug("Performing schedule task");
        String retval = null;
        CronTab ct = new CronTab(this._command, LOGGER);
        CronTriggers cronTriggers = new CronTriggers(this._triggers, (IUNIXTaskScheduler)((Object)this), this._command);
        int rc = 0;
        try {
            rc = ct.setExistingCronTabEntries();
            if (rc != 0 && rc != 1 && rc != 126) {
                LOGGER.error("Could not exec the 'crontab -l' command for some reason. crontab -l command returned code: " + rc);
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return null;
        }
        boolean flowScheduled = this.isFlowScheduled(this._flowId, ct.getCronTabEntries());
        if (flowScheduled) {
            return null;
        }
        int cronTabWriteRc = 0;
        try {
            cronTabWriteRc = this.writeCronTabMapToCronTabFile(ct, cronTriggers);
            if (cronTabWriteRc != 0) {
                LOGGER.error("Writing out crontab map failed with rc = " + cronTabWriteRc);
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            LOGGER.error("Exception message: " + e.getMessage());
            return null;
        }
        retval = this.genTriggerId();
        LOGGER.debug("schedule task completed successfully");
        return retval;
    }

    @Override
    public boolean deleteTask() {
        LOGGER.debug("Performing delete task");
        CronTab ct = new CronTab(this._command, LOGGER);
        int rc = 0;
        try {
            rc = ct.setExistingCronTabEntries();
            if (rc != 0) {
                LOGGER.error("Could not obtain the current user's crontab entries.");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        try {
            ct.deleteFromCronTab(this._flowId);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        LOGGER.debug("delete task completed successfully");
        return true;
    }

    @Override
    public String updateTask() {
        LOGGER.debug("Performing update task");
        String retval = null;
        this.deleteTask();
        retval = this.scheduleTask();
        LOGGER.debug("update task completed successfully");
        return retval;
    }

    private String genTriggerId() {
        LOGGER.debug("Generating trigger ID");
        String triggerId = UUID.randomUUID().toString();
        LOGGER.debug("generated trigger ID: " + triggerId);
        return triggerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCronTabMapToCronTabFile(CronTab ct, CronTriggers cronTriggers) throws IOException {
        LOGGER.debug("Writing new crontab map to temp file");
        int retval = 0;
        String newCtFile = ct.createNewCronTabFile();
        if (CLIHelper.isEmpty(newCtFile)) {
            LOGGER.debug("Unable to save original crontab components to temp file. createNewCronTabFile() failed.");
            return 1;
        }
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(newCtFile, true)));
            List<String> ctMapLines = cronTriggers.getCrontabMap();
            LOGGER.debug("New crontab map line count = " + ctMapLines.size());
            for (String ctMapLine : ctMapLines) {
                pw.println(ctMapLine);
            }
        }
        int rc = ct.consumeCronTabFile(newCtFile);
        LOGGER.debug("crontab file import process returned with exit code: " + rc);
        if (rc != 0 && rc != 1 && rc != 126) {
            LOGGER.error("Failed to set new crontab for user. Temp file not imported as new crontab. crontab returned: " + rc);
            return 3;
        }
        File ctFile = new File(newCtFile);
        if (!ctFile.delete()) {
            LOGGER.error("Could not delete temp file: " + newCtFile);
        }
        return retval;
    }

    private boolean isFlowScheduled(String _flowId, List<String> ctEntries) {
        LOGGER.debug("Checking to see if Flow is already scheduled.");
        if (CollectionUtils.isEmpty(ctEntries)) {
            LOGGER.debug("Existing crontab is empty or null. Flow is not currently scheduled.");
            return false;
        }
        boolean retval = false;
        String flowId = null;
        for (String ctLine : ctEntries) {
            flowId = this.getFlowIdFromCtLine(ctLine);
            if (flowId != _flowId) continue;
            LOGGER.debug("Flow already scheduled.");
            return true;
        }
        return retval;
    }

    private String getFlowIdFromCtLine(String ctLine) {
        LOGGER.debug("Getting Flow ID from crontab line: " + ctLine);
        String flowId = "BOGUS****ID";
        int executeParamIndex = ctLine.indexOf(" -execute ");
        if (executeParamIndex > 0) {
            int endOfExecuteParamOption = executeParamIndex + " -execute ".length();
            flowId = ctLine.substring(endOfExecuteParamOption, endOfExecuteParamOption + this._flowId.length());
        }
        return flowId;
    }

    public String createCrontabString(Map<String, String> ctMap) {
        LOGGER.debug("Creating crontab string");
        if (MapUtils.isEmpty(ctMap)) {
            LOGGER.debug("crontab map size was 0. Cannot process that.");
            return null;
        }
        LOGGER.debug("crontab map size = " + ctMap.size());
        String crontabFormatStr = "{second} {minute} {hour} {day} {month} {weekday} {year}";
        String retval = MetaUtilities.replaceString(crontabFormatStr, "{second} ", "");
        retval = MetaUtilities.replaceString(retval, "{minute}", ctMap.get("minute"));
        retval = MetaUtilities.replaceString(retval, "{hour}", ctMap.get("hour"));
        retval = MetaUtilities.replaceString(retval, "{day}", ctMap.get("day"));
        retval = MetaUtilities.replaceString(retval, "{month}", ctMap.get("month"));
        retval = MetaUtilities.replaceString(retval, "{weekday}", ctMap.get("weekday"));
        retval = MetaUtilities.replaceString(retval, " {year}", "");
        LOGGER.debug("Created crontab string: " + retval);
        return retval;
    }
}

