/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.sasjfs.trigger;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.ip.engine.mq.client.NullOutputStream;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerClient;
import com.sas.scheduler.api.servers.sasjfs.trigger.OSTriggerUtilities;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.ITaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.trigger.serviceinterface.WindowsTaskScheduler;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIHelper;
import com.sas.scheduler.api.servers.sasjfs.utilities.CLIReturnCodes;
import com.sas.scheduler.api.servers.sasjfs.utilities.OSCommand;
import com.sas.scheduler.model.TimeEventInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class OSTrigger {
    public static Logger LOGGER = null;
    private static String m_id;
    private static String m_flowId;
    private static SealedString m_key;
    private static String m_user;
    private static String m_stdout;
    private static String m_stderr;
    private static int m_action;
    private static String m_config;
    private static String m_jmsUrl;
    private static String m_jmsClass;
    private static String m_command;
    private static String m_oscommand;
    private static OSTriggerClient m_client;

    public static void main(String[] args) {
        m_id = UUID.randomUUID().toString();
        System.exit(OSTrigger.OSTriggerTask(args));
    }

    public static int OSTriggerTask(String[] args) {
        int rc = CLIReturnCodes.SUCCESS.getValue();
        OSTrigger.processCommandLineArguments(args);
        OSTrigger.initLogger();
        LOGGER.debug("OSTrigger begin run...");
        OSTrigger.getClient();
        switch (m_action) {
            case 1: {
                LOGGER.debug("Processing COMMAND_SCHEDULE");
                rc = OSTrigger.scheduleTask(m_client);
                break;
            }
            case 2: {
                LOGGER.debug("Processing COMMAND_RESCHEDULE");
                rc = OSTrigger.rescheduleTask(m_client);
                break;
            }
            case 3: {
                LOGGER.debug("Processing COMMAND_UNSCHEDULE");
                rc = OSTrigger.unscheduleTask(m_client);
                break;
            }
            case 4: {
                LOGGER.debug("Processing COMMAND_EXECUTE");
                rc = OSTrigger.executeTask(m_client);
                break;
            }
            case 5: {
                LOGGER.debug("Processing COMMAND_SYNC_PASSWORD");
                String host = "localhost";
                try {
                    InetAddress addr = InetAddress.getLocalHost();
                    host = addr.getHostName();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
                char[] key = OSTriggerUtilities.retrievePassword(host, m_user, m_client);
                if (key == null) break;
                m_key = key != null ? new SealedString(key) : null;
            }
            default: {
                ITaskScheduler scheduler;
                LOGGER.debug("Processing COMMAND_UPDATE_PASSWORD");
                if (m_oscommand == null) {
                    m_oscommand = m_client.getOSCommandPath();
                }
                if (!((scheduler = OSTriggerUtilities.initScheduler(null, null, m_oscommand, m_flowId, m_user, m_key, LOGGER)) instanceof WindowsTaskScheduler)) break;
                ((WindowsTaskScheduler)scheduler).updatePassword();
            }
        }
        LOGGER.debug("OSTrigger end run.");
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeTask(OSTriggerClient client) {
        int retval = CLIReturnCodes.SUCCESS.getValue();
        if (m_command == null) {
            String flowOrchCmd = client.getFlowOrchestratorCommand();
            m_command = OSTriggerUtilities.buildFlowOrchestratorCommand(4, flowOrchCmd, m_flowId, m_jmsUrl, m_jmsClass);
        }
        OSCommand osCommand = new OSCommand(m_command, SASJFScheduler.getLogger());
        PrintStream outputStream = null;
        PrintStream errorStream = null;
        try {
            outputStream = m_stdout != null ? new PrintStream(m_stdout) : new PrintStream(new NullOutputStream());
            errorStream = m_stderr != null ? new PrintStream(m_stderr) : new PrintStream(new NullOutputStream());
            LOGGER.debug("Attempting to run OS command");
            retval = osCommand.runJob(outputStream, errorStream);
        }
        catch (FileNotFoundException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            if (outputStream == null) {
                outputStream = new PrintStream(new NullOutputStream());
            }
            if (errorStream == null) {
                errorStream = new PrintStream(new NullOutputStream());
            }
            try {
                retval = osCommand.runJob(outputStream, errorStream);
            }
            catch (InterruptedException e1) {
                if (MetaUtilities.isDebug()) {
                    e1.printStackTrace();
                }
                retval = CLIReturnCodes.INTERRUPTED.getValue();
            }
        }
        catch (InterruptedException e) {
            if (MetaUtilities.isDebug()) {
                e.printStackTrace();
            }
            retval = CLIReturnCodes.INTERRUPTED.getValue();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (errorStream != null) {
                errorStream.close();
            }
        }
        return retval;
    }

    private static int unscheduleTask(OSTriggerClient client) {
        ITaskScheduler scheduler;
        int retval = CLIReturnCodes.SUCCESS.getValue();
        if (m_oscommand == null) {
            m_oscommand = client.getOSCommandPath();
        }
        if (!(scheduler = OSTriggerUtilities.initScheduler(null, null, m_oscommand, m_flowId, m_user, m_key, LOGGER)).deleteTask()) {
            retval = CLIReturnCodes.PERM_DENIED.getValue();
        }
        return retval;
    }

    private static int rescheduleTask(OSTriggerClient client) {
        int retval = CLIReturnCodes.SUCCESS.getValue();
        List<TimeEventInfo> triggers = OSTriggerUtilities.getTimeEventTriggers(client.getTriggerInfo(m_flowId));
        if (m_command == null) {
            String flowOrchCmd = client.getFlowOrchestratorCommand();
            m_command = OSTriggerUtilities.buildFlowOrchestratorCommand(1, flowOrchCmd, m_flowId, m_jmsUrl, m_jmsClass);
        }
        if (m_oscommand == null) {
            m_oscommand = client.getOSCommandPath();
        }
        String triggerId = client.getTriggerId(m_flowId);
        ITaskScheduler scheduler = OSTriggerUtilities.initScheduler(triggers, m_command, m_oscommand, m_flowId, m_user, m_key, LOGGER);
        triggerId = scheduler.updateTask();
        if (!client.setTriggerId(m_flowId, triggerId)) {
            retval = CLIReturnCodes.TRY_AGAIN.getValue();
        }
        return retval;
    }

    private static int scheduleTask(OSTriggerClient client) {
        ITaskScheduler scheduler;
        String triggerId;
        int retval = CLIReturnCodes.SUCCESS.getValue();
        List<TimeEventInfo> triggers = OSTriggerUtilities.getTimeEventTriggers(client.getTriggerInfo(m_flowId));
        if (CollectionUtils.isEmpty(triggers)) {
            LOGGER.error("Triggers list for Flow ID: " + m_flowId + " is empty.");
            retval = CLIReturnCodes.TRY_AGAIN.getValue();
            return retval;
        }
        if (m_command == null) {
            String flowOrchCmd = client.getFlowOrchestratorCommand();
            m_command = OSTriggerUtilities.buildFlowOrchestratorCommand(1, flowOrchCmd, m_flowId, m_jmsUrl, m_jmsClass);
        }
        if (m_oscommand == null) {
            m_oscommand = client.getOSCommandPath();
        }
        if (CLIHelper.isEmpty(triggerId = (scheduler = OSTriggerUtilities.initScheduler(triggers, m_command, m_oscommand, m_flowId, m_user, m_key, LOGGER)).scheduleTask())) {
            LOGGER.debug("triggerId not generated for Flow ID: " + m_flowId);
            retval = CLIReturnCodes.TRIGGER_ID_GEN_FAIL.getValue();
            return retval;
        }
        if (!client.setTriggerId(m_flowId, triggerId)) {
            LOGGER.debug("setTriggerId() failed for Flow ID: " + m_flowId);
            retval = CLIReturnCodes.TRY_AGAIN.getValue();
        }
        return retval;
    }

    private static String handleSpacesInPath(String path) {
        String retval = null;
        if (-1 == path.indexOf(" ")) {
            return path;
        }
        if (OSTrigger.pathIsQuoted(path)) {
            return path;
        }
        retval = "\"" + path + "\"";
        return retval;
    }

    private static boolean pathIsQuoted(String path) {
        return path.startsWith("\"") && path.endsWith("\"");
    }

    private static void processCommandLineArguments(String[] saArgs) {
        int nArgs = saArgs.length;
        for (int iArg = 0; iArg < nArgs; ++iArg) {
            if (MetaUtilities.isDebug()) {
                String nextarg;
                String string = nextarg = iArg + 1 < nArgs ? saArgs[iArg + 1] : null;
                if (nextarg != null && !nextarg.startsWith("-")) {
                    System.out.println(saArgs[iArg] + " " + nextarg);
                } else {
                    System.out.println(saArgs[iArg]);
                }
            }
            if (saArgs[iArg].equalsIgnoreCase("-schedule")) {
                m_action = 1;
                m_flowId = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-reschedule")) {
                m_action = 2;
                m_flowId = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-unschedule")) {
                m_action = 3;
                m_flowId = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-execute")) {
                m_action = 4;
                m_flowId = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-syncKey")) {
                m_action = 5;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-key")) {
                String key;
                m_key = (key = saArgs[++iArg]) != null ? new SealedString(key) : null;
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-user")) {
                m_user = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-config")) {
                m_config = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-stdout")) {
                m_stdout = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-stderr")) {
                m_stderr = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsUrl")) {
                m_jmsUrl = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-jmsContextFactory")) {
                m_jmsClass = saArgs[++iArg];
                continue;
            }
            if (saArgs[iArg].equalsIgnoreCase("-command")) {
                m_command = saArgs[++iArg];
                continue;
            }
            if (!saArgs[iArg].equalsIgnoreCase("-osCommand")) continue;
            m_oscommand = saArgs[++iArg];
        }
    }

    private static OSTriggerClient getClient() {
        if (m_client == null) {
            Properties config = new Properties();
            if (m_config != null) {
                config.setProperty("sasjfs.commandLine.filePath", m_config);
            }
            if (m_jmsClass != null) {
                config.setProperty("java.naming.factory.initial", m_jmsClass);
            } else {
                config.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            }
            if (m_jmsUrl != null) {
                config.setProperty("java.naming.provider.url", m_jmsUrl);
            } else {
                config.setProperty("java.naming.provider.url", "tcp://localhost:61616");
            }
            if (m_user != null) {
                config.setProperty("JMSSecurityUserid", m_user);
            }
            if (m_key != null) {
                config.setProperty("JMSSecurityPasswd", new String(m_key.getCharacters()));
            }
            try {
                m_client = new OSTriggerClient(m_id, config);
            }
            catch (InterruptedException e) {
                LOGGER.debug("InterruptedException: unable to create client.");
            }
        }
        return m_client;
    }

    private static void initLogger() {
        block8: {
            try {
                System.setProperty("hostName", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                System.setProperty("hostName", "localhost");
            }
            if (m_user != null && !m_user.isEmpty()) {
                System.setProperty("userName", m_user);
            } else {
                System.setProperty("userName", System.getProperty("user.name"));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.US);
            String time = dateFormat.format(new Date());
            System.setProperty("timeStamp", time);
            if (!m_config.endsWith(File.separator)) {
                m_config = m_config + File.separator;
            }
            String log4jConfigFilePath = m_config + "log4j2.xml";
            File log4jConfigFile = new File(log4jConfigFilePath = OSTrigger.handleSpacesInPath(log4jConfigFilePath));
            if (!log4jConfigFile.exists()) {
                throw new IllegalArgumentException("log4j2.xml not found in configDir: " + m_config);
            }
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(log4jConfigFile.toURI());
            }
            catch (Exception e) {
                if (!MetaUtilities.isDebug()) break block8;
                e.printStackTrace();
            }
        }
        LOGGER = LogManager.getLogger(OSTrigger.class);
        LOGGER.debug("initLogger() complete");
    }

    static {
        m_user = System.getProperty("userName");
        m_stdout = null;
        m_stderr = null;
        m_action = 0;
        m_config = OSTrigger.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        m_jmsUrl = System.getProperty("sas.sasjfs.jms.url");
        m_jmsClass = System.getProperty("sas.sasjfs.jms.factory");
    }
}

