/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.os;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.os.OSScheduler;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.SchedulerException;
import java.util.ResourceBundle;

public class OSCalendar
implements Calendar {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(OSCalendar.class);
    private static final String InvalidCharacters = "\"<>][ #:;/=";
    private static final char SubstituteCharacter = '_';
    private String m_name = null;
    private String m_owner = "SYS";
    private String m_definition = null;
    private String m_description = null;
    private String m_expression = null;
    private IRecurrenceInfo m_recurrenceInfo = null;

    public OSCalendar(IRecurrenceInfo info, Scheduler scheduler) throws SchedulerException {
        if (!(scheduler instanceof OSScheduler) || info == null) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("OSCalendar.InvalidScheduler.txt"), OSCalendar.class, "OSCalendar.InvalidScheduler.txt", null);
            throw ex;
        }
        this.m_name = info.toShortUniqueString();
        this.m_recurrenceInfo = info;
        this.m_expression = null;
        this.m_description = info.toXML();
    }

    public OSCalendar(String name, String expression, String description) {
        this.m_name = name;
        this.m_recurrenceInfo = null;
        this.m_expression = expression;
        this.m_description = description;
    }

    public OSCalendar(String name, String expression, String owner, String description) {
        this.m_name = name;
        this.m_owner = owner;
        this.m_recurrenceInfo = null;
        this.m_expression = expression;
        this.m_description = description;
    }

    public Object getCalendar() {
        return this;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public boolean setExpression(String exp) {
        this.m_expression = exp;
        return true;
    }

    @Override
    public IRecurrenceInfo getDays() {
        return this.m_recurrenceInfo;
    }

    @Override
    public boolean setDays(IRecurrenceInfo info) {
        this.m_recurrenceInfo = info;
        return true;
    }

    @Override
    public boolean isUserDefined() {
        return !this.m_owner.equalsIgnoreCase("SYS");
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getXML() {
        return this.getDefinition();
    }

    @Override
    public boolean setXML(String xml) {
        return this.setDefinition(xml);
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean setDescription(String description) {
        this.m_description = description;
        return true;
    }

    @Override
    public String getOwner() {
        return this.m_owner;
    }

    @Override
    public boolean setOwner(String owner) {
        this.m_owner = owner;
        return true;
    }

    @Override
    public String makeValidCalendarName(String nameStr) {
        return MetaUtilities.makeValidCalendarName(nameStr, InvalidCharacters, '_');
    }

    @Override
    public boolean isValidCalendarName(String nameStr) {
        boolean isValid = true;
        int slen = InvalidCharacters.length();
        if (!Character.isLetter(nameStr.charAt(0))) {
            isValid = false;
        } else {
            for (int i = 0; i < slen; ++i) {
                char c = InvalidCharacters.charAt(i);
                if (nameStr.indexOf(c) < 0) continue;
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    @Override
    public String getDefinition() {
        return this.m_definition;
    }

    @Override
    public boolean setDefinition(String definition) {
        this.m_definition = definition;
        return true;
    }
}

