/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie.job;

import com.sas.scheduler.api.servers.oozie.generation.ACTION;
import com.sas.scheduler.api.servers.oozie.generation.COORDINATORAPP;
import com.sas.scheduler.api.servers.oozie.generation.WORKFLOW;
import com.sas.scheduler.api.servers.oozie.job.AbstractOozieJob;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.api.servers.oozie.job.OozieWorkflowJob;
import com.sas.scheduler.model.DailyRecurrence;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.MonthlyRecurrence;
import com.sas.scheduler.model.OpaqueRecurrence;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.model.TriggerEventInfo;
import com.sas.scheduler.model.WeeklyRecurrence;
import com.sas.scheduler.model.YearlyRecurrence;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SimpleTimeZone;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;

public class OozieCoordinatorJob
extends AbstractOozieJob {
    COORDINATORAPP coordinatorApp = null;
    int YEARS_IN_FUTURE_ON_END = 50;
    Set<Package> packages = new HashSet<Package>();
    String coordXML = null;
    Exception exception = null;
    OozieWorkflowJob job = null;

    public OozieCoordinatorJob(FlowInfo flow, SchedulerServerInfo server) {
        super(flow, server);
        this.job = new OozieWorkflowJob(flow, server);
        this.createApplication();
        JAXBElement<COORDINATORAPP> oozieCoordinator = this.m_oozieFactory.createCoordinatorApp(this.coordinatorApp);
        try {
            this.coordXML = this.getXml(oozieCoordinator, "   ", this.packages, true);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            this.coordXML = null;
            this.exception = e;
        }
    }

    public String getXML() {
        return this.coordXML;
    }

    public void scheduleFlow() throws OozieException {
        this.job.uploadFlow();
        this.job.uploadScript();
        this.upload();
        this.submitJob(this.getCoordinatorConfigurationXML(), false);
    }

    public void upload() throws OozieException {
        String path = this.getWEBHdfsPathForCoordinator();
        String xml = this.getXML();
        try {
            this.Debug(xml);
            AbstractOozieJob.HttpResponse resp = this.hdfsCreate(path, xml, true);
            this.Debug(resp);
            if (resp.code != 201) {
                throw new OozieException(MessageFormat.format(m_bundle.getString("OozieCoordinatorJob.Coordinator.UploadFailed.fmt"), path, resp.code));
            }
        }
        catch (IOException e) {
            throw new OozieException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createApplication() {
        GregorianCalendar current;
        this.packages.add(COORDINATORAPP.class.getPackage());
        this.coordinatorApp = this.m_oozieFactory.createCOORDINATORAPP();
        this.coordinatorApp.setName(this.flow.getName());
        WORKFLOW oozieWorkflow = this.m_oozieFactory.createWORKFLOW();
        this.packages.add(WORKFLOW.class.getPackage());
        oozieWorkflow.setAppPath(this.getHDFSPathForWorkflow());
        ACTION action = this.m_oozieFactory.createACTION();
        this.packages.add(ACTION.class.getPackage());
        JAXBElement<WORKFLOW> workflow = this.m_oozieFactory.createWORKFLOW(oozieWorkflow);
        action.setAny(workflow);
        String el = null;
        String minutes = "*";
        String hours = "*";
        String dates = "*";
        String months = "*";
        String wkdays = "*";
        String years = "";
        String start = null;
        String end = null;
        String timezone = null;
        SimpleDateFormat oozieDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'", Locale.getDefault());
        oozieDate.setTimeZone(SimpleTimeZone.getTimeZone("UTC"));
        TriggerEventInfo trigger = this.flow.getTriggerEvent();
        if (trigger != null && trigger.getTimeEventDataBinding() != null) {
            TimeEventInfo te = trigger.getTimeEventDataBinding();
            hours = te.getHours();
            minutes = this.stripLeadingZeros(te.getMinutes());
            timezone = te.getTimezone();
            if (timezone != null) {
                this.coordinatorApp.setTimezone(timezone);
            } else {
                this.coordinatorApp.setTimezone(SimpleTimeZone.getDefault().getID());
            }
            IRecurrenceInfo ir = te.getRecurrence();
            if (ir instanceof DailyRecurrence) {
                DailyRecurrence d = (DailyRecurrence)ir;
                if (d.getStartDate() != null) {
                    start = oozieDate.format(d.getStartDate().getTime());
                }
                if (d.getEndDate() != null) {
                    end = oozieDate.format(d.getEndDate().getTime());
                }
                if (d.getSkipCount() == 1) {
                    wkdays = d.isWeekDays() ? "2-6" : "*";
                } else {
                    String[] tokens = hours.split(",; -");
                    Calendar startCal = d.getStartDate();
                    startCal.set(11, Integer.valueOf(tokens[0]));
                    tokens = minutes.split(",; -");
                    startCal.set(12, Integer.valueOf(tokens[0]));
                    Date startDate = startCal.getTime();
                    start = oozieDate.format(startDate);
                    el = "${coord:days(" + d.getSkipCount() + ")}";
                }
            } else if (ir instanceof DateList) {
                Calendar startCal = null;
                DateList l = (DateList)ir;
                List dlist = l.getDatesToRun();
                if (dlist.size() > 0) {
                    startCal = (Calendar)dlist.get(0);
                } else if (l.getStartDate() != null) {
                    startCal = l.getStartDate();
                }
                String[] tokens = hours.split(",; -");
                int hour = Integer.valueOf(tokens[0]);
                startCal.set(11, hour);
                tokens = minutes.split(",; -");
                int minute = Integer.valueOf(tokens[0]);
                startCal.set(12, minute);
                Date startDate = startCal.getTime();
                start = oozieDate.format(startDate);
                startCal.set(11, startCal.get(11) + 1);
                end = oozieDate.format(startCal.getTime());
                el = "61";
            } else if (ir instanceof WeeklyRecurrence) {
                int mask;
                WeeklyRecurrence w = (WeeklyRecurrence)ir;
                if (w.getStartDate() != null) {
                    start = oozieDate.format(w.getStartDate().getTime());
                }
                if (w.getEndDate() != null) {
                    end = oozieDate.format(w.getEndDate().getTime());
                }
                if (w.getSkipCount() == 1) {
                    mask = w.getDayOfWeekDataBinding();
                    switch (mask) {
                        case 64: {
                            wkdays = "1";
                            break;
                        }
                        case 1: {
                            wkdays = "2";
                            break;
                        }
                        case 2: {
                            wkdays = "3";
                            break;
                        }
                        case 4: {
                            wkdays = "4";
                            break;
                        }
                        case 8: {
                            wkdays = "5";
                            break;
                        }
                        case 16: {
                            wkdays = "6";
                            break;
                        }
                        case 32: {
                            wkdays = "7";
                            break;
                        }
                        case 96: {
                            wkdays = "1,7";
                            break;
                        }
                        case 31: {
                            wkdays = "2-6";
                            break;
                        }
                        case 127: {
                            wkdays = "*";
                            break;
                        }
                        default: {
                            wkdays = null;
                            if ((mask & 0x40) != 0) {
                                wkdays = "1";
                            }
                            if ((mask & 1) != 0) {
                                String string = wkdays = wkdays == null ? "2" : wkdays + ",2";
                            }
                            if ((mask & 2) != 0) {
                                String string = wkdays = wkdays == null ? "3" : wkdays + ",3";
                            }
                            if ((mask & 4) != 0) {
                                String string = wkdays = wkdays == null ? "4" : wkdays + ",4";
                            }
                            if ((mask & 8) != 0) {
                                String string = wkdays = wkdays == null ? "5" : wkdays + ",5";
                            }
                            if ((mask & 0x10) != 0) {
                                String string = wkdays = wkdays == null ? "6" : wkdays + ",6";
                            }
                            if ((mask & 0x20) != 0) {
                                wkdays = wkdays + ",7";
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else {
                    mask = w.getDayOfWeekDataBinding();
                    switch (mask) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: {
                            String[] tokens = hours.split(",; -");
                            Calendar startCal = w.getStartDate();
                            startCal.set(11, Integer.valueOf(tokens[0]));
                            tokens = minutes.split(",; -");
                            startCal.set(12, Integer.valueOf(tokens[0]));
                            Date startDate = startCal.getTime();
                            start = oozieDate.format(startDate);
                            el = "${coord:days(" + w.getSkipCount() * 7 + ")}";
                            break;
                        }
                        default: {
                            throw new InvalidParameterException(w.toString());
                        }
                    }
                }
            } else if (ir instanceof MonthlyRecurrence) {
                MonthlyRecurrence m = (MonthlyRecurrence)ir;
                if (m.getStartDate() != null) {
                    start = oozieDate.format(m.getStartDate().getTime());
                }
                if (m.getEndDate() != null) {
                    end = oozieDate.format(m.getEndDate().getTime());
                }
                if (m.getSkipCount() != 1) throw new InvalidParameterException(m.toString());
                if (m.getDayOfMonth() > 0) {
                    dates = String.valueOf(m.getDayOfMonth());
                } else if (m.getDayOfWeek() > 0) {
                    int week = m.getWhichWeek();
                    int day = m.getDayOfWeek();
                    if (day == 128) {
                        dates = "L";
                    } else {
                        switch (day) {
                            case 64: {
                                wkdays = "1";
                                break;
                            }
                            case 1: {
                                wkdays = "2";
                                break;
                            }
                            case 2: {
                                wkdays = "3";
                                break;
                            }
                            case 4: {
                                wkdays = "4";
                                break;
                            }
                            case 8: {
                                wkdays = "5";
                                break;
                            }
                            case 16: {
                                wkdays = "6";
                                break;
                            }
                            case 32: {
                                wkdays = "7";
                            }
                        }
                        switch (week) {
                            case 1: {
                                wkdays = wkdays + "#1";
                                break;
                            }
                            case 2: {
                                wkdays = wkdays + "#2";
                                break;
                            }
                            case 3: {
                                wkdays = wkdays + "#3";
                                break;
                            }
                            case 4: {
                                wkdays = wkdays + "#4";
                                break;
                            }
                            case 6: {
                                wkdays = wkdays + "L";
                            }
                        }
                    }
                }
            } else if (ir instanceof YearlyRecurrence) {
                YearlyRecurrence y = (YearlyRecurrence)ir;
                if (y.getStartDate() != null) {
                    start = oozieDate.format(y.getStartDate().getTime());
                }
                if (y.getEndDate() != null) {
                    end = oozieDate.format(y.getEndDate().getTime());
                }
                if (y.getSkipCount() != 1) throw new InvalidParameterException(y.toString());
                int month = y.getMonth();
                months = String.valueOf(month);
                if (y.getDayOfMonthDataBinding() > 0) {
                    dates = String.valueOf(y.getDayOfMonthDataBinding());
                } else if (y.getDayOfWeek() > 0) {
                    int week = y.getWhichWeek();
                    int day = y.getDayOfWeek();
                    if (day == 128) {
                        dates = "L";
                    } else {
                        switch (day) {
                            case 64: {
                                wkdays = "1";
                                break;
                            }
                            case 1: {
                                wkdays = "2";
                                break;
                            }
                            case 2: {
                                wkdays = "3";
                                break;
                            }
                            case 4: {
                                wkdays = "4";
                                break;
                            }
                            case 8: {
                                wkdays = "5";
                                break;
                            }
                            case 16: {
                                wkdays = "6";
                                break;
                            }
                            case 32: {
                                wkdays = "7";
                            }
                        }
                        switch (week) {
                            case 1: {
                                wkdays = wkdays + "#1";
                                break;
                            }
                            case 2: {
                                wkdays = wkdays + "#2";
                                break;
                            }
                            case 3: {
                                wkdays = wkdays + "#3";
                                break;
                            }
                            case 4: {
                                wkdays = wkdays + "#4";
                                break;
                            }
                            case 6: {
                                wkdays = wkdays + "L";
                            }
                        }
                    }
                }
            } else {
                if (!(ir instanceof OpaqueRecurrence)) throw new InvalidParameterException(te.toString());
                throw new InvalidParameterException(te.toString());
            }
        }
        String frequency = el != null ? el : minutes + " " + hours + " " + dates + " " + months + " " + wkdays + " " + years;
        this.coordinatorApp.setFreqency(frequency);
        if (start != null) {
            this.coordinatorApp.setStart(start);
        } else {
            current = new GregorianCalendar(Locale.getDefault());
            String startStr = oozieDate.format(current.getTime());
            this.coordinatorApp.setStart(startStr);
        }
        if (end != null) {
            this.coordinatorApp.setEnd(end);
        } else {
            current = new GregorianCalendar(Locale.getDefault());
            GregorianCalendar endCal = new GregorianCalendar(current.get(1) + this.YEARS_IN_FUTURE_ON_END, current.get(2), current.get(5), 23, 59);
            String endStr = oozieDate.format(endCal.getTime());
            this.coordinatorApp.setEnd(endStr);
        }
        this.coordinatorApp.setACTION(action);
    }

    private String stripLeadingZeros(String value) {
        if (value.compareTo("00") == 0) {
            return "0";
        }
        if (value.compareTo("01") == 0) {
            return "1";
        }
        if (value.compareTo("02") == 0) {
            return "2";
        }
        if (value.compareTo("03") == 0) {
            return "3";
        }
        if (value.compareTo("04") == 0) {
            return "4";
        }
        if (value.compareTo("05") == 0) {
            return "5";
        }
        if (value.compareTo("06") == 0) {
            return "6";
        }
        if (value.compareTo("07") == 0) {
            return "7";
        }
        if (value.compareTo("08") == 0) {
            return "8";
        }
        if (value.compareTo("09") == 0) {
            return "9";
        }
        return value;
    }
}

