/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.oozie;

import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Calendar;
import com.sas.scheduler.api.servers.FlowHistory;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.api.servers.oozie.OozieCalendar;
import com.sas.scheduler.api.servers.oozie.OozieJob;
import com.sas.scheduler.api.servers.oozie.generation.ObjectFactory;
import com.sas.scheduler.api.servers.oozie.job.OozieCoordinatorJob;
import com.sas.scheduler.api.servers.oozie.job.OozieException;
import com.sas.scheduler.api.servers.oozie.job.OozieWorkflowJob;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OozieScheduler
extends SchedulerIMPL
implements Scheduler {
    private static final ResourceBundle m_bundle;
    private static final Logger LOGGER;
    private String m_host;
    private int m_port;
    private ObjectFactory m_oozieFactory;
    private OozieCalendar m_cal;
    private FlowInfo m_flow;
    private static int m_maxHistory;
    private static int m_maxHistoryPerFlow;
    private static HashMap<String, FlowHistory> m_cachedHistory;
    private static long m_nextID;

    public OozieScheduler(SchedulerServerInfo info) {
        block3: {
            super(info);
            this.m_host = info.getHost();
            if (info.getPort() != null) {
                try {
                    this.m_port = Integer.getInteger(info.getPort());
                }
                catch (RuntimeException ex) {
                    if (!this.isDebug()) break block3;
                    ex.printStackTrace();
                }
            }
        }
        this.m_oozieFactory = new ObjectFactory();
    }

    public void setMaximumsOnHistory(int allflows, int perflow) {
        m_maxHistory = allflows;
        m_maxHistoryPerFlow = perflow;
    }

    @Override
    public boolean areQueues() {
        return false;
    }

    @Override
    public List<String> getQueues() {
        return null;
    }

    @Override
    public Calendar getCalendar(IRecurrenceInfo info) {
        try {
            OozieCalendar cal = new OozieCalendar(info, this);
            cal.setDays(info);
            cal.setDescription(info.toXML());
            return cal;
        }
        catch (SchedulerException se) {
            return null;
        }
    }

    @Override
    public Calendar createCalendar(IRecurrenceInfo info) {
        return this.getCalendar(info);
    }

    @Override
    public String getClassId() {
        return "ff3aab60-8926-4e88-8af3-4287787d7d7";
    }

    @Override
    public boolean scheduleFlow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        boolean rc = false;
        this.m_flow = flow;
        try {
            OozieCoordinatorJob coord = new OozieCoordinatorJob(flow, this.m_schedulingServer);
            coord.scheduleFlow();
            rc = true;
        }
        catch (OozieException e) {
            flow.setFlowSubmitted(false, null);
            SchedulerException ex = new SchedulerException(e.getMessage(), OozieScheduler.class, "OozieScheduler.Job.failed.fmt", new Object[]{e.getMessage()});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getStackTrace().toString());
            } else if (this.isDebug()) {
                e.printStackTrace();
            }
            throw ex;
        }
        return rc;
    }

    @Override
    public boolean scheduleFlowNow(FlowInfo flow) throws SchedulerException, UnsupportedOperationException, InvalidParameterException {
        this.m_flow = flow;
        try {
            try {
                flow.checkCircularDependencies();
            }
            catch (InvalidParameterException ex) {
                InvalidParameterException e = new InvalidParameterException(OozieScheduler.createCircularDependencyMessage(null, ex.getMessage(), flow));
                throw e;
            }
            OozieWorkflowJob job = new OozieWorkflowJob(flow, this.m_schedulingServer);
            job.runFlow();
        }
        catch (OozieException e) {
            SchedulerException ex = new SchedulerException(e.getMessage(), OozieScheduler.class, "OozieScheduler.Job.failed.fmt", new Object[]{e.getMessage()});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getStackTrace().toString());
            } else if (this.isDebug()) {
                e.printStackTrace();
            }
            throw ex;
        }
        return true;
    }

    @Override
    public boolean removeFlow(FlowInfo flow, String triggerType) throws UnsupportedOperationException, SchedulerException {
        try {
            boolean rc = this.removeFlowFromScheduler(flow.getName(), flow.getScheduledUser());
            if (rc) {
                flow.setFlowSubmitted(false);
                flow.setScheduleDefinitionId("");
            } else if (triggerType != null && triggerType.equalsIgnoreCase("RunNow")) {
                return true;
            }
            return rc;
        }
        catch (SchedulerException ex) {
            return triggerType != null && triggerType.equalsIgnoreCase("RunNow");
        }
    }

    @Override
    public boolean removeFlow(String flowName) throws UnsupportedOperationException, SchedulerException {
        return this.removeFlowFromScheduler(flowName, this.m_schedulingServer.getUsername());
    }

    private boolean removeFlowFromScheduler(String flowName, String userid) throws UnsupportedOperationException, SchedulerException {
        try {
            return true;
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            SchedulerException ex = new SchedulerException(m_bundle.getString("OozieScheduler.ErrorProcessingFlow.txt"), OozieScheduler.class, "OozieScheduler.ErrorProcessingFlow.txt", null);
            throw ex;
        }
    }

    @Override
    public boolean killFlowInstance(FlowHistory flowInstance) {
        return false;
    }

    @Override
    public long getFlowInstance(FlowInfo flow) throws SchedulerException {
        FlowHistory history = this.getFlowHistory(flow);
        long flowID = m_nextID++;
        m_cachedHistory.put(String.valueOf(flowID), history);
        return flowID;
    }

    @Override
    public int getMaxFlowHistoryCount() throws SchedulerException {
        return 3;
    }

    @Override
    public FlowHistory getFlowHistory(FlowInfo flow) {
        FlowHistory flowHistory = null;
        return flowHistory;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, int count) {
        if (count < 0) {
            return null;
        }
        List<FlowHistory> list = null;
        return list;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow, int count) {
        if (count < 0) {
            return null;
        }
        List<FlowHistory> list = null;
        return list;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(String userid, List<FlowInfo> flowList, int count) {
        if (count < 0) {
            return null;
        }
        ArrayList<FlowHistory> flowInstances = new ArrayList<FlowHistory>();
        HashMap<String, FlowInfo> flowNames = new HashMap<String, FlowInfo>();
        for (FlowInfo flow : flowList) {
            String flowname = flow.toString();
            flowNames.put(flowname, flow);
        }
        List<FlowHistory> flows = this.getFlowHistoryList(userid, count * flowList.size() * 2);
        int numFlows = flows.size();
        int flowCount = 0;
        String lastFlowName = "";
        for (int x = 0; x < numFlows; ++x) {
            FlowHistory history = flows.get(x);
            String thisFlowName = history.getFlowName();
            if (!flowNames.containsKey(thisFlowName)) continue;
            if (lastFlowName.equals(thisFlowName)) {
                ++flowCount;
            } else {
                flowCount = 0;
                lastFlowName = thisFlowName;
            }
            if (flowCount > count) continue;
            flowInstances.add(history);
        }
        return flowInstances;
    }

    @Override
    public List<FlowHistory> getAllFlowHistory() throws SchedulerException {
        return null;
    }

    @Override
    public List<FlowHistory> getFlowHistoryList(FlowInfo flow) {
        return null;
    }

    @Override
    public Date getFinishTime(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getFinishTime() : null;
    }

    @Override
    public Date getStartTime(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getStartTime() : null;
    }

    @Override
    public int getState(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getState() : -1;
    }

    @Override
    public int getStatus(long id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null ? history.getStatus() : -2;
    }

    @Override
    public boolean isFlowScheduled(String id) {
        FlowHistory history = m_cachedHistory.get(String.valueOf(id));
        return history != null;
    }

    @Override
    public boolean isFlowScheduled(FlowInfo flow) {
        return this.verifyFlowScheduled(flow);
    }

    @Override
    public boolean verifyFlowScheduled(FlowInfo flow) {
        try {
            return false;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    @Override
    public boolean isValidFlowName(String name) {
        int namelen = name.length();
        if (namelen == 0) {
            return false;
        }
        char firstChar = name.charAt(0);
        if (!Character.isUnicodeIdentifierStart(firstChar) && firstChar != SUBCHAR) {
            return false;
        }
        for (int i = 1; i < namelen; ++i) {
            if (Character.isUnicodeIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValidJobName(String name) {
        return OozieJob.isValidName(name);
    }

    @Override
    public String getInvalidChars(boolean flow) {
        if (flow) {
            return "][:;)(#$/";
        }
        return OozieJob.getInValidChars();
    }

    @Override
    public boolean closeConnection() {
        this.m_connected = false;
        return true;
    }

    @Override
    public boolean doesRunNowLeaveDefinition() throws InvalidParameterException {
        return true;
    }

    @Override
    public String runNowName(String flowname) {
        return "RunNow_" + flowname;
    }

    @Override
    public boolean isHistorySupported() throws InvalidParameterException {
        if (this.m_schedulingServer == null) {
            throw new InvalidParameterException();
        }
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return major != 9 || minor != 1;
    }

    @Override
    public boolean isJobDependenciesEnabled() throws InvalidParameterException {
        if (this.m_schedulingServer == null) {
            throw new InvalidParameterException();
        }
        int major = this.getMajorVersion();
        int minor = this.getMinorVersion();
        return major != 9 || minor != 1;
    }

    @Override
    public boolean isTimeDependenciesEnabled() {
        return false;
    }

    @Override
    public boolean isFileDependenciesEnabled() {
        return false;
    }

    public String getWebHDFSPathForCoordinator(FlowInfo flow, SchedulerServerInfo scheduler) {
        String nameNode = scheduler.getWebNameNode();
        String coorPath = scheduler.getCoordinatorPath();
        String userName = scheduler.getUsername();
        if (userName == null) {
            userName = this.m_schedulingServer.getUsername();
        }
        if (userName == null) {
            userName = "";
        }
        userName = this.stripDomainFromUsername(userName);
        String filepath = nameNode + "/webhdfs/v1" + coorPath + "/" + userName + "_c_" + flow.getName() + ".xml";
        return filepath;
    }

    public String getFSPathForCoordinator(FlowInfo flow, SchedulerServerInfo scheduler) {
        String defaultFS = scheduler.getNameNode();
        String coorPath = scheduler.getCoordinatorPath();
        String userName = scheduler.getUsername();
        if (userName == null) {
            userName = this.m_schedulingServer.getUsername();
        }
        if (userName == null) {
            userName = "";
        }
        userName = this.stripDomainFromUsername(userName);
        String filepath = defaultFS + coorPath + "/" + userName + "_c_" + flow.getName() + ".xml";
        return filepath;
    }

    public String getWebHDFSPathForWorkflow(FlowInfo flow, SchedulerServerInfo scheduler) {
        String nameNode = scheduler.getWebNameNode();
        String workPath = scheduler.getWorkflowPath();
        String userName = scheduler.getUsername();
        if (userName == null) {
            userName = this.m_schedulingServer.getUsername();
        }
        if (userName == null) {
            userName = "";
        }
        userName = this.stripDomainFromUsername(userName);
        String filepath = nameNode + "/webhdfs/v1" + workPath + "/" + userName + "_w_" + flow.getName() + ".xml";
        return filepath;
    }

    public String getFSPathForWorkflow(FlowInfo flow, SchedulerServerInfo scheduler) {
        String defaultFS = scheduler.getNameNode();
        String workPath = scheduler.getWorkflowPath();
        String userName = scheduler.getUsername();
        if (userName == null) {
            userName = this.m_schedulingServer.getUsername();
        }
        if (userName == null) {
            userName = "";
        }
        userName = this.stripDomainFromUsername(userName);
        String filepath = defaultFS + workPath + "/" + userName + "_w_" + flow.getName() + ".xml";
        return filepath;
    }

    public static boolean parseConfig(SchedulerServerInfo ssi, String configPath) {
        boolean ret = true;
        HadoopProperties p = new HadoopProperties();
        if (configPath.startsWith("/") && !configPath.endsWith("/")) {
            configPath = configPath + "/";
        } else if (!configPath.endsWith("\\")) {
            configPath = configPath + "\\";
        }
        try {
            String http_policy;
            File core_site = new File(configPath + "core-site.xml");
            File hdfs_site = new File(configPath + "hdfs-site.xml");
            File mapred_site = new File(configPath + "mapred-site.xml");
            File yarn_site = new File(configPath + "yarn-site.xml");
            File hadoop_site = new File(configPath + "hadoop-site.xml");
            File combined = new File(configPath + "combined.xml");
            if (core_site.exists()) {
                OozieScheduler.parsePropertyXML(p, core_site);
            }
            if (hdfs_site.exists()) {
                OozieScheduler.parsePropertyXML(p, hdfs_site);
            }
            if (mapred_site.exists()) {
                OozieScheduler.parsePropertyXML(p, mapred_site);
            }
            if (yarn_site.exists()) {
                OozieScheduler.parsePropertyXML(p, yarn_site);
            }
            if (hadoop_site.exists()) {
                OozieScheduler.parsePropertyXML(p, hadoop_site);
            }
            if (combined.exists()) {
                OozieScheduler.parsePropertyXML(p, combined);
            }
            if ("true".equals(((Properties)p).getProperty("yarn.resourcemanager.ha.enabled"))) {
                String[] ids = ((Properties)p).getProperty("yarn.resourcemanager.ha.rm-ids").split(",");
                String RMID = "yarn.resourcemanager.address." + ids[0];
                String address = ((Properties)p).getProperty(RMID);
                if (address == null || address.equals("")) {
                    RMID = "yarn.resourcemanager.hostname." + ids[0];
                    address = ((Properties)p).getProperty(RMID);
                    address = address + ":8032";
                }
                System.out.println("ResouceManager = " + address);
                ssi.setJobTracker(address);
            } else {
                String address = ((Properties)p).getProperty("yarn.resourcemanager.address");
                if (address == null || address.equals("")) {
                    address = ((Properties)p).getProperty("yarn.resourcemanager.hostname");
                    address = address + ":8032";
                }
                System.out.println("ResouceManager = " + address);
                ssi.setJobTracker(address);
            }
            boolean is_ssl = false;
            String sslenabled = ((Properties)p).getProperty("hadoop.ssl.enabled");
            if (sslenabled != null && sslenabled.equals("true")) {
                is_ssl = true;
            }
            if ((http_policy = ((Properties)p).getProperty("dfs.http.policy")) != null && http_policy != "" && (http_policy.equals("HTTPS_ONLY") || http_policy.equals("HTTP_AND_HTTPS"))) {
                is_ssl = true;
            }
            String namenode = "";
            String dfs_ns = ((Properties)p).getProperty("dfs.nameservices");
            if (dfs_ns != null) {
                String[] nameservices = dfs_ns.split(",");
                String nameservice = nameservices[0];
                boolean working = false;
                int index = 0;
                String list = ((Properties)p).getProperty("dfs.ha.namenodes." + nameservice);
                String[] namenodes = list.split(",");
                while (!working) {
                    namenode = is_ssl ? ((Properties)p).getProperty("dfs.namenode.https-address." + nameservice + "." + namenodes[index]) : ((Properties)p).getProperty("dfs.namenode.http-address." + nameservice + "." + namenodes[index]);
                    if (namenode != null && !namenode.startsWith("http")) {
                        namenode = is_ssl ? "https://" + namenode : "http://" + namenode;
                    }
                    if (OozieScheduler.pingService(namenode)) {
                        working = true;
                        continue;
                    }
                    if (index < namenodes.length - 1) {
                        ++index;
                        continue;
                    }
                    break;
                }
            } else if (is_ssl) {
                namenode = ((Properties)p).getProperty("dfs.https.address");
                if (namenode == null) {
                    namenode = ((Properties)p).getProperty("dfs.namenode.https-address");
                }
            } else {
                namenode = ((Properties)p).getProperty("dfs.http.address");
                if (namenode == null) {
                    namenode = ((Properties)p).getProperty("dfs.namenode.http-address");
                }
            }
            if (namenode != null && !namenode.startsWith("http")) {
                namenode = is_ssl ? "https://" + namenode : "http://" + namenode;
            }
            System.out.println("HDFS  NameNode is " + namenode);
            ssi.setWebNameNode(namenode);
            String defaultFS = "";
            defaultFS = ((Properties)p).getProperty("fs.defaultFS");
            System.out.println("DefaultFS = " + defaultFS);
            ssi.setNameNode(defaultFS);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            ret = false;
        }
        catch (SAXException e) {
            e.printStackTrace();
            ret = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    protected static void parsePropertyXML(Properties p, File xml) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(xml);
        NodeList list = doc.getElementsByTagName("property");
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            NodeList nl = node.getChildNodes();
            String name = "";
            String value = "";
            for (int j = 0; j < nl.getLength(); ++j) {
                Node item = nl.item(j);
                if (item.getNodeName().equals("name")) {
                    name = item.getTextContent();
                    continue;
                }
                if (!item.getNodeName().equals("value")) continue;
                value = item.getTextContent();
            }
            p.setProperty(name, value);
        }
    }

    @Override
    protected boolean __maketheconnection() throws SchedulerException {
        boolean connected = false;
        if (this.m_schedulingServer.getUsername() == null || this.m_schedulingServer.getUsername().length() == 0) {
            PasswordAuthentication l = MetaUtilities.getLoginIdentity(this.m_schedulingServer);
            if (l != null) {
                String username = l.getUserName();
                this.m_schedulingServer.setUsername(username);
                char[] pw = l.getPassword();
                if (pw.length > 0 && MetaUtilities.isAllowPasswordCache()) {
                    this.m_schedulingServer.setPassword(pw.toString());
                }
                connected = username != null && username.length() > 0;
            }
        } else {
            connected = true;
        }
        return connected;
    }

    @Override
    public boolean checkVersion(SchedulerIMPL scheduler) throws SchedulerException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean pingService(String address) {
        HttpURLConnection conn = null;
        boolean rc = false;
        try {
            URL url = new URL(address);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.connect();
            int code = conn.getResponseCode();
            if (code == 200) {
                rc = true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rc;
    }

    private void printJson(Object object) throws JSONException, IOException {
        System.out.println("JSON:");
        if (object != null) {
            JSONObject jsonObject = new JSONObject(String.valueOf(object));
            this.printJson("  ", jsonObject);
        }
    }

    private void printJson(String indent, JSONObject jsonObject) throws JSONException, IOException {
        if (jsonObject == null) {
            System.out.println(indent + "null");
        } else if (jsonObject.equals(JSONObject.NULL)) {
            System.out.println(indent + "JSONObject.NULL");
        } else {
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (jsonObject.isNull(key)) {
                    System.out.println(indent + "'" + key + "' = isNull");
                    continue;
                }
                Object object = jsonObject.get(key);
                if (object.equals(JSONObject.NULL)) {
                    System.out.println(indent + "'" + key + "' = JSONObject.NULL");
                    continue;
                }
                if (object instanceof JSONArray) {
                    JSONArray array = (JSONArray)object;
                    System.out.println(indent + "'" + key + "' = array[" + array.length() + "]:");
                    for (int i = 0; i < array.length(); ++i) {
                        if (array.isNull(i)) {
                            System.out.println(indent + "  " + i + ". = isNull");
                            continue;
                        }
                        Object element = array.get(i);
                        if (element == null) {
                            System.out.println(indent + "  " + i + ". null");
                            continue;
                        }
                        if (object.equals(JSONObject.NULL)) {
                            System.out.println(indent + "  " + i + ". = JSONObject.NULL");
                            continue;
                        }
                        if (element instanceof JSONObject) {
                            System.out.println(indent + "  " + i + ". {");
                            this.printJson(indent + "    ", (JSONObject)element);
                            System.out.println(indent + "  }");
                            continue;
                        }
                        System.out.println(indent + "  " + i + ".  [" + element + "](" + element.getClass().getName() + ")");
                    }
                    continue;
                }
                if (object instanceof JSONObject) {
                    System.out.println(indent + "'" + key + "' = {");
                    this.printJson(indent + "  ", (JSONObject)object);
                    System.out.println(indent + "}");
                    continue;
                }
                System.out.println(indent + "'" + key + "' = [" + object + "](" + object.getClass().getName() + ")");
            }
        }
    }

    private String stripDomainFromUsername(String userName) {
        if (userName == null) {
            return null;
        }
        if (userName.contains("\\")) {
            userName = userName.substring(userName.indexOf(92) + 1);
        } else if (userName.contains("&5C")) {
            userName = userName.substring(userName.indexOf("&5C") + 3);
        }
        if (userName.contains("@")) {
            userName = userName.substring(0, userName.indexOf(64));
        } else if (userName.contains("&40")) {
            userName = userName.substring(0, userName.indexOf("&40"));
        }
        return userName;
    }

    public String getRESTAPIPath(SchedulerServerInfo scheduler) {
        if (scheduler != null) {
            return scheduler.getRestAPIPath();
        }
        if (this.m_schedulingServer != null) {
            return this.m_schedulingServer.getRestAPIPath();
        }
        return null;
    }

    static {
        LOGGER = LogManager.getLogger(OozieScheduler.class);
        String strClassName = OozieScheduler.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
        m_maxHistory = 9999;
        m_maxHistoryPerFlow = 25;
        m_cachedHistory = new HashMap();
        m_nextID = 0L;
    }

    public class HdfsOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        ResponseEntity<String> response;

        public HdfsOperationException(String message, ResponseEntity<String> response) {
            super(message);
            this.response = null;
            this.response = response;
        }

        public ResponseEntity<String> getResponse() {
            return this.response;
        }

        public void setResponse(ResponseEntity<String> response) {
            this.response = response;
        }
    }

    private static class HadoopProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private Pattern p = Pattern.compile("(\\$\\{([^\\}]+)\\})");

        private HadoopProperties() {
        }

        @Override
        public String getProperty(String key) {
            String ret = super.getProperty(key);
            if (ret != null) {
                Matcher m = this.p.matcher(ret);
                while (m.find()) {
                    String prop = m.group(2);
                    String value = this.getProperty(prop);
                    if (value == null) continue;
                    ret = ret.replace(m.group(1), value);
                }
            }
            return ret;
        }
    }

    static enum ACTIONS {
        SHELL,
        MAP_REDUCE,
        PIG,
        FS,
        SUB_WORKFLOW,
        JAVA,
        OTHER;

    }
}

