/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.threadpool;

import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import com.sas.scheduler.api.servers.ip.engine.threadpool.WorkerThreadInterface;

final class WorkerThread
extends Thread
implements WorkerThreadInterface {
    private Object _lock = new Object();
    private Runnable _currentWork;
    private boolean _dying;
    private ThreadPool _myPool;

    public WorkerThread(ThreadPool myPool, String name) {
        super(name);
        this.setDaemon(true);
        this._myPool = myPool;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAsynchronously(Runnable work) {
        Object object = this._lock;
        synchronized (object) {
            this._currentWork = work;
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForWorkToComplete(Runnable previousWorkAssignment) {
        if (previousWorkAssignment == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                while (this._currentWork == previousWorkAssignment) {
                    this._lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForWorkToComplete(Runnable previousWorkAssignment, long timeoutMSec) {
        if (previousWorkAssignment == null) {
            return;
        }
        try {
            Object object = this._lock;
            synchronized (object) {
                long now = WorkerThread.now();
                long expire = now + timeoutMSec;
                while (this._currentWork == previousWorkAssignment && now < expire) {
                    long waitTime = Math.max(1L, expire - now);
                    this._lock.wait(waitTime);
                    now = WorkerThread.now();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNewWork() {
        try {
            Object object = this._lock;
            synchronized (object) {
                while (this._currentWork == null && !this._dying) {
                    this._lock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCurrentWorkNow() {
        if (this._currentWork != null) {
            try {
                this._currentWork.run();
            }
            catch (Throwable t) {
                StringBuffer msg = new StringBuffer(200);
                msg.append("**\n** client of THREAD POOL threw unexpected exception\n** (work item.toString(): ");
                try {
                    msg.append(this._currentWork.getClass()).append(" - ").append(this._currentWork).append(")");
                }
                catch (RuntimeException e) {
                    msg.append("--worker toString() threw exception too [").append(e).append("]");
                }
                System.err.println(msg);
                t.printStackTrace();
            }
            Object object = this._lock;
            synchronized (object) {
                this._currentWork = null;
                this._lock.notifyAll();
            }
            this._myPool.readyForNewAssignment(this);
        }
    }

    @Override
    public void run() {
        block1: {
            while (true) {
                this.waitForNewWork();
                if (this._currentWork == null) break;
                this.doCurrentWorkNow();
            }
            if (this._dying) break block1;
            this._myPool.workerPhonesInSick(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateWhenCurrentWorkCompletes() {
        Object object = this._lock;
        synchronized (object) {
            this._dying = true;
            this._lock.notifyAll();
        }
    }
}

