/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.mq.client.OutputWriter;
import javax.jms.JMSException;
import javax.jms.Message;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessagePostProcessor;

public class QueueWriter
implements OutputWriter {
    protected JmsTemplate mResultsQueue;
    protected String mServerCallbackID;

    public QueueWriter(JmsTemplate outputQueue, String serverCallbackID) {
        this.mResultsQueue = outputQueue;
        this.mServerCallbackID = serverCallbackID;
    }

    @Override
    public void write(byte[] data, final String streamID, final String rendevousID, final String outputName) {
        try {
            this.mResultsQueue.convertAndSend((Object)new Object[]{data}, new MessagePostProcessor(){

                public Message postProcessMessage(Message message) throws JMSException {
                    message.setStringProperty("resultType", streamID);
                    message.setLongProperty("timeStamp", System.currentTimeMillis());
                    message.setStringProperty("rendevousID", rendevousID);
                    message.setObjectProperty("outputSavePath", (Object)outputName);
                    message.setStringProperty("CallbackServer", QueueWriter.this.mServerCallbackID);
                    return message;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

