/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.impl.ServerComponentImpl;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.ip.engine.mq.client.CommandLineJobServer;
import com.sas.scheduler.api.servers.ip.engine.mq.client.JMSClientSupport;
import com.sas.scheduler.modelUtils.ConfigUtils;
import com.sas.svcs.scheduling.client.CachedObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class CommandLineJobServerFromMetadata
extends CommandLineJobServer {
    public static final String Config_MetadataCredentialsFile = "sas.dip.commandLine.metadataCredentialsPath";
    public static final String Config_MetadataConnectionInfoFile = "sas.dip.commandLine.metadataConnectionInfoPath";
    protected static final String UNIX_SERVICELOG_DIP_JOBRUNNER_UP = "SAH061999I";
    public static final String Config_MetadataHost = "sas.dip.commandLine.MetadataHost";
    public static final String Config_MetadataPort = "sas.dip.commandLine.MetadataPort";
    public static final String Config_MetadataUser = "sas.dip.commandLine.MetadataUser";
    public static final String Config_MetadataPassword = "sas.dip.commandLine.MetadataPassword";
    public static final String Config_MetadataRepositoryName = "sas.dip.commandLine.RepositoryName";
    public static final String Config_SchedulerName = "sas.dip.commandLine.SchedulerName";
    protected static volatile boolean mShuttingDown = false;
    private static final String SASConfig_MetaHost = "-metaserver";
    private static final String SASConfig_MetaPort = "-metaport";
    private static final String SASConfig_MetaRepository = "-metarepository";
    private static final String SASConfig_MetaUser = "-metauser";
    private static final String SASConfig_MetaPassword = "-metapass";

    public static void main(String[] args) throws Exception {
        System.out.println("DIP - Command-Line Job Runner");
        try {
            JMSClientSupport support = new CommandLineJobServerFromMetadata().createJobRunner(args);
            if (support != null) {
                System.out.println("Started DIP Job Runner with ID: " + support.getRenderer().getID());
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    static JMSClientSupport start(String[] args) throws Exception {
        System.out.println("DIP - Command-Line Job Runner");
        try {
            JMSClientSupport support = new CommandLineJobServerFromMetadata().createJobRunner(args);
            if (support != null) {
                System.out.println("Started DIP Job Runner with ID: " + support.getRenderer().getID());
                return support;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Properties parseMetadataConnectionProperties(Properties sourceProperties) {
        String connectionFile;
        Properties results = new Properties();
        String credFile = sourceProperties.getProperty(Config_MetadataCredentialsFile, null);
        if (credFile != null) {
            this.findPropertiesInSASFile(credFile, new String[]{SASConfig_MetaUser, SASConfig_MetaPassword}, results);
        }
        if ((connectionFile = sourceProperties.getProperty(Config_MetadataConnectionInfoFile, null)) != null) {
            this.findPropertiesInSASFile(connectionFile, new String[]{SASConfig_MetaHost, SASConfig_MetaPort, SASConfig_MetaRepository}, results);
        }
        return results;
    }

    protected void findPropertiesInSASFile(String fileName, String[] properties, Properties outputData) {
        String fileData = this.readFileText(fileName);
        if (fileData != null) {
            fileData = CommandLineJobServerFromMetadata.stripComments(fileData);
            for (String property : properties) {
                ConfigUtils.findProperty((String)fileData, (String)property, (Properties)outputData);
            }
        }
    }

    public static String stripComments(String data) {
        StringBuffer result = new StringBuffer();
        block0: for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '*') {
                i = data.indexOf(59, i + 1);
                result.append(' ');
                if (i >= 0) continue;
                break;
            }
            if (ch == '/' && i + 1 < data.length() && data.charAt(i + 1) == '*') {
                i = data.indexOf("*/", i + 2);
                result.append(' ');
                if (i < 0) break;
                ++i;
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                char endChar = ch;
                result.append(ch);
                ++i;
                while (i < data.length()) {
                    ch = data.charAt(i);
                    result.append(ch);
                    if (ch == endChar) continue block0;
                    ++i;
                }
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFileText(String fileName) {
        String string;
        File f = new File(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
        try {
            String line;
            StringBuffer fileData = new StringBuffer();
            while ((line = br.readLine()) != null) {
                fileData.append(line);
                fileData.append('\n');
            }
            string = fileData.toString();
        }
        catch (Throwable throwable) {
            try {
                br.close();
                throw throwable;
            }
            catch (Exception e) {
                this.getLogger().logMessage(Level.WARNING, e);
                return null;
            }
        }
        br.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JMSClientSupport createJobRunner(String[] args) throws Exception {
        SealedString password;
        Object omrHost;
        Runtime.getRuntime().addShutdownHook(new Thread("DIP JobRunner-Auto Shutdown"){

            @Override
            public void run() {
                mShuttingDown = true;
            }
        });
        System.out.println("DIP Job Runner starting to obtain configuration.  Unix service initialization token: SAH061999I");
        Properties clientProperties = this.getProperties(args);
        if (clientProperties == null) {
            return null;
        }
        int connectionAttemptCount = 0;
        block9: while (true) {
            if (mShuttingDown) {
                System.exit(0);
            }
            try {
                String omrClusterPorts;
                System.out.println("Attempting to get sastrust and jms credentials via Gemfire cache");
                String logFilePath = clientProperties.getProperty("sas.dip.commandLine.logFilePath");
                if (logFilePath == null) {
                    System.err.println("Error: no log path specified; gemfire will not be used.");
                    break;
                }
                File logFileLocation = new File(logFilePath);
                File gemfireConfig = new File(logFileLocation.getParentFile(), "dip-gemfire-config.xml");
                if (!gemfireConfig.exists()) {
                    System.err.println("Error: Gemfire config file does not exist.  Job Runner will probably not operate correctly: " + gemfireConfig.getAbsolutePath());
                    break;
                }
                FileSystemXmlApplicationContext applicationContext = new FileSystemXmlApplicationContext(gemfireConfig.toURI().toURL().toString());
                Properties environmentProperties = null;
                Map schedulingCache = (Map)applicationContext.getBean("schedulingCache");
                CachedObject cachedObject = new CachedObject();
                cachedObject.setCache(schedulingCache);
                cachedObject.setKey("/sas/properties/environment");
                cachedObject.setClass(Properties.class);
                cachedObject.setSingleton(false);
                int cacheAttemptCount = 0;
                while (true) {
                    if (mShuttingDown) {
                        System.exit(0);
                    }
                    if ((environmentProperties = (Properties)cachedObject.getObject()) != null) break;
                    if (++cacheAttemptCount == 1 || cacheAttemptCount % 20 == 0) {
                        System.err.println("Gemfire cache not available after " + cacheAttemptCount + " attempts.  Retrying.");
                    }
                    if (cacheAttemptCount > 100) continue block9;
                    this.breakUpWait(60000L);
                }
                String user = environmentProperties.getProperty("secure.user");
                SealedString passwd = environmentProperties.getProperty("secure.password") != null ? new SealedString(environmentProperties.getProperty("secure.password")) : null;
                String jmsUser = environmentProperties.getProperty("jms.user");
                SealedString jmsPassword = environmentProperties.getProperty("jms.password") != null ? new SealedString(environmentProperties.getProperty("jms.password")) : null;
                omrHost = environmentProperties.getProperty("omr.host");
                String omrPort = environmentProperties.getProperty("omr.port");
                String omrClusterHosts = environmentProperties.getProperty("omr_cluster_hosts");
                if (null != omrClusterHosts && !omrClusterHosts.isEmpty()) {
                    omrHost = omrClusterHosts;
                }
                if (null != (omrClusterPorts = environmentProperties.getProperty("omr_cluster_ports")) && !omrClusterPorts.isEmpty()) {
                    omrPort = omrClusterPorts;
                }
                this.updateClientProperty(clientProperties, Config_MetadataUser, user, "metadata user", true);
                this.updateClientProperty(clientProperties, Config_MetadataPassword, passwd != null ? String.valueOf(passwd.getCharacters()) : null, "metadata password", false);
                this.updateClientProperty(clientProperties, "JMSSecurityUserid", jmsUser, "JMS user", true);
                this.updateClientProperty(clientProperties, "JMSSecurityPasswd", jmsPassword != null ? String.valueOf(jmsPassword.getCharacters()) : null, "JMS password", false);
                this.updateClientProperty(clientProperties, Config_MetadataHost, (String)omrHost, "metadata host", true);
                this.updateClientProperty(clientProperties, Config_MetadataPort, omrPort, "metadata port", true);
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (BeanDefinitionParsingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                if (++connectionAttemptCount == 1 || connectionAttemptCount % 20 == 0) {
                    e.printStackTrace();
                    System.err.println("Connection to Gemfire failed after " + connectionAttemptCount + " attempts.  Retrying.");
                }
                this.breakUpWait(60000L);
                continue;
            }
            break;
        }
        System.out.println("Searching for metadata locations and credentials in config files");
        Properties metadataConnectionProperties = this.parseMetadataConnectionProperties(clientProperties);
        String[] propertyTranslations = new String[]{Config_MetadataHost, SASConfig_MetaHost, Config_MetadataPort, SASConfig_MetaPort, Config_MetadataRepositoryName, SASConfig_MetaRepository, Config_MetadataUser, SASConfig_MetaUser, Config_MetadataPassword, SASConfig_MetaPassword};
        for (int i = 0; i < propertyTranslations.length; i += 2) {
            String dipKey = propertyTranslations[i];
            String configKey = propertyTranslations[i + 1];
            if (clientProperties.containsKey(dipKey) || !metadataConnectionProperties.containsKey(configKey)) continue;
            clientProperties.setProperty(dipKey, metadataConnectionProperties.getProperty(configKey));
        }
        String rendererID = System.getProperty("sas.dip.commandLine.jobRunnerID", null);
        if (rendererID != null) {
            clientProperties.setProperty("sas.dip.commandLine.jobRunnerID", rendererID);
        }
        if ((rendererID = clientProperties.getProperty("sas.dip.commandLine.jobRunnerID", "")).length() == 0) {
            System.err.println("Property missing: sas.dip.commandLine.jobRunnerID");
            this.showHelp();
            return null;
        }
        String host = clientProperties.getProperty(Config_MetadataHost, null);
        String port = clientProperties.getProperty(Config_MetadataPort, "8561");
        String username = clientProperties.getProperty(Config_MetadataUser, null);
        SealedString sealedString = password = clientProperties.getProperty(Config_MetadataPassword, null) != null ? new SealedString(clientProperties.getProperty(Config_MetadataPassword, null)) : null;
        if (host == null || username == null || password == null) {
            System.err.println("Missing one or more metadata connection properties:");
            if (host == null) {
                System.err.println("\tsas.dip.commandLine.MetadataHost");
            }
            if (username == null) {
                System.err.println("\tsas.dip.commandLine.MetadataUser");
            }
            if (password == null) {
                System.err.println("\tsas.dip.commandLine.MetadataPassword");
            }
            this.showHelp();
            return null;
        }
        String reposName = clientProperties.getProperty(Config_MetadataRepositoryName, null);
        String schedulerName = clientProperties.getProperty(Config_SchedulerName, null);
        MdFactoryImpl factory = new MdFactoryImpl();
        try {
            factory.setDebug(false);
            factory.setLoggingEnabled(false);
            factory.getUtil().setOutputStream((OutputStream)System.out);
            factory.getUtil().setLogStream((OutputStream)System.out);
            factory.makeOMRConnection(host, port, username, password != null ? String.valueOf(password.getCharacters()) : null);
            MdObjectStore store = factory.createObjectStore(null, "CommandLineStore");
            String reposID = null;
            if (reposName == null) {
                reposID = ((CMetadata)factory.getOMIUtil().getRepositories().get(0)).getId();
            } else {
                for (CMetadata metadata : factory.getOMIUtil().getRepositories()) {
                    if (!reposName.equals(metadata.getName())) continue;
                    reposID = metadata.getId();
                    break;
                }
            }
            if (reposID == null) {
                System.err.println("Metadata repository name (" + reposName + ") not found.");
                this.showHelp();
                omrHost = null;
                return omrHost;
            }
            boolean schedulerFound = false;
            List dipServers = MetaUtilities.getSchedulerServers(106, (MdStore)store, reposID);
            for (Object serverObject : dipServers) {
                String[] copyItems;
                if (!(serverObject instanceof ServerComponentImpl)) continue;
                ServerComponentImpl server = (ServerComponentImpl)serverObject;
                if (schedulerName != null && server.getName().indexOf(schedulerName) < 0) continue;
                AssociationList properties = server.getProperties();
                Properties metaProps = new Properties();
                for (int i = 0; i < properties.size(); ++i) {
                    Property property = (Property)properties.elementAt(i);
                    metaProps.setProperty(property.getPropertyName(), property.getDefaultValue());
                }
                for (String propName : copyItems = new String[]{"java.naming.factory.initial", "java.naming.provider.url", "MaxJobs", "JobCountBeforeWait", "MaxWaitTimeMS", "BaseWaitTimeMS", "PIP.OutputLimit", "PIP.JobPollFrequency"}) {
                    String metadataValue = metaProps.getProperty(propName);
                    if (clientProperties.containsKey(propName) || metadataValue == null) continue;
                    clientProperties.setProperty(propName, metadataValue);
                }
                schedulerFound = true;
                break;
            }
            if (!schedulerFound) {
                System.err.println("No DIP scheduler found with name including: " + schedulerName);
                this.showHelp();
                Iterator iterator = null;
                return iterator;
            }
        }
        finally {
            factory.closeOMRConnection();
        }
        System.out.println("DIP Job Runner finished obtaining configuration.");
        JMSClientSupport support = this.constructJobRunner(clientProperties);
        return support;
    }

    protected void breakUpWait(long timeMS) throws InterruptedException {
        for (long elapsed = 0L; elapsed < timeMS; elapsed += 5000L) {
            Thread.sleep(5000L);
        }
    }

    protected void updateClientProperty(Properties clientProperties, String key, String value, String displayName, boolean show) {
        if (!clientProperties.containsKey(key) && value != null && !value.equals("")) {
            System.out.println("Found " + displayName + " from Gemfire: " + (show ? value : "<not shown>"));
            clientProperties.setProperty(key, value);
        }
    }

    @Override
    protected void showHelp() {
        System.out.println("Usage: ");
        System.out.println("\tjava [-Dsas.dip.commandLine.propertyFile=<file path>] [-Dsas.dip.commandLine.jobRunnerID=<id>] CommandLineJobServerFromMetadata [<property file path>]");
        System.out.println("Arguments in the properties file (supply required values and any that should override metadata settings):");
        System.out.println();
        System.out.println("Required parameters (preferred, intended for service usage)");
        System.out.println("\t [Required*] sas.dip.commandLine.metadataCredentialsPath-The path to the file containing SAS code with the userid/password (i.e. the sasv9_meta.cfg file).");
        System.out.println("\t [Required*] sas.dip.commandLine.metadataConnectionInfoPath-The path to the file containing SAS code with the metadata host/port/repository (i.e. the sasv9.cfg file).");
        System.out.println("Required parameters (alternative for non-service cases or to override values from cfg files)");
        System.out.println("\t [Required*] sas.dip.commandLine.jobRunnerID-The unique ID to use for this server (for logs, etc).  You must supply this value either here or using the property.  The property works as an override.");
        System.out.println("\t [Required] sas.dip.commandLine.MetadataHost-The host name of the metadata server.");
        System.out.println("\t [Required*] sas.dip.commandLine.MetadataPort-The port of the metadata server.  Default is 8561.");
        System.out.println("\t [Required] sas.dip.commandLine.MetadataUser-A user ID that can read DIP server metadata.");
        System.out.println("\t [Required] sas.dip.commandLine.MetadataPassword-A password corresponding to the user ID.");
        System.out.println("\t [Required*] sas.dip.commandLine.RepositoryName-The name of the metadata repository.  Uses first repository otherwise.");
        System.out.println("\t [Required*] sas.dip.commandLine.SchedulerName-Part or all of the name of the DIP scheduler that this Job Runner is associated with.  Uses first scheduler otherwise.");
        System.out.println("\t [Required*] JMSSecurityUserid-The JMS user id.  Don't include if no security");
        System.out.println("\t [Required*] JMSSecurityPasswd-The JMS password.  Don't include if no security");
        System.out.println();
        System.out.println("Other parameters that override the values from metadata");
        System.out.println("\tjava.naming.factory.initial-JMS factory class. ex. org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        System.out.println("\tjava.naming.provider.url-JMS URL.  ex. tcp://myMachine.mydomain.com:61616");
        System.out.println("\tMaxJobs-The maximum number of jobs that the server can run at the same time.  Typical value is 10.");
        System.out.println("\tJobCountBeforeWait-The maximum number of jobs that the server can run before it will delay before accepting new work.  Typical value is 2.");
        System.out.println("\tBaseWaitTimeMS-The base wait time used by the default load balancer algorithm.  Typical value is 2000 (2 seconds)");
        System.out.println("\tMaxWaitTimeMS-The maximum wait time used by the default load balancer algorithm.  Typical value is 20000 (20 seconds)");
        System.out.println("\tPIP.OutputLimit-The max number of bytes captured for a job's stdout or stderr, in bytes.  Typical value is 50000.");
        System.out.println("\tPIP.JobPollFrequency-The number of milliseconds before the job runner checks for work again.  Typical value is 10000.");
        System.out.println();
        System.out.println("\tsas.dip.commandLine.hardKillAllowed-if 'true', a Process destroy will be used to terminate processes that have overrun their allotted time.  Otherwise, only a soft kill will be attempted.");
        System.out.println("\tsas.dip.commandLine.handledApplicationIDs-A comma-separated list of application IDs.  If not supplied, the default command-line ID is used.");
        System.out.println("\tsas.dip.commandLine.alternateCommandShell-Set the command shell.  <command shell>;<shell exit command>.  Ex. 'cmd;exit'");
        System.out.println("\tsas.dip.commandLine.logLevel-Set the log level.  INFO/WARN/ERROR/DEBUG.  Default is INFO");
        System.out.println();
        System.out.println("Ctrl-C to shut down the job server gracefully.  Jobs already accepted will be completed first, but no new work will be grabbed.");
    }

    public static void externalShutdown() {
        mShuttingDown = true;
    }
}

