/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.mq.client;

import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.FlowManager;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.mq.client.AbstractJobRunner;
import com.sas.scheduler.api.servers.ip.engine.threadpool.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.apache.commons.lang.SystemUtils;

public class CommandLineJobRunner
extends AbstractJobRunner {
    protected Map<String, Process> mRunningJobs = new HashMap<String, Process>();
    protected Map<String, Boolean> mKilledJobs = new HashMap<String, Boolean>();
    protected boolean mHardKillAllowed = true;
    protected String mName;
    protected String mRunAsMode = "ROOT_ONLY";
    public static final String COMMAND_LINE_RENDERER_NAME = "CommandLine-Renderer";
    public static final String COMMAND_LINE_APPLICATION_ID = "DIP.CommandLine";
    public static final String Property_RunningAsRoot = "sas.dip.commandLine.isRoot";
    public static final String ConfigRunAs_Auto = "ROOT_ONLY";
    public static final String ConfigRunAs_Never = "NO";
    public static final String ConfigRunAs_Always = "YES";
    protected ClientLogger mLogger;
    protected List<String> mApplicationIDs = null;
    protected List<ShellSpecifier> mShells;
    public static final String Windows_Shell = "cmd";
    public static final String Unix_Shell = "/bin/sh";
    public static final String GenericShellExitCommand = "exit";

    public CommandLineJobRunner() {
        this(COMMAND_LINE_RENDERER_NAME);
    }

    public CommandLineJobRunner(String name, ClientLogger logger) {
        this.mName = name;
        this.mLogger = logger;
        this.mShells = new ArrayList<ShellSpecifier>();
        if (SystemUtils.IS_OS_WINDOWS) {
            this.mShells.add(new ShellSpecifier(Windows_Shell, GenericShellExitCommand));
        } else if (SystemUtils.IS_OS_UNIX) {
            this.mShells.add(new ShellSpecifier(Unix_Shell, GenericShellExitCommand));
        } else {
            this.mShells.add(new ShellSpecifier(Unix_Shell, GenericShellExitCommand));
            this.mShells.add(new ShellSpecifier(Windows_Shell, GenericShellExitCommand));
        }
        this.mShells.add(new ShellSpecifier("", ""));
        this.mLogger.logMessage(Level.FINE, "Currently running as root: " + this.isRootProperty());
    }

    public CommandLineJobRunner(String name) {
        this(name, FlowManager.getDefaultLogger());
    }

    public void setApplicationIDs(List<String> appIDs) {
        this.mApplicationIDs = appIDs;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public List<String> getApplicationIDs() {
        if (this.mApplicationIDs != null) {
            return this.mApplicationIDs;
        }
        return Arrays.asList(COMMAND_LINE_APPLICATION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killJob(String rendevousID, boolean force) {
        Process p = null;
        CommandLineJobRunner commandLineJobRunner = this;
        synchronized (commandLineJobRunner) {
            p = this.mRunningJobs.get(rendevousID);
        }
        if (p != null) {
            commandLineJobRunner = this;
            synchronized (commandLineJobRunner) {
                this.mKilledJobs.put(rendevousID, true);
            }
            if (this.isHardKillAllowed()) {
                p.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runJob(Job jobDefinition, String rendevousID, PrintStream outputStream, PrintStream errorStream) throws InterruptedException {
        Process p = null;
        InputStream errStream = null;
        InputStream oStream = null;
        try {
            Object commandWriter;
            String jobCommand = jobDefinition.getOSCommand();
            ShellSpecifier usedShell = null;
            Throwable lastException = null;
            for (ShellSpecifier shell : this.mShells) {
                try {
                    String shellCommand = shell.getShellCommand();
                    if (shellCommand.length() == 0) {
                        shellCommand = jobCommand;
                    } else if (!jobDefinition.getUserName().isEmpty() && !jobDefinition.getUserName().equals("Anonymous") && this.canRunAs()) {
                        shellCommand = "sudo -n -u " + jobDefinition.getUserName() + " " + shellCommand;
                        this.mLogger.logMessage(Level.FINE, "DIP JobRunner: Attempting to run command (" + shellCommand + ") as " + jobDefinition.getUserName());
                    } else {
                        this.mLogger.logMessage(Level.FINE, "DIP JobRunner: Attempting to run command (" + shellCommand + ") as service user");
                    }
                    p = Runtime.getRuntime().exec(shellCommand);
                    usedShell = shell;
                    break;
                }
                catch (Exception e) {
                    this.mLogger.logMessage(Level.FINE, "Failed to run shell command: " + shell.getShellCommand());
                    this.mLogger.logMessage(Level.INFO, e);
                    lastException = e;
                }
            }
            if (usedShell == null || p == null) {
                if (lastException != null) {
                    this.mLogger.logMessage(Level.WARNING, lastException);
                    lastException.printStackTrace(errorStream);
                }
                throw new IllegalArgumentException(lastException);
            }
            if (usedShell.getShellCommand().length() > 0) {
                commandWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(p.getOutputStream(), "UTF-8")), true);
                ((PrintWriter)commandWriter).println(jobCommand);
                if (usedShell.getExitCommand().length() > 0) {
                    ((PrintWriter)commandWriter).println(usedShell.getExitCommand());
                }
                ((PrintWriter)commandWriter).close();
            }
            commandWriter = this;
            synchronized (commandWriter) {
                this.mRunningJobs.put(rendevousID, p);
            }
            errStream = new BufferedInputStream(p.getErrorStream());
            oStream = new BufferedInputStream(p.getInputStream());
            AtomicInteger errorStreamFlag = new AtomicInteger(0);
            AtomicInteger outputStreamFlag = new AtomicInteger(0);
            this.grabStreamOutput(errStream, errorStream, errorStreamFlag);
            this.grabStreamOutput(oStream, outputStream, outputStreamFlag);
            int exitValue = p.waitFor();
            CommandLineJobRunner commandLineJobRunner = this;
            synchronized (commandLineJobRunner) {
                Boolean killed = this.mKilledJobs.remove(rendevousID);
                if (killed != null && killed.equals(Boolean.TRUE)) {
                    throw new InterruptedException("Process killed by scheduler.");
                }
            }
            int outputWaitTicks = 0;
            while (errorStreamFlag.get() == 0 || outputStreamFlag.get() == 0) {
                Thread.sleep(500L);
                if (++outputWaitTicks <= 120) continue;
            }
            int n = exitValue;
            return n;
        }
        catch (InterruptedException e) {
            e.printStackTrace(errorStream);
            throw e;
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
            e.printStackTrace(errorStream);
            throw new RuntimeException(e);
        }
        finally {
            CommandLineJobRunner commandLineJobRunner = this;
            synchronized (commandLineJobRunner) {
                this.mRunningJobs.remove(rendevousID);
            }
            if (errStream != null) {
                try {
                    errStream.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (IOException e) {
                    this.mLogger.logMessage(Level.WARNING, e);
                }
            }
        }
    }

    public void setRunAsMode(String mode) {
        if (mode != null) {
            this.mRunAsMode = mode;
        }
    }

    protected boolean canRunAs() {
        if (SystemUtils.IS_OS_UNIX) {
            if (this.mRunAsMode.equals(ConfigRunAs_Never)) {
                return false;
            }
            if (this.mRunAsMode.equals(ConfigRunAs_Always)) {
                return true;
            }
            if (this.isRootProperty()) {
                return true;
            }
        }
        return false;
    }

    private boolean isRootProperty() {
        String isRootString = System.getProperty(Property_RunningAsRoot, "false");
        boolean isRoot = Boolean.parseBoolean(isRootString);
        return isRoot;
    }

    private void grabStreamOutput(final InputStream iStream, final PrintStream oStream, final AtomicInteger completeFlag) {
        ThreadPool.instance().executeAsynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    try {
                        int bytesRead;
                        while ((bytesRead = iStream.read(buf)) >= 0) {
                            oStream.write(buf, 0, bytesRead);
                        }
                    }
                    catch (IOException e) {
                        CommandLineJobRunner.this.mLogger.logMessage(Level.FINE, e);
                    }
                }
                finally {
                    completeFlag.incrementAndGet();
                }
            }
        });
    }

    public boolean isHardKillAllowed() {
        return this.mHardKillAllowed;
    }

    public void setHardKillAllowed(boolean hardKillAllowed) {
        this.mHardKillAllowed = hardKillAllowed;
    }

    public void addShellCommand(String shellCommand, String exitCommand) {
        if (shellCommand != null && shellCommand.length() > 0 && exitCommand != null && exitCommand.length() > 0) {
            this.mShells.add(0, new ShellSpecifier(shellCommand, exitCommand));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(CommandLineJobRunner)");
        buffer.append(" HardKillAllowed=" + this.isHardKillAllowed());
        buffer.append(" JobQueues=");
        boolean first = true;
        for (String queue : this.getApplicationIDs()) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(queue);
        }
        return buffer.toString();
    }

    static class ShellSpecifier {
        private String mShellCommand;
        private String mExitCommand;

        public ShellSpecifier(String shellCommand, String shellExitCommand) {
            this.mShellCommand = shellCommand;
            this.mExitCommand = shellExitCommand;
        }

        public String getShellCommand() {
            return this.mShellCommand;
        }

        public String getExitCommand() {
            return this.mExitCommand;
        }
    }
}

