/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine.jgroups;

import com.sas.entities.GUID;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.AbstractUserSession;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.HistorySearchOptions;
import com.sas.scheduler.api.servers.ip.engine.JobRendererInfo;
import com.sas.scheduler.api.servers.ip.engine.MasterServer;
import com.sas.scheduler.api.servers.ip.engine.PredefinedCalendar;
import com.sas.scheduler.api.servers.ip.engine.ScheduleIDInfo;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlowIDInfo;
import com.sas.scheduler.api.servers.ip.engine.jgroups.JGroupsClusterSupport;
import com.sas.scheduler.model.SchedulerException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.jgroups.Address;
import org.jgroups.Message;

public class JGroupsMasterServer
implements MasterServer {
    private JGroupsClusterSupport mClusterSupport;
    protected Address mMasterNode;
    protected Address mExecutionMasterNode;
    protected int mFailureRetries = 5;

    public JGroupsMasterServer(JGroupsClusterSupport clusterSupport, Address masterNode, Address executionMasterNode) {
        this.mMasterNode = masterNode;
        this.mExecutionMasterNode = executionMasterNode;
        this.mClusterSupport = clusterSupport;
    }

    private void postMessage(Message message) {
        Vector<Address> targetMasterNode = new Vector<Address>();
        targetMasterNode.add(this.mMasterNode);
        this.mClusterSupport.getDispatcher().castMessage(targetMasterNode, message, 6, this.mClusterSupport.getTimeout());
    }

    @Override
    public String[] addFlows(String sessionID, TopLevelFlow[] newFlows) {
        String[] flowDefs;
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "AddFlows";
        data[1] = sessionID;
        data[2] = flowDefs = new String[newFlows.length];
        for (int i = 0; i < newFlows.length; ++i) {
            TopLevelFlow flow = newFlows[i];
            flowDefs[i] = flow.toSerializedForm();
        }
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[newFlows.length];
    }

    @Override
    public String[] addPredefinedCalendars(String sessionID, PredefinedCalendar[] calendars) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AbstractUserSession createSession(String userID, String password) {
        return this.createSession(userID, password != null ? new SealedString(password) : null);
    }

    @Override
    public AbstractUserSession createSession(String userID, SealedString password) {
        String guid;
        Message message = new Message();
        String[] data = new String[]{"CreateSession", userID, String.valueOf(password != null ? password.getCharacters() : null), guid = GUID.newGUID()};
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            AbstractUserSession userSession = this.mClusterSupport.getManager().getExecutionProvider().constructSession((String)result);
            userSession.setFlowManager(this.mClusterSupport.getManager());
            return userSession;
        }
        return null;
    }

    @Override
    public String[] deleteFlows(String sessionID, String[] flowIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "DeleteFlows";
        data[1] = sessionID;
        data[2] = flowIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[0];
    }

    @Override
    public TopLevelFlowIDInfo[] getAllFlowIDs(String sessionID) {
        Message message = new Message();
        Object[] data = new Object[3];
        data[0] = "GetAllFlowIDs";
        data[1] = sessionID;
        String guid = GUID.newGUID();
        data[2] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] idInfoStrings = (String[])result;
            ArrayList<TopLevelFlowIDInfo> idInfos = new ArrayList<TopLevelFlowIDInfo>();
            for (int i = 0; i < idInfoStrings.length; ++i) {
                String defString = idInfoStrings[i];
                try {
                    TopLevelFlowIDInfo newFlowInfo = TopLevelFlowIDInfo.createFromSeralizedForm(defString, this.mClusterSupport.getManager().getLogger());
                    if (newFlowInfo == null) continue;
                    idInfos.add(newFlowInfo);
                    continue;
                }
                catch (Exception e) {
                    this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                }
            }
            return idInfos.toArray(new TopLevelFlowIDInfo[0]);
        }
        return new TopLevelFlowIDInfo[0];
    }

    @Override
    public PredefinedCalendar getCalendarForID(String calendarID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TopLevelFlow[] getFlowDefinitions(String sessionID, String[] flowIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "GetFlowDefinitions";
        data[1] = sessionID;
        data[2] = flowIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] flowDefs = (String[])result;
            ArrayList<TopLevelFlow> defs = new ArrayList<TopLevelFlow>();
            for (int i = 0; i < flowDefs.length; ++i) {
                String defString = flowDefs[i];
                try {
                    TopLevelFlow newFlow = TopLevelFlow.createFromXML(new BufferedReader(new StringReader(defString)), this.mClusterSupport.getManager().getLogger());
                    if (newFlow == null) continue;
                    defs.add(newFlow);
                    continue;
                }
                catch (Exception e) {
                    this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return defs.toArray(new TopLevelFlow[0]);
        }
        return new TopLevelFlow[0];
    }

    @Override
    public FlowHistory[] getFlowHistories(String sessionID, String[] flowIDs, int countPerFlow) {
        Message message = new Message();
        Object[] data = new Object[5];
        data[0] = "GetFlowHistories";
        data[1] = sessionID;
        data[2] = flowIDs;
        data[3] = new Integer(countPerFlow);
        String guid = GUID.newGUID();
        data[4] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] historiesAsString = (String[])result;
            ArrayList<FlowHistory> histories = new ArrayList<FlowHistory>();
            for (int i = 0; i < historiesAsString.length; ++i) {
                String historyString = historiesAsString[i];
                try {
                    FlowHistory history = FlowHistory.GetHistoryFromString(historyString, this.mClusterSupport.mLogger);
                    if (history == null) continue;
                    histories.add(history);
                    continue;
                }
                catch (Exception e) {
                    this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                }
            }
            return histories.toArray(new FlowHistory[0]);
        }
        return new FlowHistory[0];
    }

    protected Object waitForResponse(String guid) {
        try {
            long startTime = System.currentTimeMillis();
            while (!this.mClusterSupport.hasResponse(guid) && System.currentTimeMillis() - startTime <= 60000L) {
                Thread.sleep(250L);
            }
            Object result = this.mClusterSupport.getResponse(guid);
            return result;
        }
        catch (Exception e) {
            this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, e);
            return null;
        }
    }

    @Override
    public FlowHistory[] getFlowHistory(String sessionID, HistorySearchOptions options) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "SearchHistory";
        data[1] = sessionID;
        data[2] = options.toSerializedForm();
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] historiesAsString = (String[])result;
            ArrayList<FlowHistory> histories = new ArrayList<FlowHistory>();
            for (int i = 0; i < historiesAsString.length; ++i) {
                String historyString = historiesAsString[i];
                try {
                    FlowHistory history = FlowHistory.GetHistoryFromString(historyString, this.mClusterSupport.mLogger);
                    if (history == null) continue;
                    histories.add(history);
                    continue;
                }
                catch (Exception e) {
                    this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                }
            }
            return histories.toArray(new FlowHistory[0]);
        }
        return new FlowHistory[0];
    }

    @Override
    public String getFlowID(String sessionID, String flowName) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "GetFlowByName";
        data[1] = sessionID;
        data[2] = flowName;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    @Override
    public FlowInstance[] getInstanceDefinitions(String sessionID, String[] instanceIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "GetInstanceDefinitions";
        data[1] = sessionID;
        data[2] = instanceIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] instanceDefs = (String[])result;
            ArrayList<FlowInstance> defs = new ArrayList<FlowInstance>();
            for (int i = 0; i < instanceDefs.length; ++i) {
                String defString = instanceDefs[i];
                try {
                    FlowInstance newInstance = FlowInstance.createFromXML(new BufferedReader(new StringReader(defString)), this.mClusterSupport.getManager().getLogger());
                    if (newInstance == null) continue;
                    defs.add(newInstance);
                    continue;
                }
                catch (SchedulerException e) {
                    this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, e);
                }
            }
            return defs.toArray(new FlowInstance[0]);
        }
        return new FlowInstance[0];
    }

    @Override
    public ScheduleIDInfo[] getPredefinedCalendarIDInfos(String sessionID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PredefinedCalendar[] getPredefinedCalendars(String sessionID, String[] calendarIDs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] holdFlows(String sessionID, String[] flowIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "HoldFlows";
        data[1] = sessionID;
        data[2] = flowIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[0];
    }

    @Override
    public boolean isAdministrator(String sessionID) {
        Message message = new Message();
        Object[] data = new Object[3];
        data[0] = "IsAdministrator";
        data[1] = sessionID;
        String guid = GUID.newGUID();
        data[2] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public String[][] isPredefinedCalendarInUse(String sessionID, String scheduleID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean killExecutionItem(String sessionID, String flowInstanceID, String subItemID, boolean force) {
        Message message = new Message();
        Object[] data = new Object[6];
        data[0] = "KillExecutionItem";
        data[1] = sessionID;
        data[2] = flowInstanceID;
        data[3] = subItemID;
        data[4] = force;
        String guid = GUID.newGUID();
        data[5] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public String[] killFlowInstances(String sessionID, String[] instanceIDs, boolean force) {
        Message message = new Message();
        Object[] data = new Object[5];
        data[0] = "KillFlows";
        data[1] = sessionID;
        data[2] = instanceIDs;
        data[3] = force;
        String guid = GUID.newGUID();
        data[4] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[0];
    }

    @Override
    public String[] releaseFlows(String sessionID, String[] flowIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "ReleaseFlows";
        data[1] = sessionID;
        data[2] = flowIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[0];
    }

    @Override
    public String[] runFlows(String sessionID, String[] flowIDs) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "RunFlows";
        data[1] = sessionID;
        data[2] = flowIDs;
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            return (String[])result;
        }
        return new String[0];
    }

    @Override
    public boolean terminateSession(String sessionID) {
        Message message = new Message();
        Object[] data = new Object[3];
        data[0] = "TerminateSession";
        data[1] = sessionID;
        String guid = GUID.newGUID();
        data[2] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean triggerExecutionItem(String sessionID, String flowInstanceID, String subItemID) {
        Message message = new Message();
        Object[] data = new Object[5];
        data[0] = "TriggerExecutionItem";
        data[1] = sessionID;
        data[2] = flowInstanceID;
        data[3] = subItemID;
        String guid = GUID.newGUID();
        data[4] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean updateFlow(String sessionID, TopLevelFlow flow) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "UpdateFlow";
        data[1] = sessionID;
        data[2] = flow.toSerializedForm();
        String guid = GUID.newGUID();
        data[3] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    @Override
    public boolean updatePredefinedCalendar(String sessionID, PredefinedCalendar newCalendarDef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markJobFinished(String rendevousID, int statusCode, int exitCode) {
        if (this.mExecutionMasterNode == null) {
            this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, "Null execution channel in markJobFinished");
            return;
        }
        Message message = new Message();
        Object[] data = new Object[]{"MarkJobFinished", rendevousID, new Integer(statusCode), new Integer(exitCode)};
        message.setObject((Serializable)data);
        Vector<Address> targetMasterNode = new Vector<Address>();
        targetMasterNode.add(this.mExecutionMasterNode);
        this.mClusterSupport.getExecutionDispatcher().castMessage(targetMasterNode, message, 6, this.mClusterSupport.getTimeout());
    }

    @Override
    public void updateJobStartInfo(String rendevousID, long startTime, String rendererName) {
        if (this.mExecutionMasterNode == null) {
            this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, "Null execution channel in updateJobStartInfo");
            return;
        }
        Message message = new Message();
        Object[] data = new Object[]{"UpdateJobStart", rendevousID, new Long(startTime), rendererName};
        message.setObject((Serializable)data);
        Vector<Address> targetMasterNode = new Vector<Address>();
        targetMasterNode.add(this.mExecutionMasterNode);
        this.mClusterSupport.getExecutionDispatcher().castMessage(targetMasterNode, message, 6, this.mClusterSupport.getTimeout());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JGroups Master Server: " + this.mMasterNode);
        return buffer.toString();
    }

    @Override
    public int getErrorStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return this.getStreamData("GetErrorData", sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    @Override
    public int getOutputStreamData(String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        return this.getStreamData("GetOutputData", sessionID, flowID, instanceID, uniqueSubitemID, startPos, maxCharacters, buffer);
    }

    public int getStreamData(String opCode, String sessionID, String flowID, String instanceID, String uniqueSubitemID, long startPos, int maxCharacters, StringBuffer buffer) {
        Message message = new Message();
        Object[] data = new Object[8];
        data[0] = opCode;
        data[1] = sessionID;
        data[2] = flowID;
        data[3] = instanceID;
        data[4] = uniqueSubitemID;
        data[5] = startPos;
        data[6] = maxCharacters;
        String guid = GUID.newGUID();
        data[7] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        try {
            JGroupsClusterSupport.OutputHolder holder = (JGroupsClusterSupport.OutputHolder)result;
            buffer.append(holder.getData());
            return holder.getCharsRead();
        }
        catch (Exception e) {
            this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
            return -1;
        }
    }

    @Override
    public Collection<JobRendererInfo> getJobRendererSnapshots() {
        Message message = new Message();
        Object[] data = new Object[2];
        data[0] = "GetRendererSnapshots";
        String guid = GUID.newGUID();
        data[1] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        ArrayList<JobRendererInfo> results = new ArrayList<JobRendererInfo>();
        Object result = this.waitForResponse(guid);
        if (result instanceof String[]) {
            String[] infos;
            for (String serializedData : infos = (String[])result) {
                try {
                    JobRendererInfo object = JobRendererInfo.createFromData(serializedData);
                    if (object == null) continue;
                    results.add(object);
                }
                catch (Exception e) {
                    this.mClusterSupport.mLogger.logMessage(Level.WARNING, e);
                }
            }
            return results;
        }
        return results;
    }

    @Override
    public Properties getMasterServerConfig() {
        Message message = new Message();
        Object[] data = new Object[2];
        data[0] = "GetMasterServerConfig";
        String guid = GUID.newGUID();
        data[1] = guid;
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof String) {
            Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(((String)result).getBytes()));
            }
            catch (IOException e) {
                this.mClusterSupport.getManager().getLogger().logMessage(Level.WARNING, e);
            }
            return props;
        }
        return new Properties();
    }

    @Override
    public List<Long> getNextTriggerTimes(List<String> flowIDs, Calendar startTime) {
        Message message = new Message();
        Object[] data = new Object[4];
        data[0] = "GetNextTriggerTimes";
        data[1] = flowIDs.toArray(new String[0]);
        String guid = GUID.newGUID();
        data[2] = guid;
        data[3] = startTime.getTimeInMillis();
        message.setObject((Serializable)data);
        this.mClusterSupport.addResponder(Thread.currentThread(), guid);
        this.postMessage(message);
        Object result = this.waitForResponse(guid);
        if (result instanceof Long[]) {
            ArrayList<Long> results = new ArrayList<Long>();
            results.addAll(Arrays.asList((Long[])result));
            for (int i = results.size(); i < flowIDs.size(); ++i) {
                results.add(0L);
            }
            return results;
        }
        ArrayList<Long> results = new ArrayList<Long>();
        for (int i = 0; i < flowIDs.size(); ++i) {
            results.add(0L);
        }
        return results;
    }

    @Override
    public String getJobRoutingRulesXML(String sessionID) {
        return "";
    }

    @Override
    public boolean setJobRoutingRulesXML(String sessionID, String xml) {
        return false;
    }
}

