/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.servers.ip.engine;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.servers.ip.engine.ClientLogger;
import com.sas.scheduler.api.servers.ip.engine.ClusterSupport;
import com.sas.scheduler.api.servers.ip.engine.ExecutionCallback;
import com.sas.scheduler.api.servers.ip.engine.FilePersistence;
import com.sas.scheduler.api.servers.ip.engine.FlowHistory;
import com.sas.scheduler.api.servers.ip.engine.FlowInstance;
import com.sas.scheduler.api.servers.ip.engine.IPersistenceProvider;
import com.sas.scheduler.api.servers.ip.engine.InProcessExecutionProviderBase;
import com.sas.scheduler.api.servers.ip.engine.Job;
import com.sas.scheduler.api.servers.ip.engine.RunHistory;
import com.sas.scheduler.api.servers.ip.engine.RunningJob;
import com.sas.scheduler.api.servers.ip.engine.SyncManager;
import com.sas.scheduler.api.servers.ip.engine.TopLevelFlow;
import com.sas.scheduler.api.servers.ip.engine.UserInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SimpleProcessProvider
extends InProcessExecutionProviderBase {
    protected Map<String, Thread> mRunningJobMap;
    protected IPersistenceProvider mPersistenceProvider;
    protected Map<String, String> mInMemoryHistoryHolder = new HashMap<String, String>();
    protected Map<String, Writer> mInMemoryHistoryWriters = new HashMap<String, Writer>();
    protected long mNextFlowID = System.currentTimeMillis();
    protected static final String HistoryRoot = "history";
    protected static final String InstanceFile = "instances.dat";
    protected static final String UsedTimesFile = "usedTriggerTimes.dat";
    protected int mNumberOfWorkerThreads = 10;
    public static final String ESC_PREFIX = "(";
    public static final String ESC_SUFFIX = ")";

    public SimpleProcessProvider(ClientLogger logger, File persistenceRoot, int numberOfWorkerThreads) {
        super(logger, null);
        this.mRunningJobMap = new HashMap<String, Thread>();
        if (persistenceRoot != null) {
            this.mPersistenceProvider = new FilePersistence(persistenceRoot, logger);
        }
        this.mNumberOfWorkerThreads = numberOfWorkerThreads;
    }

    public SimpleProcessProvider(ClientLogger logger, File persistenceRoot, int numberOfWorkerThreads, ClusterSupport cluster) {
        super(logger, cluster);
        this.mRunningJobMap = new HashMap<String, Thread>();
        if (persistenceRoot != null) {
            this.mPersistenceProvider = new FilePersistence(persistenceRoot, logger);
        }
        this.mNumberOfWorkerThreads = numberOfWorkerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeJob(final Job j, final ExecutionCallback callback, UserInfo userInfo) {
        Thread worker = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process p = null;
                try {
                    p = Runtime.getRuntime().exec(j.getCommand());
                    int exitValue = p.waitFor();
                    if (exitValue == 0) {
                        callback.markDone();
                    } else {
                        callback.markExited(exitValue);
                    }
                }
                catch (IOException e) {
                    callback.markFailedToRun();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (p != null) {
                        p.destroy();
                    }
                    callback.markKilled();
                }
                finally {
                    Map<String, Thread> e = SimpleProcessProvider.this.mRunningJobMap;
                    synchronized (e) {
                        SimpleProcessProvider.this.mRunningJobMap.remove(callback.getRendevousID());
                    }
                }
            }
        });
        Map<String, Thread> map = this.mRunningJobMap;
        synchronized (map) {
            this.mRunningJobMap.put(callback.getRendevousID(), worker);
        }
        worker.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killJob(String rendevousID) {
        Map<String, Thread> map = this.mRunningJobMap;
        synchronized (map) {
            Thread t = this.mRunningJobMap.get(rendevousID);
            if (t != null) {
                t.interrupt();
            }
        }
    }

    @Override
    public String getNewFlowID(TopLevelFlow flow) {
        return "F" + Long.toString(this.mNextFlowID++);
    }

    @Override
    protected boolean isUserIDAdministrator(String canonicalUserID) {
        return true;
    }

    @Override
    @Deprecated
    protected boolean validateUser(String userID, String password) {
        return this.validateUserSealedString(userID, password != null ? new SealedString(password) : null);
    }

    @Override
    protected boolean validateUserSealedString(String userID, SealedString password) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Reader getFlowHistoryReader(TopLevelFlow flow) {
        if (this.mPersistenceProvider == null) {
            Map<String, String> map = this.mInMemoryHistoryHolder;
            synchronized (map) {
                String history = this.mInMemoryHistoryHolder.get(flow.getID());
                if (history == null) {
                    history = "";
                    this.mInMemoryHistoryHolder.put(flow.getID(), history);
                }
                return new StringReader(history);
            }
        }
        return this.mPersistenceProvider.getReader(HistoryRoot, SimpleProcessProvider.escapeFileSegment(flow.getID()));
    }

    @Override
    protected Writer getFlowHistoryWriter(TopLevelFlow flow) {
        if (this.mPersistenceProvider == null) {
            StringWriter writer = new StringWriter();
            this.mInMemoryHistoryWriters.put(flow.getID(), writer);
            return writer;
        }
        return this.mPersistenceProvider.getWriter(HistoryRoot, SimpleProcessProvider.escapeFileSegment(flow.getID()), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteFlowHistoryStore(TopLevelFlow flow) {
        if (this.mPersistenceProvider == null) {
            this.mInMemoryHistoryWriters.remove(flow.getID());
            this.mInMemoryHistoryHolder.remove(flow.getID());
            return;
        }
        Object sync = SyncManager.getInstance().getSyncObject(flow.getID());
        try {
            Object object = sync;
            synchronized (object) {
                this.mPersistenceProvider.delete(HistoryRoot, SimpleProcessProvider.escapeFileSegment(flow.getID()));
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject(flow.getID());
        }
    }

    @Override
    protected Reader getRunningFlowInstanceReader() {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getReader("", InstanceFile);
    }

    @Override
    protected Writer getRunningFlowInstanceWriter(boolean append) {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getWriter("", InstanceFile, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAcceptJob(RunningJob rj) {
        Map<String, Thread> map = this.mRunningJobMap;
        synchronized (map) {
            if (this.mNumberOfWorkerThreads > 0 && this.mRunningJobMap.size() >= this.mNumberOfWorkerThreads) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFlowHistoryItem(TopLevelFlow flow, FlowHistory history) {
        block9: {
            if (this.mPersistenceProvider != null) {
                Object sync = SyncManager.getInstance().getSyncObject(flow.getID());
                try {
                    Object object = sync;
                    synchronized (object) {
                        super.addFlowHistoryItem(flow, history);
                        break block9;
                    }
                }
                finally {
                    SyncManager.getInstance().releaseSyncObject(flow.getID());
                }
            }
            Writer writer = this.mInMemoryHistoryWriters.remove(flow.getID());
            if (writer != null) {
                String currentData = this.mInMemoryHistoryHolder.get(flow.getID());
                if (currentData == null) {
                    currentData = "";
                }
                currentData = currentData + writer.toString();
                this.mInMemoryHistoryHolder.put(flow.getID(), currentData);
            }
        }
    }

    @Override
    public List<FlowHistory> getFlowHistory(Map<TopLevelFlow, Integer> historyRequestMap, UserInfo userInfo) {
        if (this.mPersistenceProvider != null) {
            return super.getFlowHistory(historyRequestMap, userInfo);
        }
        return new ArrayList<FlowHistory>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeFlowHistoryRecords(TopLevelFlow flow) {
        if (this.mPersistenceProvider != null) {
            Object sync = SyncManager.getInstance().getSyncObject(flow.getID());
            try {
                Object object = sync;
                synchronized (object) {
                    super.removeFlowHistoryRecords(flow);
                }
            }
            finally {
                SyncManager.getInstance().releaseSyncObject(flow.getID());
            }
        }
    }

    public int getNumberOfWorkerThreads() {
        return this.mNumberOfWorkerThreads;
    }

    public void setNumberOfWorkerThreads(int numberOfWorkerThreads) {
        this.mNumberOfWorkerThreads = numberOfWorkerThreads;
    }

    @Override
    protected Reader getUsedTimesReader() {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getReader("", UsedTimesFile);
    }

    @Override
    protected Writer getUsedTimesWriter(boolean append) {
        if (this.mPersistenceProvider == null) {
            return null;
        }
        return this.mPersistenceProvider.getWriter("", UsedTimesFile, append);
    }

    protected static boolean isLegalFileCharacter(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '-';
    }

    public static String escapeFileSegment(String segment) {
        boolean good = true;
        for (int i = 0; i < segment.length(); ++i) {
            char ch = segment.charAt(i);
            if (SimpleProcessProvider.isLegalFileCharacter(ch)) continue;
            good = false;
            break;
        }
        if (good) {
            return segment;
        }
        StringBuffer buffer = new StringBuffer(segment.length() + 10);
        for (int i = 0; i < segment.length(); ++i) {
            char ch = segment.charAt(i);
            if (!SimpleProcessProvider.isLegalFileCharacter(ch)) {
                buffer.append(ESC_PREFIX);
                buffer.append(Integer.toString(ch));
                buffer.append(ESC_SUFFIX);
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    @Override
    protected void removeDeadFlowPersistence(Set<String> validFlowIDs) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        try {
            FilenameFilter emptyFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return true;
                }
            };
            HashSet<String> fixedFlowIDs = new HashSet<String>();
            for (String id : validFlowIDs) {
                fixedFlowIDs.add(SimpleProcessProvider.escapeFileSegment(id));
            }
            validFlowIDs = fixedFlowIDs;
            String[] topDirs = new String[]{"STDOUT", "STDERR"};
            for (int i = 0; i < topDirs.length; ++i) {
                List<String> flowHistoryDirs = this.mPersistenceProvider.listFiles(topDirs[i], "", emptyFilter);
                for (String dirName : flowHistoryDirs) {
                    if (validFlowIDs.contains(dirName)) continue;
                    this.mPersistenceProvider.deleteDir(topDirs[i], dirName);
                }
            }
        }
        catch (Exception e) {
            this.mLogger.logMessage(Level.WARNING, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateUsedTimes(Map<String, Map<String, Long>> usedTimes) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        Object o = SyncManager.getInstance().getSyncObject("UsedTimesFile");
        try {
            Object object = o;
            synchronized (object) {
                long startTime = System.currentTimeMillis();
                this.mLogger.logMessage(Level.INFO, "Saving used time data (Start)");
                Writer writer = this.getUsedTimesWriter(false);
                if (writer != null) {
                    BufferedWriter bw = new BufferedWriter(writer);
                    try {
                        for (String flowID : usedTimes.keySet()) {
                            Map<String, Long> itemMap = usedTimes.get(flowID);
                            bw.write(this.writeUsedTimesRecord(flowID, itemMap));
                            bw.newLine();
                        }
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                    this.mLogger.logMessage(Level.INFO, "Saving used time data (End) Time elapsed: " + (System.currentTimeMillis() - startTime) + "ms");
                } else {
                    this.mLogger.logMessage(Level.INFO, "Saving used time data (End).  Failed because writer couldn't be acquired.");
                }
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject("UsedTimesFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRunningFlowInstances(Collection<FlowInstance> flowInstances) {
        if (this.mPersistenceProvider == null) {
            return;
        }
        Object o = SyncManager.getInstance().getSyncObject("InstanceDataFile");
        try {
            Object object = o;
            synchronized (object) {
                Writer writer = this.getRunningFlowInstanceWriter(false);
                if (writer != null) {
                    BufferedWriter bw = new BufferedWriter(writer);
                    try {
                        for (FlowInstance flowInstance : flowInstances) {
                            try {
                                String instanceData = FlowInstance.getEscapedData(flowInstance.toSerializedForm());
                                bw.write(RunHistory.getEscapedString(flowInstance.getFlowHistory().getID()) + RunHistory.HistorySeparator + instanceData);
                                bw.newLine();
                            }
                            catch (Exception e) {
                                this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                    }
                    finally {
                        try {
                            bw.close();
                        }
                        catch (IOException e) {
                            this.getFlowManager().getLogger().logMessage(Level.WARNING, e);
                        }
                    }
                }
            }
        }
        finally {
            SyncManager.getInstance().releaseSyncObject("InstanceDataFile");
        }
    }

    @Override
    public boolean isMaster() {
        if (!this.isClusteringServer()) {
            return super.isMaster();
        }
        if (this.mPersistenceProvider == null) {
            return this.mClusterSupport.isMasterServer();
        }
        if (!this.mPersistenceProvider.hasLock()) {
            if (this.mClusterSupport.isMasterServer()) {
                this.assumeMastership();
            }
        } else if (!this.mClusterSupport.isMasterServer()) {
            this.loseMastership();
        }
        return this.mClusterSupport.isMasterServer() && this.mPersistenceProvider.hasLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loseMastership() {
        if (this.mPersistenceProvider != null) {
            IPersistenceProvider iPersistenceProvider = this.mPersistenceProvider;
            synchronized (iPersistenceProvider) {
                this.mPersistenceProvider.releaseLock();
            }
        }
        super.loseMastership();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assumeMastership() {
        this.mNextFlowID = System.currentTimeMillis();
        if (this.mPersistenceProvider != null) {
            IPersistenceProvider iPersistenceProvider = this.mPersistenceProvider;
            synchronized (iPersistenceProvider) {
                if (!this.mPersistenceProvider.hasLock()) {
                    this.mPersistenceProvider.acquireLock();
                }
            }
        }
        super.assumeMastership();
    }

    @Override
    public boolean isFullPersistenceRequired() {
        if (this.mPersistenceProvider == null) {
            return false;
        }
        return !this.mPersistenceProvider.isAppendSupported();
    }
}

